package ## no critic: Modules::RequireFilenameMatchesPackage
    # hide from PAUSE
    TableDataRole::Business::ID::KAN::Client::Lab::Testing;

use 5.010001;
use strict;
use warnings;

use Role::Tiny;
with 'TableDataRole::Source::AOA';

# BEGIN FRAGMENT id=meta-idn_kan_client_lab_testing varname=meta
# note: This fragment's content is generated by a script. Do not edit manually!
# src-file: /home/u1/repos/gudangdata/bin/../table/idn_kan_client_lab_testing/meta.yaml
# src-revision: 3b3cd2b857df32333b0aa6c71768f3bb60da0e22 (Sat Sep 23 07:23:26 2023 +0700)
# generate-date: Sat Sep 23 00:25:53 2023 UTC
# generated-by: update-fragments-in-perl-module
our $meta = {
  _note => "Automatically generated by gen-meta-yaml-from-data-tsv on Sat Sep 23 00:08:51 2023 UTC",
  fields => {
    accreditation_number => {
      pos      => 0,
      schema   => "str*",
      sortable => 1,
      summary  => "accreditation_number",
      unique   => 1,
    },
    address => { pos => 3, schema => "str*", sortable => 1, summary => "address", unique => 0 },
    expiry_date => {
      pos      => 6,
      schema   => "str*",
      sortable => 1,
      summary  => "expiry_date",
      unique   => 0,
    },
    is_active => { pos => 1, schema => "str*", sortable => 1, summary => "is_active", unique => 0 },
    lab_name => { pos => 2, schema => "str*", sortable => 1, summary => "lab_name", unique => 0 },
    note => { pos => 7, schema => "str*", sortable => 1, summary => "note", unique => 0 },
    phone => { pos => 4, schema => "str*", sortable => 1, summary => "phone", unique => 0 },
    scope => { pos => 5, schema => "str*", sortable => 1, summary => "scope", unique => 0 },
  },
  header => 1,
  pk => "accreditation_number",
  summary => "(Summary here)",
};
# END FRAGMENT id=meta-idn_kan_client_lab_testing

# BEGIN FRAGMENT id=data-idn_kan_client_lab_testing varname=data
# note: This fragment's content is generated by a script. Do not edit manually!
# src-file: /home/u1/repos/gudangdata/bin/../table/idn_kan_client_lab_testing/data.csv
# src-revision: 3b3cd2b857df32333b0aa6c71768f3bb60da0e22 (Sat Sep 23 07:23:26 2023 +0700)
# generate-date: Sat Sep 23 00:25:53 2023 UTC
# generated-by: update-fragments-in-perl-module
our $data = [
  [
    "LP-001-IDN",
    "Yes",
    "PT. Mutuagung Lestari",
    "Jl. Raya Bogor Km. 33,5 No. 19 Cimanggis, Depok, Jawa Barat",
    "(021) 8740202",
    "Beras, Produk perikanan (Shrimp, Cat Fish, Milk Fish, Tilapia Mollusca), Pangan Segar Asal Tumbuhan, Buah (buah segar), Sayur, rumput laut, kacang dan bijian-bijian (sayur, rumput laut, kacang dan bijian-bijian segar), Kacang-Kacangan, lada, Kopi Roasted, Serealia &amp; Produk Serealia, Biskuit, Daging dan produk daging, Crde Palm Oil (CPO) dan turunannya, Pupuk Urea, Pupuk Triple Super Fosfat, Pupuk Fosfat Alam untuk Pertanian (Rock Phosphate), Pupuk NPK Padat, Pupuk Dolomit, Pupuk Kalium Klorida (KCl), Pupuk Urea Ammonium Phosphat (UAP), Pupuk Guano, Pupuk Ammonium Sulfat, Pupuk Ammonium Klorida, Pupuk Kalsium Nitrat (CaNO\x{2083}), Pupuk Kalium Nitrat (KNO\x{2083}), Pupuk Mono Ammonium Phosphate (MAP), Pupuk SP 36, Pupuk Kalium Sulfat , Pupuk Kieserit, Pupuk Kaptan, Pupuk CuSO\x{2084}, Pupuk ZnSO\x{2084}, Pupuk Organik , Jaringan Tanaman, Tanah, Produk - produk susu dan analognya, Telur dan produk telur, Daging dan produk daging termasuk daging unggas dan daging hewan buruan, Buah dan sayur, rumput laut, biji-bijian (buah segar, buah olahan, sayur, kacang dan biji-bijian segar, sayur, rumput laut, kacang dan biji-bijian olahan), Serealia &amp; produk serealia yang merupakan produk turunan dari biji serelia, akar, &amp; umbi, kacang-kacangan &amp; empulur tidak termasuk produk bakeri dari kategori 07 &amp; kacang dari kategori 04, Ikan dan produk perikanan termasuk molusca, krustasea, dan ekinodermata serta amfibi dan reptil, Minuman tidak termasuk produk susu, Kayu Lapis (Plywood), Veneer Lamina (Laminated Veneer Lumber), Kayu Laminasi (Glued Laminated Timber), Lantai Kayu (Flooring), Papan Partikel (Particle Board), Papan Serat (Fiber Board), Produk kayu, Panel Kayu, Papan Serat (Fiber Board) &amp; Papan Partikel (Particle Board), Panel Kayu, Air untuk keperluan hygiene dan sanitasi, Air Minum, Air Mineral , Air sumur, air danau, air sungai, air muara, air rawa, air rawa besar, air situ, air mata air, air waduk, Air limbah , Air Limbah dari Industri Minyak Sawit, Air laut, Udara ambien, Getaran, Kebisingan, Kebauan, Lingkungan kerja, Emisi sumber tidak bergerak",
    "24/04/2026",
    "",
  ],
  [
    "LP-005-IDN",
    "Yes",
    "PT PLN (Persero) Pusat Sertifikasi - LMK Lab",
    "Jl. Duren Tiga No. 102, Kalibata, Jakarta Selatan",
    "(021) 7940428",
    "Vibrasi, minyak insulasi pakai dan baru, Batubara, Tube, KWh meter, pemutus tenaga mini (MCB), kabel berinsulasi PVC dengan tegangan pengenal 450/750 V bag.3: kabel tanpa selubung untuk pemasangan tetap (magun), kabel berinsulasi PVC dengan tegangan pengenal 450/750 V bag.4: kabel berselubung untuk pemasangan tetap (magun),",
    "23/04/2024",
    "",
  ],
  [
    "LP-007-IDN",
    "Yes",
    "Balai Besar Standardisasi dan Pelayanan Jasa Industri Bahan dan Barang Teknik",
    "Jl. Sangkuriang No. 14, Bandung, Jawa Barat 40135",
    "(022) 2504088, 2510682, 2504828",
    "",
    "28/08/2027",
    "",
  ],
  [
    "LP-010-IDN",
    "Yes",
    "Balai Besar Pengujian Minyak dan Gas Bumi LEMIGAS \x{2013} Laboratorium Proses",
    "Jl. Ciledug Raya, Cipulir, Kebayoran Lama Jakarta Selatan, DKI Jakarta",
    "(021) 74394422",
    "Aviation Gasoline, Bensin (Gasoline), Kerosin, Solar (Diesel Fuel), Biosolar, Minyak Bakar, Minyak Lumas, Minyak Bumi, Air Buangan/Air Formasi/Air Produksi, Lumpur Pemboran, Sedimen, Tanah, Surfaktan/Dispersan, Air Minum, Larutan Kimia, Biodiesel B-100, Bioetanol, Aviation Turbine Fuel (AVTUR)",
    "02/07/2026",
    "",
  ],
  [
    "LP-011-IDN",
    "Yes",
    "Laboratorium Unit Pengelola Penilaian Kesesuaian Bahan dan Barang Teknik",
    "Jl. Letjen Suprapto Kav 3, Cempaka Putih, Jakarta Pusat",
    "(021) 4209179",
    "baja tulangan, jaringan kawat baja las untuk tulangan beton dari kawat baja, baja lembaran lapis seng, pipa baja saluran air dengan atau tanpa lapisan seng, pipa baja konstruksi umum, material logam, baja batangan untuk keperluan umum (BjKU), baja lembaran, pelat dan gulungan canai panas (BjP), baja lembaran dan gulungan canai dingin (BjD), baja lembaran dan gulungan lapis paduan aluminium-seng (BjLAS), baja profil WF-beam proses canai panas (BjPWF-beam), baja profil kanal U canai panas (BjP kanal U), baja profil I-beam proses canai panas (BJ P I-beam), baja profil siku sama kaki proses canai panas (Bj siku sama kaki), baja profil H (Bj PH-beam), kawat baja kuens (quench) temper untuk konstruksi beton pratekan (PC-Bar/KBjP-Q), tujuh kawat baja tanpa lapisan dipilin untuk konstruksi beton pratekan (PC strand/KBjP-P7), kawat baja tanpa lapisan konstruksi beton pra tekan (PC Wire/KBjP), kawat baja tanpa lapisan untuk konstruksi beton, penyambung pipa berulir besi cor malleable hitam, berojong kawat, kawat brojong dan brojong berlapis PVC, kawat baja karbon rendah, batang kawat baja karbon rendah, billet baja tuang kontinyu untuk baja tulangan beton dan baja profit ringan, silinder beton, lembaran semen rata, lembaran semen gelombang simetris, genteng beton, genteng keramik berglazur, bata beton (paving block), kloset duduk, keramik berglasir-tableware-alat makan dan minum, ubin keramik, pipa PVC untuk saluran air minum, pipa PVC untuk saluran air buangan didalam dan diluar bangunan, sambungan pipa PVC untuk saluran air minum, system perpipaan plastik \x{2013} pipa polietilena (PE) dan fitting untuk system penyediaan air minum \x{2013} bagian 1: umum, system perpipaan plastik \x{2013} pipa polietilena (PE) dan fitting untuk system penyediaan air minum \x{2013} bagian 2 pipa, cat tembok emulsi, sistem perpipaan plastik untuk penyaluran bahan bakar gas \x{2013} polietilena (PE) \x{2013} bagian 2: pipa, sistem perpipaan plastik untuk instalasi air panas dan dingin \x{2013} polipropilena (PP) \x{2013} bagian 2: pipa, profil rangka baja ringan, pipa baja untuk pancang, Sistem perpipaan plastik Pipa Polietilena (PE) dan Fiting untuk sistem penyediaan air minum Bagian 3: Fiting, Blok Beton Ringan Bergelembung Udara (Aerated) dengan proses Otoklaf, Beton aerasi autoklaf, Bata ringan untuk pasangan dinding, Papan semen rata non asbestos, Lembaran Rata Kalsium Silikat, Baja lembaran, pelat, dan gulungan canai panas untuk",
    "01/09/2024",
    "",
  ],
  [
    "LP-012-IDN",
    "Yes",
    "UPTD Balai Pengujian dan Sertifikasi Mutu Barang Provinsi Sumatera Barat",
    "Jl. Belibis No. 3, Air Tawar, Padang, Sumatera Barat",
    "(0751) 7054202",
    "Minyak pala, cassia Indonesia, karet SIR, biji kopi",
    "19/03/2024",
    "",
  ],
  [
    "LP-013-IDN",
    "Yes",
    "PT. Mutuagung Lestari Samarinda",
    "Jl. Teuku Umar No. 18, Sungai Kunjang, Samarinda, Kalimantan Timur",
    "(0541) 272600",
    "kayu lapis struktural/structural plywood, kayu lapis penggunaan umum/general use), Venir lamina (Laminated Veneer Lumber/LVL)",
    "19/03/2024",
    "",
  ],
  [
    "LP-014-IDN",
    "Yes",
    "Balai Pengujian dan Sertifikasi Mutu Barang Provinsi Kalimantan Selatan",
    "Jl. Panglima Batur Banjarbaru, Kalimantan Selatan",
    "(0511) 4772237",
    "Karet spesifikasi teknis/Standard Indonesia Rubber (SIR), karet konvensional, plastik, beras",
    "23/08/2025",
    "",
  ],
  [
    "LP-018-IDN",
    "Yes",
    "Pusat Produksi, Inspeksi &amp; Sertifikasi Hasil Perikanan Provinsi DKI Jakarta",
    "Lokasi 1: Jl. Pluit Permai No. 1, Pluit - Penjaringan - Jakarta Utara Lokasi 2: Jl. R.M Kahfi I No. 1, Kel. Cipedak, Kec. Jagakarsa - Jakarta Selatan",
    "(021) 78885839/6684224",
    "udang, lobster, paha kodok, ikan, ubur-ubur, Tepung ikan, kepiting, rajungan, Kekerangan, Kerupuk produk perikanan, ikan kering/asin,Rumput laut, Tuna dalam kemasan kaleng, sarden dan makerel dalam kemasan kaleng, Bakso Ikan, Siomay Ikan, otak-otak ikan, kaki naga ikan, sosis ikan, Pempek ikan, naget ikan, Ikan pindang, Produk perikanan lainnya, Air minum, Marlin, tuna, tengiri, tongkol, cakalang, layang, Ikan segar, produk ikan kering (teri nasi kering, ebi, ikan asin), Produk olahan Ikan beku, Produk Udang Beku, Produk Perikanan Beku, Ikan Budidaya (nila &amp; lele), Air kolam ikan, Ikan air laut segar, Ikan beku, Produk ikan kering",
    "15/02/2026",
    "",
  ],
  [
    "LP-021-IDN",
    "Yes",
    "Balai Besar Standardisasi dan Pelayanan Jasa Industri Logam dan Mesin",
    "Jl. Sangkuriang No. 12, Bandung, Jawa Barat",
    "(022) 2503171",
    "Logam dan Paduannya, Produk Logam (Baja), Produk Logam / Produk Pengelasan , Baja tulangan Beton, Baja Tulangan Beton Hasil Canai Panas Ulang, Baja Siku Sama Kaki Bertepi Bulat Canai Panas hasil Reroling, Mutu dan cara uji, Keran Air Rumah Tangga Jenis Katup Pintu, Tabung Baja LPG, Regulator Tekanan Rendah untuk Tabung Baja LPG, Regulator Tekanan Tinggi untuk tabung baja LPG , Katup Tabung Baja LPG, Katup Tabung LPG, katup tabung LPG tipe koneksi ulir, Baja Tulangan Beton dalam bentuk Gulungan, Sepeda, Garpu Tarik (Cangkrang), Belincong, Garpu Tanah, Gergaji Kayu Tangan, Parang, Sekop, Cangkul, Linggis, Kored, Sabit / Arit, Sabit Bergerigi, Kampak, Baja Karbon dan Paduan Rendah, Besi Cor, Baja Tahan Karat, Paduan Nikel(Ni hard), Baja Karbon, Baja Tahan Karat, Paduan Tinggi, Carbon &amp; Low Alloy Steel, Cr-Ni Steel ( Stainless Steel ), Low Alloy Cast Iron, Aluminium Alloys, Universal Copper , Brasses ( Kuningan ), Silicon Bronzes, Baja Profil Siku Sama Kaki Proses Canai Panas (Bj P Siku Sama Kaki), Batang Kawat Baja Karbon Rendah, Selang Karet untuk Kompor Gas LPG, Selang Termoplastik untuk kompor gas LPG, Kompor Gas Bahan Bakar LPG satu tungku dengan sistem pemantik, Kompor Gas Tekanan Rendah Jenis Dua dan Tiga Tungku Dengan Sistem Pemantik, Baja Lembaran Lapis Seng, Baja Profil H (Bj P H-Beam), Baja Profil Kanal U Proses Canai panas (Bj-P Kanal U), Bj-P I Beam, Baja Profil WF - Beam proses canai panas, Baja Beton Pratekan Bag.3: Kawat (Quench and Temper), Kawat baja quens (quench) temper untuk konstruksi beton pratekan (PC bar /KBjP-Q), Kawat Baja Tanpa Lapisan Untuk Beton pratekan (PC wire/KBjP), Tujuh Kawat Baja Tanpa Lapisan dipilin untuk Konstruksi Beton Pratekan(PC strand / KBjP-P7), Penyambung Pipa Berulir Cor Maleable Hitam, Baja Lembaran , pelat dan gulungan canai panas (Bj P), Meter Air Minum, Baja Lembaran dan gulungan canai dingin (Bj D), Baja lembaran dan gulungan lapis paduan aluminium seng (Bj.L AS), Pipa baja saluran air dengan atau tanpa lapis seng, Sepatu Rem Besi Cor Kelabu untuk Kereta Api, Paku Baja, Katup pintu kuningan berulir 1,0 Mpa dan 1,5 Mpa ( 10 kgf/cm2 dan 15 kgf/cm2), Katup pintu kuningan berulir 125, 150, dan 200 untuk air, minyak, dan gas",
    "05/10/2026",
    "",
  ],
  [
    "LP-022-IDN",
    "Yes",
    "Balai Besar Standardisasi dan Pelayanan Jasa Industri Kulit, Karet dan Plastik",
    "Jl. Sokonandi No. 9, Yogyakarta",
    "(0274) 512929; 563655",
    "Kulit, Karet, Ban dalam kendaraan bermotor, Ban mobil penumpang, Ban sepeda motor, Ban truk dan bus, Ban truk ringan, Rol karet pengupas gabah, Sol karet cetak, Karet Bantalan Dermaga, Sepatu pengaman, Karung tenun polipropilena (PP) untuk bahan pangan curah, Sepatu bot PVC, Sepatu bot PU, Sepatu Kulit Sistem Lem (Bagian 1: Wanita), Sepatu Kulit sistem Lem (Bagian 2 : Pria), Air Hyginie sanitasi, Air Sungai, Air sumur dan air danau, Air limbah, SIR, RSS",
    "20/09/2025",
    "",
  ],
  [
    "LP-023-IDN",
    "Yes",
    "Unit Pengelola Pengujian dan Inspeksi, Sertifikasi Produk Perindustrian, Perdagangan, Koperasi Usaha Kecil dan Menengah DKI Jakarta",
    "Jl. Let. Jend Soeprapto, Kav. 3, Cempaka Putih, Jakarta Pusat, DKI Jakarta",
    "(021) 4244835",
    "Benang, kain, tekstil dan produk tekstil, kulit, sepatu wanita, sepatu pria, kulit imitasi, sol luar (karet), karton kulit (leather board), sepatu olahraga, Alat Pelindung Diri - Sepatu Pengaman (Bahan Kulit)",
    "22/08/2026",
    "",
  ],
  [
    "LP-024-IDN",
    "Yes",
    "PT Sucofindo (Persero) SBU Laboratory",
    "Jl. Arteri Tol Cibitung No. 1, Cikarang Barat, Kab. Bekasi, Jawa Barat",
    "(021) 88321176",
    "General :",
    "24/09/2024",
    "",
  ],
  [
    "LP-025-IDN",
    "Yes",
    "Balai Pengujian Mutu Barang Jakarta",
    "Jl. Raya Bogor Km. 26, Ciracas \x{2013} Jakarta 13740",
    "(021) 87721002; 8703881",
    "",
    "30/09/2024",
    "",
  ],
  [
    "LP-028-IDN",
    "Yes",
    "PT Sucofindo - Laboratorium Cabang Surabaya",
    "Jl. Jend. Ahmad Yani No. 315, Surabaya",
    "(031) 8470547",
    "Gaplek, Biji Kopi, Biji Kakao, Pupuk Triple Super Fosfat (TSP), Pupuk Ammonium Sulfat, Pupuk Ammonium Klorida, Pupuk NPK Padat, Pupuk Dolomit, Pupuk Kalium Klorida, Pupuk Mono Fosfat Diamonium Phosphat (DAP), Pupuk SP-36, Pupuk Fosfat Alam untuk Pertanian, Pupuk sisa proses Asam amino (Haspramin), Pupuk Borat, Pupuk Urea, Aluminium Sulfat padat, Aluminium Sulfat cair, Asam Sulfat Teknis, Gula Kristal Mentah (raw sugar), Gula Kristal Putih, Gula Kristal Rafinasi, Bahan Pangan dan Pakan ( Virgin Oil, Minyak Goreng, Mentega, Margarin, Produk Kakao dan Cokelat), Cemaran Mikroba dalam daging, telur, susu serta hasil olahannya (susu pasteurisasi, daging sapi giling segar, daging olahan, telur segar dan telur asin), Air Minum Dalam Kemasan, Kopi Instan, Mie Instant, Minyak Goreng Sawit, Minyak makan dan turunannya, Air Mineral, Air Mineral Alami, Air Demineral, Air Permukaan dan, Air Sungai, Air Limbah, Air Untuk Keperluan Higiene Sanitasi, Air Minum, Limbah Padat dan Semi Padat, Udara Emisi Sumber Tidak Bergerak , Udara Ambien, Udara Lingkungan Kerja / Industrial Hygiene, Batu Kapur (Lime stone), Bijih besi &amp; pasir besi, Bijih Mangan (Manganese ore), Batubara, Timah, Cu Cathode, Lead, Zircon Sand, Makanan &amp; Minuman (Kue kering, keripik, jus buah, jamu, teh, es krim) (Nutrition Fact), Garam Konsumsi Beriodium, Solar 48, Bio Solar (B20), Pupuk (Anorganik dan Organik), Biskuit, Bahan Pangan dan Pakan (biskuit, produk kakao dan coklat, fishmeal), Palm Kernel, CPO, Beras, Lubricating oils, Solar/Biosolar, Marine Fuel Oil (MFO), Air RO/Hemodialisa,",
    "20/09/2025",
    "",
  ],
  [
    "LP-029-IDN",
    "Yes",
    "Pusat Penelitian Karet Unit Riset Bogor Getas \x{2013} PT Riset Perkebunan Nusantara",
    "Jl. Salak No. 1, Bogor 16151",
    "(0251) 8319817",
    "Lateks alam, vulkanisat/kompon, selang karet untuk kompor gas LPG, ban mobil penumpang, ban truk ringan, ban truk dan bus, ban sepeda motor, rol karet pengupas gabah, vulkanisat karet pompa air tangan, karet mentah, karet pegangan selang (grip handle) sepeda motor, lis karet pintu lemari es, karet perapat (rubber seal) pada katup tabung LPG, spesifikasi bantalan elastomer tipe polos dan tiper berlapis untuk perletakan jembatan, karet spesifikasi teknis, ban dalam kendaraan bermotor, selang termoplastik elastomer untuk kompor gas, ban dalam sepeda, vulkanist karet kompon bantalan dermaga, sarung tangan karet steril untuk keperluan bedah sekali pakai, sarung tangan untuk pemeriksaan medis sekali pakai - bagian 1: spesifikasi untuk sarung tangan terbuat dari lateks atau larutan karet, ban vulkanisir (ban truk ringan)",
    "15/10/2024",
    "",
  ],
  [
    "LP-030-IDN",
    "Yes",
    "UPT Pengujian dan Sertifikasi Mutu Barang Provinsi Kalimantan Barat",
    "Jl. Abdurrachman Saleh No.31, Pontianak, Kalimantan Barat",
    "(0561) 762849",
    "Karet alam - Standard Indonesian Rubber (SIR), plastik pembungkus bandela, Crude Palm Oil (CPO), garam konsumsi beryodium, BOKAR, lada putih, lada hitam, inti kelapa sawit (palm kernel), minyak kelapa mentah, minyak goreng sawit, minyak goreng",
    "24/10/2026",
    "",
  ],
  [
    "LP-031-IDN",
    "Yes",
    "UPT Pengujian dan Sertifikasi Mutu Barang, Dinas Perdagangan, Koperasi, Usaha Kecil dan Menengah Provinsi Riau",
    "Jl. Dr. Sutomo No. 108, Pekanbaru",
    "(0761) 21325",
    "Air minum, air untuk keperluan sanitasi hygiene, air mineral/demineral, daging telur dan susu serta hasil olahannya, minyak kelapa mentah, minyak kelapa sawit mentah (Crude Palm Oil), tepung terigu sebagai bahan makanan, gula kristal putih, makanan (bakso, bubur ayam, nuget, brownis, kue kering), karet alam (SIR), pupuk NPK, pupuk Kalium Klorida (KCl), pupuk fosfat alam, limbah cair",
    "16/02/2025",
    "",
  ],
  [
    "LP-032-IDN",
    "Yes",
    "UPTD Balai Pengujian dan Sertifikasi Mutu Barang Dinas Perindustrian dan Perdagangan Provinsi Jambi",
    "Jl. Letjen Suprapto No. 29, Telanaipura, Jambi",
    "(0741) 60822",
    "SIR, biji pinang bukan obat, biji kopi, cassia Indonesia, Crude Palm Oil (CPO), garam konsumsi beryodium, pupuk NPK padat, pupuk KCl, pupuk TSP, air minum dalam kemasan (AMDK), minyak goreng, minyak goreng sawit, kopi bubuk, madu, Beras, Plastik Pembungkus Bandela",
    "22/08/2026",
    "",
  ],
  [
    "LP-035-IDN",
    "Yes",
    "UPT Pengujian Sertifikasi Mutu Barang - Lembaga Tembakau Jember",
    "Jl. Kalimantan No. 1 Jember, Jawa Timur",
    "(0331) 338396",
    "Benih Tembakau, Beras, Garam konsumsi beriodium, Kasturi, Komoditas unik tembakau, Pupuk organik, Pupuk organik padat, Rajangan Maesan, Rajangan Paiton, Rokok, Tembakau, Tembakau bawah naungan (TBN), Tembakau BES VO Ekspor, Tembakau Boyolali Asepan, Tembakau Cerutu Besuki Bagian I : Bahan olahan, Tembakau Cerutu Besuki Bagian I : Asalan, Tembakau Jawa Timur Voor Oogst, Tembakau Kedu, Tembakau krosok Madura VO, Tembakau Lumajang, Tembakau rajangan Madura, Tembakau rajangan virginia Bojonegoro, Tembakau Virginia FC, Tembakau Vorstenlanden, Sayuran dan buah berkadar air tinggi (Sayuran bunga (kubis), sayuran daun (sawi), sayuran polong (edamame), sayuran buah (cabai)), Phosphin",
    "27/07/2025",
    "",
  ],
  [
    "LP-036-IDN",
    "Yes",
    "UPT Pengujian dan Sertifikasi Mutu Barang - Lembaga Tembakau Surabaya",
    "Jl. Gayung Kebonsari Dalam No.12A Surabaya",
    "(031) 8280762",
    "Asam Sulfat Pekat Teknis, Beras, Biji Kakao, Biji Kopi, Biji Pala , Fuli, Gabah, Garam Bahan Baku untuk Industri Garam Beryodium, Garam Konsumsi Beryodium, Jagung, Karet Konvensional, Lada Putih, Minyak Goreng Sawit, Pupuk Amonium Sulfat, Pupuk Diamonium Fosfat, Pupuk Dolomit, Pupuk Fosfat Alam Untuk Pertanian, Pupuk Kalium Klorida, Pupuk Kalium Sulfat, Pupuk Monoamonium Fosfat (MAP), Pupuk NPK Padat, Pupuk SP-36, Pupuk Super Fosfat Tunggal, Pupuk Tripel Super Fosfat, Pupuk Urea, Pupuk Organik Padat, Tembakau Besuki NO, Tembakau Besuki Voor-Oogst Ekspor, Tembakau Boyolali Asepan, Tembakau Jawa Timur Voor Oogst, (Jatim VO), Tembakau Virginia FC, Tepung Terigu sebagai bahan makanan",
    "21/06/2025",
    "",
  ],
  [
    "LP-037-IDN",
    "Yes",
    "Balai Pengujian dan Sertifikasi Mutu Barang Surakarta",
    "Jl. Panjang \x{2013} Kartasura Km.8, Pabelan, Kartasura, Sukoharjo, Jawa Tengah",
    "(0271) 743959 ; 7881926",
    "Minyak Daun Cengkeh, Teh Hitam, Biji Kopi, Teh Hijau, Tembakau Rajangan Boyolali, Tembakau Rajangan Temanggung, Tembakau Rajangan Weleri, Tembakau Rajangan Muntilan, Tembakau Rajangan Mranggen, Tembakau Boyolali Asepan, Tembakau Vorstenlanden, Tembakau Kedu, Gabah, Jagung, Beras, Air Minum Dalam Kemasan (air mineral, air demineral, air embun), Daging, telur dan susu serta hasil olahannya, Kopi Bubuk, Kopi Instan, Jamu (Kapsul, Cair, Pil, Serbuk), Pupuk Organik",
    "13/06/2026",
    "",
  ],
  [
    "LP-043-IDN",
    "Yes",
    "PT Sucofindo (Persero) Cabang Semarang",
    "Jl. Raya Kaligawe No. 8, Kel. Trimulyo, Kec. Genuk, Semarang, Jawa Tengah",
    "(024) 6590547, 3516616",
    "Air limbah, air minum, air untuk keperuan hygiene dan sanitasi, air sungai, air mineral, air laut, air hemodialisa, udara emeisi sumber tidak bergerak, udara ambien, pupuk NPK padat, pupuk fosfat alam untuk pertanian, pupuk kalium klorida, pupuk ammonium sulfat, pupuk SP-36, pupuk tripel super fosfat, pupuk kalium sulfat, pupuk organik",
    "01/12/2025",
    "",
  ],
  [
    "LP-044-IDN",
    "Yes",
    "Laboratorium Cabang Bandar Lampung, PT. Sucofindo (Persero)",
    "Jl. Gatot Subroto No. 161, Pecoh Raya, Bandar Lampung 35228",
    "(0721) 474660",
    "Batubara, crude palm oil, air limbah, air sungai, air danau",
    "18/12/2027",
    "",
  ],
  [
    "LP-045-IDN",
    "Yes",
    "PT. Freeport Indonesia",
    "Jl. Airport Mozes Kilangin No. 1, Timika, Papua",
    "(0901) 463076",
    "Air untuk keperluan higiene dan sanitasi, Air Sumur, Air Sungai, Air Danau, air laut dan air muara, Air Limbah, tailing, sedimen, jaringan tanaman dan hewan",
    "27/6/2027",
    "",
  ],
  [
    "LP-046-IDN",
    "Yes",
    "Balai Besar Standardisasi dan Pelayanan Jasa Industri Selulosa",
    "Jl. Raya Dayeuhkolot No. 132, Bandung, Jawa Barat",
    "(022) 5202980, 5202871",
    "Lembaran Pulp/ Pulp sheet, Kertas, Karton, Karton dupleks, Kertas pengganda tanpa karbon, Kertas komputer kontinu, Kertas karbon, Pita kertas berperekat, Pita kertas berperekat peka tekanan, Kertas sigaret, Buku tulis sekolah, Tisu, Kertas tisu toilet, Air limbah, Air Sungai, Emisi sumber tidak bergerak, Udara Ambient, Kebauan, Udara Lingkungan Kerja, Kebisingan, Air mineral dan demineral, garam konsumsi beriodium",
    "19/09/2026",
    "",
  ],
  [
    "LP-049-IDN",
    "Yes",
    "UPT Pengawasan dan Sertifikasi Benih Tanaman Pangan dan Hortikultura Provinsi Jawa Timur",
    "Jl. Gayung Kebonsari 175 A, Surabaya - Jawa Timur",
    "(031) 8292079",
    "Padi, jagung, kedelai, kacang tanah, kacang hijau, gandum, kacang panjang, sawi, buncis, labu, semangka, mentimun, bayam, terong, tomat, cabai",
    "17/05/2025",
    "",
  ],
  [
    "LP-053-IDN",
    "Yes",
    "PT Antam, Tbk UBPP Logam Mulia-Laboratorium Pengujian Kualitas",
    "Jl. Raya Bekasi Km. 18, Jatinegara Kaum, Pulogadung, Jakarta Timur",
    "(021) 29980900",
    "Bullion, logam, batuan, pasir dan konsentrat, emas paduan, emas murni, logam",
    "15/09/2024",
    "",
  ],
  [
    "LP-057-IDN",
    "Yes",
    "Balai Besar Standardisasi dan Pelayanan Jasa Industri Agro",
    "Jl. Ir. H. Juanda 11 Bogor, Jawa Barat",
    "(0251) 8324068",
    "Abon sapi, abon ikan, acar, agar-agar tepung,air kelapa olahan, air kelapa dalam kemasan, bahan baku minuman, bakpia kacang hijau, bakso ikan, bakso daging, ikan bandeng presto, bangket sagu, Bawang merah goreng, bihun, bihun instan, bihun jagung, bika ambon, biskuit, biskuit diet diabetes, biskuit untuk bayi dan balita, buah kering, bumbu rasa ayam, bumbu rasa sapi, cokelat butir, dendeng sapi, dekstrin industri pangan, dodol, dodol sirsak, emping melinjo, es krim, es berbasis susu, formula lanjutan, garam bahan baku untuk industri garam beryodium, garam konsumsi beryodium, gula kristal mentah, gula kristal putih, gula kristal rafinasi, gula palma, ikan dan hasil olahannya, jeli, kacang garing, kacang goyang, kakao bubuk, kakao massa, kakao butter (lemak kakao), kecap ikan, kecap kedelai, kecap kedelai asin, kecap kedelai manis, keju cedar olahan, kembang gula (karet, keras, lunak), keripik kentang, keripik singkong, keripik buah, kerupuk beras, kerupuk kulit, kerupuk ikan, kerupuk udang, kopi bubuk, kopi celup, kopi instan, kopi mix, kopi premiks, kopi gula susu dalam kemasan, kopra, corned beef, krimer nabati bubuk, kue lapis, kue wingko, lemak reroti, lombok kering, madu, makanan MP-ASI (bubuk instan, biskuit, siap masak, siap santai), makanan ringan ekstrudat, makaroni, manisan pala, margarin, mayones, mentega kacang, mie basah, mie instan (berlaku untuk kepiting dan bumbunya), mie kering, mie makanan ringan (cemilan), minuman energi, minuman kopi dalam kemasan, minuman isotonik, minuman jeli, minuman sari buah, minuman serbuk berperisa, minuman teh dalam kemasan, minuman susu fermentasi berperisa, minyak goreng, minyak goreng kelapa, minyak goreng sawit, minyak jagung sebagai minyak makan, minyak kedelai sebagai minyak makan, minyak kelapa sawit (crude palm oil), minyak safflower sebagai minyak makan, minyak wijen sebagai minyak makan, MSG, nugget ayam (chicken nugget), nanas dalam kaleng, nata dalam kemasan, rambutan dalam kaleng, rempah-rempah bubuk, remah roti, roti Tawar, Roti manis, roti kenari, sale pisang, sambal, Produk Santan (Santan encer, Santan, Santan krim, Santan konsentrat, Santan bubuk), sarden dan makarel dalam kemasan kaleng, sari buah anggur, sari buah apel, sari buah tomat, sauerkraut dalam kemasan, saus cabe, saus tiram, saus tomat, selai buah, selai buah diet diabetes, serbuk minuman tradisional, sirup, sirup untuk diabetes, sirup fruktosa (HFS), sosis daging, spagheti, pasta, sup instan, susu bubuk, susu coklat bubuk, susu evaporasi, susu kedelai, susu kental manis, susu pasteurisasi, susu segar, susu sereal, susu UHT, tahu, tapioca, tauco, teh hijau, teh hijau celup, teh hijau bubuk, teh hitam, teh hitam celup, teh kering dalam kemasan, teh wangi, tempe kedelai, sohun, tepung beras, tepung beras ketan, tepung bumbu, tepung es krim, tepung gula, tepung hunkwe, tepung jagung, tepung kacang hijau, tepung ketan, tepung mokaf, tepung sagu, tepung singkong, tepung terigu sebagai bahan makanan, tepung untuk kue siap pakai, Terasi Udang, wajik, yogurt, Air Mineral, air demineral, air mineral alami, air minum embun, air minum, air minum pH tinggi, air untuk keperluan hygiene sanitasi, air limbah, udara ambien, kebisingan, pakan buatan bagi udang, pupuk urea, pupuk tripel super posfat, pupuk NPK, pupuk super posfat (SP-36), pupuk amonium sulfat, pupuk super fosfat tunggal, pupuk fosfat alam untuk pertanian, pupuk kalium klorida, ransum anak ayam; ras pedaging; ransum anak ayam ras petelur; ransum ayam ras, pedaging, ransum dara ayam ayam ras petelur, ransum itik petelur dara; ransum puyuh petelur pemula, swab test.",
    "02/10/2025",
    "",
  ],
  [
    "LP-060-IDN",
    "Yes",
    "Balai Standardisasi dan Pelayanan Jasa Industri Samarinda",
    "Jl. MT. Haryono/Banggeris No. 1, Samarinda, Kalimantan Timur",
    "(0541) 745431; 7771364",
    "Air minum dalam kemasan (AMDK), air limbah, air permukaan, Air sungai, air danau, air tanah, pupuk urea, pupuk NPK, garam konsumsi, udara ambient, Udara Emisi Sumber Tidak Bergerak, Udara Emisi Sumber Bergerak, minyak kelapa sawit mentah (CPO), minyak goreng sawit",
    "06/05/2024",
    "",
  ],
  ["LP-061-IDN", "No", "", "", "", "", "", "Nomor Akreditasi dicabut"],
  ["LP-062-IDN", "No", "", "", "", "", "", "Nomor Akreditasi dicabut"],
  ["LP-063-IDN", "No", "", "", "", "", "", "Nomor Akreditasi dicabut"],
  ["LP-064-IDN", "No", "", "", "", "", "", "Nomor Akreditasi dicabut"],
  ["LP-065-IDN", "No", "", "", "", "", "", "Nomor Akreditasi dicabut"],
  [
    "LP-066-IDN",
    "Yes",
    "PT Pupuk Kalimantan Timur",
    "Jl. James Simandjuntak No. 1, Bontang, Kalimantan Timur",
    "(0548) 41202",
    "Pupuk urea, amoniak cair, pupuk NPK padat, pupuk kalium klorida, pupuk diamonium pospat (DAP), gas alam, air limbah, air laut, emisi gas buang sumber tidak bergerak, emisi gas buang sumber bergerak, udara ambien, kebisingan",
    "19/09/2026",
    "",
  ],
  [
    "LP-067-IDN",
    "Yes",
    "MBRIO Food Laboratory",
    "Jl. Villa Indah Pajajaran Blok B-17, Pulo Armin, Bogor, Jawa Barat",
    "(0251) 8346986",
    "Abon daging sapi, Air bersih, Air minum dalam kemasan, Biskuit, Buah segar dan buah dalam kemasan, Bumbu bubuk kering, bumbu pasta, Daging ayam segar, daging unggas dan daging hewan buruan yang dihaluskan dan diolah dengan perlakuan panas, daging unggas dan daging hewan buruan yang dihaluskan, diolah dan dibekukan, Es krim, Gula palma, Gula putih lunak (Soft White Sugar), gula merah lunak (Soft Brown Sugar), sirup glukosa, sirup glukosa kering (Dried Glucose Syrup), gula pasir mentah, gula kristal rafinasi, Ikan Segar; Filet Ikan dan Hasil Perikanan Termasuk Moluska, Krustase dan Ekinodermata berlapis tepung yang dibekukan, Jeli agar siap konsumsi, Kakao bubuk, Keik dan pai (isi buah atau custard, vla), Keju, Kembang gula/permen lunak, kembang gula keras/permen keras, Kopi, teh, seduhan herbal dan minuman biji-bijian dan sereal panas, Kopi bubuk, kopi instan, minuman kopi dalam kemasan, Krimer, Kukis (kue nastar), Makanan ringan ekstrudat, Minuman isotonik, Minuman sari kedelai, Minuman jeli, Minuman sari buah, Minuman susu fermentasi, yogurt, Coklat pasta, Pangan olahan siap saji (nasi goreng), Mie instan, Produk kakao dan cokelat (cokelat butir, cokelat batang), Produk protein kedelai, Roti, Saus cabe, saus panggang/saus barbekue (BBQ sauce), saus teremulsi, Sayur, kacang dan biji-bijian segar, Minuman serbuk, Sereal bar, sereal siap saji termasuk sereal sarapan, Sirup, Susu bubuk, susu segar, susu pasteurisasi, susu UHT, Teh bubuk, teh celup, minuman teh dalam kemasan, Tepung beras, tepung bumbu, Tepung terigu, , Air limbah, Hygiene monitoring, Kosmetik : bedak padat, bedak tabur, cologne, eye shadow, lipstik, lotion, maskara, pasta gigi, lipgloss, pewarna rambut, tissue basah, shampo, Antiseptik/Desinfektan",
    "05/06/2026",
    "",
  ],
  [
    "LP-069-IDN",
    "Yes",
    "PT Indofood CBP Sukses Makmur, Tbk - Corporate Quality Assurance Laboratory",
    "Jl. Ancol I No. 4-5, Ancol Barat, Jakarta Utara, DKI Jakarta",
    "(021) 6909432",
    "Tepung dan pati (tepung terigu, tepung beras, tepung jagung, tapioka, pati termodifikasi, pati kentang), mie (mie instan, mie kering, bihun, mie sebagai makanan ringan) dan pasta, Makanan berbasis susu berperisa dan atau difermentasi, makanan bayi, Makanan ringan (potato chips, cassava chips, tempe chips, baked corn puff, talas chips, kerupuk), biskuit, kecap, saus, sirup, minuman ringan, bumbu bubuk (powder) dan kondimen, bumbu pasta, garam, susu bubuk, garic powder, minyak, lemak, dan minyak bumbu, carragenan, cabe bubuk, margarin, ikan asin, gula, ferrofumarate, tartrazin, wheat gluten, asam sitrat, ammonium bicarbonate, NaH2PO4, Na2CO3, MSG, guargum, air besih dan air minum, produk freeze dried (daging, sayuran, soid ingredients), hygiene monitoring (swab test alat, pakaian dan lantai, kontak tangan, test udara)",
    "09/05/2026",
    "",
  ],
  [
    "LP-070-IDN",
    "Yes",
    "PT Bukit Asam Tbk. Unit Pelabuhan Tarahan",
    "Jl. Raya Soekarno Hatta Km. 15, Tarahan, Bandar Lampung, Lampung",
    "(0721) 31545; 31686",
    "Batubara",
    "20/03/2027",
    "",
  ],
  [
    "LP-071-IDN",
    "Yes",
    "PT. Geoservices Samarinda (Multilokasi)",
    "Lokasi 1: Jl. HM. Kadrie Oening No. 94, RT.18, Kel. Air Hitam, Kec. Samarinda Ulu, Samarinda, Kalimantan Timur Lokasi 2: Via PT Indominco Site, Bontang Coal Terminal Tanjung Santan, Desa Santan Hilir, Kutai Kertanegara, Kalimantan timur",
    "(0541) 7773628;733163",
    "Batubara",
    "16/10/2027",
    "",
  ],
  [
    "LP-072-IDN",
    "Yes",
    "PT. Geoservices Balikpapan (Multilokasi)",
    "Lokasi 1: Jl. MT. Haryono No. 161 Ringroad, Kel. Damai Baru, Kec. Balikpapan Selatan, Balikpapan, Kalimantan Timur Lokasi 2: Via. PT Kideco Jaya Agung, Tanah Merah, Paser (Tanah Grogot), Kalimantan Timur Lokasi 3: Via. PT Teguh Sinarabadi &amp; PT Firman Ketaun Perkasa, Desa Muara Bunyut, Melak, Kutai Barat, Kalimantan Timur",
    "(0542) 872152",
    "Lokasi 1: Batubara, bijih tambang nikel/nickel ore, crude palm oil, Air untuk Keperluan Higiene Sanitasi, air minum, air limbah, Air Sungai, air danau dan sejenisnya, tanah/lumpur/padatan/sedimen, Udara ambien",
    "18/11/2027",
    "",
  ],
  [
    "LP-073-IDN",
    "Yes",
    "PT Bukit Asam, Tbk Tanjung Enim",
    "Jl. Parigi No. 1 Talang Jawa (Lingkar Tenis), Kel. Pasar Tanjung Enim, Kec. Lawang Kidul, Sumatera Selatan",
    "(0734) 451096, 451097",
    "Batubara, air bersih, air limbah",
    "21/03/2026",
    "",
  ],
  [
    "LP-075-IDN",
    "Yes",
    "PT Bukit Asam, Tbk Tanjung Enim - Laboratorium Penguji Geoteknik",
    "Kantor Eksplorasi &amp; Geoteknik, Muara Tiga Besar, Kab. Lahat, Sumatera Selatan",
    "(0734) 451096 ext. 2560, 2538",
    "Tanah, beton kubus, beton silinder, beton, sampel geoteknik",
    "28/08/2027",
    "",
  ],
  [
    "LP-076-IDN",
    "Yes",
    "PT Petrokimia Gresik",
    "Jl. Jenderal Akhmad Yani, Gresik, Jawa Timur",
    "(031) 3982200",
    "Pupuk ZK, pupuk NPK, pupuk SP 36, pupuk urea, pupuk ZA, fosfat alam untuk pertanian, pupuk organik, kapur untuk pertanian, gipsum, asam fosfat, asam sulfat, aluminium flouride, CO",
    "24/10/2026",
    "",
  ],
  [
    "LP-077-IDN",
    "Yes",
    "Kedeputian Bidang Infrastruktur Riset dan Inovasi - Direktorat Pengelolaan Laboratorium, Fasilitas Riset dan Kawasan Sains - Laboratorium Pengujian Balai Besar Teknologi Kekuatan Struktur - BRIN",
    "Kawasan PUSPIPTEK Gedung 220, Setu, Tangerang Selatan, Banten",
    "(021) 7560930",
    "Baja lembaran lapis seng, Baja lembaran dan gulungan lapis paduan aluminium-seng (Bj.L-AS), Kawat baja, Pipa baja untuk konstruksi umum, Pipa baja lapis seng untuk saluran air, Beton, Logam, Low alloy, Cr Ni (stainless steel), Al dan paduannya, Low alloy, Metallography logam, Ban truk ringan, Ban truk dan bus, Valve (katup air), Selang hidrolik, Pipa besi, Pipa PVC, Konstruksi Bangunan/struktur/permesin/jembatan, Tali Kawat Baja untuk Minyak dan Gas Bumi, Kawat baja tanpa lapisan untuk konstruksi beton pratekan (PC wire/KBj P), Tujuh kawat baja tanpa lapisan dipilih untuk konstruksi beton pratekan (PC strand / KBjP - P7), Kawat Baja Kuens (quensh) temper untuk konstruksi Beton pratekan (PC Bar/KBjP-Q), Pipa baja saluran air dengan atau tanpa lapisan seng, Ban dalam untuk kendaraan bermotor, Bantalan beton monoblock, Tiang pancang penampang bulat berongga pratarik (spun pile), Tiang pancang penampang bulat berongga pratarik (square pile), Turap beton prategang sheet pile/CCSP, Flat sheet pile, Pole beton prategang ( catenary pole ), Baja tulangan beton, Baja tulangan beton, bahan logam, wire mesh, Bead wire, Wire mesh, Seng dan paduan, Copper dan paduan, Jaring Kawat Las Lapis Seng, Baja Lembaran dan gulungan canai dingin (Bj D), Baja Lembaran Lapis Seng, Profil Rangka Baja Ringan, Tabung pemadam api portable, Bantalan beton dan sistem penambat, Batang Kawat Baja Karbon Tinggi, Foil Aluminium &amp; Paduannya, Pelat &amp; lembaran aluminium, Baut Belah Batuan Jepit Baja, Ban mobil penumpang, Ban sepeda motor, Bitumen bergelombang, Baja Lembaran dan gulungan canai panas lunak (Bj-PL), Pelat dan Lembaran Aluminium, Pipa dan pelat baja bergelombang lapis seng, Baja batangan untuk keperluan umum (Bj-KU), Baja Profil siku sama kaki proses canai panas (Bj P Siku Sama Kaki), Baja profil kanal U proses canai, Baja profil i-beam proses canai panas, Baja lembaran dan gulungan canai dingin, Elektoda las terbungkus baja karbon rendah, mutu dan cara uji, Blok Beton ringan bergelombang, Baja Lembaran, Pelat, dan Gulungan Canai Panas untuk Aplikasi struktur umum dan struktur las , Kawat Baja Karbon Rendah, Baja Pelat, Lembaran &amp; Gulungan canai panas (Bj.P)",
    "18/01/2025",
    "",
  ],
  [
    "LP-079-IDN",
    "Yes",
    "Balai Standardisasi dan Pelayanan Jasa Industri Pontianak",
    "Jl. Budi Utomo No. 41, Pontianak, Kalimantan Barat",
    "(0561) 881393; 884442",
    "Air mineral, pupuk NPK padat, pupuk kalium klorida, pupuk fosfat alam untuk pertanian, garam konsumsi beryodium, mi instan, tepung terigu sebagai bahan makanan, Minyak Goreng Sawit, air limbah, air permukaan, Air Sungai, Air Danau, Air Tanah, air baku/air higiene sanitasi, udara ambien",
    "17/12/2024",
    "",
  ],
  [
    "LP-080-IDN",
    "Yes",
    "Balai Standardisasi dan Pelayanan Jasa Industri Palembang",
    "Jl. Perindustrian II No. 12 KM 9, Sukarami, Palembang",
    "(0711) 412482",
    "tepung terigu, mie instant, air mineral, air mineral alami, air demineral, Biji kopi, kopi bubuk, kopi instan, biskuit, garam konsumsi, minyak goreng sawit, empek-empek, Pempek ikan rebus beku, kerupuk (ikan udang &amp; moluska siap makan), pakan, Pupuk amonium sulfat (ZA), pupuk dolomit, pupuk fosfat alam untuk pertanian, pupuk NPK padat, pupuk kalium klorida, Pupuk urea, air limbah, udara ambient, lingkungan, Udara emisi sumber tidak bergerak, pupuk NPK, Air sumur untuk bahan baku air minum, air permukaan, air sungai, air bersih, air waduk, Air untuk keperluan sanitasi hygiene, Karet alam",
    "15/03/2025",
    "",
  ],
  [
    "LP-081-IDN",
    "Yes",
    "Balai Besar Pengujian Minyak dan Gas Bumi LEMIGAS \x{2013} Laboratorium Aplikasi",
    "Jl. Ciledug Raya, Kav. 109, Cipulir, Kebayoran Lama, Jakarta Selatan, DKI Jakarta",
    "T. (021) 7398278",
    "Minyak Lumas Motor Bensin Empat Langkah Kendaraan Bermotor (baru dan bekas pakai), Minyak Lumas Motor Bensin Empat Langkah sepeda motor, Minyak Lumas Motor Bensin Dua Langkah Berpendingin (Udara dan air), Minyak Lumas Motor Diesel Putaran tinggi, Minyak Lumas Roda Gigi Transmisi Manual dan Gardan untuk Kendaraan Bermotor, Minyak Lumas Transmisi Otomatis, Gemuk Lumas Kendaraan Bermotor, Minyak Lumas Hidrolik Industri Jenis Anti Aus, Minyak Lumas Roda Gigi Industri Tertutup, Minyak Lumas Motor Diesel Putaran Sedang, Minyak Lumas Motor Diesel Putaran Rendah, Minyak Lumas Motor Gas Stationer, Minyak Lumas Turbin, Gemuk Lumas Industri, Minyak Lumas Kompresor Udara, Minyak Insulasi Mineral untuk Transformator, Minyak Lumas Sirkulasi, Minyak Lumas Roda Gigi Industri Terbuka, Minyak Lumas Motor Bensin Otomatis, Minyak Lumas bekas atau dalam pemakaian, Bahan Bakar Minyak Jenis (Bensin, Minyak Solar, Minyak Tanah, Minyak Diesel, Biodiesel, Avtur, Avgas), Cairan Rem DOT 3, DOT 4, DOT 5",
    "17/04/2027",
    "",
  ],
  [
    "LP-082-IDN",
    "Yes",
    "Pusat Standardisasi Instrumen Kualitas Lingkungan Hidup, Kementerian Lingkungan Hidup dan kehutanan",
    "Kawasan PUSPIPTEK Gedung 210, Jl. Raya PUSPIPTEK, Serpong, Tangerang 15314",
    "(021) 75872028",
    "Air sumur, Air sungai, air danau, air limbah, air laut, air hujan, udara ambien, udara emisi, kebisingan, getaran, sedimen, tanah, limbah padat, limbah cair dan multifasa (TLCP), biota (jaringan tubuh, organ hewan), biomarker (rambut, kuku)",
    "19/03/2024",
    "",
  ],
  [
    "LP-084-IDN",
    "Yes",
    "Balai Besar Teknologi Pencegahan Pencemaran Industri (BBTPPI) Semarang",
    "Jl. Ki Mangunsarkoro 6, Semarang",
    "(024) 8316315; 8314312; 8310216",
    "Air Limbah , Air Sungai, Air Sumur, Air Waduk, Air Danau, Air Rawa, Air Laut, Air Untuk Keperluan Higiene Sanitasi, Air minum, Limbah padat, tanah, sedimen, Udara Ambien, Getaran, Kebisingan, Udara Emisi Sumber Tidak Bergerak, Tepung terigu sebagai bahan makanan, Garam Konsumsi Beryodium, Pupuk NPK Padat, Minyak goreng sawit, Seng Oksida, Air mineral, Air Demineral, Aluminium sulfat, Pupuk Fosfat Alam untuk Pertanian, Biskuit, Gula Kristal Putih, Meja Belajar untuk Sekolah, Kursi Belajar untuk Sekolah, Lemari Pakaian, Meja Kantor, Kursi Kuliah Tunggal, Kursi Baja untuk Kantor, Kursi Sofa, Lemari Baja Beroda Untuk Pasien, Lemari arsip dari Baja untuk kantor",
    "21/06/2025",
    "",
  ],
  [
    "LP-085-IDN",
    "Yes",
    "Balai Besar Pengujian Minyak dan Gas Bumi LEMIGAS - Laboratorium Eksploitasi",
    "Jl. Ciledug Raya Kav. 109, Cipulir, Kebayoran Lama, Jakarta Selatan, DKI Jakarta",
    "(021) 7222978",
    "Semen, serbuk barite, serbuk bentonite, batuan (core), gas alam, air formasi",
    "22/08/2026",
    "",
  ],
  ["LP-086-IDN", "No", "", "", "", "", "", "Nomor Akreditasi dicabut"],
  [
    "LP-088-IDN",
    "Yes",
    "UPT Pengujian Mutu dan Pengembangan Produk Kelautan dan Perikanan Surabaya",
    "Jl. Pagesangan II No. 58 B, Surabaya, Jawa Timur",
    "(031) 8274692",
    "Air dan es, ikan dan produk perikanan (hidup, segar, beku, kering, fermentasi, rebus/khusus, kaleng), produk olahan, paha kodok, udang",
    "22/11/2026",
    "",
  ],
  [
    "LP-090-IDN",
    "Yes",
    "PT. Beckjorindo Paryaweksana",
    "Jl. Rawa Bengkel No. 8, Bandar Lampung, Lampung",
    "(0721) 262358",
    "Biji kopi, lada hitam, wood charcoal, activated carbon",
    "27/6/2027",
    "",
  ],
  [
    "LP-091-IDN",
    "Yes",
    "PT. ALS Indonesia",
    "Lokasi 1 : Kawasan Industri Sentul, Jl. Cahaya Raya Blok K, Bogor 16810 Lokasi 2 : Jl. Arifin Ahmad, Kel. Sidomulyo Timur, Kec. Marpoyan Damai, Kota Pekanbaru",
    "(021) 29415151 (0761) 6702828",
    "Air minum, air bersih (air untuk keperluan hygiene sanitasi), air permukaan (air sungai, air danau), air limbah, air laut, TCLP-air limbah, tanah, lumpur, padatan, sedimen, TCLP-tanah, jaringan ikan, udara emisi, udara ambien, potable water, cooling water, electrical and electronic tools, personal exposure/industrial hygiene - Urine, Darah, surface swab, personal exposure/industrial hygiene - particulate, batubara, tepung-tepungan, susu bubuk, daging dan olahannya, mie instan, biskuit, makanan ringan ekstrudat, makanan ternak, seasoning powder, susu segar/cair/susu bubuk,produk minuman, sayur-sayuran, buah-buahan, produk pangan asal hewan (ikan, cumi, udang), produk pangan asal nabati (coklat-cocoa), saus sambal, orange/lemon water, minyak goreng, makanan berkalori tinggi (santan dan kacang), makanan berkalori rendah (bawang putih) dan minuman rendah kalori, makanan (tepung dan hasil olahannya, daging mentah, raw seafood, dairy products, dan makanan ringan) dan minuman (minuman kemasan UHT, minuman botol, minuman kaleng, minuman bersoda), Air tanah",
    "22/05/2027",
    "",
  ],
  [
    "LP-093-IDN",
    "Yes",
    "PT Bukit Asam Unit Dermaga Kertapati",
    "Jl. Stasiun Kereta Api, Kertapati, Palembang 30258",
    "(0711) 512617",
    "Batubara",
    "03/10/2024",
    "",
  ],
  [
    "LP-094-IDN",
    "Yes",
    "UPT Balai Penerapan Mutu Produk Perikanan Provinsi Sulawesi Selatan",
    "Jl. Prof. Dr. Ir. Sutami Makassar No. 23, Makassar, Sulawesi Selatan",
    "(0411) 4731511",
    "Udang Beku, Udang Segar, Udang Masak Beku, Udang Berlapis Tepung (Breaded) Beku, Udang kupas mentah beku, Lobster Beku, Daging Rajungan Pasteurisasi dalam Kaleng, Ikan Beku, Ikan Segar, Tuna Loin Beku, Tuna Loin Segar, Steak Ikan Beku, Ikan Kayu, Cumi-Cumi Beku, Fillet Ikan Beku, Tuna Ground Meat Beku, Tuna Slice Beku, Gurita Mentah Beku, Gurita Segar, Sotong Beku, Telur Ikan Terbang Kering, Teripang Kering, Sirip Ikan Hiu Kering, Ikan Asin Kering, Abon Ikan, Bandeng Cabut Duri, Bandeng Presto, Otak-Otak Ikan, Kaki Naga Ikan, Bakso Ikan, Sosis Ikan, Nuget Ikan, Siomay Ikan, Amplang Ikan, Kerupuk Ikan, kerupuk udang, bandeng cabut duri, bandeng presto, rumput laut kering, Agar-Agar Tepung, Air dan es yang digunakan dalam proses produksi di unit pengolahan ikan, produk perikanan beku, produk perikanan dalam kaleng,",
    "26/02/2026",
    "",
  ],
  [
    "LP-096-IDN",
    "Yes",
    "Deputi Bidang Infrastruktur Riset dan Inovasi - Direktorat Pengelolaan Laboratorium, Fasilitas Riset dan Kawasan Sains dan Teknologi - Laboratorium Konversi Energi - Badan Riset dan Inovasi Nasional (BRIN)",
    "Kawasan Puspiptek Gd. 620-622, Serpong, Tangerang Selatan",
    "(021) 7560562",
    "Modul fotovoltaik, baterai, Battery Charge Regulator (BCR), inverter pada pembangkit listrik tenaga surya, sistem fotovoltaik yang berdiri sendiri, emisi sumber tidak bergerak, lampu swabalast CFL, lampu swabalast LED, lampu DC, AC Split wall mounted",
    "21/03/2026",
    "",
  ],
  [
    "LP-097-IDN",
    "Yes",
    "UPTD Pengujian dan Penerapan Mutu Hasil Perikanan Provinsi Bali",
    "Jl. Kapten Tantular No. 10 Denpasar, Bali",
    "(0361) 262836",
    "Ikan beku (ikan cucut, tuna, marlin, meka, kakap, kerapu, gindara, mahi-mahi, layang lemuru, tenggiri, layur, cumi-cumi, telur ikan), udang/lobster beku, ikan segar (kerapu, tuna, marlin, meka, kakap, gindara, mahi-mahi, layur, kurisi, tongkol), lobster segar, ikan olahan/kering (ikan asap, rumput laut, teripang, ikan dalam kaleng, pindang), air pengolahan ikan",
    "15/03/2025",
    "",
  ],
  [
    "LP-103-IDN",
    "Yes",
    "Balai Pengujian Mutu Hasil Perikanan Kelas A Provinsi Jawa Tengah",
    "Jl. Siliwangi 636, Semarang, Jawa Tengah",
    "(024) 7605311",
    "(Ikan, rajungan, Udang, kerang, cumi) laut segar, beku dan kering, (ikan, udang) tawar segar, tepung ikan, Olahan Ikan (Naget Ikan, Keripik Ikan, Bakso Ikan, Bandeng Duri Lunak, Bandeng Cabut Duri, Abon Ikan, Kerupuk Udang,Rajungan Kaleng, Sarden Kaleng, Tuna Kaleng), Air proses pengolahan produk perikanan, air sumber, air PDAM, air untuk pencucian alat-alat pengolahan produk perikanan",
    "03/04/2026",
    "",
  ],
  [
    "LP-104-IDN",
    "Yes",
    "PT Hanjaya Mandala Sampoerna, Tbk",
    "Jl. Raya Surabaya \x{2013} Malang Km. 51,4, Sukorejo, Kab. Pasuruan, Jawa Timur",
    "(0343) 636740",
    "Cigarette (mainstream smoke) - white cigarette, cigarette (mainstream smoke) -kretek cigarette, cigarette paper, cigarette tipping paper, cigarette plug wrap, cigarette, filter plug, filter rods, cigarette tobacco, cigarette paper (kertas rokok), cigarette tipping paper, aluminium foil, karton, adhesive material (lem), triacetine solution, tobacco and tobacco product, cengkeh kering, tobacco leaf and blend, Cigarette (smoke condensate)",
    "24/10/2026",
    "",
  ],
  [
    "LP-106-IDN",
    "Yes",
    "Deputi Bidang Infrastruktur Riset dan Inovasi - Direktorat Pengelolaan Laboratorium, Fasilitas Riset dan Kawasan Sains Teknologi - Laboratorium Polimer",
    "Kawasan PUSPIPTEK, Gedung 460, Tangerang Selatan, Banten 15314",
    "(021) 7563360",
    "Polimer, Komposit Polimer, Poliolefina, biji plastik, polietilene",
    "01/01/2028",
    "",
  ],
  [
    "LP-107-IDN",
    "Yes",
    "Balai Pengawasan dan Sertifikasi Benih Provinsi Jawa Tengah",
    "Jl. Solo \x{2013} Yogyakarta Km. 15 Sraten, Gatak, Sukoharjo PO BOX Kab.Sukoharjo. Jawa Tengah",
    "(0271) 780232",
    "Benih tanaman pangan (padi, jagung, kedelai, kacang hijau, kacang tanah)",
    "17/04/2027",
    "",
  ],
  ["LP-108-IDN", "No", "", "", "", "", "", "Nomor Akreditasi dicabut"],
  [
    "LP-109-IDN",
    "Yes",
    "Balai Standardisasi dan Pelayanan Jasa Industri Manado",
    "Jl. Raya Mapenget, Paniki Dua, Kota Manado, Sulawesi Utara",
    "(0431) 7244447",
    "Air mineral, air demineral, mie instan, garam konsumsi beryodium, arang tempurung kelapa, minyak goreng, kelapa parut kering, biskuit, tepung ikan sebagai bahan baku pakan, minyak goreng sawit, air limbah, air sungai, air bersih",
    "24/10/2026",
    "",
  ],
  [
    "LP-110-IDN",
    "Yes",
    "Balai Besar Standardisasi dan Pelayanan Jasa Industri Hasil Perkebunana, Mineral Logam, dan Maritim",
    "Jl. Prof. Dr. H. Abdurrahman Basalamah, MA No. 28, Makassar, Sulawesi Selatan",
    "(0411) 441207",
    "air mineral, Air demineral, Mi instan, Garam konsumsi beryodium, Tepung Terigu , Kakao bubuk, Gula rafinasi, Gula kristal putih, Kakao massa, Biskuit, Minyak goreng sawit, Biji kakao, Kopi biji, Kopi Bubuk, Pupuk NPK padat, Semen Portland, Semen Portland Pozzolan, Semen Portland Komposit , Air minum, Air untuk keperluan higiene sanitasi, Air limbah, Air permukaan (danau, sumur, sungai, waduk), Udara ambien, Lingkungan kerja , Udara emisi sumber tidak bergerak, Daging, telur, susu dan Olahannya, Air laut, bawang merah, sirup, rumput laut kering, sosis, bakso, minuman, briker/batubara",
    "20/09/2025",
    "",
  ],
  [
    "LP-111-IDN",
    "No",
    "",
    "",
    "",
    "",
    "",
    "Nomor digabung dengan LP-023-IDN",
  ],
  [
    "LP-112-IDN",
    "Yes",
    "Balai Besar Pengujian Perangkat Telekomunikasi",
    "Jl. Bintara Raya I No. 17, Bekasi Barat",
    "(021) 86615492-95",
    "Pemancar Radio Siaran , Radio Komunikasi HF/VHF/UHF, Terminal GPRS, Pesawat Telepon Seluler GSM, Pesawat Telepon Seluler WCDMA, Wireless Local Area Network (WLAN), Radio Trunking, Pesawat Faksimili, Pesawat Telepon Analog, Electronic Data Capture (EDC), Key Telephone System, PABX Analog, Perangkat elektronik maupun listrik yang membangkitkan emisi/radiasi, Repeater GSM, Repeater WCDMA, Pemancar siaran televisi digital DVB T-2, Pesawat telepon seluler LTE, BTS LTE, Router, Radio Microwave, Penerima DVB T2, Radio Maritim, Radio Modem, Optical Line Terminal (OLT),Optical Network Terminal (ONT), IP PBX, IP Phone, Penerima DVB-S, Electrical Safety, Specific Absorbtion Rate",
    "17/11/2024",
    "",
  ],
  [
    "LP-114-IDN",
    "Yes",
    "Balai Besar Kimia dan Kemasan",
    "Jl. Balai Kimia, No.1 Pekayon, Pasar Rebo, Jakarta Timur",
    "(021) 8717438, 8710630, 8720449",
    "Pupuk urea; Pupuk NPK padat, Pupuk fosfat alam untuk pertanian, Pupuk SP-36, Pupuk kalium klorida, Pupuk tripel super fosfat, Pupuk cair hasil samping proses asam amino (haspramin), Pupuk amonium sulfat, Asam sulfat teknis, Aluminium sulfat, Natrium silikat cair teknis, Poli aluminium klorida, Deterjen serbuk, Natrium hipoklorit teknis, Asam klorida teknis, Kaporit (Kalsium Hipoklorit), Soda Kaustik (Soda Api) Teknis Padat dan Cair, Seng Oksida, Natrium Metabisulfi, Resin PVC, Produk Melamin-Perlengkapan makan dan minum, Sodium tripolifosfat (STPP) mutu teknis, Kalsium karbida (CaC2), Garam konsumsi beryodium, Pupuk Borat, Asam Formiat, Plastik-Wadah makanan dan minuman Polystyrene foam, PP (Polipropilena), PE (Polietilena), Kemasan Transpor untuk produk non dangerous goods(simulan transportasi) (Jerrycan, drum, kotak karton gelombang (KKG), paper bag/plastic bag), Jerrycan atau Drum untuk kemasan dangerous goods, Kotak Karton Gelombang (KKG) untuk kemasan dangerous goods, Paper bag atau Plastik bag untuk kemasan dangerous goods, Palet Plastik, Palet Kayu, Palet kertas, Plastik dan Produk Plastik, Kertas, Karton Dan Karton Gelombang, Plastik - Tangki Air Vertikal - Polietilena (PE), Kosmetik (Krim Wajah), Plastik (Polikarbonat), Plastik (PE, PP, PVC, PET, Multilayer,PS), Korek api gas, Helm Pengendara Kendaraan Bermotor Roda Dua, Keamanan Mainan-Bagian 1 : Aspek Keamanan yang Berhubungan dengan Sifat Fisis dan Mekanis; Keamanan mainan-Bagian 2: Aspek Keamanan yang Berhubungnan dengan sifat mudah terbakar, Mainan anak (Bagian 3: migrasi unsur tertentu, Plastik Multilayer &amp; logam Termigrasi, Plastik, Pthalat pada mainan anak",
    "21/06/2025",
    "",
  ],
  [
    "LP-115-IDN",
    "Yes",
    "Balai Pengujian Mutu Produk Tanaman",
    "Jl. AUP Pasar Minggu, Jakarta Selatan 12520",
    "(021) 78835256",
    "Biji-bijian serealia : Beras, jagung, gandum, gabah;",
    "16/10/2027",
    "",
  ],
  ["LP-116-IDN", "No", "", "", "", "", "", "Nomor Akreditasi dicabut"],
  [
    "LP-118-IDN",
    "Yes",
    "UPTD Balai Pengawasan dan Sertifikasi Benih Tanaman Pangan dan Hortikultura Propinsi Jawa Barat",
    "Jl. Ciganitri II Bojongsoang \x{2013} Bandung 40228",
    "(022) 7563014",
    "Benih tanaman pangan (padi, jagung, kedelai, kacang hijau, kacang tanah, gandum, sorgum), benih tanaman hortikultura (cabai, tomat, bayam, buncis, kacang panjang, wortel, sawi, semangka, mentimun, terung), tanah, pertanaman kentang (di lapangan) dan umbi kentang (di gudang) untuk benih bersertifikat kelas G0, G1, G2, G3, G4",
    "18/11/2024",
    "",
  ],
  ["LP-119-IDN", "No", "", "", "", "", "", "Nomor Akreditasi dicabut"],
  [
    "LP-121-IDN",
    "Yes",
    "Balai Besar Pengujian Standar Instrumen Veteriner",
    "Jl. R.E. Martadinanat No. 30 Bogor, Jawa Barat",
    "(0251) 8331048; 8334456",
    "Hewan utuh (sakit/mati), Organ atau potongan organ, Serum,Swab Trakea, Swab Kloaka, Darah segar, Faeces, Pakan, bahan pakan dan organ hewan (paru-paru, trakea, usus halus, usus buntu, hati, limpa, jantung, ginjal dan lain-lain), Serum (sapi, domba/kambing, babi), Kolustrum, susu, cairan amnion, jaringan fetus, cairan hygroma, Serum (sapi, anjing, tikus dan manusia), Urin, Air, darah dan ginjal, Serum dan darah ayam, Swab darah, cairan udema, organ tulang, sumsum tulang, kulit, bulu, daging, tanah dan pakan ternak, Serum darah, Susu (susu segar, susu bubuk), daging, telur, makanan dan minuman asal ternak (keju, rolade,es krim, nugget, bakso, yogurt, sosis, rolade), Pakan ternak, bahan pakan dan biji-bijian (jagung, bungkil kacang, dedak, kedelai, bungkil kedelai, Kacang tanah), Susu, Daging",
    "18/12/2027",
    "",
  ],
  [
    "LP-122-IDN",
    "Yes",
    "Pusat Pelayanan Kesehatan Hewan dan Peternakan",
    "Lokasi 1 : Jl. Raya Bambu Apus , Cipayung, Jakarta Timur Lokasi 2 : Jl. Harsono RM Ragunan, Jakarta Selatan",
    "(021) 8455748",
    "Lokasi 1 : Daging, telur, susu dan hasil olahannya, peralatan pengolahan (meja, wajan, talenan, pisau, panci, dsb), daging (ayam, sapi, kambing/domba), olahan daging, susu cair, susu bubuk, telur dan olahan telur, Bahan pangan asal hewan yang dicurigai mengandung gen babi, susu (segar, UHT, pasteurisasi, kental manis, coklat bubuk, evaporasi), rendang daging sapi, Kornet, sosis, Bakso (daging sapi, kerbau, kambing, babi, unggas, hewan ternak lain), naget ayam, minuman susu fermentasi berperisa, margarin, mentega, es krim, keju, usus ayam, jeroan, hati, ginjal",
    "23/05/2024",
    "",
  ],
  [
    "LP-123-IDN",
    "Yes",
    "Balai Besar Veteriner Denpasar",
    "Jl. Raya Sesetan No. 266 Denpasar, Bali",
    "(0361) 720862; 720615",
    "Organ sapi, organ babi, organ ayam, daging, susu, telur, Otak hewan pembawa rabies, swab kloaka/trachea, serum unggas, serum babi, tinja hewan, preparat ulas darah sapi dan kerbau, daging/organ babi dan sapi, serum (anjing, kucing, sapi bali, kerbau, sapi, ayam), darah EDTA dan organ limpa sapi bali, swab nasal dan organ babi/kera, organ kerbau, organ hewan pembawa rabies",
    "25/07/2026",
    "",
  ],
  [
    "LP-124-IDN",
    "Yes",
    "UPT Penerapan Mutu Hasil Perikanan, Dinas Kelautan dan Perikanan Sumatera Utara",
    "Jl. Pulau Biak No. 1 Kawasan Industri Medan, Mabar, Medan",
    "0811605533",
    "Ikan (beku, segar), sotong (beku, kaleng), cumi-cumi (kaleng, beku), gurita (beku), udang (beku, segar, kaleng), ikan teri, tuna (kaleng, beku), kerang (beku, kaleng), paha kodok (beku), bekicot (beku, kering, kaleng), teripang (kering), ubur-ubur asin, sirip cucut, kepiting kaleng, siput beku, nila (beku, segar), kepiting kulit lunak beku, rajungan kaleng, daging rajungan pasteurisasi",
    "16/12/2024",
    "",
  ],
  [
    "LP-125-IDN",
    "Yes",
    "Balai Besar Pengawas Obat dan Makanan di Yogyakarta",
    "Jl. Tompeyan I, Tegalrejo, Yogyakarta 55244",
    "(0274) 561038",
    "Terapetik : tablet, kapsul, sirup, larutan, suspensi, injeksi, krim",
    "23/04/2024",
    "",
  ],
  [
    "LP-126-IDN",
    "Yes",
    "UPT Laboratorium Lingkungan Hidup Daerah (LLHD) Provinsi DKI Jakarta",
    "Jl. Casablanca Kav. 1 Kuningan, Jakarta Selatan 12950",
    "(021) 5209651",
    "Air bersih, air permukaan, air limbah, Air tanah, Air limbah, udara ambien",
    "01/09/2024",
    "",
  ],
  [
    "LP-127-IDN",
    "Yes",
    "PT Pupuk Sriwidjaja Palembang",
    "Jl. Mayor Zen, Komplek PT PUSRI Palembang 30118",
    "(0711) 712111; 712222",
    "Pupuk urea prill, ammonia cair, pupuk NPK padat",
    "28/07/2024",
    "",
  ],
  ["LP-129-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  [
    "LP-130-IDN",
    "Yes",
    "PT Intertek Utama Services",
    "Jl. Raya Bogor Km.28 Jakarta Timur, DKI Jakarta",
    "(021) 29384454",
    "",
    "28/08/2027",
    "",
  ],
  [
    "LP-132-IDN",
    "Yes",
    "Balai Besar Pengawas Obat dan Makanan di Semarang",
    "Jl. Sukun Raya No. 41 A, Semarang, Jawa Tengah",
    "(024) 7613761; 761376",
    "Terapetik dan NAPZA: Tablet, Kapsul, Sirup, Suspensi, Injeksi, Infus, Tetes Mata, Tetes Telinga, Salep, Krim, Cuplikan",
    "02/07/2026",
    "",
  ],
  [
    "LP-133-IDN",
    "Yes",
    "Balai Besar Pengawas Obat dan Makanan di Surabaya",
    "Jl. Karangmenjangan No. 20, Surabaya, Jawa Timur",
    "(031) 5022815",
    "Terapetik : tablet kapsul, krim, injeksi, suspensi, Larutan",
    "13/06/2026",
    "",
  ],
  ["LP-134-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  [
    "LP-136-IDN",
    "Yes",
    "UPTD Pengujian dan Penerapan Mutu Produk Perikanan Cirebon",
    "Jl. Sutawinangun No. 2 Cirebon Jawa Barat 45131",
    "(0231) 201454",
    "Bekicot Kaleng, Breaded Fish, Breaded Shrimp, Daging Rajungan Kaleng, Fillet Ikan Beku, Ikan Rajungan Beku, Udang Beku, Gurita Beku, Kerang Beku, Cumi Laut Beku, Ikan Tawar Beku, Udang Tawar Beku, Ikan Rajungan Segar, Udang Segar, Gurita Segar, Kerang Segar, Cumi Laut Segar, Ikan Tawar Segar, Udang Tawar Segar, Ikan Laut Kering, Udang Laut Kering, Cumi Laut Kering, Ikan Olahan Tradisional, Olahan Ikan (Naget Ikan, Otak-otak Ikan, Bakso Ikan, Abon Ikan, Dimsum Ikan, Kerupuk Ikan, Kerupuk Udang, Kerupuk Moluska, Kerupuk Ikan Siap Makan, Kerupuk Udang Siap Makan, Kerupuk Moluska Siap Makan, Terasi Udang, Kaki Naga Ikan), Paha Kodok Beku, Value dded Fish, Value Added Shrimp, Ikan Beku (Fillet Ikan, Ikan Rajungan, Udang, Gurita, Kerang, Cumi Laut, Ikan Tawar, Udang Tawar, Paha Kodok), Ikan segar (Ikan Rajungan, Udang, Gurita, Kerang Cumi Laut, Ikan Tawar, Udang Tawar), Air untuk Keperluan Higiene Sanitasi (air PDAM dan Es), Bawang Goreng",
    "27/01/2028",
    "",
  ],
  [
    "LP-139-IDN",
    "Yes",
    "Balai Besar Pengawas Obat dan Makanan di Denpasar",
    "Jl. Tjut Nya Dien No. 5, Renon, Denpasar",
    "(0361) 223763; 234597",
    "Obat terapetik (sediaan padat bentuk kapsul, sediaan padat bentuk tablet, sediaan cair bentuk injeksi, sediaan cair bentuk larutan, sediaan cair bentuk sirup, Sediaan Cair bentuk Sirup Kering, sediaan krim/salep),",
    "01/04/2027",
    "",
  ],
  [
    "LP-140-IDN",
    "Yes",
    "Balai Veteriner Bukittinggi",
    "Jl. Raya Bukittinggi - Payakumbuh Km. 14, Baso, Kab. Agam, Sumatera Barat",
    "(0752) 28300",
    "Virologi: otak hewan (anjing, kucing, kera, mamalia), serum unggas, serum darah babi, organ, swab, feses pada unggas, serum anjing.",
    "17/7/2027",
    "",
  ],
  [
    "LP-143-IDN",
    "Yes",
    "PT Pertamina (Persero) Refinery Unit III Plaju - Laboratory Engineering and Development",
    "Jl. Beringin No. 1 , PO BOX No. 1, Plaju, Palembang 30268",
    "(0711) 598805",
    "Crude oil, premiun, pertamax, avtur, kerosine, solar dan solar plus, medium naphtha, industrial fuel oil, fuel oil, Low sulfur waxy residue (LSWR), Low Aromatics White Spirit (LAWS), Special Boiling Point (SBP), n-hexane, polytam, asam sulfat",
    "18/11/2024",
    "",
  ],
  ["LP-144-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  ["LP-145-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  [
    "LP-151-IDN",
    "Yes",
    "Laboratorium Litbang dan Jaminan Mutu, PT Semen Indonesia",
    "Lokasi 1 : Gedung PPS, PT Semen Indonesia Tbk, Jl. Veteran, Gresik 61122 Lokasi 2 : Gedung dormitori, PT Semen Indonesia Tbk, Desa Sumberarum Kec. Terek , Tuban 62356",
    "(031) 3981731-3 (0356) 325001-3",
    "Lokasi 1 : Terak dan semen, semen, Beton",
    "23/04/2024",
    "",
  ],
  [
    "LP-152-IDN",
    "No",
    "",
    "",
    "",
    "",
    "",
    "Nomor digabung dengan LP-137-IDN",
  ],
  [
    "LP-153-IDN",
    "Yes",
    "Balai Besar Pengawas Obat dan Makanan di Padang",
    "Jl. Gajah Mada, Gunung Pangilun, Padang, Sumatera Barat",
    "(0751) 7054280",
    "Terapetik (kapsul, tablet, suspensi kering), Napza (simplisia, serbuk, tablet, injeksi), obat tradisional dan suplemen makanan (rajangan, sediaan padat, sediaan cair), kosmetik, pangan dan bahan berbahaya (produk susu dan analognya; lemak, minyak dan emulsi; buah dan sayur; kembang gula/permen dan coklat; serealia dan produk serealia; produk bakeri; daging dan produk daging; ikan dan produk perikanan; telur dan produk telur; pemanis termasuk madu; produk pangan untuk keperluan gizi khusus; minuman tidak termasuk produk susu; makanan ringan siap santap; kemasan pangan), mikrobiologi",
    "29/07/2027",
    "",
  ],
  [
    "LP-156-IDN",
    "Yes",
    "Laboratorium Jasa Pengujian, Kalibrasi dan Sertifikasi IPB",
    "Gedung Pascasarjana Wing Kimia Lantai Dasar, Kampus IPB Baranangsiang, Jl. Padjajaran, Bogor, Jawa Barat",
    "(0251) 8319894",
    "Udara emisi sumber tidak bergerak, Udara emisi sumber bergerak, udara lingkungan kerja, udara ambien, kebauan, kebisingan, air limbah, air sungai, TCLP, Limbah B3 (padat, sludge), air untuk keperluan higiene dan sanitasi, air minum, air laut, tanah, Susu bubuk, sabun cair, sanitizer, susu cair, keju virgin coconut oil (VCO), minyak ikan, daging, kornet, sosis, pakan ternak, minuman beralkohol (kadar rendah di bawah 5%), perisa, biskuit, pestisida, deterjen serbuk, seterjen cuci cair, pembersih lantai",
    "20/09/2025",
    "",
  ],
  [
    "LP-157-IDN",
    "Yes",
    "Laboratorium Kesehatan Daerah Provinsi DKI Jakarta",
    "Jl. Rawasari Selatan No. 2, Jakarta, DKI Jakarta",
    "(021) 4247404",
    "Air untuk keperluan higiene dan sanitasi, air minum, air mineral, Air limbah, nasi siap saji, kosmetik (padatan: lipstik, bedak, cream), margarin, kerang, obat Kimia (tablet, sirup), obat tradisional (kapsul dan serbuk), Etanol dalam minuman, mie, bakso, kerupuk, saus, kecap, kue, sirup, jeli, minuman ringan, tahu putih, tahu kuning, minuman berperisa, tepung, susu, biskuit, sereal, beras, strawberry, selada, urin, plasma, rambut, darah",
    "19/12/2026",
    "",
  ],
  [
    "LP-158-IDN",
    "Yes",
    "Balai Laboratorium Bea dan Cukai Kelas I Jakarta",
    "Lokasi 1 : Jl. Letjen Suprapto 66, Jakarta Pusat 10520 Lokasi 2 : Jl. Pabean no.1, Tanjung Priok, Jakarta Utara Lokasi 3 : Jl. Area Cargo bandara Soekarno Hatta, Jl. Raya bandara, Cengkareng, Banten Lokasi 4 : Jl. pulorida no.101,Merak, Tamansari, Kota cilegon, Banten Lokasi 5 : Jl. Rumah Sakit No. 167, Babakan Penghulu, Kec. Cinambo, Kota Bandung, Jawa Barat (Satuan Pelayanan Laboratorium Bea dan Cukai Bandung) Lokasi 6 : Jl. Pelabuhan No. 1, Pontianak, Kalimantan Barat",
    "(021) 4246033",
    "Lokasi 1 : Minuman mengandung Etil Alkohol, Garam(NaCl), lubricant oil, polimer, crude palm oil (CPO), gula kristal mentah (raw sugar), gula kristal putih, gula kristal rafinasi, tekstil, low-alloy steel, konsentrat Tembaga, mineral logam",
    "29/12/2024",
    "",
  ],
  [
    "LP-159-IDN",
    "Yes",
    "PT Selamat Sempurna Tbk.",
    "Jl. Raya LPPU Curug No. 88, Bitung, Tangerang, Banten",
    "(021) 5984388",
    "Filter, oil filter, fuel filter, spin on filter, air filter, packing filter, spring, paper for filter, cabin filter, filter water separator",
    "24/09/2024",
    "",
  ],
  ["LP-160-IDN", "No", "", "", "", "", "", "Nomor Akreditasi dicabut"],
  [
    "LP-162-IDN",
    "Yes",
    "Balai Besar Pengembangan Pengujian Mutu Benih Tanaman Pangan dan Hortikultura",
    "Jl. Raya Tapos, Kotak Pos 20, Cimanggis, Depok, Jawa Barat",
    "(021) 8755046",
    "Benih (Padi, Kedelai, Jagung, Jagung Manis, Kacang Tanah, kacang hijau, Gandum, kangkung, kacang kapri, kacang merah, waluh, bit gula, lobak, spinach, seledri, paria, koro, kecipir, pepaya, bawang, kol bunga, petsai, sawi, ketimun, selada, tomat, buncis, kol, wortel, cabai, terong, kacang panjang, oyong, semangka, melon, kentang), jaringan tanaman buah naga",
    "05/06/2026",
    "",
  ],
  [
    "LP-165-IDN",
    "No",
    "",
    "",
    "",
    "",
    "",
    "Nomor digabung dengan LP-163-IDN</strong>",
  ],
  [
    "LP-167-IDN",
    "Yes",
    "PT Pulau Sambu Guntung",
    "Sungai Guntung, Kecamatan Kateman, Kabupaten Indragiri Hilir, Riau",
    "(0779) 552888",
    "Desiccated coconut, coconut cream/coconut milk, coconut cream/coconut milk powder, high acid coconut milk beverage, low acid coconut milk beverage, high acid/acidified coconut water beverage, low acid coconut water beverage, aseptic coconut water-single stength, coconut sugar, water treatment, water for drinking domestic purposes and cleaning water, swab test, food packaging (Poly propylene, poly ethylene, paperbiard, alumunium foil), general water and water foam cooling and boiler, Steam condensate, food ingredients (food additive and processing aid)",
    "27/07/2025",
    "",
  ],
  [
    "LP-169-IDN",
    "Yes",
    "UPTD Balai Penerapan Mutu Hasil Perikanan Provinsi Kalimantan Selatan",
    "Jl. Mistar Cokrokusumo No. 01 RT. 003 RW. 001, Cempaka, Banjarbaru, Kalimantan Selatan",
    "(0511) 4781660",
    "Ikan segar, udang segar, Ikan, filet Ikan dan produk perikanan meliputi moluska, krustase, ekinodemata yang dibekukan dan ekinodermata berlapis tepung yang dibekukan, ikan beku, air dan es, produk olahan ikan (Bakso ikan, otak-otak, siomay ikan, empek-empek, empek-empek palembang, sosis ikan, sosis udang, kaki naga, dan tekwan, Amplang, abon ikan, Kerupuk udang, kerupuk kulit ikan, kerupuk ikan, Ikan asin kering, udang kering, cumi-cumi kering/juhi, Terasi udang, Moluska, krustase dan ekinodermata segar",
    "20/03/2027",
    "",
  ],
  ["LP-171-IDN", "No", "", "", "", "", "", "Nomor Akreditasi dicabut"],
  [
    "LP-172-IDN",
    "Yes",
    "Balai Pengujian Mutu dan Sertifikasi Pakan",
    "Jl. MT Haryono No. 98 Kec. Setu, Kab. Bekasi, Jawa Barat",
    "(021) 82602182",
    "Bahan pakan asal tumbuhan, bahan pakan asal hewan, bahan pakan (hijauan), pakan ternak non ruminansia, Pakan ruminansia",
    "04/05/2026",
    "",
  ],
  [
    "LP-173-IDN",
    "Yes",
    "Balai Besar Pengawas Obat dan Makanan di Bandung",
    "Jl. Pasteur No. 25, Bandung, Jawa Barat",
    "(022) 4230546",
    "Terapetik : Tablet, kapsul, sirup, suspensi, injeksi, infus,semisolida, tetes mata",
    "05/09/2026",
    "",
  ],
  [
    "LP-174-IDN",
    "Yes",
    "Laboratorium Air Perum Jasa Tirta II",
    "Jl. Curug, Kosambi, Kec. Klari, Kab. Karawang, Jawa Barat",
    "(0264) 20285, 201972",
    "Air limbah, air sungai, air danau, air untuk keperluan higiene sanitas, air minum, ambien, emisi sumber tidak bergerak, kebisingan lingkungan kerja, kebisingan lingkungan",
    "27/07/2025",
    "",
  ],
  [
    "LP-178-IDN",
    "Yes",
    "Balai Besar Pengawas Obat dan Makanan di Jakarta",
    "Jl. As'syafiiyah No. 133, Cilangkap, Jakarta Timur, DKI Jakarta",
    "(021) 84304048",
    "Terapetik:",
    "15/02/2026",
    "",
  ],
  [
    "LP-179-IDN",
    "Yes",
    "Balai Besar Standardisasi dan Pelayanan Jasa Industri Tekstil",
    "Jl. Jend. Ahmad Yani No. 390, Bandung, Jawa Barat",
    "(022) 7206214 ; 7206215",
    "Kain dan pakaian jadi, serat, benang, geotekstil, karpet, mainan anak, tekstil dan produk tekstil, masker medis, pakaian pelindung",
    "21/03/2026",
    "",
  ],
  ["LP-181-IDN", "No", "", "", "", "", "", "Nomor Akreditasi dicabut"],
  ["LP-182-IDN", "No", "", "", "", "", "", "Nomor Akreditasi dicabut"],
  [
    "LP-184-IDN",
    "Yes",
    "PT. Saraswanti Indo Genetech",
    "Graha SIG Jl. Rasamala No.20 Taman Yasmin, Bogor, Jawa Barat",
    "(0251) 7532348",
    "Air demineral, Air mineral, air mineral alami, biskuit, Kopi Instan, Mi Instan, Minyak Goreng Sawit, Susu Bubuk, Susu Kental Manis, Tepung Terigu Sebagai Bahan Makanan, Mainan, Mainan Berbahan Tekstil, Tekstil, Beras, Garam Konsumsi Beriodium, Jagung, Jagung - Bahan Pakan Ternak, Kedelai, Pangan Olahan jagung dan Kedelai (Sampel sedikit mengandung gula, lemak, minyak, dan cokelat : susu bubuk kedelai; Sampel banyak mengandung gula : gula jagung, kecap; Sampel mengandung lesitin, lemak atau minyak : minyak jagung, lesitin), Tempe, Biji Kopi, Kopi Bubuk, Kopi Celup, Kopi Gula Krimer, Kopi Gula Susu Dalam Kemasan, Kopi Mix, Minuman Kopi Dalam Kemasan, Madu, Keju Olahan, Keju Cheddar Olahan, Cokelat Butir, Kakao Bubuk, Kecap Kedelai Asin, Kecap Kedelai Manis, Kembang Gula / Permen Lunak, Bubuk Whey &amp; Produknya, Kecuali Keju Whey, Campuran Susu &amp; Krim Bubuk Berperisa (tergantung jenis perisanya), Campuran Susu &amp; Krim Bubuk Plain, Formula Bayi, Minuman Berbasis Susu yang Berperisa, Minuman Susu Fermentasi Berperisa, Lassi, Minuman Yogurt Berperisa, Susu diasamkan, Susu diasamkan rendah lemak, Susu diasamkan tanpa lemak, Susu fermentasi, Susu fermentasi tanpa lemak, Susu fermentasi rendah lemak, Yogurt, Susu Bubuk Berlemak (Full Cream), Susu Bubuk Berlemak Instan, Susu Bubuk Rendah Lemak dan Susu Bubuk Kurang Lemak, Susu Kental Manis Lemak Nabati/ Susu, Krim Kental Manis, Krimer Kental Manis, Khoa Kental Manis Minyak Nabati, Susu, Susu Segar, Susu Pasteurisasi, Susu UHT, Susu Steril, Susu Rendah Lemak, Susu Rekonstitusi, Susu Rekombinan, Bubuk Whey, Es krim, Susu Bubuk Berlemak/Full cream, Susu Cair, Minyak Goreng, Minyak Sayur, Minyak Salad, Minyak Samin, Lemak Reroti, Pengganti Minyak Mentega, Minyak Kelapa Sawit Mentah (CPO), Minyak Inti Kelapa Sawit Mentah (CPKO), Minyak Inti Kelapa Sawit (RBDPKO), Minyak Kelapa Sawit (RBDPO), Minyak Stearin Kelapa Sawit, Minyak Stearin Kelapa Sawit Mentah, Produk Emulsi Lemak yang Kadar Lemaknya Tidak Kurang dari 80%, Minyak sayur, Virgin oil, Margarin, Es untuk Dimakan (Edible Ice), Es stik, Ice flake, Jem Buah atau Selai Buah, Jeli Buah, Produk Buah Untuk Isi Pastri, Marmalad Sitrus Chutney Mangga, Sambal Buah Buah Bergula, Buah Berkristal, Kulit Buah Bergula, Bubur Buah, Puree Buah, Pasta Buah, Saus Buah, Saus Apel, Topping Buah, Nata De Coco Utuh Tidak Siap Konsumsi, Konsentrat Asam Jawa, Bubuk Asam Jawa, Toffee Asam Jawa, Bars Buah, Tepung Buah, Sayur Dalam Kemasan, Tomat Dalam Kemasan, Jagung Manis Dalam Kemasan, Jamur Dalam Kaleng, Asparagus Dalam Kaleng, Wortel Dalam Kaleng, Rebung Bambu Dalam Kaleng, Sayur Kering, Cabe Kering, Jamur Kering, Rumput Laut Kering, Nori, Sayur Asin Kering, Kacang Kering dan Polong Kacang Kering, Sayur Segar, Buah Segar, Buah Dalam Kemasan,Selai Buah, Puree Buah, Keripik Pisang, Kentang Beku, Kacang Tanah, Selai Kacang, Kimchi, Kakao Bubuk Untuk Sarapan, Bubuk Kakao dengan Lemak Sedang, Bubuk Kakao Rendah Lemak, Kakao Bubuk, Kakao Bubuk Sangat Halus (Cocoa Fineness), Nib Kakao, Kembang Gula Keras / Permen Keras, Massa Kakao dan Cairan Kental (Liquor) Cokelat, Keik Kakao (Cocoa Press Cake), Minuman Kakao (Drinking Cocoa), Minuman Cokelat (Drinking Chocolate), Cokelat Instan, Coklat butir, Coklat Drop, Coklat Pasta, Permen Lunak bukan Jely, Biji-bijian Utuh, Makanan Pendamping ASI (MP ASI), MP ASI Bubuk Instan, MP ASI Siap Santap, MP ASI Siap Masak, MP ASI Biskuit, Makaroni, Mi Kering Gandum, Mi Kering Lainnya, Bihun Instan, Kuetiaw Instan, Makaroni, Instan, Mi Basah Matang, Nasi Instan, Bubur Serealia Instan, Sohun, Bihun, Pasta dan Mi Pra-Masak Serta Produk Sejenis, Sereal Olahan, Tepung Terigu Self-Raising, Tepung Terigu Terklorinasi, Tepung Terigu dengan Penambahan Protein, Tepung Terigu Utuh (Wholemeal Wheat Flour), Pasta Kering /Spagetti, Minuman Serbuk Kedelai, Biskuit (Manis) atau Kukis atau Sweet Crackers, Biskuit Marie, Biskuit Marie Salut, Roti Bagelen, Biskuit Lapis, Biskuit Stik Colek, Keik (Cake), Kukis (Cookies) dan Pai (Pie), Keik Mentega (Butter Cake), Keik Keju (Cheese Cake), Keik Pound (Pound Cake atau Quatre Quarts), Pai Apel, Roti Bagelen Pisang, Wafer, Wafer Roti, Wafer Salut, Kukis, Kukis Gula, Kukis Oatmeal, Bika Ambon, Serabi, Pukis, Kue Cucur, Cerabikang, Cakue, Kue Bantal, Kue Ape, Egg Roll, Produk Bakeri Istimewa Lainnya (Misalnya Donat, Roll Manis, Scones, Dan Muffin), Roti Buah/Roti Kismis, Roti Diperkaya, Roti Kadet (Roll), Roti Tawar, Roti Putih, Roti Tawar Kupas, Roti Susu, Roll Susu, Bun Susu, Roti Wheat Germ, Roti Meal, Roti Meal Utuh (Whole Meal), Roti Gandum Utuh (Whole Wheat), Roti Rye, Roti Pumpernickel, Premix Cake, Daging Olahan Khas Indonesia, Ham Sapi (Daging Paha Sapi Kuring) Matang, Bahu Sapi Kuring Matang, Daging Ayam Yang Dikalengkan, Potongan Daging Yang Direbus Dalam Kecap (Tsukudani), Daging Olahan Khas Indonesia Berbentuk Potongan, Produk Daging Yang Dilapis Dan Dimarinasi (Coated And Marinated Meat Products), Daging Kuah Dalam Kemasan, Daging Dalam Kaleng (Tanpa Kuah), Daging Cincang Kuring Matang, Daging, Daging Unggas Dan Daging Hewan Buruan Yang Dihaluskan, Diolah Dan Dibekukan, Dan Diolah Dengan Perlakuan Panas, Abon, Kornet, Bakso daging, Ikan dan Produk Perikanan Awet, Ikan Segar, Ikan, Filet Ikan dan Produk Perikanan Meliputi Moluska, Krustase dan Ekinodermata yang Dibekukan Udang beku, Kerupuk Udang, Telur Cair Utuh, Telur Segar, Tepung custard, Gula dan Sirup Lainnya, Gula Kristal Putih, Bawang Putih, Bawang Merah (Shallot), Bawang Batak, Biji Seledri, Biji Sawi/Biji Mustard, Biji Sawi Bubuk atau Biji Mustard Bubuk, Cabe Jawa, Cabe Merah Segar, Bubur Cabe, Cabe Bubuk, Biji Dill (Dill Seed), Adas Manis, Adas Sowa, Adas Cina, Ender, Dill Weed, Fenugreek, Kelabat, Kelabet, Klabat, Fenugreek Bubuk, Kelabat Bubuk, Kelabe Bubuk, Klabat Bubuk, Fuli Kering, Fuli Bubuk, Jahe Segar, Jahe Kering, Bubur Jahe, Jahe Bubuk, Jintan/Caraway, Jintan Bubuk, Jintan Manis, Jintan Hitam, Jintan Hitam Bubuk, Jintan Putih, Cumin, Jintan Putih Bubuk, Kapulaga, Biji Kapulaga, Kapulaga Lokal, Kapulaga (Cardamom) Amomum, Biji Kapulaga (Cardamom) Amomum, Kapulaga Bubuk, Kapulaga (Cardamom) Amomum Bubuk, Kayu Manis, Kayu Manis Bubuk, Kemiri Dengan Tempurung, Kemiri, Kemiri Bubuk, Kencur, Kencur Bubuk, Ketumbar, Daun Ketumbar, Ketumbar Bubuk, Picung, Kluwek, Kunyit, Kunyit Bubuk, Lada Hitam, Lada Hitam Bubuk, Lada Putih, Lada Putih Bubuk, Lada Bubuk Campuran, Andaliman, Lengkuas/Laos, Lengkuas/Laos Bubuk, Kecombrang/Sambung/ Kencong, Marjoram, Mint, Onion / Bawang Bombay, Onion Bubuk /Bawang Bombay Bubuk, Oregano, Pala, Pala Untuk Destilasi, Pala Bubuk, Parsley, Paprika Bubuk, Sweet Paprika Bubuk, Rosemari, Saga, Saffron, Pekak / Bunga Lawang /Star Anise, Temu Kunci, Tarragon, Thymi / Thyme, Bumbu Ekstrak Daging Sapi, Bumbu Rasa Sapi, Bumbu Ekstrak Daging Ayam, Bumbu Rasa Ayam, Bumbu Pasta Ekstrak Daging, Kecap Kedelai Asin Non Fermentasi/Hidrolisat, Kecap Asin (Salty Soy Sauce), Pasta Tomat, Bubur (Pulp) Tomat, Bubur (Pulp) Horseadish, Ekstrak Aloe, Salsa, Saus Cabe, Sambal Kecap /Saus Sambal Kecap, Saus Sambal Cabe Hijau, Sambal, Sambal Siap Dikonsumsi, Saus Protein Nabati Terhidrolisis, Saus Campuran Protein Nabati Terhidrolisis, Saus Kedelai Fermentasi, Mayonaise, Kecap manis, Formula bayi, Suplemen Pangan, Formula bayi prematur, Air Minum Dalam Kemasan (AMDK), Air Bermineral, Air Soda, Air Minum Beroksigen, Air Minum Bervitamin, Air Minum Heksagonal, Kopi Cair Konsentrat, Premiks Kopi, Kapucino, Minuman Elektrolit Berkarbonat, Minuman Hipotonik Berkarbonat, Minuman Isotonik Berkarbonat, Minuman Hipertonik Berkarbonat, Minuman Dasar Elektrolit Berkarbonat, Serbuk Minuman Berkarbonat, Minuman Berkafein Formulasi, Minuman Berperisa, Ginger Ale, Sarsaparilla, Root Beer, Birch Beer, Soda Krim (Cream Soda), Minuman Citrus, Minuman Kola, Limun, Punches/Ades, Crush, Cordials, Minuman Sari Buah, Minuman Rasa Buah, Sirup Berperisa, Sirup Buah, Sirup Cokelat, Sirup Karamel, Sirup Kopi, Air Berperisa, Squash, Squash Berperisa, Lemonade dan \x{2018}Fruit-Ades\x{2019} Lainnya, Serbuk Minuman Berperisa, Serbuk Minuman Rasa Jeruk, Minuman Elektrolit Tidak Berkarbonat, Minuman Hipotonik Tidak Berkarbonat, Minuman Isotonik Tidak Berkarbonat, Minuman Hipertonik Tidak Berkarbonat, Minuman Dasar Elektrolit (Electrolyte Drinks Base) Tidak Berkarbornat, Minuman Asam Jawa, Iced Tea, Iced Tea Instan, Minuman Nira, Minuman Mengandung Jeli, Nata De Coco Dalam Minuman, Sari Buah, Sari Buah Campuran, Sari Jeruk Nipis (Lime Juice), Sari Buah Apel, Sari Buah Jeruk Besar (Grapefruit Juice), Sari Buah Jeruk Orange, Valencia, Sari Buah Jeruk Siam, Tangerine, Minuman Citrus Comminutes, Sari Buah Nanas, Sari Buah Lemon, Sari Buah lainnya, Teh Hitam, Teh Hijau, Teh Putih, Teh Wangi, Teh Wangi Tradisional, Teh Olong atau Teh Semi Fermentasi, Teh Hijau Bubuk, Teh Kering Dalam Kemasan, Teh Hitam Celup, Teh Wangi Celup, Teh Hijau Celup, Minuman Teh Dalam Kemasan, The Instan, Teh Cair Konsentrat, Premiks Teh, Minuman Beralkohol yang diberi Aroma, Minuman Perisa Buah, Minuman Isotonik, Minuman Serbuk Perisa, Makanan Ringan Berbahan Dasar Kentang, Umbi, Serealia, Tepung atau Pati, Makanan Ringan (Ekstrudat), Kacang Atom, mie, bubur instan, nasi goreng, Mi Kuah, Sayur Kuah, Sop, dan Soto, biji pala, Bahan Baku Tambahan Pangan Pewarna, Pangan Flavor, Sosis, Agar-agar, Tepung Terigu, Sambal, Susu Bubuk, Minuman Sari Kedelai, Makanan Ikan Kaleng, Cookies, Wafer, Keripik, Roti Kering, Biskuit, air cooling tower, air bersih, air hemodialisa, air limbah, air WFI, Bahan Baku Farmasi, Obat, Suplemen, Obat Tradisional (sediaan padat, cair, dan semi padat), kapsul gelatin, Kosmetik (Bedak tabur, Bedak compact, Bedak compact, Lipstik, Eye shadow, Krim salep, Toner (pembersih wajah), Gel Rambut, Shampo, Sabun, Hairspray, Krim malam, Foundation /Alas Bedak, Lotion, Sabun cair, Sabun cuci tangan, Sabun padat), desinfektan, sanitary napkin, bahan baku asam askorbat, bahan baku TiO2, talcum powder, pakan ternak, mainan anak, crayon, Buah Kering, Buah Kering Campur, Buah Kering Asin, Sale Pisang, Buah Asin, Gelatin Bubuk; Saus Panggang/Saus Barbekue (BBQ Sauce), Saus Pizza, Saus Spagheti (Spaghetti Sauce), Saus Tiram, Saus Perendam / Saus Marinasi (Marinated Sauce), Pupuk NPK, Gula kristal rafinasi, Masker dari Kain, Masker Medis, Bahan Baku Dipotassium Hydrogen Phospate, Bahan Baku Asam Mefenamat, Bahan Baku Sodium Bikarbonat, Selenium yeast, Kacang garing, Alas kaki berbahan karet, Bedcover, Kasur Pegas, Selimut, Lotion antinyamuk, Pembalut, Popok bayi, Bahan Baku Monosodium Glutamat, Air Permukaan, Air Tanah, Tablet Medicine, Handrub, Handwash, Produk untuk membersihkan di tempat, Basic dressing set, Benang jahit luka, Blood Transfusion Set, Foley Catheter, Infusion set, Jarum suntik, Kantung air seni, Kantung darah, Kasa Steril, Lensa kontak, Sarung tangan bedah, Selang infus, Suction Catheter with Thumb Control, Wing needle, Swab Test Peralatan, Cawan kontak dinding, Tissue basah, Hydrolised Vegetable Protein (HVP), Texturized Vegetable Protein (TVP), Bor listrik, Catok Rambut Listrik, Dispenser (Water Dispenser), Gergaji Listrik, Gerinda Listrik, Oven Listrik Portabel (Electrical Portable Oven), Pelumat (Blender), Pemanggang Roti Listrik (Toaster), Pemroses Makanan Listrik (Electrical Food processor), Penanak Nasi (Rice Cooker), Pencampur (Mixer), Pencukur Listrik, Juicer, Penghisap Debu (Vacuum Cleaner), Teko Listrik (Electric Kettle), Microwave Oven, Obat sirup, Larutan sorbitol",
    "17/01/2026",
    "",
  ],
  [
    "LP-185-IDN",
    "Yes",
    "PT Djarum",
    "Desa Bakalan, Krapyak, Kudus 59332",
    "(0291) 431494",
    "Rokok putih, rokok kretek",
    "28/04/2025",
    "",
  ],
  [
    "LP-186-IDN",
    "Yes",
    "UPT Laboratorium Pengujian Konstruksi Dinas Pekerjaan Umum Bina Marga Jawa Timur",
    "Jl. Ngampelsari No. 100, Kec. Candi Sidoarjo, Kab. Sidoarjo, Surabaya, Jawa Timur",
    "(031) 99712671",
    "Aspal keras, Tanah dan Batuan, Agregat kasar, Agregat halus, Agregat kasar dan agregat halus, Beton, Campuran Aspal, Tanah Lempung dan Lanau",
    "06/08/2026",
    "",
  ],
  [
    "LP-188-IDN",
    "Yes",
    "Balai Besar Pengawas Obat dan Makanan di Palembang",
    "Jl. Pangeran Ratu Seberang Ulu 1, Jakabaring, Palembang 30352",
    "(0711) 510126",
    "Obat/terapetik : tablet, suspensi, kapsul, krim, injeksi, Napza",
    "29/04/2027",
    "",
  ],
  [
    "LP-189-IDN",
    "Yes",
    "Departemen Teknik Lingkungan, Fakultas Teknik Sipil dan Lingkungan, Institut Teknologi Bandung (ITB) - Laboratorium Air",
    "Jl. Ganesha 10, Bandung, Jawa Barat",
    "(022) 2534176",
    "Air untuk keperluan higiene dan sanitasi, air minum, air sumur, air danau, air sungai, mata air, air limbah",
    "04/06/2027",
    "",
  ],
  [
    "LP-190-IDN",
    "Yes",
    "PT Geoservices Banjarbaru",
    "Lokasi 1: Jl. A. Yani No. 8 Km. 33, Loktabat, Banjarbaru, Kalimantan Selatan Lokasi2: Jl. A. Yani Km. 95, Tatakan Rantau, Sungai Putting, Kalimantan Selatan Lokasi 3: Jl. Haul Road Adaro KM.0, Desa kelanis, Kec. Mangkatip, Kab. Barito Selatan, Kalimantan Selatan Lokasi 4: Site PT Maruwai Coal, Ds Muara Tuhup, Kec. Laung Tuhup, Kab. Murung, Kalimantan Tengah Lokasi 5: Site PT Maruwai Coal, Ds. Tumbang Baloi, Kec. Laung Tuhup, Kab. Murung Raya, Kalimantan Tengah",
    "(0511) 4772612",
    "Batubara",
    "22/11/2026",
    "",
  ],
  [
    "LP-191-IDN",
    "No",
    "",
    "",
    "",
    "",
    "",
    "Nomor akreditasi digabung dengan LP-578-IDN</strong></p>",
  ],
  [
    "LP-193-IDN",
    "Yes",
    "Balai Besar Pengawas Obat dan Makanan di Medan",
    "Jl. Willem Iskandar Pasar V Barat I No. 2, Medan Estate, Medan, Sumatera Utara",
    "(061) 6628363",
    "I. Produk terapetik",
    "25/07/2026",
    "",
  ],
  [
    "LP-194-IDN",
    "Yes",
    "Special Quality Assurance Laboratory, PT Nestle Indonesia - Kejayan factory",
    "Jl. Raya Pasuruan \x{2013} Malang Km. 9,5, Tembero, Kejayan, Pasuruan 67172",
    "(0343) 421005",
    "Susu bubuk susu segar, knental manis, susu UHT, susu Pasteurisasi, susu sterilisasi, kopi bubuk, kopi, kopi UHT, Maltodextrin, cereal powder, bumbu penyedap",
    "26/12/2025",
    "",
  ],
  [
    "LP-195-IDN",
    "Yes",
    "PT Unilab Perdana",
    "Jl. Ciledug Raya No. 10 Cipulir Kebayoran Lama, Jakarta Selatan, DKI Jakarta",
    "(021) 7253322",
    "Air limbah, air sumur, air danau, air sungai, air waduk, air muara, air untuk keperluan higiene sanitasi, air kolam renang, air minum, air minum dalam kemasan/AMDK (air mineral, air demineral), air reverse osmosis, air laut, biota, lumpur, tanah, sedimen, udara ambien, kebisingan, lingkungan kerja, udara emisi tidak bergerak, emisi gas buang kendaraan bermotor",
    "15/03/2025",
    "",
  ],
  [
    "LP-196-IDN",
    "Yes",
    "PT Bentoel Prima",
    "Jl. Raya Karanglo Lt 1, Kel. Banjararum, Kec. Singosari , Kabupaten Malang, Jawa Timur 65153",
    "(0341) 490000",
    "Rokok, Rokok putih dan kretek (White and kretek cigarettes), kertas tipping, filter rod, rokok buatan mesin (SKM, SPM), foil, flip, filter,Tembakau (tunggal atau campuran) dan tembakau blend tanpa flavor, Cairan sigaret elektrik (E-Liquid), Aerosol sigaret elektrik (E-vapour)",
    "28/04/2025",
    "",
  ],
  [
    "LP-197-IDN",
    "No",
    "",
    "",
    "",
    "",
    "",
    "Nomor digabung dengan LP-608-IDN</strong>",
  ],
  [
    "LP-199-IDN",
    "Yes",
    "Balai Besar Pengawas Obat dan Makanan di Makassar",
    "Jl. Bajiminasa No. 2, Makassar, Sulawesi Selatan",
    "(0411) 872021",
    "Terapetik: tabet, kapsul, suspensi oral, larutan oral",
    "22/11/2026",
    "",
  ],
  [
    "LP-204-IDN",
    "Yes",
    "PT Bureau Veritas Consumer Products Services Indonesia",
    "Lokasi 1: Jl. Cideng Timur 38, Gedung KKM Lt. 2, Jakarta Lokasi 2: Jl. Daan Mogot Km 21 No. 1, Pergudangan Era Prima Blok H11, Tangerang",
    "(021) 63488777",
    "Handuk, Tekstil , Corrugated Board / Carton, Toys / Mainan safety for toys - part 2 : flammability (uji ketahanan api), Toys / Mainan (textile/non textile), Furniture - Kasur Bayi (Baby Crib), Meja salin (changing table), Kasur susun (bunk bed) , produk anak-anak, maupun dewasa, Lemari (Cabinet/Dresser), Furniture accessories - Anti Tip Kit, Coating furniture, Footware, Jewelry, Leather, Metal and Ophthalmic Optics, Polymer of ethylene and ethylene-vinyl acetate (EVA) copolymers, Sludge, Substrate, Waste Water, Terminal GPRS, Pesawat Telepon GSM, Bluetooth, Wireless Local Area Network (WLAN), LTE, Low Power, SRD, Digital Video Broadcasting-Terrestrial Second Generation (DVB-T2): Television, Set to box, Handy talky, Kursi, Meja",
    "30/06/2025",
    "",
  ],
  ["LP-205-IDN", "No", "", "", "", "", "", "Nomor Akreditasi dicabut"],
  [
    "LP-206-IDN",
    "Yes",
    "Deputi Bidang Infrastruktur Riset dan Inovasi - Direktorat Pengelolaan Laboratorium, Fasilitas Riset dan Kawasan Sains Teknologi Keselamatan dan Metrologi Radiasi - BRIN",
    "Jl. Lebak Bulus Raya No. 49, Jakarta Selatan, DKI Jakarta",
    "(021) 7513906",
    "Radioaktif pada: Bahan pangan, air, biota, susu, tanah dan sedimen, bahan bangunan, filter udara, udara, NORM/TENORM, dosimeter termoluminesensi (TLD), dosimeter OSL, tempat sumber radioaktif, kamera radiografi, bungkusan zat radioaktif tipe A, bungkusan zat radioaktif tipe B, Aprom, beton, gipsum, pesawat sinar x radiografi (umum/mobile, gigi intraoral, gigi panoramik, mammografi, fluoroskopi, CT-scan)",
    "24/04/2026",
    "",
  ],
  [
    "LP-207-IDN",
    "Yes",
    "UPT Laboratorium Terpadu Universitas Sebelas Maret",
    "Jl. Ir. Sutami 36 A Kentingan, Surakarta, Jawa Tengah",
    "(0271) 663379, 632354",
    "Air untuk keperluan higiene dan sanitasi, air sungai, air limbah, udara ambien, Kebisingan, Lingkungan Kerja, AMDK (Air Minum dalam Kemasan), Panili",
    "25/07/2026",
    "",
  ],
  [
    "LP-208-IDN",
    "Yes",
    "Sumatera Tobacco Trading Company",
    "Jl. Siantar No. 3-5, Medan, Sumatera Utara (lokasi 1) Jl. Pdt. Dr. Justin Sihombing No. 43, Pematang Siantar, Sumatera Utara (lokasi 2)",
    "(061) 4515214",
    "Rokok putih (main stream), rokok kretek (main stream), tembakau",
    "25/07/2026",
    "",
  ],
  [
    "LP-209-IDN",
    "Yes",
    "Pusat Higiene Perusahaan, Kesehatan dan Keselamatan Kerja",
    "Jl. Jend. A. Yani No. 69/70 Cempaka Putih, Jakarta Pusat, DKI Jakarta",
    "(021) 42878913",
    "Tempat kerja, ambien, udara ambien, udara lingkungan kerha, emisi sumber tidak bergerak",
    "03/04/2026",
    "",
  ],
  [
    "LP-213-IDN",
    "Yes",
    "Balai Standardisasi dan Pelayanan Jasa Industri Surabaya",
    "Jl.Jagir Wonokromo 360 Surabaya, Jawa Timur",
    "(031) 8410054",
    "setrika listrik, pompa air listrik, kipas angin, Kipas Angin Meja, Kipas Angin Tumpu, Kipas Angin dinding - Kinerja dan konstruksi, mesin cuci, lemari pendingin, mesin dapur, pemanas cairan, audio video, audio video (EMC), produk pembunuh serangga (insect killer product), Peralatan Rumah tangga, alat listrik, dan peralatan sejenis (household appliances, electric tools and similar apparatus), produk pencahayaan listrik (electrical lighting), peralatan teknologi industri (information technology equipment), produk multimedia (multimedia equipment), handphone, Peralatan Teknologi Informasi, Vacuum Cleaner, Microwave Oven, Piranti Pijat listrik, Pemanas air sesaat, Bor Listrik, Gerinda, Mesin poles, dan pengampelas jenis cakram, Mesin Serut (planer), Gergaji, lampu swabalast untuk pelayanan pencahayaan umum (uji keselamatan, uji kinerja), Lampu LED swa-balast untuk layanan pencahayaan umum dengan tegangan &gt; 50V (uji keselamatan, uji kinerja), aki kendaraan bermotor roda empat atau lebih, aki kendaraan bermotor kategori L, Oven, Penanak Nasi, Televisi, Luminer, Sel dan baterai sekunder untuk penyimpanan energi terbarukan, Showcase, mainan anak, Low Power Devices, Bluetooth 2.4 GHz Devices, WLAN 2.4GHz Devices, WLAN 5.8GHz Devices, baja tulangan beton canai ulang, baja tulangan beton dalam bentuk gulungan, kawat baja karbon rendah, kawat bronjong, bronjong kawat, lembaran serat kritosil semen rata, baja lembaran lapis seng, genteng keramik, baja profil siku sama kaki proses canai panas, baja lembaran dan gulungan canai dingin, baja profil kanal U proses canai panas, baja lembaran, pelat, dan gulungan canai panas, baja lembaran dan gulungan lapis paduan aluminium - seng, baja profil I-beam proses canai panas, Baja Profil Kanal WF-Beam Proses Canai Panas, tali kawat baja untuk minyak dan gas bumi, tali kawat baja, kompor gas LPG satu tungku dengan sistem pemantik mekanik khusus untuk usaha mikro, baja batangan untuk keperluan umum, regulator tekanan tinggi untuk tabung baja LPG, kompor gas bahan bakar LPG satu tungku dengan sistem pemantik, regulator tekanan rendah untuk tabung baja LPG, baja profil H (Bj P H-beam), kompor gas tekanan rendah jenis dua dan tiga tungku dengan sistem pemantik, pipa baja saluran air dengan atau tanpa lapisan seng, genteng beton, bata beton, baja tulangan beton, Baja tahan karet canai dingin bentuk lembaran dan gulungan (Bj TK D), batang kawat baja karbon rendah, profil rangka baja ringan, Kompor Gas LPG dan LNG / NG Untuk Komersil, biskuit, Air Mineral, Air demineral, garam konsumsi beryodium, garam bahan baku untuk garam konsumsi beryodium, tepung terigu sebagai bahan makanan, asam sulfat teknis, Pupuk fosfat, aluminium sulfat, pupuk NPK, pupuk dolomit, Minyak goreng sawit, air limbah, air untuk keperluan higiene sanitasi, air minum, Air sungai, Lingkungan Kerja, udara ambien, udara emisi sumber tidak bergerak",
    "26/02/2028",
    "",
  ],
  [
    "LP-216-IDN",
    "No",
    "",
    "",
    "",
    "",
    "",
    "Nomor dilgabung dengan LP-163-IDN",
  ],
  [
    "LP-217-IDN",
    "Yes",
    "Balai Hidrologi dan Lingkungan Keairan",
    "Jl. Ir. H. Juanda 193, Bandung 40135",
    "(022) 2503357",
    "Air permukaan (Air Sungai, air danau/waduk), air limbah, air tanah",
    "27/01/2028",
    "",
  ],
  [
    "LP-218-IDN",
    "Yes",
    "Balai Besar Pengawas Obat dan Makanan di Pontianak",
    "Jl. Dr. Soedarso, Pontianak-78124",
    "(0561) 572417",
    "Terapetik : sediaan tablet, serbuk injeksi",
    "17/12/2024",
    "",
  ],
  [
    "LP-220-IDN",
    "Yes",
    "UPT Pengujian dan Sertifikasi Mutu Barang Medan",
    "Jl. STM No. 17 Kampung Baru, Medan, Sumatera Utara",
    "(061) 7862040",
    "Biji kakao, biji kopi, minyak daun cengkeh, minyak kenanga, minyak sereh, minyak nilam, minyak pala, minyak akar wangi, minyak fuli, gabah, jagung, beras, lada putih, crude palm oil, pala, garam konsumsi beryodium, tepung terigu sebagai bahan makanan, Cassia Indonesia, Standard Indonesian Rubber (SIR), plastik bandela, karet konvensional, biji pinangn bukan untuk obat",
    "21/03/2026",
    "",
  ],
  [
    "LP-221-IDN",
    "Yes",
    "Services Laboratory SEAMEO BIOTROP",
    "Jl. Raya Tajur Km. 6, Kel. Pakuan, Kec. Bogor Selatan, Bogor",
    "(0251) 8357175",
    "Udara ambien, kebisingan lingkungan, udara emisi sumber tidak bergerak, air limbah, air untuk higiene dan sanitasi, air permukaan (air sungai, air danau), kacang tanah dan produk olahannya, jagung dan produk olahannya, tanah mineral",
    "13/12/2025",
    "",
  ],
  [
    "LP-224-IDN",
    "Yes",
    "PT Equilab International",
    "Jl. RS Fatmawati Persil 33, Cilandak, Jakarta Selatan",
    "(021) 7695513",
    "Plasma darah dan darah, obat sirup tradisional, kembang gula keras, sosis daging",
    "26/02/2026",
    "",
  ],
  [
    "LP-225-IDN",
    "Yes",
    "PT Carsurin Tanah Merah",
    "Site PT Kideco Jaya Agung, (TMCT Central Laboratory, Port Area Tanah Merah Coal Terminal), Kalimantan Timur",
    "(0543) 23304",
    "Batubara",
    "05/06/2026",
    "",
  ],
  [
    "LP-226-IDN",
    "Yes",
    "Balai Besar Inseminasi Buatan Singosari",
    "Desa Toyomarto, Kec. Singosari, Kab. Malang, Jawa Timur",
    "(0341) 458359; 454331",
    "Semen segar sapi, semen cair sapi, semen beku sapi, semen segar kambing, semen cair kambing, semen beku kambing",
    "21/08/2024",
    "",
  ],
  ["LP-227-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  [
    "LP-228-IDN",
    "Yes",
    "Balai Besar Karantina Ikan Pengendalian Mutu dan Keamanan Hasil Perikanan Jakarta I",
    "Gedung Karantina Pertanian Bandara Soekarno, Kabupaten Tangerang, Banten",
    "(021) 5507932",
    "Ikan air tawar dan Ikan air laut (termasuk ikan hias), Ikan dan krustacea (udang dan kepiting), katak, Produk perikanan (ikan dan",
    "18/11/2028",
    "",
  ],
  [
    "LP-229-IDN",
    "Yes",
    "PT Mattel Indonesia, QA Laboratory",
    "Jl. Industri Utama Blok SS Kav. 1-3, Kawasan Industri Jababeka, Desa Mekar Mukti Cikarang Utara, Bekasi, Jawa Barat (lokasi 1 - East Plant) Jl Jababeka V Blok G 4-6, Kawasan Industri Jababeka, Desa Harja Mekar, Cikarang Utara, Bekasi, Jawa Barat (lokasi 2 - West Plant)",
    "(021) 89839300",
    "Toys/mainan anak",
    "18/10/2025",
    "",
  ],
  [
    "LP-230-IDN",
    "Yes",
    "Balai Besar Pengawas Obat dan Makanan di Pekanbaru",
    "Jl. Diponegoro No. 10, Pekanbaru, Riau",
    "(0761) 21496",
    "Terapetik dan NAPZA : kapsul, tablet, sirup, suspensi oral, larutan, krim, injeksi, tetes telinga, tetes mata",
    "18/12/2027",
    "",
  ],
  [
    "LP-231-IDN",
    "Yes",
    "UPTD Laboratorium Lingkungan, Dinas Lingkungan Hidup dan Pertanahan Provinsi Sumatera Selatan",
    "Jl. Aerobik No. 4 Kampus POM IX Palembang 30137",
    "(0711) 359974",
    "Air sungai, air danau, air rawa, air limbah, air untuk keperluan hygiene sanitasi, tanah, lumpur, B3, udara ambien, kebisingan, emisi tidak bergerak, emisi bergerak, Udara lingkungan kerja",
    "18/12/2027",
    "",
  ],
  [
    "LP-232-IDN",
    "Yes",
    "Balai Besar Pengawas Obat dan Makanan di Manado",
    "Jl. Raya Manado \x{2013} Tomohon Km. 7, Pineleng \x{2013} Sulawesi Utara 95361",
    "(0431) 824686; 824210; 824327",
    "Terapetik : Sediaan tablet, sediaan sirup",
    "23/04/2024",
    "",
  ],
  [
    "LP-233-IDN",
    "Yes",
    "Balai Besar Laboratorium Kesehatan Palembang",
    "Jl. Inspektur Yazid No.2, Km. 2,5 Palembang, Sumatera Selatan",
    "(0711) 352683",
    "Air, air bersih dan air limbah, Disinfektan",
    "21/08/2024",
    "",
  ],
  [
    "LP-235-IDN",
    "Yes",
    "Balai Besar Kerajinan dan Batik",
    "Jl. Kusumanegara No. 7, Yogyakarta",
    "(0274) 546111",
    "Tekstil, Batik, Batik tulis, Batik Cap , Batik Kombinasi , Pakaian Jadi, Tekstil dan poduk tekstil, Handuk mandi, Barang-barang emas , Barang-barang perak, Bola sepak, Bola voli, Bola basket, Bola tenis meja, Raket bulu tangkis, Bola bulu tangkis, Lembing, Peluru tolak peluru, Cakram, Bola sepak takraw, Raket tenis meja, Jaring sepak takraw, Jaring bola volley, Jaring bulu tangkis, Jaring tenis meja, Jaring sepak bola, Meja tenis meja, Jaring Futsal, Papan pantul bola basket, Simpai (ring) bola basket, Gitar akustik klasik, Catur, Tongkat Estafet, Bola kasti, Pemukul bola kasti, Bola POA, Bola ayun besar/ kecil, Roket/ rudal, Gawangan aman, Petak lompat, Clapper, Bilah, Cones, Gelang raja, Tas POA, Kantong POA, Matras senam, Mainan anak, Ayunan, seluncuran dan mainan aktivitas sejenis untuk pemakaian di dalam dan di luar lingkungan tempat tinggal, Baju bayi",
    "20/03/2027",
    "",
  ],
  [
    "LP-237-IDN",
    "Yes",
    "PT Intertek Utama Services Cikini (multilokasi)",
    "Lokasi 1: Jl. Cikini IV No. 2, Gondangdia, Jakarta Pusat, DKI Jakarta Lokasi 2: Kawasan Industri Candi, Jl. Gatot Subroto Blok 27, No. 4, Semarang, Jawa Tengah",
    "(021) 3918584",
    "Pakaian bayi, Textile and textile products, footwear, masker kain, gaun bedah, toys and toys product, metals, print, paper, metal jewelry, ceramics, electronics, polymer, plastics, coating, leather, wood, outdoor chair, outdoor loungers, outdoor tables, indoor chair, indoor table, storage (indoor), office chair, office desk/table, office storage, moisture content, corrugated carton, metal compounds, domestic seating, bed and mattress, plastic for toys, fabrics for toys, paper metal wood for toys",
    "24/10/2026",
    "",
  ],
  [
    "LP-238-IDN",
    "Yes",
    "Balai Teknologi Termodinamika Motor dan Propulsi - BPPT",
    "Kawasan PUSPIPTEK, Gedung 230, Serpong, Tangerang \x{2013} Banten 15314",
    "(021) 7560539",
    "Mesin motor bakar (diesel silinder tunggal, road use vehicle, non automotive engine), kendaraan bermotor roda empat, motor listrik",
    "20/10/2024",
    "",
  ],
  [
    "LP-241-IDN",
    "Yes",
    "Balai Besar Teknik Kesehatan Lingkungan dan Pengendalian Penyakit (BBTKLPP) Surabaya",
    "Jl. Sidoluhur No. 12, Surabaya 60175, Jawa Timur",
    "(031) 3540189; 3540191",
    "Air minum, air bersih, air kolam renang, air sungai, air waduk, air limbah, air limbah (rumah sakit, domestik, klinik), udara lingkungan kerja, swab peralatan makan (piring, sendok, gelas, mangkok), Rectal, swab linen, alat operasi (gunting, scalpel, pinset), lantai, dinding, Makanan (sayuran, lauk pauk) dan minuman (teh, susu, jus, dll), kebisingan, lingkungan kerja, udara ambien, Limbah Padat (Tanah, Sludge, Padatan/Bloyong Kerak Evaporator), tanah,",
    "18/11/2027",
    "",
  ],
  [
    "LP-242-IDN",
    "Yes",
    "PT. SUCOFINDO Laboratorium Cabang Banjarmasin",
    "Lokasi 1 : Jl. A. Yani Km. 18,2 No. 238, Kayu Bawang, Kec. Landasan Ulin Barat, Banjarmasin, Kalimantan Selatan Lokasi 2 : Coal processing Barge loading km 0, PT Adaro Indonesia, kec. Dusun hilir, Kabupaten Barito selatan",
    "(0511) 3271080-83 (0526) 2091254",
    "Lokasi 1 : Batubara, crude palm oil (CPO), bijih besi, air minum,Air Untuk Kebutuhan Hygiene Sanitasi, Air Sungai, air limbah, udara ambien, kebisingan, Udara Emisi Sumber Tidak Bergerak",
    "26/02/2028",
    "",
  ],
  ["LP-243-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  [
    "LP-244-IDN",
    "Yes",
    "Balai Besar Pengawas Obat dan Makanan di Jayapura",
    "Jl. Otonom Kotaraja, Jayapura - Papua",
    "(0967) 5186333/5186777",
    "Terapetik : tablet, kapsul, suspensi, larutan, serbuk",
    "28/10/2024",
    "",
  ],
  [
    "LP-245-IDN",
    "Yes",
    "Balai Pengawas Obat dan Makanan di Kendari",
    "Kompleks Praja Bumi Anduonohu, Kendari, Sulawesi Tenggara",
    "(0401) 3195855",
    "Terapetik dan NAPZA : tablet, kapsul, sirup, cuplikan, injeksi, suspensi",
    "20/02/2027",
    "",
  ],
  [
    "LP-248-IDN",
    "No",
    "",
    "",
    "",
    "",
    "",
    "Nomor digabung dengan LP-258-IDN",
  ],
  [
    "LP-249-IDN",
    "Yes",
    "PT Gudang Garam",
    "Desa Sumbersuko, Gempol, Kab. Pasuruan, Jawa Timur",
    "(0354) 638888",
    "Rokok kretek, rokok putih",
    "05/09/2026",
    "",
  ],
  [
    "LP-250-IDN",
    "Yes",
    "PT Bridgestone Tire Indonesia",
    "Jl. Raya Bekasi Km. 27, Kel. Harapan Jaya, Bekasi Utara, Jawa Barat",
    "(021) 8840828",
    "Ban mobil penumpang (Rim: 10\", 12\", 13\", 14\", 15\", 16\", 17\", 18\", 19\"), ban truk ringan (Rim: 10\", 12\", 13\", 14\", 15\", 16\", 17\", 18\"), ban truk dan bus (Rim: 20\", 22.5\", 24\"), ban dalam kendaraan bermotor",
    "29/04/2027",
    "",
  ],
  [
    "LP-251-IDN",
    "Yes",
    "Balai Besar Teknik Kesehatan Lingkungan dan Pengendalian Penyakit Yogyakarta",
    "Jl. Imogiri Timur Km. 7,8, Grojogan, Wirokerten, Banguntapan, Kab. Bantul, Yogyakarta",
    "(0274) 371588",
    "Air minum, air bersih, air sungai, air danau, air waduk, air saluran, air mata air, air gua, air limbah, air kolam renang, air laut, usap, air haemodialisa, sedimen, sludge, tanah, lumpur/sedimen,usap, udara, udara ambien, pangan, usap, usap tenggorok/usap nasofaring, serum, nyamuk, kebisingan, udara ruang, jaringan daging ikan",
    "22/11/2026",
    "",
  ],
  [
    "LP-252-IDN",
    "Yes",
    "PT Riau Sakti United Plantations",
    "Km. 00, Desa Pulau Burung, Kec. Pulau Burung, Kab. Indragiri Hilir, Riau",
    "(0779) 541888",
    "Desicated coconut, canned coconut cream/milk, canned pineapple, pineapple juice concentrate, UHT coconut cream/milk, frozen coconut water concentrate, virgin coconut oil, Aseptic Coconut Water Single, Swab Test (personel, peralatan/equipment uniform)",
    "22/11/2026",
    "",
  ],
  [
    "LP-253-IDN",
    "Yes",
    "UPT Pengelola Penyelidikan, Pengujian dan Pengukuran Bina Marga, Dinas Bina Marga Provinsi DKI Jakarta",
    "Jl. D.I. Panjaitan Kav. 583, Cawang, Jakarta Timur 13410",
    "(021) 8194559",
    "Tanah, beton, jalan, aspal cement/aspal padat, agregat kasar (spleet, macadam, screening), agregat halus (abu batu), pasir (",
    "15/10/2024",
    "",
  ],
  [
    "LP-254-IDN",
    "Yes",
    "Laboratorium Cabang Sangatta, PT Sucofindo (Persero)",
    "Lokasi 1: Jl. AM Parikesit Road 9, Sangatta, Kab. Kutai Timut, Kalimantan Timur Lokasi 2: PIK Lubuk Tutung Port Site Coal Laboratory Desa Sekerat, Kec. Bengalon, Kab. Kutai Timur Lokasi 3 : Jl. Soekarno Hatta, Dusun Kalimaya, Desa Sempayau, Kec. Sangkulirang, Kab. Kutai Timur Lokasi 4 : Site PT Indexim Coalindo Kaliorang Port, Kec. Kaliorang, Kab. Kutai Timur, Kalimantan Timur",
    "(0549) 525120 ; (0549) 525213",
    "Lokasi 1: Batubara, air bersih, air minum, air limbah, fuel/solar, used oil",
    "23/05/2024",
    "",
  ],
  [
    "LP-255-IDN",
    "Yes",
    "PT Coca Cola Indonesia - Laboratorium Pabrik Konsentrat",
    "Jl. Raya Bogor - Jakarta Km. 38, Cilangkap, Depok, Jawa Barat",
    "(021) 28688101",
    "Propylene Glycol. Beverage Base, Water Treated",
    "29/04/2027",
    "",
  ],
  ["LP-256-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  [
    "LP-258-IDN",
    "Yes",
    "PT SUCOFINDO Laboratorium Cabang Samarinda (Multilokasi)",
    "Lokasi 1 : Jl. Teuku Umar No. 65 RT 60, Kelurahan Karang Asam, Samarinda, Kalimantan Timur 75126 Lokasi 2 : Unit Pelayanan - Jl. Pelita RT 02, Dondang Kecamatan Muara Jawa Kabupaten Kutai Kertanegara",
    "(0541) 6293771-4; 08125804753",
    "Lokasi 1 : Batubara, air limbah, air untuk keperluan higiene dan sanitasi, Air sungai, air minum, Emisi sumber tidak bergerak, Udara ambient, kebisingan, Minyak kelapa sawit (CPO), beton silinder, Baja tulangan beton, Agregat kasar, agregat halus, Tanah, batuan",
    "26/02/2027",
    "",
  ],
  [
    "LP-259-IDN",
    "Yes",
    "Balai Keselamatan Kerja Provinsi Jawa Tengah",
    "Jl. Ngesrep Barat III No. 44, Semarang, Jawa Tengah",
    "(024) 7474495",
    "Udara ambien, udara emisi sumber bergerak, udara emisi sumber tidak bergerak, lingkungan kerja",
    "22/05/2027",
    "",
  ],
  [
    "LP-260-IDN",
    "Yes",
    "PT Hartono Istana Teknologi",
    "Lokasi 1: Jl. Raya Semarang Demak Km. 9, Sayung, Jawa Tengah (Sublab Home Appliance) Lokasi 2: Jl. KHR. Asnawi PO Box 126, Kudus, Jawa Tengah (Sublab Elektronika &amp; RF)",
    "(024) 6592220 ; (0291) 433255",
    "Electric iron, Spin extractors, Washing machine, Kitchen machines (blender, juicer), Heating liquid, Refrigerator, freezer, Air conditioner, Electric fan, Commercial refrigerators, Rice cooker, Pesawat telepon seluler GSM, Pesawat telepon seluler WCDMA, Pesawat telepon seluler LTE, Wireless Local Area Network (WLAN), Perangkat Bluetooth, Receiver DVB-T2, Information technology equipment (ITE), Audio, video and similar electronic apparatus, Battery charger, Audio/video, information and communication technology, Low Power Wide Area (LPWA) non seluler, Television",
    "25/07/2026",
    "",
  ],
  [
    "LP-262-IDN",
    "Yes",
    "Balai Keselamatan dan Kesehatan Kerja Bandung",
    "Jl. Golf No. 34, Ujungberung, Bandung, Jawa Barat",
    "(022) 7800995",
    "Udara ambien, kebisingan, udara lingkungan kerja",
    "05/06/2026",
    "",
  ],
  [
    "LP-263-IDN",
    "Yes",
    "PT Goodyear Indonesia, Tbk",
    "Jl. Pemuda No. 27, Bogor 16161",
    "(0251) 8322071",
    "Ban mobil penumpang, ban truk ringan, ban truk dan bus",
    "24/09/2024",
    "",
  ],
  [
    "LP-264-IDN",
    "Yes",
    "Laboratorium Pengujian Baterai - PT GS Battery.",
    "Kawasan Industri Surya Cipta, Jl. Surya Utama Kav. 13 \x{2013} 14, Ciampel, Karawang, 41361",
    "(0267) 440961-64 Ext. 3310; 3311",
    "Aki untuk kendaraan bermotor roda empat atau lebih, Aki untuk kendaraan bermotor kategori L",
    "23/05/2024",
    "",
  ],
  ["LP-266-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  [
    "LP-268-IDN",
    "Yes",
    "Balai Besar Pengawas Obat dan Makanan di Samarinda",
    "Jl. Let. Jend. Soeprapto No. 3, Samarinda 75123",
    "(0541) 741630",
    "Terapetik (Tablet, kapsul, sirup, suspensi oral, larutan,tetes mata, krim, bedak tabur);",
    "22/07/2024",
    "",
  ],
  ["LP-269-IDN", "No", "", "", "", "", "", "Nomor Akreditasi dicabut"],
  [
    "LP-270-IDN",
    "Yes",
    "PT Sumi Rubber Indonesia",
    "Bukit Indah City Blok H Sektor 1A \x{2013} Indotaisei Industrial Estate, Cikampek 41373",
    "(0264) 351346; 351347",
    "Ban truk ringan, ban sepeda motor, ban mobil penumpang, ban truk dan bus",
    "18/12/2027",
    "",
  ],
  [
    "LP-272-IDN",
    "Yes",
    "PT Elangperdana Tyre Industry",
    "Jl. Elang, Kawasan Industri Indokodstra, Citeureup, Bogor 16810",
    "(021) 8759940",
    "Ban mobil penumpang, ban truk ringan, ban niaga, ban truk dan bus",
    "26/06/2024",
    "",
  ],
  [
    "LP-273-IDN",
    "Yes",
    "UPTD Pembinaan dan Pengujian Mutu Hasil Perikanan Merauke",
    "Jl. Nowari Lampu Satu, Merauke, Papua",
    "(0971) 323515",
    "Ikan beku/segar/hidup, udang beku/segar, cumi-cumi beku/segar",
    "29/07/2027",
    "",
  ],
  [
    "LP-274-IDN",
    "Yes",
    "Balai Keselamatan dan Kesehatan Kerja Dinas Tenaga Kerja dan Transmigrasi, Daerah Istimewa Yogyakarta",
    "Jl. Ireda No. 38, Yogyakarta 55152",
    "(0274) 371716",
    "Kebisingan, udara ambien, emisi sumber tidak bergerak, lingkungan kerja",
    "31/03/2024",
    "",
  ],
  ["LP-277-IDN", "No", "", "", "", "", "", "Nomor Akreditasi dicabut"],
  [
    "LP-278-IDN",
    "Yes",
    "Balai Besar Pengawas Obat dan Makanan di Palangka Raya",
    "Jl. Cilik Riwut No. 13, Km. 3,5 Palangka Raya, Kalimantan Tengah",
    "(0536) 3228359, 3230770",
    "Obat Terapetik : sirup, tablet, kapsul",
    "02/07/2026",
    "",
  ],
  [
    "LP-280-IDN",
    "Yes",
    "PT Semen Padang",
    "Jl. Raya Indarung, Padang",
    "(0751) 202038",
    "Semen, semen pengeboran, limestone, gypsum, batubara, agregat, beton",
    "23/04/2024",
    "",
  ],
  [
    "LP-283-IDN",
    "Yes",
    "PT Industri Karet Deli",
    "Jl. K. L. Yos Sudarso Km. 8.3, Medan, Sumatera Utara",
    "(061) 6612611",
    "Ban mobil penumpang; ban sepeda motor; ban truk ringan; ban truk dan bus; ban dalam kendaraan bermotor, ban dalam sepeda, ban pertanian, ban industri, ban sepeda",
    "02/01/2027",
    "",
  ],
  [
    "LP-286-IDN",
    "Yes",
    "PT Biochem Technology",
    "Jl. Sulawesi No. 36, Surabaya, Jawa Timur",
    "(031) 5022666",
    "Susu dan Minuman berbasis susu, Susu Fermentasi dan produk susu fermentasi, Susu kental dan analognya, krim yang disterilkan atau UHT, krim whipping, krim rendah lemak, Susu bubuk dan krim bubuk, Keju tanpa pemeraman, Keju peram, Makanan pencuci mulut berbahan dasar susu, lemak dan minyak nabati, mentega dan margarin, buah olahan, sayur kering, cabe kering, rumput laut kering, sayur dalam kemasan, tomat dalam kemasan, jagung manis dalam kemasan, jamur dalam kemasan, asparagus dalam kemasan, wortel dalam kemasan, rebung bamboo dalam kemasan, pasta tomat, keripik sayur, selai buah, kakao bubuk dan kakao massa/kelik kakao, olesan berbasis kakao, produk kakao dan cokelat, kembang gula, tepung dan pati, sereal olahan, pasta dan mi serta produk sejenisnya, tepung bumbu, minuman kedelai, tahu segar, kedelai fermentasi, produk bakteri, krekers (tidak termasuk krekers manis), Premiks untuk roti tawar dan produk bakteri, keik, kukis dan pai, Premiks untuk produk bakteri istimewa, daging, daging unggas dan daging hewan buruan mentah, Produk-produk olahan daging, daging unggas dan daging hewan buruan dalam bentuk (utuh atau potongan, Dihaluskan), Ikan dan produk perikanan lainnya termasuk moluska, krustase dan ekinodermata yang telah mengalami pengolahan, ikan dan produk perikanan awet, Telur segar, gula mentah dan gula dimurnikan, gula merah, larutan gula dan sirup, bumbu dan kondimen, cuka makan, sup dan kaldu, saus non emulsi, ragi dan produk sejenisnya, susu kedelai, minuman berbasis air berperisa, kopi, teh, seduhan herbal dan minuman biji-bijian dan sereal panas, the kering, minuman beralkohol, makanan ringan berbahan dasar kentang, umbi, serelia, tepung atau pati, olahan kacang dan berbasis ikan, nasi dan lauk pauk (nasi ayam, nasi ayam bumbu, nasi daging saus, nasi daging bumbu, nasi ikan pepes, nasi ikan panggang, nasi ikan saus, nasi ikan bumbu, nasi kuning, nasi uduk), obat tradisiional (jamu) solid dan liquid, kosmetik (solid, semi solid, liquid), bahan tambahan pangan (essence, pewarna, pengembang, pengemulsi, stabilizer), tepung terigu, biskuit, garam konsumsi beryodium, ikan dan produk perikanan kaleng, Madu, herba dan rempah, udara/ruang, permukaan peralatan, meja, tangan, baju, lantai, Susu, susu segar, susu pasteurisasi, susu UHT, susu steril, susu rendah lemak, susu rekonstitusi, susu rekombinan, Minyak Goreng, Minyak Sayur, Minyak Salad, Minyak Samin, Lemak Reroti, Pengganti Minyak Mentega, Sayur Beku, Buncis Beku, Kacang Kapri Beku, Brokoli Beku, Brussel Sprout Beku, Bayam Beku, Wortel Beku, Jamur Beku, Biji Jagung Beku, Jagung Bertongkol Beku, Terong Beku, Jamur Kering, Nori, Sayur Asin Kering, Kacang Kering dan Polong Kacang Kering, biji-bijian utuh, Bawang Putih, Bawang Merah (Shallot), Bawang Batak, Biji Seledri, Biji Sawi/Biji Mustard, Biji Sawi Bubuk atau Biji Mustard Bubuk, Cabe Jawa, Cabe Merah Segar, Bubur Cabe, Cabe Bubuk, Biji Dill (Dill Seed), Adas Manis, Adas Sowa, Adas Cina, Ender, Dill Weed, Fenugreek, Kelabat, Kelabet, Klabat, Fenugreek Bubuk, Kelabat Bubuk, Kelabet Bubuk, Klabat Bubuk, Fuli Kering, Fuli Bubuk, Jahe Segar, Jahe Kering, Bubur Jahe, Jahe Bubuk, Jintan/Caraway, Jintan Bubuk, Jintan Manis, Jintan Hitam, Jintan Hitam Bubuk, Jintan Putih, Cumin, Jintan Putih Bubuk, Kapulaga, Biji Kapulaga, Kapulaga Lokal,Kapulaga (Cardamom) Amomum, Biji Kapulaga (Cardamom) Amomum, Kapulaga Bubuk, Kapulaga (Cardamom) Amomum Bubuk, Kayu Manis, Kayu Manis Bubuk, Kemiri Dengan Tempurung, Kemiri, Kemiri Bubuk, Kencur, Kencur Bubuk, Ketumbar, Daun Ketumbar, Ketumbar Bubuk, Picung, Kluwek, Kunyit, Kunyit Bubuk, Lada Hitam, Lada Hitam Bubuk, Lada Putih, Lada Putih Bubuk, Lada Bubuk Campuran, Andaliman, Lengkuas/Laos, Lengkuas/Laos Bubuk, Kecombrang/ Sambung/ Kencong, Marjoram, Mint, Onion/Bawang Bombay, Onion Bubuk/Bawang Bombay Bubuk, Oregano, Pala, Pala Untuk Destilasi, Pala Bubuk, Parsley, Paprika Bubuk, Sweet Paprika Bubuk, Rosemari, Saga, Saffron, Pekak/Bunga Lawang/Star Anise, Temu Kunci, Tarragon, Thymi/Thyme, Ikan dan produk perikanan,",
    "22/07/2024",
    "",
  ],
  [
    "LP-287-IDN",
    "Yes",
    "PT Indocement Tunggal Prakarsa, Tbk - Laboratorium Quality Assurance and Research Division",
    "Jl. Mayor Oking Jayaatmaja, Citeureup, Bogor, Jawa Barat",
    "(021) 8754343",
    "Terak dan semen, aternative fuel (hazardous waste solid fuel (HWSF), paint sludge) semen, batubara, alternative fuel, alternative material, agregat halus, agregat kasar, concrete",
    "24/10/2026",
    "",
  ],
  [
    "LP-288-IDN",
    "Yes",
    "Balai Besar Karantina Ikan, Pengendalian Mutu dan Keamanan Hasil Perikanan Makassar",
    "Jl. A. Djemma No. 7, Makassar, Sulawesi Selatan",
    "(0411) 874793",
    "Ikan koi, mas, koki, komet, bandeng, kerapu, nila, udang windu, udang vannamei, lele, fresh &amp; frozen demersal, fresh &amp; frozen pelagic, fresh &amp; frozen tuna, fresh &amp; pasteurized crabmeat, fresh &amp; dry flying fish roe, fresh &amp; frozen chepalod, fresh &amp; frozen lobster &amp; slipper lobster, fresh &amp; frozen &amp; cook shrimp, dried shark fin, dried fish maw, dried abalone, dried sea cucumber, frozen octopus, frozen milkfish, dried seaweed, air dan es, ikan tuna, udang vannamei, kepiting, Lobster, ikan sidat, ikan belut, Ikan air tawar, Air dan es",
    "01/02/2027",
    "",
  ],
  [
    "LP-289-IDN",
    "Yes",
    "PT Jababeka Infrastruktur",
    "Gedung WTP-2, Jl. Irigasi Raya No. 1, Cikarang Baru, Bekasi, Jawa Barat",
    "(021) 89834321",
    "Air bersih, air minum, Air sungai, air limbah, udara ambien, udara lingkungan kerja, emisi sumber tidak bergerak, lingkungan kerja",
    "18/11/2024",
    "",
  ],
  [
    "LP-290-IDN",
    "Yes",
    "Balai Pengawas Obat dan Makanan di Bengkulu",
    "Jl. Depati Payung Negara Km. 13 No. 29, Pekan Sabtu Tromopl Pos 2, Bengkulu",
    "(0736) 53990-53993",
    "Obat Terapetik : sirup, tablet, kapsul, Larutan",
    "21/06/2025",
    "",
  ],
  [
    "LP-291-IDN",
    "Yes",
    "Balai Pengawas Obat dan Makanan di Ambon",
    "Jl. Dr. Kayadoe SK. 20, Kudamati, Ambon, Maluku",
    "(0911) 345866",
    "Terapetik : sediaan obat, kapsul, oral, sirup, injeksi, NAPZA Obat tradisional : padat, cair, suplemen kesehatan",
    "22/07/2024",
    "",
  ],
  [
    "LP-292-IDN",
    "Yes",
    "UPTD Balai Pengujian Mutu Hasil Perikanan Tangerang",
    "Jl. Perintis Kemerdekaan II, Cikokol, Tangerang 15118",
    "(021) 5581273",
    "Produk Perikanan (tuna segar, tuna beku, kakap segar, kakap beku, tenggiri segar, tenggiri beku, tuna loin beku, udang segar, udang beku, udang rebus beku, udang breaded, kerang, lobster, belut ikan asin, Belut hidup, abon ikan, Ikan asin kering, kerupuk ikan, bakso ikan, cumi beku, ranjungan kaleng pasteurisasi, otak-otak ikan, pindang ikan, bandeng presto, nugget ikan, siomay ikan), air untuk keperluan sanitasi hygiene (air baku , air proses pengolahan ), air minum, es",
    "16/12/2024",
    "",
  ],
  [
    "LP-293-IDN",
    "Yes",
    "Pusat Veteriner Farma - Direktorat Jenderal Peternakan &amp; Kesehatan Hewan, Kementerian Pertanian",
    "Jl. Jendral Achmad Yani 68 \x{2013} 70, Surabaya 60231",
    "(031) 8291125; 8291124",
    "Vaksin Anthrax, Vaksin Rabies, Vaksin",
    "01/01/2028",
    "",
  ],
  [
    "LP-294-IDN",
    "Yes",
    "PT Gajah Tunggal, Tbk.",
    "Lokasi 1 : Jl. Gatot Subroto Km.7, Tangerang 15135 Lokasi 2 : Jl. Transheksa Km. 2.3 Kawasan KJIE (Konsorsium) Karawang Barat, Jawa Barat",
    "(021) 5901309/12 ext. 124/115",
    "Lokasi 1: Ban mobil penumpang, ban truk ringan, ban truk dan bus, ban sepeda motor, ban dalam kendaraan bermotor",
    "23/05/2024",
    "",
  ],
  [
    "LP-297-IDN",
    "No",
    "",
    "",
    "",
    "",
    "",
    "Nomor digabung dengan LP-269-IDN",
  ],
  [
    "LP-298-IDN",
    "Yes",
    "PT Sari Incofood Corporation",
    "Jl. Tambak Rejo Desa Buntu Bedimbar, Kec. Tanjung Morawa, Kab. Deli Serdang, Sumatera Utara",
    "(061) 7943420",
    "R &amp; G Coffee Mixture, minuman kopi dalam kemasan, Ground Coffee, Ground Coffee Mixture, Cereal, Daun The, Cereal Mixture Chocolate Mixture, Creamer, Instant Coffee, Minuman Serbuk Berperisa, Instant Tea Mixture, R &amp; G Coffee, Instant Coffee Mixture, Instant Tea, Susu Bubuk, Air Limbah, Air Bersih, Air Minum",
    "06/09/2027",
    "",
  ],
  ["LP-299-IDN", "No", "", "", "", "", "", "Nomor Akreditasi dicabut"],
  ["LP-301-IDN", "No", "", "", "", "", "", "Nomor Akreditasi dicabut"],
  [
    "LP-302-IDN",
    "Yes",
    "Central Laboratory - PT PAM Lyonnaise Jaya",
    "Jl. Penjernihan II No. 1, Pejompongan, Jakarta Pusat 10210",
    "(021) 5720850",
    "Air minum dan air sungai",
    "26/02/2028",
    "",
  ],
  [
    "LP-304-IDN",
    "Yes",
    "Balai Pengawas Obat dan Makanan di Kupang",
    "Jl. R.A. Kartini, Kel. Kota Baru, Kec. Kelapa Lima, Kupang, Nusa Tenggara Timur 85228",
    "(0380) 8554595",
    "I. Terapetik (Obat): sediaan tablet, sediaan kapsul, sediaan sirup kering, sediaan sirup, sediaan salep kulit, sediaan suspensi, sediaan tetes mata, sediaan tetes telinga, sediaan injeksi",
    "18/11/2024",
    "",
  ],
  [
    "LP-305-IDN",
    "Yes",
    "Balai Besar Teknik Kesehatan Lingkungan dan Pengendalian Penyakit Jakarta",
    "Jl. Bambu Apus Raya No. 6 Blok C1, Cipayung, Jakarta Timur, DKI Jakarta",
    "(021) 8484912",
    "Air limbah, air sungai, air danau, air untuk keperluan higiene sanitasi, air minum, air haemodialisa, makanan siap saji, usap (alat makan &amp; minum, alat masak, alat medis, lantai, dinding), swab nasopharingeal, swab oropharingeal, swab hidung dan tenggorokan, sediaan darah (preparat ulas darah), udara ambien, udara emisi sumber tidak bergerak, lingkungan kerja, kebisingan, limbah B3 padat (abu, sludge, dan padatan)",
    "29/07/2027",
    "",
  ],
  ["LP-306-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  [
    "LP-307-IDN",
    "No",
    "",
    "",
    "",
    "",
    "",
    "Nomor digabung dengan LP-269-IDN</strong>",
  ],
  [
    "LP-308-IDN",
    "Yes",
    "PT Universal Laboratory",
    "Latrade Industrial Park Blok H-1, Tanjung Uncang, Kota Batam, Kepulauan Riau",
    "(0778) 396830",
    "Insektisida, herbisida, fungisida, pestisida, pestisida glyphospate",
    "17/11/2024",
    "",
  ],
  [
    "LP-309-IDN",
    "Yes",
    "PT Krakatau Tirta Industri",
    "Jl. Ir. Sutami, Kebonsari, Citangkil, Cilegon \x{2013} Banten 42442",
    "(0254) 372186; 37224",
    "Air untuk keperluan Higiene sanitasi",
    "18/09/2027",
    "",
  ],
  ["LP-310-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  ["LP-311-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  [
    "LP-312-IDN",
    "Yes",
    "Departemen Ilmu dan Teknologi Pangan, Fakultas Teknologi Pertanian, Institut Pertanian Bogor",
    "Kampus Darmaga IPB, Bogor 16002",
    "(0251) 8629855",
    "Corned beef, virgin coconut oil (VCO), MP-ASI, keju, baso daging, sosis, bumbu instan, kecap, mie, tepung sagu, tepung tapioka, tahu, tempe, ubi jalar, pasta (makaroni), rumput laut, tepung beras, tepung kacang kacang hijau, tepung terigu, bandeng presto, sop instan, wafer stick, biskuit, jagung, makanan kaleng, snack (potato chips), susu bubuk minyak goreng, susu cair, ikan kaleng, buah kaleng, saos sambal, sirup jahe, terasi, dodol, pasta coklat, minuman serbuk, saos dan tapioka, sari buah/juice, minyak goreng sawit, minyak jagung, minyak kelapa, minyak kedelai, kopi, air minum, tepung-tepungan, kerupuk, krim bubuk",
    "24/02/2025",
    "",
  ],
  [
    "LP-313-IDN",
    "Yes",
    "PT Yamaha Indonesia Motor Manufacturing",
    "Jl. Dr. KRT. Radjiman Widyodiningrat, Rawa Teratai, Cakung, Jakarta Timur, DKI Jakarta",
    "(021) 4612222",
    "Emisi gas buang sepeda motor (EURO 3)",
    "06/09/2027",
    "",
  ],
  [
    "LP-315-IDN",
    "Yes",
    "Balai Pengujian Mutu dan Sertifikasi Produk Hewan",
    "Jl. Pemuda No. 29 A Bogor, Jawa Barat",
    "(0251) 8353712",
    "Daging, sosis, bakso, susu, telur, nuget, abon, susu bubuk, dendeng, cornet, burger, sarang burung walet, gelatine, meat bone meal, daging sapi, daging ayam dan olahan daging, keju,",
    "04/03/2027",
    "",
  ],
  [
    "LP-316-IDN",
    "Yes",
    "PERUMDA Tirtawening Kota Bandung - Laboratorium Pengendalian Kualitas Lingkungan",
    "Jl. Atlas No. 6 Antapani, Bandung 40281",
    "(022) 7219399",
    "Air bersih (air sumur, air perpipaan, air kolam renang, air pemandian umum, air spa), air minum, air permukaan (air sungai, air mata air, air waduk), air limbah, tanah/lumpur ekstrak TCLP, udara ambien, kebauan, udara emisi sumber tidak bergerak, air untukkeperluan hygiene sanitasi,",
    "19/04/2025",
    "",
  ],
  [
    "LP-317-IDN",
    "Yes",
    "Laboratoria Pengembangan Teknologi Industri Agro dan Biomedika (LAPTIAB) - BPPT",
    "Gedung 610-612 LAPTIAB-BPPT Kawasan Puspiptek, Serpong, Tangerang Selatan, Banten",
    "(021) 7560530",
    "Kue kering (kukis), rimpang kering, teh dan kopi, bahan pakan (hijauan, bahan pakan konsentrat sapi), serbuk terdispersi dalam air, ekstrak bahan alam, alfa amylase padat dan cair, xylanase padat dan cairm protease padat dan cair, bahan plastik (khusu plastik berbahan pati baik secara keseluruhan dan sebagian, plastik",
    "23/05/2026",
    "",
  ],
  [
    "LP-320-IDN",
    "Yes",
    "PT. Asahimas Flat Glass, Tbk.",
    "Bukit Indah Industrial Park, Sektor IA Blok J \x{2013} L, Cikampek, Jawa Barat 41373",
    "(0264) 351711 ext. 6409",
    "Kaca pengaman berlapis (laminated glass), kaca pengaman diperkeras",
    "21/08/2024",
    "",
  ],
  [
    "LP-321-IDN",
    "Yes",
    "PT. Ecostar Laboratories",
    "Karawaci Office Park B16, Lippo Karawaci - Tangerang 15811",
    "(021) 55793664",
    "Air limbah, air permukaan, air bersih, air minum, udara emisi sumber tidak bergerak, udara ambien, udara lingkungan kerja",
    "28/11/2024",
    "",
  ],
  [
    "LP-322-IDN",
    "Yes",
    "PT. Multistrada Arah Sarana, Tbk.",
    "Jl. Raya Lemahabang Km.58,3, Desa Karangsari, Kec. Cikarang Timur, Bekasi 17550",
    "(021) 89140333",
    "Ban mobil penumpang, ban truk ringan, ban sepeda motor",
    "18/11/2027",
    "",
  ],
  [
    "LP-323-IDN",
    "Yes",
    "Departemen Teknologi Industri Pertanian - Fakultas Teknologi Industri Pertanian - Institut Pertanian Bogor",
    "Kampus Institut Pertanian Bogor Darmaga, PO. Box 220, Bogor 16002",
    "(0251) 8627830/8621974",
    "Air permukaan, air limbah, air minum, air bersih, sedimen, gula kristal mentah, tepung jagung, susu bubuk diet diabetes, keripik singkong, gula palma, susu sereal",
    "28/07/2024",
    "",
  ],
  [
    "LP-326-IDN",
    "Yes",
    "Pusat Sumber Daya Mineral Batubara dan Panas Bumi",
    "Jl. Soekarno Hatta No. 444, Bandung, Jawa Barat",
    "(022) 5202698",
    "Batuan, batubara, bijih, batuan/pasir, mineral logam, laterit nikel, mineral logam, mineral bukan logam, laterit bauksit, air panas bumi, Mineral Bukan Logam kecuali Batu Gamping atau Batu Kapur",
    "18/11/2024",
    "",
  ],
  [
    "LP-327-IDN",
    "Yes",
    "PT. Gelora Djaja",
    "Jl. Buntaran No. 9, Manukan Wetan, Tandes, Surabaya, Jawa Timur",
    "(031) 7493556",
    "Rokok kretek, rokok putih, tembakau/blend tembakau, cigarette Tipping Paper, Cigarette Filter, Mineral Water, Air Limbah, air sungai, Cairan sigaret elektrik dan Produk tembakau yang dipanaskan, Cairan sigaret elektrik, Produk tembakau yang dipanaskan, Cairan sigaret elektrik, Sigaret Kelembak Kemenyan",
    "27/01/2028",
    "",
  ],
  [
    "LP-328-IDN",
    "Yes",
    "Laboratorium Quality Control Departement Plant 9/10 - PT. Indocement Tunggal Prakarsa, Tbk.",
    "Jl. Raya Cirebon - Bandung Km.19, Palimanan \x{2013} Cirebon 45161",
    "(0231) 343760; 343232; 343923",
    "Portland semen type I, (II/V), V, terak semen portland type I, portland composite cement",
    "21/08/2024",
    "",
  ],
  [
    "LP-329-IDN",
    "Yes",
    "Balai Inseminasi Buatan Lembang",
    "Jl. Kayu Ambon No. 78, Lembang, Kab. Bandung Barat",
    "(022) 2786222",
    "Semen beku, semen cair (sapi, kerbau, domba dan kambing)",
    "19/04/2025",
    "",
  ],
  [
    "LP-330-IDN",
    "Yes",
    "PT Mitralab Buana",
    "Jl. Agung Raya II No. 14, RT 007 RW 007, Lenteng Agung, Jagakarsa, Jakarta Selatan 12610",
    "(021) 7888 1468; 78881252",
    "Udara ambien, kebisingan, lingkungan kerja, emisi sumber tidak bergerak, emisi sumber bergerak, air limbah, air permukaan (air sungai, air danau, air sumur, air situ, air mata air), air untuk keperluan higiene dan sanitasi, air minum, air laut",
    "26/02/2028",
    "",
  ],
  [
    "LP-331-IDN",
    "Yes",
    "UPTD Kesehatan Hewan dan Kesehatan Masyarakat Veteriner",
    "Jl. Raya Tangkuban Perahu Km. 22, Cikole, Lembang, Jawa Barat",
    "(022) 2785715",
    "Darah sapi, feses (ruminansia, kuda, rodensia), daging dan produk olahan daging (sosis, bakso, nugget), telur, susu dan produk olahannya, swab kloaka, trakea atau organ",
    "22/11/2025",
    "",
  ],
  [
    "LP-332-IDN",
    "Yes",
    "UPT Keselamatan Kerja Surabaya",
    "Jl. Dukuh Menanggal 122, Surabaya 60234",
    "(031) 8280440",
    "Udara ambien, udara lingkungan kerja, udara emisi gas buang",
    "24/09/2024",
    "",
  ],
  ["LP-333-IDN", "No", "", "", "", "", "", "Nomor Akreditasi dicabut"],
  ["LP-334-IDN", "No", "", "", "", "", "", "Nomor Akreditasi dicabut"],
  [
    "LP-335-IDN",
    "Yes",
    "Analytical Laboratory Smartri, PT Sinar Mas Agro Resources &amp; Technology (SMART), Tbk.",
    "Libo Estate, Desa. Sam Sam, Kec. Kandis, Siak - Riau",
    "(0761) 32986",
    "Pupuk amonium sulfat, pupuk amonium klorida, pupuk fosfat alam untuk pertanian, pupuk diamonium posphat (DAP), pupuk kalium klorida (MOP), pupuk dolomit, pupuk borat, pupuk chopper sulfat (CuSO",
    "18/09/2027",
    "",
  ],
  [
    "LP-336-IDN",
    "Yes",
    "PT Geoservices - Environmental Laboratories",
    "Jl. Sukajadi No. 227, Bandung 40153",
    "(022) 2038468",
    "Air bersih, air tanah, air minum, air minum dalam kemasan (AMDK), air permukaan, air limbah, air limbah penambangan bijih emas/tembaga dan batu bara, makanan (infant formula dan polenta), gula dan jus, preform, closure dan botol kosong, air cooling tower, Air untuk keperluan higiene sanitasi, Air sungai",
    "28/07/2024",
    "",
  ],
  [
    "LP-337-IDN",
    "No",
    "",
    "",
    "",
    "",
    "",
    "Nomor tidak digunakan lagi",
  ],
  [
    "LP-338-IDN",
    "Yes",
    "PT. Nusantara Water Centre",
    "Intercon Plaza - Taman Kebon Jeruk Blok A3/16-17, Jl. Meruya Ilir Raya, Jakarta",
    "(021) 5304982; 5857392",
    "Air minum, air bersih, air tanah, air proses, air limbah, air sungai, air danau, udara ambien, kebisingan lingkungan, lingkungan kerja, udara emisi tidak bergerak",
    "20/09/2025",
    "",
  ],
  [
    "LP-342-IDN",
    "Yes",
    "PT Clinisindo Laboratories",
    "Jl. Ulujami Raya No. 12, Pesanggrahan, Jakarta 12250",
    "(021) 73889918",
    "Plasma Darah yang mengandung :",
    "31/10/2027",
    "",
  ],
  [
    "LP-343-IDN",
    "Yes",
    "Laboratorium PAM Jaya",
    "Jl. Pejompongan Raya No. 2 , Pejompongan, Jakarta Pusat, DKI Jakarta",
    "(021) 5704250 ; (021) 5719404",
    "Air higiene sanitasi, air minum, air sungai/badan air, air minum dalam kemasan, air kolam renang, air mineral",
    "04/08/2024",
    "",
  ],
  [
    "LP-344-IDN",
    "Yes",
    "PT Sandia Jaya Laboratories - San Clin Eq",
    "Jl. Leuwigajah No. 174, Cimahi, Jawa Barat",
    "(022) 6629653",
    "Plasma dan serum darah yang mengandung :",
    "18/09/2027",
    "",
  ],
  [
    "LP-346-IDN",
    "Yes",
    "UPTD Laboratorium Lingkungan Hidup Dinas Lingkungan Hidup Provinsi Jawa Barat",
    "Jl. A. H. Nasution No. 117, Ujungberung, Bandung, Jawa Barat",
    "(022) 7803370",
    "Air limbah, air danau, air sumur, air sungai, air akuifer, air situ, air mata air, air waduk, air untuk keperluan higiene dan sanitasi",
    "04/05/2026",
    "",
  ],
  [
    "LP-347-IDN",
    "Yes",
    "Balai Pengujian Standar Instrumen Unggas dan Aneka Ternak",
    "Jl. Veteran IIII, Ciawi, Bogor",
    "(0251) 8240751-53",
    "Pakan ternak, bahan pakan, cairan rumen",
    "30/06/2025",
    "",
  ],
  [
    "LP-348-IDN",
    "Yes",
    "UPT Balai Sertifikasi Mutu Benih Tanaman Pangan dan Hortikultura Sulawesi Selatan",
    "Jl. Dr. Ratulangi No. 71, Maros, Sulawesi Selatan",
    "(0411) 371202",
    "Benih tanaman pangan (padi, kedelai, jagung, kacang tanah, kacang hijau, gandum);",
    "17/07/2027",
    "",
  ],
  [
    "LP-349-IDN",
    "Yes",
    "Pusat Promosi dan Sertifikasi Hasil Pertanian",
    "Jl. Raya Jambore No. 1, Cibubur, Jakarta Timur, DKI Jakarta",
    "(021) 89952691",
    "Residu pestisida pada buah pome, buah batu, buah sitrus, buah berry, buah kering, produk dan buah berlemak, sayuran berbuah, sayuran akar dan umbi-umbian, sayuran berdaun, beras, sereal, cabai kering, dan biji berlemak; formulasi pestisida, manisan buah basah, dodol wingko, buah dan sayuran, asanan, salad, dodol, manisan, sirup lidah buaya, pisang sale, jahe, benih tanaman pangan, benih tanaman hortikultura, daun bawang, bawang merah, bawang putih, kedelai",
    "25/07/2026",
    "",
  ],
  [
    "LP-350-IDN",
    "Yes",
    "UPT Perlindungan Tanaman Pangan dan Hortikultura Sumatera Utara",
    "Jl. Jenderal Besar Abdul Haris Nasution No. 4, Pangkalan Masyhur, Medan 21043",
    "(061) 7880230",
    "Tomat, cabe, kentang, selada, peleng, sawi, pakcoy, bayam, brokoli, bunga kol, bawang prei, jeruk, kubis, kol, padi, kedelai, apel, kacang panjang, formulasi pestisida (bahan aktif)",
    "17/12/2024",
    "",
  ],
  [
    "LP-352-IDN",
    "Yes",
    "PT. Carsurin Samarinda",
    "Jl. HM. Rifaddin No. 9 RT 25 Kec. Loa Janan Ilir, Samarinda 75132",
    "0541 - 4114327-30",
    "Batubara, Air Limbah",
    "31/03/2024",
    "",
  ],
  [
    "LP-353-IDN",
    "Yes",
    "PT. Carsurin Banjarbaru",
    "Jl. Ahmad Yani Km. 21,5, Landasan Ulin, Banjarbaru, Kalimantan Selatan",
    "(0511) 4705849",
    "Batubara, CPO, Nickel ore, Limestone, Bauksit, Air Limbah, Air Danau, Air Sungai, Air Muara, Air Rawa, Air Mata Air, Air Waduk, Air Untuk Keperluan Higiene Sanitasi, Air Minum, Air RO Haemodialisa, Daging &amp; Olahan Daging",
    "28/07/2024",
    "",
  ],
  [
    "LP-355-IDN",
    "Yes",
    "PT Pharma Metric Labs",
    "Lokasi 1 : Gedung Indra Sentral Cempaka Putih Unit R -T, Jl. Letjen. Suprapto No. 60, Jakarta Pusat, DKI Jakarta Lokasi 2 : Gedung kalbe business Innovation centre Unit 1A, Jl. Pulogadong no.23 kav no. II G.5, Kawasan Industri PT JIEP, Cakung, Jakarta Timur, DKI Jakarta",
    "(021) 4265310, 4269475",
    "Lokasi 1 : Plasma darah manusia, kapllet , Bahan Baku Obat(Levofloxacin Hemilhydrate, Losartan Potassium, Valsartan, Imatinib Mesylate), Obat Tablet (Levoflaxacin, Losartan Potassium, Valsartan, Imatinib Mesylate), Bahan baku (asam asetat, larutan cuka, larutan",
    "24/09/2024",
    "",
  ],
  [
    "LP-356-IDN",
    "Yes",
    "Perumda Tirta Manuntung Balikpapan",
    "Jl. MT. Haryono No. 01, Kampung Damai, Balikpapan, Kalimantan Timur",
    "(0542) 7218831/7218832",
    "Air baku, air olahan, air limbah",
    "P16/02/2025",
    "",
  ],
  [
    "LP-357-IDN",
    "Yes",
    "UPTD Laboratorium Lingkungan, Dinas Lingkungan Hidup Kabupaten Bandung",
    "Jl. Raya Soreang Km. 17, Kab. Bandung, Jawa Barat",
    "(022) 5896293",
    "Air untuk keperluan higiene dan sanitasi, air sungai, air danau, air mata air, air limbah, udara ambien, kebisingan",
    "02/07/2026",
    "",
  ],
  [
    "LP-358-IDN",
    "Yes",
    "Balai Besar Veteriner Maros",
    "Jl. Dr. Sam Ratulangi, Kab. Maros, Sulawesi Selatan",
    "(0411) 371105",
    "Serum ayam, Material abortus sapi, cairan synovial/higroma sapi, Tanah, material sisa-sisa dari sapi mati (darah, kulit), Usus ayam, feses ayam, swab lingkungan peternakan ayam, Daging ayam, Preparat ulas darah sapi, Organ otak anjing, Serum (kambing, domba, sapi dan kerbau), Preparat ulas darah sapi dan kuda, Feses (sapi, kuda dan kambing), Serum sapi dan kambing, Otak (Cerebellum, Hippocampus, Cortex, Medulla Oblongata) pada anjing, Serum babi, Serum anjing dan kucing, Isolat, tanah, pakan ternak (sapi), bahan asal hewan (kulit sapi), Isolat, swab ayam, Itik, burung, babi, kelelawar, Isolat swab ayam, Itik, burung , Isolat, swab trakea, swab oropharyngeal, swab kloaka, organ, swab lingkungan, pakan, feses, bulu, telur dari unggas (ayam, itik, bebek), Spesimen berupa organ, daging (sapi, ayam, babi), pakan ternak, bahan olahan asal hewan yang diduga mengandung spesies yang lain (pemalsuan daging) pada ayam, Spesimen berupa organ, daging (sapi, ayam, babi), pakan, bahan olahan asal hewan yang diduga mengandung spesies yang lain (pemalsuan daging) , Spesimen berasal dari kultur dan darah dari hewan sapi dan hewan lainnya, Spesimen berupa isolat, bahan asal hewan dan bahan olahan asal hewan (bakso,nugget, sosis), Spesimen berasal dari organ hewan (otak) tanpa pengawet dari anjing, Spesimen berasal dari organ hewan (otak) tanpa pengawet dan urin sapi, Darah sapi, Serum, organ, darah babi, Daging dan produk olahan (Bakso, nugget, sosis), Daging dan produk olahan (daging, nugget, sosis), telur (ayam), Daging dan produk olahan(daging, nugget, sosis)dan Telur (ayam)",
    "22/11/2026",
    "",
  ],
  [
    "LP-360-IDN",
    "Yes",
    "PT Indocement Tunggal Prakarsa, Tbk - Quality Control Department",
    "Desa Tarjun, Kecamatan Kelumpang Hilir, Kabupaten Kotabaru \x{2013} Kalimantan Selatan 72171",
    "(0518) 61000 (Ext.2053)",
    "Portland cement type 1, portland composite cement, terak semen portland",
    "26/02/2028",
    "",
  ],
  ["LP-363-IDN", "No", "", "", "", "", "", "Nomor Akreditasi dicabut"],
  ["LP-364-IDN", "No", "", "", "", "", "", "Nomor Akreditasi dicabut"],
  [
    "LP-366-IDN",
    "Yes",
    "Balai Besar Pengujian Standar Instrumen Pascapanen Pertanian",
    "Lokasi 1 : Jl. Tentara Pelajar No. 12A, Cimanggu, Bogor, Jawa Barat Lokasi 2 : Jl. Surotokunto Rawagabus, karawang",
    "(0251) 8321762",
    "Loaksi 1 : Makanan (biskuit, kraket kukis, wafer, pai), minuman (saribuah, minuman cair selain susu, minuman lain nonkarbonasi, sirup), susu bubuk, tepung beras, cairan nano emulsi dari minyak atsiri, nabati dan lemak hewani, bahan pangan berpati yang berasal dari tanaman jenis serealia, ubi, talas, palma, dan biji-bijian, sayur dan buah dengan kadar air tinggi, teh dan tepung-tepungan",
    "22/11/2025",
    "",
  ],
  [
    "LP-367-IDN",
    "Yes",
    "Balai Besar Standardisasi dan Pelayanan Jasa Industri Keramik dan Mineral Non Logam",
    "Jl. Jend. A Yani No. 392 Bandung, Jawa Barat",
    "(022) 7206221, 7207115, 7206296",
    "Ubin Keramik, Tableware ( ART ), Kloset Duduk, Peturasan pria jenis vitrous china, Bidet jenis vitreous china, Tandas jongkok jenis vitorus cina, Meja cuci keramik jenis vitreous cina, Kaca Pengaman Berlapis untuk Bangunan dan Mebelair , Kaca Pengaman Diperkeras untuk Bangunan dan Panel, Kaca Pengaman Berlapis ( Laminated Glass ) untuk Kendaraan Bermotor, Kaca Lembaran (Hemat Energi, Kaca Reflektif), Kaca Berpola, Kaca untuk Bangunan: Cermin Kaca Lembaran Berlapis Perak, Kaca Cermin Lembaran untuk Penggunaan Umum, Kaca untuk bangunan \x{2013} Blok kaca (Glass blocks), Kaca untuk bangunan - kaca berlapis dan kaca pengaman berlapis, Kaca untuk bangunan - kaca isolasi, Kaca Lembaran, Kaca Pengaman Diperkeras untuk kendaraan bermotor, Genteng Keramik, Genteng Keramik Berglasir, Genteng Beton, Bata beton (Paving block), Bata beton untuk pasangan dinding, Bata Tahan Api Jenis Alumina Tinggi, Bata Tahan Api Jenis Samot , Bahan Tahan Api Kastabel Jenis Alumina Silikat, Bahan Tahan Api Isolasi Kastabel Jenis Aluminium Silikat, Bata Tahan Api Magnesit, Raming Miks Jenis Samot dan Jenis Kadar Alumina Tinggi, Mortar Tahan Api Jenis Kadar Alumina Tinggi yang Mengeras pada Suhu Kamar, Bahan Mentah Keramik, Kaca Isolasi untuk ruang dan lemari pendingin, Kaca pengaman untuk sarana perkeretaapian, ampul gelas untuk obat suntik, vial gelas untuk obat suntik",
    "22/11/2025",
    "",
  ],
  [
    "LP-369-IDN",
    "Yes",
    "Balai Veteriner Medan",
    "Jl. Jend. Gatot Subroto No. 255 A, Medan, Sumatera Utara",
    "(061) 8452253",
    "Serum ayam, serum sapi, serum kerbau, serum bebek, entok, burung, serum domba, serum babi, serum domba, serum kambing, swab (daging ayam, telur) &amp;organ, swab/organ (trachea, kloaka, lingkungan) unggas (ayam, beberk, entok, burung), organ sapi (limpa, usus, paru, trakea, lidah, rumen) &amp; oragn ayam (paru, otak, hari, ginjal, jantung, otot), bakteri, feses (sapi, kerbau, kambing, domba, ayam, bebek, entok, burung, babi, unggas (ayam, bebek, entok, burung), ruminansia (sapi, kerbau, kambing, domba), otak anjing, ulas darah (ayam, sapi, kerbau, kambing, domba), kerokan kulit (sapi, kerbau, kambing, domba), susu, daging, telur, darah (sapi, kerbau, domba, babi, ayam)",
    "23/05/2026",
    "",
  ],
  [
    "LP-370-IDN",
    "Yes",
    "PT. Pindo Deli Pulp And Paper Mills",
    "Desa Kuta Mekar BTB 6-9, Karawang 41361",
    "(0267) 440111",
    "Kertas",
    "03/10/2024",
    "",
  ],
  [
    "LP-371-IDN",
    "Yes",
    "PT Pertamina - Laboratory Production Sungai Pakning",
    "Jl. Cendana No. 1, Komplek Pertamina Sungai Pakning, Bengkalin, Riau",
    "(0766) 91220",
    "Low Sulphur Waxy Residue (LSWR)/Long Residue, Solar 48, Kerosine, Crude Oil",
    "27/07/2025",
    "",
  ],
  [
    "LP-372-IDN",
    "Yes",
    "PT Karsa Buana Lestari",
    "Perkantoran Bintaro 8, Jl. Bintaro Permai Raya Kav. 8/III, Kel. Bintaro, Kec. Pesanggrahan, Jakarta Selatan",
    "(021) 7378020",
    "Air minum, air hygiene sanitasi, air tanah, air sungai, air situ, drainase, waduk, air danau, air limbah, air laut, tanah, sedimen lumpur, emisi, udara ambien, lingkungan kerja",
    "02/10/2025",
    "",
  ],
  [
    "LP-374-IDN",
    "Yes",
    "Balai Besar Pengujian Minyak dan Gas Bumi LEMIGAS \x{2013} Laboratorium Teknologi Gas",
    "Jl Cileduk Raya Kav 109, Kebayoran Lama, Jakarta",
    "(021) 7398276",
    "LPG, gas bumi, logam, larutan, tabung LPG, tabung CNG, pipa polietilen, Raw Material polietilen",
    "20/09/2025",
    "",
  ],
  [
    "LP-376-IDN",
    "Yes",
    "PT. Professional Technology Specialist",
    "Tunas Industrial Estate Block 4-D, Batam Centre, Batam, Kepulauan Riau",
    "(0778) 471 983",
    "Bahan Logam dan produk logam",
    "21/06/2025",
    "",
  ],
  [
    "LP-380-IDN",
    "Yes",
    "Balai Pengujian dan Peralatan, Dinas Pekerjaan Umum Bina Marga dan Cipta Karya Provinsi Jawa Tengah",
    "Jl. Murbei I Timur, Srondol Timur, Semarang, Jawa Tengah",
    "(024) 7471705",
    "Beton, Mortar, Paving Block, Campuran Beraspal, Agregat Halus, Agregat Kasar, Besi Beton, Tanah",
    "22/05/2027",
    "",
  ],
  [
    "LP-382-IDN",
    "Yes",
    "Balai Besar Laboratorium Kesehatan Jakarta",
    "Jl. Percetakan Negara No. 23B, Jakarta Pusat, DKI Jakarta",
    "(021) 4212524",
    "Daging dan olahannya, air minum, air mineral, Air reserve omosis (RO), air limbah, air higiene sanitasi, Bakso, daging ayam (rebus), Ikan air Tawar dan Ikan air laut olahan (Rebus/kukus), bakery, Bakery istimewa (manis), Roti, Roti tawar, usap permukaan, susu, eskrim, keju, Udang segar, sayur segar (selada), Sayuran Beku, Makanan sayur tidak berkuah, sayuran berkuah, Makanan siap saji, Alat kesehatan (Pembalut, perban, kapas), Desinfektan, Antiseptik, air hemodialisa (HD), Air mineral, Air minum, air untuk keperluan higiene dan sanitasi, air limbah, Rapid Diagnostic Test (RDT) (Anti Syphilis (TP), Anti Syphilis (TP), Anti HCV, HbsAg, Anti HIV), Reagen PCR Covid-19, Masker medis",
    "20/02/2027",
    "",
  ],
  [
    "LP-383-IDN",
    "Yes",
    "Balai Standardisasi dan Pelayanan Jasa Industri Ambon",
    "Jl. Kebun Cengkeh Batu Merah Atas, Ambon, Maluku",
    "(0911) 341897",
    "Air mineral, biskuit, bagea asagu, ikan teri kering, ikan asin kering, cumi-cumi kering, rumput laut kering, minyak kayu putih, Minyak nilam, minyak serai, pala, garam, air limbah, air sungai, air sumur, air untuk keperluan higiene sanitasi",
    "26/12/2025",
    "",
  ],
  [
    "LP-384-IDN",
    "No",
    "",
    "",
    "",
    "",
    "",
    "Nomor digabung dengan LP-512-IDN",
  ],
  [
    "LP-385-IDN",
    "Yes",
    "PT Nutrifood Indonesia",
    "Lokasi 1: Jl. Raya Ciawi No. 280 A, Bogor, Jawa Barat Lokasi 2: Jl. Selayar II Blok H7-H8, Cibitung, Cikarang Barat, Jawa Barat",
    "(0251) 8240257 (lokasi 1) (021) 29635900 (lokasi 2)",
    "Susu bubuk dan turunannya (skim, full cream, whey protein, caseinate), susu formula, minuman serbuk, krim nabati, coklat bubuk, minuman tidak berkarbonat berperisa/sari buah dan sari sayuran, susu siap minum (susu pasteurisasi/susu steril/UHT/olahan), mie kering, kecap, pemanis (berbasis sorbitol), sirup, sediaan suplemen bubuk, minuman susu fermentasi berperisa/minuman yoghurt berperisa, air proses, jam/jeli buah/marmalad, sirup buah, sirup berperisa, sirup encer berperisa, cookies, dekorasi dan saus manis, makanan ringan - berbahan dasar kentang, umbi, serealia tepung atau pati (makanan snack bar), permen susu, suplemen vitamin (sediaan padat)",
    "26/02/2026",
    "",
  ],
  [
    "LP-387-IDN",
    "Yes",
    "Balai Karantina Ikan, Pengendalian Mutu dan Hasil Perikanan Surabaya I",
    "Jl. Raya Bandar Udara, Ir. Haji Juanda No. 23, Sidoarjo, Jawa Timur",
    "(031) 8688099",
    "Udang windu, udang vannamei, lobster, kepiting, frozen shrimp, Ikan (kakap, Kerapu, Bandeng, nila), ikan air tawar (ikan mas, koi, koki, komet, nila, gurame, lele, belut, sidat, patin, cherax, goldfish, snakehead fish, goby, mullets, rainbow trout, eel, catfish), Ikan air laut (Goby, yelowfin sea bream, Kakap putih), produk perikanan (Karagenan, agar powder, tepung ikan, teripang kering, rumput laut kering, ikan asin, chitin chitosan, shellfish), benih nila, frozen fish and fishery products, kerupuk (udang &amp; ikan), air dan es, fresh fish , life tropical fish",
    "25/07/2026",
    "",
  ],
  [
    "LP-389-IDN",
    "Yes",
    "PT Sucofindo (Persero) - Laboratorium Cabang Medan",
    "Jl. Jend. Gatot Subroto Km. 5,5 No. 105 Medan, Sumatera Utara",
    "(061) 8451880",
    "Minyak dan lemak (CPO dan turunannya), pupuk fosfat alam untuk pertanian, pupuk kalium klorida, pupuk ammonium sulfat, pupuk NPK padat, pupuk tripel super fosfat, air limbah, air sungai, air minum, air untuk keperluan higiene dan sanitasi, udara emisi sumber tidak bergerak, udara ambien, kebisingan",
    "13/06/2026",
    "",
  ],
  [
    "LP-390-IDN",
    "Yes",
    "Balai Besar Uji Standar Karantina Pertanian Jakarta",
    "Jl. Pemuda No. 64 Kav. 16-17, Rawamangun, Jakarta Timur, DKI Jakarta",
    "(021) 4894877; 4753182",
    "Umbi-umbian, biji-bijian (gandum, padi, kedelai), benih (kubis-kubisan, jagung, kelapa sawit, kentang, tomat, cabai merah, cabai rawit,padi), bagian tanaman( kubis, jagung, kentang, tomat), pangan segar asal tumbuhan (Anggur, labu siam, sawi, pak choi, brokoli, pir, apel, wortel, tomat, bawang daun, Jamur enoki), sap tanaman atau ooze, hasil isolasi atau RNA hasil isolasi, spesimen (gulma, Lalat buah, serangga) sarang burung walet, serangga, bahan baku pakan ternak, serum (ayam, sapi, kambing, domba, anjing, kucing, kera, dan hewan pemapat rabies), Darah, jaringan, dan produk olahan babi, Swab nasofaring kuda, swab kloaka dan trachea, daging, susu, telur, feses, preparat (cendawan, nematoda)",
    "21/03/2026",
    "",
  ],
  [
    "LP-392-IDN",
    "Yes",
    "Balai Uji Standar Karantina Ikan, Pengendalian Mutu dan Keamanan Hasil Perikanan",
    "Jl. Raya Setu No.01, Cilangkap, Jakarta Timur, DKI Jakarta",
    "(021) 8451378",
    "Kerang (hidup), Belut (hidup, segar) , Ikan (Mas, Koi, Koki, Komet ) (hidup), Ikan kaleng (tuna, mackerel, sarden), Ikan beku (sardin, mackarel, kakap, kerapu, tuna, tongkol, layang, salmon), Kerang (hidup, segar, beku), Udang (hidup, segar, beku, rebus), Lele, betutu, gurame, nila, arwana, koki, Ikan mas, patin, bawal, belut ,sidat, kerapu, (hidup), Ikan (bawal, bandeng, kuwe, kembung, tongkol, tuna, kakap, ayam-ayam, belanak, mujair, gurame, salem,",
    "13/06/2026",
    "",
  ],
  [
    "LP-393-IDN",
    "Yes",
    "PT Surveyor Carbon Consulting Indonesia Cabang Samarinda",
    "Lokasi 1: Jl. Siradj Salman No. 168, RT 027, Kel. Jawa, Kec. Samarinda Ulu, Samarinda, Kalimantan Timur Lokasi 2: Komplek Ruko Pergudangan Kendari Indah Blok A1. Jl. R. Suprapto Punggolaka, Puuwatu Kota Kendari, Sulawesi Tenggara",
    "(0541) 734000",
    "Batubara, mineral/batuan, nickel laterite ore, porduk bijih nickel NPI dan Fe Ni",
    "25/07/2026",
    "",
  ],
  [
    "LP-394-IDN",
    "Yes",
    "Balai Penerapan Standar Instrumen Pertanian Nusa Tenggara Barat",
    "Jl. Raya Peninjauan Narmada, Lombok Barat, Nusa Tenggara Barat",
    "(0370) 671312",
    "Tanah, pupuk NPK padat, pupuk urea, pupuk SP 36, pupuk amonium sulfat, pupuk fosfat alam untuk pertanian, pupuk organik, jaringan tanaman",
    "24/10/2026",
    "",
  ],
  [
    "LP-396-IDN",
    "Yes",
    "UPTD Laboratorium Perindustrian Kabupaten Tegal",
    "Jl. Raya Dampyak Km. 4, Kompleks Lingkungan Industri Kecil (LIK), Kab. Tegal, Jawa Tengah",
    "(0283) 357437",
    "Logam dan Produk Logam, Baja Profil H Canai Panas (Bj PHC), Baja Profil Siku Sama Kaki Proses Canai Panas , (Bj P Siku Sama Kaki), Baja Tulangan Beton, Beton Silinder dan Beton Kubus, Bata Beton (Paving Block), Logam Non Ferro Basis Alumunium, Logam Non Ferro Basis Tembaga, Baja Karbon dan Paduan Rendah, Baja Tahan Karat",
    "05/06/2026",
    "",
  ],
  [
    "LP-398-IDN",
    "Yes",
    "Balai Laboratorium Kesehatan dan Kalibrasi D.I Yogyakarta",
    "Ngadinegaran MJ. III No. 62, Daerah Istimewa Yogyakarta",
    "(0274) 378187",
    "Air minum, air untuk keperluan higiene dan sanitasi, air kolam renang, air danau,air sungai, air limbah, Air Minum Isi Ulang, Air Mineral, makanan (sereal, susu, daging, bakeri, ikan), minuman (sari buah dan sari sayur), obat tradisional (obat dalam (kapsul), obat luar (cairan obat luar), kosmetik (selain untuk anak di bawah 3 tahun dan area sekitar mata, membran mukosa), udara, usap (swab lantai, dinding, alat makan)",
    "13/06/2026",
    "",
  ],
  [
    "LP-399-IDN",
    "Yes",
    "Balai Besar Laboratorium Kesehatan Surabaya",
    "Jl. Karangmenjangan No. 18 Surabaya, Jawa Timur",
    "(031) 5021451",
    "Air minum, air untuk keperluan Hygiene sanitasi, air limbah, Rapid Diagnostic Test (RDT) (Antigen COVID-19, Anti Syphilis (TP), Anti HCV, HbsAg, Anti HIV)",
    "29/04/2027",
    "",
  ],
  [
    "LP-400-IDN",
    "Yes",
    "Balai Besar Laboratorium Kesehatan Makassar",
    "Jl. Perintis Kemerdekaan KM 11, Tamalanrea, Makassar, Sulawesi Selatan",
    "(0411) 586458",
    "Air sungai, air minum, air hygiene sanitasi (air sumur dan air tanha), air laut, air limbah, bahan pangan, makanan ringan siap santap, butter, lingkungan kerja",
    "20/03/2027",
    "",
  ],
  ["LP-401-IDN", "No", "", "", "", "", "", "Nomor Akreditasi dicabut"],
  [
    "LP-402-IDN",
    "Yes",
    "Balai Perikanan Budidaya Air Payau Situbondo",
    "Jl. Raya Pecaron, Panarukan, Kab. Situbondo, Jawa Timur",
    "(0338) 673328",
    "kan (kakap dan kerapu), udang (udang putih, udang penacus, udang rostris), air payau dan air laut, air tawar, daging ikan dan udang",
    "20/02/2027",
    "",
  ],
  [
    "LP-404-IDN",
    "Yes",
    "PT Surveyor Carbon Consuting Indonesia Cabang Banjarbaru",
    "Jl. A. Yani Km. 30, Kel. Guntung Payung, Kec. Landasan Ulin, Banjarbaru, Kalimantan Selatan",
    "(0511) 4785367",
    "Batubara, Mineral",
    "24/04/2026",
    "",
  ],
  [
    "LP-405-IDN",
    "Yes",
    "UPTD Laboratorium Lingkungan Dinas Lingkungan Hidup dan Kebersihan Kota Palembang",
    "Jl. Lunjuk Jaya No. 2, Lantai II, Demang Lebar Daun, Palembang, Sumatera Selatan",
    "(0711) 310154",
    "Air limbah, air sungai, air kolam renang, air sumur, air bersih, Air Kolam Retensi, Air Sumur Pantau",
    "24/10/2026",
    "",
  ],
  [
    "LP-407-IDN",
    "Yes",
    "PT Sari Husada - Central Laboratory",
    "Jl. Raya Jogja-Solo Km. 19, Prambanan, Klaten, Jawa Tengah",
    "(0274) 498001",
    "Susu bubuk",
    "5/10/2022",
    "",
  ],
  [
    "LP-408-IDN",
    "Yes",
    "Balai Perikanan Budidaya Air Tawar Mandiangin",
    "Jl. Tahura Sultan Adam Km. 14, Mandiangin, Kec. Karang Intan, Kab Banjar, Kalimantan Selatan",
    "0811 500 4658",
    "Udang windu, udang vannamei, ikan mas, ikan koi, ikan air tawar, pakan ikan dan bahan pakan ikan, air bersih",
    "26/02/2026",
    "",
  ],
  [
    "LP-409-IDN",
    "Yes",
    "PT Hyprowira Adhitama",
    "Kompleks pergudangan taman tekno, Sektor XI Blok H3 No. 28 E Taman Tekno - BSD City Serpong, Tangerang - Banten Tangerang Selatan",
    "(021) 29662266/77",
    "Pelumas hidrolik, pelumas turbin, pelumas motor diesel putaran cepat, minyak lumas roda gigi industri, minyak lumas untuk aplikasi penerbangan, pelumas sirkulasi peralatan mill dan baja, pelumas industri kertas, pelumas industri keramik, minyak transformator, solar (fuel), bahan bakar jenis biosolar, bahan bakar avtur, metil etil glikol (MEG), metanol, grease, Oli Transformer, Permukaan Materi Padat Tidak Berpori",
    "19/12/2026",
    "",
  ],
  [
    "LP-410-IDN",
    "Yes",
    "Pusat Standardisasi Instrumen Pengelolaan Hutan Berkelanjutan",
    "Jl. Gunung Batu No. 5, Bogor, Jawa Barat",
    "(0251) 8633378, 86333413",
    "Kayu, arang kayu, arang tempurung kelapa, briket arang kayu, arang aktif, kayu solid, fosil kayu, kayu lapis, femir rotan",
    "29/07/2027",
    "",
  ],
  [
    "LP-411-IDN",
    "Yes",
    "PT TUV NORD Indonesia",
    "Jl. Science Timur 1 Blok B3-F1, Kawasan Industri Jababeka V, Cibatu - Cikarang, Kab. Bekasi, Jawa Barat",
    "(021) 29574720",
    "",
    "22/08/2026",
    "",
  ],
  [
    "LP-412-IDN",
    "Yes",
    "PT Widya Cipta Buana, Laboratorium Binalab",
    "Lokasi 1: Komp. Rukon Metro, Jl. Venus Barat Kav. 15, Metro Margahayu Raya, Bandung, Jawa Barat Lokasi 2: Jl. Prof. Moh. Yamin No. 116 C-D, Pekanbaru, Riau",
    "(022) 7561503 (0761) 856252",
    "Air minum, air untuk keperluan higiene dan sanitasi, air bersih, air tanah, air sungai, air waduk air saluran, air limbah, air laut, Udara Emisi Sumber Tidak Bergerak, udara ambien, kebisingan, udara ruang kerja, tanah/sedimen/material",
    "21/03/2026",
    "",
  ],
  [
    "LP-413-IDN",
    "Yes",
    "UPTD Laboratorium lingkungan Dinas Lingkungan Hidup Provinsi Jambi",
    "Jl. KH. Agus Salim, No.7, Kotabaru, Jambi",
    "(0741) 40706",
    "Air limbah, air sumur, air danau, air sungai, air tanah, kebisingan, udara ambien, udara emisi sumber bergerak, udara emisi sumber tidak bergerak, kesuburan tanah",
    "19/12/2026",
    "",
  ],
  [
    "LP-415-IDN",
    "Yes",
    "PT Carsurin Cikarang",
    "Lokasi 1 : Jl. Gaharu 1 Blok F2 No. 10J Multi Guna Niaga, Delta Silikon 3 Lippo Cikarang, Bekasi, Jawa Barat Lokasi 2 : Jl. Telaga Bodas Raya No.88, Kec. Gajahmungkur, Kota Semarang, Jawa Tengah",
    "(021) 9617045/ 9675818",
    "Batubara, activated carbon, wood charcoal, bijih nikel, produk nikel, Tekstil-Pakaian Bayi, Air Limbah Domestik, Air Limbah Industri, Air Sungai, Air Laut, Udara Ambien, Kebisingan, Lingkungan Kerja",
    "21/03/2026",
    "",
  ],
  [
    "LP-416-IDN",
    "Yes",
    "PT Trakindo Utama - Laboratorium SOS",
    "Lokasi 1: avling Komersial Taman Tekno Blok B No.1, BSD City Sektor XI, Serpong, Tangerang Lokasi 2: Jl. Jend. Sudirman No. 848, Balikpapan, Kalimantan Timur Lokasi 3: MMA Office 1st Floor, Area PT Amman Mineral Nusa Tenggara, Batu Hijau, Sumbawa Barat, Nusa Tenggara Barat Lokasi 4: Jl. Kuala Tembaga Lot E-3 PO.Box 7014, Light Industrial Park (LIP) Timika 99920 Kuala Kencana, Papua",
    "(021) 782 2373, 781 1030, 2997 6620 Ext. 2959",
    "Pelumas bekas (in used), pelumas mesin. Pelumas selain pelumas mesin, air limpasan penangkap minyak/lemak (oil trap overflow)",
    "17/01/2026",
    "",
  ],
  [
    "LP-417-IDN",
    "Yes",
    "PT Yamaha Motor Nuansa Indonesia",
    "Jl. Raya Bekasi Km.23 Pulogadung, Jakarta",
    "(021) 4611234",
    "Air minum, air higienis sanitasi",
    "22/11/2025",
    "",
  ],
  [
    "LP-418-IDN",
    "Yes",
    "PT Pharindo Laboratories - Econolab International",
    "Jl. Raya Kebayoran Lama No. 33, Kel. Grogol Selatan, Kebayoran Lama, Jakarta Selatan, DKI Jakarta",
    "(021) 7251471",
    "Plasma darah manusia",
    "25/07/2026",
    "",
  ],
  [
    "LP-419-IDN",
    "Yes",
    "PT Geoservices Asam-Asam (Multilokasi)",
    "Lokasi 1: Jl. A Yani KM 121 RT 12, Sungai Banta, Desa Asam-asam, Kec. Jorong Kab. Tanah Laut, Kalimantan Selatan Lokasi 2: Via PT Arutmin Asam - Asam, Jl A.Yani KM.122 Sungai Banta, Kec.Jorong Kab. Tanah Laut, Kalimantan Selatan Jorong Lokasi 3: Komp. Jetty PT. WBM Desa Sungai Cuka, Kec. Satui, Kab. Tanah Bumbu, Kalimantan Selatan Lokasi 4: Jl. A. Yani KM 204, Sebamban Kampung, Kec. Sungai Loban, Kab. Tanah Bumbu, Klaimantan Selatan",
    "(0512) 63075, 63078",
    "Batubara",
    "24/10/2026",
    "",
  ],
  [
    "LP-420-IDN",
    "Yes",
    "PT Geoservices Berau",
    "Jl.Mutiara RT 13, Kec/Kel Gunung Tabur, Kab Berau, Kalimantan Timur",
    "(0554) 2030206",
    "Batubara",
    "16/10/2027",
    "",
  ],
  [
    "LP-421-IDN",
    "Yes",
    "PT Badak NGL",
    "Plant Site PT Badak NGL Bontang, Kalimantan Timur",
    "(0548) 551424; 551539",
    "Air limbah industri, air limbah domestik, air higiene dan sanitasi, Sumber Emisi Tidak Bergerak, natural gas (NG), Liquefaction Natural Gas (LNG), Liquefied Petroaleum Gas (LPG)",
    "05/09/2026",
    "",
  ],
  [
    "LP-422-IDN",
    "Yes",
    "PT Hi-Test",
    "Century Park, Block F No. 6-7, Batam, Kepulauan Riau",
    "(0778) 7483070",
    "Material logam dan produk logam (pelat baja, sambungan las, dan base nickel), baja karbon, baja paduan rendah, nikel dan paduannya, copper dan paduannya",
    "06/08/2026",
    "",
  ],
  [
    "LP-424-IDN",
    "Yes",
    "Pusat Penelitian Teh dan Kina",
    "Gambung, Desa Mekarsari, Kec. Pasirjambu, Kab. Bandung, Jawa Barat",
    "(022) 5928185",
    "Teh hitam, Teh hijau, Tanaman",
    "20/02/2027",
    "",
  ],
  [
    "LP-425-IDN",
    "Yes",
    "Departemen Manajemen Sumber Daya Perairan, Fakultas Perikanan dan Ilmu Kelautan Institut Pertanian Bogor (IPB) - Laboratorium Produktivitas dan Lingkungan Perairan",
    "Gedung FPIK Wing 14 Lantai 1-2, Kampus IPB Darmaga, Bogor, Jawa Barat",
    "(0251) 8621495",
    "Air sungsi, air sumur, air danau, air situ, air muara, air waduk, air rawa, air laut, air minum, air untuk keperluan higiene dan sanitasi, air limbah, padatan (tanah/sedimen), biota",
    "13/06/2026",
    "",
  ],
  ["LP-427-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  [
    "LP-428-IDN",
    "Yes",
    "Balai Karantina Ikan Pengendalian Mutu dan Keamanan Hasil Perikanan Denpasar",
    "Jl. Sunset Road No.777, Kuta, Badung, Bali",
    "(0361) 4727390",
    "Ikan (ikan air laut, ikan air tawar, ikan kerapi, ikan kakap, ikan nila, ikan mas, ikan koi, ikan nila, ikan koki, ikan salmon, ikan sidat, ikan hias air laut/zebra fish), crustacea (lobster dan kepiting, udang hias air laut, udang windu, udang vanname),",
    "28/08/2027",
    "",
  ],
  [
    "LP-429-IDN",
    "Yes",
    "PT Charoen Pokphand Indonesia - Regional Laboratory Surabaya",
    "Jl. Raya Surabaya \x{2013} Mojokerto KM. 26, Kec. Krian, Kab. Sidoarjo, Jawa Timur",
    "(031) 8972992",
    "Pakan ternak, bahan pakan nabati, pakan bahan hewani, bahan pakan nabati selain molases, bahan pakan inorganik, bahan imbuhan pakan",
    "20/02/2027",
    "",
  ],
  [
    "LP-431-IDN",
    "Yes",
    "Fakultas Farmasi Universitas Indonesia",
    "Gd. Kampus Baru UI, Depok, Pondok Cina, Beji, Depok, Jawa Barat",
    "(021) 7864049",
    "Plasma darah manusia, suplemen kesehatan (sediaan tablet, sediaan kapsul keras, sediaan kapsul lunak, sediaan cair, sediaan serbuk)",
    "05/10/2026",
    "",
  ],
  [
    "LP-432-IDN",
    "Yes",
    "PT SGS Indonesia",
    "Lokasi 1 : The garden center 1st &amp; 2nd Floor - Cilandak Commercial Estate Blok H # 108C, Jl. Raya Cilandak KKO, Jakarta Selatan, DKI Jakarta Lokasi 2 : Jl. Diponegoro No. 247, Ungaran, Semarang, Jawa Tengah",
    "Lokasi 1: (021) 29780600 Lokasi 2: (024) 76929130",
    "Lokasi 1 : Kacang dan makanan ringan olahan kacang, cabai kering, bumbu rempah-rempah (lada hitam, Lada Putih Bubuk, kayu manis dan produk analognya, jintan, biji pala, jahe, cloves), cassia, pakan ikan, serealia dan produk serealia, minyak dari biji-bijian (seed oil), Lemak, minyak dan produk mengandung minyak/lemak (Tumbuhan dan hewan), kembang gula lunak, gula kristal mentah, gula Kristal putih, Pakan ternak, Produk kakao, Lemak Kakao &amp; bubuk kakao, tepung dan pati, Ikan dan Produk Perikanan Olahan termasuk Moluska dan Krustasea, Makanan Ringan berbahan dasar kentang, umbi, serealia, tepung atau pati, berbasis kacang dan berbasis ikan, Susu Bubuk, Krim Bubuk dan Bubuk Analog, Susu dan Produk Analognya, Keju dan Produk Analognya, Es Krim dan Makanan Pencuci Mulut, Breakfast- cereal, Sausages, Ice Cream, Cracker, Milk-Chocolate, Chocholate, Wheat &amp; Wheat-Products, Bakery, Cakes, Bread, Cookies, Soups, Sauces, Beverages (Juice), biscuit, tepung, rinse water, Sodium metabisulfite, Flavour, seasoning spices, condiment, gula kristal rafinasi,Udang, ikan dan produk ikan kalengan, garam konsumsi beryodium, popok bayi, pembalut wanita, minyak goreng sawit, lemak dan emulsi minyak/lemak, creamer, minuman ringan, makanan pencuci mulut, produk biji-bijian, minuman kemasan, buah-buahan, sirup, Margarin, mentega, sosis, daging dan daging olahan, kecap, mi instan, mayonais, permen, minyak dan turunannya (margarin, fatty acid, shortening, RBDPO, RBD, stearin, PKE, CPO, PKO), tepung terigu, sabun (padat &amp; cair), cream, Lotion, skincare, shampoo, kopi instan, air limbah,Sludge (total konsentrasi), air minum, air bersih, Air mineral, Air demineral, air mineral alami, air mineral dalam kemasan (AMDK), air bilasan, swab (permukaan), plastik kemasan pangan, plastik dan kayu (wadah &amp; kemasan pangan), Plastik, Polymer, Rubber, Powder, Paint/Ink, Liquid, Metal, Textile, ceramic, glazed ceramic ware, plastik PP &amp; PE, plastic (PP, PE, PVC, melamin, rubber, PC, Nylon), plastic (aqueous test simulant), Asesoris (Metal, Metal Alloy, Metal-Anodic, Metal-Catodic), Grease, Organik, silicon, Produk electrotechnical, kulit, Polyurethan, karet, silica gel, alas kaki (polimer, plastik), mainan anak, Produk anak-anak bukan logam, Auxilaries and finishing agents; Pretreatment agents; Finishing assistants; Dyes and pigments; Flame retardants; fat liquoring agents, solvent, Anciliaries, anti foaming, cat dan pelapis permukaan yang sejenis, coating, leather, print, artificial leather, footwear, Completed Shoes, Upper Material Footwear (Leather, Fabric), Leather Shynthetic Materials, Air produksi, Glycol, FAME (B100), biosolar, HSD, MGO, MFO, lube oil, crude oil, gas, Salad Dressing, Sayuran dan Buah Berkadar Air Tinggi, Sayuran dan Buah, Selai, Selai Coklat, Mie instan, Teh Kering Dalam Kemasan, Edible Ice, Lotion, Lipstik, Body Lotion, Hand Cream, Lip Balm, Ethanol, Mono Diethylene Amine (MDEA)",
    "22/11/2026",
    "",
  ],
  [
    "LP-433-IDN",
    "Yes",
    "PT Water Laboratory Nusantara Indonesia",
    "Lokasi 1 : Jl. Yos Sudarso No. 65 Paal Dua, Manado \x{2013} Sulawesi Utara Lokasi 2 : Jl. Ahmad Yani No. 68B, Tanah Sereal, Bogor",
    "(0431) 873030 (0251) 8333740",
    "Lokasi 1 : Air tanah, air permukaan, air minum, air bersih, air untuk keperluan hygiene dan sanitasi, air limbah (limbah domestik, air lindi, penambangan bijih emas atau tembaga, biji nikel), air laut, jaringan hewan &amp; tumbuhan, tanah, sedimen, lumpur, tanah dan limbah (TCLP), swab test, udara ambien, emisi tidak bergerak, udara lingkungan kerja",
    "30/03/2025",
    "",
  ],
  [
    "LP-434-IDN",
    "Yes",
    "Balai Pengembangan Perbenihan dan Pengawasan Mutu Benih Tanaman Pertanian Daerah Istimewa Yogyakarta",
    "Kompleks Dinas Pertanian dan Ketahanan Pangan, Jl. Gondosuli No. 6 Yogyakarta",
    "(0274) 566687",
    "Padi, kedelai, jagung, kacang hijau, cabe, tomat",
    "21/03/2026",
    "",
  ],
  [
    "LP-435-IDN",
    "Yes",
    "UPTD Laboratorium Lingkungan Dinas Lingkungan Hidup dan Kebersihan Kabupaten Tangerang",
    "Jl. K.H Sarbini No. 4, Komplek Perkantoran Tigaraksa, Tangerang, Banten",
    "(021) 5991455",
    "Air limbah, air badan air, air bersih, air minum, kebisingan, udara ambien, Air sungai dan sejenisnya",
    "18/11/2024",
    "",
  ],
  [
    "LP-437-IDN",
    "Yes",
    "UPT Balai Pengujian dan Sertifikasi Mutu Barang Dinas Perdagangan dan Perindustrian Provinsi Kalimantan Tengah",
    "Jl. RTA. Milono Km. 5,5 Palangka Raya, Kalimantan Tengah",
    "(0536) 3221551",
    "Standar Indonesia Rubber (SIR), Crude Palm Oil (CPO), Beras",
    "01/02/2027",
    "",
  ],
  [
    "LP-439-IDN",
    "Yes",
    "Balai Pengamanan Fasilitas Kesehatan Makassar",
    "Jl. Perintis Kemerdekaan Km.11, Makassar, Sulawesi Selatan",
    "(0411) 582345",
    "Pesawat Sinar-X (x-ray general purpose/radiografi umum, x-ray mobile, gigi intra oral, x-ray gigi panoramic/Cephalometri, CT scan, x-ray fluoroscopy(R/F, C-Arm, ESWL, Angiografi), mammografi), dosimeter thermoluminisensi (TLD Badge)",
    "25/07/2026",
    "",
  ],
  [
    "LP-442-IDN",
    "Yes",
    "PT Biro Klasifikasi Indonesia",
    "Jl. Yos Sudarso No 38 - 39 -40, Tanjung Priok, Jakarta Utara, DKI Jakarta",
    "(021) 4301017, 4301703, 4300993",
    "Bahan logam, logam dan paduannya (baja karbon rendah, baja karbon sedang, baja karbon tinggi), sambungan las (pipa dan palte), baja tulangan beton (BJTS, BJTP), baut (baut-A 325, baut-F 10T, baut grade 8.8), carbon &amp; low alloy, Cr NI (stainless steel), copper &amp; copper alloys",
    "18/11/2027",
    "",
  ],
  [
    "LP-445-IDN",
    "Yes",
    "Balai Karantina Ikan, Pengendalian Mutu dan Keamanan Hasil Perikanan Balikpapan",
    "Jl. Kol. Syarifuddin Yoes No. 10 RT. 094, Ring Road, Kota Balikpapan Kalimantan Timur 76115",
    "(0542) 876348",
    "Udang (penaid, ronggeng), kepiting, ikan air tawar, ikan air laut, ikan mas dan koi, lele, patin, lobster, Udang Beku, Udang kupas Beku, Udang Kupas Rebus Beku, Ikan Beku, Ikan Segar, Udang Segar, Ikan Asin Kering, Rumput Laut Kering, Udang Kering Tanpa Kulit (ebi)",
    "28/08/2027",
    "",
  ],
  ["LP-446-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  [
    "LP-447-IDN",
    "Yes",
    "Balai Inseminasi Buatan Ungaran",
    "Jl. MT. Haryono No. 53 A, Kelurahan Sidomulyo, Kecamatan Ungaran Timur, Kabupaten Semarang, Jawa Tengah 50501",
    "(024) 692 1107",
    "Semen segar sapi, semen cair sapi, semen beku sapi, semen segar kambing, semen cair kambing, semen beku kambing",
    "17/12/2024",
    "",
  ],
  ["LP-448-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  [
    "LP-449-IDN",
    "Yes",
    "Balai Teknik Kesehatan Lingkungan dan Pengendalian Penyakit (BTKLPP) Kelas I Palembang",
    "Jl. Sultan Mahmud Badaruddin II KM. 11 No. 55, Palembang 30154",
    "(0711) 5645923",
    "Air bersih, air minum, air limbah, air minum dalam kemasan, daging, telur, susu dan olahannya, produk perikanan, udara ambien, Udara lingkungan kerja, air permukaan",
    "06/05/2024",
    "",
  ],
  [
    "LP-450-IDN",
    "Yes",
    "UPTD Geologi dan Laboratorium DESDM Provinsi Sumatera Selatan",
    "Jl. Angkatan 45 No. 2240 Palembang 30137",
    "(0711) 379040, 367307",
    "Batubara",
    "18/11/2027",
    "",
  ],
  [
    "LP-451-IDN",
    "Yes",
    "UPTD Laboratorium Lingkungan Dinas Lingkungan Hidup Kabupaten Mojokerto",
    "Jl. Pemuda No. 55B, Mojosari, Kab. Mojokerto, Jawa Timur",
    "(0321) 591539",
    "Air bersih (air untuk keperluan higiene dan sanitasi), air sungai, air limbah, udara ambien, kebisingan, lingkungan kerja, emisi sumber bergerak, emisi sumber tidak bergerak",
    "04/06/2027",
    "",
  ],
  [
    "LP-452-IDN",
    "Yes",
    "Balai Pengawasan dan Sertifikasi Benih Tanaman Pangan dan Hortikultura Provinsi Kalimantan Selatan",
    "Jl. P. Suriansyah Ujung No. 63 A, Banjarbaru \x{2013} Kalimantan Selatan 70711",
    "(0511) 4772077",
    "Benih tanaman pangan (padi, jagung, kedelai, kacang tanah)",
    "29/04/2027",
    "",
  ],
  [
    "LP-453-IDN",
    "Yes",
    "Laboratorium Penguji Kualitas Udara - BMKG",
    "Jl. Angkasa I No. 2, Kemayoran, Jakarta 10720",
    "(021) 4246321 ext. 313",
    "Udara ambien, air hujan",
    "04/08/2024",
    "",
  ],
  [
    "LP-454-IDN",
    "Yes",
    "Balai Pengelolaan Informasi Sumber Daya Kelautan dan Perikanan - Laboratorium Kualitas",
    "Jalan SEACORM KM.2, Kec. Jembrana, Kab. Jembrana, Bali",
    "(0365) 442666",
    "Air laut, air permukaan (air sungai, air sumur , air danau, air tambak), air limbah",
    "24/09/2024",
    "",
  ],
  [
    "LP-455-IDN",
    "Yes",
    "PT. Ispat Indo",
    "Desa Kedungturi, Taman Sepanjang Sidoarjo, PO BOX 1083, Surabaya",
    "(031) 7887000",
    "Billet, Wire Rods dan D-Bars",
    "24/05/2024",
    "",
  ],
  ["LP-456-IDN", "No", "", "", "", "", "", "Nomor Akreditasi dicabut"],
  [
    "LP-458-IDN",
    "Yes",
    "UPTD Balai Pengawasan dan Sertifikasi Mutu Barang Provinsi Lampung",
    "Jl. Cut Meutia No.36, Bandar Lampung 35214",
    "(0721) 480410",
    "Standard Indonesian Rubber (SIR), biji kopi, biji kakao, lada hitam, lada putih, jagung, gabah, beras",
    "06/05/2024",
    "",
  ],
  [
    "LP-461-IDN",
    "Yes",
    "Balai Besar Karantina Pertanian Surabaya",
    "Lokasi 1 : Jl. Letjen Suprapto 67, waru, Sidoarjo Lokasi 2 : Jl. Kalimas Baru 88D, Surabaya Lokasi 3 : Jl. Raya Bandara Ir. H. Juanda no.26, Sidoarjo 61253",
    "(031) 8681498 (031) 3295367",
    "Lokasi 1 : Benih padi, benih jagung, akar dan umbi kentang, tanah dari areal pertanaman kentang, akar dari tamanan jeruk dan jahe, benih gandum, benih alfalfa (medicago sativa), benih cabai, benih tomat, benih kentang dan umbi bawang merah, buah belimbing, nangka, jambu dan cabai, buah apel, pear, anggur, dan jeruk,biji gandum, beras dan bungkil,buah kelengkeng",
    "17/04/2027",
    "",
  ],
  [
    "LP-462-IDN",
    "Yes",
    "PT Semen Baturaja (Persero) Tbk - Departemen Quality Control (Multilokasi)",
    "lokasi 1 : Jl. Raya Tiga Gajah, Baturaja, Ogan Komering Ulu 32117 Lokasi 2 : Jl. Abikusno Cokrosuyoso, kertapati, Palembang 30001 Lokasi 3 : Jl. Yos sudarso Km 7, Panjang, Bandar lampung",
    "(0735) 320344 (0711) 511261",
    "Semen portland (OPC), semen composite (PCC), beton silinder, beton kubus",
    "27/6/2027",
    "",
  ],
  [
    "LP-465-IDN",
    "Yes",
    "Balai Pengamanan Fasilitas Kesehatan Jakarta",
    "Jl. Percetakan Negara No.23A, Johar Baru, Jakarta Pusat, Daerah Khusus Ibukota Jakarta",
    "(021) 4240406; 42882249",
    "Termoluminisensi (TLD) mata Hp, Computed Radiography, Digital Radiography, Pesawat sinar X -radiografi umum (General Purpose ) dengan AEC, Pesawat sinar X -radiografi umum (General Purpose ) tanpa AEC, Pesawat sinar X -mobile, Pesawat sinar X - Dental, Pesawat sinar X - Dental Panoramic, Radiasi lingkungan pesawat sinar-x, Pesawat sinar X - Mammografi, Pesawat sinar X - Fluoroskopi, Pesawat sinar X - CT-Scan, Pesawat Magentic Resonans Imaging (MRI), TLD Badge HP, Pesawat Sinar X Angiografi, Pesawat Sinar X C-Arm, Ventilator, Continuous Positive Airway Pressure, High Flow Nasal Canule, Alat hisap medik, autoclave, centrifuge, centrifuge refrigerator, ECT, USG, Freezer Laboratorium, lampu operasi, personal negatif pressure chamber, Photo Therapy Unit/Blue Light, Power Emergency Resucitator, Defibrillator/ DC Shock, Defibrillator Monito r, Defibrillator with Electrocardiograph (ECG) with SPO2, infant warmer, inkubator bayi, UST, General Purpose X-Ray, Bed Elektrik Pasien Hospital, Sphygmomanometer",
    "02/12/2027",
    "",
  ],
  [
    "LP-466-IDN",
    "Yes",
    "PT. IOL Indonesia Laboratorium Samarinda (Multilokasi)",
    "Lokasi 1: Jl. KH. Wahid Hasyim No. 34A, Sempaja, Samarinda, Kalimantan Timur Lokasi 2: Jl. Silo No. 128, RT 06, Teluk Bayur, Kab. Berau, Kalimantan Timur",
    "(0541) 250111 (0554) 2030734",
    "Batubara",
    "28/08/2027",
    "",
  ],
  ["LP-467-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  [
    "LP-468-IDN",
    "Yes",
    "UPTD Laboratorium Kesehatan Provinsi Kalimantan Timur",
    "Jl. KH. Ahmad Dahlan No. 27, Samarinda, Kalimantan Timur 75117",
    "(0541) 741732",
    "Air minum, air bersih, air limbah, air badan air, air kolam renang, Air Danau, Air Sungai, Air Muara, Air Rawa, Air Mata Air, Air Waduk, Air Untuk Keperluan Higiene Sanitasi, Air RO Haemodialisa, makanan catering, jajanan sekolah, snack, minuman berperisa, udara, usap lantai, dinding, alat makan, Daging dan Olahan Daging",
    "24/09/2024",
    "",
  ],
  [
    "LP-469-IDN",
    "Yes",
    "PT. IOL Indonesia Laboratorium Banjarbaru",
    "Jl. A. Yani Km. 33,3 No. 3, Loktabat, Banjarbaru, Kalimatan Selatan 70712",
    "(0511) 4788840",
    "Batubara",
    "06/09/2027",
    "",
  ],
  [
    "LP-471-IDN",
    "Yes",
    "Balai Besar Pengawas Obat dan Makanan di Bandar Lampung",
    "Jl. Dr. Susilo No. 105, Bandar Lampung 35213",
    "(0721) 252212",
    "Terapetik : tablet, kapsul, suspensi, injeksi, krim, salep mata, tetes mata, tetes telinga, infus, larutan;",
    "22/07/2024",
    "",
  ],
  [
    "LP-472-IDN",
    "Yes",
    "PT Pusat Riset Perkebunan Nusantara - Pusat Penelitian Kelapa Sawit",
    "Jl. Brigjen Katamso No. 51, Medan, Sumatera Utara",
    "(061) 7862477",
    "Pupuk triple super fosfat (TSP), pupuk amonium sulfat (ZA), puuk SP-36, pupuk fosfat alam untuk pertanian, pupuk NPK, pupuk dolomit, pupuk kalium klorida, pupuk urea, pupuk anorganik, pupuk kieserite, Crude Palm Oil (CPO), Minyak goreng sawit, Palm Kerneal Meal, Daun (Jaringan Tanaman), Tanah, air permukaan, air limbah",
    "18/11/2027",
    "",
  ],
  ["LP-474-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  [
    "LP-475-IDN",
    "Yes",
    "Akademi Kimia Analisis Bogor",
    "Jl. Pangeran Sogiri No. 283, Tanah Baru, Bogor 16158",
    "(0251) 8650351",
    "Air limbah, Air minum, Air bersih",
    "22/07/2024",
    "",
  ],
  [
    "LP-476-IDN",
    "Yes",
    "Fakultas Teknik Sipil dan Perencanaan, Universitas Islam Indonesia - Laboratorium Kualitas Lingkungan",
    "Kampus terpadu UII, Gedung M. Natsir, Jl. Kaliurang Km. 14.4, Yogyakarta",
    "(0274) 898471, 896440",
    "Air Laut, air limbah, air mineral, air sumur, air danau, air sungai, air muara, air rawa, air akuifer, air situ, air mata air, air waduk, Air untuk Keperluan Higiene Sanitasi, Kebisingan Lingkungan, Udara Ambien, Udara dalam ruangan, Udara Lingkungan Kerja (Industrial Hygiene)",
    "17/05/2025",
    "",
  ],
  [
    "LP-477-IDN",
    "Yes",
    "PT Solusi Bangun Indonesia, Tbk - AFR Laboratory",
    "Narogong Plant, Jl. Raya Narogong Km. 7, Gunung Putri, Kab. Bogor",
    "(021) 8231260",
    "Limbah B3 (padat, cair, sludge), cement, clinker, air limbah, air permukaan (air sungai, air danau, air tanah), udara ambient, udara emisi sumber tidak bergerak, kebisingan",
    "17/12/2024",
    "",
  ],
  [
    "LP-478-IDN",
    "Yes",
    "Laboratorium Terpadu Universitas Islam Indonesia",
    "Jl. Kaliurang Km. 14,5, Sleman, Yogyakarta 55584",
    "(0274) 895920 ext. 3045",
    "Air minum dalam kemasan (AMDK), air dan air limbah, minyak nilam, minyak pala, minyak atsiri seraiwangi tipe jawa",
    "22/07/2024",
    "",
  ],
  [
    "LP-479-IDN",
    "Yes",
    "Balai Besar Teknik Kesehatan Lingkungan &amp; Pengendalian Penyakit Banjarbaru",
    "Jl. H. Mistar Cokrokusumo No. 2A, Banjarbaru, kalimantan Selatan 70714",
    "(0511) 4780343",
    "Air minum, air bersih, Air permukaan/air badan air, air limbah, udara ambien, udara lingkungan kerja, makanan (katering), Lantai/dinding ruangan steril (RS), Alat makan (Piring, gelas, sendok, garpu), Usap tenggorok dan usap nasopharing",
    "31/03/2024",
    "",
  ],
  [
    "LP-480-IDN",
    "Yes",
    "Fakultas Geografi Universitas Gadjah Mada - Laboratorium Hidrologi dan Klimatologi Lingkungan",
    "Sekip Utara, Bulak Sumur, Yogyakarta 55281",
    "(0274) 548632",
    "Air sungai, air danau, air waduk, air kolam, air limbah, air tanah, lingkungan kerja",
    "28/04/2025",
    "",
  ],
  [
    "LP-481-IDN",
    "Yes",
    "UPTD Balai Pengujian dan Sertifikasi Mutu Barang, Dinas Perindustrian dan Perdagangan Aceh",
    "Jl. Banda Aceh \x{2013} Medan Km 4,5 Desa Meunasah Manyang, Kec.Ingin Jaya, Banda Aceh 23371",
    "(0651) 32171",
    "Biji kopi, biji kakao, minyak nilam, minyak pala, tepung terigu, garam konsumsi beryodium",
    "20/10/2024",
    "",
  ],
  [
    "LP-482-IDN",
    "Yes",
    "Balai Perikanan Budidaya Air Payau Takalar",
    "Desa Boddia, Kecamatan Galesong, Kabupaten Takalar, Sulawesi Selatan",
    "(0418) 2312972",
    "Air laut, air payau, air tawar, ikan dan pakan ikan, udang, kepiting, Ikan bandeng, ikan kerapu, ikan kakap, telur ikan, rajungan, ikan",
    "23/04/2024",
    "",
  ],
  [
    "LP-483-IDN",
    "Yes",
    "Balai Besar Pengawas Obat dan Makanan di Banda Aceh",
    "Jl. Tgk. H. Mohd. Daud Beureueh No. 110, Banda Aceh 23126",
    "(0651) 7411698, 23926",
    "Terapetik (tablet, suspensi)",
    "02/12/2027",
    "",
  ],
  [
    "LP-485-IDN",
    "Yes",
    "UPTD Balai Pengawasan dan Sertifikasi Mutu Barang Provinsi Sumatera Selatan",
    "Jl. Demang Lebar Daun No.261D, Palembang, Sumatera Selatan",
    "(0711) 441646",
    "SIR, kopi biji, karet konvensional",
    "17/12/2024",
    "",
  ],
  [
    "LP-487-IDN",
    "Yes",
    "Balai Pengembangan Jasa Konstruksi",
    "Jl. Ring Road Utara Maguwoharjo, Depok, Sleman \x{2013} Yogyakarta 55282",
    "(0274) 489622",
    "Tanah, agregat halus dan agregat kasar, beton, aspal",
    "20/10/2024",
    "",
  ],
  [
    "LP-488-IDN",
    "Yes",
    "Laboratorium Kesehatan Provinsi Kalimantan Selatan",
    "Jl. Bumi Mas Raya No. 22, Banjarmasin, Kalimantan Selatan 70249",
    "(0511) 3258958",
    "Air minum, air bersih, air permukaaan, air limbah, udara ambien, usap alat/dinding lantai, usap linen, air, makanan, minuman, Udara",
    "23/05/2024",
    "",
  ],
  [
    "LP-489-IDN",
    "Yes",
    "PT Indonesia Asahan Aluminium",
    "Pabrik Peleburan Aluminium, Kuala Tanjung, Kec. Sei Suka, Kab. Batubara, Sumatera Utara 21257",
    "(0622) 31311",
    "Produk aluminium, alumina, kokas, aluminium fluorida, air bersih, air limbah",
    "07/07/2024",
    "",
  ],
  [
    "LP-490-IDN",
    "Yes",
    "Laboratorium Quality Assurance - Divisi Digital Services, PT Telekomunikasi Indonesia, Tbk",
    "Jl. Gegerkalong Hilir No. 47, Bandung Jawa Barat 40152",
    "(022) 4571050 - 4571051",
    "Digital fixed radio system point to point, wireless LAN, Bluetoth, perangkat HF, VHF, UHF, radio pemancar maritim, transponder Dense Wavelength Division Multiplexing (DWDM) untuk teresterial dan submarine, optical terminal multiplexer, sub system of reconfigurable optical add-drop multiplexer (ROADM), tuneable optical transponder, optical line terminal, perangkat kabel serat optik single mode berkonstruksi loose tube untuk aplikasi duct, perangkat kabel serat optik single mode G652D bertipe kering dan berkonstruksi single core per loose tube untuk aplikasi kabel udara, optical distribution frame, optical distribution cabinet, optical rossette (OR) sebagai terminasi fiber optik pada dinding sesuai BS 4662, perangkat blok terminal rumah kabel untuk layanan broadband, optical distribution frame untuk fiber termination management, optical distribution cabinet (ODC) dengan splitter, simplex G657A SC/UPC optical patch cord untuk FTTH, optical distribution point (ODP) aerial closure, optical distribution point (ODP) pole, optical distribution point (ODP) wall mounted, optical distribution point (ODP) pedestal, perangkat telekomunikasi berbasis internet protokol, baterai asam timbal berventilasi untuk system floating, baterai asam timbal untuk system floating, uninterruptible power supply (UPS) statis, rectifier indoor, baterai asam timbal stasioner untuk system catu daya charge-discharge,Pengujian EMC, kabel telepon udara berisolasi dan berselubung polietilen, berpenguat sendiri, kabel saluran rumah, saluran penanggal bawah tanah, saluran penanggal atas tanah (U-ES), tiang telepon besi dengan sambungan, bentuk taper segi delapan tahan korosi cuaca, pipa HDPE untuk kabel serat optic, ONT Retail for GPON, Open ONT Retail Dualband for GPON, ONT Retail Premium for GPON, L2/L3 Switch, Router, SDWAN-Edge, Baterai Lithium Ferro Phospate",
    "01/09/2024",
    "",
  ],
  [
    "LP-491-IDN",
    "Yes",
    "PT Traya Tirta Cisadane",
    "Jl. Raya Serpong No. 1-2, Serpong, Tangerang 15310",
    "(021) 7565528",
    "Air sungai, air limbah, air minum",
    "21/08/2024",
    "",
  ],
  [
    "LP-492-IDN",
    "Yes",
    "UPTD Balai Sertifikasi dan Pengendalian Mutu Barang Provinsi Kepulauan Bangka Belitung",
    "Jl. Depati Amir No.203 KM.3, Pangkalpinang 33134",
    "(0717) 422162",
    "Lada putih, Crude Palm Oil (CPO)",
    "31/08/2024",
    "",
  ],
  [
    "LP-493-IDN",
    "Yes",
    "BBalai Besar Pelaksana Jalan Nasional DKI Jakarta - Jawa Barat",
    "Jl. Ir. H. Juanda Km. 2, Komplek Binamarga, Cikampek, Jawa Barat",
    "(0264) 8311190",
    "Aspal keras/aspal cair/aspal emulsi, campuran braspal, agregrat, tanah, beton",
    "01/09/2024",
    "",
  ],
  [
    "LP-494-IDN",
    "Yes",
    "PT Carsurin Bontang",
    "Area Pelabuhan Bontang Coal Terminal, PT. Indo Tambangraya Megah, Tbk, Tanjung Meranggas, Bontang, Kalimantan Timur",
    "(0548) 26616",
    "Batubara",
    "18/11/2027",
    "",
  ],
  [
    "LP-495-IDN",
    "Yes",
    "PT Tudung Putra Putri Jaya \x{2013} Tudung Corporate Laboratory",
    "Jl Bintaro Raya No. 10A, Kebayoran Lama, Jakarta Selatan, DKI Jakarta",
    "(021) 7290110 ext.315",
    "Biskuit (Manis) atau Kukis atau Sweet Crackers, Biskuit Marie, biskuit stik colek, Biskuit Marie Salut, Roti Bagelen, biskuit lapis, Kukis (Cookies) dan Pai (Pie), Wafer, wafer roti, wafer salut, kukis, kukis gula, kukis oatmeal, egg roll, Krekers, Tidak Termasuk Krekers Manis, Produk Kakao dan Cokelat, Serbuk Minuman Berperisa, Minuman Isotonik Tidak Berkarbonat, Minuman Hipertonik Tidak Berkarbonat, Minuman Mengandung Jeli, Nata De Coco Dalam Minuman, Makanan Ringan Berbahan Dasar Kentang, Umbi, Serealia, Tepung atau Pati, Makanan Ringan Olahan Kacang, Seasoning, Garam, Minuman Berbasis Susu yang Berperisa, Saus Cabe, Minyak Goreng, Minyak Sayur,",
    "26/02/2028",
    "",
  ],
  [
    "LP-496-IDN",
    "Yes",
    "Balai Pengamanan Fasilitas Kesehatan Surabaya",
    "Jl. Karangmenjangan No. 22, Surabaya 60286",
    "(031) 5035830",
    "General X-Ray, mobile X-Ray, dental Intraoral X-Ray , dental Panoramic X-Ray, dental Chepalometric X-Ray, Fluoroscopy X-Ray, C-arm X-ray, Angiografi X-ray,CT-Scan, Digital Radiography (DR), Computed Radiography (CR), Mammografi x-ray, Magnetic Resonance Imaging (MRI), TLD",
    "28/07/2024",
    "",
  ],
  [
    "LP-497-IDN",
    "Yes",
    "PT Intertek Utama Services - Gosowong",
    "Gosowong Gold Project, PT. Nusa Halmahera Minerals, Drop Point 3, Gosowong, Halmahera, Kecamatan Kao, Kabupaten Halmahera Utara - 97764",
    "(021) 78846956 ext 4841",
    "Mineral batuan, larutan, Dore bullion",
    "18/11/2024",
    "",
  ],
  [
    "LP-498-IDN",
    "Yes",
    "PT Semen Tonasa",
    "Desa Biring Ere, Kec. Bungoro, Kab. Pangkep, Sulawesi Selatan",
    "(0410) 312345",
    "Batubara, Semen Portland, Semen Portland Komposit, Semen portland Pozzoland, klinker",
    "21/08/2024",
    "",
  ],
  ["LP-500-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  [
    "LP-501-IDN",
    "Yes",
    "PT. Prasadha Pamunah Limbah Industri",
    "Jalan Raya Narogong \x{2013} Desa Nambo, PO BOX 18 Cileungsi, Bogor, Jawa Barat",
    "(021) 86704042",
    "Air sungai, air tanah dan air limbah, soil/sedimen/sludge, limbah organik/bahan bakar sintesis, udara ambien, in oil, air minum, air permukaan, air sumur, air danau, Organik Liquid",
    "23/04/2024",
    "",
  ],
  [
    "LP-502-IDN",
    "Yes",
    "UPTD Balai Laboratorium Kesehatan Provinsi Sumatera Barat",
    "Jl. Gajah Mada (Gunung Pangilun) , Padang 25137",
    "(0751) 7054023",
    "Air minum, Air Untuk Keperluan Higiene Sanitasi, air badan air (Air sungai, air danau), air limbah",
    "24/09/2024",
    "",
  ],
  [
    "LP-503-IDN",
    "Yes",
    "PT. Barindo Anggun Industri",
    "Jl. Simopomahan No. 148 \x{2013} 150 P, Tandes \x{2013} Surabaya 60181",
    "(031) 7493333",
    "Meter air diameter : 15 mm-50mm, katup meter air",
    "15/09/2024",
    "",
  ],
  [
    "LP-504-IDN",
    "Yes",
    "Balai Pengujian Laik Jalan dan Sertifikasi Kendaraan Bermotor",
    "Jl. Raya Setu, Cibuntu \x{2013} Bekasi 17520",
    "(021) 8253353",
    "Emisi gas buang sepeda motor, Emisi gas buang light duty vehicle",
    "03/10/2024",
    "",
  ],
  [
    "LP-506-IDN",
    "Yes",
    "PT Asahimas Flat Glass, Tbk.",
    "Kawasan Industri Indotaisei, Sektor IA Blok M, Cikampek, Jawa Barat",
    "(021) 6904128; 6904041",
    "Kaca lembaran, kaca reflektif proses pirolisa, kaca berpola, kaca hemat energi, kaca cermin berlapis perak, kaca cermin berlapis aluminium",
    "21/08/2024",
    "",
  ],
  [
    "LP-507-IDN",
    "Yes",
    "UPTD Laboratorium Lingkungan Dinas Lingkungan Hidup dan Kehutanan Provinsi Kepualauan Bangka Belitung",
    "Komplek Perkantoran Pemerintah Provinsi Kepulauan Bangka Belitung, Air Itam, Pangkalpinang, Bangka Belitung",
    "(0717) 436975",
    "Air limbah, air permukaan, air sungai, air danau, udara emisi sumber gas tidak bergerak, udara ambien, lingkungan kerja, air laut, udara emisi sumber bergerak",
    "04/08/2024",
    "",
  ],
  [
    "LP-508-IDN",
    "Yes",
    "UPT Laboratorium Lingkungan Dinas Lingkungan Hidup Provinsi Jawa Timur",
    "Jl. Wisata Menanggal No. 38, Surabaya, Jawa Timur",
    "(031) 8543852 ; (031) 8541807",
    "Air tanah, air permukaan (air sungai, air danau), air limbah, limbah B3 (limbah padat, slurry, cairan), udara ambien, udara emisi",
    "24/09/2024",
    "",
  ],
  [
    "LP-509-IDN",
    "Yes",
    "Balai Pengujian Standar Instumen Tanaman Jeruk dan Buah Subtropika",
    "Jl. Raya Tlekung No. 1 Junrejo, Batu, Jawa Timur",
    "(0341) 592683",
    "Daun jeruk",
    "27/10/2025",
    "",
  ],
  [
    "LP-510-IDN",
    "Yes",
    "UPTD Balai Pengujian dan Sertifikasi Mutu Barang Provinsi Gorontalo",
    "Jl. Tinaloga No.4 Kecamatan Tilongkabila Kabupaten Bone Bolango Provinsi Gorontalo",
    "(0435) 830898",
    "Jagung, rumput laut, biji kakao, beras",
    "29/12/2024",
    "",
  ],
  ["LP-511-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  [
    "LP-512-IDN",
    "Yes",
    "PT SUCOFINDO Laboratorium Cabang Makassar (Multilokasi)",
    "Lokasi 1 : Jl. Urip Sumoharjo No. 90A, Makassar, Sulawesi Selatan Lokasi 2 : Jl Pattimura No. 58 Puuwatu Kota Kendari Lokasi 3 : Kawasan Industri PT. IMIP Jl. Trans Sulawesi Desa Fatupia Morowali",
    "(0451) 451890",
    "Batubara, air untuk keperluan higiene sanitasi, air permukaan (Air sungai dan air danau), air limbah, udara ambien, emisi tidak bergerak, kebisingan lingkungan, air laut, beton, nikel ore, semen, klinker, CPO",
    "27/10/2024",
    "",
  ],
  [
    "LP-513-IDN",
    "No",
    "",
    "",
    "",
    "",
    "",
    "Nomor digabung dengan LP-071-IDN",
  ],
  [
    "LP-514-IDN",
    "Yes",
    "PT Angler Biochemlab",
    "Jl. Sawo No. 17-19, Kel. Bringin, Kec. Sambikereb, Surabaya, Jawa Timur",
    "(031) 7456111",
    "Produk pertanian: Sayuran, buah dan sereal (Buah pome (apel, pir), Buah berbiji (aprikot, ceri, buah persik), Buah (melon, semangka), Sayuran umbi lapis (bawang merah, bawang putih, bawang bombai), Sayuran buah tomat, paprika, mentimun), Sayuran bunga (bunga kol, brokoli), Sayuran daun (selada, bayam), Sayuran batang dan tangkai (bawang perai, seledri, asparagus), Tanaman/makanan ternak (gandum untuk makanan ternak, alfalfa), Sayuran polong (buncis, kacang panjang), Sayuran akar (lobak), Daun teh, Jamur, Kacang - kacangan (kenari, kemiri, kastanye), Biji (bunga matahari, kapas, kacang kedelai, kacang tanah), Alpukat, Hops, Biji cokelat, Biji kopi, Rempah - rempah, Sayuran polong kering (kacang kedelai, kacang hijau), Serealia (gandum, jagung, padi), Sayuran akar (bit, wortel), Tanaman akar (kentang, ubi jalar, ubi kayu), Produk olahan tepung (mie, roti, kue, biskuit, spaghetti), Buah jeruk (jeruk lemon, jeruk mandarin, jeruk bali, jeruk peras), Buah berry (strawberry, blueberry, buah frambus), Kismis (kismis hitam, kismis merah, kismis putih), Anggur, Buah kiwi, Nanas, Hops, Cokelat fermentasi, Kopi, Teh, Rempah \x{2013} rempah, Padi",
    "17/12/2024",
    "",
  ],
  [
    "LP-516-IDN",
    "Yes",
    "PT Syslab",
    "Plaza Amsterdam Blok D-2, Sentul City, Bogor 16810",
    "(021) 87962155",
    "Air limbah, air permukaan, air minum, air bersih, air sungai, air danau, air laut, tanah/sedimen/sludge (B3), udara emisi, udara ambien, kebauan, udara lingkungan kerja, air laut, TCLP, Produk elektronik bagian logam dan bagian plastik untuk pengujian RoHS, tekstil, produk tekstil, pakaian bayi, garment, mainan anak (toys), Minyak lumas dan bahan bakar minyak",
    "23/04/2024",
    "",
  ],
  ["LP-517-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  [
    "LP-518-IDN",
    "Yes",
    "Balai Pengujian Standardisasi Instrumen Tanaman Aneka Kacang",
    "Jl. Raya Kendalpayak Km. 8, Kotak Pos 66 Malang 65101",
    "(0341) 801468",
    "Tanah, Biji (kedelai, kacang tanah dan kacang hijau), Benih (kedelai, kacang tanah dan kacang hijau)",
    "15/10/2024",
    "",
  ],
  [
    "LP-520-IDN",
    "Yes",
    "Departemen Teknik Metalurgi dan Material Fakultas Teknik Universitas Indonesia",
    "Departemen Teknik Metalurgi dan Material FTUI, Kampus Baru UI - Depok 16424",
    "(021) 78849045",
    "Baja lembaran dan gulungan lapis paduan aluminium seng (Bj. Las), baja lembaran pelat dan gulungan canai panas (Bj. P), baja profil I-Beam proses canai panas (Bj. P I-Beam), Baja profil kanal U proses canai panas (Bj. P Kanal U), Baja profil siku sama kaki proses canai panas (Bj. P Siku Sama Kaki), Baja profil Wf-Beam proses canai panas (Bj. P Wf Beam), Baja tulangan beton dalam bentuk gulungan, baja tulangan beton hasil canai panas ulang, Baka pelat, strip dan lembaran canai panas untuk tabung gas, baja tulangan beton untuk ukuran P6-P19, logam dan produknya, non ferrous, produk Lasan",
    "28/07/2024",
    "",
  ],
  [
    "LP-521-IDN",
    "Yes",
    "Laboratorium Jasa Pengujian dan Penelitian (Qlab) Fakultas Farmasi Universitas Pancasila",
    "Srengseng Sawah, Jagakarsa \x{2013} Jakarta 12640",
    "(021) 786 4727/28",
    "Suplemen tablet tidak bersalut, suplemen kapsul cangkang keras, suplemen kapsul lunak, gula sukrosa, cairan, larutan, suplemen kapsul, suplemen tablet, sediaan cair (larutan, suspensi, emulsi), produk preparat multivitamin dan mineral (sediaan tablet, kapsul, cairan, kategori 1 (sediaan optalmik yang dibuat dengan dasar atau pembawa air), kategori 2 (sediaan topikal yang dibuat dengan dasar atau pembawa air), kategori 3 (sediaan oral selain antasida dibuat dengan dasar atau pembawa air), produk obat dan bahan alam (tablet, kapsul, serbuk, cair)",
    "15/09/2024",
    "",
  ],
  [
    "LP-522-IDN",
    "Yes",
    "PT Petrolab Services (multilokasi)",
    "Lokasi 1 : Jl. Pisangan Lama III No. 28, Jatinegara - Jakarta Timur 13230 Lokasi 2 : Jl. Jend. Sudirman No. 874, Sepinggan, Balikpapan 76114, Kalimantan Timur",
    "(021) 4717001",
    "Lokasi 1 : Biodisel, Fuel, Lubricant (new and used oil), oil transformer, air minum, air bersih, air permukaan, air limbah, air laut, air untuk keperluan hygiene dan sanitasi, air sungai, emisi sumber tidak bergerak, Udara Emisi Sumber Bergerak, manusia, tanah/sedimen/sludge, udara ambien, udara lingkungan kerja, Darah, AMDK (Air Mineral), CPO, Minyak lumas motor bensin 4 (empat) langkah kendaraan bermotor , Minyak lumas motor diesel putaran tinggi , Minyak lumas motor bensin 4 (empat) langkah sepeda motor, Minyak lumas roda gigi transmisi manual dan gardan, solar, grease, base oil, Turbine Oil Terpakai,Transformer Oil Terpakai, Fuel Oil (MFO), Grease New, Grease Pakai, Water Coolant, Insulating Paper, Biodiesel (B20, B30, B40)",
    "12/06/2024",
    "",
  ],
  ["LP-523-IDN", "No", "", "", "", "", "", "Nomor Akreditasi dicabut"],
  [
    "LP-524-IDN",
    "Yes",
    "Laboratorium Cabang Balikpapan, PT Sucofindo (Persero)",
    "Lokasi 1 : Jl. Jend. A. Yani No. 1, Gunung Sari Ulu, Balikpapan 76122 Lokasi 2 : Janju km 10 Tanah Merah Coal, Tanah Grogot Lokasi 3 : Unit Pelayanan Tanah Grogot, Tanah Merah Coal terminal",
    "(0542) 732186/88",
    "Lokasi 1 : Batubara, air limbah, air sungai, air minum, air kebutuhan higiena sanitasi, emissions - stationary source",
    "24/02/2025",
    "",
  ],
  [
    "LP-525-IDN",
    "Yes",
    "PT Turangga Tosan Indonesia",
    "Jl. Raya Puspiptek No. 78, Kp. Ampera Poncol, RT/RW. 007/002, Babakan, Setu, Kota Tangerang Selatan 15315",
    "(021) 7560684",
    "Sepeda roda dua, mainan, sepeda anak",
    "16/12/2024",
    "",
  ],
  [
    "LP-526-IDN",
    "Yes",
    "Pusat Penelitian Gula Indonesia, PT Perkebunan Nusantara X",
    "Dusun Jengkol, Desa Plosokidul, Kec. Plosklaten, Kab. Kediri, Jawa Timur",
    "(0354) 443841",
    "Tanah, pupuk anorganik (ZA, urea, SP 36, KCl, NPK), pupuk organik padat, pupuk organik cair",
    "19/04/2025",
    "",
  ],
  [
    "LP-528-IDN",
    "Yes",
    "UPTD Laboratorium Pembinaan dan Pengujian Mutu Hasil Perikanan Provinsi Nangroe Aceh Darussalam",
    "Jl. S.M. Raja Ujung, Komplek Pelabuhan Perikanan, Lampulo, Banda Aceh",
    "(0651) 7400552",
    "Udang beku (frozen shrimp), tuna segar, tuna beku, udang segar",
    "01/12/2024",
    "",
  ],
  ["LP-529-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  [
    "LP-530-IDN",
    "Yes",
    "Balai Teknik Kesehatan Lingkungan dan Pengendalian Penyakit Kelas I Makassar",
    "Jl. Wijaya Kusuma Raya No. 29-31, Makassar",
    "(0411) 871620",
    "Air minum, air untuk keperluan higiene dan sanitasi, air sungai, air limbah",
    "15/09/2024",
    "",
  ],
  ["LP-531-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  [
    "LP-532-IDN",
    "No",
    "",
    "",
    "",
    "",
    "",
    "Nomor digabung dengan LP-531-IDN",
  ],
  [
    "LP-533-IDN",
    "Yes",
    "UPT Pengawasan dan Sertifikasi Benih Provinsi Kalimantan Barat",
    "Jl. Alianyang Gg. Kurnia No. 127, Pontianak 78116",
    "(0561) 742758",
    "Benih tanaman pangan : padi (oryza sativa), jagung (zea mays), kedelai (glyvine max)",
    "17/12/2024",
    "",
  ],
  [
    "LP-534-IDN",
    "Yes",
    "UPT Pengujian dan Sertifikasi Mutu Barang, Dinas Perindustrian dan Perdagangan Provinsi Sulawesi Tengah",
    "Jl. R.A Kartini No. 43, Palu 94112",
    "(0451) 424532",
    "Beras, gabah, jagung, rumput laut, biji kakao,kakao bubuk, kopra, biji kopi, cengkeh, bawang merah goreng",
    "16/12/2024",
    "",
  ],
  [
    "LP-535-IDN",
    "Yes",
    "Stasiun Karantina Ikan, Pengendalian Mutu dan Keamanan Hasil Perikanan Batam",
    "Jl. M. Nahar No. 1, Batam Centre, Batam, Kepulauan Riau",
    "(0778) 470320",
    "Ikan air laut segar dan beku (salmon, tongkol, benggol, mata besar, sarden, layang, baronang, tuna, kakap segar, tenggiri), air pengolahan, lele, ikan mas, Cyprinidae, Anguillidae, ikan sebelah, ikan nila, koki, gurame, kerapu, kura-kura, buaya, Gold fish, belanak, patin, bawal, kakap, kembung, selar, ikan ekor kuning, cupang, salmon, komet, red parot, moly, koi, udang belalang, sirip hiu, kepiting, lobster, udang windu dan vannamei, ikan dan produk perikana yang dikukus dan rebus dan/atau goreng/panggang (bakso ikan, bakso udang, udang tempura, udang masak), ikan nila, Udang (yellowleg shrimp, giant tiger prawn, northern white shrimp, blue shrimp, white leg shrimp)",
    "15/03/2025",
    "",
  ],
  [
    "LP-536-IDN",
    "Yes",
    "PT Freyabadi Indotama",
    "Jl. Maligi III Lot J No.2A, Kawasan Industri KIIC, Karawang 41361",
    "(021) 89109135-36",
    "Coklat olahan",
    "18/08/2024",
    "",
  ],
  [
    "LP-537-IDN",
    "Yes",
    "Balai Karantina Ikan, Pengendalian Mutu dan Keamanan Hasil Perikanan Lampung",
    "Jl. Soekarno Hatta No.91 Km 6-7 Campang Raya, Bandar Lampung",
    "(0721) 770087",
    "Udang, Rajungan, cumi, Kerang darah, kerang hijau, Ikan tongkol, ikan patin, ikan kakap, Ikan kembung, ikan kerapu, ikan barakuda, ikan baronang, ikan layang, Produk perikanan (Frozen value added shrimp, Frozen value added squid, Frozen value added Lobster, Canned Pasteurized lobster meat, Pasteurized crabmeat, Frozen raw shrimp, Frozen cooked shrimp, frozen cephalopods, Frozen Hard callm, Frozen demersal fish, Frozen snail, Canned snail), Ikan nila, Lele, sidat, mas, koki, Koi, Gurame, Ikan demersal, Udang penaeid (udang vannamei, udang windu, udang biru, udang galah, lobster, kepiting), cacing, Artemia, Ikan Simba, Ikan Bawal, Ikan Cupang, Ikan Guppy, Udang segar, udang beku, rajungan, Ikan kembung segar, Udang breaded",
    "19/04/2025",
    "",
  ],
  ["LP-538-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  [
    "LP-540-IDN",
    "Yes",
    "PT Jasa Mutu Mineral Indonesia (multilokasi)",
    "Lokasi 1 : Jl. Rapak Indah No. 189, Samarinda, Kalimantan timur 75126 Lokasi 2 : Desa Punagaya, kec. Bangkalan, Kabupaten Jeneponto, Sulawesi Selatan",
    "(0541) 6276886",
    "Lokasi 1 : Batubara, mineral",
    "15/09/2024",
    "",
  ],
  [
    "LP-541-IDN",
    "Yes",
    "Stasiun Karantina Ikan, Pengendalian Mutu dan Keamanan Hasil Perikanan Cirebon",
    "Jl. Cideng Indah No. 236 A, Kedawung, Cirebon, Jawa Barat",
    "(0231) 248857",
    "Ikan air tawar (ikan mas, gurame, nila, lele, patin, belut, nilem, tambakan), Ikan hias air tawar (komet, cupang, palty, guppy, koi), Ikan air payau (udang vannamei, udang windu, udang putih), Dreid Crab Shell, fish meal, tepung cumi, abuk udang, Air dan Es, Produk perikanan (frozen fish, surimi, breaded shrimp beku, daging kepiting, udang beku, ikan segar, udang segar, bakso ikan dan cumi-cumi beku), Isolat Bakteri, Air Tambak, Air Tanah, Air laut, Air sungai, Ikan segar (Balakutak, Bawal hitam, Cephalopoda, cumi-cumi, ikan Acang-acang, ikan alu-alu, ikan Ayam-ayam, ikan Bandeng, ikan Banjar, ikan Barakuda, ikan Bawal hitam, Ikan Bawal putih, ikan Belanak, ikan Bentrong, ikan Cakalang, ikan Coklatan, ikan Cucut, ikan Ekor kuning, ikan Gurame, ikan Hiu, ikan Kakap, ikan Kapasan, ikan Kembung Banjar, ikan Kembung Como, ikan Kerapu, ikan Kerong-kerong, ikan Ketong, ikan Kuwe, ikan Kumisan, ikan kurisi, ikan Kuro, ikan Lajan, ikan Layang, ikan Layur, ikan Lele, ikan lemuru, ikan Lencam, ikan Manyung, ikan Mata goyang, ikan Mata sebelah, ikan Nila, ikan Pari, ikan Petek, ikan Porang-porang, ikan Remang, ikan Samge, ikan Sebelah, ikan Selaget, ikan Selar, ikan Semar, ikan Talang, ikan Tanjan, Ikan Tembang, ikan Tenggiri, ikan Teri, ikan Teros, ikan Tiga waja, ikan Tongkol, ikan Tuna, ikan Wais, ikan Kakap putih, kerang bulu, Kerang Darah, kerang simping), ikan beku (Cephalopoda, Cumi-cumi, Fillet frozen patin, Fillet ikan dori, Fillet ikan sidat, Frozen Banana Shrimp, Frozen cuttle fish, Frozen fish steak, Frozen mackarel, Frozen pangasius fillet, Frozen ribbon fish, Frozen samge, makarel fillet, red mullet, ikan sidat, udang vannamei, udang windu), ikan kering /teripang kering, olahan ikan (bakso ikan kuah, ebi Panko, kerupuk udang, otak-otak, Shumai furai, ikan teri asin, kerang hijau rebus), Frozen Scallop Meat Roe Off, Kerang hijau, Kerang bulu, Kerang darah",
    "17/12/2024",
    "",
  ],
  [
    "LP-543-IDN",
    "Yes",
    "Balai Standardisasi dan Pelayanan Jasa Industri Banjarbaru",
    "JJl. Panglima Batur Barat No. 2, Banjarbaru, Kalimantan Selatan",
    "(0511) 4772461",
    "Pupuk fosfat alam untuk pertanian, pupuk NPK padat, pupuk KCl, AMDK (air mineral, air demineral), garam konsumsi yodium, air sumur, air danau, air sungai, air muara, air rawa, air situ, air mata air, air waduk, air akuifer, air limbah, udara ambien, udara emisi sumber tidak bergerak, kebisingan, lingkungan kerja, papan partikel",
    "15/03/2025",
    "",
  ],
  [
    "LP-544-IDN",
    "Yes",
    "UPTD Balai Pengawasan dan Sertifikasi Benih Provinsi Sumatera Barat",
    "Jl. H.A. Amarullah, Kotak Pos 30, Bukittinggi",
    "(0752) 22226",
    "Kedelai, padi, jagung, kacang tanah, kacang hijau, tomat, cabai, mentimun, kacang panjang, kubis, kangkung, bayam cabut, semangka, petsai, wortel, kacang buncis dan terong",
    "30/06/2025",
    "",
  ],
  ["LP-545-IDN", "No", "", "", "", "", "", "Nomor Akreditasi dicabut"],
  [
    "LP-546-IDN",
    "Yes",
    "Politeknik Manufaktur Ceper",
    "Batur, Tegalrejo, Ceper, Klaten, Jawa Tengah",
    "(0272) 552968",
    "Ferro dan non-Ferro",
    "30/06/2025",
    "",
  ],
  [
    "LP-547-IDN",
    "Yes",
    "PT Sucofindo (Persero) - Laboratorium Cabang Batam",
    "Jl. Raden Patah No. 61, Baloi, Batam, Kepulauan Riau",
    "(0778) 456575",
    "Air bersih, air sumur, air waduk, air sungai, air rawa, air danau, air limbah, udara ambient, kebisingan lingkungan, emission-stationary source, Crude Palm Oil (CPO), Tin Ingot",
    "28/04/2025",
    "",
  ],
  [
    "LP-548-IDN",
    "Yes",
    "PT Geoservices Bandung",
    "Jl. Setiabudi No. 79-81, Bandung",
    "(022) 2031316; 2035436",
    "Batubara",
    "24/02/2025",
    "",
  ],
  ["LP-549-IDN", "No", "", "", "", "", "", "Nomor Akreditasi dicabut"],
  [
    "LP-550-IDN",
    "Yes",
    "Stasiun Karantina Ikan, Pengendalian Mutu dan Keamanan Hasil Perikanan Merauke",
    "Jl. Garuda Spadem, Kotak Pos 263, Merauke, Papua",
    "(0971) 324169",
    "Ikan air tawar, ikan lele, kodok, udang putih dan udang windu, ikan segar, ikan beku, ikan mas, ikan koi, ikan nila, udang zebra, kepiting",
    "01/12/2024",
    "",
  ],
  [
    "LP-551-IDN",
    "Yes",
    "UPT Laboratorium Kesehatan Daerah Provinsi Sumatera Utara",
    "Jl. Williem Iskandar Pasar V Barat I No. 4, Medan Estate, Sumatera Utara",
    "(061) 6617079",
    "Air minum, air bersih, air limbah, air permukaan, air minum dalam kemasan (AMDK), coconut milk powder, daging ayam segar dan beku, Lantai, dinding, Alat makan, Alat medis, linen",
    "26/12/2025",
    "",
  ],
  [
    "LP-552-IDN",
    "Yes",
    "PDAM Surya Sembada Kota Surabaya",
    "Lokasi 1 : Jl. Prof. Dr. Moestopo No. 2, Surabaya, Jawa Timur Lokasi 2 : Jl. Mastrip 56A, Karangpilang, Surabaya",
    "(031) 5039373",
    "Air sungai, air untuk keperluan higiene sanitasi, air minum, air mineral, air limbah",
    "29/05/2025",
    "",
  ],
  [
    "LP-553-IDN",
    "Yes",
    "UPTD Balai Pengujian dan Sertifikasi Mutu Barang Dinas Perdagangan dan Perindustrian Provinsi Bali",
    "Jl. Raya Puputan Niti Mandala, Renon, Denpasar 802",
    "(0361) 231961",
    "Biji kopi, panili, biji kakao",
    "15/03/2025",
    "",
  ],
  [
    "LP-554-IDN",
    "Yes",
    "Balai Karantina Ikan, Pengendalian Mutu dan Keamanan Hasil Perikanan Entikong",
    "Jl. Raya Entikong Km. 5, Kec. Entikong, Kab. Sanggau, Entikong, Kalimantan Barat",
    "(0564) 31845",
    "Udang putih (Litopenaeus vannamei), Ikan lele (clarias sp), ikan patin (pangasius sp) dan ikan mas (cyprinus carpio), ikan nila (oreochromis niloticus), udang (penaeus sp, linopeaeus sp), kepiting (scylla serrata), Rajungan ( portunus pelagicus),kekerangan, produk perikanan dan bahan olahan produk perikanan, ikan beku, ikan segar, udang segar, udang beku, ikan asin, ikan asap, Cephalopods segar dan beku, ikan lele (Clarias sp.), Ikan gurame (Osphronemus goramy), ikan mas (Cyprinus carpio), ikan Nila (oreochromic niloticus).",
    "24/09/2024",
    "",
  ],
  ["LP-555-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  [
    "LP-556-IDN",
    "Yes",
    "Balai Penelitian Lingkungan Pertanian",
    "Jl. Raya Jakenan \x{2013} Jaken Km. 05, Jakenan-Pati, Jawa Tengah",
    "(0295) 4749044",
    "Tanah, air irigasi, tanaman pangan (padi/beras), tanaman hortikulutra (kubis, kacang panjang, sawi apel, melon, cabai, bawang merah, kentang), udara emisi lingkungan pertanian, formulasi pestisida, pupuk organik padat",
    "30/09/2024",
    "",
  ],
  ["LP-557-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  [
    "LP-558-IDN",
    "Yes",
    "Laboratorium Kualitas Udara, Teknik Sipil dan Lingkungan \x{2013} Institut Teknologi Bandung",
    "Gedung Teknik Lingkungan, LabTek IX/C Lt. 5, Jl. Ganesha No. 10, Bandung",
    "(022) 2534189",
    "Udara ambien, kebauan, emisi sumber tidak bergerak, kebisingan lingkungan, masker (masker medis dan masker kain)",
    "20/09/2025",
    "",
  ],
  [
    "LP-559-IDN",
    "Yes",
    "PT Printec Perkasa 2",
    "Jl. Industri Utama Blok SS, Kav. 4-5, Kawasan Industri Jababeka II, Cikarang Utara, Bekasi 17550",
    "(021) 8937888",
    "Paint and similar surface coating materials, toy substrate materials, coating of paint, vanish, lacquer, printing ink, polymer and similar coatings, polymeric and similar materials, including laminates, whether textile reinforced or not, but excluding other textiles, paper and paper board, textiles, whether natural or synthetic, other material, whether colored or not, paints, including finger paints, vanishes, lacquers, glazing powders and similar materials in solid or in liquid form, surface coating material",
    "27/10/2024",
    "",
  ],
  ["LP-560-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  [
    "LP-561-IDN",
    "Yes",
    "UPTD Pengujian Mutu dan Pengembangan Produk Kelautan dan Perikanan Provinsi Kepulauan Riau",
    "Jl. Sultan Machmud No. 13 Tanjung Pinang",
    "(0771) 24291",
    "Ikan beku : Tongkol, Sarden, ekor kuning, embung, cumi, Malong, hiu",
    "21/06/2025",
    "",
  ],
  [
    "LP-564-IDN",
    "Yes",
    "Laboratorium Sentral Ilmu Hayati Universitas Brawijaya",
    "Jl. Veteran, Malang, Jawa Timur",
    "(0341) 559054",
    "Tepung terigu, biskuit, Minuman berperisa, perisa/flavour cair, Air minum dalam kemasan (AMDK), Daging dan produk olahannya (daging, bakso, sosis, abon, nuget), Kultur sel",
    "25/07/2026",
    "",
  ],
  [
    "LP-565-IDN",
    "Yes",
    "PT Anugrah Analisis Sempurna",
    "Jl. Raya Jakarta - Bogor KM. 37 RT 05/04, Kel. Sukamaju, Kec. Cilodong, Depok, Jawa Barat",
    "(021) 29629393",
    "Air limbah, Air permukaan, air bersih/air tanah, air untuk keperluan higiene dan sanitasi, air minum, air laut, udara lingkungan kerja, Industrial Higiene, udara ambien, emisi gas buang sumber tidak bergerak, emisi gas buang sumber bergerak, Darah, urine, sludge/tanah, Air, biskuit, Rempah bubuk, Susu, Margarin, swab pada Peralatan, mie instan, Produk daging, produk perikanan, produk pestisida, Pupuk amonium sulfat, Pupuk Fosfat alam untuk pertanian, Pupuk kalium Klorida, Pupuk NPK padat, Pupuk SP-36, Pupuk tripel posfat, Pupuk Urea, Minuman beralkohol, limbah B3 (cair, semi padat, slurry, padat, sludge (TCLP), Fly Ash Bottom Ash",
    "15/03/2025",
    "",
  ],
  [
    "LP-566-IDN",
    "Yes",
    "Balai Besar Riset Budidaya Laut dan Penyuluhan Perikanan Banjar Dinas Gondol",
    "Dusun Gondol, Desa Penyabangan, Kec. Gerokgak, Kab. Buleleng, Singaraja - Bali",
    "(0362) 92278",
    "Udang segar, ikan segar, air laut, air payau, air permukaan, pakan dan bahan pakan ikan",
    "16/02/2025",
    "",
  ],
  [
    "LP-567-IDN",
    "Yes",
    "Balai Riset Perikanan Budidaya Air Payau dan Penyuluhan Perikanan (Status dibekukan sementara per 13 Maret 2023)",
    "Jl. Makmur Dg. Sitakka No. 129, Maros - Sulawesi Selatan 90512",
    "(0411) 371544",
    "Udang air payau, sedimen/tanah, air payau, air tawar dan air laut, bahan pakan, pakan, ikan dan udang, rumput laut",
    "29/12/2024",
    "",
  ],
  [
    "LP-568-IDN",
    "Yes",
    "PT Ecosindo Laboranusa",
    "Graha Senta, Jl. Siliwangi No. 80, Bekasi",
    "(021) 82407113",
    "Air untuk keperluan higiene sanitasi, air minum, AMDK, air limbah, air sumur, air sungai, air waduk, air laut, udara ambien, lingkungan kerja, udara emisi sumber tidak bergerak, udara emisi sumber bergerak, kebisingan",
    "15/03/2025",
    "",
  ],
  ["LP-569-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  [
    "LP-570-IDN",
    "Yes",
    "PT Sadikun Niagamas Raya",
    "Jl. Diponegoro KM. 40 No.62, Jatimulya Tambun Selatan, Bekasi, Jawa Barat",
    "(021) 8814646",
    "New Oil (Engine oil, industrial oil), Used oil (Engine oil, industrial oil), Bahan bakar diesel (solar), Fresh Engine &amp; Industrial Oil (Minyak Lumas Motor Bensin 4 Langkah Kendaran bermotor, Minyak Lumas Motor Bensin 4 Langkah Kendaraan Sepeda Motor, Minyak Lumas Motor Bensin 2 Langkah, Minyak Lumas Roda Gigi Kendaraan, Minyak Lumas Hidrolik, Minyak Lumas Roda Gigi Industri, Minyak Lumas Transformator), VI improver, Di package, base oil (minyak dasar), Cutting oil, Hidrosafe oil, coolant dan pelumas water base (new &amp; used oil)",
    "17/12/2024",
    "",
  ],
  [
    "LP-571-IDN",
    "Yes",
    "Balai Karantina Ikan, Pengendalian Mutu dan Keamanan Hasil Perikanan Semarang",
    "Jl. Dr. Suratmo No. 28, Kembang Arum, Semarang",
    "(024) 76671020",
    "Ikan air tawar, ikan air laut, produk perikanan, udang, tepung ikan, ikan Bandeng, ikan Kerapu, ikan Nila, ikan Mackerel, ikan Salmon",
    "21/06/2025",
    "",
  ],
  [
    "LP-572-IDN",
    "Yes",
    "PT Envilab Indonesia",
    "Manyar MA Karimun Industrial Business Park No. B-35, Jl. Raya Manyar, Kabupaten Gresik, Jawa Timur",
    "(031) 99006835",
    "Udara ambien, udara lingkungan kerja, Lantai dan dinding, udara emisi sumber tidak bergerak, Emisi kendaraan, air limbah, air laut, air bersih, air permukaan (Air sungai, air sumur, air danau, air waduk, air muara), air minum (air mineral, air demineral, air mineral alami), Lingkungan, limbah padat &amp; cair, tanah , TLCP sampel tanah, sedimen dan limbah padat, limbah B3, air untuk keperluan higiene dan sanitasi, air sungai",
    "16/02/2025",
    "",
  ],
  [
    "LP-573-IDN",
    "Yes",
    "Balai Karantina Ikan, Pengendalian Mutu dan Keamanan Hasil Perikanan Surabaya II",
    "Jl. Sawungguling No. 177-183, Taman Sidoarjo, Jawa Timur",
    "(031) 7873151",
    "Ikan mas, koi, koki, komet, nila, gurame, udang windu dan vannamae, ikan air tawar, penaide, tepung ikan, crab shell, kerapu, belut, ikan air laut, udang beku, bandeng, ikan beku, ikan lele, patin, kepiting, ikan pelagis, ikan demersal, udang, cephalopoda, produk ikan, ikan kering, air dan es, udang budidaya, udang laut hidup, segar dan beku, Mackarel, Sardines, Tuna, Cakalang, Tongkol, Tenggiri, Atlantic Salmon, Coho Salmo, Brown Trout, Rainbow trout, Chum Salmon, Pink Salmon, Sockeye Salmon, Goldfish, Rainbow trout, Kakap Merah, Kakap Putih/ Barramundi/Seabass, Lele Dumbo/ Sharptooth African Catfish, Lele lokal/ Walking Catfish, Nila, Gurami, Patin, Kerapu/ Grouper",
    "19/04/2025",
    "",
  ],
  ["LP-574-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  [
    "LP-578-IDN",
    "Yes",
    "PT Geoservices Batulicin",
    "Jl. Manggis No. 163, RT 08 RW 02, Kec. Batulicin, Kab. Tanah Bumbu, Kalimantan Selatan (lokasi 1) Jl. Jenderal Sudirman No. 335 AB, Kotabaru, Kalimantan Selatan (lokasi 2)",
    "(0518) 71972",
    "Batubara",
    "23/05/2026",
    "",
  ],
  [
    "LP-579-IDN",
    "Yes",
    "PT Multi Instrumentasi",
    "Jl. Tengah Gedebage No. 4, Ujung Berung, Bandung",
    "(022) 7803484",
    "Meter air",
    "27/07/2025",
    "",
  ],
  [
    "LP-580-IDN",
    "Yes",
    "Balai Pengawas Obat dan Makanan di Palu",
    "Jl. Undata No. 3, Palu, Sulawesi Tengah 94111",
    "(0451) 428738; 423088",
    "Terapetik (tablet, kapsul, suspensi, sediaan tetes mata, tetes telinga, sediaan serbuk, asam salsilat dalam bedak campuran), NAPZA, obat tradisional dan produk komplemen, kosmetika, pangan",
    "17/11/2024",
    "",
  ],
  [
    "LP-582-IDN",
    "Yes",
    "PT Perkebunan Nusantara IV",
    "Jl. Letjend. Suprapto No. 2, Medan, Sumatera Utara",
    "(061) 4154666",
    "Minyak sawit mentah, minyak inti sawit, bungkil inti sawit, air umpan, air kation, air anion, air ketel, inti sawit (kenel), teh hitam",
    "22/11/2026",
    "",
  ],
  [
    "LP-586-IDN",
    "Yes",
    "Stasiun Karantina Ikan Pengendalian Mutu dan Keamanan Hasil Perikanan Palembang",
    "Jl. Gubernur Haji asnawi mangku alam Palembang",
    "(0711) 7080089",
    "Ikan air tawar, ikan air laut, ikan mas dan ikan koi, ikan mas koki, lele, nila, belut, karper, cupang, molly, sepat, cichlid, platy, neon tetra, oscar, gurame, udang vanamei, udang windu, belut, kepiting, produk bahan makanan asal ikan, paha kodok, ubur-ubur",
    "31/01/2025",
    "",
  ],
  ["LP-587-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  [
    "LP-588-IDN",
    "Yes",
    "UPT Pengawasan dan Sertifikasi Benih Provinsi Nusa Tenggara Timur",
    "JL. Alfons Nisnoni No. 15, Kupang \x{2013} Nusa Tenggara Timur",
    "(0380) 823313",
    "Tanaman pangan (padi, jagung, kedelai, kacang hijau, kacang tanah), tanaman hortikultura (kangkung, bayam, ketimun, tomat, wortel, buncis, kacang panjang, petsay, kool, cabe, terung)",
    "15/03/2025",
    "",
  ],
  [
    "LP-589-IDN",
    "Yes",
    "Balai Besar Pengujian Mutu dan Sertifikasi Obat Hewan",
    "Jl. Raya Pembangunan Gunungsindur, Bogor, Jawa Barat",
    "(021) 7560489 ; 7560466",
    "Vaksin inaktif Coryza, vaksin inaktif Fowl Cholera, probiotik Bacillus subtilis, vaksin inaktif salmonella enteritidis, vaksin aktif mycoplasma gallisepticum, vaksin inaktif septicemia epizootica, vaksin aktif brucella, vaksin aktif anthrax, vaksin aktif virus unggas, vaksin aktif virus non unggas, vaksin inaktif virus unggas, vaksin inaktif virus non unggas, obat umum (injeksi), antibiotik (injeksi) dengan pelarut air, antibiotik (injeksi) dengan pelarut minyak, serum salmonella, vaksin aktif newcastle disease, serum dan virus newcastle disease, vaksin inaktif newcastle disease, vaksin aktif newcastle disease, vaksin aktif infectious bronchitis, vaksin inaktif infectious bronchitis, virus inaktif egg drop syndrome, serum dan antigen egg drop syndrome, vaksin aktif infectious laryngo tracheitis, vaksin aktif chicken anemia agent, vaksin aktif mareks disease, vaksin aktif infectious bursal disease, vaksin inaktif infectious bursal disease, vaksin inaktif avian influenza, serum dan virus avian influenza, vaksin aktif avian influenza, vaksin aktif avian encephalomyelitis, vaksin aktif swollen head syndrome, vaksin aktif viral arthritis, vaksin aktif bovine viral diarrhea, vaksin aktif infectious bovine rhinotracheitis, vaksin aktif fowl pox, vaksin aktif canine distemper, vaksin aktif canine contagious hepatitis, vaksin aktif canine parvovirus, vaksin aktif canine para influenza, vaksin aktif feline calici virus, vaksin aktif feline viral rhinotracheitis, serum avian influenza (Al), antigen avian influenza (Al), oksitetra siklin injkesi, sulfadiazin-trimethoprim serbuk, tilosin injeksi, enrofloksasin serbuk, amoksisilin serbuk, siprofloksasin serbuk, oksitetrasiklin injeksi, otak anjing/mencit, unggas hidup/mati, organ/jaringan, doksisiklin serbuk, obat hewan Ampicilin, obat hewan Albendazole, Tetrasiklin serbuk, Oksitetrasiklin (serbuk, injeksi), Tilosin (serbuk, Injeksi), Eritromisin serbuk, Linkomisin serbuk, Spektinomisin serbuk",
    "16/02/2025",
    "",
  ],
  [
    "LP-590-IDN",
    "Yes",
    "Balai Teknik Kesehatan Lingkungan dan Pengendalian Penyakit Kelas I Manado",
    "Jl. Adipura Raya Lingkungan X, Kel. Paniki Bawah, Kec. Mapanget, Manado, Sulawesi Utara",
    "(0431) 818140",
    "Air minum, air bersih, air sungai, air limbah, udara ambien, kebisingan lingkungan, emisi sumber bergerak, emisi sumber tidak bergerak",
    "21/03/2026",
    "",
  ],
  ["LP-591-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  [
    "LP-592-IDN",
    "Yes",
    "Pusat Penelitian Kopi dan Kakao",
    "Jl. P.B Sudirman No. 90 Jember, Jawa Timur",
    "(0331) 757130",
    "Tanah, jaringan tanaman, pupuk organik, pupuk NPK padat, pupuk urea, pupuk TSP, pupuk ZA, pupuk KCl, pupuk super phosphat tunggal, biji kopi, biji kakao, mesin pengering tipe bak datar",
    "18/10/2025",
    "",
  ],
  [
    "LP-594-IDN",
    "Yes",
    "PT Suzuki Indomobil Motor - Laboratorium Uji Emisi",
    "Jl. Diponegoro km 38,2, Tambun, Bekasi, Jawa Barat",
    "(021) 8807401",
    "Kendaraan baru 2W, kendaraan baru 4 W",
    "21/03/2026",
    "",
  ],
  [
    "LP-595-IDN",
    "Yes",
    "Deputi Bidang Infrastuktur Riset dan Inovasi - Direktorat Pengelolaan Fasilitas Ketenaganukliran - LP Teknologi Radiosotop dan Radiofarmaka - BRIN",
    "Gedung 11 Kawasan Puspiptek, Serpong \x{2013} Tangerang Selatan",
    "(021) 7563141",
    "Senyawa bertanda (153 Sm-EDTMP, 131 I-MIBG), kit radiofarmaka (MIBI, MDP, DTPA)",
    "21/06/2025",
    "",
  ],
  [
    "LP-597-IDN",
    "Yes",
    "Pusat Pengembangan Pengujian Obat dan Makanan Nasional",
    "Jl. Percetakan Negara No. 23, Jakarta Pusat, DKI Jakarta",
    "(021) 4245015",
    "Obat dan Napza:",
    "25/07/2026",
    "",
  ],
  [
    "LP-598-IDN",
    "Yes",
    "Balai Standardisasi dan Pelayanan Jasa Industri Bandar Lampung",
    "Jl. By Pass Soekarno Hatta Km I Raja Basa, Bandar Lampung",
    "(0721) 706353",
    "Gula kristal putih, minyak goreng sawit, pupuk TSP, pupuk dolomit, pupuk urea, pupuk NPK padat, pupuk KCl, pupuk amonium sulfat, garam bahan baku, gula kristal mentah, gula kristal putih, gula kristal mentah, garam konsumsi beryodium, garam bahan baku, air mineral, tepung tapioka, air imbah, air sungai, air danau, air sumur, daging, susu, telur, olahan (tempe, tahu, baso),",
    "22/12/2025",
    "",
  ],
  [
    "LP-599-IDN",
    "Yes",
    "Balai Besar Perbenihan dan Proteksi Tanaman Perkebunan",
    "Jl. Raya Mojoagung No. 52 Mojoagung, Jombang, Jawa Timur",
    "(0321) 495842,496430",
    "Kopi, kenaf, wijen, tembakau, jarak pagar, jarak kepyar, kapas, Trichoderma, Beauveria bassiana, Metarzhium sp, formulasi pestisida, kakao serbuk, komoditas unik (kopi, kakao), biji-bijian sereal (beras, beras coklat, beras hitam), komoditas rempah (pala, lada, kayu manis)",
    "18/10/2025",
    "",
  ],
  ["LP-600-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  [
    "LP-603-IDN",
    "Yes",
    "PT Sucofindo (Persero) - Laboratorium Cabang Padang",
    "Lokasi 1 : Jl. By Pass Km. 19,5, Kel. Balai Gadang, Kec. Koto Tangah, Padang, Sumatera Barat Lokasi 2 : Laboratorium site KIM, Desa tanjung belit, kec. Jujuhan, Kab. bungo, Jambi",
    "(0751) 443100",
    "Lokasi 1 : Coal, palm oil and its derivates, river water and well water, waste water, Hygiene sanitary water, ambient air, enviromental noise, emission - stationary source, industrial hygiene and indoor air quality",
    "22/11/2025",
    "",
  ],
  [
    "LP-604-IDN",
    "Yes",
    "PT Nutricia Indonesia Sejahtera",
    "Jl. Raya Bogor Km. 26,6, Jakarta Timur 13710",
    "(021) 29553456",
    "Susu bubuk",
    "17/05/2025",
    "",
  ],
  [
    "LP-605-IDN",
    "Yes",
    "PT. Indonesia Sukses Makmur,Tbk - Bogasari Flour Mills",
    "Jl. Raya Cilincing No.1 Tanjung Priok, Jakarta Utara 14110",
    "(021) 29987801",
    "Tepung terigu, pasta, gandum (wheat)",
    "30/06/2025",
    "",
  ],
  [
    "LP-606-IDN",
    "Yes",
    "Balai Besar Perbenihan dan Proteksi Tanaman Perkebunan Ambon",
    "Jl. Pertanian Passo, Ambon, Maluku",
    "(0911) 361203; 361325",
    "Benih Kakao (Theobroma cacao), Benih Pala (Myristica fragrans), Benih Cengkeh (Syzygium aromaticum), Benih Cengkih (Syzygium aromaticum), Jamur Metarhizium anisopliae, Jamur Beauveria bassiana, Jamur Trichoderma spp.",
    "20/09/2025",
    "",
  ],
  [
    "LP-607-IDN",
    "Yes",
    "Balai Standardisasi dan Pelayanan Jasa Industri Padang",
    "Jl. Raya LIK No. 23, Ulu Gadut, Kota Padang, Sumatera Barat",
    "(0751) 72201",
    "Garam konsumsi beryodium, minyak goreng sawit, rendang daging sapi,rendang daging dalam kemasan, kakao bubuk, keripik singkong,kopi sangrai dan kopi bubuk, air mineral, air demineral, semen portland, semen pemboran, semen portland komposit, semen portland campur, semen portland pozzolan, semen hidraulis, pupuk urea, pupuk NPK, air sumur, air danau, air sungai, air situ, air mata air, air waduk, air hujan, air rawa, air untuk keperluan higiene dan sanitasi, air limbah, kebauan, udara ambien, kebisingan lingkungan, kebisingan di tempat kerja, udara emisi sumber tidak bergerak, udara emisi sumber bergerak",
    "01/12/2025",
    "",
  ],
  ["LP-608-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  [
    "LP-609-IDN",
    "Yes",
    "UPTD Pengujian Energi dan Sumber Daya Mineral",
    "Jl. Soekarno Hatta No 576, Bandung 40286",
    "(022) 7562049",
    "Air permukaan (air sumur, air mata air), air limbah, air tanah, tanah dan pasir, mineral non logam (zeolit, bentonit, feldsfar, diatome, perlite, kaolin, andesit)",
    "19/04/2025",
    "",
  ],
  [
    "LP-610-IDN",
    "Yes",
    "Balai Penerapan Standar Instrumen Pertanian Kalimantan Timur",
    "Jl. Pangeran M. Noor-Sempaja, Samarinda, Kalimantan Timur",
    "(0541) 220857",
    "Tanah, pupuk organik padat, pupuk organik cair, makanan dan minuman (nugget, kripik, cookies, kue basah), pelet, bahan baku pakan, pakan jadi, bahan hijauan, dedak, tepung ikan, sekam, pakan lele, bungkil sawit",
    "22/11/2025",
    "",
  ],
  ["LP-611-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  [
    "LP-612-IDN",
    "Yes",
    "UPTD Balai Pengujian Dinas Pekerjaan Umum Provinsi Jambi (EXPIRED)",
    "Jl. RB. Siagian No. 01, Kel. Pasir Putih, Jambi",
    "(0741) 570077",
    "Aspal keras, koral/batu pecah, pasir, beton keras, tanah, tanah dasar/subgrade, lapis pondasi agregat, penyelidikan tanah/soil investigation",
    "20/09/2020",
    "",
  ],
  ["LP-614-IDN", "No", "", "", "", "", "", "Nomor Akreditasi dicabut"],
  ["LP-615-IDN", "No", "", "", "", "", "", "Nomor Akreditasi dicabut"],
  [
    "LP-617-IDN",
    "Yes",
    "PT Omega Medika Farma Laboratori",
    "Jl. Raden Saleh Raya No. 4, Jakarta Pusat 10430 (head office) Jl. Kramat Raya No. 61A, Jakarta Pusat 10450 (laboratorium)",
    "(021) 3905831",
    "Plasma darah",
    "21/06/2025",
    "",
  ],
  [
    "LP-618-IDN",
    "Yes",
    "Balai Besar Veteriner Wates",
    "Jl. Raya Yogyakarta-Wates Km. 27, Gripeni, Wates, Kulonprogo, Yogyakarta",
    "(0274) 773168",
    "Swabs (oral, chloacal, oropharingeal, tracheal), Organ/Jaringan (bulu, paru, cor, otak, ren, trachea, usus, hati), Cairan allantois, Sampel lingkungan (feses, air), Vaksin, Swabs (swab luka), Organ/Jaringan (kulit, lien, paru, bulu, telinga), Darah/ulas darah, Sampel lingkungan (tanah, air, feses), vaksin antrax, Swabs (nasal), Organ/Jaringan (kulit, bulu, paru), Serum, Plasma darah, Semen, Wash: vaginal/preputial, Sampel lingkungan (feses)., Swabs (oral, cloacal, oropharyngeal, tracheal), Organ/Jaringan (bulu, paru, jantung, otak, ginjal, trakhea, usus, hati), Sampel lingkungan (feses, air, permukaan alat), Cairan allantois, Vaksin, Swab (nasal), Serum/darah, Organ (tonsil, trakhea, paru), Sampel lingkungan (dari feses, air, permukaan alat), Cairan kultur jaringan, Swabs (nasal), Semen, Serum/darah, Organ (trakhea, paru), Sampel lingkungan (feses, air, permukaan alat), Cairan kultur jaringan, Daging/karkas, telur, susu, jeroan, Daging, telur, susu, jeroan dan olahannya (nugget, sosis), Pangan asal hewan (daging, telur, susu), Swab, Organ/jaringan, Cairan allantois, sampel lingkungan (feses, air, tanah, pupuk), Cairan allantois, Otak, Organ (trachea dan paru-paru), semen, swab nasal, Sel terinfeksi, Organ (trachea dan paru-paru), darah, swab nasal, Organ (usus, otak dan paru-paru), swab nasal, Serum darah unggas, Serum darah ruminansia, Serum darah Sapi, Serum Darah Babi, Serum darah Anjing, Kucing, Kera, Swab kloaka, pakan dan organ/jaringan, Darah, jaringan, organ, tanah, tulang dan kulit, susu, cairan dari lingkungan, Serum, Pakan, isi rumen, Pakan , Hewan utuh, Organ/jaringan, Feses, Darah, Bakso, daging, Ekstrak daging ayam dan sapi, isolat bakteri salmonela, isolat bakteri escherichia coli",
    "21/06/2025",
    "",
  ],
  [
    "LP-620-IDN",
    "Yes",
    "UPT Laboratorium Lingkungan Hidup Dinas Pengelolaan Lingkungan Hidup Provinsi Sulawesi Selatan",
    "Jl. Urip Sumoharjo, No.269 Makassar, Sulawesi Selatan",
    "(0411) 453208",
    "Air sungai, air sumur, air danau, air bersih, air minum, air laut, air limbah, udara ambien, udara emisi",
    "21/06/2025",
    "",
  ],
  [
    "LP-621-IDN",
    "Yes",
    "Balai Standardisasi dan Pelayanan Jasa Industri Medan",
    "Lokasi 1 : Jl. Sisingamangaraja No. 24, Medan, Sumatera Utara Lokasi 2 : Jl. Sisingamangaraja No. KM 7,5, Medan, Sumatera Utara",
    "(061) 7363471/7362830",
    "Lokasi 1 : Tepung terigu sebagai bahan makanan, air mineral dan air demineral, biji kopi,kopi instan, garam konsumsi beryodium, garam bahan baku untuk industri garam beryodium, biskuit, mie instan, minyak goreng sawit, gula kristal rafinasi, roti, pupuk amonium sulfat, pupuk fosfat alam untuk pertanian, pupuk KCl, pupuk NPK padat, pupuk SP-36, pupuk TSP, pupuk urea, Kapur untuk pertanian, Dolomite, air limbah, air Sungai, air danau, air mata air, air sumur, air sumur bor, sumber mata air, air minum, air limbah, udara emisi sumber tidak bergerak, udara ambien, udara emisi sumber bergerak, Getaran, kebisingan, Crude palm oil (CPO)",
    "17/01/2026",
    "",
  ],
  [
    "LP-623-IDN",
    "Yes",
    "PT Sucofindo (Persero) cabang Palembang",
    "Lokasi 1 : Jl. Jend Sudirman No. 774 Palembang, Sumatera Selatan Lokasi 2 : Kompleks pergudangan palembang Star blok C no. 2, Jl. Letjen Harun sohar, Tanjung Api-api, Palembang Lokasi 3 :Jl. Lubuk Beringin no.139, Desa manggul, Lahat Lokasi 4 : Jl Linggarjati no.22, Kel. Batin tikal, Kec. Taman sari, Pangkalpinang",
    "(0711) 312990",
    "Lokasi 1 : CPO, CPKO, RBD Palm Oil, RBD Palm Stearin, Pupuk KCl, Pupuk NPK padat, Pupuk Tripel Super Phosphat, Air Higiene Sanitasi, Air Limbah, Udara Ambient, Kebisingan lingkungan, Lingkungan Kerja, Udara emisi (Sumber tidak bergerak)",
    "18/10/2025",
    "",
  ],
  [
    "LP-624-IDN",
    "Yes",
    "Laboratorium Besar Perbenihan dan Proteksi Tanaman Perkebunan (BBP2TP) Medan",
    "Jl. Asrama No. 124 Medan",
    "(061) 8470504",
    "Jamur Beauveria bassiana pada tepung jagung, kompos, PDA, tepung beras, jagung pecah giling, benih kopi, benih kakao, benih karet, produk/formulasi pestisida",
    "24/10/2021",
    "",
  ],
  [
    "LP-625-IDN",
    "Yes",
    "PT Sucofindo (Persero) - Laboratorium Cabang Pekanbaru",
    "Graha Sucofindo, Jl. Jend. A. Yani, No. 79, Pekanbaru, Riau",
    "(0761) 35681",
    "Air limbah, air sungai, air laut, air untuk keperluan higiene dan sanitasi, pupuk MOP/KCl, pupuk TSP, Crude Palm Oil (CPO), udara ambien, kebauan, udara ambien, kebisingan, udara emisi sumber tidak bergerak, lingkungan kerja",
    "13/06/2026",
    "",
  ],
  [
    "LP-626-IDN",
    "Yes",
    "Balai Teknik Kesehatan Lingkungan dan Pengendalian Penyakit Kelas I Batam",
    "Jl. Balai Teknik Kel. Sei Binti, Kec. Sagulung, Kota Batam, Kepulauan Riau",
    "(0778) 8075096",
    "Air minum, air higiene sanitasi, air kolam renang, air sungai, air sumur, air waduk, air limbah, udara ambien, lingkungan kerja, udara indoor (lingkungan kerja), emisi sumber tidak bergerak, air minum (air olahan/tanpa diolah langsung diminum). Air bersih (air higiene sanitasi, air pemandian, bahan baku air minum, air badan air (sungai waduk), air laut (pelabuhan, wisata bahari, biota laut), air limbah (domestik/fasyankes dan limbah usaha lainnya), air hemodialisa, air sumur pantau, swab/usap (alat makan, lantai, dinding, dan alat lainnya)",
    "25/07/2026",
    "",
  ],
  [
    "LP-627-IDN",
    "Yes",
    "PT Medialab Indonesia",
    "Lokasi 1 : Jl. Jatiwangi No. 44 Kamurang, Kel. Cikedokan, Kec. Cikarang Barat, Kab. Bekasit, Jawa Barat 17530 Lokasi 2 : Jl. Kahuripan Nirwana No. 29W Desa Entelsewu, Kec. Buduran, Sidoarjo Jawa Timur",
    "(021) 28517576",
    "Lokasi 1: Air Sumur, Air Danau, Air Sungai, Air Muara, Air Rawa, Air Akuifer, Air Situ, Air Mata Air, Air Waduk, Air Tanah, Air Laut, Air untuk Keperluan Higiene Sanitasi, Air Limbah, Air Minum, Limbah Cair, Sediment, Sludge B3 (TCLP), Udara Lingkungan Kerja, Udara Ambien, Udara Emisi Sumber Tidak Bergerak, Udara Emisi Sumber Bergerak, Pakan konsentrat sapi, Bahan Pakan ternak (Bungkil kedelai, bungkil inti sawit, dedak padi, jagung, bungkil kelapa), pupuk organik padat untuk pertanian",
    "26/12/2025",
    "",
  ],
  [
    "LP-628-IDN",
    "Yes",
    "Stasiun Karantina Ikan, Pengendalian Mutu dan Keamanan Hasil Perikanan Pontianak",
    "Jl. Arteri Supadio Km 18, Pontianak, Kalimantan Barat",
    "(0561) 725427",
    "Ikan segar, crustacea, coelenterata, molusca, echinodermata, ikan air tawar, produk olahan (basko, nuget, haikeng, katsu, otak-otak)",
    "26/02/2026",
    "",
  ],
  [
    "LP-630-IDN",
    "Yes",
    "Balai Karantina Pertanian Kelas I Palembang",
    "Jl. Kol. H. Barlian km 6 No. 78 Palembang, Sumatera Selatan",
    "(0711) 411609",
    "Kelapa sawit (daun), umbi kentang, spesimen serangga, caisin (daun), serum darah unggas, kelas mamalia (serum darah sapi)",
    "22/11/2025",
    "",
  ],
  [
    "LP-631-IDN",
    "Yes",
    "PT Charoen Pokphand Indonesia - Regional Laboratory Balaraja",
    "Jl. Raya Serang km 30, Balaraja,Tangerang, Banten",
    "(021) 5951186",
    "Produk jadi pakan ternak poultry, swine dan aqua (pakan ikan dan pakan udang), bahan baku pakan ternak asal nabati (corn, soy bean meal, wheat, sorgum, corn gluten meal, full fats soya, rice bran, rape seed meal), bahan baku pakan ternak asal hewani (meat bone meat, fish meal, squid liver powder, shrimp head meal, bone meal, poultry meat meal, chicken fether meal, blood meal), bahan baku pakan ternak dari sumber ikan dan sejenisnya (fish meal, squid meal, squid liver powder, shrimp head meal), premix untuk bahan pakan ternak, bahan baku murni atau konsentrat berupa mineral dan vitamin (limestone, monocalcium phosphate, monodicalcium phosphate, garam, bahan murni vitamin E, bahan murni vitamin B, CuSO4, CuCl2, FeSO4, ZnSO4, ZnO, MnSO4, MnO, K3PO4, KI, MgSO4 dan coal)",
    "27/10/2025",
    "",
  ],
  ["LP-632-IDN", "No", "", "", "", "", "", "Nomor Akreditasi dicabut"],
  [
    "LP-633-IDN",
    "Yes",
    "Stasiun Karantina Ikan, Pengendalian Mutu dan Keamanan Hasil Perikanan Jambi",
    "Jl. Sersan Ud. Syawal Palmerah Baru, Jambi",
    "(0741) 573726",
    "Ikan air tawar, ikan laut, ikan segar, ikan mas dan koi, udang penaide",
    "18/10/2025",
    "",
  ],
  ["LP-634-IDN", "No", "", "", "", "", "", "Nomor Akreditasi dicabut"],
  ["LP-636-IDN", "No", "", "", "", "", "", "Nomor Akreditasi dicabut"],
  [
    "LP-637-IDN",
    "Yes",
    "Balai Teknik Irigasi",
    "Jl. Cut Meutia, Bekasi",
    "(021) 8801345",
    "Semen portland, agregat halus, agregat, agregat kasar, beton, beton elemen, struktur, beton struktur, beton segar, tanah, aliran air di saluran irigasi",
    "18/10/2025",
    "",
  ],
  [
    "LP-638-IDN",
    "Yes",
    "Pusat Pendayagunaan Informatika dan Kawasan Strategis Nuklir - BATAN",
    "Gedung 71 Lantai III, Kawasan Puspiptek Serpong, Tangerang Selatan, Banten",
    "(021) 7560575",
    "Thermoluminence Dosimeter (TLD), udara ambien, tanah, air tanah, air sungai, air minum, air danau, air hujan, air limbah",
    "17/01/2026",
    "",
  ],
  ["LP-639-IDN", "No", "", "", "", "", "", "Nomor Akreditasi dicabut"],
  [
    "LP-641-IDN",
    "Yes",
    "Pusat Penelitian dan Pengembangan Teknologi Mineral dan Batubara",
    "Jl. Jend. Sudirman No. 623, Bandung",
    "(022) 6030483",
    "Clay Mineral (Zeolit, Trass, Bentonit, Lempung, Ball Clay, Kaolin, felspar, perlit), Bijih Besi/Pasir Besi/Batu Besi, Kapur (Batu gamping, Kalsit, Dolomit, Kapur Tohor, Marmer, Gipsum, Barium Karbonat), Pasir Kuarsa/Pasir Silika, Mangan, Batuan Sulfidis, Batuan Emas, Abu Batu bara, Mineral dan batuan, Batuan, bahan galian tambang, tanah, batubara, abu, logam dan hasil proses/penelitian, Material berbahan padat (organik/anorganik), Batuan, bahan galian tambang, tanah, Air Limbah , Air sungai, air danau, Tanah, Uji Statik Pengidentifikasian Sumber Air Asam Tambang , Batubara, Batuan",
    "15/02/2026",
    "",
  ],
  [
    "LP-644-IDN",
    "Yes",
    "PT Pertamina (Persero) Integrated Terminal Makassar",
    "Jl. Hatta No. 1 Makassar, Sulawesi Selatan",
    "(0411) 36199211",
    "Avtur, premium, pertamax, kerosine, MFO, solar dan biosolar, fuel",
    "21/03/2026",
    "",
  ],
  [
    "LP-646-IDN",
    "Yes",
    "Balai Besar Karantina Pertanian Soekarno-Hatta",
    "Gedung Karantina Pertanian, Bandara Internasional Soekarno Hatta, Kota Tangerang, Banten",
    "085353858580",
    "Sarang burung walet, Serum darah anjing dan kucing, Serum darah kuda, Jagung (Zea mays), padi (Oryza sativa), strawberi (Fragaria virginiana), krisan (Chrysanthemum), kubis-kubisan (Brassica sp) , raspberi (rubus), cabai (Capsicum sp.), timun (Cucumis sativus), semangka (Citrullus lanatus), tomat (Solanum lycopersicum), tembakau (Nicotiana spp.), anggur (Vitis vinifera), Benih tomat (Solanum lycopersicum) dan benih cabai (Capsicum annuum), Padi (Oryza sativa), Krisan (Chrysanthemum), Grapes (anggur), lemons (lemon), mandarins (jeruk mandarin), tangerines (jeruk keprok), oranges (jeruk), strawberry (stroberi), blueberry (blueberries), raspberry (rasfberries), black currant (currant hitam), red currant (currant merah), white currant (currant putih), kiwifruit (buah kiwi), pineapple (nanas)",
    "25/07/2026",
    "",
  ],
  [
    "LP-647-IDN",
    "Yes",
    "PT Geoservices Mojokerto",
    "Jl. Empunala No. 48, Kel. Balongsari, Kec. Magersari, Kota Mojokerto, Jawa Timur",
    "(0321) 390258",
    "Batubara",
    "04/05/2026",
    "",
  ],
  [
    "LP-648-IDN",
    "Yes",
    "Stasiun Karantina Ikan Pengendalian Mutu dan Keamanan Hasil Perikanan Padang",
    "Jl. Raya Bandar Udara lnternasional Minangkabau, Padang Pariaman, Sumatera Barat",
    "(0751) 819090",
    "Lobster, kepiting, udang kipas, lobster air tawar, ikan laut, ikan hias laut, ikan air tawar, ikan hias air tawar, ikan segar, Tuna segar, tuna beku, Ikan mas, ikan nila, Ikan gurame, Ikan lele, Labi-labi, ikan kepe-kepe, ikan blue devil, angulilidae, ikan betutu, kura-kura, buaya, gold fish, belanak, ikan patin, Ikan sepat, ikan kakap putih, ikan salmon, ikan mas koki, belut, Ikan segar (Ikan tuna, ikan kakap, ikan kuwe, ikan kembung, ikan tongkol, cumi-cumi, ikan layang, ikan baracuda, ikan layur, ikan bawal, ikan kerapu, udang) Steak ikan beku",
    "13/06/2026",
    "",
  ],
  ["LP-649-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  [
    "LP-650-IDN",
    "Yes",
    "Stasiun Karantina Ikan, Pengendalian Mutu dan Keamanan Hasil Perikanan Yogyakarta",
    "Jl. Kenanga No. 26, Maguwoharjo, Depok Sleman, Yogyakarta",
    "(0274) 489390",
    "Ikan mas, ikan koi, ikan, ikan air tawar, ikan gurame, ikan lele, ikan patin, ikan maskoki, ikan komet, udang galah, udang vanname, udang windu, ikan segar, udang segar, ikan nila, tuna kaleng, tuna rebus beku, kerang masak, ikan segar, tuna pouch, udang beku, udang kupas mentah beku, ikan beku",
    "18/10/2025",
    "",
  ],
  ["LP-652-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  [
    "LP-653-IDN",
    "Yes",
    "Balai Besar Pengujian Penerapan Hasil Perikanan",
    "Jl. Raya Setu No. 70 Cipayung, Jakarta Timur",
    "(021) 84998429",
    "Kakap, kembung, tuna, gurame, ekor kuning, tenggiri, udang, cumi, ikan teri nasi, keripik belut, abon ikan, bandeng presto, bandeng cabut duri beku, kerupuk ikan, bakso ikan beku, fillet ikan dan produk perikanan meliputi molusca, krustasea (udang beku), ikan produk perikanan awet (sarden dengan media saus tomat), udang beku, rajungan beku, tuna kaleng, sarden kaleng, kepiting kaleng, udang/ikan berlapis tepung beku, rumput laut kering, telur ikan terbang, udang kaleng, rajungan kaleng, bakso ikan beku, marlin, tuna, kakap, cakalang, kerapu, kekerangan, surimi dan produk olahannya, tepung ikan, kerupuk udang, tongkol, ikan dalam kemasan kaleng hasil sterilisasi, ikan asin, produk olahan rumput laut, bandeng presto, terasi, air minum",
    "27/10/2025",
    "",
  ],
  [
    "LP-654-IDN",
    "Yes",
    "Stasiun Karantina lkan, Pengendalian Mutu dan Keamanan Hasil Perikanan Palu",
    "Jl. Garuda No. 22 Palu, Sulawesi Tengah",
    "(0451) 4708307",
    "Ikan air tawar, ikan laut segar dan beku, Crustacea, ikan hias, ikan segar",
    "22/08/2026",
    "",
  ],
  ["LP-655-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  [
    "LP-656-IDN",
    "Yes",
    "PT Tigaraksa Satria Tbk.",
    "Jl. Cangkringan Km 1,5 Dhuri, Tirtomartani, Sleman, Yogyakarta",
    "(0274) 498253",
    "Susu bubuk, minuman serbuk, tepung gula",
    "04/05/2026",
    "",
  ],
  [
    "LP-657-IDN",
    "Yes",
    "R&amp;D Centre PT Nusa Pusaka Kencana - Analytical &amp; QC Laboratory",
    "Desa Bahilang, Tebing Syahbandar, Serdang Bedagai, Sumatera Utara",
    "(0621) 21511",
    "Tanaman, Tanah, Urea, Ammonium Sulfat, Fosfat alam, Tripel Super Phosphate (TSP), Super Phosphate-36 (SP-36), Diamonium Phosphate (DAP), Muriate of Potash (MOP), Dolomite/CaCO3, Kieserite/MgO, NPK, Borate, Copper Sulfat, Zink Sulfat, Abu Janjang , CPO, Air limbah, Kompos",
    "01/12/2025",
    "",
  ],
  [
    "LP-658-IDN",
    "Yes",
    "Balai Karantina Ikan, Pengendalian Mutu dan Keamanan Hasil Perikanan Ambon",
    "Jl. Laksdya Leo Wattimena, Waiheru, Ambon, Maluku",
    "(0911) 3869137",
    "Ikan air tawar (ikan belut dan sidat), ikan air laut (ikan tuna dan cakalang, kerapu), crustacea (kepiting bakau, udang dan lobster), air dan es, fresh tuna loin, udang segar, ikan segar, teripang kering, sirip hiu kering, rumput laut kering",
    "26/02/2026",
    "",
  ],
  [
    "LP-659-IDN",
    "Yes",
    "Balai Karantina Pertanian Kelas I Balikpapan",
    "Jl. Brigjen Abdul Wahab Syahrani No. 37, Balikpapan, Kalimantan Timur 76126",
    "(0542) 423312",
    "Serum darah (anjing, kucing, primata, ayam, day old chick, day old duck, sapi, kerbau, kambing, domba), bahan asal hewan (daging sapi, ayam, kerbau, kambing, bebek, telur, susu) dan hasil bahan asal hewan (bakso sapi, nugget, sosis sapi, sosis ayam), darah sapi, kerbau, kambing, domba kuda, kentang, biji kedelai, kayu Plywood, beras, serangga, bulir padi",
    "21/03/2026",
    "",
  ],
  [
    "LP-660-IDN",
    "Yes",
    "Balai Besar Karantina Pertanian Tanjung Priok",
    "Jl. Padamaran No. 6, Pelabuhan Tanjung Priok (Pos 3) Jakarta Utara, DKI Jakarta",
    "(021) 4367269",
    "Daging, susu, telur, dan tepung telur, Serum (sapi), Bahan Baku Pakan Ternak (Meat Bone Meal, Poultry By Product Meal, Hydrolyse Feather Meal, Blood Meal), Sarang Burung Walet, Unggas hidup, Bulu Unggas, Kentang (Solanum tuberosum), bawang merah (Allium cepa), mentimun (Cucumis sativus), wortel (Daucus carota), tomat (Lycopersicum esculentum), Jambu biji (psidium guajava), mangga (Mangifera indica), Jeruk (Citrus sp), nangka (Artocarpus integra), pepaya (Carica papaya), Pisang (Musa paradisiaca), cempedak (Artocarpus champeden Spring), melon (Cucumis melo), labu siam (Sechium e dule), labu kuning (Cucurbita moschata), belimbing (Averhoa carambola), mentimun (Cucumis sativus), jambu air (Syzygium aqueum ), cabai (Capsicum sp), sukun (Artocarpus altilis), plum (Prunus spp), lengkeng (Dimocarpus longan), kacang buncis (Phaseolus vulgaris), kacang merah (Vigna unguiculata), krisan/seruni (Chrysanthemum spp), apel (Malus domestica), Umbi bunga lily (Lilium spp.), sarikaya (Anonna squamosa), ubi kayu (Manihot esculenta), manggis (Garcinia mangostana), Jagung, Jagung manis (Zea mays), Umbi bawang putih (Allium sativum), Bambu hias, suji (Dracaena spp.), Sirih Gading / Sirih Belanda / Janda Bolong (Philodendron spp .), Lidah mertua (Sansevieria spp.), Siklok (Agave attenuata), Bakung (Amaryllis sp.), Kuping Gajah (Anthurium spp.), Aglonema (Aglaonema spp.), Lidah Buaya (Aloe vera), Kedondongan (Polyscias fruticosa), Talas-talasan (Alocasia spp.), Biji Gandum (Triticum sp), Kacang tanah (Arachis hypogaea), kapas (Gossypium hirsutum), bunga matahari (Heliantus annuus), barley (Hordeum vulgare) ,padi (Oryza sativa), millet (Panicum miliaceum), wijen (Sesamum indicum),",
    "04/05/2026",
    "",
  ],
  [
    "LP-661-IDN",
    "Yes",
    "Balai Pengujian dan Laboratorium Lingkungan Hidup Dinasl Lingkungan Hidup dan Kehutanan Provinsi Jawa Tengah",
    "Jl. Setiabudi (Komplek Diklat Provinsi Jawa Tengah), Srondol, Semarang, Jawa Tengah",
    "(024) 7478813 ; (024) 76401105",
    "Air limbah, air untuk keperluan higiene dan sanitasi, air sumur, air danau, air sungai, air muara, air mata air dan air waduk, udara ambien, udara emisi sumber tidak bergerak, udara emisi sumber bergerak (M, N, O solar), udara emisi sumber bergerak (L bensin)",
    "23/05/2026",
    "",
  ],
  ["LP-664-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  [
    "LP-667-IDN",
    "Yes",
    "PT Pertamina (Persero) Fuel Terminal Wayame",
    "Jl. Ir. Putuhena Km 24 Wayame Ambon, Maluku",
    "(0911) 310087",
    "Avtur, Premium, Kerosine, Solar (B0 dan B30)",
    "24/04/2026",
    "",
  ],
  [
    "LP-668-IDN",
    "Yes",
    "Analytical Laboratory of Oleochemical and Specialty Fats Complex KIM 2 - PT Musim Mas",
    "Jl. Oleo, Kawasan Industri Medan II, Saentis-Percut Sei Tuan, Deli Serdang, Medan, Sumatera Utara",
    "(061) 6871123",
    "Glycerine, fatty acid, specialty fats, fatty alcohol, soap noodle, ester, emulsifier",
    "04/09/2025",
    "",
  ],
  ["LP-670-IDN", "No", "", "", "", "", "", "Nomor Akreditasi dicabut"],
  [
    "LP-671-IDN",
    "Yes",
    "IPB Culture Collection",
    "Jl. Agatis Gedung Fakultas Perikanan L5/Wing 3, Kampus IPB Darmaga, Bogor, Jawa Barat",
    "(0251) 8627378",
    "Antiseptik dan desinfektan kimiawi",
    "24/10/2026",
    "",
  ],
  ["LP-673-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  ["LP-674-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  [
    "LP-675-IDN",
    "Yes",
    "Balai Besar Pelaksanaan Jalan Nasional Sumatera Utara",
    "Jl. Sakti Lubis / Busi Dalam No. 1 Medan, Sumatera Utara",
    "(061) 7880822",
    "Aspal, beton, tanah, tanah dasar subgrade, agregat halus, agregat kasar, campuran agregat dan aspal",
    "25/07/2026",
    "",
  ],
  [
    "LP-676-IDN",
    "Yes",
    "Stasiun Karantina Ikan, Pengendalian Mutu dan Keamanan Hasil Perikanan Pekanbaru",
    "Jl. Rawa Indah Pekanbaru, Kel. Sidomulyo Timur, Kec. Marpoyan, Damai, Pekanbaru, Riau",
    "(0761) 673563",
    "African catfish, Blue catfish, Brown bullhead, Catfish, Chanel catfish, Danio, Eel, Flounder, Gold fish, Green knifefish, Jambal catfish, Blue spot mullet, Nile Tilapia, Striped catfish, Bullhead, Catfish, Common Carp, Frog, Giant gouramy, Gilthead seabrem, Nile Tilapia, Arwana, kakap, Pakan ikan (pelet), Ikan air laut segar dan beku (salmon, tongkol, kembung, sarden, baronang, tuna, kakap, tenggiri, Serai, udang, mata besar, senangin, kurau, jenaha, cakalang), Ikan segar air tawar (Jelawat), Crucian Carp, Koi Carp Hybrids, Kelompok Crustacea perairan khususnya Decapoda (Udang, Kepiting, Crayfish, Lobster) yang hidup di laut, payau dan air tawar",
    "26/02/2026",
    "",
  ],
  [
    "LP-678-IDN",
    "Yes",
    "Stasiun Karantina Ikan, Pengendalian Mutu dan Keamanan Hasil Perikanan Palangka Raya",
    "Jl. Adonis Samad, Panarung, kec. Pahandut, Palangka Raya, Kalimantan Tengah",
    "(0536) 3242323",
    "Ikan air tawar, ikan segar, ikan beku, kepiting, udang segar/beku, udang hidup",
    "03/04/2026",
    "",
  ],
  [
    "LP-680-IDN",
    "Yes",
    "Stasiun Karantina Ikan, Pengendalian Mutu dan Keamanan Hasil Perikanan Bengkulu",
    "Jl. Raya Padang Kemiling RT 02 Pekan Sabtu Kecamatan Selebar, Bengkulu",
    "(0736) 53017",
    "Ikan Mas, Ikan Nila, Ikan tongkol, cakalang, tuna, kerapu, bawal putih, bawal hitam, kakap merah, kakap putih, udang kelong, layur, tenggiri, Udang Vannamei, Udang Windu, Lobster, Nila, Mas, Gurame, Lele, Sidat, patin dan jenis ikan cyprinid lainnya., Udang Windu, Vannamei dan Udang Kelong , Udang Windu, Vannamei dan Udang Kelong , Lele, patin, mas, sidat, ekor kuning dan cat fish lainnya, Ikan air laut segar (Bawal, kerapu, tenggiri, jenaha, kakap, Layur, daging ikan tenggiri) Udang Segar, Udang Beku, Lobster Beku, Ikan beku (layur, bawal)",
    "23/05/2026",
    "",
  ],
  [
    "LP-681-IDN",
    "Yes",
    "PT Geoservices Sangatta",
    "Jl. Poros Kabo No. 136, Sangatta-mKutai Timur, Kalimantan Timur",
    "(0549) 22192",
    "Batubara",
    "17/01/2026",
    "",
  ],
  [
    "LP-682-IDN",
    "Yes",
    "PT Geoservices Palembang",
    "Jl. Letjen Harun Sohar, Komplek Pergudangan Griya Bandara Indah No. F8, Kel. Kebun Bunga, Kec. Sukarami, Palembang, Sumatera Selatan",
    "(0711) 418614",
    "Batubara",
    "17/01/2026",
    "",
  ],
  [
    "LP-683-IDN",
    "Yes",
    "Stasiun Karantina Ikan, Pengendalian Mutu dan Keamanan Hasil Perikanan Kelas I Pangkalpinang",
    "Komplek Perkantoran Pemda Provinsi Kep. Bangka Belitung Jalan Profesi No.4 Pangkalpinang",
    "(0717) 434756",
    "Ikan Segar dan Beku, Ikan Air Laut, Udang vanamei, Kerapu, kakap Putih, Ikan Tenggiri, Bawal, Kakap, Senangin, Sembilang, Rajungan, sebelah, Cumi cumi, Produk perikanan lain (Bakso, sosis, nuget, Otak otak, terasi, ikan asin)",
    "20/02/2027",
    "",
  ],
  [
    "LP-684-IDN",
    "Yes",
    "PT Agricon",
    "Jl. Melati No. 5 Desa Wanaherang, Kec. Gunung Putri, Kab Bogor, Jawa Barat",
    "(021) 8672344",
    "Pestisida/formulasi pestisida",
    "03/04/2026",
    "",
  ],
  [
    "LP-687-IDN",
    "No",
    "",
    "",
    "",
    "",
    "",
    "Nomor digabung dengan LP-269-IDN</strong>",
  ],
  [
    "LP-688-IDN",
    "Yes",
    "UPTD Balai Pengawasan dan Sertifikasi Benih Tanaman Pangan dan Hortikultura Provinsi Sulawesi Utara",
    "Jl. 17 Agustus Manado, Kotak Pos 1412, Sulawesi Utara",
    "(0431) 844210",
    "Padi, jagung, kedelai, kacang tanah, kacang hijau, mentimun, seledri, buncis, semangka, terung, sawi, wortel, cabe, tomat, bayam",
    "17/04/2027",
    "",
  ],
  [
    "LP-689-IDN",
    "Yes",
    "Balai Pengawasan dan Sertifikasi Benih/Bibit Pertanian dan Peternakan Provinsi Maluku",
    "Jl. Wolter Monginsidi, Kompleks Pertanian, Ambon, Maluku",
    "(0911) 362768",
    "Benih padi",
    "21/03/2026",
    "",
  ],
  [
    "LP-690-IDN",
    "Yes",
    "PT Antam, Tbk. - Unit Bisnis Pertambangan Maluku Utara",
    "Lokasi 1 : Smelter FeNi, Tanjung Buli, Halmahera Timur, Maluku Utara Lokasi 2 : Site Pulau Pakai - Kec. Kota Maba, Halmahera Timur, Maluku Utara Lokasi 3 : Site Moronopo - Kec. Kota Maba, Halmahera Timur, Maluku Utara",
    "(021) 7812736",
    "Lokasi 1 : Nikel ore, Ferro Nikel (FeNi), Batubara",
    "22/11/2025",
    "",
  ],
  [
    "LP-691-IDN",
    "Yes",
    "Balai Karantina Pertanian Kelas 1 Denpasar",
    "Jl. Raya Benoa No. 20, Denpasar, Bali",
    "(0316) 720805",
    "Spesimen serangga, umbi kentang, tanaman caisin, tanaman kentang, daging dan produk olahannya, telu, susu dan produk olahannya, sarang walet, serum sapi, serum kambing, serum babi, serum unggas, swab kloaka, swab trachea, darah sapi, darah babi, darah kambing",
    "13/12/2025",
    "",
  ],
  [
    "LP-692-IDN",
    "Yes",
    "Balai Teknik Kesehatan lingkungan dan Pengendalian Penyakit Kelas I Medan",
    "Jl. K. H Wahid Hasyim No. 15, Medan, Sumatera Utara",
    "(061) 4512305",
    "Air minum (isi ulang), air untuk keperluan higiene dan sanitasi, air sungai, air limbah, swab alat makan, alat medis, dinding dan lantai, lingkungan kerja, udara ambien, kebisingan",
    "23/05/2026",
    "",
  ],
  [
    "LP-693-IDN",
    "Yes",
    "Balai Pengembangan lndustri Pesepatuan lndonesia",
    "Komplek Pasar Wisata Kedensari, Tanggulangin, Kab. Sidoarjo",
    "(031) 8855149",
    "Sepatu pengaman, Sepatu wanita kulit sistem lem, Sepatu pria kulit sistem lem, Sol karet cetak, Bagian atas sepatu (upper), Sol luar, Sepatu boot vinil klorida",
    "20/03/2022",
    "",
  ],
  ["LP-694-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  [
    "LP-696-IDN",
    "Yes",
    "PT Agri Makmur Pertiwi",
    "Jl. Raya Pare Kediri Km. 6,3, Desa Sambirejo, Kec. Pare, Kediri, Jawa Timur",
    "(0354) 391882, 394818",
    "Jagung, Padi, Kacang hijau, Mentimun, Gambas, Paria, Kangkung, Kacang panjang, Semangka, Melon, Jagung manis, Kubis, Bayam, Labu, Selada, Sawi, Sawi putih, Brokoli, Buncis, Marigold, Cabai besar, Terong, Tomat, Seledri, kol bunga,",
    "19/12/2026",
    "",
  ],
  ["LP-697-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  [
    "LP-698-IDN",
    "Yes",
    "Balai Pengawas Obat dan Makanan di Pangkalpinang",
    "Komplek Perkantoran Pemerintah Propinsi Kep. Bangka Belitung, Jl. Pulau Bangka, Air Itam, Pangkalpinang, Kepulauan Bangka Belitung",
    "(0717) 439278",
    "Terapetik: tablet, kapsul, larutan oral, injeksi",
    "22/08/2026",
    "",
  ],
  [
    "LP-699-IDN",
    "Yes",
    "Balai Besar Pengawas Obat dan Makanan di Serang",
    "Jl. Syech Nawawi Albantani, Kel. Banjar Sari, Kec. Cipocok Jaya, Kota Serang, Banten",
    "(0254) 8491152, 8490943",
    "Terapetik dan Napza (Tablet dan kapsul), obat tradisional (Sediaan padat, sediaan cair), suplemen kesehatan, kosmetika (Sediaan pewarna rambut, sediaan krim, sediaan padat, sediaan bayi), pangan (Cokelat bubuk, Minuman ringan, Minyak goreng, sirup, Kecap asin, Tepung terigu, Garam meja, Susu bubuk berlemak , Tahu, Saos Cabe, Mie instan, MP-ASI Bubuk Instan, Sosis, nugget, Air Minum Dalam Kemasan (air mineral, air demineral, air embun), Kopi Instan, Kemasan Plastik Polikarbonat, Gula Kristal Putih atau Gula Pasir), Mikrobiologi",
    "22/11/2026",
    "",
  ],
  [
    "LP-700-IDN",
    "Yes",
    "PT. Bogor Labs",
    "Ruko Yasmin Sektor VI No. 198, Jl. Ring Road Bogor Utara, Bogor, Jawa Barat",
    "(0251) 7534496",
    "Air sungai, air untuk keperluan higiene sanitasi, air limnbah, air terproduksi, air laut, biota, tanah, tanah terkontaminasi, Fly ash, bottom ash, sludge, limbah B3, B3, udara ambien, udara emisi tidak bergerak, kebisingan, udara lingkungan kerja",
    "25/07/2026",
    "",
  ],
  [
    "LP-701-IDN",
    "Yes",
    "Balai Pengujian Alat Ukur, Takar, Timbang dan Perlengkapannya - Direktorat Metrologi, Kementerian Perdagangan",
    "Jl. Pasteur No.27 Bandung, Jawa Barat",
    "(022) 4203597",
    "Timbangan elektronik, timbangan pegas, meter air (Mekanik, Elektronik), meter gas rotary piston dan turbin (G16, G25, G40, G65, G100, G160, G250, G400, G650, G1000, G1600, G2500), meter gas diagphram (G1.6, G 2.5, G4), Pompa ukur bahan bakar minyak",
    "02/07/2026",
    "",
  ],
  [
    "LP-703-IDN",
    "Yes",
    "Balai Karantina Ikan Pengendalian Mutu dan Keamanan Hasil Perikanan Banjarmasin",
    "Jl. A.Yani Km 29,42 Kelurahan Guntung Manggis Banjarbaru, Kalimantan Selatan",
    "(0511) 4705720",
    "Udang Vanamei/udang Putih, udang windu, Kepiting, Lobster, Ikan Kerapu, Ikan Arwana, Produk ikan air tawar (Oscar, molly, Cupang, sepat, Tambakan, Gurame), Produk ikan segar (Bawal, Tongkol, Peda, Menangin, Selayar, Kerapu, Kakap, Babaran, Tenggiri), Produk udang segar (udang vanamei, Udang windu, Udang Galah, Udang Kipas, ) Ikan air tawar (Nila, Lele, Gurame, Mas, Koi, koki), Ikan Salmon, Ikan patin, Labi-labi, Belut rawa",
    "22/11/2026",
    "",
  ],
  [
    "LP-704-IDN",
    "Yes",
    "Balai Pengujian Kesehatan Ikan dan Lingkungan Serang",
    "Jl. Raya Carita, Ds. Umbul Tanjung, Kec. Cinangka, Kab. Serang, Banten",
    "(0254) 650431",
    "Udang, ikan air tawar, ikan air laut, air danau, air sumur, air sungai, air tanah, air limbah, air laut dan air payau, pakan (granul dan serbuk), obat ikan (granul, sediaan cair, sediaan serbuk), Ikan dan udang (segar dan kering beku (tepung",
    "19/09/2026",
    "",
  ],
  ["LP-705-IDN", "No", "", "", "", "", "", "Nomor Akreditasi dicabut"],
  [
    "LP-706-IDN",
    "Yes",
    "Balai Litbang Sungai, Puslitbang Sumber Daya Air",
    "Jl. Solo-Kartasura Km.7, Surakarta",
    "(0271) 719429",
    "Tanah, model fisik sungai",
    "26/02/2026",
    "",
  ],
  [
    "LP-707-IDN",
    "Yes",
    "PT Frissian Flag Indonesia",
    "Lokasi 1: Jl. Raya Bogor KM. 5 Pasar Rebo, Jakarta Timur, DKI Jakarta Lokasi 2: Jl. Raya Bogor KM. 26, Ciracas, Jakarta Timur, DKI Jakarta",
    "(021) 8410945",
    "Susu bubuk, susu cair, susu kental manis",
    "23/01/2027",
    "",
  ],
  [
    "LP-708-IDN",
    "Yes",
    "PT. Qualis Indonesia",
    "Jl. Padjajaran No.17 Desa Ganda Sari Kec. Jatiuwung, Tangerang, Banten",
    "(021) 55652583",
    "Leather, Textiles And Other Related Products, Metal, Electrical Compound And Other Related Product, Pakaian Bayi,Toys, Plastic And Other Related Product, Textile, Seprai, Sarung Bantal, Sarung Guling, Bedcover, Saputangan, Selimut, Handuk, Karpet/Alas Lantai, Kasur, Alas Kaki, Penghapus, Krayon/Alat Perwarna, Pakaian Dewasa, Sepatu Olahraga, Sol Luar (Karet), Kulit Imitasi, Sepatu Wanita, Sepatu Pria, Ayunan, Seluncuran Dan Mainan Aktifitas Sejenis, Kopi dan Produk kopi, Mie Instan, Biskuit, Susu dan Minuman yang mengandung susu, Tepung Terigu, Gula Kristal Halus, Coklat Bubuk, Minyak Goreng Sawit, Garam Konsumsi Beryodium, Air Minum Dalam Kemasan (AMDK), Kosmetik dan Produk Sejenisnya (Bedak, Krim Wajah, Lipstik dan lain-lain), Udang, Kakao &amp; Produk Kakao, Minyak, Lemak dan turunannya, Kecap, Saos, Bumbu, Rasa, Makanan Ringan, Minuman (Karbonasi, isotonic, sirup, Buah, Jeli, Teh), Roti, Kacang, Daging, Ikan dan produk olahannya, Sosis, Beras/Nasi, Perisa, Selai, Kornet, Krim, Yogurt, Puding, Nuget, Keripik, sereal, jagung, Rempah rempah, Cabai, bentonite, Air Bersih, Tepung kanji, Sereal sarapan, Pasta, Mie dan Produknya, Fermentasi susu dan hidrolisi dari produk susu, Keju dan Produk keju, Makanan penutup berbasis keju, Buah, Umbi, Plastik, gelas, keramik, logam, karet, sterofoam, Makanan Laut, Bahan Obat tradisional, Kembang gula/permen, Sampel Permukaan rantai produksi pangan, komponen Produk otomatif (plastik, kain, dan karet), Polyvynil chloride insulated cables of rated voltages up to and a including 450/ 750 V, Power cables with extruded insulation and their accessories for rated voltage from 1 kV (Um = 1.2 kV) up to 30 kV (Um= 36 kV), Plastics- determination of burning behaviour by oxygen index- ambient temperature test, Non metallic Materials, Electrical wires, cables and flexible cords, Instrumentation cables, Power cables with extruded insulation and their accessories for rated voltages above 30 kV) up to 150 kV (Um=170 kV), Round wire concentric lay overhead electrical stranded conductors AAAC, ACSR, ACCC, Aluminium conductors and aluminium conductors, steel-reinforced - For overhead power transmissim, Zinc-Coated (Galvanized) steel Core Wire for Use in Overhead Electrical Conductors, Test on electric an optical fibre cables under fire conditions, Test for vertical flame spread of vertically-mounted bunched wires or cables, Automotive parts - Unscreened low voltage cables, Reference Standard for Electrical Wires, Cables, and Flexible Cords, Metal-Clad Cables, Polyvinyl chloride insulated cables of rated voltage up to including 450/750 V part 6 : Lift cables and cables for flexible connections, Polyvinyl chloride insulated cables of rated voltage up to including 450/750 V part 7 : Screened Flexible cables and unscreened Flexible cables with two cores or more, Aerial Bundled Cables rated voltage 0,6/1 kV (Code type : NFA2X-T/NFA2X/NF2X/NFY), Aluminium Clad Steel Wire (AS Wire), Aluminium-magnesium-silicon alloy wire for overhead line conductor (AAAC), Hard-drawn aluminium wire for overhead line conductor, BCC 1/2H (Bare copper conductors - 1/2 Hard), BCC H (Bare copper conductors - Hard), Round wire concentric lay overhead electrical stranded conductor, Carbon Fiber Composite Core (CFCC), Pelat Batang tembaga, Perpindahan gas, Kabel Serat Optik, perangkat kabel hybrid serat optik, OPGW = Optical Ground Wire, ADSS = All Dielectric Self Supporting Cable, Pemutus-sirkit untuk proteksi arus-lebih untuk instalasi rumah tangga dan yang sejenisnya, sakelar untuk instalasi listrik magun rumah tangga dan sejenis, Tusuk kotak dan kotak kontak untuk keperluan rumah tangga dan sejenisnya, Fitting lampu sekrup Edison, Fitting lampu arus bolak balik, Degrees of protection provided by enclosures (IP Code), Metal-oxide surge arresters without gaps for AC systems, Isolator untuk saluran udara dengan tegangan nominal diatas 1000V, Overhead lines, Connector, Residual current operated circuit-breakers with integral overcurrent protection for household and similar uses (RCBO's), Residual current operated circuit-breakers without integral overcurrent protection for household and similar uses (RCCBs), Insulator Accessories, Switch gear Tegangan tinggi dan controlgear, Rakitan Perangkat hubung bagi dan kendali tegangan rendah, Kotak dan penutup untuk aksesoris listrik, Peralatan Pendingin, peralatan es krim dan pembuat es, Pompa kalor listrik, pengkondisi udara dan pengering udara, Mesin Cuci, Pompa Air, Kipas Angin, Seterika Listrik, Pemanggang Kontak,pemanggang roti dan pemasak portabel sejenis, Pengisi baterai, Pemanas Cairan, Peralatan perawatan kulit dan rambut, Peralatan Dapur, Audio, video equipment and similar electronics apparatus, Non-ducted air conditioners and heat pumps, penghisap debu, oven gelombang micro, piranti pijat listrik, bor listrik, gerinda, serut, gergaji timbal balik, circular saw, chain saw, band saw, Setrika kering termostatis, Setrika uap termostatis, Setrika tanpa senur, Penanak nasi, Televisi, Information Technology Equipment, Luminer, Lampu LED swa-blast, Persyaratan khusus - lampu tangan, Lampu dan system penerangan, Alat kendali elektronik a.s. atau a.b. untuk modul LED, Persyaratan khusus \x{2013} lampu tidur dipasang pada kotak kontak instalasi kelistrikan, Rantai cahaya,Lampu pengatur lalu lintas, Produk Penerangan, Household Appliances, ITE product, Metering Equipment, All Product Electrical and Electronic Equipment, RF test, Peralatan pendingin rumah tangga, Alat cukur, Pangkas rambut dan peranti sejenis, Modul fotovoltaik (FV) Silikon kristalin, Baterai sekunder, Baterai litium sekunder, Sistem penyimpanan energi listrik mampu-isi-ulang / Rechargeable Electrical Energy Storage System (REESS), Bank daya (Power Bank ) Ion Litium, Sistem baterai yang dapat dilepas dan ditukar (removable and swappable battery system ), Photo Voltage cables 1500 VDC, Konduit (kaku dan semifleksibel), Showcase",
    "03/04/2026",
    "",
  ],
  ["LP-709-IDN", "No", "", "", "", "", "", "Nomor Akreditasi dicabut"],
  [
    "LP-710-IDN",
    "Yes",
    "Stasiun Karantina Ikan, Pengendalian Mutu dan Keamanan Hasil Perikanan Kupang",
    "Jl. Ade Irma No. 06 Walikota Kupang, Nusa Tenggara Timur",
    "(0380) 8554726",
    "Produk perikanan, bahan olahan produk perikanan, ikan air laut, ikan air tawar",
    "04/05/2026",
    "",
  ],
  [
    "LP-711-IDN",
    "Yes",
    "Balai Riset Perikanan Budidaya Air Tawar dan Penyuluhan Perikanan (multilokasi)",
    "Lokasi 1 :Jl. Sempur No. 1 Bogor, Jawa Barat lokasi 2 : Jl. Aria Surialaga No. 67 cibalagung, Bogor, Jawa Barat Lokasi 3 : Jl. Perikanan No. 13A Pancoran Mas, Depok, Jawa Barat",
    "(0251) 8313200/8327890",
    "Lokasi 1 : Bahan baku pakan, pakan, Ikan air tawar, Ikan air tawar dan ikan air laut (ikan Lais, Ikan tapah, Ikan torsoro, Ikan mata merah, Ikan Tengadak, Ikan Baung, Ikan gabus dan Ikan Nila), Plasma darah ikan air tawar",
    "23/01/2027",
    "",
  ],
  ["LP-712-IDN", "No", "", "", "", "", "", "Nomor Akreditasi dicabut"],
  [
    "LP-713-IDN",
    "Yes",
    "Stasiun Karantina Ikan, Pengendalian Mutu dan Keamanan Hasil Perikanan Aceh",
    "Jl. Raya Bandara Sultan Iskandar Muda, Blang Bintang, Aceh Besar, Aceh",
    "(0651) 636227",
    "Ikan air tawar (ikan mas, ikan lele), produk perikanan (ikan air laut segar dan beku, ikan air tawar segar dan beku, udang segar dan beku), lobster laut, ikan air laut (ikan kerapu dan ikan kakap), crustacea",
    "23/01/2027",
    "",
  ],
  [
    "LP-715-IDN",
    "Yes",
    "UPT Laboratorium Lingkungan Dinas Lingkungan Hidup Kabupaten Pasuruan",
    "JL. Pattimura, No. 223, Kel. Bugul, Pasuruan, Jawa Timur",
    "(0343) 425279",
    "Air limbah, air sungai, air minum",
    "25/07/2026",
    "",
  ],
  [
    "LP-716-IDN",
    "Yes",
    "Stasiun Karantina Ikan, Pengendalian Mutu dan Keamanan Hasil Perikanan Kendari",
    "Jl. Wolter Monginsidi No. 82 A, Desa Langgea, Kec. Ranomeeto, Kendari, Sulawesi Tenggara",
    "(0401) 3196383",
    "Cakalang, layang, gurita, udang vannamei, rajungan, fillet tuna, daging rajungan, fillet kakap, cumi cumi beku, cakalang beku, gurita beku, layur beku, ikan nila, ikan mas, ikan lele, ikan kerapu, lobster, udang windu, kepiting, Ikan hias laut, daging kerang, teripang",
    "20/02/2027",
    "",
  ],
  ["LP-719-IDN", "No", "", "", "", "", "", "Nomor Akreditasi dicabut"],
  [
    "LP-720-IDN",
    "Yes",
    "PT Adhikarilab Indonesia",
    "Ruko Cibubur Indah Blok A No. 16. Jl. Raya Lapangan Tembak, Kel. Cibubur, Kec. Ciracas, Jakarta Timur, DKI Jakarta",
    "(021) 29378125/27",
    "Air untuk keperluan higiene dan sanitasi, air sungai, air sumur, air danau, air situ, air waduk, air rawa, air muara, air limbah, air mineral, air mineral alami, air minum, air laut, kebisingan, udara ambien, getaran, lingkungan kerja, udara emisi sumber tidak bergerak",
    "25/07/2026",
    "",
  ],
  ["LP-722-IDN", "No", "", "", "", "", "", "Nomor Akreditasi dicabut"],
  [
    "LP-723-IDN",
    "Yes",
    "PT Mecoindo",
    "East Jakarta lndustrial Park, Plot 6B - 2 East, Cikarang Selatan, Bekasi, Jawa Barat",
    "(021) 8970270",
    "Meter air DN15-DN20, DN25, DN 40, dan DN50",
    "19/09/2026",
    "",
  ],
  [
    "LP-724-IDN",
    "Yes",
    "Balai Besar Penelitian dan Pengembangan Vektor dan Reservoir Penyakit",
    "Jl. Hasanudin No. 123, Salatiga, Jawa Tengah",
    "(0298) 327096",
    "Anti nyamuk bakar, anti nyamuk elektrik, anti nyamuk semprot (aerosol), anti nyamuk uap cair (liquid), insektisida cair (liquid), insektisida serbuk (powder), insektisida butiran (sand granule), kelambu, penolak nyamuk",
    "01/02/2027",
    "",
  ],
  [
    "LP-725-IDN",
    "Yes",
    "PT Organo Science Laboratory",
    "Sentul City, Plaza Amsterdam Blok A No.7, Bogor, Jawa Barat",
    "(021) 87962710",
    "Tanah, Sayur dan Buah (Kadar air tinggi: belimbing, Kadar air rendah: jambu, bayam, kangkung, pakcoy, kacang panjang, Kadar lemak tinggi: alpukat), Minyak Sawit, Gas proses kegiatan produksi panas bumi, Gas Terkondensasi , Air untuk keperluan higiene dan sanitasi, Air limbah, Air sungai, air danau, air waduk, air saluran, mata air, air rawa dan air gua, Air laut, Udara Ambien, Kebisingan, Udara Lingkungan Kerja, Udara Emisi Sumber Tidak Bergerak, Padatan (tahan, batuan, bata, fly ash, bottom ash, sludge)",
    "25/07/2026",
    "",
  ],
  [
    "LP-726-IDN",
    "Yes",
    "PT Mitralab Buana Surabaya",
    "Jl. Kutisari No.16, Surabaya, Jawa Timur",
    "(031) 8411999",
    "Udara ambien, Kebisingan, Udara lingkungan kerja, Lingkungan kerja, Emisi sumber tidak bergerak, Emisi sumber bergerak, Air limbah, Air sumur, air sungai, air muara, air waduk, Air untuk keperluan higiene Sanitasi, air kolam renang, Air minum, Air laut, Air Mineral",
    "13/06/2026",
    "",
  ],
  [
    "LP-727-IDN",
    "Yes",
    "Laboratorium Geomekanika dan Peralatan Tambang, Institut Teknologi Bandung (ITB)",
    "Jl. Ganesa 10 Bandung, Jawa Barat",
    "(022) 2508128",
    "Batuan",
    "22/11/2026",
    "",
  ],
  ["LP-728-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  ["LP-729-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  ["LP-730-IDN", "No", "", "", "", "", "", "Nomor Akreditasi dicabut"],
  [
    "LP-731-IDN",
    "Yes",
    "Seameo Recfon Universitas Indonesia",
    "Kampus Universitas Indonesia, Jl. Salemba Raya No.6 Jakarta, DKI Jakarta",
    "(021) 31930205",
    "Serum atau plasma darah manusia",
    "04/03/2027",
    "",
  ],
  [
    "LP-732-IDN",
    "Yes",
    "UPTD Balai Pengawasan dan Sertifikasi Benih Tanaman Pangan, Hortikultura dan Perkebunan Aceh",
    "Jl. Panglima Nyak Makam No.30, Lampineung, Banda Aceh, Aceh",
    "(0651) 7551679",
    "Benih tanaman pangan (Padi, Jagung, kedelai, kacang tanah, Kacang panjang),Bayam, Benih tanaman hortikultura (Cabai, Tomat, Terong, kangkung, Kacang panjang, mentimun, seledri, sawi, wortel, bayam)",
    "05/10/2026",
    "",
  ],
  [
    "LP-733-IDN",
    "Yes",
    "PT Bakrie Pipe Industries",
    "Jl. Raya Pejuang, Kec. Medan Satria, Kota Bekasi, Jawa Barat",
    "(021) 88882095-97",
    "Material dan produk logam (pipa, pelat, sambungan las, baja tulangan dan logam paduannya), fasterner (baut dan mur)",
    "25/07/2026",
    "",
  ],
  [
    "LP-737-IDN",
    "Yes",
    "Balai Besar Karantina Pertanian Belawan",
    "Jl. Sulawesi ll, Belawan, Medan, Sumatera Utara",
    "(061) 6941484",
    "Biji pinang (Areca catechu), biji kopi (Coffea sp.), spesimen , Biji pinang (Areca catechu), tepung, Spesimen, jambu air (Syzyngium aqueum), jeruk (Citrus sinensis), nangka (Artocarpus heterophyllus), tomat (Lycopersicum esculentum), Spesimen, biji kacang tanah (Arachis hypogaea) dan/ atau biji-bijian lainnya, Umbi kentang (Solanum tuberosum), , Biji kedelai (Glycine max), Biji gandum (Triticum aestivum), Beras (Oryza sativa), beras pecah (Oryza sativa), ketumbar (Coriandrum sativum), ketan (Oryza glutinosa), Daun tanaman eukaliptus (Eucalyptus sp ), Produk asal hewan:, Daging sapi dan ayam serta olahannya (bakso, sosis, daging asap, burger), susu sapi dan olahannya (susu segar, susu pasteurisasi, susu UHT, es krim, butter, telur, Poultry by Product Meal (PPM) dan Hydrolized Feather Meal (HFM), Meat Bone Meal (MBM) dan Blood Meal, Poultry by Product Meal (PPM), Hydrolized Feather Meal (HFM), Meat Bone Meal (MBM) dan Blood Meal, Serum darah sapi, Serum darah sapi, kambing dan domba, Serum darah sapi, kambing dan domba, Anggur (Grapes) dan Stroberi (Strawberry)",
    "19/09/2026",
    "",
  ],
  ["LP-738-IDN", "No", "", "", "", "", "", "Nomor Akreditasi dicabut"],
  [
    "LP-739-IDN",
    "Yes",
    "PT Sky Pacific Indonesia",
    "Jl. Sholeh Iskandar No. 7. Kel. Kedung Badak, Kec. Tanah Sereal, Kota Bogor, Jawa Barat",
    "(0251) 8358700",
    "Air sumur, air danau, air sungai, air muara, air rawa, air akuifer, air situ, air mata air, air waduk, air limbah, air untuk keperluan higiene dan sanitasi, air tanah, air minum, air laut, udara ambien, kebauan, udara lingkungan kerja, kebisingan, getaran, udara emisi sumber tidak bergerak, udara emisi sumber bergerak, tanah, sedimen, sludge (B3), padatan, bahan multifase (ekstrak TCLP), daun akar, batang, padi berasi, jaringan ikan, kuku, rambut",
    "25/07/2026",
    "",
  ],
  [
    "LP-741-IDN",
    "Yes",
    "UPT Pengujian Mutu dan Pengembangan Produk Kelautan dan Perikanan Banyuwangi",
    "Jl. Barong, Bakungan, Glagah, Banyuwangi, Jawa Timur",
    "(0333) 417845",
    "Udang beku, Udang kupas mentah beku, Udang Rebus Beku, Udang Kupas Rebus Beku, Ikan beku, Tuna beku, Octopus beku, Octopus Sliced cooked, Tuna kaleng, Sarden dan Mackerel dalam kemasan kaleng, Unagi masak beku, Abon ikan, Kerupuk, Bakso Ikan, Tuna Masak Beku,Ikan Segar, Ikan Pindang, Ikan Renyah, Ikan Asin, Rumput Laut, Daging Rajungan dalam kemasan kaleng, Crustaceae Mentah, Crustacea masak, Cephalopoda mentah, Cephalopoda Cooked, Sidat beku, Sidat panggang beku, Nugget ikan, Swab pada Permukaan Ikan dan Peralatan pengolahan ikan (Pisau, Nampan, Meja, Talenan), Teri nasi, Fillet Ikan beku, Cephalopoda beku, Chepalopoda rebus beku, Chepalopoda sliced cooked beku, Air dan Es, Tepung ikan, Abon, pakan ikan, Pasta Ikan, Udang Segar/Beku,Ikan mentah, Ikan masak, Sidat Mentah, sidat masak, Unagi Mentah, Unagi Masak",
    "22 Agustus 2026",
    "",
  ],
  [
    "LP-743-IDN",
    "Yes",
    "PT CCIC Jakarta (Multilokasi)",
    "Kantor Pusat: Menara Citicon, Jl. Letjen S. Parman Kav. 72, Lantai 10, Suite E-F, Slipi, Jakarta Barat, DKI Jakarta Lokasi 1: PT CCIC Jakarta - Tangerang Branch, Pergudangan Bandara Benda Permai Blok M1, Jl. Raya Perancis No. 68, Benda, Tangerang, Banten Lokasi 2: PT CCIC Jakarta - Samarinda Brancht, Jl. PM Noor No. 126N-126O-126P, RT 39, Kel. Sempaja Selatan, Samarinda Utara, Kalimantan Timur Lokasi 3: PT CCIC Jakarta - Banjarbaru Branch, Jl. Banjar Gawi Raya No. 6H LIK, RT 007 RW 003, Liang Anggang, Kel. Landasan Ulin Selatan, Kec. Liang Anggang, Banjarbaru, Kalimantan Selatan",
    "(021) 5591 0851",
    "Lokasi 1: Iron ore, Nickel Ore, Manganese Ore, Bauxite, Trace Element in Coal",
    "19 Desember 2026",
    "",
  ],
  [
    "LP-744-IDN",
    "Yes",
    "PT Envirolab Nusantara",
    "Jl. Raya Kodau No. 1B, Jatiwarna, Pondok Melati, Bekasi, Jawa Barat",
    "(021) 84990026",
    "Udara dalam ruang, kebisingan, getaran, industrial hygiene, udara ambien, air untuk keperluan higiene dan sanitasi, air minum, air sungai, air limbah, udara emisi sumber tidak bergerak",
    "22 November 2026",
    "",
  ],
  [
    "LP-745-IDN",
    "Yes",
    "Balai Layanan Usaha Produksi Perikanan Budidaya Karawang",
    "Dusun Sukajadi RT 01 RW 04, Desa Pusakajaya Utara Kec. Cilebar, Kab Karawang, Jawa Barat",
    "08111155141",
    "Pakan ikan, air payau, air laut, air tawar, crustacea, ikan air tawar, dan ikan air laut",
    "20 Maret 2027",
    "",
  ],
  [
    "LP-746-IDN",
    "Yes",
    "Badan Pengusahaan Kawasan Perdagangan Bebas dan Pelabuhan Bebas Batam",
    "Jl. Sudirman No 1 Batam Centre, Pulau Batam, Kepulauan Riau",
    "(0778) 462047-48",
    "Biji plastik dan komponen elektronika",
    "02 Januari 2027",
    "",
  ],
  [
    "LP-747-IDN",
    "Yes",
    "PT Bredero Shaw Laboratory - Indonesia",
    "Kabil Industrial Estate, Jl. Hang Kasturi 1 No. 14, Kel. Batu Besar, Kec. Nongsa, Batam, Kepulauan Riau",
    "(0778) 4039000",
    "Polyolefine coating, polyolefine coating on steel, fusion bonded epoxy coating, plastics - polyolefine coating, enamel coating, polyurethene coating, polyethylene, polypropylene, adhesive, fusion bonded epoxy coating powder",
    "24 Oktober 2026",
    "",
  ],
  [
    "LP-748-IDN",
    "Yes",
    "PT Cito Diagnostika Utama",
    "Jl. Abdulrahman Saleh No. 226 ABC, Kel. Manyaran, Kec. Semarang Barat, Semarang, Jawa Tengah",
    "(024) 7615511",
    "Air kolam renang, air limbah, air minum, air sungai, air danau, air spa, air untuk keperluan higiene dan sanitasi, kebisingan, udara ambien, udara lingkungan kerja, emisi sumber tidak bergerak, udara ruang",
    "27 Juni 2027",
    "",
  ],
  [
    "LP-750-IDN",
    "Yes",
    "UPT Laboratorium Bahan Konstruksi Dinas Pekerjaan Umum, Penataan Ruang, Perumahan, Kawasan Permukiman dan Pertahanan Provinsi Riau",
    "Jl. Sudirman No 197, Tankeran Selatan Pekanbaru, Riau",
    "(0761) 322940",
    "Agregat, tanah, campuran beraspal, aspal, beton, bor inti, baja tulangan beton, air danau, air sungai, air waduk, air limbah, air untuk keperluan higiene dan sanitasi, air minum, tanah, kebisingan",
    "22 Mei 2027",
    "",
  ],
  [
    "LP-751-IDN",
    "Yes",
    "PT TUV Rheinland Indonesia",
    "Lokasi 1: Infinia Park Blok A-56, B92-B93, Jl. Dr. Saharjo No. 45, Manggarai, Jakarta Selatan, DKI Jakarta Lokasi 2: Kawasan Industrial Taman Tekno, BSD, Blok H3 No. 7, Tangerang Selatan, Banten",
    "Lokasi 1: (021) 57944579 Lokasi 2: (021) 37904579",
    "Lokasi 1 : Mainan Anak, Pelek kendaraan berpenumpang, Pelek Kendaraan bermotor kategori L, Ban dalam kendaraan bermotor, Air Conditioner, Battery charger, Mainan Elektrik, Mesin cuci (Washing Machine), Contact grills, Toasters and Similar Portable cookers (Barbecue for indoor use, Contact grills, Cooker, Food dehydrators, portable ovens, Raclette grills, Radiant grills, Roaster, Rotary grills, Rotisseries, Toasters, Waffle irons, Hotplates), Skin &amp; Hair care (Curling combs, curling irons, curling roller with separate heaters, facial saunas, hand dryers, heaters with detachable curlers, permanent-wave appliances, hair dryer, helmet hair dryers), Kitchen appliances (bean slicer, Cranberry juice extractors, Food), Refrigerator, Rice cooker, electric kettle, Water dispenser, Electrical coffe/tea Maker, Pressure cooker, Electric steam boat, Electric thermo pot, Pump, Setrika, Kipas angin, Peralatan teknologi informasi, PVC kabel, Luminer Magun, Luminer Tanam, Luminer Pencahayaan Jalan Umum, Luminer Kegunaan Umum Portabel, Luminer Lampu Sorot, Luminer Lampu Tidur, Lampu Rantai Cahaya.",
    "02 November 2026",
    "",
  ],
  ["LP-752-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  [
    "LP-753-IDN",
    "Yes",
    "Stasiun Karantina Ikan, Pengendalian Mutu dan Keamanan Hasil Perikanan Tahuna",
    "Jl. Pahlawan, Kel. Tidore, Kec. Tahuna Timur, Kab. Kepulauan Sangihe, Sulawesi Utara",
    "(0432) 21182",
    "Ikan segar (Tuna, Tongkol, Cakalang, Layang, Layaran, Selar, Marlin, Kurisi, Tuna loin, Kerapi, Kakap, Kuwe), Lobster, Ikan Nila, Ikan patin",
    "22 Agustus 2026",
    "",
  ],
  [
    "LP-754-IDN",
    "Yes",
    "PT IOL Indonesia, Palembang Laboratory",
    "Kompleks Pergudangan Sukarame Blok A No.1 Jl.Tembus Terminal Alang-Alang Lebar Palembang",
    "(0711) 5645234",
    "Batubara",
    "20 September 2025",
    "",
  ],
  [
    "LP-755-IDN",
    "Yes",
    "PT Ultra Prima Abadi Orang Tua Group - Laboratorium Analytical Research",
    "Jl. Daan Mogot Km. 14 No. 26, Jakarta Barat, DKI Jakarta",
    "(021) 5441866",
    "Krekers, Biskuit, Wafer, Kembang Gula Keras, Kembang Gula Lunak, Pasta Coklat, Air Demineral, air mineral, Susu UHT, Minuman Mengandung Susu, Minuman Susu Fermentasi, Pudding, Kacang Goyang, Makanan &amp; Minuman Sterilisasi Dalam Kemasan Secara Aseptis, Mouthwash, Pasta Gigi, Antiseptik dan Disinfektan, Biskuit : Krekers, Tidak Termasuk Krekers Manis; Keik, Kukis, dan Pai (Isi Buah atau Custard, Vla), Kembang Gula Keras / Permen Keras, Kembang Gula Lunak Permen Lunak, Minuman Susu Fermentasi Berperisa, Minuman Berbasis Susu yang Berperisa, Minuman Botanikal, Makanan Ringan Olahan Kacang, Olesan Berbasis Kakao, Termasuk Isian (Filling), Minuman Teh dalam Kemasan, Minuman Mengandung Jelly, Air Mineral, Air Demineral, Alkohol technical, Anggur fortifikasi, Minuman mengandung alkohol &gt;15% (whisky), Anggur buah, Minuman ringan beralkohol, Minuman beralkohol beras kencur, Minuman kopi dalam kemasan",
    "25 Juli 2026",
    "",
  ],
  [
    "LP-756-IDN",
    "Yes",
    "PT Global Quality Analytical",
    "Ruko Bukit Cimanggu City Blok C1 No. 22, Jl. Soleh Iskandar, Kota Bogor, Jawa Barat",
    "(0251) 7543299",
    "Udara emisi sumber tidak bergerak, Emisi kendaraan bahan bakar bensin dan solar, udara ambien, kebisingan, lingkungan kerja, air limbah, air limbah domestik, air laut, tanah/sedimen (TCLP), air sungai, air situ, air minum, air sumur, air untuk keperluan higiene dan sanitasi, air limbah fasilitas kesehatan, air RO untuk hemodialisa, air kolam renang, makanan, permukaan/swab",
    "24 April 2026",
    "",
  ],
  [
    "LP-757-IDN",
    "Yes",
    "PT Timah, Tbk",
    "Prayun, Kundur - Karimun, Kepulauan Riau",
    "(0777) 7350100 ext 51645",
    "Bijih timah, Logam timah (tin ingot)",
    "06 Agustus 2026",
    "",
  ],
  ["LP-758-IDN", "No", "", "", "", "", "", "Nomor Akreditasi dicabut"],
  [
    "LP-759-IDN",
    "Yes",
    "PT Riset Perkebunan Nusantara - Pusat Penelitian Bioteknologi dan Bioindustri Indonesia",
    "Jl. Taman Kencana No. 1, Babakan, Kec. Bogor Tengah, Kota Bogor, Jawa Barat",
    "(0251) 8324048",
    "Pupuk organik padat, daun tanaman, bahan aktif pestisida, pupuk NPK padat, pakan ikan, pupuk, gula pasir, pupuk hayati dan pupuk organik, pembersih lantai/disinfektan cair, kacang kedelai dan produk jadinya (tahu, tempe, kecap, dll), bahan olahan daging (sosis, nuget, daging giling, dll)",
    "20 Februari 2027",
    "",
  ],
  [
    "LP-760-IDN",
    "Yes",
    "PT Sucofindo Cabang Tarakan (Multilokasi)",
    "Lokasi 1: Jl. Cahaya Baru RT 02 No.104, Kel. Karang Harapan, Tarakan, Kalimantan Timur Lokasi 2: Laboratorium Unit Lati dan Suaran PT Berau Coal, Jl. Pemuda No. 40, Tanjung Redeb, Kalimantan Timur Lokasi 3: Laboratorium PT Sucofindo Unit Pelayanan Sesayap, Sei Krassi, Sembakung, Nunukan, Kalimantan Utara Lokasi 4: Laboratorium Tanjung Redep Jl. Gunung Panjang RT 01 - Tanjung Redep - Berau, Kalimantan Timur",
    "(0551) 2026645",
    "Batubara, crude palm oil, CPO dan CPKO, palm kernel, drinking water (air minum), air untuk keperluan higiene dan sanitasi, air sungai, air danau, air limbah, limbah cair",
    "17 April 2027",
    "",
  ],
  ["LP-761-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  [
    "LP-762-IDN",
    "Yes",
    "UPT Veteriner Dinas Peternakan Provinsi Nusa Tenggara Timur",
    "Jl. Timor Raya Km. 7, Oesapa Kupang, Nusa Tenggara Timur",
    "(0380) 833360",
    "Serum (sapi, Ayam, babi), daging, susu, telur dan produk olahannya (Bakso, sei, sosis, nuget, Patty), Daging ayam, sapi, Feses babi dan Sapi",
    "17 April 2027",
    "",
  ],
  [
    "LP-763-IDN",
    "Yes",
    "PERUMDAM Tirta Kerta Raharja Kabupaten Tangerang",
    "Jl. Perintis Kemerdekaan III, Cikokol, Tangerang, Banten",
    "(021) 55734361",
    "Air sungai, air keperluan higiene dan sanitasi, air minum",
    "06 Agustus 2026",
    "",
  ],
  [
    "LP-765-IDN",
    "Yes",
    "Balai Karantina Pertanian Kelas II Medan",
    "Jl. Dusun Lestari, Desa Pasar V, Kualanamu, Deli Serdang, Sumatera Utara",
    "(061) 80024003",
    "Sarang burung walet, Serum unggas (ayam, DOC, burung), Serum Anjing dan Kucing, Bahan asal hewan (daging ayam, daging sapi, daging bebek, daging babi, daging kambing, sarang burung walet) dan hasil bahan asal hewan (bakso, sosis, nugget), Umbi kentang, Biji-bijian (beras, kedelai, jagung), Biji kopi",
    "06 Agustus 2026",
    "",
  ],
  [
    "LP-766-IDN",
    "Yes",
    "Balai Litbang GAKI",
    "Kapling Jayan, Borobudur, Magelang, Jawa Tengah",
    "(0293) 789435",
    "Darah manusia, urin, garam",
    "23 Mei 2026",
    "",
  ],
  ["LP-767-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  [
    "LP-768-IDN",
    "No",
    "",
    "",
    "",
    "",
    "",
    "Nomor digabung dengan LP-787-IDN",
  ],
  [
    "LP-769-IDN",
    "Yes",
    "Unit Pengujian Veteriner dan Analisis Pakan, Fakultas Kedokteran Hewan-Universitas Airlangga",
    "Kampus C Universitas Airlangga Jl. Mulyorejo Surabaya, Jawa Timur",
    "(031) 5992785",
    "Pakan, Bahan Pakan (Jagung, cantel, kedelai, Umbi-umbian, Tepung ikan, Tepung tulang, bungkil kedelai, kacang)",
    "30 September 2027",
    "",
  ],
  ["LP-770-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  [
    "LP-771-IDN",
    "Yes",
    "Balai Pengawas Obat dan Makanan di Batam",
    "Jl. Hang Jebat, Kel. Sambau, Kec. Nongsa, Batam, Kepulauan Riau",
    "(0778) 761543",
    "Obat (tablet, serbuk, kapsul), obat tradisional (sediaan padat, sediaan multivitamin bentuk padat, cairan obat dalam), pangan (garam beryodium, tepung terigu, minuman ringan, MP ASI, sirup, limun, minuman sari buah, mie basah, minyak goreng, kecap, tepung terigu, mie instan, madi, air minum dalam kemasan, kopi instan, minyak goreng sawit, minuman kopi mengandung susu, kopi instan, saos samnal, jamu bentuk serbuk), kosmetik (sediaan rias mata, blush on, sediaan serbuk, perona mata dan pipi, semi solid, krim mata, sediaan cair, sediaan bedak bayi, sediaan bedak bayi cair, sediaan sabun bayi cair dan padat, krim wajah, bedak bayi, produk bayi sediaan semisolid, sediaan cairan bukan aerosol, sediaan cair kental, sediaan padat)",
    "17 Juli 2027",
    "",
  ],
  [
    "LP-773-IDN",
    "Yes",
    "PT Surveyor Indonesia Batam",
    "Jl. Kerapu No. 2 Batu Ampar, Batam, Kepulauan Riau",
    "(0778) 411411",
    "Air laut, air untuk keperluan higiene sanitasi, air sumur, air sungai, air muara, air danau dan air waduk, air limbah, emisis sumber tidak bergerak",
    "22 November 2026",
    "",
  ],
  [
    "LP-774-IDN",
    "Yes",
    "UPTD Balai Pengujian dan Sertifikasi Mutu Barang Provinsi Kalimantan Timur",
    "Jl. Letjen. M. T. Haryono No. 45 Samarinda, Kalimantan Timur",
    "(0541) 733731",
    "Lada putih, biji kakao, Crude Palm Oil (CPO)",
    "25 Juli 2026",
    "",
  ],
  [
    "LP-776-IDN",
    "Yes",
    "PT Hankook Tire Indonesia",
    "JI. Kenari Raya Block G.3-01 , Delta silicon 5 Industrial Park Cicau, Cikarang, Bekasi, Jawa Barat",
    "(021) 89880367",
    "Ban mobil penumpang, Ban truk ringan",
    "20 Maret 2027",
    "",
  ],
  [
    "LP-777-IDN",
    "Yes",
    "UPT Laboratorium Kesehatan Hewan Dinas Peternakan Provinsi Jawa Timur",
    "Jl. Mojopahit No. 100, Tuban, Jawa Timur",
    "(0356) 321325",
    "Feses (sapi, kambing, domba), Preparat ulas darah (sapi, kambing, domba), serum (sapi, kambing, domba, ayam, itik, unggas, mentok), daging, susu, telur dan produk olahannya (dendeng, abon, bakso, sosis, nugget, susu pasteurisasi)",
    "19 Desember 2026",
    "",
  ],
  [
    "LP-778-IDN",
    "Yes",
    "Balai Teknologi Hidrodinamika - BPPT",
    "Jl. Hidrodinamika, Kampus ITS Sukolilo, Surabaya, Jawa Timur",
    "(031) 5947849; 5948060",
    "Model kapal",
    "22 November 2026",
    "",
  ],
  [
    "LP-779-IDN",
    "Yes",
    "PT SGS Samarinda (Multilokasi)",
    "Lokasi 1: Jl. Ir. Sutami Blok A no. 9 Komp. Pergudangan, Samarinda, Kalimantan Timur Lokasi 2: Jl. Ahmad Yani KM 12.9 no.105 Gambut, Kabupaten Banjar, Kalimantan selatan",
    "Lokasi 1 : (0541) 270801 Lokasi 2 : (0511) 4220113",
    "Batubara",
    "27 Juni 2027",
    "",
  ],
  [
    "LP-781-IDN",
    "Yes",
    "PT Sucofindo (Persero) - Laboratorium Cabang Bandung",
    "Jl. Soekarno Hatta No. 217, Bandung, Jawa Barat",
    "(022) 6030262",
    "Air minum, air limbah, air untuk keperluan higiene dan sanitasi, air sungai, kebisingan, udara ambien",
    "01 Februari 2027",
    "",
  ],
  ["LP-782-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  ["LP-783-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  ["LP-785-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  [
    "LP-786-IDN",
    "Yes",
    "PT Gunung Raja Paksi, Tbk",
    "Jl. Perjuangan Kp. Tangsi No. 8, RT.004/006, Kel. Sukadanau, Kec. Cikarang Barat, Kab. Bekasi, Jawa Barat",
    "(021) 8900111",
    "Baja plat, coil, beam dan baja tulangan",
    "19 Desember 2026",
    "",
  ],
  [
    "LP-788-IDN",
    "Yes",
    "PT Riset Perkebunan Nusantara - Pusat Penelitian Perkebunan Gula Indonesia",
    "Jl. Pahlawan 25 Pasuruan, Jawa Timur",
    "(0343) 421086",
    "Gula kristal mentah/raw sugar, gula kristal rafinasi, gula kristal putih, tetes, kayu dan sejenisnya, nira, kapur tohor, tebu lonjoran, tebu cacah/ampas tebu, tanah, pupuk NPK, pupuk urea, pupuk amonium sulfat, pupuk SP-36, pupuk KCl, pupuk organik, jaringan tanaman, air permukaan (air sungai), air limbah",
    "01 April 2027",
    "",
  ],
  ["LP-789-IDN", "No", "", "", "", "", "", "Nomor Akreditasi dicabut"],
  [
    "LP-790-IDN",
    "Yes",
    "UPTD Laboratorium Lingkungan Dinas Lingkungan Hidup Kabupaten Tanah Bumbu",
    "Jl. Dharma Praja No.3 Kel. Gunung Tinggi Kec. Batulicin, Kab. Tanah Bumbu, Kalimantan Selatan",
    "(0518) 6070003",
    "Air minum, air untuk keperluan higiene dan sanitasi, air sumur, sir danau, air sungai, air muara, air rawa, air situ, air mata air, air waduk, air limbah, air laut, udara ambien, emisi sumber tidak bergerak, emisi sumber bergerak, kebisingan, lingkungan kerja, tanah",
    "02 Januari 2027",
    "",
  ],
  ["LP-791-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  [
    "LP-792-IDN",
    "Yes",
    "Stasiun Karantina Ikan, Pengendalian Mutu dan Keamanan Hasil Perikanan Tanjung Balai Asahan",
    "Jl. Pelabuhan Pantun Bogan Asahan, Sumatera Utara",
    "(0623) 95004",
    "Ikan Mas, Nila, Lelen, Patin, Gurami, Ikan Sarden, Tongkol, Cumi, Kembung, Selar, produk perikanan segar (kembung, kakap, terisi, kerapu, paru, senangin, selar, tenggiri, sarden, tongkol, cincaru, bawal, Seloncong, samge, cumi, sotong, kipang, udang, rajungan, kerang, lobster air tawar), produk perikanan beku (malong, samge, bawal, tenggiri, sarden, selar, tongkol, cimcaru, tamban, sotong, cumi, gurita, udang, kerang, kepiting)",
    "18 September 2027",
    "",
  ],
  [
    "LP-793-IDN",
    "Yes",
    "Stasiun Karantina Ikan, Pengendalian Mutu dan Keamanan Hasil Perikanan Luwuk Banggai",
    "Jl. Gunung Tompotika No.20, Luwuk, Kab. Banggai, Sulawesi Tengah",
    "(0461) 324671",
    "Ikan air laut (kerapu, kakap, sotong, banggai cardinal, Tuna loin, ikan tongkol,gurita beku, sotong beku, ikan tuna, ikan tenggiri, fillet kakap, fish cube, emperor fillet, ikan kuwe, Parrot fillet),ikan Air Tawar (ikan mas, ikan nila, ikan lele), kelompok Crustacea (kepiting, lobster, udang), Air dan Es, Ikan segar, Ikan beku, gurita beku, Cumi-cumi beku, fillet ikan beku, Ikan Kerapu Segar, Ikan kakap segar, Gurita Segar, Ikan kuwe segar, Ikan kembung segar, Ikan Layang segar, lobster segar, udang kering(ebi), Ikan tenggiri segar, teripang segar, ikan nike beku, ikan teri, Abalone segar, Abalone kering, Sotong beku.",
    "19 Desember 2026",
    "",
  ],
  [
    "LP-794-IDN",
    "Yes",
    "UPTD Balai Pengujian dan Sertifikasi Mutu Hasil Perikanan Provinsi Sulawesi Utara",
    "Jl. Cakalang No. 1, Komplek Pelabuhan Perikanan Samudera (PPS) Aertembaga, Bitung, Sulawesi Utara",
    "(0438) 34424",
    "Cumi-cumi beku, Filet kakap beku, Ikan layang beku, Ikan segar, Lobster beku, Tuna beku, Tuna loin, Tuna steak beku, Tuna segar, Tuna kaleng, Cakalang kalengUdang beku, Udang segar, Cakalang beku, Tuna chunk meat beku, Tuna cube beku, Tuna groundmeat beku, Ikan kayu, Air",
    "30 September 2022",
    "",
  ],
  ["LP-795-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  ["LP-796-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  [
    "LP-797-IDN",
    "Yes",
    "UPTD Laboratorium Kesehatan Hewan dan Kesehatan Masyarakat Veteriner Dinas Pangan dan Pertanian Kabupaten Sidoarjo",
    "Jl. Pahlawan Km. 2, Kab, Sidoarjo, Jawa Timur",
    "(031) 8941252",
    "Daging ayam, daging sapi, daging kambing, burung dara, daging bebek, jeroan ayam, jeroan sapi, telur, bahan olahan asal hewan (bakso, sosis, burger, susu segar, susu bubuk, keju) serum darah ayam, serum darah bebek, serum darah sapi",
    "18 November 2027",
    "",
  ],
  [
    "LP-798-IDN",
    "Yes",
    "Balai Pengujian Standar Instrumen Tanaman Sayuran",
    "Jl. Tangkuban Perahu No.517 Lembang, Jawa Barat",
    "(022) 2785591",
    "Benih cabai, benih tomat, hasil tanaman dan produk olahan, tanah, pupuk organik, pupuk organik padat, pupuk anorganik tunggal, pupuk urea, pupuk amonium sulfat, pupuk SP-36, pupuk KCl, benih kentang, tanaman kentang, tanaman cabai, tanaman tomat, biji bawang merah, tanah dari tanaman kentang, tomat, tanaman kubis, tanaman cabai",
    "20 Februari 2027",
    "",
  ],
  ["LP-799-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  [
    "LP-800-IDN",
    "Yes",
    "Balai Standardisasi dan Pelayanan Jasa Industri (BSPJI) Banda Aceh",
    "Jl. Cut nyak Dien No.377, Lamteumen Timur, Banda Aceh, Aceh",
    "(0651) 49714",
    "Air mineral, NPK padat, pupuk urea, semen portland, semen portland komposit, garam konsumsi beryodium, air rawa, air waduk, air sungai, air danau, dan air tanah, air limbah, sludge, air laut, udara ambien, kebisingan, udara emisi sumber tidak bergerak",
    "29/04/2027",
    "",
  ],
  [
    "LP-801-IDN",
    "No",
    "",
    "",
    "",
    "",
    "",
    "Nomor digabung dengan LP-419-IDN</strong></p>",
  ],
  ["LP-802-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  [
    "LP-804-IDN",
    "Yes",
    "Kedeputian Bidang Infrastruktur Riset dan Inovasi - Direktorat Pengelolaan Laboratorium, Fasilitas Riset, dan Kawasan Sains - Laboratorium Pengujian Teknologi Mesin Perkakas, Produksi dan Otomasi - BRIN",
    "Gedung Teknologi II No. 251, Kawasan PUSPIPTEK Cisauk, Tangerang Selatan, Banten",
    "(021) 75791278",
    "Mesin milling CNC vertical type, mesin bubut CNC",
    "20/02/2027",
    "",
  ],
  ["LP-805-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  [
    "LP-807-IDN",
    "Yes",
    "PT Musim Mas Batam - Analytical Laboratory",
    "Jl. Raya Pelabuhan CPO Kabil, Nongsa, Batam, Kepulauan Riau",
    "(0778) 711571",
    "Crude Palm Oil (CPO), Refined Bleached Deodorized Palm Oil (RBDPO), Refined Bleached Deodorized Palm Olein (RBDPOlein), Refined Bleached Deodorized Palm Stearin (RBDPS), Refined glycerine",
    "22/05/2027",
    "",
  ],
  [
    "LP-808-IDN",
    "Yes",
    "UPT Laboratorium Lingkungan Dinas Lingkungan Hidup Kabupaten Bogor",
    "Jl. H. Jairan, Kelurahan Pakansari, kecamatan cibinong, Kabupaten Bogor, Jawa Barat",
    "(021) 8765124",
    "Air Permukaan (air sungai),air limbah",
    "20/02/2027",
    "",
  ],
  [
    "LP-810-IDN",
    "Yes",
    "PT Wilmar Nabati Indonesia",
    "Jl. Kapten Darmo Sugondo No. 56, Kel. Indro, Kec. Kebomas, Kab. Gresik, Jawa Timur",
    "(031) 28932236",
    "Edible Oil, fatty acid splitted fatty acid product, hydrogenated fatty acid product, distilled fatty acid product, palm kernel expeller/palm kernel mill product, methyl ester product, fatty alcohol product, soap noodle &amp; swing noodle, refined glycerin, lemak dan minyak nabati/produk emulsi lemak yang kadar lemaknya tidak kurang dari 80%/emulsi yang mengandung lemak kurang dari 80%/ fatty acid/soap noodle/methyl ester, biodiesel (PSME dan PKME product), tepung terigu",
    "20/02/2027",
    "",
  ],
  [
    "LP-811-IDN",
    "Yes",
    "UPT Laboratorium Uji Kualitas Lingkungan Dinas Lingkungan Hidup Kabupaten Gresik",
    "Jl. Dr Wahidin Sudirohusodo No. 102 B, Gresik, Jawa Timur",
    "(031) 397566",
    "Air limbah, air danau, air sungai, air sumur, air untuk keperluan higiene sanitasi, air minum, air minum dalam kemasan, udara ambien, kebisingan, lingkungan kerja, udara emisi sumber tidak bergerak",
    "20/02/2027",
    "",
  ],
  [
    "LP-812-IDN",
    "Yes",
    "Balai Keselamatan dan Kesehatan Kerja Medan",
    "Jl. Medan \x{2013} Belawan Km. 11,5 No. 64, Medan, Sumatera Utara",
    "(061) 6853224",
    "Kebisingan, udara ambien, emisi sumber tidak bergerak, lingkungan kerja",
    "22/05/2027",
    "",
  ],
  [
    "LP-813-IDN",
    "Yes",
    "PT ANTAM Tbk, Unit Geomin &amp; Technology Development",
    "Jl. Pemuda No. 1, Kel. Jatinegara Kaum, Kec. Pulogadung, Jakarta Timur, DKI Jakarta",
    "(021) 47898888",
    "Ore nickel, ore bauksit, batuan",
    "22/05/2027",
    "",
  ],
  ["LP-814-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  [
    "LP-818-IDN",
    "Yes",
    "Laboratorium PT Sucofindo (Persero) Cabang Jambi",
    "Lokasi 1: Jl. Fatmawati No. 25 Kel. Kasang, Kec. Jambi timur, Kota Jambi-36141 Lokasi 2: Desa Kasang Pudak RT. 04 RW. 01 Kecamatan Kumpeh Ulu, Kabupaten Muaro Jambi",
    "(0741) 31200",
    "Batubara",
    "18/12/2022",
    "",
  ],
  [
    "LP-819-IDN",
    "Yes",
    "Stasiun Karantina Ikan, Pengendalian Mutu dan Keamanan Hasil Perikanan Medan II",
    "Jl. Pelabuhan Perikanan Samudera Gabion, Belawan, Medan Sumatra Utara",
    "(061) 6945753",
    "Air dan Es, Ikan Segar, Ikan Beku, Ikan olahan, salmon oil, live fish, Frozen Mackerel Fish, Live Grouper Fish, Fish Oil, Salmon Fish Oil, Frozen Salmon, Crustacea, Fresh Scombridae Fish, Frozen Scombridae, Fresh Demersal Fish, Fresh Pelagic Fish,",
    "31/10/2027",
    "",
  ],
  [
    "LP-820-IDN",
    "Yes",
    "UPTD Balai Pengawasan dan Sertifikasi Benih Tanaman Pangan Hortikultura dan Perkebunan Provinsi Bengkulu",
    "Jl. P. Muhammad Noor (Sempaja) No. 3, Samarinda 75117",
    "(0541) 221213",
    "Benih padi, jagung, kedelai, kacang panjang, cabai dan kangkung",
    "23/05/2024",
    "",
  ],
  [
    "LP-821-IDN",
    "Yes",
    "UPTD Balai Pengawasan, Pengujian dan Sertifikasi Benih Tanaman Pangan, Hortikultura dan Perkebunan Provinsi Bengkulu",
    "Jl. Ir. RE. Martadinata Pulau baai kelurahan kandang, kecamatan kampung melayu, Kota Bengkulu",
    "(0736) 21410",
    "Benih padi, jagung, dan kedelai",
    "31/10/2027",
    "",
  ],
  ["LP-822-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  ["LP-823-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  [
    "LP-825-IDN",
    "Yes",
    "Balai Keselamatan dan Kesehatan Kerja Makassar",
    "Jl. KH. Abd. Jabar Akhrisi, KM 17 No. 35, Makassar, Sulawesi Selatan",
    "(0411) 4813186",
    "Air sungai, udara ambien, Pertanahan/Grounding/Arde, Getaran dan kebisingan, Lingkungan Kerja",
    "02/12/2027",
    "",
  ],
  [
    "LP-826-IDN",
    "Yes",
    "PT Surveyor Carbon Consulting Indonesia Cabang Berau",
    "Jl. Harm Ayoeb, Sei Bedungun, Tanjung Redeb, Berau, Kalimantan Timur",
    "(0554) 2020099",
    "Batubara, Nickel ore",
    "18/11/2027",
    "",
  ],
  ["LP-827-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  [
    "LP-828-IDN",
    "Yes",
    "PT Intertek Utama Services - Toka Tindung",
    "C/O PT Meares Soputan Mining Via Desa Winuri, Kec. Likupang Timur, Kab. Minahasa Utara, Sulawesi Utara",
    "(0431) 8895850 ext.172",
    "Mineral batuan (padatan)/mineral rock (solid), larutan (liquor), karbon aktif (padatan), dore bullion",
    "17/04/2027",
    "",
  ],
  [
    "LP-829-IDN",
    "Yes",
    "UPT Proteksi Tanaman Pangan dan Hortikultura Dinas Pertanian dan Ketahanan Pangan Provinsi Jawa Timur",
    "Jl. Pagesangan II NO. 58 Surabaya, Jawa Timur",
    "(031) 8282970",
    "Jeruk, wortel, kacang panjang, cabe, pestisida berbentuk cair dan padat",
    "18/12/2027",
    "",
  ],
  ["LP-830-IDN", "No", "", "", "", "", "", "Nomor Akreditasi dicabut"],
  [
    "LP-831-IDN",
    "Yes",
    "PT Pupuk Kujang",
    "Jl. Jend. A. Yani No. 39 , Cikampek, Karawang, Jawa Barat",
    "(0264) 316141, 317007",
    "Pupuk urea, amoniak cair, pupuk NPK, Pupuk diamonium fosfat (DAP), pupuk fosfat alam, pupuk kalium klorida (KCl), pupuk dolomit",
    "28/08/2027",
    "",
  ],
  [
    "LP-832-IDN",
    "Yes",
    "UPTD Laboratorium Lingkungan Dinas Lingkungan Hidup Kabupaten Musi Banyuasin",
    "Jl. Kolonel Wahid Udin, Kelurahan Serasan Jaya, Kecamatan Sekayu, Kabupaten Musi Banyuasin, Sumatera Selatan",
    "(0714) 321486",
    "Air permukaan (Air sungai, air danau), air limbah, udara ambien, emisi sumber tidak bergerak",
    "16/10/2027",
    "",
  ],
  [
    "LP-833-IDN",
    "Yes",
    "UPTD Laboratorium Lingkungan Dinas Lingkungan Hidup Provinsi Lampung",
    "Jl. Beringin 1 No. 1, Teluk Betung Utara, Bandar Lampung, Lampung",
    "(0721) 486559",
    "Air limbah, air danau, air sungai, air untuk keperluan higiene dan sanitasi, udara ambien, kebisingan",
    "28/08/2027",
    "",
  ],
  [
    "LP-834-IDN",
    "Yes",
    "Laboratorium Aplikasi Kimia dan Pelayanan FMIPA - Universitas Padjadjaran",
    "Jl. Raya Bandung-Sumedang KM 21, Jatinangor, Jawa Barat",
    "081221660102",
    "Tanah, pupuk organik, ektrak tanaman herbal",
    "21/08/2024",
    "",
  ],
  ["LP-836-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  ["LP-837-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  ["LP-838-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  [
    "LP-840-IDN",
    "Yes",
    "Stasiun Karantina Ikan, Pengendalian Mutu dan Keamanan Hasil Perikanan Ternate",
    "Kompleks Bandara Udara Babullah, Ternate 97728",
    "(0921) 3126148, 3111342",
    "Ikan air laut (kerapu, Bandeng, ikan hias, kepiting, lobster, udang), Ikan beku, ikan segar, Ikan Asap, Air, Es",
    "31/10/2027",
    "",
  ],
  [
    "LP-841-IDN",
    "Yes",
    "Stasiun Karantina Ikan, Pengendalian Mutu dan Keamanan Hasil Perikanan Mamuju",
    "Jl. Martadinata, Pelabuhan Ferry Simboro, Mamuju, Sulawesi Barat",
    "(0426) 22434",
    "produk perikanan (ikan segar/beku/kering), udang windu, udang vannamei, Ikan tongkol, Ikan layang, Ikan tuna, Ikan cakalang",
    "06/09/2027",
    "",
  ],
  [
    "LP-842-IDN",
    "Yes",
    "Pusat Kedokteran dan Kesehatan POLRI Jakarta",
    "Jl. Cipinang Baru Raya No. 38 Jakarta Timur 13240",
    "(021) 4700921",
    "Obat batuk cair",
    "15/10/2024",
    "",
  ],
  [
    "LP-843-IDN",
    "Yes",
    "PT Pulau Sambu - Kuala Enok",
    "Tanah Merah, Kec. Tanah Merah, Kab. Indragiri Hilir, Riau",
    "(0768) 21609",
    "Minyak dan lemak, minyak kelapa, CCNO (Crude Coconut Oil), RBD CNO(Refined Bleached Deodorized Coconut Oil), FAO (Fatty Acid Oil); Kelapa dan produk turunannya (coconut, copra, copra expeller, copra extraction pellet), produk makanan dan pakan (copra, copra expeller, copra extraction pellet), air, air untuk produksi",
    "20/03/2027",
    "",
  ],
  [
    "LP-844-IDN",
    "Yes",
    "PT Anindya Wiraputra Banjarbaru",
    "Lokasi 1: Jl. A. Yani Km. 21 RT.02 RW.02 Landasan Ulin Barat, Liang Anggang, Banjarbaru - Kalimantan Selatan 70722 Lokasi 2: Jl. Transmigrasi Km. 3,5 Kel. Barokah, Kec. Simpang Empat Batulicin, Kab. Tanah Bumbu - Kalimantan Selatan 72213",
    "(0511) 4706093",
    "Lokasi 1: Batubara, Nickel Ores, Iron Ores, Limestone, pasir silika, Mineral",
    "26/02/2028",
    "",
  ],
  [
    "LP-846-IDN",
    "Yes",
    "Balai Pengujian Standar lnstrumen Tanah dan Pupuk",
    "Jl. Tentara Pelajar No. 12, Kampus Pertanian Cimanggu, Bogor 16114",
    "(0251) 8336757",
    "Tanah, air irigasi, pupuk urea, pupuk NPK, pupuk SP-36, dolomit, kaptan, pupuk kleserit, pupuk KCI (MOP), pupuk TSP+Zn, pupuk amonium sulfat, pupuk kalium sulfat,Fosfat Alam, pupuk organik, Asam Humat, pupuk hayati",
    "19/03/2024",
    "",
  ],
  [
    "LP-847-IDN",
    "Yes",
    "UPTD Balai Pengawasan dan Sertifikasi Benih Tanaman Pangan dan Holtikultura Provinsi Lampung",
    "Jl. H. Zainal Abidin Pagar Alam No. 1C Rajabasa Bandar Lampung, Lampung",
    "(0721) 701989; 782557",
    "padi, jagung, kedelai, kacang hijau, kacang tanah, kol, cabai, tomat, terong, kubis, sawi, bayam, wortel, kacang panjang, semangka, mentimun, buncis, kangkung, pepaya, bawang, seledri",
    "18/11/2027",
    "",
  ],
  [
    "LP-850-IDN",
    "Yes",
    "PT Arara Abadi",
    "Jl. Raya Minas-Perawang Km. 26 Desa Pinang Sebatang Barat Kecamatan Tualang Kabupaten Siak Provinsi Riau",
    "(0761) 9000200",
    "Pupuk NPK, Pupuk Rock phospate (RP), Pupuk Urea, pupuk dolomite, Pupuk pottasium Chloride (KCl), Pupuk triple Super Phospate (TSP)",
    "30/09/2027",
    "",
  ],
  [
    "LP-851-IDN",
    "Yes",
    "PT Anugerah Sumbermaksmur - Laboratory Services Minamas Research Centre",
    "Jl. Baru Bakal RT 01, RW 03, Desa Tualang Timur, Kecamatan Tualang, Kabupaten Siak, Riau",
    "08117587111",
    "Jaringan tanaman, Minyak kelapa sawit, Air limbah, Pupuk Urea, Pupuk Rock Phosphate-RP, Pupuk KCl (muriate of photash-MOP), Pupuk Kieserite, Pupuk Dolomite, Pupuk Borat (HGF-B),Pupuk Campuran (compound/mixture), NPK ,Tanah",
    "18/11/2027",
    "",
  ],
  [
    "LP-852-IDN",
    "Yes",
    "PT Kehatilab Indonesia",
    "Jl. Swadaya 19, Rawa Mekar Jaya, Serpong, Kota Tangerang Selatan, Banten",
    "(021) 75879235",
    "Air hemodialisa/air untuk infus, air minum, air untuk keperluan higiene dan sanitasi, air kolam renang, air SPA, air permukaan, air danau, air sungai, air limbah, air laut, tanah biomassa, tanah pertanian, sedimen, sludge, dan padatan B3, udara ambien, kebauan, udara lingkungan kerja, kebisingan, getaran, emisi sumber tidak bergerak, emisi kendaraan",
    "31/10/2027",
    "",
  ],
  [
    "LP-853-IDN",
    "Yes",
    "PT BMT Asia Pacific Indonesia-Divisi Laboratorium",
    "Grha BMT Asia Pacific Indonesia, Jl. Pangeran Sogiri No. 61 RT/RW 01/05, Kel. Tanah Baru, Kec. Bogor Utara, Bogor",
    "(021) 8327533",
    "Udara ambien, Kebauan, Udara lingkungan kerja, Emisi sumber tidak bergerak, Emisi sumber Bergerak, Air limbah, Air keperluan Hygiene sanitasi, Air minum, Air sungai, Air laut, Padatan, Padatan TCLP, Limbah B3 padatan, kebisingan",
    "23/04/2024",
    "",
  ],
  [
    "LP-854-IDN",
    "Yes",
    "PT SUCOFINDO Laboratorium Cabang Cilegon",
    "Lokasi 1 : Jl. Raya Serang No. 106 Cilegon, Banten 42421 Lokasi 2 : Site PLTU PT Indonesia Power UP Suralaya, Jl. Paiton No. 1 Suralaya, Banten 42439",
    "(0254) 3386444 (Lokasi 1) (0254) 574335 (Lokasi 2)",
    "Lokasi 1 : Air bersih, Air limbah, Udara ambien, Emisi sumber tidak bergerak, Air permukaan",
    "26/06/2024",
    "",
  ],
  [
    "LP-855-IDN",
    "Yes",
    "Laboratorium Digital Forensik Cyber Crime, Direktorat Reserse Kriminal Khusus Polda Metro Jaya",
    "Jl. Jend. Sudirman No. 55, Jakarta 12190",
    "(021) 52344077",
    "Komputer, Hard disk, Flashdisk, Memory card, CD, DVD Handphone, SIM card, Video, Audio",
    "12/06/2024",
    "",
  ],
  [
    "LP-856-IDN",
    "Yes",
    "Pusat Laboratorium Forensik Bareskrim POLRI",
    "Jl. Babakan Madang No. 67, Cipambuan, Sentul, Bogor, Jawa Barat",
    "(021) 86613730",
    "Hardisk, flashdisk, micro SD, HP, file audio (Flashdisk), file video (Flashdisk), fisik dokumen (kertas, identasi, tinta), tanda tangan dan paraf, tulisan tangan, senjata api, peluru, anak peluru, selongsong peluru, Sisa Mesiu Penembakan (GSR), Darah kering dan segar, semen/Sperma/Vaginal , manusia (pernafasan, tahan kulit, tekanan darah), Limbah cair, minuman keras, logam baja karbon, uang kertas/uang polimer, tablet, jamu dalam bentuk sediaan (serbuk, kapsul, cair), abu arang sisa kebakaran/pembakaran, bahan peledak low wxplosive, limbah cair, limbah B3",
    "12/06/2024",
    "",
  ],
  ["LP-857-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  [
    "LP-859-IDN",
    "Yes",
    "UPTD Balai Pengawasan dan Sertifikasi Perbenihan Tanaman Provinsi Jambi",
    "Jl. Jend. Sudirman No. 28 Thehok, Jambi 36138",
    "(0741) 32201",
    "Padi, kedelai",
    "19/03/2024",
    "",
  ],
  [
    "LP-861-IDN",
    "Yes",
    "Unit Pelaksana Teknis Balai Pengawasan dan Sertifikasi Benih Tanaman Pangan dan Holtikultura Provinsi Kalimantan Tengah",
    "Jl. Cilik Riwut Km 6.5 No. 90, Palangkaraya, Kalimantan Tengah",
    "(0536) 3231492",
    "Benih padi, jagung, kedelai",
    "26/02/2028",
    "",
  ],
  [
    "LP-862-IDN",
    "Yes",
    "UPTD Laboratorium Kesehatan Hewan dan Kesehatan Masyarakat Veteriner Samarinda",
    "Jl. Juanda No. 218 Samarinda 75124",
    "(0541) 761384",
    "Daging (sapi, ayam, babi, kerbau), telur, susu dan hasil olahannya (bakso, sosis, nugget , chicken patty , beef patty , kornet), Serum unggas (ayam, burung, itik, bebek), Serum ruminansia (Sapi, Domba, kambing, babi), Serum Hewan Pembawa Rabies (HPR), feses ruminansia, Organ unggas (Trakhea dan Paru) /Swab kloaka dan orofaring, sarang burung walet",
    "18/11/2027",
    "",
  ],
  [
    "LP-863-IDN",
    "Yes",
    "Balai Penerapan Standar Instrumen Pertanian Sumatera Utara",
    "Jl. Jend. A.H Nasution No. 1B Gedung Johor, Medan 20143",
    "(061) 7870710",
    "Tanah, pupuk KCl, Daun",
    "19/03/2024",
    "",
  ],
  [
    "LP-864-IDN",
    "Yes",
    "Laboratorium Pengujian Balai Keselamatan dan Kesehatan Kerja (BK3) Samarinda",
    "Jl. Santosa No. 09, Samarinda, Kalimantan Timur",
    "(0541) 771306",
    "Udara ambien, lingkungan kerja",
    "18/11/2027",
    "",
  ],
  [
    "LP-865-IDN",
    "Yes",
    "PT Carsurin Palembang",
    "Jl. Tanjung api-api, No. 7, RT 45, RW 10, Kel. Kebun Bunga, Kec. Sukarami, Palembang, Sumatera Selatan",
    "(0711) 415283",
    "Batubara, wood charcoal, activated carbon",
    "18/11/2027",
    "",
  ],
  [
    "LP-866-IDN",
    "Yes",
    "PT BISI International Tbk (Multilokasi)",
    "Lokasi 1 : Jl. Raya Pare-wates Km. 9, Ds. Sumberagung, Kec. Plosoklaten, Kab. Kediri, Jawa Timur Lokasi 2 : Jl. HOS Cokroaminoto No. 72a Ds. Tulungrejo Kec Pare, Kab Kediri, Jawa Timur",
    "(0354) 392624 (0354) 399099",
    "Lokasi 1 : Benih (Jagung, Padi, Kedelai, Jagung Manis, Tanaman famili Cucurbitaceae dan Fabaceae, Tomat, Cabai), Horticulture Crops:Bayam (Amaranthus ),kubis (Brassica oleracea ),brokoli (Brassica oleracea ),pak choy (Brassica rapa ),sawi (Brassica rapa ),selada (Lactuca sativa ),cabai (Capsicum spp), terong (Solanum melongena),tomat (Solanum lycopersicon),gambas/oyong (Luffa acutangula), melon (Cucumis melo), blewah (Cucumis melo),pumpkin/labu (Cucurbita maxima),semangka (Citrulus lanatus),mentimun (Cucumis sativus), buncis (Phaseolus vulgaris),kacang panjang (Vigna unguiculata), kangkung (Ipomoea aquatica)pare/paria (Momordica charantia),okra (Abelmoschus esculentus), Tanaman (Kentang, Tomat, Cabai, Melon, Timun, Luffa, kacang panjang, Padi)",
    "30/09/2027",
    "",
  ],
  [
    "LP-867-IDN",
    "Yes",
    "Balai Karantina Pertanian Kelas I Banjarmasin",
    "Jl. Mayjend Sutoyo No. 1134, Banjarmasin, Kalimantan Selatan",
    "(0511) 3353980",
    "Serum unggas (DOC, DOD, ayam, bebek), serum darah: sapi, kerbau, kambing, bahan asal hewan (daging ayam, daging kerbau, daging sapi, daging kambing) dan hasil bahan asal hewan (sosis, nuget, baso), biji, cangkang dan bungkil kelapa sawit, buah (mangga, jambu air, jambu biji, belimbing, nangka, pepaya, pisang, pear, apel, jeruk), dan serangga, biji kedelai, tepung industri",
    "22/05/2027",
    "",
  ],
  ["LP-868-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  [
    "LP-869-IDN",
    "Yes",
    "PT Solusi Bangun Indonesia, Tbk (multilokasi)",
    "Jl. Ir. H. Juanda. Kab. Cilacap Jawa Tengah (lokasi 1) Jl. Raya Narogong Km. 7 PO BOX 25, Bogor lokasi 2)",
    "(0282) 541521",
    "Clinker, semen tipe PCC dan OPC,semen tipe PCC dan OPC(beton), batubara, AFR",
    "19/05/2025",
    "",
  ],
  [
    "LP-870-IDN",
    "Yes",
    "UPT Laboratorium Kesehatan Hewan Malang",
    "Jl. Raya Pakis Jajar, Kec. Pakis, Kab. Malang, Jawa Timur",
    "(034) 791182",
    "Feses (ruminansia, unggas, mamalia, hewan kecil), darah EDTA, ulas darah, kerokan kulit, serum (ayam, itik, sapi, kambing), daging segar, daging atau karkas beku, daging cincang, telur segar, susu segar, hasil olahan daging, hasil olahan susu, hasil olahan telur, susu, olahan daging",
    "04/06/2027",
    "",
  ],
  [
    "LP-871-IDN",
    "Yes",
    "PT Vicma Lab Indonesia",
    "Jl. Raya Jakarta - Bogor Km. 41, Kec. Cibinong, Kab. Bogor, Jawa Barat",
    "(021) 87902301",
    "Jinten hitam, obat tradisional sediaan kapsul, susu bubuk, mie instan,kembang gula, biji kopi",
    "22/07/2024",
    "",
  ],
  [
    "LP-872-IDN",
    "Yes",
    "UPT Laboratorium dan Pengujian Bahan Kelas A Dinas Bina Marga dan Penataan Ruang Provinsi Sulawesi Tengah",
    "Jl. Towua No. 85, Palu",
    "(0451) 482206",
    "Aspal &amp; campuran beraspal, tanah, agregat, beton",
    "19/03/2024",
    "",
  ],
  ["LP-873-IDN", "No", "", "", "", "", "", "Nomor Akreditasi dicabut"],
  [
    "LP-874-IDN",
    "Yes",
    "PT Musim Mas Belawan - Analytical Laboratory",
    "JL. Sulawesi II, Ujung Baru, Belawan, Medan, Sumatera Utara",
    "(061) 6942141/6942142",
    "Crude palm oil (CPO), Crude palm kernel oil (CPKO), crude palm kernel stearine, Crude palm stearin, crude palm olein, crude palm kernel olein, crude coconut oil, RBD palm oil, RDB palm kernel oil, RBD palm stearine, RBD palm kernel stearine, RBD palm olein, RBD palm kernel olein, RBD coconut oil, Palm kernel fatty acid distillate, Palm fatty acid distillate, Refined Glycerine",
    "01/01/2028",
    "",
  ],
  ["LP-875-IDN", "No", "", "", "", "", "", "Nomor Akreditasi dicabut"],
  [
    "LP-876-IDN",
    "Yes",
    "PT Savoria Kreasi Rasa Cikupa Factory Quality Assurance Departement",
    "Jl. Raya Serang Km. 12, Desa Bitung Jaya, kec. Cikupa, Kab. Tangerang, Banten",
    "(021) 5961253",
    "kembang gula,Makanan ringan, makanan ringan ekstrudat, Minuman serbuk minuman serbuk (teh, teh mengandung susu, kakao, coklat, coklat paduan, kopi instan, kopi instan dengan krimer dan susu), Minuman teh hijau",
    "22/07/2024",
    "",
  ],
  [
    "LP-877-IDN",
    "Yes",
    "PT Mikie Oleo Nabati Industri",
    "Jl. Raya Narogong Km. 9, Bojong Menteng, Rawa Lumbu Bekasi 17117",
    "(021) 82606060",
    "Minyak, margarin, shortening, Minyak goreng sawit (RBD Olein)",
    "21/08/2024",
    "",
  ],
  ["LP-878-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  [
    "LP-879-IDN",
    "Yes",
    "PT Busana Remaja Agracipta",
    "Jl. Pemuda - Klodran - Kadirojo - Jonggrangan - Bantul, DI Yogyakarta",
    "(0274) 6461032 ext 104",
    "Produk tekstil, pakaian jadi, kain renda dan tali",
    "26/06/2024",
    "",
  ],
  [
    "LP-880-IDN",
    "Yes",
    "PT Trouw Nutrition Indonesia - Masterlab Asia",
    "Kawasan Industri MM2100, Jl. Selayar Blok A3-2, Cikarang Barat, Bekasi 17845",
    "(021) 89983325",
    "Jagung, bungkil kacang kedelai (soybean meal), dedak padi (rice brand), besi sulfat, bahan baku pakan, premiks vitamin, air, gandum, premiks mineral, pakan, Pakan Ternak Non Ruminansia",
    "15/10/2024",
    "",
  ],
  [
    "LP-881-IDN",
    "Yes",
    "UPTD Laboratorium Lingkungan Dinas Lingkungan Hidup Kota Bekasi",
    "Jl. Gurame Raya No. 1, Perumnas II, Kayuringin Jaya, Bekasi Selatan, Jawa Barat",
    "(021) 89497830",
    "Air permukaan (air sungai, air danau), air bersih/air untuk keperluan higiene dan sanitasi, air limbah",
    "26/02/2028",
    "",
  ],
  [
    "LP-882-IDN",
    "Yes",
    "PT Anindya Wiraputra Konsult Samarinda",
    "Jl. KH. Harun Nafsi No.58 RT. 22, Rapak Dalam, Kec. Loa Janan Ilir, Samarinda Sebrang, Samarinda 75131, Kalimantan Timur",
    "(0541) 4114429",
    "Batubara",
    "19/03/2024",
    "",
  ],
  ["LP-883-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  ["LP-884-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  [
    "LP-886-IDN",
    "Yes",
    "PT AMMAN Mineral Nusa Tenggara",
    "Environmental Affairs Departement, Site Batu Hijau Kec Sekongkang Kab Sumbawa Barat, Nusa Tenggara Barat",
    "(0372) 635318 ext. 47018",
    "Air permukaan, air sungai, air danau, air kolam, air limbah, air tanah/air bersih, air laut, udara ambien",
    "19/03/2024",
    "",
  ],
  [
    "LP-887-IDN",
    "Yes",
    "Balai Pengawas Obat dan Makanan di Manokwari",
    "Jl. Angkasa Mulyono, Amban, Manokwari, Papua Barat",
    "(0986) 2217025-27",
    "Terapetik dan Napza, obat tradisional, kosmetik, pangan, mikrobiologi",
    "21/08/2024",
    "",
  ],
  [
    "LP-888-IDN",
    "Yes",
    "PT Carsurin Medan",
    "Komplek Ruko The Enterprise No B.15, Jalan Kapten Muslim, Kel Dwikora Medan",
    "(061) 42567147",
    "Minyak dan lemak dari nabati (Crude Palm Oil, RBD Palm Olein), Minyak Goreng Sawit, Minyak Goreng, Wood Charcoal, Air limbah, air sungai, air minum",
    "11/03/2024",
    "",
  ],
  [
    "LP-889-IDN",
    "Yes",
    "PT Tirta Investama - Tirta Lab",
    "Jl. Pulo Lentut No. 3, Kawasan Industri Pulo Gadung, Jakarta Timur",
    "(021) 29558000",
    "Air mineral",
    "23/04/2024",
    "",
  ],
  ["LP-890-IDN", "No", "", "", "", "", "", "Nomor Akreditasi dicabut"],
  ["LP-891-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  [
    "LP-892-IDN",
    "Yes",
    "Unit Pelaksana Teknis Laboratorium Lingkungan Dinas Perumahan Rakyat, Kawasan Permukiman dan Lingkungan Hidup Kabupaten Ketapang",
    "Jl. Hos Cokroaminoto No. 1, Kec, Delta Pawan, Kab. Ketapang, Kalimantan Barat",
    "(0534) 3037605 ; (0534) 3030559",
    "Air permukaan (air sungai, air sumur), air tanah, air limbah, air minum, air untuk keperluan higiene sanitasi",
    "26/06/2024",
    "",
  ],
  [
    "LP-893-IDN",
    "Yes",
    "PT Megasurya Mas",
    "Jl. Tambak Sawah No. 32, Sidoarjo, Jawa Timur",
    "(031) 8662390",
    "Crude palm oil (CPO), olein, Margarine &amp; Shortening, palm wax, soap, soap noodle, gliserin, candle",
    "15/01/2028",
    "",
  ],
  [
    "LP-894-IDN",
    "Yes",
    "PT ITEC Solution Indonesia",
    "Kantor Pusat: Jl. Padma Nirwana Raya No. 6 (Bogor Nirwana Residence) Mulyaharja, Bogor, Jawa Barat Laboratorium: Jl. Bogor Nirwana Raya Ruko Arcade Blok B No. 20, Kel. Mulyaharja, Bogor Selatan, Kota Bogor, Jawa Barat",
    "(0251) 7560193",
    "Air untuk keperluan higiene dan sanitasi, air minum, air sungai, air danau, air limbah, air laut, udara ambien, kebisingan, udara lingkungan kerja, Emisi sumber tidak bergerak, sludge, tanah/padatan",
    "26/02/2028",
    "",
  ],
  [
    "LP-895-IDN",
    "Yes",
    "PT Biodiversitas Bioteknologi Indonesia",
    "Jl. Cilubang Nagrak No. 62, Kel. Situgede, Kec. Bogor Barat, Bogor, Jawa Barat",
    "(0251) 8423 003/8423 005",
    "Pupuk hayati cair, tanah, jaringan tanaman (akar, batang, daun), pupuk organik padat, air sungai",
    "18/11/2027",
    "",
  ],
  [
    "LP-896-IDN",
    "Yes",
    "Balai Karantina Pertanian Kelas I Jambi",
    "Jl. MTQ Raya No. 1, Kota Jambi 36135",
    "(0741) 573110; 572102",
    "Serum sapi, serum ayam, umbi kentang, biji kedelai, Biji pinang, kacang tanah, nanas, pisang, kedelai, specimen serangga, Darah sapi",
    "26/02/2028",
    "",
  ],
  ["LP-897-IDN", "No", "", "", "", "", "", "Nomor Akreditasi dicabut"],
  ["LP-898-IDN", "No", "", "", "", "", "", "Nomor Akreditasi dicabut"],
  [
    "LP-899-IDN",
    "Yes",
    "Laboratorium Central Plantation Services (CPS Lab) - PT Central Alam Resources Lestari (CARL)",
    "Jl. HR. Soebrantas No. 134, Panam, Pekanbaru, Riau 28293",
    "(0761) 61424",
    "Jaringan tanaman, pupuk urea, pupuk amonium sulfat (ZA), pupuk fosfat alam (rock phosphate), pupuk triple super phosphate (TSP), pupuk diammonium phosphate (DPA), pupuk kalium chloride (KCl), pupuk dolomite, pupuk kapur pertanian (kaptan), pupuk kieserite, pupuk NPK padat, pupuk borate, pupuk copper sulphate (CuSO4), pupuk Zinc sulfat (ZnSO4), tanah, pupuk organik",
    "22/07/2024",
    "",
  ],
  [
    "LP-900-IDN",
    "Yes",
    "Balai Besar Pelaksanaan Jalan Nasional XI Banjarmasin",
    "Jl. Brigjend. H. Hasan Basry No. 13, Komp. Bina Marga, Banjarmasin, Kalimantan Selatan",
    "(0511) 4423375",
    "Aspal, tanah, agregat kasar, agregat halus, campuran beraspla, beton",
    "21/08/2024",
    "",
  ],
  [
    "LP-901-IDN",
    "Yes",
    "Balai Karantina Pertanian Kelas I Mataram",
    "Jl. Pelabuhan Lembar No. 9, Kab. Lombok Barat",
    "(0370) 681036",
    "Serum darah (ayam dan burung), darah hewan ternak, daging dan telur, Umbi Kentang, Lalat Buah, Biji-bijian dan serealia, Padi",
    "11/03/2024",
    "",
  ],
  [
    "LP-902-IDN",
    "Yes",
    "PT Aneka Coffee Industry",
    "Jl. Raya Trosobo Km.23, Kec. Taman, Kab. Sidoarjo, Jawa Timur 61257",
    "(031) 8971073; 8971064",
    "Kopi biji, Biji kakao, krimer nabati bubuk, Kopi Gongseng, kakao bubuk, Kakao massa, Lemak kakao, Pasta coklat, gula kristal rafinasi, gula kristal putih, Gula Palma, Gula merah tebu, garam konsumsi beryodium, Lada putih, Kopi instan, kopi bubuk, ekstrak liquid kopi, kopi gula susu dalam kemasan, kopi gula krimer dalam kemasan, kopi+gula, minuman kopi dalam kemasan, kopi celup, Kopi premiks, Kopi Mix, Kopi sangrai dan kopi bubuk, teh hitam, teh hijau, Teh hijau bubuk, teh wangi, teh hitam celup, Teh kering dalam kemasan, Teh Instan, Minuman teh dalam kemasan, Minuman serbuk berperisa, Serbuk minuman tradisional, Biskuit, Keripik kentang, air mineral alami, air bersih, AMDK (air mineral), AMDK (air demineral)",
    "16/10/2027",
    "",
  ],
  ["LP-903-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  [
    "LP-905-IDN",
    "Yes",
    "PT Socfin Indonesia",
    "Jl. Dolok Masihul - Tebing Tinggi, Desa Martebing Kab. Serdang Bedagai",
    "(061) 6616066",
    "Tanah, pupuk urea, pupuk dolomit, pupuk kiserit, pupuk KCl, pupuk TSP, pupuk Rock Phosphate, pupuk NPK padat, daun dan batang, air limbah, air permukaan, air bersih",
    "18/11/2024",
    "",
  ],
  [
    "LP-906-IDN",
    "Yes",
    "UPTD Laboratorium Lingkungan Dinas Lingkungan Hidup dan Kehutanan Provinsi Bengkulu",
    "Komp. Kantor Gubernur Provinsi Bengkulu, Jl. Pembangunan No. 1, Padang Harapan, Bengkulu",
    "(0736) 24016",
    "Air Sungai, Air Danau, Air Rawa, Air Tanah, Air Limbah",
    "26/06/2024",
    "",
  ],
  ["LP-904-IDN", "No", "", "", "", "", "", "Nomor Akreditasi dicabut"],
  [
    "LP-907-IDN",
    "Yes",
    "PT Nojorono Tabacco International",
    "Jl. P. Sudirman No. 86 B, Kudus 59311",
    "(0291) 439161",
    "Rokok kretek/rokok putih",
    "01/09/2024",
    "",
  ],
  ["LP-908-IDN", "No", "", "", "", "", "", "Nomor Akreditasi dicabut"],
  [
    "LP-1013-IDN",
    "Yes",
    "Stasiun Karantina Pertanian Kelas II Bangkalan",
    "Jl. Kusuma Bangsa No. 20, Kamal-Bangkalan",
    "(031) 3012845",
    "Serum sapi",
    "21 Juni 2025",
    "",
  ],
  [
    "LP-1014-IDN",
    "Yes",
    "Laboratorium Energi dan Lingkungan - Direktorat Riset dan Pengabdian Masyarakat (DRPM) Institut Teknologi Sepuluh November (ITS)",
    "Jl. Teknik Kimia, Gedung Pusat Robotika Lt.2, Kampus ITS Sukolilo - Surabaya, Jawa Timur",
    "(031) 58259483",
    "Air danau, air sungai, air limbah, air untuk keperluan hygiene sanitasi, batubara",
    "21 Juni 2025",
    "",
  ],
  [
    "LP-1015-IDN",
    "Yes",
    "Stasiun Karantina Pertanian Kelas I Bengkulu",
    "Lokasi 1 : Jl. Depati Payung Negara KM 14 No. 4, Pekan Sabtu, Bengkulu (Laboratorium Karantina Hewan) Lokasi 2 : Jl. Ir. Rusandi S KM 13.8, No. 58, Kel. Kandang Mas, Bengkulu (Laboratorium Karantina Tumbuhan)",
    "(0736) 53066; 52045; 51607",
    "Serum (ayam, sapi, krebau, domba, kambing), Serealia (beras, tepung beras, jagung, tepung terigu, umbi kentang, pisang, pepaya, jeruk, kopi",
    "21 Juni 2025",
    "",
  ],
  ["LP-1016-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  ["LP-1017-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  [
    "LP-1018-IDN",
    "Yes",
    "Laboratorium Balai Karantina Pertanian Kelas 1 Jayapura",
    "Jl. Kedamaian Kotaraja Grand - Abepura, Kab. Jayapura",
    "(0967) 585789",
    "Serum darah sapi, daging dan telur konsumsi, beras (biji dalam penyimpanan), benih dan bagian tanaman, serum darah unggas, swab trachea/kloaka unggas, kedelai (biji, bunga, polong, daun kedelai), buah-buahan (mangga, pisang, belimbing, jeruk, pepaya, rambutan, cabai, tomat) dan spesimen serangga",
    "30 Juni 2025",
    "",
  ],
  ["LP-1019-IDN", "No", "", "", "", "", "", "Nomor Akreditasi dicabut"],
  ["LP-1020-IDN", "No", "", "", "", "", "", "Nomor Akreditasi dicabut"],
  [
    "LP-1021-IDN",
    "Yes",
    "PT Sucofindo (Persero) Laboratorium Cabang Cirebon",
    "Jl. Dr. Sudarsono No. 46, Kota Cirebon, Jawa Barat",
    "(0231) 242284",
    "Air limbah, air sungai, air untuk keperluan higiene sanitasi, udara ambien, kebisingan lingkungan, udara emisi sumber tidak bergerak",
    "30 Juni 2025",
    "",
  ],
  ["LP-1022-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  [
    "LP-1023-IDN",
    "Yes",
    "Departemen Gizi Masyarakat, FEMA - IPB Laboratorium Jasa Analisis Gizi",
    "Jl. Lingkar Akademik, Kampuas IPB Darmaga, Bogor",
    "(0251) 8621258",
    "Tepung terigu",
    "27 Juli 2025",
    "",
  ],
  [
    "LP-1025-IDN",
    "Yes",
    "Laboratorium Lingkungan Dinas Lingkungan Hidup Kabupaten Sukoharjo",
    "Jl. Tentara Pelajar, Jombor, Bendosari, Sukoharjo",
    "(0271) 591613",
    "Air limbah (domestik), air sungai, air waduk, air sumur, air bersih/tanah",
    "27 Juli 2025",
    "",
  ],
  [
    "LP-1026-IDN",
    "Yes",
    "UPTD Laboratorium Kesehatan dan Keselamatan Kerja Provinsi Kalimantan Selatan",
    "Jl. Brigjend. H. Hasan Basry No. 56, Banjarmasin",
    "(0511) 3304312",
    "Udara ambien, lingkungan kerja, udara emisi sumber tidak bergerak",
    "27 Juli 2025",
    "",
  ],
  [
    "LP-1027-IDN",
    "Yes",
    "UPTD Balai Sertifikasi Mutu dan Keamanan Pangan Dinas Pertanian dan Ketahanan Pangan Provinsi Bali",
    "Jl. Gurita No. 6, Sesetan, Denpasar Selatan",
    "(0361) 4723474",
    "Daging segar dan daging cincang (sapi, babi, kambing, domba, itik, bebek), produk daging olahan, susu dan produk susu olahan (yoghurt, keju), telur dan produk telur olahan (telur asin), darah dan serum ayam, serum sapi",
    "27 Juli 2025",
    "",
  ],
  [
    "LP-1028-IDN",
    "Yes",
    "PT Genero Pharmaceuticals",
    "Jl. Industri Selatan 1B, Blok KK No. 1-2, Kawasan Indutri Jababeka II, Cikarang Selatan, Kab. Bekasi",
    "(021) 89841338",
    "Sediaan kosmetik (solid, semisolid, liquid), bahan baku (Hydroquinone, Methyl Paraben, Prophyl Paraben, Tretinoin), sediaan solid, sediaan semi soid, sediaan liquid",
    "27 Juli 2025",
    "",
  ],
  [
    "LP-1030-IDN",
    "Yes",
    "Stasiun Karantina Pertanian Kelas II Mamuju",
    "Jl. H. Abdul Malik Pattana Endeng, Mamuju",
    "(0426) 2321867",
    "Serum darah sapi, ulas darah (sapi, kambing, domba, kerbau, kuda) buah pisang, spesimen serangga (lalat buah)",
    "23 Agustus 2025",
    "",
  ],
  [
    "LP-1031-IDN",
    "Yes",
    "Balai Karantina Pertanian Kelas II Tanjungpinang",
    "Jl. Rawasari No. 22A, Tanjungpinang",
    "(0771) 319737",
    "Darah Sapi dan Kambing, Darah Unggas (ayam dan DOC/Day Old Chicken), Produk simpan gudang; Beras, tepung beras, tepung tapioka, tepung sagu (Metroxylon sagu), Kacang hijau (Vigna radiata), biji Jagung (Zea mays), biji kopi (Coffea sp), Buah-buahan: pisang (Musa paradisiaca), alpukat (Persea americana), stroberi (Fragaria vesca), durian (Durio zibethinus)",
    "23 Agustus 2025",
    "",
  ],
  [
    "LP-1032-IDN",
    "Yes",
    "Balai Karantina Pertanian Kelas I Batam",
    "Jl. M. Nahar No. 01, Batam Centre, Batam",
    "(0778) 470323, 470324",
    "Tembakau, Biji cokelat, kedelai, serum darah ayam, swab kloaka dan trachea (ayam, burung), daging, telur dan susu serta hasil olahannya",
    "23 Agustus 2025",
    "",
  ],
  [
    "LP-1033-IDN",
    "Yes",
    "Balai Karantina Pertanian Kelas II Ternate",
    "Jl. Ki Hajar Dewantara No. 305, Ternate, Maluku Utara",
    "(0921) 3110799",
    "Serum sapi, serangga (pada kelapa, pisang, nanas)",
    "23 Agustus 2025",
    "",
  ],
  [
    "LP-1034-IDN",
    "Yes",
    "PT Sucofindo (Persero) Laboratorium Cabang Batulicin",
    "Lokasi 1 : Jl. Darma Praja RT 07 RW 01, Kersik Putih, Batulicin, Kalimantan Selatan Lokasi 2 : Indonesia Bulk Terminal Pulau Laut Barat,Mekar Putih, kabupaten Kota Baru",
    "(0518) 6076201",
    "Batubara",
    "23 Agustus 2025",
    "",
  ],
  ["LP-1035-IDN", "No", "", "", "", "", "", "Nomor Akreditasi dicabut"],
  ["LP-1036-IDN", "No", "", "", "", "", "", "Nomor Akreditasi dicabut"],
  [
    "LP-1037-IDN",
    "Yes",
    "PT Vertex Global Indonesia",
    "Pergudangan Bandara Benda Permai Blok G10 Dadap, Tangerang",
    "(021) 29215868",
    "Luminer magun kegunaan umum, Luminer tanam, Luminer pencahayaan jalan umum, Luminer kegunaan umum potabel, Luminer lampu sorot, Audio Video (Pesawat TV, Speaker Aktif, Disc Player DVD/Blu-ray, Tape mobil, Set top box), Grills, toaster and similar cooking appliances, Heating liquid, Kitchen machine, Washing Machine, Electric Fan, Electrical Heat Pump, Air conditioner and dehumidifier, Pump, Refrigerating appliances, ice-making appliances and ice-maker, Electric Iron, Lampu swa-balast untuk pelayanan pencahayaan umum - Persyaratan keselamatan, Lampu LED swa-balast untuk layanan penerangan umum dengan tegangan suplai &gt; 50 V - Spesifikasi keselamatan, Lampu swa-balast untuk pelayanan pencahayaan umum - Persyaratan unjuk kerja, Lampu LED swa-balast untuk layanan penerangan umum dengan tegangan suplai &gt; 50 V - Persyaratan kinerja, Elektrik - Toys, , Aki kendaraan bermotor roda empat atau lebih, Aki kendaraan bermotor kategori L, Tableware, Kloset duduk, Ubin Keramik, Mainan Anak, Peralatan Masak dari logam, , Peralatan makan dan masak dari baja tahan karat, Tangki Air Plastik silinder, Tekstil / Mainan anak, Luminer, Luminer lampu tidur, Luminer rantai cahaya,kipas angin, vacuum cleaner, microwave oven, Peranti perawatan kulit dan rambut, Alat cukur, potong rambut dan sejenisnya, insect killer, Pemanas rendam portable, Pemanggang Roti Listrik,Penanak Nasi, Teko Listrik, Pengering Rambut, Pencukur Listrik, Piranti Pijat Listrik, Pemanas air sesaat (Electric Immersion Stick), Panci listrik serbaguna, Oven Listrik Portabel, Pelumat (Blender ), Pengejus (Juicer), Pencampur (Mixer), Pemroses Makanan Listrik (Electrical Food Processor), Dispenser (Water Dispenser), Pengering Tangan Listrik (Hand Dryer), Catok rambut listrik, Bor Listrik, Gerinda Listrik, Mesin Serut, Gergaji Listrik, Enclosure, Pakaian Bayi, Handuk, Kain Seprai, Kain Seprai, Kain/Tekstil, Karpet/Alas lantai, Sarung Bantal dan sarung guling, Bed cover, Sapu tangan, Selimut, Kasur, Alas kaki seluruhnya dari karet/plastik, Eraser/Penghapus, Alat Pewarna (Crayon), Mainan Anak- Uji Bakar",
    "4 September 2025",
    "",
  ],
  [
    "LP-1038-IDN",
    "Yes",
    "UPTD Laboratorium Lingkungan Dinas Lingkungan Hidup Kota Prabumulih",
    "Jl. Nigata, Kel. Cambai, Kec. Cambai, Kota Prabumulih, Sumatera Selatan",
    "081278829404",
    "Air limbah, air sungai, air danau, air rawa",
    "20 September 2025",
    "",
  ],
  [
    "LP-1040-IDN",
    "Yes",
    "Laboratorium Pengkajian Pangan, Obat-obatan dan Kosmetika Majelis Ulama Indonesia",
    "Gedung Global Halal Centre, Jl. Pemuda No. 5, Bogor",
    "(0251) 8358748",
    "Daging dan Produk Olahannya (Daging segar, Daging Variasi Segar, Daging Beku, Daging Kering, Daging Fermentasi, Daging Cincang, Daging Kornet, Daging Marinasi, Daging Asap, Tepung Daging, Kaldu Daging, Dendeng, Abon, Sosis, Bakso, Nugget, Patty/Burger, Salami, Pastrami), Bahan sediaan obat/farmasi (gelatin, pancreatin, condroitin, placenta, cangkang kapsul), Bumbu (padatan, pasta, cairan), Permen lunak, marshmellow, Rambut/bulu, tulang, Kulit dan Produk Olahannya (kulit, kerupuk kulit), Kulit samak, Flavor cair, Ekstrak Tanaman (vanila ekstrak, apel ekstrak, minyak atsiri, oleoresin), Buah dalam Kemasan (leci kaleng, jamur dalam botol kaca, jamur dalam kemasan plastik), acar, tauco, Minuman (sari buah) dan Minuman yang mengandung alkohol (\x{2264} 0.5 %) , Saus (saus tiram, saus tomat, saus sambal), Kecap (kecap manis, kecap asin), Cuka (cuka apel, cuka beras), Jamu cair, Obat Cair obat batuk, obat-obatan dalam bentuk cairan), Propolis, Yoghurt, Susu Probiotik, minuman mengandung susu, Biskuit, Pembersih Mulut (mouthwash), Kosmetik Dekoratif (eyeshadow, maskara, blash on, pensil alis, foundashion, bedak, lipstik), Air Minum Dalam Kemasan (air mineral, demineral, air embun), Hygiene monitoring (kontak udara, swab test), Produk pangan mengandung bahan hewan unggas, Produk pangan mengandung hewan mamalia, Produk pangan mengandung bahan perikanan, Produk dan bahan kemasan pangan mengandung bahan hewan mamalia (plastik dan kertas), Produk kosmetik mengandung bahan hewan mamalia, Minuman Elektrolit Berkarbonat, Minuman Hipotonik Berkarbonat, Minuman Isotonik Berkarbonat, Minuman Hipertonik Berkarbonat, Minuman Dasar Elektrolit (Electrolyte Drinks Base) Berkarbonat, Serbuk Minuman Berkarbonat, Minuman Berkafein Formulasi (Formulated Caffeinated Beverages), Minuman Berperisa, Ginger Ale, Sarsaparilla, Root Beer, Birch, Beer, Soda Krim (Cream Soda), Minuman Citrus, Minuman Kola, Limun, Larutan Sorbitol, Gliserol, Propilen glikol, Larutan Maltitol",
    "20 September 2025",
    "",
  ],
  [
    "LP-1041-IDN",
    "Yes",
    "Quality Assurance, Food Ingredients Division PT Indofod CBP Sukses Makmur, Tbk",
    "Jl. Raya Purwakarta - Cikampek Km 13, Desa Cikopo, Kec. Bungursari, Kab. Purwakarta, Jawa Barat",
    "(0264) 313511",
    "Bumbu (Bumbu mi instan), Bumbu Pasta, Minyak bumbu, Bawang goreng, Bakso Daging Kering, Kecap, Saus Cabe, Cabe Bubuk, Lada, Solid Ingredient (Sayuran kering, Ikan kering, Daging kering), Produk Steril Komersial (Real Meat), Air bersih untuk produksi, Sirup",
    "20 September 2025",
    "",
  ],
  [
    "LP-1042-IDN",
    "Yes",
    "PT Perta Samtan Gas",
    "Komplek Pertamina Sungai Gerong, Jl. No. 8, Sungai Gerong Banyuasin I, Kab. Banyuasin, Sumatera Selatan",
    "(0711) 5740703",
    "Liquefied petroleum gas (LPG)",
    "20 September 2025",
    "",
  ],
  ["LP-1043-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  ["LP-1044-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  [
    "LP-1045-IDN",
    "Yes",
    "PT Syngenta Seed Indonesia",
    "Jl. Kraton Industri Raya No. 4, PIER, Bangil Pasuruan, Jawa Timur",
    "(0343) 294100",
    "Benih jagung",
    "2 Oktober 2025",
    "",
  ],
  ["LP-1046-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  ["LP-1047-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  ["LP-1048-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  ["LP-1049-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  [
    "LP-1050-IDN",
    "Yes",
    "UPTD Laboratorium Lingkungan Dinas Lingkungan Hidup dan Kehutanan Provinsi Nusa Tenggara Timur",
    "Jl. Alfonsus Nisnoni No.7, Kel. Airnona, Kec. Kota Raja, Kupang",
    "(0380) 829922",
    "Air limbah, air sumur, air danau, air sungai, air muara, air rawa, air akuifer, air mata air, air waduk, air tanah, air minum, air untuk keperluan hygiene dan sanitasi",
    "18 Oktober 2025",
    "",
  ],
  [
    "LP-1051-IDN",
    "Yes",
    "UPTD Laboratorium Lingkungan Dinas Lingkungan Hidup dan Kebersihan Kabupaten Sidoarjo",
    "Jl. Untung Suropati No. 31, Sidoarjo, Jawa timur",
    "(031) 8940947",
    "Air limbah, air sungai, air minum, air untuk keperluan higiene sanitasi",
    "18 Oktober 2025",
    "",
  ],
  [
    "LP-1052-IDN",
    "Yes",
    "PT Carsurin Cilegon",
    "Rukan Business Square Blok C-19, Jl. Raya Utama Pondok Cilegon Indah, Cilegon, Banten",
    "(0254) 380808",
    "Mono Etilen Glikol/MEG (produk petrokimia), Solar High Speed Diesel (HSD) dan Base Oil",
    "27 Oktober 2025",
    "",
  ],
  [
    "LP-1053-IDN",
    "Yes",
    "PT UL International Indonesia",
    "Altira Business Park Blok E/03, Jl. Yos Sudarso Kav. 85, Sunter, Jakarta Utara",
    "(021) 26690908-09",
    "TTusuk kontak dan kotak kontak untuk keperluan rumah tangga dan keperluan sejenis - Bagian 1: Persyaratan umum , Kabel berinsulasi PVC dengan tegangan pengenal sampai dengan 450 / 750V Bagian 3: Kabel nirselubung untuk perkawatan magun, Kabel berinsulasi PVC dengan tegangan pengenal sampai dengan 450 / 750V Bagian 4: Kabel berselubung untuk perkawatan magun, Kabel berinsulasi PVC dengan tegangan pengenal sampai dengan 450 / 750V Bagian 5: Kabel fleksibel (kabel senur), Kabel daya dengan insulasi terekstrusi dan lengkapannya untuk voltase pengenal dari 1 kV (Um=1,2 kV) sampai dengan 30 kV (Um=36 kV) - Bagian 1: Kabel untuk voltase pengenal 1 kV (Um=1,2 kV) dan 3 kV (Um=3,6 kV), Kabel daya dengan insulasi terekstruksi dan lengkapnya untuk voltase pengenal dari 1 kV (Um = 1,2 kV) sampai dengan 30 kV (Um = 36 kV) - Bagian 2: Kabel untuk voltase pengenal 6 kV (Um = 7,2 kV) ampai dengan 30 kV (Um = 36 kV), audio, video and similar electronic apparatus - Safety requirements",
    "27 Oktober 2025",
    "",
  ],
  [
    "LP-1054-IDN",
    "Yes",
    "Balai Pengawasan dan Sertifikasi Benih Pertanian Provinsi Nusa Tenggara Barat",
    "Jl. Raya Peninjauan Narmada, Mataram",
    "(0370) 672433",
    "Benih padi, benih palawija (jagung, kacang tanah, kacang hijau, kedelai), hortikultura (sawi/petsay, kangkung, seledri, wortel, selada, kacang buncis, terong, bayam, kacang panjang, tomat, cabai",
    "22 November 2025",
    "",
  ],
  [
    "LP-1055-IDN",
    "Yes",
    "UPTD Pembinaan dan Pengawasan Mutu Barang Bengkulu",
    "l. Mangga V, Lingkar Timur, Bengkulu",
    "(0736) 20189",
    "Standard Indonesian Rubber (SIR), biji kopi, biji kakao, crude palm oil (CPO), karet konvensional",
    "22 November 2025",
    "",
  ],
  [
    "LP-1056-IDN",
    "Yes",
    "PT Citra Borneo Indah - Laboratorium Analitik",
    "Jl. Sulung Kenambui KM. 30,4 Desa Runtu, Kec. Arut Selatan, Kab. Kota Waringin Barat, Kalimantan Tengah",
    "(0532) 21297",
    "Daun, pupuk urea, pupuk kalium klorida, pupuk kiserit, pupuk dolomit, pupuk NPK padat, pupuk fosfat alam untuk pertanian, pupuk borat, pupuk copper sulfat, pupuk zink sulfat, tanah, air tanah, air sungai, air limbah, crude palm oil (CPO)",
    "22 November 2025",
    "",
  ],
  [
    "LP-1058-IDN",
    "Yes",
    "PT Nugraha Indah Citarasa Indonesia",
    "Jl. Surya Kencana Kav. 1 Bok M1 - BCD, Kawasan Industri Surya Cipta, Karawang, Jawa Barat",
    "(0267) 8637994",
    "Seasoning Powder",
    "22 November 2025",
    "",
  ],
  ["LP-1059-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  [
    "LP-1060-IDN",
    "Yes",
    "UPT Laboratorium Pengujian Kualitas Lingkungan Dinas Lingkungan Hidup Kota Yogyakarta",
    "Jl. Bimasakti No. 1 Yogyakarta",
    "(0274) 515876",
    "Air sungai, air waduk/embung, air limbah, air untuk keperluan higiene sanitasi",
    "1 Desember 2025",
    "",
  ],
  [
    "LP-1061-IDN",
    "Yes",
    "UPTD Laboratorium Lingkungan Dinas Lingkungan Hidup Kabupaten Banyuasin",
    "Komplek Perkantoran Pemerintah Kabupaten Banyuasin No. 31, Sekojo, Pangkalan Balai, Banyuasin, Sumatera Selatan",
    "(0711) 7690109",
    "Air sungai, air sumur, air danau, air limbah, kebisingan lingkungan, udara ambien, udara emisi sumber tidak bergerak",
    "1 Desember 2025",
    "",
  ],
  ["LP-1062-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  [
    "LP-1063-IDN",
    "Yes",
    "UPTD Laboratorium Kesehatan Kota Semarang",
    "Jl. Raden Patah No. 178, Semarang",
    "(024) 3545020",
    "Air minum (PDAM, DAM/DEPO air minum, air siap minum, air hygiene sanitasi (sumur, air artesis)",
    "1 Desember 2025",
    "",
  ],
  [
    "LP-1064-IDN",
    "Yes",
    "PT Mintec Abadi Site",
    "PT Kideco Jaya Agung - Laboratorium Penguji Mekanika Batuan, Jl Job Site PT Kideco Jaya Agung, Desa Batu Kajang RT 025, Kab. Paser, Kalimantan Timur",
    "(0543) 22522",
    "Batuan, tanah",
    "1 Desember 2025",
    "",
  ],
  [
    "LP-1065-IDN",
    "Yes",
    "UPTD Laboratorium Lingkungan Dinas Lingkungan Hidup Kota Probolinggo",
    "Jl. Anggrek (Depan TPA Bestari), Probolinggo, Jawa Timur",
    "(0335) 426558",
    "Air limbah industri, air sungai, air sumur, air mata air, air kolam renang",
    "13 Desember 2025",
    "",
  ],
  [
    "LP-1066-IDN",
    "Yes",
    "Balai Karantina Pertanian Kelas II Palangkaraya",
    "Jl. G. Obos Km. 5,5, Palangkaraya, Kalimantan Tengah",
    "(0536) 3247400",
    "Serum darah sapi dan kerbau, biji, kecambah, tanaman dan bagian tanaman kelapa sawit, bungkil kelapa sawit",
    "13 Desember 2025",
    "",
  ],
  [
    "LP-1067-IDN",
    "Yes",
    "Departemen Ilmu Tanah dan Sumberdaya Lahan, Fakultas Pertanian - Institut Pertanian Bogor (IPB)",
    "Jl. Meranti, Kampus IPB Dramaga, Bogor, Jawa Barat",
    "(0251) 8627792",
    "Tanah, tanaman, pupuk organik padat",
    "13 Desember 2025",
    "",
  ],
  ["LP-1068-IDN", "No", "", "", "", "", "", "Nomor Akreditasi dicabut"],
  [
    "LP-1069-IDN",
    "Yes",
    "UPT Pembenihan dan Sertifikasi Benih Tanaman Pangan Hortikultura, dan Perkebunan Provinsi Riau",
    "Jl. Kaharudin Nasution No. 69, Simpang Tiga, Pekanbaru",
    "(0761) 674687",
    "Benih kacang tanah, kedelai, padi, jagung",
    "22 Desember 2025",
    "",
  ],
  ["LP-1070-IDN", "No", "", "", "", "", "", "Nomor Akreditasi dicabut"],
  [
    "LP-1071-IDN",
    "Yes",
    "PT Jakarta Cakratunggal Steel Mills",
    "Jl. Raya Bekasi Km 21-22, RT 01/RW 09, Cakung Barat, Cakung, Jakarta Timur, DKI Jakarta",
    "(021) 4604230",
    "Baja tulangan beton, low alloy steel",
    "13 Desember 2025",
    "",
  ],
  ["LP-1072-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  [
    "LP-1073-IDN",
    "Yes",
    "PT Inti Ganda Perdana",
    "Lokasi 1 : Jl. Pegangsaan dua blok A1 Km 1.6 Kelapa Gading, Jakarta Utara Lokasi 2 : Kawasan Industri Mitra Kerawang, Jl. Mitra Raya III Blok I-3 &amp; I-4, Desa Parungmulya, Kec. Ciampel, Kab. Karawang, Jawa Barat",
    "(021) 4602755 (0267) 8637868",
    "Poros propeller, poros axle",
    "22 Desember 2025",
    "",
  ],
  [
    "LP-1074-IDN",
    "Yes",
    "Fakultas Perikanan dan Ilmu Kelautan, Universitas Mulawarman, Laboratorium Kualitas Air",
    "Jl. Muara Pahu, Kompleks Gedung FPIK, Kampus Gn. Kelua, Universitas Mulawarman, Samarinda",
    "(0541) 748554",
    "Air sungai, air danau, air muara, air rawa, air waduk, air limbah, air sumur, air laut",
    "22 Desember 2025",
    "",
  ],
  [
    "LP-1075-IDN",
    "Yes",
    "UPTD Jasa Laboratorium Energi dan Sumberdaya Mineral Provinsi Sulawesi Selatan",
    "Jl. A. Pangerang Pettarani, Makassar",
    "(0411) 873045",
    "Mineral (batuan), air tanah",
    "22 Desember 2025",
    "",
  ],
  [
    "LP-1076-IDN",
    "Yes",
    "Laratorium Pusat Survei Geologi",
    "Jl. Diponegoro No. 57 Bandung",
    "(022) 7203205",
    "Batuan, tanah/soil, batuan (vein, batuan alterasi, sedimen sungai, bijih)",
    "26 Desember 2025",
    "",
  ],
  [
    "LP-1077-IDN",
    "Yes",
    "UPT Laboratorium Lingkungan Dinas Lingkungan Hidup Provinsi Kalimantan Selatan",
    "Jl. Bangun Praja Kawasan Perkantoran Pemerintah Provinsi Kalimantan Selatan",
    "(0511) 6749252",
    "Air limbah, air muara, air mata air, air waduk, air sungai, air tanah, air danau, air bersih (air untuk keperluan hygiene dan sanitasi), udara ambien, kebisingan lingkungan",
    "26 Desember 2025",
    "",
  ],
  ["LP-1078-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  [
    "LP-1079-IDN",
    "Yes",
    "PT IAPMO Group Indonesia",
    "Jl. Kapuk Timur Blok F23 No. 11A, Lippo Cikarang, Bekasi",
    "(021) 89911467",
    "Ubin Keramik, Tableware, Tangki Pembilas, Katup Pembilas, Fitting Inlet dan Outlet, Cookware, Flatware, Profil Baja Ringan, Kaca Lembaran, Kaca Pengaman Diperkeras Untuk Kendaraan Bermotor, Kaca Pengaman Berlapis (Laminated Glass) Untuk Kendaraan Bermotor, Blok Kaca, Cermin Kaca Lembaran Lapis Perak, Cermin kaca lembaran lapis alumunium, cat dekoratif, Kloset Duduk, Kloset Jongkok, Kloset duduk fitur dual flush, Perlengkapan tambahan untuk kloset duduk, tangki dan urinal (Trim for Water Closet Bowls, Tanks and Urinals), Kloset enam liter dengan penggelontor ganda (Six-Liter Water Closets Equipped With a Dual Flushing Device), Kloset, Urinal, Urinal gantung dinding, bak mandi, bidet, pancuran air minum, bak cuci tangan, lantai shower (dulang), penggunaan pada institusional, Kloset, Urinal, Bak cuci, bak cuci klinis, Kloset, Bak cuci tangan tipis, kloset, urinal yang dipasang di dinding, urinal keramik, lantai shower (dulang), bak cuci non-vitrous china, Bak mandi, Pancuran air minum dan pendingin air, bak cuci tangan, Lantai Shower (dulang), bak cuci, Bak cuci tangan, Bak mandi, Pancuran air minum dan pendingin air, Bak mandi, kloset, urinal, bidet, Bak cuci tangan, bak cuci, pancuran air minum dan pendingin air, Lantai shower (dulang), bidet, Lantai shower (dulang), Bak mandi, Bak cuci tangan/ piring, Bak mandi, Bak cuci tangan/ piring, baskom plastik, ember plastik, Performa of shower for bathing, Water supply tapware, Fitting Suplai, Fitting Suplai (High effisiency - Shower head dan hand held shower), Fitting Suplai (High effisiency - commercial pre-rinse spray valve), Fitting Buangan, Selang air fleksibel, Katup pengisi- anti siphon, Katup gelontor, kincir 1 phase, kincir berangkai, Galvanis pada produk zinc alloy, Spesifikasi bata ringan untuk pasangan dinding, bata beton untuk pasangan dinding, bata beton kerawang, bata beton (paving blok), bata beton pejal, bata merah untuk pasangan dinding, bata merah berlubang, pipa, sambungan pipa, fiberglass, kantong plastik untuk pembibitan tanaman, wastafel keramik, pipa baja lapis seng, Pipa baja saluran air dengan atau tanpa lapisan seng, Pipa baja untuk perancah, Kawat baja lapis paduan seng alumunium (Bj KLSA), Baja lembaran, plat dan gulungan canai panas (Bj P), Baja lembaran lapis seng (Bj LS), Baja profil siku sama kaki proses canai panas (Bj P siku sama kaki), Baja lembaran dan gulungan canai dingin (Bj D), Spesifikasi beton aerasi autoklaf, Baja lembaran dan gulungan lapis paduan alumunium - seng (Bj. L.AS), Keran Sanitari: Spesifikasi umum untuk regulator laju alir",
    "17 Januari 2026",
    "",
  ],
  [
    "LP-1080-IDN",
    "Yes",
    "Balai Karantina Pertanian Kelas I Semarang",
    "Jl. Benoa No.1, Komplek Pelabuhan Laut Tanjung Emas, Semarang, Jawa Tengah",
    "(024) 3547915",
    "Spesimen serangga, biji kedelai, bagian tanaman sengon, sarang burung walet, serum darah anjing, serum darah sapi, dan kambing, biji gandum",
    "26 Januari 2026",
    "",
  ],
  ["LP-1081-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  ["LP-1082-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  ["LP-1083-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  [
    "LP-1084-IDN",
    "Yes",
    "Perum Percetakan Uang Republik Indonesia",
    "Jl. Tarum Barat, Desa Parungmulya, Kec. Ciampel, Kab. Karawang, Jawa Barat",
    "(021) 73950000 ext 4115, 4116",
    "Kertas security, Kertas Kemasan, Kertas Komersil dan Kertas Sticker, Doss/karton gelombang",
    "15 Februari 2026",
    "",
  ],
  [
    "LP-1085-IDN",
    "Yes",
    "PT Putra Baja Deli",
    "Kawasan Industri Terpadu Wilmar, Bojonegara, Kramatwatu, Serang, Banten",
    "087886000402",
    "Baja tulangan beton sirip, baja tulangan beton polos, Low alloy (carbon steel)",
    "15 Februari 2026",
    "",
  ],
  [
    "LP-1086-IDN",
    "Yes",
    "UPTD Laboratorium Lingkungan Dinas Lingkungan Hidup Kabupaten Purwakarta",
    "Jl. Purnawarman Timur No. 11A, Purwakarta, Jawa Barat",
    "0264-212738/8308120",
    "Air sungai, air limbah",
    "15 Februari 2026",
    "",
  ],
  [
    "LP-1087-IDN",
    "Yes",
    "Perumda Air Minum Tirta Raharja Kabupaten Bandung",
    "Jl. Kolonel Masturi Km.3 Cipageran, Cimahi Utara, Cimahi, Jawa Barat",
    "(022) 6654184",
    "Air minum",
    "26 Februari 2026",
    "",
  ],
  ["LP-1088-IDN", "No", "", "", "", "", "", "Nomor Akreditasi dicabut"],
  [
    "LP-1089-IDN",
    "Yes",
    "Balai Karantina Pertanian Kelas I Padang",
    "Jl. Sutan Syahrir No. 267, Mata Air, Padang",
    "(0751) 62560",
    "Pinang, kakao, serum darah sapi",
    "21 Maret 2026",
    "",
  ],
  ["LP-1090-IDN", "No", "", "", "", "", "", "Nomor Akreditasi dicabut"],
  [
    "LP-1091-IDN",
    "Yes",
    "Stasiun Karantina Pertanian Kelas I Biak",
    "Jl. Dr. Sam Ratulangi Np. 35, Biak, Papua",
    "(0981) 22084",
    "Serum darah sapi, Serum darah ayam, day old chick (DOC), serum darah day old duck (DOD), Bahan asal hewan (daging ayam, daging bebek, daging sapi, daging rusa, daging kambing, telur dan susu), Hasil Bahan asal hewan (bakso sapi, bakso ayam, nugget, sosis sapi dan sosis ayam), Tanaman Holtikultura (Mangga, Pepaya, Jeruk, Rambutan,Sirsak, alpukat, nanas, Buah naga, pisang, puring, Anggrek, lengkeng, sawo, sawi, salak atau bagian bagiannya), Tanaman Perkebunan : Kakao (Theobroma cacao) atau bagian-bagiannya (buah, bunga, batang, daun dan akar)",
    "21 Maret 2026",
    "",
  ],
  [
    "LP-1092-IDN",
    "Yes",
    "Balai Karantina Pertanian Kelas I Pontianak",
    "Jl. Kom. Yos Sudarso No. 81 A, Pontianak, Kalimantan Barat",
    "(0561) 775322 / 775323",
    "Biji kedelai, serum darah ruminansia, serum darah unggas, Spesimen Kering Lalat Buah, Sarang Burung Walet",
    "21 Maret 2026",
    "",
  ],
  ["LP-1093-IDN", "No", "", "", "", "", "", "Nomor Akreditasi dicabut"],
  [
    "LP-1094-IDN",
    "Yes",
    "Bidang Laboratorium Forensik (BIDLABFOR) Polda Jawa Timur",
    "Jl. Achmad Yani No. 116, Surabaya, Jawa timur",
    "(031) 8280550",
    "Darah segar, Bercak darah, Bercak saliva, Bercak sperma, Kuku, Abu/arang sisa kebakaran, Manusia (Polygraph Forensik), Mobile Phone dan Sim Card, , Hard Disk dan Memory Card, PC Komputer, Dokumen kertas, Tanda tangan dan paraf pada kertas, Tulisan tangan pada kertas, Uang kertas, Blanko kertas, Stempel pada kertas, Kristal, Tablet, Cairan, Bong, Cangklong, Pipet Kaca, Sedotan Plastik Bekas Pakai dan Alumunium Foil, Daun-daun kering, biji-biji kering dan ranting-ranting, Tablet, Kapsul dan Serbuk, Senjata Api standar organik dan senjata api rakitan, Peluru Standar Organik dan Modifikasi, Anak Peluru (Proyektil) dan Selongsong Peluru, Bahan Peledak Low Explosive, Bahan Peledak High Explosive, Sampel (mikro) BB yang diduga Bahan Peledak (Unknown Substances), Sampel BB yang diduga Bahan Peledak (Unknown Substances), Serpihan Objek dan Semburan Debu (Swab Residu Post Blast), Bahan Peledak, Tempat Kejadian Perkara, Nomor Rangka, Nomor Mesin, Nomor Rangka dan Nomor Mesin",
    "3 April 2026",
    "",
  ],
  [
    "LP-1095-IDN",
    "Yes",
    "Bidang Laboratorium Forensik (BIDLABFOR) Polda Sulawesi Selatan",
    "Jl. Sultan Alauddin No. 8, Pabaeng-Baeng, Makassar, Sulawesi Selatan",
    "(0411) 872022",
    "Darah kering dan Sperma kering, Epitel pipi, sampel darah, Sperma, Kristal, cairan, bong, cangklong, pipet kaca, sedotan, plastik bekas pakai, alumunium foil dan urine, Tablet, kapsul serbuk, cairan, kristal , Ganja, Material Dokumen, Tanda Tangan/Paraf, Tulisan Tangan, Blanko, Cap Stempel, Tulisan Cetak, Uang Kertas, Senjata Api Standar, Peluru, Selongsong dan Anak peluru, Bahan Peledak, Kendaraan Bermotor, Senjata Api, Abu/Arang sisa kebakaran , Handphone &amp; Simcard, Hardisk, flashdisk, memory card, dan komputer",
    "3 April 2026",
    "",
  ],
  [
    "LP-1096-IDN",
    "Yes",
    "UPTD Balai Laboratorium Kesehatan, Pemeliharaan dan Kalibrasi Alat Kesehatan Provinsi Kepulauan Bangka Belitung",
    "Jl. Pulau Pongok, Kel. Air Itam, Kec. Bukit Intan, Pangkal Pinang, Kepulauan Bangka Belitung",
    "(0717) 423304",
    "Air mineral, air minum",
    "24 April 2026",
    "",
  ],
  [
    "LP-1097-IDN",
    "Yes",
    "Balai Pengujian Standar Instrumen Tanaman Industri dan Penyegar",
    "Jl. Raya Pakuwon Km. 2, Parungkuda , Kab. Sukabumi, Jawa Barat",
    "(0266) 6542181",
    "Tanah, tanaman/jaringan",
    "24 April 2026",
    "",
  ],
  ["LP-1098-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  [
    "LP-1099-IDN",
    "Yes",
    "PT Graha Mutu Persada, Persada Laboratory",
    "Jl. Raya Pacing No. 01, Kec. Bangsal, Mojokerto, Jawa Timur",
    "(0321) 5287839",
    "Air limbah, air untuk keperluan higiene dan sanitasi, air sungai, air laut, air minum, udara ambien, lingkungan kerja, udara emisi sumber tidak bergerak",
    "24 April 2026",
    "",
  ],
  [
    "LP-1100-IDN",
    "Yes",
    "Bidang Laboratorium Forensik (BIDLABFOR) Polda Bali",
    "Jl. Gunung Sanghyang No. 108B, Denpasar, Bali",
    "(0361) 410608",
    "Cairan serum, cairan urin, Buccal swab, bercak darah, bercak sperma, kristal, tabley, cairan, bong, cangklong, pipet kaca, sedotan, plastik bekas pakai, aluminium foil, Narkotika (batang, daun, biji kering, padatan cokelat/hitam, cairan kental, tablet, kapsul serbuk, cairan, dan kristal), tanda/tulisan tangan, produk cetak, uang, anak peluru, bahan peledak, kendaraan bermotor, abu/arang sisa kebakaran dari riksa TKP, respon reaksi tubuh manusia, digital forensik (hard disk, flash disk, micro SD, handphone, sim card, memory, file audio)",
    "24 April 2026",
    "",
  ],
  [
    "LP-1101-IDN",
    "Yes",
    "UPTD Laboratorium Lingkungan Dinas Lingkungan Hidup Kabupaten Tapin",
    "Jl. Gubernur H. Aberani Sulaiman No. 129, Dulang Rantau, Kab. Tapin, Kalimantan Selatan",
    "(0517) 31638",
    "Air sungai, air danau, air limbah",
    "4 Mei 2026",
    "",
  ],
  [
    "LP-1102-IDN",
    "Yes",
    "PT Mega Andalan Kalasan",
    "Jl. Solo KM. 13, Tanjungtirto, Tirtomani, Sleman, Daerah Istimewa Yogyakarta",
    "(0274) 4398407",
    "Kastor dan roda, tempat tidur pasien (manual dan elektrik)",
    "4 Mei 2026",
    "",
  ],
  [
    "LP-1103-IDN",
    "Yes",
    "Loka Pengamanan Fasilitas Kesehatan Banjarbaru",
    "Jl. Benua Praja Utara, RT.03 RW. 01, Kel. Cempaka, Kec. Cempaka, Banjarbaru, Kalimantan Selatan",
    "(0511) 5915674",
    "TLD badge, pesawat sinar X general purpose, pesawat sinar x mobile, dental panoramic with chepalometry, dental sinar x intra oral, pesawat sinar x CT scan, Radiasi lingkungan pesawat sinar X",
    "4 Mei 2026",
    "",
  ],
  ["LP-1104-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  ["LP-1105-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  [
    "LP-1106-IDN",
    "Yes",
    "Balai Penerapan Standar Instrumen Pertanian Bengkulu",
    "Jl. Irian Km 6.5, Bengkulu",
    "(0736) 23030",
    "Tanah, pupuk NPK padat",
    "23 Mei 2026",
    "",
  ],
  ["LP-1107-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  [
    "LP-1108-IDN",
    "Yes",
    "PT Nachindo Tape Industry",
    "Desa Betro, Kec. Sedati, Kab. Sidoarjo, Jawa Timur",
    "(031) 8910285",
    "Adhesive Tape (Pressure Sensitive Tape): OPP tape, masking tape, PVC tape, double side tape, double foam tape, cloth tape, kraft tape, hard PVC tape, glass filament tape, cellulose tape, mending tape, stationary tape",
    "23 Mei 2026",
    "",
  ],
  [
    "LP-1109-IDN",
    "Yes",
    "PT AusNDT Indonesia",
    "Rukan Kelapa Gading Square Blok H/28A, Kelapa Gading, Jakarta Utara, DKI Jakarta",
    "(021) 45869955",
    "Lasan berbahan logam, material berbahan logam",
    "5 Juni 2026",
    "",
  ],
  [
    "LP-1110-IDN",
    "Yes",
    "Balai Pengkajian Teknologi Pertanian (BPTP) Lampung",
    "Jl. HI. ZA. Pagar Alam No. 1A, Rajabasa, Bandar Lampung",
    "(0721) 781776, 701328",
    "Tanah",
    "5 Juni 2026",
    "",
  ],
  [
    "LP-1111-IDN",
    "Yes",
    "Loka Pengamanan Fasilitas Kesehatan (LPFK) Surakarta",
    "Jl. Sindoro Raya, Kampung Randusari RT 02 RW 03, Kel. Mojosongso, Kec. Jebres, Surakarta, Jawa Tengah",
    "(0271) 644379",
    "Radiografi umum dengan dan tanpa AEC, Radiografi mobile , Pesawat gigi [Panoramic Cephalometri], Pesawat gigi Intra Oral, Computed Tomography (CT) - SCAN, Mammografi, Fluoroskopi (R/F, C-Arm, ESWL, Angiografi), MRI, Dosimeter Film (Film Badge), Dosimeter TL (TLD Badge)",
    "5 Juni 2026",
    "",
  ],
  ["LP-1112-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  [
    "LP-1113-IDN",
    "Yes",
    "Balai Penerapan Standar Instrumen Pertanian Lampung",
    "Jl. Sumantri Brojonegoro No. 1, Bandar Lampung, Lampung",
    "082185928209",
    "Residu pestisida pada tomat, melon, anggur, strawberry, beras dan jagung",
    "13 Juni 2026",
    "",
  ],
  [
    "LP-1114-IDN",
    "Yes",
    "UPTD Laboratorium Lingkungan Dinas Lingkungan Hidup Kota Pangkalpinang",
    "Jl. Delima Siam VI, Kel. Sriwijaya, Kec. Girimaya, Pangkalpinang, Bangka",
    "(0717) 9102539",
    "Air permukaan (air sungai, air sumur, air danau), air limbah",
    "13 Juni 2026",
    "",
  ],
  [
    "LP-1115-IDN",
    "Yes",
    "PT Carsurin Kendari",
    "Jl. Prof. M. Yamin No. 63, Kel. Puuwatu, Kec. Puuwatu, Kab. Kendari, Sulawesi Tenggara",
    "08119465350",
    "Bijih nikel, produk nikel hasil pengolahan dan pemurnian",
    "13 Juni 2026",
    "",
  ],
  [
    "LP-1116-IDN",
    "Yes",
    "PT Pembangkitan Jawa Bali Unit Bisnis Jasa (PJB UBJ) O&amp;M PLTU Rembang",
    "Jl. Raya Semarang Surabaya Km. 130, Desa Leran Kec. Sluke, Kab. Rembang, Jawa Tengah",
    "(0295) 4552779",
    "Batubara",
    "13 Juni 2026",
    "",
  ],
  [
    "LP-1117-IDN",
    "Yes",
    "Balai Besar Perikanan Budidaya Air Tawar Sukabumi",
    "Jl. Selabintana No. 37, Sukabumi, Jawa Barat",
    "(0266) 225211",
    "Ikan, ikan mas dan koi, produk perikanan, pakan dan bahan baku pakan ikan, air sumber, air permukaan, Air sumur, mata air, air kolam, air sungai, air danau, udang, pakan buatan, pakan alami, bahan baku pakan",
    "2 Juli 2026",
    "",
  ],
  ["LP-1118-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  [
    "LP-1120-IDN",
    "Yes",
    "Balai Laboratorium Pengujian Kesehatan Ikan dan Lingkungan Kelas A Provinsi Jawa Tengah",
    "Jl. Mpu Tantular No. 2, Semarang, Jawa Tengah",
    "(0245) 3514838",
    "Air permukaan (air sungai, air irigasi, air kolam ikan, air waduk, air danau, air sumur, air tambak/muara), ikan (ikan nila, ikan gurame, ikan mas, ikan koi, ikan lele, ikan tawes, ikan bawal, ikan kornet, udang dan bandeng), udang windu dan udang vaname",
    "25 Juli 2026",
    "",
  ],
  ["LP-1121-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  [
    "LP-1122-IDN",
    "Yes",
    "Balai Teknik Pantai",
    "Jl. Gilimanuk - Singaraja Km. 122, Gerokgak, Bali",
    "(0362) 92598",
    "Model bangunan pantai",
    "25 Juli 2026",
    "",
  ],
  ["LP-1123-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  [
    "LP-1124-IDN",
    "Yes",
    "PT Hijau Persada Sejahtera",
    "Jl. Jendral Sudirman Km 5.5, Komplek Sawit Raya I No. 02, Sampit, Kalimantan Tengah",
    "(0531) 2067829",
    "Daun, pupuk RP, pupuk NPK, pupuk urea, pupuk KCl, pupuk borat",
    "25 Juli 2026",
    "",
  ],
  [
    "LP-1125-IDN",
    "Yes",
    "PT Surya Indotim Imex",
    "Jl. Raya Jonggol, Kp. Tunggilis, Desa Cipeucang, Kec. Cileungsi, Kab. Bogor, Jawa Barat",
    "(021) 89931103",
    "Gas mixture",
    "25 Juli 2026",
    "",
  ],
  [
    "LP-1126-IDN",
    "Yes",
    "PT Wiraswata Gemilang Indonesia",
    "Desa Gandamekar Km. 24, Cibitung, Bekasi, Jawa Barat",
    "(021) 8831241",
    "Minyak lumas motor bensin 4(empat) langkah kendaraan bermotor, Minyak lumas motor bensin 4(empat) langkah sepeda motor, Minyak lumas motor diesel putaran tinggi, Minyak lumas roda gigi transmisi manual dan gardan, Minyak lumas transmisi otomotif, Minyak lumas hidrolik , Minyak lumas motor bensin 2 (dua) langkah dengan pendingin udara, Pelumas Used Oil , Additive (Package, TBN Booster, VI Improver), Base Oil (BS 150, SN 500, Dubase 4, Solvent (Heavy Gas Oil))",
    "25 Juli 2026",
    "",
  ],
  [
    "LP-1127-IDN",
    "Yes",
    "UPTD Laboratorium Lingkungan Dinas Lingkungan Hidup Kota Semarang",
    "Jl. Tapak Raya, Tugurejo, Kec. Tugu, Kota Semarang, Jawa Tengah",
    "(024) 8664742",
    "Air limbah, air untuk keperluan higiene dan sanitasi, air sungai, air minum",
    "6 Agustus 2026",
    "",
  ],
  [
    "LP-1128-IDN",
    "Yes",
    "UPTD Laboratorium Lingkungan, Dinas Lingkungan Hidup Kota Pariaman",
    "Jl. Diponegoro No. 48, Kota Pariaman, Sumatera Barat",
    "(0751) 93844",
    "Air limbah, air sungai, air sumur, air tanah, air danau, air minum, air untuk keperluan higiene dan sanitasi",
    "6 Agustus 2026",
    "",
  ],
  [
    "LP-1129-IDN",
    "Yes",
    "PT Jambi Lestari Internasional",
    "Jl. Nusa Indah I No. 59E, Kel. Rawasari, Kec. Alam Barajo, Kota Jambi, Jambi",
    "(0741) 3071716",
    "Air sungai, air muara, air rawa, air waduk, air akuifer, air danau, air situ, air limbah, air untuk keperluan higiene dan sanitasi, Kolam Renang, SPA, Pemandian umum, air minum, Air Untuk Fasilitas Kesehatan/Hemodialisis, udara ambien, emisi sumber tidak bergerak,emisi sumber bergerak, kebisingan, lingkungan kerja, Tanah, Sedimen",
    "6 Agustus 2026",
    "",
  ],
  [
    "LP-1130-IDN",
    "Yes",
    "UPT Laboratorium Terpadu dan Sentra Inovasi Teknologi - Universitas Lampung",
    "Jl. Prof. Dr. Sumantri Brodjonegoro No. 1, Bandar Lampung, Lampung",
    "(0721) 784049",
    "Air sumur, air sungai, air minum, air limbah, tanah",
    "6 Agustus 2026",
    "",
  ],
  [
    "LP-1131-IDN",
    "No",
    "",
    "",
    "",
    "",
    "",
    "Nomor digabung dengan LP-229-IDN",
  ],
  ["LP-1132-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  [
    "LP-1133-IDN",
    "Yes",
    "PT PJB UBJ O&amp;M PLTU Paiton",
    "Jl. Surabaya-Situbondo Km. 141, Paiton, Kab. Probolinggo, Jawa Timur",
    "(0335) 771668",
    "Batubara",
    "22 Agustus 2026",
    "",
  ],
  [
    "LP-1134-IDN",
    "Yes",
    "PT IOL Indonesia Laboratorium Paiton",
    "Jl. Raya Surabaya - Situbondo Km. 141, Paiton, Kab. Probolinggo, Jawa Timur",
    "08115555026 /08115849562",
    "Batubara",
    "22 Agustus 2026",
    "",
  ],
  [
    "LP-1135-IDN",
    "Yes",
    "Balai Laboratorium Bea dan Cukai Kelas II Medan",
    "Lokasi 1: Jl. Sumatera No.116, Belawan, Medan, Sumatera Utara Lokasi 2 : Satuan Pelayanan Laboratorium Bea dan Cukai Teluk Bayur, Jl. Sutan Syahrir No. 1, Komplek Perumahan Bea Cukai, Bukit Putus, Kel. Rawang, Padang Selatan, Padang, Sumatera Barat Lokasi 3 : Satuan Pelayanan Laboratorium Bea dan Cukai Bandar Lampung, Jl. Yos Sudarso, Pelabuhan Panjang, Bandar Lampung, Pidada, Panjang, Bandar Lampung, Lampung",
    "(061) 6945236",
    "Lokasi 1: Crude Palm Oil (CPO), Polimer, Minuman mengandung Etil Alkohol, RBD Palm Olein, RBD Palm Stearin",
    "22 Agustus 2026",
    "",
  ],
  [
    "LP-1136-IDN",
    "Yes",
    "SMK SMAK Padang",
    "Jl. Alai Pauh V. No. 13, Kel. Kel. Kapalo, Padang, Sumatera Barat",
    "(0751) 777703",
    "Minyak atsiri (minyak pala, minyak nilam, minyak sereh), kopi instand, sabun cair pembersih tangan, pupuk NPK, air limbah",
    "22 Agustus 2026",
    "",
  ],
  [
    "LP-1137-IDN",
    "Yes",
    "PT Tribhakti Inspektama Cabang Palembang",
    "Jl. Tembus Terminal Km. 12 Ruko No. 12 dan 13 RT. 012 RW. 005, Kel. Talang Kelapa, Kec. Alang-alang Lebar, Kota Palembang, Sumatera Selatan",
    "",
    "Batubara",
    "22 Agustus 2026",
    "",
  ],
  [
    "LP-1138-IDN",
    "Yes",
    "UPTD Laboratorium Lingkungan Dinas Lingkungan Hidup Kota Cimahi",
    "Komplek Perkantoran Kota Cimahi, Gedung D, Jl. Demanghardjakusumah, Kota Cimahi, Jawa Barat",
    "(022) 6650060",
    "Air permukaan (air sungai, air danau, air danau buatan), air limbah, air untuk keperluan higiene dan sanitasi",
    "22 Agustus 2026",
    "",
  ],
  [
    "LP-1139-IDN",
    "Yes",
    "UPT Laboratorium Lingkungan Dinas Lingkungan Hidup Kota Malang",
    "Jl. Simpang Majapahit No. 1 Kota Malang, Jawa Timur",
    "(0341) 360328",
    "Air limbah, air sungai",
    "22 Agustus 2026",
    "",
  ],
  ["LP-1140-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  ["LP-1141-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  ["LP-1142-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  ["LP-1143-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  ["LP-1144-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  ["LP-1145-IDN", "No", "", "", "", "", "", "Nomor Akreditasi dicabut"],
  [
    "LP-1146-IDN",
    "Yes",
    "UPTD Laboratorium Lingkungan Dinas Lingkungan Hidup Kabupaten Luwu Timur",
    "Jl. Soekarno Hatta, Malili, Kab. Luwu Timur, Sulawesi Selatan",
    "(0474) 321371",
    "Air sungai, air danau, air sumur, air limbah",
    "19 September 2026",
    "",
  ],
  [
    "LP-1147-IDN",
    "Yes",
    "Stasiun Karantina Pertanian Kelas I Samarinda",
    "Jl. P.M. Noor No. 2 Sempaja, Samarinda, Kalimantan Timur",
    "(0541) 220016",
    "Serum darah sapi, preparat ulas darah sapi, kayu serpihan, biji kedelai",
    "19 September 2026",
    "",
  ],
  [
    "LP-1148-IDN",
    "Yes",
    "UPT Laboratorium Lingkungan Dinas Lingkungan Hidup Kabupaten Musi Rawas",
    "Komplek Perkantoran Pemerintah Kab. Musi Rawas, Jl. Lintas Sumatera Km. 12,5 Muara Beliti, Kab. Musi Rawas, Sumatera Selatan",
    "(0733) 4552400",
    "Air sumur, air danau, air sungai, air rawa, air waduk, air tanah, air minum, air untuk keperluan higiene dan sanitasi, air limbah, udara emisi sumber tidak bergerak, lingkungan kerja, udara ambien",
    "5 Oktober 2026",
    "",
  ],
  ["LP-1149-IDN", "No", "", "", "", "", "", "Nomor Akreditasi dicabut"],
  [
    "LP-1150-IDN",
    "Yes",
    "PT PLN Nusantara Power UP Indramayu",
    "Jl. Raya Sukra, Desa Sumur Adem, Kec. Sukra, Kab. Indramayu, Jawa Barat",
    "(0234) 5613236",
    "Batubara",
    "24 Oktober 2026",
    "",
  ],
  [
    "LP-1151-IDN",
    "Yes",
    "Balai Perlindungan Tanaman Pangan dan Hortikultura Provinsi Jawa Barat",
    "Jl. Tangkuban Parahu KM. 22, Cikole, Lembang, Kab. Bandung Barat, Jawa Barat",
    "(022) 2784949",
    "Formulasi dan bahan teknis pestisida, residu pestisida (sayuran berpigmen dan berkadar air tinggi, buah dan sayuran berkadar air tinggi, pupuk NPK padat, pupuk SP-36, pupuk organik padat, pupuk organik cair",
    "24 Oktober 2026",
    "",
  ],
  [
    "LP-1152-IDN",
    "Yes",
    "PT PLN Nusantara Power UP Gresik",
    "Jl. Harun Thorir No. 1, Kab. Gresik, Jawa Timur",
    "(031) 3981569",
    "Air boiler drum, gas alam (natural gas)",
    "24 Oktober 2026",
    "",
  ],
  ["LP-1153-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  [
    "LP-1154-IDN",
    "Yes",
    "UPT Laboratorium Lingkungan Dinas Lingkungan Hidup Kabupaten Jombang",
    "Jl. Presiden KH. Abdurrahman Wachid No.132, Kab. Jombang, Jawa Timur",
    "(0321) 8494980",
    "Air limbah, air sungai, air untuk keperluan higiene dan sanitasi",
    "2 November 2026",
    "",
  ],
  [
    "LP-1155-IDN",
    "Yes",
    "Balai Perikanan Budidaya Air Tawar Sei Gelam Provinsi Jambi",
    "Jl. Bumi Perkemahan Pramuka Desa Sungai Gelam, Kab. Muaro, Jambi",
    "(0741) 75554472",
    "Ikan air tawar, bahan pakan, pakan dan ikan",
    "2 November 2026",
    "",
  ],
  ["LP-1156-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  [
    "LP-1157-IDN",
    "Yes",
    "PT International Cargo Services",
    "Jl. Veteran No. B-97, Helvetia Komplek Brayan Trade Center, Medan, Sumatera Utara",
    "(061) 8459253",
    "Vegetable fat/oil and derivative, palm kernel/copra expeller, wood charcoal",
    "22 November 2026",
    "",
  ],
  [
    "LP-1158-IDN",
    "Yes",
    "UPTD Laboratorium Lingkungan Dinas Lingkungan Hidup Kabupaten Sarolangun",
    "Komplek Perkantoran Gunung Kembang, Kab. Sarolangun, Jambi",
    "(0745) 91357",
    "Air sungai, air limbah",
    "22 November 2026",
    "",
  ],
  [
    "LP-1159-IDN",
    "Yes",
    "PT Soci Mas",
    "Jl. Pulau Irian No. 2, Kawasan Industri Medan, Saentis, Percut Sei Tuan, Kab. Deli Serdang",
    "(061) 6851582",
    "Fatty Acid, soap noodle, glyserin",
    "4 Desember 2026",
    "",
  ],
  [
    "LP-1160-IDN",
    "Yes",
    "PT PJB UBJ O&amp;M PLTU Tanjung Awar-awar",
    "Jl. Tanjung Awar-awar Desa Wadung Kec. Jenu, Kab. Tuban, Jawa Timur",
    "(0356) 320320",
    "Batubara",
    "4 Desember 2026",
    "",
  ],
  ["LP-1161-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  [
    "LP-1162-IDN",
    "Yes",
    "PT Indofood CBP Sukses Makmur, Tbk - Laboratorium Central Quality Control Divisi Noodle",
    "Jl. Kp. Jarakosta, Desa Sukadanau RT 005/02 No. 1, Cibitung, Kab. Bekasi, Jawa Barat",
    "(021) 8901166",
    "Mie (mie instan, mie kering, mie makanan ringan), saus cabe, kecap, garam, bawang goreng, bubuk bumbu, minyak goreng, tepung terigu, cabe bubuk, minyak bumbu, batubara, cangkang sawit, solid ingredient, tepung kedelai, tepung beras, tapioka, deoiled soy lechitine powder, terigu",
    "4 Desember 2026",
    "",
  ],
  ["LP-1163-IDN", "No", "", "", "", "", "", "Nomor Akreditasi dicabut"],
  [
    "LP-1164-IDN",
    "Yes",
    "UPTD Balai Pengembangan Teknologi dan Standardisasi Industri",
    "Jl. Ciwaru Raya No. 57, Serang, Banten",
    "(0254) 8491044",
    "Paving block",
    "19 Desember 2026",
    "",
  ],
  [
    "LP-1165-IDN",
    "Yes",
    "Lembaga Penyakit Tropis Universitas Airlangga",
    "Kampus C Mulyorejo Universitas Airlangga, Surabaya, Jawa Timur",
    "(031) 5992445-46",
    "Darah, serum dan plasma nyamuk, larva nyamuk dan nyamuk dewasa, Darah, serum dan plasma manusia, sputum, darah manusia dan hewan, jaringan biopsi manusia dan hewan, trunk wash (gajah), aerosol, cairan tubuh ain (cairan cerebrospinal, pleural, syunovil, dll), biopsi jaringan dan sayatan kulit, serum, darah dari manusia, Isolat senyawa organik, Larva dan Nyamuk Aedes aegypti dan Aedes albopictus",
    "19 Desember 2026",
    "",
  ],
  [
    "LP-1166-IDN",
    "Yes",
    "UPT Balai Pengembangan Perbibitan Ternak dan Diagnostika Kehewanan, Dinas Pertanian dan Ketahanan Pangan Daerah Istimewa Yogyakarta",
    "Desa Barongan, Kel. Sumberagung, Kec. Jetis, Kab. Bantul, Daerah Istimewa Yogyakarta",
    "(0274) 55241; 08112950898",
    "Serum unggas (ayam dan itik), serum dan darah ayam, serum sapi dan kambing, daging telur, susu serta hasil olahannya",
    "19 Desember 2026",
    "",
  ],
  [
    "LP-1167-IDN",
    "Yes",
    "PT Bina Pratama Sakato Jaya - Laboratorium Agronomi",
    "Sungai Tenang, Kiliranjao, Kec. Kamang Baru, Kab. Sijunjung, Sumatera Barat",
    "08117056117",
    "Daun, tanah, pupuk NPK padat",
    "19 Desember 2026",
    "",
  ],
  [
    "LP-1168-IDN",
    "Yes",
    "PT PJB UBJ O&amp;M PLTU Pacitan - Laboratorium Kimia",
    "Jl. Raya Pacitan - Trenggalek KM 55, Ds. Sukorejo, Kec. Sudimoro, Kab. Pacitan, Jawa Timur",
    "(0357) 5173444",
    "Batubara",
    "19 Desember 2026",
    "",
  ],
  [
    "LP-1169-IDN",
    "Yes",
    "UPTD Laboratorium Pengujian dan Pengendalian Mutu Hasil Perikanan Kepulauan Bangka Belitung",
    "Jl. Ketapang, Pangkalbalam, Pangkalpinang, Kepulauan Bangka Belitung",
    "(0717) 9100125",
    "Ikan segar, ikan beku, kekerangan, olahan ikan, air dan es, swab permukaan",
    "19 Desember 2026",
    "",
  ],
  ["LP-1170-IDN", "No", "", "", "", "", "", "Nomor Akreditasi dicabut"],
  [
    "LP-1171-IDN",
    "Yes",
    "Laboratorium Keamanan Pangan Dinas Pangan Aceh",
    "Jl. T. Nyak Arief, Komplek Keistimewaan Aceh, Banda Aceh, Aceh",
    "(0651) 7551754",
    "Pome Fruit, Fruitting Vegetables/curcubits, Brasica vegetables, roat and tuber vegetables, leafy vegetables and fresh herbs, cereal grain and products, dry legume vegetables/pulses, buah (pir, anggur, apel), sayuran (cabe, tomat, kol, timun, bawang merah, bayam, kemangi)",
    "23 Januari 2027",
    "",
  ],
  [
    "LP-1172-IDN",
    "Yes",
    "PT Mitra Agro Servindo",
    "Jl. Tomang Raya No. 49 C-D, Jakarta Barat, DKI Jakarta",
    "(021) 5664048",
    "Tanaman daun, tanah, pupuk fosfat alam, pupuk urea, pupuk kalium klorida, pupuk NPK, pupuk organik, pupuk TSP, pupuk Borat",
    "23 Januari 2027",
    "",
  ],
  [
    "LP-1173-IDN",
    "Yes",
    "PT Chemviro Buana Indonesia",
    "Jl. Mayor Oking Jaya Atmajaya, Ruko Imperium Park Blok C No. 19, Kel. Ciriung, Kec. Cibinong, Bogor, Jawa Barat",
    "(021) 87914212",
    "Kebisingan, lingkungan kerja, udara ambien, udara emisi, air limbah, air untuk keperluan higiene sanitasi, air sungai, air sumur, air waduk, air danau, Crude Palm Oil (CPO)",
    "23 Januari 2027",
    "",
  ],
  [
    "LP-1174-IDN",
    "Yes",
    "PT PLN (Persero) Unit Induk Transmisi Jawa Bagian Timur dan Bali",
    "Jl. Suningrat No. 45, Taman Sidoarjo, Kabupaten Sidoarjo, Jawa Timur",
    "(031) 7882113",
    "Minyak trafo pakai",
    "1 Februari 2027",
    "",
  ],
  [
    "LP-1175-IDN",
    "Yes",
    "Kedeputian Bidang Infrastruktur Riset dan Inovasi \x{2013} Direktorat Pengelolaan Laboratorium, Fasilitas Riset, dan Kawasan Sains - Laboratorium Pengujian Teknologi Lingkungan - BRIN",
    "Gedung Geostech No. 820, Kawasan Puspiptek, Serpong, Tangerang",
    "(021) 75791377",
    "Air limbah, air danau, air sungai dan air sumur, minyak trafo",
    "20 Februari 2027",
    "",
  ],
  [
    "LP-1176-IDN",
    "Yes",
    "Loka Penelitian Kambing Potong",
    "Sei Putih, PO BOX 1, Galang, 20585, Kab. Deli Serdang, Sumatera Utara",
    "(061) 7980270",
    "Hijauan, pakan ternak dan bahan pakan ternak",
    "20 Februari 2027",
    "",
  ],
  [
    "LP-1177-IDN",
    "Yes",
    "UPTD Laboratorium Lingkungan Dinas Lingkungan Hidup Kabupaten Lahat",
    "Jl. Bhayangkara No. 8, Bandar Jaya, Kab. Lahat, Sumatera Selatan",
    "(0731) 321523",
    "Air sungai, air sumur, air limbah",
    "20 Februari 2027",
    "",
  ],
  [
    "LP-1178-IDN",
    "Yes",
    "Laboratorium Pengujian Material Konstruksi Dinas Pekerjaan Umum dan Penataan Ruang Kabupaten Badung (multilokasi)",
    "Jl. Raya Sempidi No.43, Sempidi, Mengwi - Kab. Badung, Bali (kantor pusat) Jl. Kebo iwa no.39 Ubung Kaja, kec. Denpasar Utara, Denpasar, Bali (Lokasi Laboratorium)",
    "(0361) 9009406",
    "Beton, Aspal campuran, aspal, agregat kasar dan halus, Tanah",
    "20 Februari 2027",
    "",
  ],
  [
    "LP-1179-IDN",
    "Yes",
    "Balai Pengujian dan Identifikasi Barang Tipe B Surabaya (Multilokasi)",
    "Lokasi 1: Jl. Perak Timur No. 498, Surabaya, Jawa Timur Lokasi 2 : KPPBC TMP Tanjung Emas, Jl. Yos Sudarso No.17, Semarang Barat, Kota Semarang, Jawa Tengah Lokasi 3: Jl. Raya Pelabuhan Pantoloan, Kec. Trawaeli, Kota Palu, Sulawesi Tengah",
    "(031) 3286492",
    "Lokasi 1: Polimer, Crude Palm Oil (CPO), minyak goreng sawit, minyak kelapa, garam, baja, Nikel",
    "20 Februari 2027",
    "",
  ],
  ["LP-1180-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  [
    "LP-1181-IDN",
    "Yes",
    "PT Global Environment Laboratory",
    "Jl. Poros Samarinda-Bontang Gg. 16 No. 77, RT 006, Kel. Lempake, Kec. Samarinda Utara, Kota Samarinda, Kalimantan Timur",
    "(0541) 4110850",
    "Air untuk keperluan higiene dan sanitasi, air sungai, air sumur, air limbah, udara ambien, kebisingan, getaran, lingkungan kerja, udara emisi sumber tidak bergerak, emisi gas buang kendaraan bermotor tipe M, N, O dan emisi gas buang kendaraan bermotor tipe L",
    "20 Februari 2027",
    "",
  ],
  [
    "LP-1182-IDN",
    "Yes",
    "PT Adei Plantations &amp; Industry - Mandau Central Laboratory",
    "PT Adei Plantations &amp; Industry - Mandau Central Laboratory",
    "085376787829",
    "Pupuk, minyak kelapa sawit, air bersih/air untuk keperluan higiene dan sanitasi, air limbah, air sumur, air sungai, air waduk",
    "20 Februari 2027",
    "",
  ],
  ["LP-1183-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  [
    "LP-1184-IDN",
    "Yes",
    "PT Sibaweh Laboratorium Indonesia",
    "Jl. Moch. Toha No. 51 C, Kel. Pungkur, Kec. Regol, Bandung, Jawa Barat",
    "(022) 42822868",
    "Produk olahan daging, produk olahan ikan, produk olahan",
    "20 Maret 2027",
    "",
  ],
  ["LP-1185-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  [
    "LP-1186-IDN",
    "Yes",
    "PT Bintang Inspeksindo Indonesia",
    "Jl. Legok Raya Km.6 No. 77, Kelapa Dua, Tangerang, Banten",
    "(021) 22227029",
    "Produk baja, baja tahan karat beserta paduannya dari berbagai tipe dan aplikasi termasuk sambungan las, baja paduan rendah, baja tahan karat",
    "20 Maret 2027",
    "",
  ],
  [
    "LP-1187-IDN",
    "Yes",
    "Bidang Laboratorium Forensik (BIDLABFOR) Polda Jawa Tengah",
    "Komplek Akpol, Jl. Sultan Agung, Candi Baru, Semarang, Jawa Tengah",
    "(024) 8312742",
    "Blangko pada Kertas, Cap Stempel pada Kertas, Tanda Tangan dan Paraf pada Kertas, Tulisan Cetak Kertas, Tulisan tangan pada Kertas, Fisik Dokumen pada Kertas, senjata api, peluru, selongsong dan anak peluru, TKP, blok nomor mesin, blok nomor angka, minuman keras, urin dan darah, mobile device (smartphone/futurephone dan SIM CARD), raw material (serbuk kristal, cong/cangklong, aluminium foil, pipet kaca, bungkus plastik, tablet, serbuk)",
    "20 Maret 2027",
    "",
  ],
  ["LP-1188-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  [
    "LP-1189-IDN",
    "Yes",
    "UPT Laboratorium Kesehatan Ikan dan Lingkungan, Dinas Kelautan dan Perikanan Provinsi Jawa Timur",
    "Ds. Sidepan, Kec. Winongan, Kab. Pasuruan, Jawa Timur (Kantor) Jl. Perikanan No. 746, Kalianyar, Bangil, Kab. Pasuruan, Jawa Timur (Laboratorium)",
    "(0343) 741654",
    "Ikan air payau (bandeng, nila), ikan air laut (kerapu, kakap, bandeng), ikan air tawar (patin, mas lele, koi, gurame, nila), udang air payau (vannamei, windu), air payau, air laut,dan air tawar, udang windu, udang vannamei, ikan mas, ikan koi",
    "1 April 2027",
    "",
  ],
  [
    "LP-1190-IDN",
    "Yes",
    "Balai Produksi Induk Udang Unggul dan Kekerangan Karangasem",
    "Desa Bugbug, Kab.Karangasem, Bali",
    "(0363) 2787803",
    "Udang",
    "1 April 2027",
    "",
  ],
  [
    "LP-1191-IDN",
    "Yes",
    "Balai Perikanan dan Budidaya Laut Lombok",
    "P.O.BOX 1 Sekotong Barat, Dsn. Gili Genting, Desa Sekotong Barat, Kab. Lombok Barat, Nusa Tenggara Barat",
    "081339322666",
    "Ikan laut (kerapu, bawal, kakap), udang (vanamei, windu), air laut",
    "1 April 2027",
    "",
  ],
  [
    "LP-1192-IDN",
    "Yes",
    "UPT Pengelolaan dan Pelayanan Perumahan Permukiman, Dinas Perumahan Rakyat, Kawasan Permukiman dan Cipta Karya Provinsi Jawa Timur",
    "Jl. Gayung Kebonsari No.169 Surabaya, Jawa Timur",
    "(031) 8292270",
    "agregat halus, agregat kasar",
    "17 April 2027",
    "",
  ],
  [
    "LP-1193-IDN",
    "Yes",
    "UPT Laboratorium Lingkungan Dinas Lingkungan Hidup Kabupaten Rokan Hulu",
    "Komplek Perkantoran Bina Praja Kabupaten Rokan Hulu, Pasir Pangaraian, Kab. Rokan Hulu, Riau",
    "(0762) 91849",
    "Air sungai, air danau, air bersih, air limbah",
    "17 April 2027",
    "",
  ],
  [
    "LP-1194-IDN",
    "Yes",
    "UPTD Laboratorium Lingkungan Dinas Lingkungan Hidup Kabupaten Muaro Jambi",
    "Jl. Lintas Timur Sumatera, Komplek Perkantoran Bukit Cinto Kenang RT.21, Kel. Sengeti, Kec. Sekernan, Kab. Muaro Jambi, Jambi",
    "(0741) 590082",
    "Air sungai, air limbah",
    "17 April 2027",
    "",
  ],
  [
    "LP-1195-IDN",
    "Yes",
    "Balai Veteriner Kelas B Boyolali",
    "Lokasi 1: Jl. Cendana No. 11, Boyolali, Jawa Tengah Lokasi 2: Jl. Ahmad Yani No. 54A, Banyumas, Jawa Tengah Lokasi 3: Jl. Balekambang Lor No. 3, Manahan, Banjarsari, Surakarta Lokasi 4: Jl. Diponegoro No. 1, Lingkup Eks. Bakorwil, Kota Magelang",
    "(0276) 321036",
    "Produk asal hewan (daging, susu, telur dan olahannya) air bersih untuk pengolahan pangan, sarang walet, kulit, serum sapi, kerbau, kambing/domba, serum dan darah ayam, bebek, feses sapi, kerbau, kambing/domba",
    "17 April 2027",
    "",
  ],
  [
    "LP-1196-IDN",
    "Yes",
    "PT PJB UP Muara Karang",
    "Jl. Pluit Karang Ayu No. 1, Pluit, Penjaringan, Jakarta Utara, DKI Jakarta",
    "(021) 6692806",
    "Air proses, pelumas industri baru, pelumas mesin pompa dan turbin",
    "29 April 2027",
    "",
  ],
  [
    "LP-1197-IDN",
    "Yes",
    "Bidang Laboratorium Forensik (BIDLABFOR) Polda Sumatera Selatan",
    "Jl. Jend. Sudirman KM 4.5 MAPOLDA Sumsel, Palembang",
    "(0711) 318084",
    "Blangko, cap stempel, produk cetak/tulisan cetak, fisik dokumen, dokumen, tanda tangan dan paraf, tulisan tangan, uang kertas rupiah, senjata api standar organik, senjata api rakitan, peluru standar organik, selongsong peluru, anak peluru, sisa mesiu penembakan, bom ikan, bahan peledak, petasan, buccal swab, darah, sperma, handphone, simcard, abuarang sisa kebakaran, bong, cangklong, cairan dalam bong, pasta, kristal, daun/daun kering",
    "29 April 2027",
    "",
  ],
  [
    "LP-1198-IDN",
    "Yes",
    "UPT Perlindungan Tanaman Pangan dan Hortikultura, Dinas Pangan Tanaman Pangan dan Hortikultura Provinsi Riau - Laboratorium Pestisida",
    "Jl. Hang Tuah Ujung, No.71, Pekanbaru, Riau",
    "(0761) 34392",
    "Sayuran buah (cabe), sayuran daun (salada), beras, formulasi pestisida, agen pengendali hayati",
    "29 April 2027",
    "",
  ],
  [
    "LP-1199-IDN",
    "Yes",
    "Balai Pengawasan Ketenagakerjaan dan K3 Pulau Lombok",
    "Jl. Majapahit No. 70, Mataram, Nusa Tenggara Barat",
    "(0370) 636365",
    "Lingkungan kerja, getaran",
    "22 Mei 2027",
    "",
  ],
  ["LP-1200-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  [
    "LP-1201-IDN",
    "Yes",
    "Balai Besar Pengawas Obat dan Makanan di Mataram",
    "Jl. Catur Warga, Mataram, Nusa Tenggara Barat",
    "(0370) 621926",
    "Terapetik dan Napza (tablet, kapsul, sirup/suspensi, injeksi/infus, salep/tetes, suppositoria), psikotropika/narkotika (injeksi, serbuk/bahan baku),",
    "22 Mei 2027",
    "",
  ],
  [
    "LP-1202-IDN",
    "Yes",
    "PT Intibenua Perkasatama",
    "Jl. Datuk Laksamana Areal Pelabuhan Dumai, Riau",
    "(0765) 31142",
    "Crude Palm Oil (CPO), Crude Palm Kernel Oil, RBD Palm",
    "22 Mei 2027",
    "",
  ],
  [
    "LP-1203-IDN",
    "Yes",
    "UPT Laboratorium Lingkungan Dinas Lingkungan Hidup dan Kebersihan Kota Depok",
    "Jl. Merdeka Raya No. 45, Kel. Abadijaya, Kec. Sukmajaya, Kota Depok, Jawa Barat",
    "(021) 77820929",
    "Air sungai, air limbah",
    "22 Mei 2027",
    "",
  ],
  ["LP-1204-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  [
    "LP-1205-IDN",
    "Yes",
    "Balai Karantina Pertanian Kelas I Pekanbaru",
    "Jl. Ikhlas 2, Simpangtiga, Kec, Bukit Raya, Pekanbaru, Riau",
    "(0761) 22172",
    "Lalat buah, Serum darah ayam DOC (Day old chicken), Serum darah sapi, kambing, domba, specimen serangga, daun ubi kayu, Bungkil Kelapa Sawit, Biji Kedelai",
    "4 Juni 2027",
    "",
  ],
  [
    "LP-1206-IDN",
    "Yes",
    "Divisi Engineering Development Center, PT Astra Otoparts, Tbk",
    "Kawasan Industri Greenland International Center, Jl. Anggrek Raya No. 25, Kota Deltamas, CIkarang Pusat, Kab. Bekasi, Jawa Barat",
    "(021) 2215792021",
    "Fe dan Al based metal, plastik",
    "4 Juni 2027",
    "",
  ],
  ["LP-1207-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  ["LP-1208-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  [
    "LP-1209-IDN",
    "Yes",
    "PT Pembangkitan Jawa Bali Unit Pembangkitan Muara Tawar",
    "Jl. PLTGU Muara Tawar No. 1, Desa Segarajaya, Kec. Tarumajaya, Kab. Bekasi, Jawa Barat",
    "(021) 88990052",
    "Gas alam",
    "27 Juni 2027",
    "",
  ],
  [
    "LP-1210-IDN",
    "Yes",
    "PT East Jakarta Industrial Park (EJIP)",
    "Kawasan Industri EJIP, Jl. Citanduy 7, Plot WATEC, Cikarang Selatan, Kab. Bekasi, Jawa Barat",
    "(021) 8971118",
    "Air sungai, air limbah, udara ambien, kebisingan lingkungan, emisi sumber tidak bergerak",
    "27 Juni 2027",
    "",
  ],
  ["LP-1211-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  [
    "LP-1212-IDN",
    "Yes",
    "UPTD Laboratorium Kesehatan Daerah Provinsi Banten",
    "Jl. Syech Nawawi Al-Bantani, Banjar Agung, Kab. Serang, Banten",
    "(0254) 7913025",
    "Air minum, air untuk keperluan higiene dan sanitasi, air minum dalam kemasan, swab nasofaring dan orofaring",
    "27 Juni 2027",
    "",
  ],
  [
    "LP-1213-IDN",
    "Yes",
    "Balai Besar Pelaksanaan Jalan Nasional Jawa Timur \x{2013} Bali - Laboratorium Teknik Jalan dan Jembatan Wilayah Jawa Timur",
    "Jl. Raya Waru No.20, Kab. Sidoarjo, Jawa Timur",
    "(031) 8540198",
    "Agregat halus, agregat kasar, aspal",
    "27 Juni 2027",
    "",
  ],
  ["LP-1214-IDN", "No", "", "", "", "", "", "Nomor Akreditasi dicabut"],
  ["LP-1215-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  [
    "LP-909-IDN",
    "Yes",
    "PT Intimas Surya",
    "Jl. Ikan Tuna Raya IV, Pelabuhan Benoa, Bali",
    "(0361) 724246",
    "Produk perikanan, fresh dan forozen produk perikanan",
    "31/03/2024",
    "",
  ],
  [
    "LP-911-IDN",
    "Yes",
    "UPT Laboratorium Badan Lingkungan Hidup Kabupaten Sumenep",
    "Jl. KH. Mansyur No 25, Sumenep, Jawa Timur",
    "(0328) 662779",
    "Air, Permukaan, Air Bersih, Air limbah, Udara Ambien",
    "23/04/2024",
    "",
  ],
  [
    "LP-912-IDN",
    "Yes",
    "Laboratorium Pengujian Terpadu Universitas Pembangunan Nasional \"Veteran\" Jawa Timur",
    "Jl. Raya Rungkut Madya Gunung Anyar, Surabaya",
    "(031) 8708286",
    "Tanah, pupuk organik, daun, aneka tepung (serealia, kacang-kacangan dan umbi-umbian), limbah cair",
    "08/06/2024",
    "",
  ],
  ["LP-913-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  [
    "LP-914-IDN",
    "Yes",
    "Laboratorium Uji Departemen Teknik Sipil - Universitas Indonesia",
    "Fakultas Teknik Universitas Indonesia Kampus Baru UI Depok 16424",
    "(021) 7866594",
    "Beton, Baja Tulangan polos, Baja tulangan beton, ulir, Tanah, Mortar, Agregat halus, Agregat kasar, Air bersih",
    "21/08/2024",
    "",
  ],
  [
    "LP-915-IDN",
    "No",
    "",
    "",
    "",
    "",
    "",
    "Nomor digabung dengan LP-018-IDN</strong>",
  ],
  [
    "LP-919-IDN",
    "Yes",
    "Balai Riset Pemuliaan Ikan Sukamandi",
    "Jl. Raya 2 Sukamandi, Kecamatan Patokbeusi, Kabupaten Subang - Jawa Barat 41263",
    "(0260) 520500",
    "Jaringan ikan, air permukaan",
    "04/08/2024",
    "",
  ],
  [
    "LP-920-IDN",
    "Yes",
    "Pusat Kedokteran dan Kesehatan POLRI - Laboratorium DNA",
    "Jl. Cipinang Baru Raya No. 3B Jakarta Timur 13240",
    "(021) 29834510",
    "Darah, epitel, sperma, akar rambut, tulang, gigi dan materi biologis barang bukti",
    "18/11/2024",
    "",
  ],
  [
    "LP-921-IDN",
    "Yes",
    "UPT Laboratorium Lingkungan Dinas Lingkungan Hidup Kota Padang",
    "Jl. By Pass Km 15, Palarik, Air Pacah, Koto Tangah, Kota Padang",
    "08126748536",
    "Air permukaan (air sungai, air danau, air kolam, air drainase), air limbah, air bersih (air sumur, air PDAM), air minum isi ulang",
    "01/09/2024",
    "",
  ],
  [
    "LP-923-IDN",
    "Yes",
    "Balai Besar Pelaksanaan Jalan Nasional VIII - Laboratorium Teknik Jalan dan Jembatan Wilayah Provinsi Bali",
    "Jl. Raya Denpasar - Gilimanuk KM 24+800, Banjar Samsaman, Desa Kukuh, Kec. Kerambitan, Kab. Tabanan, Bali",
    "(0361) 8311508",
    "Aspal Minyak, agregat kasar, agregat halus, Tanah, Silinder beton, Kubus mortar",
    "01/09/2024",
    "",
  ],
  [
    "LP-924-IDN",
    "Yes",
    "Laboratorium Pembinaan dan Pengujian Mutu Hasil Perikanan Ternate",
    "Jl. Pasar Inpres Bastiong, Kompleks Pelabuhan Perikanan Nusantara, Ternate",
    "(0921) 3122749",
    "Ikan beku, ikan segar, Ikan olahan (tuna, Cakalang, layang, kembung)",
    "24/09/2024",
    "",
  ],
  [
    "LP-925-IDN",
    "Yes",
    "UPT Pembibitan Ternak dan Pakan Ternak, DInas Peternakan dan Kesehatan Hewan Provinsi Kalimantan Barat",
    "Jl. Adisucipto No. 48, Pontianak 78124",
    "(0561) 584785",
    "Pakan, bahan pakan, hijauan",
    "17/12/2024",
    "",
  ],
  [
    "LP-927-IDN",
    "Yes",
    "PT Geoservices Padang",
    "Jl. By Pass Km 25, Anak Air, Padang, Sumatera Barat",
    "(0751) 484759",
    "Batubara",
    "17/12/2024",
    "",
  ],
  [
    "LP-928-IDN",
    "Yes",
    "PT Surveyor Indonesia Cabang Palembang (Multilokasi)",
    "Kantor Pusat: Jl. Soekarno Hatta No. 3040 Karya Baru, Kec. Alang-Alang Lebar, Palembang Lokasi 1 : Jl. RB. Siagaan No. 43-44, Kel. Pasir Putih, Kec. Jambi Selatan, Kota Jambi Lokasi 2; Jl. Soekarno Hatta No. 227, Pangkal Pinang Lokasi 3: Jl. Raya Bakauheni Km. 15, Tarahan, Panjang, Bandar Lampung",
    "(0741) 3601599 ; (0541) 250111",
    "Batubara, logam timah",
    "28/07/2024",
    "",
  ],
  [
    "LP-929-IDN",
    "Yes",
    "PT Citra Tubindo, Tbk - Metallurgical Laboratory",
    "Jl. Hang Kesturi, Km. 4, Kawasan Industri Terpadu Kabil, Kel Batu Besar, Kec Nongsa, Bata,",
    "(0778) 711888",
    "Steel Tubular Product",
    "23/04/2024",
    "",
  ],
  ["LP-930-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  [
    "LP-932-IDN",
    "Yes",
    "PT Eurofins Modern Testing Services CPT Indonesia",
    "City Resort Residence Rukan Malibu Blok H No. 25-27, Cengkareng, Jakarta Barat, DKI Jakarta",
    "(021) 56944971",
    "Tekstil &amp; Toys, Leather, paint &amp; surface coating, children's metal jewelry, children metal products, metal products, non-metal products, material plastik, mainan, child care products, polimer, free standing clothing storage units",
    "15/09/2024",
    "",
  ],
  [
    "LP-933-IDN",
    "No",
    "",
    "",
    "",
    "",
    "",
    "Nomor digabung dengan LP-751-IDN</strong>",
  ],
  ["LP-935-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  [
    "LP-936-IDN",
    "Yes",
    "Balai Penerapan Standar Instrumen Pertanian Jawa Tengah",
    "Jl. BPTP No. 40, Sidomulyo, Ungaran, Kabupaten Semarang 50501",
    "(024) 6924965",
    "Tanah, pupuk NPK, pupuk organik padat, pupuk organik cair, pakan ternak dan bahan dasar pakan",
    "03/10/2024",
    "",
  ],
  [
    "LP-937-IDN",
    "Yes",
    "PT Pertamina Gas Kalimantan Area",
    "Jl. Ir. James Simanjuntak No.1, Kawasan Kompleks Industri PT Pupuk Kaltim, Bontang",
    "(0548) 41830",
    "Gas alam (natural gas)",
    "15/09/2024",
    "",
  ],
  ["LP-938-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  ["LP-939-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  [
    "LP-941-IDN",
    "Yes",
    "Laboratorium Terpadu Fakultas Kedokteran Universitas Indonesia",
    "Jl. Salemba Raya No. 6, Jakarta Pusat",
    "(021) 3101733",
    "Serum, plasma dan cairan folikel (manusia), darah, jaringan, sel kultur, RNA, complementary DNA (cDNA), darah perifer/darah tepi dan darah tali pusat",
    "20/10/2024",
    "",
  ],
  [
    "LP-944-IDN",
    "Yes",
    "Balai Penelitian dan Pengembangan Rawa",
    "Jl. Gatot Subroto No. 6 RT. 34, Banjarmasin",
    "(0511) 3256623",
    "Air rawa, air sungai, limbah, tanah",
    "20/10/2024",
    "",
  ],
  [
    "LP-945-IDN",
    "Yes",
    "PT Surveyor Indonesia Cabang Semarang",
    "Lokasi 1: Jl. Peterongan Timur No 11B RT.005/RW.007 Kel. Peterongan Kec. Semarang Selatan, Semarang, Jawa Tengah Lokasi 2: PT Kaltim Prima Coal, Gedung P61, Tanjungbara, Sangatta, Kutai Timur Lokasi 3: Jl. Ahmad Yani, KM. 122, Asam-asam Jorong, Tanah Laut, Kalimantan Selatan Lokasi 4: Ruko Kendari Indah, Jl. R. Suprapto No. 222, Blok A3-R3, Punggolaka, Kendari, Sulawesi Tenggara Lokasi 5: Kawasan Industri Sentul, Jl. Cahaya Raya Kavling H10 No. 5-6, Leuwinutug, Citeureup, Bogor, Jawa Barat Lokasi 6: Jl. Cendana No, 105A, Teluk Lerong Ulu, Kec. Sungai Kunjang, Samarinda, Kalimantan Timur",
    "Lokasi 1: (024) 76530125 Lokasi 3: (0511) 5926342 Lokasi 4: (0410) 3131435 Lokasi 5: (021) 50871249 Lokasi 6: (0541) 6522009",
    "Batubara (lokasi 1, 2, 3, 5 dan 6)",
    "17/11/2024",
    "",
  ],
  ["LP-946-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  ["LP-947-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  [
    "LP-948-IDN",
    "Yes",
    "Balai Karantina Pertanian Kelas II Kendari",
    "Jl. Prof. M. Yamin, Puuwatu 93114, Kendari",
    "(0401) 3123986",
    "Serum unggas, serum sapi, serum kambing, serum kerbau, kopra, biji kedelai, ulas darah hewan",
    "17/11/2024",
    "",
  ],
  [
    "LP-949-IDN",
    "Yes",
    "Deputi Bidang Infrastruktur Riset dan Inovasi - Direktorat Pengelolaan Laboratorium, Fasilitas Riset, dan Kawasan Sains Teknologi - LP Teknologi Bahan Bakar Nuklir - BRIN",
    "Gedung 20, Kawasan Puspiptek, Serpong, Tangerang Selatan",
    "(021) 7560915",
    "Logam, padatan logam, keramik, komposit, padatan dan larutan Uranium, padatan pejal, padatan serbuk, logam dan paduannya (Ferrous dan Non Ferrous), logam (SS), logam paduan (Zirkaloy), paduan logam yang mengandung bahan nuklir, larutan bahan bakar, padatan (lingkungan dan bahan nuklir)",
    "17/11/2024",
    "",
  ],
  [
    "LP-950-IDN",
    "Yes",
    "Balai Karantina Pertanian Kelas I Bandar Lampung",
    "Jl. Soekarno Hatta Km. 20, Way Laga, Bandar Lampung",
    "(0721) 31305",
    "Serum sapi, kedelai biji, soybean meal, palm kernel expeller, corn gluten meal, soybean meal, distiller dried grain, wheat flour, coklat biji, kopi biji, jagung biji, beras pecah, beras ketan, pinang biji, lada biji, J wheat flour",
    "16/12/2024",
    "",
  ],
  [
    "LP-951-IDN",
    "Yes",
    "PT Krakatau Steel (Persero) Tbk - Laboratorium Uji Lingkungan",
    "Jl. Akasia, Komplek Pbarik PT Krakatau Steel (Persero), Tbk, Cilegon, Banten",
    "(0254) 371310; 371826",
    "Air limbah, lingkungan kerja",
    "16/12/2024",
    "",
  ],
  ["LP-952-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  [
    "LP-953-IDN",
    "Yes",
    "Stasiun Karantina Pertanian Kelas I Banda Aceh",
    "Jl. T. Nyak Arief Kompleks Peurada, Banda Aceh",
    "(0651) 7552454",
    "Serum unggas (ayam), beras, serum (sapi/kambing), kopi biji",
    "16/12/2024",
    "",
  ],
  [
    "LP-954-IDN",
    "Yes",
    "UPT Laboratorium Lingkungan Dinas Lingkungan Hidup Kabupaten Belitung",
    "Jl. Anwar No. 2, Tanjung Pandan, Kab. Belitung, Bangka Belitung",
    "(0719) 25243",
    "Air sungai, air muara, air untuk keperluan hygiene dan sanitasi, air limbah, udara lingkungan kerja, udara ambien, udara emisi sumber tidak bergerak",
    "16/12/2024",
    "",
  ],
  [
    "LP-955-IDN",
    "Yes",
    "PT Anindya Wiraputra Konsult Bara Tabang",
    "Desa Senyiur, Kec. Muara Ancalong, Kab. Kutai Timur",
    "085241599448",
    "Batubara",
    "16/12/2024",
    "",
  ],
  [
    "LP-956-IDN",
    "Yes",
    "UPT Laboratorium Lingkungan Dinas Lingkungan Hidup dan Perhubungan Kabupaten Hulu Sungai Tengah",
    "Jl. Perintis Kemerdekaan Batali Raya, Desa Benawa Tengah, Kec. Barabai, Kab. Hulu Sungai Tengah 71351",
    "(0517) 44239",
    "Air permukaan ,air limbah, air Lindi",
    "29/12/2024",
    "",
  ],
  [
    "LP-957-IDN",
    "Yes",
    "Balai Riset Perikanan Perairan Umum dan Penyuluhan Perikanan (Status dibekukan sementara per 3 April 2023)",
    "Jl. Gubernur H. A. Bastari No. 08, Jakabaring, Palembang",
    "(0711) 5649598",
    "Air permukaan (air sungai, air danau, air waduk, air estuari, air rawa), Limbah cair",
    "28/12/2024",
    "",
  ],
  [
    "LP-958-IDN",
    "Yes",
    "PT Krakatau Posco - Laboratorium Uji Mekanik dan Kimia",
    "Jl. Afrika No. 2, Kawasan Industri Krakatau, Cilegon, Banten 42443",
    "(0254) 369700",
    "Baja, Baja Karbon, Baja Paduan Rendah, Besi Tuang, Bijih Besi, Batu Kapur, Ari Limbah, Air Pasokan, Batubara",
    "28/12/2024",
    "",
  ],
  [
    "LP-960-IDN",
    "Yes",
    "Unit Pelaksana Teknis Daerah (UPTD) Laboratorium Lingkungan Dinas Lingkungan Hidup Kabupaten Cilacap",
    "Jl. Bromo Timur No. 12, Cilacap Selatan, Cilacap",
    "(0282) 521184",
    "Air sungai, air danau, air waduk, air limbah, air tanah, Air permukaan (air sungai)",
    "29/12/2024",
    "",
  ],
  [
    "LP-961-IDN",
    "Yes",
    "PT Smart Tbk (Global R&amp;D)",
    "Komplek Pergudangan Marunda Center Blok D No. 1, Tarumajaya, Bekasi 17211",
    "(021) 88991121",
    "Crude and refined edible oil and fat, cooking oil, shortening/specially fat, margarine/butter, CPO, refined edible oil and fat, soybean oil, olive oil, cocoa butter, water, bread/cake/DBPO, RBDPO",
    "29/12/2024",
    "",
  ],
  ["LP-963-IDN", "No", "", "", "", "", "", "Nomor Akreditasi dicabut"],
  [
    "LP-964-IDN",
    "Yes",
    "Laboratorium Uji Kimia dan Mekanik, PT Krakatau Steel (Persero) Tbk.",
    "Jl. Industri No. 5, Kel. Ramaanuju, Kec. Purwakarta, Cilegon",
    "(0254) 371274",
    "Baja lembaran dan gulungan canai dingin, Baja lembaran dan gulungan canai panas, kawat baja, baja, aluminium base (aluminium ingot, aluminium pellet, aluminium short dan aluminium wire), minyak nabati (minyak setengah jadi pelapis permukaan strip), pelumas (pelumas gerabox, pelumas mesin dan pelumas hodrolik)",
    "19/01/2025",
    "",
  ],
  [
    "LP-966-IDN",
    "Yes",
    "PT Mutuagung Lestari Pangkalan Bun",
    "Jl. Topar RT. 002, Desa Pasir Panjang, Pangkalan Bun",
    "(021) 8740202",
    "Badan air penerima (BAP), Air Sungai, Air Danau, Air Waduk, air limbah, air bersih, Air Untuk Keperluan HIgiene dan Sanitasi, Air Tanah (sumur pantau), udara ambient, emisi sumber tidak bergerak, Kebisingan",
    "18/01/2025",
    "",
  ],
  [
    "LP-967-IDN",
    "Yes",
    "PT Farmalab Indoutama",
    "Jl. Delima II No. 4 RT 009 RW 003, Kel. Malaka Sari, Kec. Duren Sawit, Jakarta Timur",
    "(021) 86617112",
    "Plasma darah yang mengandung kapropril, plasma darah yang mengandung sefiksim, Plasma darah manusia",
    "18/01/2025",
    "",
  ],
  [
    "LP-968-IDN",
    "Yes",
    "Balai Karantina Pertanian Kelas II Yogyakarta",
    "Jl. Laksda Adisucipto Km 8, Maguwoharjo, Sleman, Yogyakarta",
    "(0274) 488856",
    "Daging dan olahannya (bakso, nugget, ayam olahan, bebek olahan), susu pasteurisasi, lalat buah, bagian tanaman bergejala (akar, batang, daun, bunga, dan buah : tomat, cabe, terong) serum darah unggas (ayam), serum darah (anjing &amp; kucing)",
    "18/1/2025",
    "",
  ],
  ["LP-969-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  [
    "LP-971-IDN",
    "Yes",
    "PT Nestle Indonesia - Karawang Factory Quality Assurance Department",
    "Kawasan Industri Surya Cipta, Jl. Surya Pratama Kavling I-37 I-38 I-39, Desa Kutanegara, Kec. Ciampel, Kab. Karawang, Jawa Barat 41363",
    "(0267) 8630353",
    "MP ASI bubuk instan, minuman serbuk coklat dengan susu, minuman serbuk coklat, formula pertumbuhan, santan bubuk",
    "16/2/2025",
    "",
  ],
  [
    "LP-972-IDN",
    "Yes",
    "UPTD Laboratorium Lingkungan Hidup Dinas Lingkungan Hidup Kabupaten Tuban",
    "Jl. Veteran No. 27, Kab. Tuban, Jawa Timur 62319",
    "(0356) 321026",
    "Mata air, air sungai, air waduk, air untuk keperluan higiene dan sanitasi, air limbah",
    "16/2/2025",
    "",
  ],
  ["LP-973-IDN", "No", "", "", "", "", "", "Nomor Akreditasi dicabut"],
  [
    "LP-974-IDN",
    "Yes",
    "Departemen Agronomi dan Holtikultura, Faperta - Institut Pertanian Bogor (IPB)",
    "Jl. Meranti, Wing 9/level 4, Kampus IPB Darmaga, Kab. Bogor",
    "(0251) 8629353",
    "Pupuk urea, pupuk SP36, pupuk KCl, pupuk NPK padat, pupuk anorganik hara makro campuran, tanah, logam pada tanaman",
    "16/2/2025",
    "",
  ],
  [
    "LP-975-IDN",
    "Yes",
    "PT TCRC Inspectindo",
    "Gatot Subroto IV, Jl. Cengkeh No. 49, Kota Banjarmasin, Kalimantan Selatan",
    "(0511) 3274065",
    "Batubara",
    "16/2/2025",
    "",
  ],
  [
    "LP-976-IDN",
    "Yes",
    "UPTD Laboratorium Dinas Lingkungan Hidup Kabupaten Banyuwangi",
    "Jl. KH. Agus Salim No. 107, Banyuwangi, Jawa Timur",
    "(0333) 428833",
    "Air limbah, air sungai, air sumur, air danau, air muara, air rawa, air akuifer, air situ, air mata air, air waduk, air tanah, air untuk keperluan higiene, air kolam renang, air solus per aqua, air pemandian umum, air minum, air laut",
    "16/2/2025",
    "",
  ],
  ["LP-977-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  [
    "LP-978-IDN",
    "Yes",
    "PT Mutuagung Lestari Pekanbaru",
    "Jl. Arifin Ahmad No. 109B, Kel. Sidomulyo Timur, kec. Marpoyan Damaai, Pekanbaru - Riau",
    "(0761) 565420",
    "Air sungai,air tanah (sumur pantau), air limbah, air untuk keperluan higiene sanitasi, air minum, udara ambien, udara emisi sumber tak bergerak, Lingkungan kerja",
    "19/4/2025",
    "",
  ],
  ["LP-979-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  [
    "LP-980-IDN",
    "Yes",
    "Balai Karantina Pertanian Kelas II Pangkalpinang",
    "Jl. Yos Sudarso No. 133, Pangkalpinang, Kepulauan Bangka Belitung",
    "(0717) 434799",
    "Serum (sapi, kerbau, kambing), bahan asal hewan (daging beku, daging segar, sarang burung walet), serum darah (sapi, kerbau), beras, dedak, terigu, tapioka, kedelai, jagung biji, kopra, cangkang sawit, bungkil sawit, nanas, bijikedelai, pisang kepok",
    "15/3/2025",
    "",
  ],
  [
    "LP-981-IDN",
    "Yes",
    "PT Dirgantara Indonesia - Quality Laboratory Test &amp; Metrology - Unit Jaminan Mutu",
    "Jl. Pajajaran No. 154, Bandung",
    "(022) 6054630",
    "Aluminium alloys and steel alloys, non metal (carbon), lapisan pada metal",
    "15/3/2025",
    "",
  ],
  [
    "LP-982-IDN",
    "Yes",
    "Balai Penerapan Standar Instrumen Pertanian Jawa Barat",
    "Jl. Kayu Ambon No. 80, Lembang, Bandung, Jawa Barat",
    "(022) 2786238",
    "Benih tanaman pangan (padi, kedelai), beras",
    "15/3/2025",
    "",
  ],
  [
    "LP-983-IDN",
    "Yes",
    "Balai Pelaksanaan Jalan Nasional III",
    "Jl. Jati No. 109, Padang",
    "(0751) 8952360",
    "Agregat, tanah, beton, aspal",
    "15/3/2025",
    "",
  ],
  [
    "LP-984-IDN",
    "Yes",
    "PT Indonesia Power Unit Pembangkitan Suralaya",
    "Komplek PLTU Suralaya, Merak, Cilegon",
    "(0254) 571230; 571240",
    "Batubara",
    "15/3/2025",
    "",
  ],
  [
    "LP-985-IDN",
    "Yes",
    "UPT Laboratorium Kesehatan Kota Mojokerto",
    "Jl. HOS Cokroaminoto No. 58, Mojokerto, Jawa Timur",
    "(0321) 5282752",
    "Air bersih, air minum, air sungai, air limbah, air badan air, Udara ruang, usap/swab (alat makan, alat minum, alat masak, linen, alkes, AC, lantai, dinding)",
    "19/4/2025",
    "",
  ],
  ["LP-986-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  [
    "LP-987-IDN",
    "Yes",
    "Balai Penyelidikan dan Pengembangan Teknologi Kebencanaan Geologi",
    "Jl. Cendana No. 15, Yogyakarta",
    "(0274) 514192",
    "Air tanah, air mata air, air kawah, air danau, batuan",
    "19/4/2025",
    "",
  ],
  ["LP-988-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  ["LP-989-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  [
    "LP-990-IDN",
    "Yes",
    "Balai Proteksi Tanaman Perkebunan (BPTP) Pontianak",
    "Jl. Budi Utomo No. 57, Siantan Hulu, Pontanak, Kalimantan Barat",
    "(0561) 882784",
    "Agen pengendali hayati (Metarhizium anisopliae, Beauveria bassiana, Trichoderma)",
    "19/4/2025",
    "",
  ],
  ["LP-992-IDN", "No", "", "", "", "", "", "Nomor Akreditasi dicabut"],
  ["LP-993-IDN", "No", "", "", "", "", "", "Nomor Akreditasi dicabut"],
  ["LP-994-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  [
    "LP-995-IDN",
    "Yes",
    "PT TJB Power Services",
    "PLTU Tanjung Jati B Unit 1 &amp; 2, Desa Tubanan, Kec. Kembang, Kab. Jepara 59453",
    "(0291) 771566",
    "Batubara",
    "19/4/2025",
    "",
  ],
  [
    "LP-997-IDN",
    "Yes",
    "UPTD Pelayanan dan Pengujian Veteriner Provinsi Banten",
    "Jl. Raya Cilegon Km. 4, Taktakan, Kota Serang",
    "(0254) 220165",
    "Serum (sapi, kerbau), , unggas) feses (sapi, kerbau, kambing, domba), daging, susu, telur dan produk olahannya, bakso, cloacal swab, tracheal swab",
    "19/4/2025",
    "",
  ],
  [
    "LP-998-IDN",
    "Yes",
    "Balai Pengujian Standar lnstrumen Tanaman Palma",
    "Jl. Raya Mapanget, Kotak Pos 1004, Manado",
    "(0431) 812430",
    "Tanaman, tanah",
    "19/4/2025",
    "",
  ],
  [
    "LP-999-IDN",
    "Yes",
    "Balai Laboratorium Kesehatan dan Pengujian Alat Kesehatan Jawa Tengah",
    "Jl. Soekarno Hatta No. 185, Semarang",
    "(024) 6710662",
    "Air untuk keperluan higiene dan sanitasi, air minum, air limbah, air sungai, air tanah, air danau",
    "28/4/2025",
    "",
  ],
  ["LP-1000-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  ["LP-1001-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  [
    "LP-1002-IDN",
    "Yes",
    "PT Tirtamas Jaya Sakti",
    "Villa Kebon Jeruk, Jl. Kebon Jeruk Raya Blok F2, Jakarta Barat",
    "(021) 53660863",
    "Kapsul lunak, sirup/suspnsi/emulsi, kapsul, tablet, serbuk",
    "17/5/2025",
    "",
  ],
  [
    "LP-1003-IDN",
    "Yes",
    "PT Jasindo Testing Services",
    "Jl. Kapten Sumarsono Komplek Graha Helvetia Blok G20, Medan, Sumatera Utara",
    "(061) 8442565",
    "Crude palm oil, RBD PO, RBD olein, dan RBD stearin",
    "17/5/2025",
    "",
  ],
  [
    "LP-1004-IDN",
    "Yes",
    "UPTD Laboratorium Lingkungan Dinas Lingkungan Hidup Kabupaten Magelang",
    "Jl. Letnan Tukiyat No.4 A, Kota Mungkid, Magelang",
    "(0293) 3301855",
    "Air permukaan (air sungai), air limbah",
    "17/5/2025",
    "",
  ],
  [
    "LP-1005-IDN",
    "Yes",
    "Unit Pelaksana Teknis Daerah Balai Pengujian dan Keamanan Pakan/Bahan Pakan Cikole Lembang",
    "Jl. Raya Tangkuban Perahu Km. 22, Desa Cikole Lembang, Kab. Bandung Barat, Jawa Barat",
    "(022) 2787172",
    "Pakan dan Bahan Pakan, Pakan ternak (ruminansia dan non ruminansia), Bahan pakan asal hewan dan tumbuhan, Hijauan pakan ternak",
    "17/5/2025",
    "",
  ],
  [
    "LP-1006-IDN",
    "Yes",
    "Balai Laboratorium Lingkungan Dinas Lingkungan Hidup dan Kehutanan Daerah Istimewa Yogyakarta",
    "Jl. Tentara Rakyat Mataram No. 53, Jetis, Yogyakarta",
    "(0274) 588518",
    "Air sungai, air waduk/telaga, air untuk keperluan higienis dan sanitasi, air limbah",
    "17/5/2025",
    "",
  ],
  ["LP-1007-IDN", "No", "", "", "", "", "", "Nomor Akreditasi dicabut"],
  [
    "LP-1008-IDN",
    "Yes",
    "PT Sucofindo (Persero) - Laboratorium SBU Mineral",
    "Jl. Raya Tol Arteri Cibitung 1, Cikarang Barat, Kabupaten Bekasi",
    "087762722518",
    "Manganase ore, bauxite ore, iron ore, nickel ore, cement clinker, silica sand, rocks, mineral dan batuan",
    "21/6/2025",
    "",
  ],
  ["LP-1009-IDN", "No", "", "", "", "", "", "Nomor Akreditasi dicabut"],
  [
    "LP-1010-IDN",
    "Yes",
    "Balai Pengamanan Fasilitas Kesehatan Medan",
    "Jl. KH. Wahid Hasyim No. 15, Medan",
    "(061) 4533162",
    "Pesawat sinat X Radiografi umum, Pesawat sinat X Radiografi gigi, TLD Badge, pesawat CT scan, pesawat sinar X flouroskopi, Pesawat Mammography",
    "21/6/2025",
    "",
  ],
  [
    "LP-1011-IDN",
    "Yes",
    "UPT Laboratorium Lingkungan Dinas Lingkungan Hidup Kabupaten Lebak",
    "Jl. Langlang Buana No. 2 Rangkasbitung, Kab. Lebak, Banten",
    "(0252) 5551777",
    "Air imbah, air minum, air untuk keperluan higiene sanitasi, air sungai, air sumur, air danau, udara ambien, kebisingan",
    "21/6/2025",
    "",
  ],
  [
    "LP-1012-IDN",
    "Yes",
    "UPT Laboratorium Kesehatan Kota Magelang",
    "Jl. Jeruk No. 1A, Kota Magelang",
    "(0293) 314587",
    "Air minum, air bersih (higiene sanitasi, kolam renang, solus per aqua, pemandian umum), air limbah, air kolam renang, Udara, Mikrobiologi (udara, lantai, dinding, alat makan, alat medis, linen), makanan siap saji (es cendol, nasi campur)",
    "21/6/2025",
    "",
  ],
  ["LP-1216-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  ["LP-1217-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  ["LP-1218-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  [
    "LP-1219-IDN",
    "Yes",
    "PT Kaldu Sari Nabati",
    "Jl. Raya Cicalengka-Majalaya Km 1.6, Desa Cikuya, Cicalengka, Kab. Bandung, Jawa Barat",
    "(022) 7947777",
    "Biskuit, makanan ringan esktrudat, pasta, soft cookies, cocoa powder, jagung, whey bubuk, coklat bubuk, tepung terigu",
    "17 Juli 2027",
    "",
  ],
  [
    "LP-1220-IDN",
    "Yes",
    "Stasiun Karantina Pertanian Kelas II Tanjung Balai Karimun",
    "Jl. Jend. Sudirman - Poros, Kab. Karimun, Kepulauan Riau",
    "(0777) 7366077",
    "Serum darah sapi, tepung terigu, tepung sagu, beras, jagung",
    "29 Juli 2027",
    "",
  ],
  [
    "LP-1221-IDN",
    "Yes",
    "PT Nestle Indonesia - Panjang Factory",
    "Jl. Raya Bakauheni Km. 13, Bandar Lampung, Lampung",
    "(0721) 31253",
    "Coffee mixes, Pure Soluble coffee, raw material -flavor, bumbu masak",
    "29 Juli 2027",
    "",
  ],
  [
    "LP-1222-IDN",
    "Yes",
    "Bidang Laboratorium Forensik (BIDLABFOR) Polda Sumatera Utara",
    "Jl. SM Raja Km. 10,5, Kawasan Mapoldasu, Medan, Sumatera Utara",
    "(061) 7942391",
    "Blangko, cap stempel, tulisan cetak, material dokumen, tanda tangan dan paraf, uang kertas palsu, peralatan pengujian MDMA (kristal, tablet, cairan, bong, pipet kaca, sedotan plastik bekas pakai, aluminium foil), pengujian cannabis (pohon, daun kering, ranting kering, biji kering, linting, linting sisa bakar), pengujian metamfetamin (tablet, serbuk),Bercak darah, buccal swab, bercak darah, bercak sperma, senjata api, peluru, anak peluru, selongsong peluru, HP, SIMCARD, respon tubuh manusia",
    "28 Agustus 2027",
    "",
  ],
  [
    "LP-1223-IDN",
    "Yes",
    "Stasiun Karantina Pertanian Kelas I Tanjung Balai Asahan",
    "Jl. Perintis Kemerdekaan KM. 9, Simpang Empat, Asahan, Sumatera Utara",
    "(0623) 533473",
    "Telur, pinang biji, biji kedelai, serum (sapi, domba, kambing)",
    "28 Agustus 2027",
    "",
  ],
  [
    "LP-1224-IDN",
    "Yes",
    "Balai Pengkajian Teknologi Pertanian Banten",
    "Jl. Raya Cipatayasa Km. 01, Ciruas, Serang",
    "(0254) 281055",
    "Padi, jagung, kedelai",
    "28 Agustus 2022",
    "",
  ],
  ["LP-1225-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  [
    "LP-1226-IDN",
    "Yes",
    "Laboratorium Penguji Balai Pengkajian Teknologi Pertanian Kalimantan Barat",
    "Jl. Budi Utomo No. 45, Kota Pontianak",
    "(0561) 882069",
    "Tanah",
    "28 Agustus 2022",
    "",
  ],
  [
    "LP-1227-IDN",
    "Yes",
    "UPT Laboratorium Lingkungan Dinas Lingkungan Hidup Kabupaten Serang",
    "Jl. Letnan Jidun No. 4, Kabupaten Serang Banten",
    "(0254) 220849",
    "Air limbah, air permukaan (air sungai, air danau), air untuk keperluan hygiene sanitasi",
    "28 Agustus 2027",
    "",
  ],
  ["LP-1228-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  [
    "LP-1229-IDN",
    "Yes",
    "PT Megalopolis Manunggal Industrial Development",
    "Jl. Kalimantan, Blok DD, Kawasan Industri MM 2100, Cikarang Barat, Bekasi, Jawa Barat",
    "(021) 8981001",
    "Air limbah",
    "28 Agustus 2027",
    "",
  ],
  [
    "LP-1230-IDN",
    "Yes",
    "PT Smart Tbk Unit Marunda",
    "Kawasan Industri dan Pergudangan Blok D No.1 Marunda Center, Tarumajaya, Kab. Bekasi, Jawa Barat",
    "(021) 889911146",
    "Raw material (CPO), Edible oil refined fractioned oil, edible oil refined hydrogenated oil, edible oil texturized oil, fatty acid",
    "28 Agustus 2027",
    "",
  ],
  [
    "LP-1231-IDN",
    "Yes",
    "UPT Laboratorium Lingkungan Dinas Lingkungan Hidup dan Kehutanan Provinsi Banten",
    "Jl. KH. Syech Nawawi Al-Bantani Palima, KP3B (Kawasan Pusat Pemerintahan Provinsi Banten), Kab. Serang, Banten",
    "(0254) 267093",
    "Air sungai, air danau, air sumur, air limbah, air minum, air bersih/air untuk keperluan higiene dan sanitasi, udara ambien, kebisingan lingkungan",
    "28 Agustus 2027",
    "",
  ],
  ["LP-1232-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  [
    "LP-1233-IDN",
    "Yes",
    "Balai Karantina Pertanian Kelas II Tarakan",
    "Jl. Mulawarman No. 3, RT 26, Tarakan Barat, Kota Tarakan, Kalimantan Utara",
    "(0551) 21528",
    "Serum darah sapi, preparat ulas darah sapi, daun kelapa, biji kedelai",
    "6 September 2027",
    "",
  ],
  [
    "LP-1234-IDN",
    "Yes",
    "Stasiun Karantina Pertanian Kelas I Merauke",
    "Jl. Peternakan Mopah Lama, Kelurahan Rimba Jaya, Distrik, Kab. Merauke, Jawa Barat",
    "(0971) 3331919",
    "Serangga gudang pada beras, serangga gudang pada kopra, serangga gudang pada biji jagung, kacang tanah, kacang hijau, dan beras, cendawan pada biji kedelai, serum darah sapi, serum darah ayam",
    "28 Agustus 2027",
    "",
  ],
  [
    "LP-1235-IDN",
    "Yes",
    "Stasiun Karantina Pertanian Kelas I Bandung",
    "Jl. Soekarno Hatta No. 725 C, Bandung, Jawa Barat",
    "(022) 7300014",
    "Ubi jalar, bahan asal hewan (daging sapi) dan hasil bahan asal hewan (produk daging: bakso sapi, smoke beef, daging bebek olahan/ungkap, daging sapi asap, sei sapi, sosis dan nugget)",
    "28 Agustus 2027",
    "",
  ],
  [
    "LP-1236-IDN",
    "Yes",
    "Balai Teknologi Air Minum Kementerian Pekerjaan Umum dan Perumahan Rakyat",
    "Jl. Chairil Anwar I No. 1, Kel. Margahayu, Kec. Bekasi Timur, Kota Bekasi, Jawa Barat",
    "(021) 8804242",
    "Air untuk keperluan higiene dan sanitasi, air minum, air limbah",
    "28 Agustus 2027",
    "",
  ],
  [
    "LP-1237-IDN",
    "Yes",
    "UPT Laboratorium Kesehatan Kerja Dinas Tenaga Kerja dan Transmigrasi, Provinsi Kalimantan Barat",
    "Jl. Achmad Yani No. 1, Pontianak, Kalimantan Barat",
    "(0561) 762036",
    "Lingkungan kerja, udara ambien",
    "28 Agustus 2027",
    "",
  ],
  [
    "LP-1238-IDN",
    "Yes",
    "Fakultas Perikanan dan Ilmu Kelautan Universitas Borneo Tarakan - Laboratorium Kualitas Air",
    "Jl. Amal Lama No. 1 Tarakan Timur, Kalimantan Utara",
    "081803662423",
    "Air limbah",
    "28 Agustus 2027",
    "",
  ],
  [
    "LP-1239-IDN",
    "Yes",
    "UPTD Laboratorium Lingkungan pada Dinas Lingkungan Hidup Daerah Kabupaten Asahan",
    "Jl. WR. Supratman No.13, Kisaran, Kec. Kota Kisaran Timur, Kab. Asahan, Sumatera Utara",
    "(0623) 41182",
    "Air sungai, air bersih untuk keperluan higiene dan sanitasi, air minum, air limbah",
    "28 Agustus 2027",
    "",
  ],
  [
    "LP-1240-IDN",
    "Yes",
    "UPTD Keselamatan dan Kesehatan Kerja Provinsi Sumatera Barat",
    "Jl. Khatib Sulaeman No. 25, Padang, Sumatera Barat",
    "(0751) 7054931",
    "Lingkungan kerja",
    "6 September 2027",
    "",
  ],
  [
    "LP-1241-IDN",
    "Yes",
    "Balai Karantina Pertanian Kelas II Gorontalo",
    "Jl. Achmad Nadjamuddin No. 21, Dulalowo, Gorontalo",
    "(0435) 821609/827653",
    "Serum darah sapi, serum atau darah unggas (ayam, bebek, burung), darah sapi, preparat apus darah sapi, serangga gudang pada biji jagung, beras, kopra, bungkil kopra, bungkil kelapa, kelapa",
    "6 September 2027",
    "",
  ],
  [
    "LP-1242-IDN",
    "Yes",
    "PT Intibenua Perkasatama Lubuk Gaung",
    "Jl.Raya Lubuk Gaung, Kelurahan Lubuk Gaung, Kecamatan Sungai Sembilan, Dumai, Riau",
    "08116042156",
    "Crude Palm Oil, Crude Palm Kernel Oil, RBD Palm Oil, RBD Palm Olein, RBD Palm Stearin &amp; Palm Middle Fraction, Palm Fatty Acid Destillate, Palm Kernel Fatty Acid Destillate, RBD Palm Kernel Oil, RBD Palm Kernel Stearine, Crude Palm Kernel Olein, Crude Palm Kernel Stearine, Palm Mid Fraction, Distilled Fatty Acid, Crude Glycerine",
    "6 September 2027",
    "",
  ],
  [
    "LP-1243-IDN",
    "Yes",
    "Laboratorium Pakan Dinas Peternakan dan Perikanan Kabupaten Blitar",
    "Jl. Cokroaminoto No. 22, Blitar, Jawa Timur",
    "(0342) 801136",
    "Pakan dan Bahan Pakan",
    "6 September 2027",
    "",
  ],
  ["LP-1244-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  [
    "LP-1245-IDN",
    "Yes",
    "PT Indonesia Power UJP PLTU Jawa Barat 2 Pelabuhan Ratu",
    "Jl. Raya Pelita Kp. Cipatuguran, Desa Jayanti, Kec Pelabuhan Ratu, Kab Sukabumi, Jawa Barat",
    "(0266) 435503",
    "Batubara",
    "6 September 2027",
    "",
  ],
  [
    "LP-1246-IDN",
    "Yes",
    "UPT Pelayanan Kesehatan Hewan, Kesehatan Masyarakat Veteriner dan Klinik Hewan Provinsi Kalimantan Barat",
    "Jl. Adisucipto No. 48, Pontianak 78124",
    "(0561) 584365",
    "Serum darah (ayam, babi, sapi, kerbau) Otak anjing, Produk hewan olahan (bakso, nugget, abon, kikil, kornet, daging giling, rolade, dendeng)",
    "6 September 2027",
    "",
  ],
  [
    "LP-1247-IDN",
    "Yes",
    "UPT Laboratorium Lingkungan Dinas Lingkungan Hidup Kabupaten Agam",
    "Jl. Sikumbang No. 1 Padang Baru, Lubuk Basung, Kab Agam, Sumatera Barat",
    "(0752) 877813",
    "Air sungai, air danau, air tanah/sumur pantau TPAS, air lindi, air untuk keperluan higiene sanitasi, air limbah, air minum",
    "18 September 2027",
    "",
  ],
  ["LP-1248-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  ["LP-1249-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  ["LP-1250-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  ["LP-1251-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  ["LP-1252-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  [
    "LP-1253-IDN",
    "Yes",
    "PT BVAQ Indonesia Lab",
    "Kompleks Pergudangan Daan Mogot Eraprima Kav. J10, Jl. Daan Mogot Km. 21, Batu Ceper, Tangerang",
    "(021) 55723474",
    "Tepung terigu, Mie Instan, Biskuit, Makanan Ringan Ekstrudat (berbahan dasar kentang, umbi, serealia, tepung dan pati), Minyak goreng sawit, CPO, air mineral, produk tepung terigu (mie instant, ekstrudat), air proses/non portable water, Animal and vegetable fats and oil (CPO, Cooking oil), ikan dan produk perikanan segar, Potongan Daging Unggas dan Daging Hewan Buruan yang Dilepaskan dari Tulangnya, Digiling Mekanik dan Dibentuk, MDM, Sosis segar, Daging, Daging Unggas dan Daging Hewan Buruan yang Dihaluskan dan Diolah dengan Perlakuan Panas atau Dibekukan, bumbu dan kondimen, yogurt, Susu fermentasi berperisa, susu bubuk, susu formula bayi, susu UHT, keju olahan, makanan pencuci mulut berbahan dasar susu, Produk emulsi lemak yang kadar lemaknya tidak kurang dari 80%, minyak goreng, minuman serbuk, swab peralatan, swab monitoring lingkungan, sirup berperisa, saus non emulsi, produk serupa roti termasuk roti untuk isi dan tepung roti, tepung panir",
    "30 September 2027",
    "",
  ],
  ["LP-1254-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  [
    "LP-1255-IDN",
    "Yes",
    "PT Biometrik Riset Indonesia",
    "Ruko Brickhouse, Jl. Raya Bogor KM 31 no. 52 Unit H dan I, kel. Cisalak, Kecamatan Sukmajaya, Depok, Jawa Barat",
    "(021) 87731563",
    "Plasma Darah Manusia",
    "16 Oktober 2027",
    "",
  ],
  [
    "LP-1256-IDN",
    "Yes",
    "PT Sentana Adidaya Pratama",
    "Jalan Kapten Darmo Sugondo No. 56 , Gresik 61124 Jawa Timur",
    "(0231) 3989101",
    "Pupuk NPK padat",
    "16 Oktober 2027",
    "",
  ],
  [
    "LP-1257-IDN",
    "Yes",
    "Laboratorium Fakultas Kedokteran, Kesehatan Masyarakat dan Keperawatan, Universitas Gadjah Mada",
    "Jalan Farmako, Sekip Utara Yogyakarta",
    "(0274) 560300",
    "sputum manusia, feses manusia, Sediaan obat/herbal, Darah/plasma darah yang mengandung rifampisin dan metfomin, Darah, sediaan tabir surya topikal, DNA",
    "16 Oktober 2027",
    "",
  ],
  [
    "LP-1258-IDN",
    "Yes",
    "PT Indonesia Power Unit Jasa Pembangkitan PLTU Banten 2 Labuan",
    "Jl. Laba Terusan Panimbang Desa Sukamaju Kecamatan Labuan Kabupaten Pandeglang Banten",
    "(0253) 805015",
    "Batubara",
    "31 Oktober 2027",
    "",
  ],
  [
    "LP-1259-IDN",
    "Yes",
    "Departemen Ilmu Tanah dan Sumberdaya Lahan, Fakultas Pertanian, Universitas Padjajaran (UNPAD)",
    "Jl. Raya Bandung-Sumedang KM 21 Jatinangor, Kabupaten Sumedang, jawa barat",
    "(022) 7797200",
    "Pupuk NPK, Tanah, Pupuk organik padat",
    "31 Oktober 2027",
    "",
  ],
  [
    "LP-1260-IDN",
    "Yes",
    "Stasiun Karantina Pertanian Kelas I Cilacap",
    "Komplek Bandara Tunggul Wulung Tritih Lor, Cilacap, Jawa Tengah",
    "(0282) 521870",
    "Serum darah (sapi, kerbau, kambing, domba), preparat ulas darah (sapi, kambing, kerbau), tepung gandum, tanah, akar tanaman kentang",
    "31 Oktober 2027",
    "",
  ],
  [
    "LP-1261-IDN",
    "Yes",
    "Sekolah Kedokteran Hewan dan Biomedis Institut Pertanian Bogor",
    "Lantai 4 Wing 1, Jl. Agatis, Kampus IPB Dramaga, Bogor, Jawa Barat",
    "081289604225",
    "Organ unggas (ayam, bebek, burung), Swab Trakhea, Swab Kloaka",
    "31 Oktober 2027",
    "",
  ],
  ["LP-1262-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  [
    "LP-1263-IDN",
    "Yes",
    "UPT Pengujian Energi dan Sumber Daya Mineral Provinsi Jawa Timur",
    "Jl. Perak Timur No. 320, Surabaya, Jawa Timur",
    "(031) 99093115",
    "Air untuk keperluan hygiene sanitasi",
    "18 November 2027",
    "",
  ],
  [
    "LP-1264-IDN",
    "Yes",
    "UPT Laboratorium Kesehatan Daerah Kota Tangerang Selatan",
    "Jl. Tekno Widya Sektor XI No. 1, Taman Tekno, BSD Tangerang Selatan, Banten",
    "(021) 29307897",
    "Air Minum, Air untuk keperluan hygiene dan sanitasi",
    "18 November 2027",
    "",
  ],
  [
    "LP-1265-IDN",
    "Yes",
    "Stasiun Karantina Pertanian Kelas I Sorong",
    "Jl. Selat Sunda (Komplek Bandara Deo) Sorong, Papua Barat",
    "(0951) 321220",
    "Serum darah sapi, beras, kopra (daging buah kelapa), kernel kelapa sawit, spesimen serangga, biji kedelai",
    "18 November 2027",
    "",
  ],
  ["LP-1266-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  [
    "LP-1267-IDN",
    "Yes",
    "Laboratorium Pakan Dinas Peternakan Provinsi Jawa Timur",
    "Jl. Ahmad Yani No. 202, Surabaya, Jawa Timur",
    "(031) 8280445",
    "Bahan pakan asal tumbuhan, Bahan pakan asal hewan, Pakan Hijauan, Pakan non ruminansia, Pakan ruminansia (konsentrat sapi potong, konsentrat sapi perah,pakan komplit sapi perah, konsentrat domba, konsentrat kambing, pakan konsentrat kerbau perah, pakan konsentrat kerbau potong), Feed Suplemen (Yeast Mud, Mineral), padatan",
    "18 November 2027",
    "",
  ],
  [
    "LP-1268-IDN",
    "Yes",
    "PT Indonesia Power - Banten 1 Suralaya OMU",
    "Jl. Yos Sudarso PLTU Suralaya 8, Kel. Suralaya, Kec Pulomerak, Cilegon, Banten",
    "(0254) 570402",
    "Batubara",
    "18 November 2027",
    "",
  ],
  [
    "LP-1269-IDN",
    "Yes",
    "PT Indonesia Power, Unit Jasa Pembangkitan Jawa Tengah 2 Adipala",
    "Desa Bunton, Kec Adipala, Kab Cilacap, Jawa Tengah",
    "(0282) 5264130",
    "Batubara",
    "18 November 2027",
    "",
  ],
  [
    "LP-1270-IDN",
    "Yes",
    "Stasiun Karantina Pertanian Kelas I Ambon",
    "Jl. Y. Syaranamual No.1 Kate-Kate, Ambon, Maluku",
    "(0911) 3683673",
    "Serum darah (sapi, kerbau, kambing, domba), Kopra",
    "18 November 2027",
    "",
  ],
  [
    "LP-1271-IDN",
    "Yes",
    "Aretha Medika Utama - Biomolecular and Biomedical Research Centre",
    "Jl. Babakan Jeruk II No. 9, Bandung, Jawa Barat",
    "(022) 2015097",
    "Ekstrak tumbuhan",
    "18 November 2027",
    "",
  ],
  [
    "LP-1272-IDN",
    "Yes",
    "PT Ecogreen Oleochemical",
    "Jl. Raya Pelabuhan Kabil Kav. No. 1, Nongsa - Kabil, Kel. Kabil, Kec. Nongsa, Batam, Kepulauan Riau",
    "(0778) 711002",
    "Medium Chain Triglycerides (MCT)/ Caprylic Capric Triglycerides (GTCC), fatty alcohol, Crude Palm Kernel Oil (CPKO), Coconut Oil (CNO)",
    "18 November 2027",
    "",
  ],
  [
    "LP-1273-IDN",
    "Yes",
    "UPTD Balai Mekanisasi dan Sarana Prasarana Pertanian, Dinas Perkebunan, Tanaman Pangan dan Hortikultura Provinsi Sumatera Barat - Laboratorium Penguji Mutu Alsintan",
    "Jl. Syech Djamil Djambek, Landbouw, Bukittinggi, Sumatera Barat",
    "(0752) 22823",
    "Mesin Pencacah Hijauan Pakan Ternak, Mesin Perontok Padi Tipe Pelemparan Jerami, Mesin pemipil jagung, Mesin Penghancur (crusher) bahan baku pupuk organik, Mesin pencacah (chopper) bahan pupuk organik",
    "18 November 2027",
    "",
  ],
  ["LP-1274-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  ["LP-1275-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  [
    "LP-1276-IDN",
    "Yes",
    "PT Ubar Jalindo",
    "Jl. Mekar Mulya, Kav No.7, Panyileukan, Bandung, Jawa Barat",
    "(022) 87885577",
    "Air limbah, air permukaan (air sungai, air danau), air bersih, kebisingan, udara ambien, lingkungan kerja, emisi sumber tidak bergerak",
    "18 November 2027",
    "",
  ],
  [
    "LP-1277-IDN",
    "Yes",
    "UPTD Laboratorium Lingkungan Dinas Lingkungan Hidup Kota Bengkulu",
    "Jl. WR. Supratman No. 08A, Kel. Bentiring Permai, Kec. Muara Bangkahulu, Bengkulu",
    "(0736) 20853",
    "Air Sungai dan air limbah",
    "18 November 2027",
    "",
  ],
  [
    "LP-1278-IDN",
    "Yes",
    "UPT Laboratorium Pengujian Dinas Energi &amp; Sumber Daya Mineral Provinsi Riau",
    "Jl. Jendral Sudirman, Simpang Tiga Pekanbaru, Riau",
    "(0761) 26991; 26992",
    "Batubara",
    "2 Desember 2027",
    "",
  ],
  [
    "LP-1279-IDN",
    "Yes",
    "Stasiun Karantina Pertanian Kelas I Timika",
    "Jl. Yos Sudarso Km. 05, Kab Mimika, Timika, Papua",
    "(0901) 3215162",
    "Beras, Buah (Jambu Biji, Jambu Air, Pisang Raja, Cabe, Tomat, Serangga), Serum (sapi, kambing, domba, ayam, Itik, Entok Bebek)",
    "2 Desember 2027",
    "",
  ],
  [
    "LP-1280-IDN",
    "Yes",
    "Dinas Lingkungan Hidup Kabupaten Karanganyar",
    "Jl. KH Samanhudi Cangakan Karanganyar",
    "(0271) 6491231",
    "Air Limbah",
    "2 Desember 2027",
    "",
  ],
  [
    "LP-1281-IDN",
    "Yes",
    "UPTD Laboratorium Lingkungan Dinas Pertanahan dan Lingkungan Hidup Kabupaten Balangan",
    "Jl. Ahmad Yani Km 5,5 Kel Batupiring , Kec Paringin Selatan, Kab. Balangan, Kalimantan Selatan",
    "(0526) 2094102",
    "Air permukaaan (air sungai, air danau), air limbah",
    "2 Desember 2027",
    "",
  ],
  [
    "LP-1282-IDN",
    "Yes",
    "PT Geomarindex",
    "Jl. Raya Kranggan no.17 RT.001, RW.005, Jatisampurna, Bekasi, Jawa Barat",
    "(021) 8441070 ; (021) 22988580",
    "Tanah",
    "2 Desember 2027",
    "",
  ],
  ["LP-1283-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  [
    "LP-1284-IDN",
    "Yes",
    "PT Mutuagung Lestari Medan",
    "Jl. Ngumban Surbakti Nomor 60, Kelurahan Sempakat, Kec. Medan Seayang, Kota Medan. Sumatera Utara",
    "(061) 42081350",
    "Air Sungai, Air danau, air limbah, Air untuk keperluan higiene sanitasi, emisi sumber tidak bergerak, udara ambien, kebisingan",
    "2 Desember 2027",
    "",
  ],
  [
    "LP-1285-IDN",
    "Yes",
    "PT Advanced Analytics Asia Laboratories",
    "Ruko Salemba Mas Salemba Raya 34-36 K Kel Kenari Kec Senen, Jakarta Pusat, DKI Jakarta",
    "(021) 3161673",
    "Air limbah, Air Sungai, Air untuk keperluan Higiene dan sanitasi/ air minum, udara emisi sumber tidak bergerak, Udara ambien, Udara Lingkungan kerja, Kebisingan",
    "2 Desember 2027",
    "",
  ],
  [
    "LP-1286-IDN",
    "Yes",
    "Balai Karantina Pertanian Kelas I Manado",
    "Jl. Yos Sudarso 177, Kel. Bitung Barat, Kec. Maesa, Sulawesi Utara",
    "(0438) 30339",
    "Serum darah unggas, Pala biji dan bunga pala, Kopra, bungkil kelapa, bungkil sawit",
    "2 Desember 2027",
    "",
  ],
  [
    "LP-1287-IDN",
    "Yes",
    "Balai Diklat Tambang Bawah Tanah",
    "Jl. Soekarno Hatta Durian II, Kec. Barangin, Sawahlunto, Sumatera Barat",
    "(0754) 61604/ 0811776655",
    "Batubara",
    "18 Desember 2027",
    "",
  ],
  ["LP-1288-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  [
    "LP-1289-IDN",
    "Yes",
    "UPTD Pengawasan dan Sertifikasi Benih Tanaman Pangan, Hortikultura dan Perkebunan Provinsi Banten",
    "Jl. Raya Cilegon KM. 4 Drangong, Serang, Provinsi Banten 42162",
    "(0254) 217842",
    "Benih padi, jagung, kedelai",
    "18 Desember 2027",
    "",
  ],
  [
    "LP-1290-IDN",
    "Yes",
    "Koperasi Jasa Keselamatan Radiasi dan Lingkungan - NuklindoLab",
    "Plaza Ciputat Mas Blok B Kav. P-Q, Jl. Ir. H. Juanda No. 5A, Ciputat Timur, Tangerang Selatan, Banten",
    ".(021) 29500440",
    "Pesawat Sinar-X Radiografi Umum, Pesawat Sinar-X Fluoroskopi, Pesawat Sinar-X Mammografi, Pesawat Sinar-X CT-Scan, Pesawat Sinar-X Dental Intraoral, Dosimeter Termoluminesensi (TLD), Ruangan/benda uji yang berhubungan dengan sumber radioaktif, Perisai radiasi (apron, tabir radiasi, kaca timbal, dinding, atau material lainnya), Sumber radioaktif (Cs-137, Co-60, Am-241)",
    "18 Desember 2027",
    "",
  ],
  [
    "LP-1291-IDN",
    "Yes",
    "PDAM Tirta Kahuripan Kabupaten Bogor",
    "Jl. Raya Tegar Beriman No. 1 RT.5 RW.8, Kelurahan Sukahati, Kecamatan Cibinong, Bogor, Jawa Barat",
    "(021) 83715759",
    "Air bersih, air minum",
    "18 Desember 2027",
    "",
  ],
  [
    "LP-1292-IDN",
    "Yes",
    "UPT. Laboratorium Lingkungan Dinas Lingkungan Hidup dan Kehutanan Kabupaten Bulukumba",
    "Jl. Dahlia No. 2 Bulukumba",
    "(0413) 81048",
    "Air Sungai, air limbah, air laut",
    "18 Desember 2027",
    "",
  ],
  [
    "LP-1293-IDN",
    "Yes",
    "Balai Veteriner Semarang",
    "Lokasi 1 : Jl. Setiabudi No 113 Semarang Lokasi 2 : Jl. Tunggul Wulung No 103 Pati Lokasi 3 : Jl. MT Haryono No 55 Ungaran",
    "(0246) 923914",
    "Lokasi 1: Sampel swab kloaka, swab trachea, bulu muda, swab, Serum darah unggas (Ayam, Bebek, Itik, Burung), Serum darah ruminansia (Sapi, Kambing, Domba, Babi), Feses ternak (Ayam, Sapi, Kambing, Domba, Babi, Kuda, Itik) dan hewan kesayangan (Anjing, Kucing, Kelinci, Primata)",
    "18 Desember 2027",
    "",
  ],
  ["LP-1294-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  [
    "LP-1295-IDN",
    "Yes",
    "PT Sucofindo - Laboratorium Cabang Denpasar",
    "Kantor Pusat: Jl. Tukad Badung, Lingkungan Klod Kel. Renon, Kec. Denpasar Selatan Kota Denpasar Provinsi Bali Labratorium: Site Benete Exploration Building PT. AMMAN Mineral Nusa Tenggara, Benete, Kab. Sumbawa Barat - Nusa Tenggara Barat",
    "(0361) 241847",
    "Konsentrat tembaga",
    "18 Desember 2027",
    "",
  ],
  [
    "LP-1296-IDN",
    "Yes",
    "PT Citra Lestari Enviro",
    "Jl. Setia Budi Komplek Setia Budi Point No. 36 C, Medan",
    "(061) 8211586",
    "Air bersih, air limbah, Air sungai, udara ambien, udara emisi sumber tidak bergerak, kebisingan",
    "18 Desember 2027",
    "",
  ],
  ["LP-1297-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  [
    "LP-1298-IDN",
    "Yes",
    "Balai Pengujian Standardisasi Instrumen Tanaman Buah Tropika (Multilokasi)",
    "Lokasi 1: Jl. Raya Solok-Aripan Km.8, PO. Box 5 Solok, Sumatera Barat Lokasi 2: Jl. Raya Solok-Sumani Km.10, PO Box 5 Solok, Sumatera Barat",
    "(0755) 20137",
    "Lokasi 1: Jaringan tanaman, tanah",
    "1 Januari 2028",
    "",
  ],
  [
    "LP-1299-IDN",
    "Yes",
    "Balai Karantina Pertanian Kelas II Palu",
    "Jl. Bahari Pantoloan, Palu, Sulawesi Tengah",
    "(0451) 491689; 4925566",
    "Serum darah Sapi, Buah Kelapa dan Biji Kakao, Ulas Darah Sapi dan kambing",
    "15 Januari 2028",
    "",
  ],
  [
    "LP-1300-IDN",
    "Yes",
    "PT Carsurin Berau",
    "Jl. Gunung Panjang RT 03, Tanjung Redeb, Kab Berau, Kalimantan Timur",
    "0554 - 2034661",
    "Batubara",
    "15 Januari 2028",
    "",
  ],
  ["LP-1301-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  [
    "LP-1302-IDN",
    "Yes",
    "UPT Laboratorium Dasar dan Terpadu Universitas Khairun",
    "Lokasi 1 : Jl. Jusuf Abdurahman, Kampus II Universitas Kharun Gambesi, Kota Ternate, Maluku Utara",
    "(0921) 3110904",
    "Air sungai, air danau dan air rawa",
    "15 Januari 2028",
    "",
  ],
  [
    "LP-1303-IDN",
    "Yes",
    "Perumdam Tirta Kencana Kota Samarinda",
    "Jl. Cendana Komplek PDAM Samarinda RT. 07 Kelurahan Karang Anyar Kecamatan Sungai Kunjang, Samarinda, Kalimantan Timur",
    "(0541) 741460",
    "Air baku dan air untuk keperluan higiene sanitasi",
    "15 Januari 2028",
    "",
  ],
  [
    "LP-1304-IDN",
    "Yes",
    "PT Indonesia Power-UJP Banten 3 Lontar",
    "Jl. Ir. Haji Sutami, Desa Lontar Kecamatan Kemiri, Kabupaten Tangerang - Banten",
    "085714451445",
    "Batubara",
    "15 Januari 2028",
    "",
  ],
  [
    "LP-1305-IDN",
    "Yes",
    "Laboratorium Perumda Paljaya",
    "Jl. Sultan Agung No. 1, Setiabudi, Jakarta Selatan",
    "081285827177",
    "Air Limbah",
    "15 Januari 2028",
    "",
  ],
  [
    "LP-1306-IDN",
    "Yes",
    "Laboratorium Forensik Digital Direktorat Tindak Pidana Siber Bareskrim Polri",
    "Jl. Trunojoyo No. 3, Kebayoran Baru, Jakarta Selatan",
    "(021)7258775",
    "Perangkat mobile/genggam (handphone, tablet), Sim card, Memory card, Komputer, Laptop, hardisk, SSD, Flashdisk",
    "27 Januari 2026",
    "",
  ],
  ["LP-1307-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  ["LP-1308-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  [
    "LP-1309-IDN",
    "Yes",
    "PT PJB UBJ O&amp;M PLTU Amurang",
    "Jl. Trans Sulawesi, Desa Tawaang, Kec Tenga, Kab Minahasa Selatan, Sulawesi Utara",
    "081355905483",
    "Batubara",
    "26 Februari 2028",
    "",
  ],
  [
    "LP-1310-IDN",
    "Yes",
    "Balai Karantina Pertanian Kelas I Kupang",
    "Lokasi 1 : Jl. Yos Sudarso, Tenau, Kota Kupang, Nusa Tenggara Timur Lokasi 2 : Jl. Yos Sudarso No.21",
    "(0380) \x{2013} 890040, 890200, 890011, 8563016",
    "Lokasi 1: Serum darah sapi, Preparat ulas darah kuda, kerbau",
    "26 Februari 2028",
    "",
  ],
  [
    "LP-1311-IDN",
    "Yes",
    "PT Haldin Pacific Semesta",
    "Jl. Irian V Blok MM 2 Cibitung Industrial Town Bekasi",
    "(021) 89981789",
    "Minyak Nilam, Ekstrak Glikolat Tanaman, Madu, Esktrak Kering Teh hijau, Ekstrak Kering Jahe, Madu, Ekstrak Kering Madu, Ekstrak Kering Turmerik",
    "11 Maret 2024",
    "",
  ],
  [
    "LP-1312-IDN",
    "Yes",
    "PT Refined Bangka Tin",
    "Kawasan Industri Jelitik, Sungailiat, Kabupaten Bangka, Provinsi Kepulauan Bangka Belitung",
    "(0717) 95444",
    "Logam timah murni, bijih timah",
    "31 Maret 2024",
    "",
  ],
  [
    "LP-1313-IDN",
    "Yes",
    "Balai Besar Pelaksanaan Jalan Nasional V Palembang",
    "Jl. H.M Noerdin Pandji RT 03 RW 01 No.78 KM. 7",
    "(0711) 410016",
    "Aspal, campuran beraspal",
    "31 Maret 2024",
    "",
  ],
  [
    "LP-1314-IDN",
    "Yes",
    "PT Chandra Asri Petrochemical, Tbk",
    "Lokasi 1: Jl. Raya Anyer Km. 123, Ciwandan, Cilegon, Banten 28 Desember 2022 Lokasi 2: Desa Mangunreja, Kec. Pulo Ampel, Kba. Serang, Banten",
    "(0254) 5750080",
    "Ethylene, propylene, 1.3 butadiene, raffinate-1, py gas, pyrolisis fuel oil (PFO), Polyethylene,Polypropylene, Styrene, Toluene",
    "23 April 2024",
    "",
  ],
  ["LP-1315-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  [
    "LP-1316-IDN",
    "Yes",
    "PT Kahatex",
    "Jl. Cijerah Cigondewah Girang No. 16 , RT 001/ RW 032, Melong, Cimahi Selatan",
    "(022) 6031566 ; 6031030",
    "Textile and textile product",
    "23/05/2024",
    "",
  ],
  [
    "LP-1317-IDN",
    "Yes",
    "PT Pertamina Lubricants",
    "Oil Center Building, Jl. MH. Thamrin Kav. 55 , Jakarta Lokasi 1 : Lab. Production Unit Jakarta : Jl. Jampea No. 1 Plumpang, Tanjung Priok, Jakarta Utara Lokasi 2 : Lab. Production Unit Cilacap : Jl. MT. Haryono, Kawasan Industri Cilacap, Jawa Tengah Lokasi 3 : Lab. Production Unit Gresik : Jl. Harun Tohir \x{2013} Gresik, Jawa Timur Lokasi 4 : Lab. Product Development : Jl. Yos Sudarso Pintu 3 Plumpang, Jakarta Utara Lokasi 5 : Lab. Oil Clinic : Jl. Yos Sudarso Pintu 3 Plumpang, Jakarta Utara Lokasi 6 : 6. Lab. TSP Batakan : Jl. Mulawarman No.99, Batakan, Kel Manggar, Balikpapan Timur, Kaltim",
    "(021) 31907190",
    "Base oil, aditif, Pelumas (New, Used, Grease), BBM Umum (Premium, Pertamax, Pertamax Turbo, Pertamina Dex, Solar, Kero, MDF, MFO), BBM Khusus (Avtur,Pure Methanol ,MethMix,Demin Water, Millipore), Solvent (SBP XX +LAWS+SMT), Agro/Petro Chemical (Lokasi 1)",
    "26/06/2024",
    "",
  ],
  [
    "LP-1318-IDN",
    "Yes",
    "Laboratorium Lingkungan Dinas Lingkungan Hidup Kabupaten Pemalang",
    "Jl. Jenderal Gatot Subroto No. 28, Pemalang",
    "(0284) 322121",
    "Air sungai",
    "26/6/2024",
    "",
  ],
  [
    "LP-1319-IDN",
    "Yes",
    "PT RND Teknologi Indonesia",
    "Jl. KSR Dadi Kusmayadi Blok C No. 9 RT 02 RW 05 Kel. Tengah, Kec. Cibinong, Bogor, Jawa Barat",
    "(021) 521184",
    "Air bersih, air permukaan (air sungai, air waduk, air danau), air sumur, air laut, air limbah, udara ambien, udara lingkungan kerja, emisi sumber tidak bergerak",
    "26/6/2024",
    "",
  ],
  [
    "LP-1320-IDN",
    "Yes",
    "PT Pertamina Geothermal Energy-Laboratorium Uji Mutu Area Kamojang",
    "Jl. Raya Kamojang, Kabupaten Bandung, PO BOX 120 Garut",
    "(022) 7806379 ; (022) 7806882-83",
    "Air panas bumi, gas panas bumi",
    "26/6/2024",
    "",
  ],
  [
    "LP-1321-IDN",
    "Yes",
    "PT Cheil Jedang Indonesia Pasuruan - Laboratorium Quality",
    "Desa Arjosari RT 04 RW 02, Kec. Rejoso, Kab. Pasuruan, Jawa Timur",
    "(0343) 482333",
    "Batubara",
    "7/7/2024",
    "",
  ],
  [
    "LP-1322-IDN",
    "Yes",
    "PT Hyundai Calibration and Certification Technologies Indonesia",
    "Jl. I Gusti Ngurah Rai 10, RT 10/RW 11, Pondok Kopi, Kec. Duren Sawit, Jakarta Timur, DKI Jakarta",
    "(021) 22477781",
    "GPRS/GSM/CDMA/WCDM/ HSPA/LTE, Bluetooth, WLAN, Zigbee, Low power device &amp; RFID, Telecommunication Products (laptop, mobile phone, BT speaker, tablet, router, car avn, tv with BT or wifi, BT remote, Wireless car key, Monitor with wifi or BT, Lora device, Tracking system, Wireless module, BT module,Wlan module, Lora module, 2g module, 3g module, 4g module, RFID module, low power module, POS terminal, BT medical equipment, wlan medical equipment, 2g 3g 4g medical, BT keyborad, BT mouse, low power Mouse, smart watch, wireless measurement equipment for electricity, wireless health checker, access point, smart plug, BT ear set, wireless microphone, wireless keyboard, wireless mouse, BT drone, wifi Drone, RFID Drone, 2G 3G 4G Drone, Lora Drone, wireless smart home devices, wireless projector, wireless powerbeam, wireless CCTV, CCTV camera, wireless MP3, wireless refridgerator, wireless desktop, wireless vaccuum cleaner, wireless water purifier, wireless bulb, wirless air purifier, wireless heater, wireless portable battery, wireless camera, wireless clock, wireless toy (RC car), wireless temperature recorder, wireless humidity recorder, wireless kindle, smart home system, smart pen, smart glasses, wireless e-cigarette, Car sensor, PDA)",
    "7/7/2024",
    "",
  ],
  [
    "LP-1323-IDN",
    "Yes",
    "PT Untung Bersama Sejahtera",
    "Jl. Raya Kenjeran 395-399, Surabaya",
    "(031) 3894636",
    "Gold bar, Larutan sepuh cyanide, Larutan sepuh permal, Larutan sepuh putih, Larutan sepuh tembaga, Larutan sepuh hitam, perhiasan emas",
    "7/7/2024",
    "",
  ],
  [
    "LP-1324-IDN",
    "Yes",
    "PT Prodia OHI International",
    "Jl. Niaga Raya Blok CC-5, No. 16-17, JCBD, Cikarang Selatan, Kab. Bekasi, Jawa Barat",
    "(021) 89840586 ; (021) 89840584",
    "Udara lingkungan kerja, air limbah, air untuk keperluan higiene dan sanitasi, air minum",
    "7/7/2024",
    "",
  ],
  ["LP-1325-IDN", "No", "", "", "", "", "", "Nomor Akreditasi dicabut"],
  [
    "LP-1326-IDN",
    "Yes",
    "Balai Karantina Ikan, Pengendalian Mutu dan Keamanan Hasil Perikanan Tarakan",
    "Jl. Lestari RT. 03, Kelurahan Karang Harapan Kecamatan Tarakan Barat, Tarakan",
    "(0551) 3810388",
    "Kepiting, udang lobster, udang windu, udang putih, kerang-kerangan, ikan mas, ikan mas koi, ikan mas koki, ikan nila",
    "4/8/2024",
    "",
  ],
  [
    "LP-1327-IDN",
    "Yes",
    "Fakultas Teknologi Industri Pertanian Universitas Padajadjaran",
    "Ged. Departemen Teknologi Industri Pangan, Jl. Raya Bandung Sumedang Km. 21, Jatinangor - Bandung, Jawa Barat",
    "(022) 779844",
    "Susu bubuk, snack (keripik), keripik kentang",
    "21/8/2024",
    "",
  ],
  [
    "LP-1328-IDN",
    "Yes",
    "PT Anindya Wiraputra Konsult Cabang Palembang",
    "Jl. H. Gub. Muhammad Ali Amin, SH. Komp. Pergudangan Gria Mitra Sukarami Blok D No. 09, Kel. Talang Kelapa Kec. Alang-alang Lebar Palembang, Sumatera Selatan",
    "(0711) 384109",
    "Batubara",
    "21/8/2024",
    "",
  ],
  [
    "LP-1329-IDN",
    "Yes",
    "PT Surya Esa Perkasa, Tbk",
    "Jl. Raya Palembang -Indralaya Km. 17, Simpang Y, Palembang",
    "(0711) 5649700",
    "Liquefied petroleum gas (LPG)",
    "21/8/2024",
    "",
  ],
  [
    "LP-1330-IDN",
    "Yes",
    "PT Lotte RND Center Indonesia",
    "Kawasan MM2100 Industrial Town, Jl.Kalimantan Blok E3 Gandamekar, Cikarang Barat",
    "(021) 30029047",
    "Es untuk dimakan (edible ice), Buah dan sayur ( Buah kering, kismis, sale pisang, mangga, manisan buah baik kering dan basah, buah dalam kaleng, jem, jeli, marmalad, jeli agar, santan cair, pasta kelapa, krim kelapa, kelapa parut kering, nata dalam kemasan, lempok atau analogi lempok berbasis buah, keripik berbasis buah, sayuran beku, sayuran kering, acar (sayuran asin), sayuran dalam kaleng, keripik berbasis sayur, umbi-umbian, kacang-kacangan, gadung, singkong, talas, kentang, ubi jalar, dan sejenisnya), Kembang gula/permen dan cokelat (kakao bubuk, kakao massa, produk kakao dan coklat, kembang gula keras,kembang gula lunak bukan jeli, kembang gula lunak jeli, kembang gula karet, kembang gula nirgula), Serealia dan produk serealia (tepung tapioka, tepung hunkwe, tepung kacang hijau, tepung singkong, tepung sagu, tepung garut, tepung jagung, tepung gandum, tepung beras, tepung siap pakai untuk kue, tepung aren, tepung pisang, sereal untuk sarapan tanpa susu, susu sereal bubuk, bihun spagetti, mie kering, sohun, mi instan, makaroni, pasta kering, produk akhir serealia yang masih perlu pengolahan lebih lanjut, mi basah, pasta mentah, tepung bumbu, dodol, wingko, yangko berbasis tepung beras ketan, wajik, tauco, produk olahan tempe, sari kedelai dan bakpia kacang hijau), Produk bakeri (roti, produk bakeri tawar/ premiks, tepung panir, produk bakeri istimewa manis, asin &amp; gurih), Daging dan produk daging (Dendeng sapi, dendeng asap yang diolah dengan panas, produk daging kering termasuk abon, kerupuk kulit, kerupuk paru, kerupuk usus ayam, daging olahan dan daging ayam olahan , bakso, sosis, naget, burger, sosis siap masak, corned dalam kaleng), Ikan dan produk perikanan (ikan, fillet ikan, molusca, crustaceae, echinodermata, hancuran sari ikan, ikan olahan yang diasap dengan garam atau tanpa garam, ikan olahan yang dikeringkan dengan garam atau tanpa garam, ikan olahan yang difermentasi dengan garam atau tanpa garam, produk perikanan awet, produk perikanan dikalengkan, produk perikanan difermentasi), Telur dan produk-produk telur (Telur cair, putih telur cair, kuning telur cair dengan pasteurisasi, telur beku, telur tepung atau kering, telur asin, makanan pencuci mulut berbahan dasar telur atau custard), Pemanis (Pemanis selain madu dan madu), Garam, rempah, sup, saus, salad, produk protein (Herba, rempah-rempah, bumbu mie instan, kodimen dan bumbu lainnya, mustard, sup, kaldu dalam kaleng, sup instan bubuk termasuk sup krim instan bubuk, bumbu rasa sapi, bumbu rasa ayam, saus teremulsi mayonnaise, sala dressing, sambal terasi, kecap kedelai, kecap ikan, kecap air kelapa, saus tiram, saus tomat, saus cabe, saus non emulsi lainnya, produk oles untuk salad, sandwich, dan ragi), AMDK, sari buah, sari sayuran, minuman berkarbonat (air soda, limun, dan sejenisnya), minuman isotonik, sirup, serbuk minuman (berperisa atau tidak berperisa, tradisional, dll),minuman squash, minuman tidak berkarbonat berperisa, teh kering dalam kemasan, teh celup, minuman teh dalam kemasan, kopi bubuk dalam kemasan, kopi celup, kopi instan, kopi campur, minuman kopi dalam kemasan, anggur, anggur buah, Makanan ringan siap santap (Makanan ringan ekstrudat, kacang garing, kacang sukro, kacang bawang, kacang telor, kacang bali, kacang goyang, makanan dan minuman sterilisasi dalam kemasan aseptis, dan pangan olahan sejenis lainnya), Peralatan makan (pisau, talenan, dan sejenisnya), Makanan siap santap (Bulgogi burger, Ayam geprek, Spaghetti bolognese, Lasagna, Nasi goreng , Chicken blackpapper, Grilled chicken, Risoles, Ayam penyet, Seblak, Gorengan, kwetiau goreng, Mie goreng, Bihun goreng, Nasi capcay, Paket ayam, Soto ayam, Toppoki, Yaki udon dan makanan siap santap sejenis lainnya)",
    "21/8/2024",
    "",
  ],
  [
    "LP-1331-IDN",
    "Yes",
    "PT PLN (Persero) Unit Induk Pembangkitan Sumatera Bagian Selatan - Unit Pembangkitan Teluk Sirih",
    "Jl. Lintas Sumatera Padang - Painan Km. 25, Teluk Kabung Tengah, Bungus Teluk Kabung, Kota Padang, Sumatera Barat",
    "(0751) 4650089",
    "Batubara",
    "21/8/2024",
    "",
  ],
  [
    "LP-1332-IDN",
    "Yes",
    "PT. Jasa Mutu Mineral Indonesia Banjarbaru",
    "Jl. Trikora HM. 3379 RT. 024 RW. 005 Kelurahan Kemuning, Kecamatan Banjarbaru Selatan, Banjarbaru, Kalimantan Selatan",
    "(0511) 4770259 ; (0511) 5910685",
    "Batubarat, Nickel Ore",
    "21/8/2024",
    "",
  ],
  [
    "LP-1333-IDN",
    "Yes",
    "UPT Laboratorium Terpadu Universitas Syiah Kuala",
    "Jl. Syeh Abdul Rauf No. 7, Kopelma Darussalam, Banda Aceh",
    "(0651) 3612265",
    "Tanah, beton dan tulangan baja",
    "1/9/2024",
    "",
  ],
  [
    "LP-1334-IDN",
    "Yes",
    "PT Bayer Indonesia",
    "Jl. Rungkut Industri I No. 12, Surabaya",
    "(031) 992042222; 8439541",
    "Pestisida bentuk cairan, pasta, dan padatan",
    "1/9/2024",
    "",
  ],
  [
    "LP-1335-IDN",
    "Yes",
    "PT Fonterra Brands Manufacturing Indonesia - FSQ Laboratory",
    "Kawasan Terpadu Indonesia, China (KITIC) Kav. 55, Desa Nagsari, Kec. Serang Baru, Bekasi, Jawa Barat",
    "(021) 30425445",
    "Milk Powder, Swab (lantai, permukaan peralatan /conveyor, meja kerja proses, personel higiene), cheese, air minum/ air bersih, Butter",
    "1/9/2024",
    "",
  ],
  [
    "LP-1336-IDN",
    "Yes",
    "PT Federal Karyatama - Laboratorium Pelumas",
    "Jl. Australia II Kav R.1, Krakatau Industrial Estate Cilegon, Kel. Warnasari, Kec. Citangkil, Cilegon",
    "(0254) 7840498 ext. 87373",
    "Pelumas, Pelumas Mobil Bensin, Pelumas Mobil Diesel, Pelumas Motor Non Matic, Pelumas Motor Matic, Pelumas Hidrolik, Pelumas Transmisi Manual (Gear), Pelumas Heat Thermal Oil",
    "24/09/2024",
    "",
  ],
  [
    "LP-1337-IDN",
    "Yes",
    "Deputi Bidang Infrastruktur Riset dan Inovasi \x{2013} Direktorat Pengelolaan Laboratorium, Fasilitas Riset dan Kawasan Sains dan Teknologi-Laboratorium Penerbangan \x{2013} Badan Riset dan Inovasi Nasional (BRIN)",
    "Jl. Raya LAPAN Sukamulya, Rumpin, Bogor, Jawa Barat",
    "(021) 75790031",
    "Komposit, komponen pesawat terbang",
    "24/09/2024",
    "",
  ],
  [
    "LP-1338-IDN",
    "Yes",
    "PT Lawangmas Primapack Indonesia",
    "Jl. Perusahaan No. 99, Kompleks Industri Randuagung Singosari, Malang",
    "(0341) 454999",
    "Substrat, alumunium foil, laminate, pouch/bag, tinta (ink)",
    "24/09/2024",
    "",
  ],
  [
    "LP-1339-IDN",
    "Yes",
    "PT Gunung Sejahtera Ibu Pertiwi - Laboratorium R&amp;D",
    "Desa Pandu Senjaya, Kec. Pangkalan Lada, Kab. Kotawaringin Barat, Kalimantan Tengah",
    "081281696722",
    "Daun, rachis kelapa sawit, pupuk anorrganik urea, tanah, pupuk organik padat, pupuk anorganik NPK, pupuk anorganik urea, pupuk anorganik SP-36, pupuk anorganik fosfat alam, pupuk anorganik KCl, pupuk anorganik dolomit, pupuk anorganik borat, pupuk anorganik kapur pertanian, pupuk anorganik kieserit, pakan ternak, Air sumur, Air limbah, Minyak kelapa sawit mentah (CPO)",
    "24/09/2024",
    "",
  ],
  [
    "LP-1340-IDN",
    "Yes",
    "PT Sorini Agro Asia Corporindo Cargill Incorporated",
    "Kawasan Industri Modern Cikande, Jl. Modern Industri Utama, Blok BA No. 2, Kel. Nambo Udik, Cikande, Serang",
    "(0254) 403970",
    "Dairy product",
    "24/09/2024",
    "",
  ],
  [
    "LP-1341-IDN",
    "Yes",
    "PT Jasa Mutu Mineral Indonesia Palembang",
    "Jl. Tanjung Api-api Km. 06, Dusun II RT 11, RW 005, Desa Gasing, Kecamatan Talang Kelapa, Kabupaten Banyuasin, Palembang",
    "(0711) 7421620",
    "Batubara",
    "24/09/2024",
    "",
  ],
  [
    "LP-1342-IDN",
    "Yes",
    "PT Greenlab Indo Global",
    "GRHA Environesia , Jl. Jati Mataram No, 248B, Kec. Miati, Kab. Sleman, DI Yogyakarta",
    "(0274) 880603",
    "Air laut, air minum, udara ambien, udara emisi, lingkungan kerja, air akuifer, air mata air, air sungai, air rawa, air danau, air waduk, air muara, Air Mineral, air untuk keperluan higiene dan sanitasi, air kolam renang, solus per aqua (SPA), air pemandian umum, air limbah, emisi sumber tidak bergerak, emisi sumber bergerak, sedimen, tanah/limbah padat",
    "24/09/2024",
    "",
  ],
  [
    "LP-1343-IDN",
    "Yes",
    "PT Surveyor Indonesia-Divisi Bisnis Migas",
    "Olympic Comercial Bisnis Distrik, Jl. Cahaya Raya Kav. H10 No. 1-3, Desa Leuwinutug, Kec. Citeurep, Kab. Bogor, Jawa Barat",
    "(021) 50871250",
    "Pelumas, Base oil, OCM (turbin oil)",
    "24/09/2024",
    "",
  ],
  [
    "LP-1344-IDN",
    "Yes",
    "Stasiun Karantina Pertanian Kelas II Manokwari",
    "Jl. Trikora Sowi IV, Manokwari, Papua Barat",
    "(0986) 2211194",
    "Serum darah sapi, benih padi, serum darah unggas, ayam dewasa, unggas, Biji Kedelai",
    "24/09/2024",
    "",
  ],
  [
    "LP-1345-IDN",
    "Yes",
    "Balai Penerapan Standar Instrumen Pertanian Papua Barat",
    "Jl. Brigjen Marinir (Purn) Abraham O. Atururi, Kompleks Kantor Gubernur, Arfai, Manokwari",
    "(0986) 2210832",
    "Ubi jalar, ubi kayu, tepung beras, tepung jagung, tepung sagu",
    "3/10/2024",
    "",
  ],
  [
    "LP-1346-IDN",
    "Yes",
    "Stasiun Karantina Ikan Pengendalian Mutu dan Keamanan Hasil Perikanan Bandung",
    "Jl. Ciawitali No. 44, Cimahi, Bandung",
    "(022) 6649004",
    "Ikan air tawar, produk perikanan beku dan segar, Aquatic crustacea (udang, lobster dan kepiting), Ikan cyprinid (koi, koki, mas, Guppy, Zebra fish)",
    "3/10/2024",
    "",
  ],
  [
    "LP-1347-IDN",
    "Yes",
    "PT Carsurin Balikpapan",
    "Jl. Pupuk Raya No. 56 RT 14, Balikpapan",
    "(0542) 7212194",
    "Crude Palm Oil",
    "15/10/2024",
    "",
  ],
  [
    "LP-1348-IDN",
    "Yes",
    "PT Axo Green Laboratory",
    "Jl. Rungkut Industri III Ruko Galaxi SIER No. 7, Surabaya",
    "(031) 99013124",
    "Air minum, air besih/air untuk keperluan higiene dan sanitasi, air permukaan (air sungai), air limbah, udara ambien, Udara Roadside",
    "27/10/2024",
    "",
  ],
  ["LP-1349-IDN", "No", "", "", "", "", "", "Nomor Akreditasi dicabut"],
  [
    "LP-1350-IDN",
    "Yes",
    "Balai Besar Penelitian Tanaman Padi",
    "Jl. Raya No. IX, Sukamandi, Subang",
    "(0260) 520157",
    "Biji-bijian, benih tanaman pangan, benih hortikultura, gabah, beras, coklat, kopi, minyak, mie",
    "18/11/2024",
    "",
  ],
  [
    "LP-1351-IDN",
    "Yes",
    "Balai Perikanan Budidaya Air Payau Batee",
    "Jl. Laksamana Malahayati Km. 16, Ujung Batee, Banda Aceh",
    "",
    "Udang windu, udang vanamae, ikan kakap merah, ikan kakap putih, ikan kerapu",
    "18/11/2024",
    "",
  ],
  [
    "LP-1352-IDN",
    "Yes",
    "UPT Balai Hyperkes dan Keselamatan Kerja Dinas Tenaga Kerja dan Energi Sumber Daya Mineral Provinsi Bali",
    "Jl. Raya Puputan Niti Mandala Renon, Denpasar",
    "(0361) 225561",
    "Udara ambien, lingkungan kerja",
    "18/11/2024",
    "",
  ],
  [
    "LP-1353-IDN",
    "Yes",
    "PT Edmi Manufacturing",
    "Delta Silicon Lippo Cikarang, Jl. Sungkai II Blok F26 No. 12A, Kabupaten Bekasi",
    "(021) 29617079",
    "kWh meter",
    "18/11/2024",
    "",
  ],
  [
    "LP-1354-IDN",
    "Yes",
    "PT Bungasari Flour Mills Indonesia",
    "Jl. Raya Anyer Link, Komp. Sinyar RT 014/RW 006, Tegal Ratu, Ciwandan District, Cilegon, Banten",
    "(0254) 669552",
    "Tepung terigu, gandum dan by product, tepung kulit air",
    "18/11/2024",
    "",
  ],
  [
    "LP-1355-IDN",
    "Yes",
    "Stasiun Karantina Pertanian Kelas II Ende",
    "Jl. RW. Monginsidi No. 3 Ippi, Kelurahan Tetandara, Kecamatan Ende Selatan",
    "(0381) 22474",
    "Kopra, serum darah sapi",
    "18/11/2024",
    "",
  ],
  [
    "LP-1356-IDN",
    "Yes",
    "UPT Laboratorium Lingkungan, Dinas Perumahan Rakyat, Kawasan Permukiman dan Lingkungan Hidup Kabupaten Tanah Laut",
    "Jl. A. Syukri Komplek Gagas, Permai Pelaihan, Kabupaten Tanah Laut",
    "(0512) 21552",
    "Air limbah, air permukaan, air danau, air untuk higiene sanitasi",
    "18/11/2024",
    "",
  ],
  [
    "LP-1357-IDN",
    "Yes",
    "PT Anindya Wiraputra Konsult Cabang Kendari",
    "Jl. Poros Bandara Haluoleo, Desa Onewila, Kec. Ranoometo, Kab. Konawe Selatan, Kendari, Sulawesi Tenggara",
    "",
    "Batubara, mineral (bijih nikel, bijih besi, limestone, dolomite powder, bijih mangan, pasir silika)",
    "18/11/2024",
    "",
  ],
  [
    "LP-1358-IDN",
    "Yes",
    "PT Moya Indonesia",
    "Atrium Setiabudi Building, 4th Floor Suite 410, Jl. HR. Rasuna Said Kav. 62, Kuningan RT 18/ RW 02, Karet Kuningan, Setia Budi, Jakarta Pusat",
    "(021) 52103399",
    "Air minum",
    "28/11/2024",
    "",
  ],
  [
    "LP-1359-IDN",
    "Yes",
    "PT Dion Farma Abadi - FS Dermacosmo Research and Innovation Centre",
    "Jl. Yogyakarta-Solo Km. 18, Kemudo, Sanggrahan, Prambanan, Klaten, Yogyakarta",
    "(0274) 4987557",
    "Obat, kosmetik",
    "17/12/2024",
    "",
  ],
  [
    "LP-1360-IDN",
    "Yes",
    "PT Telen Orbit Prima",
    "Lokasi 1: Desa Teluk Timbau, Kec. Dusun Hilir, Kab. Barito Selatan, Kalimantan Tengah Lokasi 2: Desa Buhut Jaya, Kec. Kapuas Tengah, Kab. Kapuas, Kalimantan Tengah",
    "082139329885",
    "Batubara",
    "17/12/2024",
    "",
  ],
  [
    "LP-1361-IDN",
    "Yes",
    "PT Indo Borneo Inspeksi Services - Laboratorium Samarinda",
    "Jl. KH. Usman Ibrahim No. 8, Kel. Pelita, Kec. Samarinda Ilir, Samarinda, Kalimantan Timur",
    "(0541) 766063",
    "Batubara, bijih tambang nikel/Nickel ore",
    "17/12/2024",
    "",
  ],
  [
    "LP-1362-IDN",
    "Yes",
    "UPTD Laboratorium Kesehatan Daerah Kota Bogor",
    "Jl. Kesehatan No. 3, Tanah Sareal, Bogor",
    "(0251) 8385082",
    "Air untuk higiene dan sanitasi, air minum, air limbah, makanan olahan dan usap dubur, usap alat, air kolam renang, makanan dan minuman",
    "17/12/2024",
    "",
  ],
  [
    "LP-1363-IDN",
    "Yes",
    "UPT Penerapan Mutu Hasil Perikanan, Dinas Kelautan dan Perikanan Provinsi Riau",
    "Jl. PPI Pangkalan Sesai, Dumai, Riau",
    "",
    "Ikan asap patin, ikan asap lele, ikan asap nila, nugget ikan patin, nugget ikan lele, nugget ikan tenggiri,bakso ikan patin, bakso ikan tenggiri, udang segar, terasi, kerupuk udang, kerupuk ikan, ikan asin, ikan segar",
    "17/12/2024",
    "",
  ],
  [
    "LP-1364-IDN",
    "Yes",
    "PT Geoservices Geoassay Cikarang",
    "Jl. Industri Selatan 2 Blok MM 1 Jababeka 2, Cikarang, Bekasi, Jawa Barat",
    "(021) 8937833",
    "Mineral, ore, logam",
    "17/12/2024",
    "",
  ],
  [
    "LP-1365-IDN",
    "Yes",
    "Balai Pengawas Obat dan Makanan di Jambi",
    "Jl. RM. Nur Atmadibrata No. 11, Telanaipura, Jambi",
    "(0741) 61031",
    "Obat, obat tradisional, kosmetik, produk susu dan analognya, lemak, minyak dan emulsi minyak, es untuk dimakan, buah dan sayur, convectionary, serealia dan produk serealia, produk bakeri, daging dan produk daging, ikan dan produk perikanan, grama, rempah, sup, salad, produk protein, produk pangan untuk keperluan khusus, minuman tidak termasuk susu, makanan ringan siap santap, makanan campuran",
    "17/12/2024",
    "",
  ],
  [
    "LP-1366-IDN",
    "Yes",
    "PT Peterson Mitra Indonesia",
    "Jl. Jend. Sudirman Blok G2 No. 5, Balikpapan Permai, Kecamatan Balikpapan Selatan, Kotamadya Balikpapan, Kalimantan Timur",
    "(0542) 436988",
    "Batubara",
    "17/12/2024",
    "",
  ],
  ["LP-1367-IDN", "No", "", "", "", "", "", "Nomor Akreditasi dicabut"],
  [
    "LP-1368-IDN",
    "Yes",
    "PT Indo Borneo Inspeksi Services Banjarbaru",
    "Jl. RO Ulin No. 145-146, Kel.Loktabat Selatan, Kec. Banjarbaru Selatan, Kalimantan Selatan",
    "(0511) 5913972",
    "Batubara",
    "21/01/2025",
    "",
  ],
  [
    "LP-1369-IDN",
    "Yes",
    "Balai Litbang Bangunan Hidraulik dan Geoteknik Keairan, Pusat Penelitian dan Pengembangan Sumber Daya Air",
    "Jl. Ir. H. Juanda 193, Bandung",
    "(022) 2505936",
    "Agregat halus, agregat kasar, beton, silinder beton, model fisik 2D bendung, model fisik 3D bendung dan bangunan pelengkap,bangunan pelimpah, saluran",
    "03/02/2025",
    "",
  ],
  [
    "LP-1370-IDN",
    "Yes",
    "Universitas Sumatera Utara - Laboratorium Bahan dan Rekayasa Beton",
    "Jl. Perpustakaan No. 19, Kampus USU, Medan",
    "081370688181",
    "Beton silinder",
    "02/02/2025",
    "",
  ],
  [
    "LP-1371-IDN",
    "Yes",
    "PT Wirakarya Sakti - Laboratorium Soil",
    "Camp RDD Sei Tapa Desa Pematang Lumut, Kecamatan Tungkal Ulu, Kabupaten Tanjung Jabung Barat, Jambi",
    "(0742) 510541",
    "Pupuk NPK Padat, Pupuk Rock Phospate (RP), Pupuk Dolomite, Pupuk KCl, Pupuk TSP, Pupuk Potassium Chloride (KCl), Pupuk Urea",
    "02/02/2025",
    "",
  ],
  [
    "LP-1372-IDN",
    "Yes",
    "PT PLN Nusantara Power Unit Pembangkitan Kaltim Teluk",
    "Jl. PLTU No. 01, Kel. Teluk Waru Karingau, Balikpapan, Kalimantan Timur",
    "(0542) 8531066",
    "Batubara",
    "02/02/2025",
    "",
  ],
  [
    "LP-1373-IDN",
    "Yes",
    "UPTD Laboratorium dan Pengujian, Dinas Pekerjaan Umum Kota Semarang",
    "Jl. Mlatiharjo Raya No. 11A, Kelurahan Mlatibaru, Kecamatan Semarang Timur, Semarang, Jawa Tengah",
    "(024) 86042797",
    "Beton silinder, paving block, core drill aspal, core drill beton, tanah, agregat kasar, agregat halus",
    "02/02/2025",
    "",
  ],
  [
    "LP-1374-IDN",
    "Yes",
    "Balai Veteriner Lampung",
    "Jl. Untung Suropati No. 2, Labuan Ratu, Bandar Lampung, Lampung",
    "(0721) 701851",
    "Serum (sapi, unggas, babi), tinja (sapi, kerbau, kambing, domba, anjing), feses mamalia (sapi, kerbau, kambing, domba), feses unggas (ayam, itik, entok, burung), hewan mati/cadaver atau hidup (unggas, ruminansia, anjing, babi), otak hewan penular rabies (anjing, kucing, kera, sapi), organ asal unggas dan mamalia, daging dan telur, air asal farm yang masuk sistem distirbusi dan pada sistem distribusi, organ sapi, kambing &amp; domba (hati, paru, ginjal, limpa, imfo grandula), organ, swab kloaka/trachea (ayam, itik, entok, burung), organ otak, tulang meat bone meal (MBM), daging pangan asal hewan (tikus/kerbau), daging ayam, usus ayam dan produk asal hewan (bakso dan sosis), isi rumen rumenansia, pakan hijau/konsentrat, air bersih, organ babi, swan nasal babi, darah babi dalam EDTA, produk olahan asal babi, organ limpa sapi, plasma darah sapi, buffycoat sapi, ulas darah sapi, organ sapi",
    "18/02/2025",
    "",
  ],
  [
    "LP-1375-IDN",
    "Yes",
    "UPTD Balai Pengawasan dan Sertifikasi Benih Tanaman Pangan dan Hortikultura Provinsi Bali",
    "Jl. Raya Sesetan KM.7, Denpasar, Bali",
    "(0361) 720073",
    "Benih padi, benih jagung",
    "18/02/2025",
    "",
  ],
  [
    "LP-1376-IDN",
    "Yes",
    "UPTD Laboratorium Bahan Konstruksi Dinas Pekerjaan Umum dan Penataan Ruang Provinsi Kalimantan Selatan",
    "Jl. Yos Sudarso No. 35, Banjarmasin, Kalimantan Selatan",
    "(0511) 3256623",
    "Beton kubus, beton silinder, tanah dan batuan, tanah kohesif, tanah, Agregat halus dan kasar, air limbah, air sungai, air sumur dan air danau",
    "18/02/2025",
    "",
  ],
  ["LP-1377-IDN", "No", "", "", "", "", "", "Nomor Akreditasi dicabut"],
  [
    "LP-1378-IDN",
    "Yes",
    "PT Tribhakti Inspektama Cabang Samarinda",
    "Lokasi 1: Jl. APT. Pranoto No.89, Kel. Sungai Keledang, Kec. Samarinda Seberang, Samarinda, Kalimantan Timur Lokasi 2. Site PT Kutai Energi, Jalan Bara No 01, Kel. Teluk Dalam, Kec. Muara Jawa, Kab. Kutai Kartanegara, Kalimantan Timur",
    "(0541) 2082222",
    "Batubara, Iron ore",
    "1/3/2025",
    "",
  ],
  [
    "LP-1379-IDN",
    "Yes",
    "PT Spindo Engineering Industry",
    "Jl. Kabupaten, Desa Cangkringmalang, Kec Beji, Pasuruan, Jawa Timur",
    "(0343) 656523, 656091",
    "Baja karbon, besi beton/besi tuangan, besi cor dan stainless steel",
    "1/3/2025",
    "",
  ],
  ["LP-1380-IDN", "No", "", "", "", "", "", "Nomor Akreditasi dicabut"],
  [
    "LP-1382-IDN",
    "Yes",
    "PT Sentra Usahatama Jaya",
    "Jl. Raya Anyer Km. 10, Ciwanda, Cilegon, Banten",
    "(0254) 601703",
    "Gula rafinasi",
    "17/3/2025",
    "",
  ],
  [
    "LP-1383-IDN",
    "Yes",
    "PT Tekenomiks Indonesia",
    "Jl. Jend. Sudirman RT 29 No. 58, Kel. Damai Bahagia, Balikpapan, Kalimantan Timur",
    "(0542) 762226",
    "Pelumas, solar, grease, biodiesel. pelumas dalam penggunaan (oil in used monitoring)",
    "17/3/2025",
    "",
  ],
  [
    "LP-1384-IDN",
    "Yes",
    "PT Darya Varia Laboratoria, Tbk. Citeureup Plant - Laboratorium QC",
    "Jl. Landbau, Karangasem Barat, Citeureup, Kabupaten Bogor",
    "(021) 8751066",
    "Sediaan obat injeksi steril",
    "17/3/2025",
    "",
  ],
  [
    "LP-1385-IDN",
    "Yes",
    "PT Nusa Laboratorium Indonesia",
    "Jl. Dalurung 4 No. 01, Bantarjati, Bogor Utara, Bogor",
    "(0251) 8367688",
    "Air untuk keperluan higiene dan sanitasi, air limbah, air sungai, udara ambien, kebisingan lingkungan, lingkungan kerja, udara emisi sumber tidak bergerak",
    "17/3/2025",
    "",
  ],
  [
    "LP-1386-IDN",
    "Yes",
    "Balai Penerapan Standar Instrumen Tanaman Serealia",
    "Jl. Dr. Ratuangi 274, Maros, Sulawesi Selatan",
    "(0411) 371529",
    "Benih (jagung, sorgum, gandum)",
    "17/3/2025",
    "",
  ],
  [
    "LP-1387-IDN",
    "Yes",
    "UPT Sertifikasi Benih Tanaman Pangan dan Hortikultura Provinsi Sumatera Utara, Dinas Tanaman Pangan dan Hortikultura Sumatera Utara",
    "Jl. Jenderal Besar Dr. Abd. Haris Nasution No. 8, Medan",
    "(061) 7864132",
    "Benih tanaman pangan (padi, jagung, kacang kedelai, kacang tanha, kacang hijau, kacang merah), benih hortikultura (bayam, seledri, kol bunga, sawi, cabai, semnagka, mentimun, wortel, kangkung, oyong, buncis, terong, tomat, kacang panjang)",
    "17/3/2025",
    "",
  ],
  [
    "LP-1388-IDN",
    "Yes",
    "UPT Laboratorium Lingkungan Hidup Kabupaten Barito Utara",
    "Jl. Simpang Pramuka I, Muara Taweh, Kab. Barito Utara, Kalimantan Tengah",
    "(0519) 23367",
    "Air permukaan (air sungai, air danau, air sumur), air limbah, air minum, air bersih (air untuk keperluan",
    "17/3/2025",
    "",
  ],
  [
    "LP-1389-IDN",
    "Yes",
    "UPTD Laboratorium Lingkungan Dinas Lingkungan Hidup Kabupaten Bantul",
    "Jl. Dr. Wahidin Sudiro Husodo No. 1, Kabupaten Bantul, Daerah Istimewa Yogyakarta",
    "(0274) 2812572",
    "Air sungai, air sumur, air limbah",
    "17/3/2025",
    "",
  ],
  ["LP-1390-IDN", "No", "", "", "", "", "", "Nomor Akreditasi dicabut"],
  [
    "LP-1391-IDN",
    "Yes",
    "PT Inti Surya Laboratorium",
    "Ruko ICON Business Park, Blok O5-O6, Cisauk, Sampora, Kabupaten Tangerang",
    "081310751528",
    "Air permukaan, air bersih (air untuk keperluan higiene sanitasi), air tanah, air limbah, air minum, air laut, udara ambien, kebisingan lingkungan, lingkungan kerja, emoso sumber tidak bergerak",
    "17/3/2025",
    "",
  ],
  [
    "LP-1392-IDN",
    "Yes",
    "Balai Peningkatan Mutu dan Keamanan Pangan",
    "Lokasi 1: Jl. Gatot Subroto, Komplek Pertanian Tarubudaya Ungaran, Jawa Tengah Lokasi 2: Jl. Sindoro Raya, Mertoudan, Jebres, Surakarta, Jawa Tengah",
    "(024) 6924604",
    "Beras, tanaman pangan (jagung, kedelai, bekatul, gabah, ubi, kacang-kacangan, sorgum), biji kopi, gabah, kacang hijau, kacang tanah (biji dan polong)",
    "17/3/2025",
    "",
  ],
  [
    "LP-1393-IDN",
    "Yes",
    "PT Bio Sciquest",
    "Ruko Kedoya Elok Plaza, Blok DD No. 74, Jl. Panjang, Kedoya Selatan, Jakarta Barat",
    "(021) 5812765",
    "Biological Safety Cabinet, Laminar Airflow, Fume Hood",
    "21/04/2025",
    "",
  ],
  ["LP-1394-IDN", "No", "", "", "", "", "", "Nomor Akreditasi dicabut"],
  [
    "LP-1395-IDN",
    "Yes",
    "PT Pertamina (Persero) - Laboratory Research and Technology Innovation",
    "Jl. Raya Bekasi Km. 20, Pulogadung, Jakarta Timur, DKI Jakarta",
    "(021) 4609311",
    "Avtur, solar, crude oil, gasoline, naphta, LPG, fuel oil, lube base/pelumas, SBP/LAWS/SF/Solphy-2, asphalt, Rubber Porcessing Oil, wax, green coke, polimer, air, katalis, absorben, air formasi, oil, gas, surfaktan, core plug, gas alam, water based mud, oil bases mud",
    "21/04/2025",
    "",
  ],
  [
    "LP-1396-IDN",
    "Yes",
    "Loka Pengawas Obat dan Makanan di Kabupaten Ende",
    "Jl. Eltari, Kel. Paupire, Ende Tengah, Kab. Ende",
    "(0381) 2627492",
    "Selai buah, mie kering, tepung terigu, saos tomat/saus smabal, minuman kopi dalam kemasan, minuman teh dalam kemasan, kopi bubuk, bakso daging, terasi, formula bayi, keripik singkong, keripik buah",
    "21/04/2025",
    "",
  ],
  [
    "LP-1397-IDN",
    "Yes",
    "Pusat Penelitan dan Pengembangan Biomedis dan Teknologi Dasar Kesehatan",
    "Jl. Dr. Semeru No. 63, Bogor, Jawa Barat",
    "(021) 42881754",
    "Serum manusia dan serum hewan coba, ASI manusia, swan nasopharing dan oroparing",
    "21/04/2025",
    "",
  ],
  [
    "LP-1398-IDN",
    "Yes",
    "Laboratorium Mineral dan Material Maju FMIPA, Universitas Negeri Malang",
    "Jl. Semarang No.5, Gedung O4 Lt.1, FMIPA Universitas Negeri Malang",
    "(0341) 574895",
    "Mineral alami dan sintetik, minyak atsiri",
    "21/04/2025",
    "",
  ],
  [
    "LP-1399-IDN",
    "Yes",
    "PT Pembangkitan Jawa Bali Unit Pembangkitan Paiton",
    "Jl. Raya Surabaya Situbondo Km. 142, Paiton, Probolinggo",
    "(0335) 771805",
    "Batubara",
    "21/04/2025",
    "",
  ],
  [
    "LP-1400-IDN",
    "Yes",
    "PT Provital Perdana",
    "Jl. Kranji Blok F15 No. 1C, Delta Silicon 2, Lippo Cikarang",
    "(021) 24520051",
    "Baju bedah (drape), catheter, cap plastik, Bacilus atrophaeus",
    "21/04/2025",
    "",
  ],
  [
    "LP-1401-IDN",
    "Yes",
    "PT Donggi Senoro LNG",
    "Desa Uso, Batui, Kab. Banggai, Sulawesi Tengah",
    "(0462) 312000",
    "LNG",
    "21 April 2025",
    "",
  ],
  ["LP-1402-IDN", "No", "", "", "", "", "", "Nomor Akreditasi dicabut"],
  [
    "LP-1403-IDN",
    "Yes",
    "UPTD Laboratorium Lingkungan Hidup Kabupaten Tojo Una-Una",
    "Jl. Kajuou desa Sansarino Kec. Ampana Kota Kabupaten Tojo Una-Una, Kab. Poso",
    "085145035806",
    "Air sungai, air muara, mata air, air limbah",
    "04 Mei 2025",
    "",
  ],
  [
    "LP-1404-IDN",
    "Yes",
    "QM Laboratorium PT. SMART Tbk. \x{2013} Refinery Surabaya",
    "Jl. Rungkut Industri Raya No. 19, Kota Surabaya",
    "(031) 8439861",
    "RBD Palm Oil, RBD Palm Stearin, RBD Palm Olein (Cooking Oil), Shortening, Specialty Fats, Margarine, Crude Palm Oil (CPO), Palm Fatty Acid Distillation (PFAD)",
    "04 Mei 2025",
    "",
  ],
  [
    "LP-1405-IDN",
    "Yes",
    "Pusat Laboratorium Narkotika Badan Narkotika Nasional",
    "Jl. Mayjen H.E Sukma Km 21 Desa Wates Jaya Kecamatan Cigombong, Kab. Bogor",
    "'081284283814",
    "Sampel serbuk, kristal, tablet, dan pecahan tablet, Sampel alat hisap, pipa kaca, aluminium foil, dan plastik bekas pakai, Sampel Urine",
    "04 Mei 2025",
    "",
  ],
  [
    "LP-1406-IDN",
    "Yes",
    "PT Delta Indonesia Laboratory",
    "Ruko Prima Orchard No. C2, Perum Prima Harapan Regency, Bekasi Utara, Kota Bekasi",
    "(021) 88382018",
    "Udara ambien, udara lingkungan kerja, emisi gas buang dari sumber tidak bergerak, emisi gas buang dari sumber tidak bergerak secara isokinetik",
    "04 Mei 2025",
    "",
  ],
  [
    "LP-1407-IDN",
    "Yes",
    "UPTD Laboratorium Lingkungan Dinas Lingkungan Hidup Kota Tegal",
    "Jl. Lele No. 12,Tegal",
    "(0283) 356787",
    "Air limbah, Air sungai, Air untuk keperluan hygiene sanitasi",
    "04 Mei 2025",
    "",
  ],
  [
    "LP-1408-IDN",
    "Yes",
    "Balai Keselamatan Kerja dan Hiperkes Maluku",
    "Jl. Laksdya Leo Wattimena, Passo - Ambon",
    "(0911) 362236/361",
    "Lingkungan kerja",
    "04 Mei 2025",
    "",
  ],
  [
    "LP-1409-IDN",
    "Yes",
    "Balai Besar Pelaksanaan Jalan Nasional Jawa Tengah \x{2013} Daerah Istimewa Yogyakarta",
    "Jl. Soekarno - Hatta KM 26, Karangjati, Kec. Bergas Kab. Semarang, Jawa Tengah",
    "(0298) 522911",
    "Aspal, tanah, beton, agregat, campuran beraspal",
    "19 Mei 2025",
    "",
  ],
  [
    "LP-1410-IDN",
    "Yes",
    "Stasiun Karantina Pertanian Kelas I Entikong",
    "Jl. Lintas Malindo, Kec. Entikong, Kab. Sanggau, Entikong, Kalimantan Barat",
    "(0564) 31197",
    "Serum darah sapi &amp; kambing, spesimen lalat buah",
    "19 Mei 2025",
    "",
  ],
  [
    "LP-1411-IDN",
    "Yes",
    "Laboratorium Lingkungan Dinas Lingkungan Hidup Kabupaten Pidie",
    "Jl. Banda Aceh - Medan Km. 111 Kec. Pidie Kab. Pidie, Nanggro Aceh Darussalam",
    "(0653) 22137",
    "Air sungai, air limbah",
    "19 Mei 2025",
    "",
  ],
  [
    "LP-1412-IDN",
    "Yes",
    "Balai Teknik Kesehatan Lingkungan dan Pengendalian Penyakit (BTKLPP) Kelas II Ambon",
    "Jl. Tabea Jouw Kopertis Karang Panjang, Ambon",
    "(0911) 311377",
    "Kebisingan lingkungan, udara ambien, lingkungan kerja, limbah cair, makanan (es untuk dimakan, buah dan sayuran, serelia dan produk serelia, produk bakeri, daging dan produk daging, ikan dan produk perikanan, telur dan produk telur, minuman berperisa, makanan ringan siap santap), air minum, air bersih, air badan air",
    "19 Mei 2025",
    "",
  ],
  [
    "LP-1413-IDN",
    "Yes",
    "Balai Pengembangan Produk dan Standardisasi Indonesia - Pekanbaru",
    "Jl. Hang Tuah Ujung, No.124, Pekanbaru",
    "(0761) 8406902",
    "Minyak goreng sawit, Crude Palm Oil (CPO)",
    "19 Mei 2025",
    "",
  ],
  [
    "LP-1414-IDN",
    "Yes",
    "PT Timah Tbk (Persero) Multilokasi",
    "Lokasi 1 :Jl. Jend. Sudirman No. 51, Pangkalpinang, Kep. Bangka Belitung Lokasi 2 :Jl. raya timah no.1, Mungko, Bangka barat, Kep. Bangka Belitung Lokasi 3 :Jl. raya Pasar gantung kec. Gantung, kabupaten belitung timur",
    "(0717) 4258000",
    "Lokasi 1 : Mineral tambang",
    "01 Juni 2025",
    "",
  ],
  [
    "LP-1415-IDN",
    "Yes",
    "Laboratorium Dinas Lingkungan Hidup Kabupaten Semarang",
    "Kompleks perkantoran Candi Asri, Jl. Candirejo Kecamatan Ungaran Barat, Kab. Semarang",
    "(024) 6925605",
    "Air limbah, air tanah, air permukaan, udara ambien",
    "01 Juni 2025",
    "",
  ],
  [
    "LP-1416-IDN",
    "Yes",
    "Balai Perikanan Budidaya Laut Batam",
    "Jl. Raya Barelang Jembatan 3 Pulau Setokok Kec. Bulang, Kotak Pos 550 Batam Center, Kota Batam",
    "08116915800",
    "Air laut, ikan laut, udang, air laut/payau, tanah",
    "01 Juni 2025",
    "",
  ],
  [
    "LP-1417-IDN",
    "Yes",
    "Balai Besar pelaksanan Jalan Nasional XVIII Jayapura",
    "Kompleks Bina Marga Tanah Hitam Jl. Abepantai Abepura, Kota Jayapura, Papua",
    "(0967) 681383",
    "Aspal, beton, baja, tanah",
    "01 Juni 2025",
    "",
  ],
  [
    "LP-1418-IDN",
    "Yes",
    "PT Kaltim Prima Coal",
    "Kaltim Prima Coal Mine Site C3 Building Sangatta, Kutai Timur, Kalimantan Timur",
    "(0549) 521052",
    "Batubara",
    "16 Juni 2025",
    "",
  ],
  [
    "LP-1419-IDN",
    "Yes",
    "UPTD Laboratorium Lingkungan Dinas Lingkungan Hidup Provinsi Sulawesi Barat",
    "JL. TVRI, Kel. Rangas, Kec. Simboro, Kab. Mamuju, Sulawesi Barat",
    "081319633780",
    "Air sungai, air tanah, air limbah",
    "16 Juni 2025",
    "",
  ],
  [
    "LP-1420-IDN",
    "Yes",
    "PT Anindya Wiraputra Konsult \x{2013} Cabang Berau",
    "Jl. H.A.R.M Ayoeb RT. 13, Kel. Gunung Tabur, Kec. Gunung Tabur, Kab. Berau, Kalimantan Timur",
    "(0554) 2033455",
    "Batubara",
    "28 Juni 2025",
    "",
  ],
  [
    "LP-1421-IDN",
    "Yes",
    "PT Anindya Wiraputra Konsult \x{2013} Cabang Cikarang",
    "Kawasan Industri Delta Silikon 3, Lippo Cikarang Jalan Rotan Blok F27 No. 23C, Desa Cicau, Kab. Bekasi, Jawa Barat",
    "(021) 88977560",
    "Batubara, bijih nikel, bauksit, limestone, bijih mangan, bijih besi, ferronickel, nickel pig iron (NPI), pasir silika",
    "28 Juni 2025",
    "",
  ],
  ["LP-1422-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  [
    "LP-1423-IDN",
    "Yes",
    "Laboratorium Service Universitas Pakuan",
    "l. Pakuan PO. BOX 452 Gd. FMIPA 2 Lt. 3A, Kota Bogor, Jawa Barat",
    "(0251) 8375547",
    "Biskuit, tepung terigu",
    "21 Juli 2025",
    "",
  ],
  [
    "LP-1424-IDN",
    "Yes",
    "PT Tribhakti Inspektama Cabang Banjarbaru",
    "Jl. Sriwijaya RT. 002 RW. 001, Kel. Landasan Ulin Utara, Kec. Liang Anggang, Banjarbaru, Kalimantan Selatan",
    "(0511) 7947038",
    "Batubara, Bauksit",
    "21 Juli 2025",
    "",
  ],
  [
    "LP-1425-IDN",
    "Yes",
    "Laboratorium Pengujian Pestisida UPT Balai Proteksi Tanaman Pangan dan Hortikultura - Dinas Pertahanan Pangan, Tanaman Pangan dan Hortikultura Provinsi Sulawesi Selatan",
    "Jl. Dr. Ratulangi No. 69. Kab. Maros, Sulawesi Selatan",
    "(0411) 371593",
    "Tomat, formula/produk pestisida cair",
    "21 Juli 2025",
    "",
  ],
  [
    "LP-1426-IDN",
    "Yes",
    "UPTD Laboratorium Energi dan Sumber Daya Mineral Kelas A - Dinas Energi dan Sumber Daya Mineral Provinsi Jawa Tengah",
    "Lokasi 1 : Jl. Madukoro AA-BB Nomor 44 Tawang Mas, Semarang, Jawa Tengah Lokasi 2 : Jl. Balekambang Lor no.3, Surakarta Lokasi 3 : Jl. P. Sudirman no.52, Pati Lokasi 4 : Jl. Jend. Sudirman no.10, purworejo Lokasi 5 : Jl. Patimura no.1, Pekalongan",
    "(024) 7608203",
    "Air Tanah",
    "21 Juli 2025",
    "",
  ],
  [
    "LP-1427-IDN",
    "Yes",
    "PT Idemitsu Lube Techno Indonesia",
    "Jl. Permata Raya Lot BB-4A Kawasan Industri KIIC, Karawang",
    "(021) 89114768",
    "Engine oil, manual &amp; automatic tranmission, gear oil, hydraulic oil, turbine oil",
    "03 Agustus 2025",
    "",
  ],
  [
    "LP-1428-IDN",
    "Yes",
    "PT CCIC Jakarta \x{2013} Agriculture and Food (Multilokasi)",
    "Lokasi 1 : Jl. Pantai Indah Selatan Ruko Elang Laut Boulevard Blok M3 No. 16 - 17 Jakarta Utara Lokasi 2 : Komplek Citraland Gama City Blok R2 No. 21 Medan Estate, Kec. Percut Sei Tuan - Kab. Deli Serdang, Sumatera Utara",
    "(021) 2986 6637",
    "Oil and Fats - CPO and its derivatives (Crude Palm Oil (CPO), Crude Palm Stearin (CPS), Refined Palm Oil (RPO), Refined Palm Stearin (RPS), Refined Palm Olein (RPO), Refined Palm Kernel Oil (RPKO), Refined Palm Kernel Stearin (RPKS), Refined Hydrogenated Palm Kernel Stearin (RHPKS), Refined Hydrogenated Palm Kernel Oil (RHPKO), Refined Hydrogenated Palm Kernel Olein (RHPKOL), Refined Palm Kernel Olein (RPKOL)) Oil and Fats - Non-CPO (Crude Degummed Soyabean Oil (CDSO), Crude Sun Flower Oil (CSFO), Crude Coconut Oil (CCCO), Refined Coconut Oil ( RCCO), Crude Rapeseed Oil ( CRSO), Palm Kernel Expellers (PKE)",
    "03 Agustus 2025",
    "",
  ],
  [
    "LP-1429-IDN",
    "Yes",
    "Laboratorium Analisa PT Sido Muncul",
    "Jl. Soekarno Hatta Km 28, Ungaran, Kab. Semarang",
    "(0298) 523515",
    "Air Bersih, Air Limbah, Air mineral, Air Minum, Alkohol bioetanol, Anggur/minuman beralkohol, Bawang putih dan ekstrak bawang putih, Chloromint , Coklat bubuk/Cacao, Egg Yolk , Ekstrak Alang-alang dan Alang-alang (simplisia), Ekstrak atau cairan obat dalam, Ekstrak bilberry, Ekstrak Gingko biloba, Ekstrak Jahe, Ekstrak kunyit, Ekstrak Sylimarin/milk thistle, Ekstrak Teh hijau, Ekstrak temulawak, Ekstrak Tribulus terrestris, Garam, Ginseng Kering dan Ekstrak Ginseng, Glukosa, Gula pasir, Identifikasi obat dalam jamu/obat tradisional, Jahe Kering, Kemasan, Kopi dan minuman yang mengandung kopi, Kunyit kering, Madu, Glucose, Fructose, Royal Jelly, Honey Powder, Meniran, Merica hitam, Merica putih dan Merica bolong, Minuman Cair (KALDB, KKB) , Minuman serbuk (KKB Energi Drink, Serbuk Telur, Ginger Tea, Jahe Wangi, Red Ginger, Beras Kencur, Kopi Jahe, Kopi Tubruk, Susu Jahe, Colatrend, Colamil, GTLS, C1000, Teh Susu Jahe, Alangsari, Kunyit Asam, Anak Sehat, Turmeric, STMJ Coklat / Kopi / Putih), Minuman suplemen C1000, Minuman Suplemen KKB Energi Drink cair dan serbuk, Minuman tradisional dalam bentuk serbuk atau cair, Minyak jahe, Minyak kayu putih, Obat tradisional (serbuk, rajangan/simplisia, kapsul/tablet), Obat tradisional Cair, Obat tradisional serbuk, kapsul, kaplet, tablet, Permen, Pupuk, Pupuk Organik, Simplisia-simplisia, Susu, Susu bubuk dan Creamer, Temulawak kering",
    "03 Agustus 2025",
    "",
  ],
  [
    "LP-1430-IDN",
    "Yes",
    "PT Industrial Multi Fan",
    "Jl. Salembaran Raya Rt04/ RW02 Dadap, Kosambi Barat, Kab. Tangerang, Banten",
    "(021) 29031063",
    "Fan",
    "03 Agustus 2025",
    "",
  ],
  [
    "LP-1431-IDN",
    "Yes",
    "UPT Balai Pengujian dan Sertifikasi Mutu Barang (BPSMB) Dinas Perdagangan Provinsi Sulawesi Selatan",
    "Jl. A.P. Pettarani, Makassar, Sulawesi Selatan",
    "(0411) 441239",
    "Biji kakao, biji kopi",
    "18 Agustus 2025",
    "",
  ],
  [
    "LP-1432-IDN",
    "Yes",
    "PT Bumi Sarimas Indonesia",
    "Jl. Raya Padang Bukittinggi Km. 21, Batang Anai, Kab. Padang Pariaman, Sumatera Barat",
    "(0751) 482229, 482219",
    "Dessicated coconut, coconut cream/milk, coconut water",
    "22 September 2025",
    "",
  ],
  [
    "LP-1433-IDN",
    "Yes",
    "UPT Laboratorium Lingkungan Dinas Lingkungan Hidup Kabupaten Donggala",
    "Jl. Jati No.3, Kompleks Perkantoran Gunung Bale, Kab. Donggala, Sulawesi Tengah",
    "(0457) 7020180",
    "Air untuk keperluan higiene dan sanitasi, air limbah, air sungai",
    "20 Oktober 2025",
    "",
  ],
  [
    "LP-1434-IDN",
    "Yes",
    "Balai Veteriner Subang",
    "Jl. Terusan Garuda Blok Werasari RT.33 Rw.11, Dangdeur, Kab. Subang, Jawa Barat",
    "(0260) 7423134",
    "Serum, organ, atau darah, feses, swab unggas, organ hewan, daging, susu, telur, otak, serum darah unggas, serum darah sapi, feses unggas dan mamalia, Darah dengan antikoagulan, serum darah,",
    "20 Oktober 2025",
    "",
  ],
  [
    "LP-1435-IDN",
    "Yes",
    "PT Leon Testing and Consultacy - Laboratorium Banjarbaru",
    "Jl. Trikora No. 1 RT 05 RW 04, Kel. Loktabat Selatan Kec. Banjarbaru Selatan, Kota Banjarbaru, Kalimantan Selatan",
    "(0511) 5917000",
    "Batubara",
    "20 Oktober 2025",
    "",
  ],
  [
    "LP-1436-IDN",
    "Yes",
    "PT Leon Testing and Consultacy - Laboratorium Samarinda",
    "Mangkupalas Business Center Unit A2-A3 Jl Ampera RT 20 Kel. Simpang pasir Kec. Palaran, Kota Samarinda, Kalimantan Timur",
    "(0541) 7274716",
    "Batubara",
    "20 Oktober 2025",
    "",
  ],
  [
    "LP-1437-IDN",
    "Yes",
    "UPT Pembinaan dan Pengujian Mutu Hasil Perikanan, Dinas Pangan, Pertanian dan Perikanan Kota Tarakan",
    "Jl. Yos Sudarso No.12, Lingkas Ujung, Tarakan, Kalimantan Timur",
    "(0551) 51459",
    "Udang Beku, Udang Segar, Ikan Beku (ikan bandeng, tuna), Ikan Segar (ikan bandeng, tuna)",
    "4 November 2025",
    "",
  ],
  [
    "LP-1438-IDN",
    "Yes",
    "PT Akurat Spektra Prima",
    "Ruko De Mansion Blok D18, Alam Sutera, Kota Tangerang",
    "(021) 53170086 / (021) 53170087",
    "Sediaan serbuk campuran vitamin B1 dan B3 (suplement), bahan baku obat dalam bentuk kristal (kadar menthol), bahan baku obat dalam bentuk cairan (kadar sineol)",
    "18 November 2025",
    "",
  ],
  [
    "LP-1439-IDN",
    "Yes",
    "Balai Besar Karantina Pertanian Makassar",
    "Jl. Kapasa Raya No. 17 KM. 14, Daya, Makassar, Sulawesi Selatan",
    "(0411) 581323",
    "Biji-bijian dalam penyimpanan: (Biji Kakao (Theobroma cacao),Kacang Mete (Anacardium occidentale), Biji Jagung (Zea mays), Biji Gandum (Triticum spp), Lada (Piper nigrum), Biji Kedele (Glycine max), Biji Kopi (Coffea spp.), Daun : ubi kayu (Manihot utilissima), Bagian tanaman pada komoditas pisang (Musa spp.), rambutan (Nephelium lappaceum), sirsak dan srikaya (Annona spp.); spesimen kutu putih, Spesimen lalat buah (Bactrocera spp.), Biji dan bagian tanaman pada komoditi cabai (Capsicum spp), tomat (Solanum lycopersicum), terong (Solanum melongena), Serum darah ayam, Daging: sapi, ayam, babi, Jeroan sapi: jantung, limpa, paru, hati, babat, ginjal, Bakso: sapi, ayam, Daging olahan: sapi, ayam, Serum darah: sapi, kerbau, kambing, domba, Serum darah: anjing, kucing, Preparat ulas darah",
    "29 November 2025",
    "",
  ],
  ["LP-1440-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  [
    "LP-1441-IDN",
    "Yes",
    "PT Forisa Nusapersada",
    "Jl. Bhumimas II No. 7 RT 003/RW003, Kawasan Industri Cikupamas, Talaga-Cikupa, Kab. Tangerang, Banten",
    "(021) 5940 3000",
    "Minuman: serbuk minuman berbasis air berperisa yang berkarbonat, Minuman serbuk berperisa, Minuman rasa buah, Minuman kopi dalam kemasan, minuman teh dalam kemasan, Tepung agar-agar, Tepung dan Olahannya: Bubuk untuk saus dan gravies, Pasta dan mie serta produk sejenis pasta, premix bakery, Tepung bumbu",
    "29 November 2025",
    "",
  ],
  [
    "LP-1442-IDN",
    "Yes",
    "PT Karyaindah Alam Sejahtera",
    "Jl. Raya Sukomulyo KM. 24, Manyar, Kec. Manyar, Kab. Gresik, Jawa Timur",
    "(031) 3930881/3957429",
    "Crude Palm Oil (CPO), Crude Palm Kernel Oil (CPKO), RBDPO, RBDPKO, RBD Olein, RBD Stearin, Shortening",
    "29 November 2025",
    "",
  ],
  [
    "LP-1443-IDN",
    "Yes",
    "PT Filtrona Manufacturing Indonesia",
    "Berbek Industri I no 16-20, Surabaya Industrial Estate Rungkut, Waru, Sidoarjo, Jawa Timur",
    "(031) 8432017/8432018",
    "Filter rokok, rokok putih, rokok, rokok kretek, rokok menthol (white and kretek), tembakau dan filter, Tembakau dan Cut Filler,",
    "29 November 2025",
    "",
  ],
  [
    "LP-1444-IDN",
    "Yes",
    "UPTD Laboratorium Veteriner Dinas Peternakan Aceh",
    "Jl. Mr. Muhammad Hasan No.147 Banda Aceh",
    "(0651) 7559050/7559090",
    "Kesmavet: Daging ayam, sapi, kerbau, kambing, otak sapi",
    "29 November 2025",
    "",
  ],
  [
    "LP-1445-IDN",
    "Yes",
    "PT Astra Honda Motor",
    "Greenland International Industrial Center (GIIC) Blok DD No.1, Kota Deltamas, Bekasi",
    "(021) 6518080",
    "Unit sepeda motor dengan kelengkapannya, sistem motot pembakaran dalam, sistem pembuangan knalpot (exhaust muffler), klakson, lampu utama, speedometer, instalasi spion, simbol dan indikator, instalasi lampu, sistem kemudi dan pengunci",
    "29 November 2025",
    "",
  ],
  [
    "LP-1446-IDN",
    "Yes",
    "Pusat Pengembangan Sumber Daya Manusia Minyak dan Gas Bumi",
    "Jl. Sorogo Nomor 1, Cepu, Kab. Blora, Jawa Tengah",
    "(0296) 421888",
    "Air Bersih (Hydrotest Water; Brine Water; Cooling Water; Injection Water), Air Limbah, Udara Ambien, Fuel Oil, Crude Oil, Bensin, Avgas, Avtur, Solar, Biosolar B10, B20, Minyak Bakar, Pelumas, Beton, Tanah Lapangan, Agregat Halus (Pasir) dan Kasar (Kerikil)",
    "29 Desember 2025",
    "",
  ],
  [
    "LP-1447-IDN",
    "Yes",
    "Pertamina Hulu Kalimantan Timur, O &amp; M Laboratory",
    "Lokasi 1: O&amp;M Lab Lawe-lawe, PHKT Lawe-lawe terminal, Penajam Paser Utama, Kalimantan Timur Lokasi 2: O&amp;M Lab Santan, PHKT Santan terminal, Marang Kayu, Kutai Kartanegara, Kalimantan Timur",
    "(0542) 7563166 /085220605036",
    "Minyak bumi, gas alam",
    "29 Desember 2025",
    "",
  ],
  [
    "LP-1448-IDN",
    "Yes",
    "PT Mitra SK Analisa Testama Samarinda",
    "Jl. Padat Karya No. 99, Sempaja, Samarinda",
    "(0541) 7776627",
    "Batubara",
    "29 Desember 2025",
    "",
  ],
  [
    "LP-1449-IDN",
    "Yes",
    "Laboratorium Pengujian Teknik Sipil Fakultas Teknik Universitas Bandar Lampung",
    "Jl. Zainal Abidin Pagar Alam No. 89, Kedaton, Bandar Lampung",
    "0812 71186088",
    "Beton, tanah, baja, aspal",
    "29 Desember 2025",
    "",
  ],
  [
    "LP-1450-IDN",
    "Yes",
    "PT Guna Sukses Inti",
    "Puri Sentra Niaga T3 No. 7, Kembangan Selatan, Kembangan, Jakarta Barat",
    "(021) 29865140",
    "BjKU, BjD, Baja lembaran dan gulungan lapis paduan aluminium-seng, Bj LS, Bj P, baja tulang beton, baja tulang beton dalam bentuk gulungan, baja tulangan beton hasil canai panas ulang, Bj P H-bema, Bj P-beam, Bj P kanal U, Bj P Siku sama kaki, Bj P WF-beam, kawat baja tanpa lapisan dipilin untuk konstruksi beton, kawat baja kuens temper untuk konstruksi beton pratekan, kawat baja tanpa lapiran untuk konstruksi beton pratekan, batang kawat baja karbon rendah, Bj LTE, baja lembaran, pelat dan gulungan canai panas, tali kawat baja, profil rangka baja ringan, cookware dari logam, peralatan makan dan masak dari baja tahan karat",
    "29 Desember 2025",
    "",
  ],
  [
    "LP-1451-IDN",
    "Yes",
    "PT Tri Sakti Purwosari Makmur",
    "Jl. Raya No. 341, Purwosari, Pasuruan, Jawa Timur",
    "(0343) 612334",
    "Rokok putih (SPM), rokok kretek (SKM), filter, ciagarette paper 9CP), cigarette tiping paper (CTP), plugwrap filter, tobacco",
    "29 Desember 2025",
    "",
  ],
  [
    "LP-1452-IDN",
    "Yes",
    "PT Genau Loka Gantari",
    "Jl. Jambangan Kebon Agung No. 12A, Surabaya",
    "(031) 8289707",
    "Air limbah, air sungai, air untuk keperluan higiene sanitasi, air laut, udara ambien, udara lingkungan kerja, kebisingan, iemisi sumber tidak bergerak",
    "29 Desember 2025",
    "",
  ],
  [
    "LP-1453-IDN",
    "Yes",
    "PT Sribangun Buminitya",
    "Commercial Centre Jababeka Shop House No. B-16, pasir Gombong, Cikarang Utara",
    "(021) 8934406",
    "Air limbah, air untuk keperluan higiene dan sanitasi, air sungai, air danau, air waduk, air muara, air mineral, air demineral, air mineral alami, air laut, kebisingan lingkungan, lingkungan kerja, udara ambien, udara emisi sumber tidak bergerak",
    "29 Desember 2025",
    "",
  ],
  [
    "LP-1454-IDN",
    "Yes",
    "Balai Teknologi Bahan Bakar dan Rekayasa Disain - BPPT",
    "Gedung 480 Kawasan Puspiptek, Kota Tangerang Selatan",
    "(021) 7563213",
    "Biodiesel B100, Biodiesel B30, minyak nabati, biomassa/particulate fuel",
    "19 Januari 2026",
    "",
  ],
  [
    "LP-1455-IDN",
    "Yes",
    "PT Binasawit Makmur, Sampoerna Agro",
    "Jl. Basuki Rahmat No. 788, Palembang",
    "(0711) 416111 ; 08117320378; 08117320379",
    "Tanah, jaringan tanaman, pupuk NPK, pupuk urea, MOP, KCl, RP, pupul Kieserite, pupuk Dolomite, pupuk Borate, Pupuk Diammonium Phospat (DAP), Pupuk Amonium sulfat (ZA), pupuk, Copper Sulphate, CPO, air kolam ikan, air kanal/air rawa (untuk irigasi), air sumur (untuk penyiraman di pembibitan), air limbah",
    "19 Januari 2026",
    "",
  ],
  [
    "LP-1456-IDN",
    "Yes",
    "PT Pertamina (Persero), Fuel Terminal Pulau Sambu",
    "Pertamina Pulau Sambu, Pulau Sambu, Kel. Tanjung Sari, Kec. Belakang Padang, Batam",
    "085272270450",
    "Solar/HSD, biosolar (B30), Marine fuel oil (MFO), biodiesel B100 (FAME)",
    "19 Januari 2026",
    "",
  ],
  [
    "LP-1457-IDN",
    "Yes",
    "Fakultas Peternakan Universitas Hasanuddin (UNHAS) - Laboratorium Bioteknologi Terpadu",
    "Jl. Perintis Kemerdekaan KM. 10, Makassar",
    "08124236415",
    "Pakan konsentrat ayam",
    "31 Januari 2026",
    "",
  ],
  [
    "LP-1458-IDN",
    "Yes",
    "Balai Karantina Pertanian Kelas II Cilegon",
    "Jl. Raya Transit Cikuasa Pantai Merak, Cilegon, Banten",
    "(0254) 571807 / 570518",
    "Ulas darah (Sapi, kuda, kerbau), Serum (Sapi, Kerbau, Kambing, Domba), Serum ayam dan bebek, Serum anjing, Daging, Produk olahan daging, dan MBM (Meat Bone Meal), Biji Gandum (Triticum spp), Biji Kedelai (Glycine max), Bungkil kedelai (Glycine max), gandum (Triticum spp), jagung (Zea mays) dan hasil olahan produksinya, Bawang merah (Allium ascalonicum ) dan bawang putih (Allium satium )",
    "31 Januari 2026",
    "",
  ],
  [
    "LP-1459-IDN",
    "Yes",
    "PT Multimas Nabati Asahan - Kuala Tanjung",
    "Acces Road Dusun IV Tanjung Permai, Desa Kualatanjung, Kec.Sei Suka. Kab.Batubara",
    "(0622) 31111",
    "Lemak dan Minyak Nabati: Minyak Kelapa Mentah (CCNO), Minyak Kelapa (RCNO/RHCNO), Lemak Reroti (Shortening), Serbuk Minyak Kelapa Sawit (RHPS /RHPO Flakes), Minyak Kelapa Sawit Mentah (CPO), Minyak Inti Kelapa Sawit Mentah (CPKO), Minyak Inti Kelapa Sawit (RBDPKO), Minyak Kelapa Sawit (R, Minyak Stearin Kelapa Sawit Mentah (CPS), Minyak Olein Kelapa Sawit (RBD Palm Olein), Minyak Olein Kelapa Sawit Mentah (COL)",
    "31 Januari 2026",
    "",
  ],
  [
    "LP-1460-IDN",
    "Yes",
    "PT Pelat Timah Nusantara, Tbk",
    "Jl. Australia I Kav E-1 Kawasan Industri KIEC, Cilegon",
    "(0254) 392353",
    "Tinplate (Baja lembaran tipis lapis timah elektrolisa / Bj LTE)",
    "31 Januari 2026",
    "",
  ],
  [
    "LP-1461-IDN",
    "Yes",
    "UPTD Laboratorium Lingkungan Dinas Lingkungan Hidup Kota Serang",
    "Jl. Raya Petir Km. 4, Cipocok Jaya, Serang, Banten",
    "(0254) 221764",
    "Air sungai, air limbah, air untuk keperluan higiene sanitasi",
    "23 Februari 2026",
    "",
  ],
  [
    "LP-1462-IDN",
    "Yes",
    "PT Detech Profesional Indonesia",
    "Bizpoint Modern Multi Business Point 1, Blok Istanbul No. 16, Kel. Sukamulya, kec. Cikupa, Kab. Tangerang, Banten",
    "(021) 59644285",
    "Material logam dan produk logam (pelat baja, baja karbon rendah, baja karbon menengah, baja karbon tinggi, baja paduan, baja tahan karat, sambungan las), Carbon steel and alloy steel (Ferro Base Metal), Stainless steel Base Metal, Nickel Base Metal, Copper Base Metal, Aluminium Base Metal, Titanium Base Metal, Stainless steel dan nickel base",
    "23 Februari 2026",
    "",
  ],
  [
    "LP-1463-IDN",
    "Yes",
    "PT Mitra SK Analisa Testama Jakarta",
    "Pulo Gadung Trade Center Block 8H No. 7, Jl. Raya bekasi Km. 21, Kawasan Industri, Jakarta Timur, DKI Jakarta",
    "(021) 46801210",
    "Batubara",
    "23 Februari 2026",
    "",
  ],
  [
    "LP-1464-IDN",
    "Yes",
    "Balai Besar Peramalan Organismen Pengganggu Tumbuhan",
    "Jl. Raya Kali Asin Tromol Pos 1, Jatisari, Karawang, Jawa Barat",
    "(0264) 360581",
    "Beauveria bassiana pada media padat (jagung/Zea mays dan beras/Oruza sativa), Isolat kultur yang berasal dari tanaman padi",
    "23 Februari 2026",
    "",
  ],
  [
    "LP-1465-IDN",
    "Yes",
    "UPT Laboratorium Terpadu Universitas Diponegoro",
    "Jl. Prof. Soedarto, SH, Tembalang, Semarang, Jawa Tengah",
    "(024) 76918147 / 7698148",
    "Tepung ikan, air minum dalam kemasan",
    "23 Februari 2026",
    "",
  ],
  [
    "LP-1466-IDN",
    "Yes",
    "UPTD Laboratorium Lingkungan Dinas Perumahan dan Kawasan Permukiman dan Lingkungan Hidup Kabupaten Kebumen",
    "Jl. Ronggowarsito No. 298, Pejagoan, Kebumen, Jawa Tengah",
    "(0821) 37782072",
    "Air sungai, air limbah, air danau, air tanah",
    "23 Februari 2026",
    "",
  ],
  [
    "LP-1467-IDN",
    "Yes",
    "PT Fluida Teknika",
    "Jl. Raya Kebayoran Lama No. 16, Jakarta Selatan, DKI Jakarta",
    "(021) 53678971, 53678972",
    "Produk infus, produk obat injeksi, produk tetes mata steril, filter steril",
    "23 Februari 2026",
    "",
  ],
  [
    "LP-1468-IDN",
    "Yes",
    "PT Anindya Wiraputra Konsult Cabang Pontianak",
    "Jl. Arteri Supadio Gg. Anyar RT 7 RW 10, Kel. Arang Limbung, Kec. Sungai Raya, Kec. Kubu Raya, Kalimantan Barat",
    "(0561) 6710694",
    "Mineral, Bauksit ore, Limestone, soda api",
    "23 Februari 2026",
    "",
  ],
  [
    "LP-1469-IDN",
    "Yes",
    "Komisi Pemberantasan Korupsi - Laboratorium Barang Bukti Elektronik",
    "Gedung Merah Putih, Jl. Kuningan Persada Kav. 4, Setiabudi, Jakarta Selatan, DKI Jakarta",
    "(021) 25578300",
    "Barang bukti elektronik/digital, data digital yang tersimpan dalam sistem elektronik, dan/atau media penyimpanan data elektronik, sistem elektronik dan/atau media penyimpanan data elektronik dalam keadaan rusak dan/atau data tidak dapat diakses, data digital dari hasil akuisisi dan/atau ekstraksi, BBE eksekusi putusan pengadilan dan media penyimpanan data elektronik non BBE untuk menyimpan salinan forensik (Hard Disk, Flash Media), Digital Multimedia (Audio, Video, Gambar)",
    "23 Februari 2026",
    "",
  ],
  [
    "LP-1470-IDN",
    "Yes",
    "PT Asiatrust Technovima Qualiti Cabang Bandung",
    "Pertokoan Tritan Point Rukan, Blok A5 No. 9, Jl. AH Nasution RT 003 RW 02, Cipadung Wetan, Panyileukan, Bandung, Jawa Barat",
    "(022) 63750774",
    "Batubara",
    "23 Februari 2026",
    "",
  ],
  [
    "LP-1471-IDN",
    "Yes",
    "Laboratorium Kimia Biofisik Fakultas Kesehatan Masyarakat Universitas Hasanuddin",
    "Jl. Perintis Kemerdekaan Km.10, Tamalanrea Indah, Makassar, Sulawesi Selatan",
    "(0411) 585658",
    "Biskuit, air untuk keperluan higiene sanitasi",
    "07 Maret 2026",
    "",
  ],
  [
    "LP-1472-IDN",
    "Yes",
    "PT Ganesha Environmental &amp; Energy Services",
    "Jl. Setiabudi No.96, Bandung, Jawa Barat",
    "(022) 82040212",
    "Emisi sumber tidak bergerak",
    "07 Maret 2026",
    "",
  ],
  [
    "LP-1473-IDN",
    "Yes",
    "PT Intertek Utama Services Martabe Project",
    "Jl. Merdeka Barat Km. 2,5, Desa Aek Pining Kec. Batang Toru, Tapanuli, Sumatera Utara",
    "(021) 2938 4454",
    "Mineral batuan dan padatan, air limbah",
    "07 Maret 2026",
    "",
  ],
  [
    "LP-1474-IDN",
    "Yes",
    "PT Indolakto - Central Laboratory",
    "Jl. Raya Bogor Km. 26.6, Gandaria, Jakarta",
    "(021) 8710211",
    "Susu bubuk, Susu Kental Manis ( SKM ), Butter, Susu segar, Susu pasteurisasi (PLM), Susu steril (SCI), Susu UHT, Es krim, Minuman berbasis air berperisa tidak berkarbonat rasa buah (LAB / Low Acid Beverage), Raw material (Sweet Whey Powder ), Susu formula pertumbuhan , Susu steril, susu UHT, susu pasteurisasi, yoghurt, Produk susu",
    "07 Maret 2026",
    "",
  ],
  [
    "LP-1475-IDN",
    "Yes",
    "PT Soilens",
    "Jl. PH. Hasan Mustafa No. 41, Bandung, Jawa Barat",
    "(022) 7272384",
    "Tanah",
    "07 Maret 2026",
    "",
  ],
  [
    "LP-1476-IDN",
    "Yes",
    "PT Trafoindo Prima Perkasa",
    "Lokasi 1: Jl. Siliwangi, RT 06/04, Kel. Alam Jaya, Kec. Jatiuwung, Tangerang, Banten Lokasi 2: Jl. Raya Prabu Siliwangi, RT 001/RW 001, Kel. Gembor, Kec. Periuk, Tangerang, Banten",
    "",
    "Current transformer (CT), Voltage transformer (VT), Transformator, Transformator Oil",
    "07 Maret 2026",
    "",
  ],
  [
    "LP-1477-IDN",
    "Yes",
    "Laboratorium Lingkungan Dinas Lingkungan Hidup Kabupaten Luwu",
    "Jl. Jenderal Sudirman No. 1, Kompleks Perkantoran Pemerintah, Kab. Luwu, Sulawesi Selatan",
    "(0471) 3314003",
    "Air sungai, air limbah",
    "07 Maret 2026",
    "",
  ],
  [
    "LP-1478-IDN",
    "Yes",
    "Laboratorium Sabo, Pusat Penelitian dan Pengembangan Sumber Daya Air",
    "Sopolan, Manguwoharjo, Depok, Sleman, Yogyakarta",
    "(0274) 886350",
    "Agregat, tanah, elevasi air dan gerusan",
    "07 Maret 2026",
    "",
  ],
  [
    "LP-1479-IDN",
    "Yes",
    "PT Cipta Karya Pangan Pasundan",
    "Jl. Dr. Setiabudi No. 193, Bandung, Jawa Barat",
    "(022) 2019433, 2019339",
    "Dodol, Makanan Ringan Berbahan Dasar Kentang, Umbi, Serealia, Tepung atau Pati , Daging, Daging Unggas Dan Daging Hewan Buruan, Yang Dihaluskan, Dan Diolah Dengan Perlakuan Panas, Keik, Kukis dan Pai (Isi Buah atau Custard,Vla), Kopi, Teh, Seduhan Herbal dan Minuman Biji-bijian dan Sereal Panas, minuman berbasis air berperisa",
    "16 Maret 2026",
    "",
  ],
  [
    "LP-1480-IDN",
    "Yes",
    "PT Surveyor Carbon Consulting Indonesia Cabang Muara Teweh",
    "Jl. H. Koyem RT 08, Kab. Barito Utara, Kalimantan Tengah",
    "(0519) 2020598",
    "Batubara",
    "16 Maret 2026",
    "",
  ],
  [
    "LP-1481-IDN",
    "Yes",
    "Laboratorium Biofarmaka Fakultas Farmasi Universitas Hasanuddin",
    "Jl. Perintis Kemerdekaan Km. 10, Tamalanrea, Makassar, Sulawesi Selatan",
    "(0411) 588556",
    "Biji kakao",
    "28 Maret 2026",
    "",
  ],
  [
    "LP-1482-IDN",
    "Yes",
    "UPTD Laboratorium Lingkungan Dinas Lingkungan Hidup Kota Jambi",
    "Jl. Jenderal Basuki Rahmat No. 08, Jambi",
    "(0741) 444015",
    "Air sungai, air limbah, Air danau, air sumur",
    "28 Maret 2026",
    "",
  ],
  ["LP-1483-IDN", "No", "", "", "", "", "", "Nomor tidak digunakan"],
  [
    "LP-1484-IDN",
    "Yes",
    "Laboratorium Penelitian dan Pengembangan Sains FMIPA Universitas Hasanudin",
    "Gedung Sains Terpadu Kampus UNHAS, Tamalanrea, Jl. Perintis Kemerdekaan Km. 10, Makassar",
    "(0411) 586016",
    "Air sumur, air limbah, air sungai, Udara ambien, Air minum dalam kemasan, tanah, Clinker, Daging",
    "28 Maret 2026",
    "",
  ],
  [
    "LP-1485-IDN",
    "Yes",
    "UPTD Balai Pengawasan dan Sertifikasi Benih Tanaman Pangan dan Hortikultura Provinsi Sumatera Selatan",
    "Jl. Kolonel H. Burlian No. 75 Km. 6,5, Taman Sari, Palembang",
    "(0711) 410059",
    "Padi, jagung, bayam",
    "28 Maret 2 026",
    "",
  ],
  [
    "LP-1486-IDN",
    "Yes",
    "Balai Pengujian Material Konstruksi, Dinas Pekerjaan Umum Provinsi Nusa Tenggara Barat",
    "Jl. Majapahit No. 8, Mataram",
    "(0370) 627487",
    "Tanah, agregat, semen, beton, aspal, air sungai, air danau, air sumur, air Mata air, air bendungan, air limbah",
    "28 Maret 2026",
    "",
  ],
  [
    "LP-1487-IDN",
    "Yes",
    "UPTD Balai Pengujian Dinas Pekerjaan Umum Provinsi Jambi",
    "Jl. RB Siagian No. 1, Kel. Pasir Putih, Jambi",
    "(0741) 570077",
    "Aspal keras, koral/batu pecah, tanah, pasir, beton keras (silinder), tanah dasar/subgrade, lapis pondasi agregat, penyelidikan tanah/soil investigation",
    "28 Maret 2026",
    "",
  ],
  [
    "LP-1488-IDN",
    "Yes",
    "PT Corelab Indonesia",
    "Kawasan Industri dan Pergudangan Taman Tekno Blok D No. 19B, Sektor XI, BSD City, Tangerang Selatan, Banten",
    "(021) 80623777",
    "Formation water and produced water, diesel fuel/MGO/solar/biosolar, Minyak Bakar (MFO)/IFO, minyak mentah/crude oil, gas alam",
    "20 April 2026",
    "",
  ],
  [
    "LP-1489-IDN",
    "Yes",
    "UPTD BPSMB Dinas Perindustrian dan Perdagangan Provinsi Sulawesi Tenggara",
    "Jl. Dr. Sam Ratulangi No. 14, Kendari, Sulawesi Tenggara",
    "(0401) 3129386",
    "Kakao, kopra, lada putih, mete kupas, mete gelondong, garam beryodium, beras",
    "20 April 2026",
    "",
  ],
  [
    "LP-1490-IDN",
    "Yes",
    "PT Ecolab International Indonesia",
    "Jl. Pahlawan, Desa Karang Asem Timur, Citeureuo, Bogor, Jawa Barat",
    "(021) 8753175",
    "Air sungai, air tanah",
    "20 April 2026",
    "",
  ],
  [
    "LP-1491-IDN",
    "Yes",
    "Laboratorium Ekologi Universitas Padjajaran",
    "Jl. Sekeloa Selatan No. 1, Bandung, Jawa Barat",
    "(022) 2502176",
    "Air limbah, air sungai, air danau, air untuk keperluan higiene sanitasi",
    "20 April 2026",
    "",
  ],
  [
    "LP-1492-IDN",
    "Yes",
    "PT Insurindo Interservices",
    "Lokasi 1 : Jl. Jenggala No. 1, Kel. Madras, Kec. Medan, Polonia Medan, Sumatera Utara Lokasi 2 : Jl. Jababeka X blok F no.9 Kawasan Industri Jababeka 1 Desa Hajarmekar, Kec. Cikarang utara, Kab. Bekasi Lokasi 3 : Jl. Kol. Syarifudin Yoes no.35 RT 45 Ruko Pelangi Balikpapan Point blok C, kel. Sepinggan Baru, Kec. balikpapan Timur",
    "(061) 4516783 (021) 89832938 (0542) 851393",
    "Lokasi 1: Minyak sawit dan fraksinya, palm kernel expeller",
    "20 April 2026",
    "",
  ],
  [
    "LP-1493-IDN",
    "Yes",
    "UPT Laboratorium Lingkungan Dinas Lingkungan Hidup Kabupaten Bengkalis",
    "Jl. Pertanian, Bengkalis, Riau",
    "082170535770",
    "Air limbah, air sungai, air tanah sumur pantau TPA, air limbah lindi TPA",
    "20 April 2026",
    "",
  ],
  [
    "LP-1494-IDN",
    "Yes",
    "PT Analitika Kalibrasi Laboratorium",
    "Graha Amparan Jati Blok BII No.14 Pakuan Regency Jl. Raya Dramaga Km.7, Kota Bogor, Jawa Barat",
    "(0251) 8473130",
    "Air minum, air minum dalam kemasan, air untuk keperluan higiene dan sanitasi, air sungai, air tanah, air limbah, Sludge TCLP, air laut, Tanah, sludge, sedimen, udara ambien, udara lingkungan kerja, Emisi Sumber Tidak Bergerak, Jaringan / Tissue",
    "02 Mei 2026",
    "",
  ],
  [
    "LP-1495-IDN",
    "Yes",
    "PT Multi Teraindo",
    "Jl. Soekarno Hatta No. 89 RT 03/ RW 04, Kel. Tobek Godang, Kec. Tampan, Pekanbaru, Riau",
    "(0761) 7875200",
    "Air sungai, air waduk , air limbah, udara ambien, kebisingan, emisi sumber tidak bergerak. Emisi sumber bergerak, tanah, TCLP/sludge",
    "02 Mei 2026",
    "",
  ],
  [
    "LP-1496-IDN",
    "Yes",
    "PT Surveyor Indonesia Cabang Medan (multilokasi)",
    "Lokasi 1 :Jl. Sunggal, No. 197 Kel. Tanjung Rejo, Kec. Medan Sunggal, Medan, Sumatera Utara Lokasi 2 : Jl. takari no.17 Kelurahan sukajadi, Kecamatan Dumai Kota, Riau",
    "(061) 42569565",
    "Lokasi 1 : Air sumur, air danau, air limbah, air untuk keperluan higiene sanitasi, air tanah, air laut",
    "02 Mei 2026",
    "",
  ],
  [
    "LP-1497-IDN",
    "Yes",
    "PT Independent Testing Survey Indonesia",
    "Rukan Sedayu Square Blok A No. 18 Jl. Lingkar Luar Barat, Kel. Cengkareng Barat, Kec. Cengkareng, Jakarta Barat, DKI Jakarta",
    "(021) 54396914",
    "Palm kernel, palm oil",
    "02 Mei 2026",
    "",
  ],
  [
    "LP-1498-IDN",
    "Yes",
    "PT Pertamina (Persero) Fuel Terminal Medan Group",
    "Jl. Kl. Yos Sudarso Km 19,5, Kel. Pekan Labuhan, Kec. Medan Labuhan, Medan, Sumatera Utara",
    "(061) 6941846",
    "Premium, pertalite, pertamax, pertamax turbo, solar, biosolar, dexlite, pertamina dex, MFO FAME",
    "02 Mei 2026",
    "",
  ],
  [
    "LP-1499-IDN",
    "Yes",
    "UPTD Pengujian dan Penerapan Mutu Hasil Perikanan, Dinas Kelautan dan Perikanan Provinsi Sumatera Selatan",
    "Jl. Taman Sari II No. 73, Km 6, Palembang, Sumatera Selatan",
    "(0711) 411381",
    "Olahan ikan (pempek, tekwan, model, ikan giling), kerupuk, ikan segar, ikan asin",
    "02 Mei 2026",
    "",
  ],
  [
    "LP-1500-IDN",
    "Yes",
    "Balai Pelaksanaan Jalan Nasional Nusa Tenggara Timur",
    "Jl. Timor Raya Km. 18, Desa Tanah Merah, Kec. Kupang Tengah, Kupang, Nusa Tenggara Timur",
    "0811381135",
    "Beton, agregat kasar, agregat halus",
    "02 Mei 2026",
    "",
  ],
  [
    "LP-1501-IDN",
    "Yes",
    "Balai Besar Perikanan Budidaya Air Payau Jepara",
    "Jl. Cik Lanang, Bulu, Kec. Jepara, Jepara, Jawa Tengah",
    "(0291) 591125",
    "Krustasea, ikan air laut, ikan air tawar, ikan air payau, sedimen, air (air payau, air laut, air tawar), pakan udang/ikan, udang",
    "2 Mei 2026",
    "",
  ],
  [
    "LP-1502-IDN",
    "Yes",
    "Laboratorium Penelitian dan Pengujian Terpadu (LPPT) UGM",
    "Jl. Kaliurang Km. 4, Sekip Utara, Depok, Sleman, Yogyakarta",
    "(0274) 548348",
    "Bakso dan Nugget, Cangkang Kapsul, Ekstrak Herbal, Buah Segar, Minyak Kelapa, VCO, Darah Hewan, Tanah, obat, kosmetik, limbah padat, limbah cair, kimia anorganik, Keju tanpa pemeraman, keju peram, susu bubuk, Susu Cair, Plasma darah , Ekstrak, jamu, kosmetika semi solid dan cair, madu, permen, dan minuman padat dalam sachet (kopi instan, biji kopi), teh , Madu, daging dan produk daging, ikan dan produk perikanan, Jamu, Larutan herbal kandidat obat kumur, Basis gigi tiruan, bahan tumpatan, gigi, logam, Jaringan tumbuhan, jaringan hewan, Serbuk kayu, Isolator Padat, Isolator Cair, Arester, Ekstrak herbal, AMDK, air sungai, Daun, Briket Arang, Minuman Beralkohol, Pupuk Organik padat, Serum Darah Tikus dan Mencit, Sel MC3T3E1, DNA Bakteri, Jaringan &amp; Organ Hewan (hati, ginjal, paru, usus, limpa, dan lidah) Tikus dan Mencit",
    "18 Mei 2026",
    "",
  ],
  [
    "LP-1503-IDN",
    "Yes",
    "PT Adhya Tirta Batam",
    "Kantor WTP DAM Muka Kuning, Jl. Letjend. Soeprapto No. 1, Batam, Kepulauan Riau",
    "(0778) 465566",
    "Air minum, air waduk, air limbah",
    "18 Mei 2026",
    "",
  ],
  ["LP-1504-IDN", "No", "", "", "", "", "", "Nomor tidak digunakan"],
  [
    "LP-1505-IDN",
    "Yes",
    "PT Nippon Indosari Corpindo (Sari Roti)",
    "Jl Selayar Blok A9, Kawasan MM2100, Mekarwangi, Cikarang Barat, Jawa Barat",
    "(021) 89844959",
    "Breadcrumb, roti tawar, roti manis, cake",
    "15 Juni 2026",
    "",
  ],
  [
    "LP-1506-IDN",
    "Yes",
    "PT Sucofindo (Persero) - Laboratorium Cabang Bengkulu",
    "Jl. Re Martadinata No. 37 RT.07, RW.02, Kel. Kandang, Kec. Kampung Melayu, Bengkulu",
    "(0736) 5611644",
    "Batubara",
    "15 Juni 2026",
    "",
  ],
  [
    "LP-1507-IDN",
    "Yes",
    "UPT Laboratorium Lingkugan Dinas Lingkungan Hidup Kabupaten Garut",
    "Jl. Pramuka No. 28, Garut, Jawa Barat",
    "(0262) 236657",
    "Air limbah, air sungai, air untuk keperluan higiene sanitasi",
    "15 Juni 2026",
    "",
  ],
  [
    "LP-1508-IDN",
    "Yes",
    "PT Bumitama Gunajaya Agro - Analytical Laboratory",
    "Jl. Tjilik Riwut Km. 125, Desa Pundu, Kec. Cempaga Hulu, Kab. Kotawaringin Timur, Kalimantan Tengah",
    "(021) 27838200",
    "MOP, RP, TSP, zincopper, copper sulfat, NPK, urea/ammonium chloride, kieserite, dolomite, kaptan, HGF-B, daun, CPO, tanah",
    "15 Juni 2026",
    "",
  ],
  [
    "LP-1509-IDN",
    "Yes",
    "UPTD Laboratorium Lingkungan Dinas Lingkungan Hidup Kabupaten Bengkulu Utara",
    "Jl. Prof. Dr. M. Yamin, SH No. 36, Kab. Bengkulu Utara, Bengkulu",
    "(0737) 521010",
    "Air sungai, air limbah",
    "15 Juni 2026",
    "",
  ],
  [
    "LP-1510-IDN",
    "Yes",
    "UPT Dinas Lingkungan Hidup Kabupaten Rokan Hilir",
    "Jl. Lintas Bagansiapiapi Batu 4, Bagan Punak Meranti Bagansiapiapi, Rokan Hilir, Riau",
    "(0767) 8001415",
    "Air sungai, air sumur, air limbah",
    "15 Juni 2026",
    "",
  ],
  [
    "LP-1511-IDN",
    "Yes",
    "UPT Laboratorium Lingkungan Hidup Kabupaten Muara Enim",
    "Jl. Mayor Tji Agus Kemas, Lintas Kepur, Kabupaten Muara Enim, Sumatera Selatan",
    "(0734) 7420101",
    "Air limbah, air sungai, air danau, air untuk keperluan higiene dan sanitasi",
    "27 Juni 2026",
    "",
  ],
  [
    "LP-1512-IDN",
    "Yes",
    "UPTD Laboratorium Lingkungan Dinas Lingkungan Hidup Kota Tangerang Selatan",
    "Jl. Raya Puspiptek Serpong No. 1, Kec. Setu Kota Tangerang Selatan, Banten",
    "(021) 75675250",
    "Air sungai, air situ, air untuk keperluan higiene sanitasi, air limbah",
    "27 Juni 2026",
    "",
  ],
  [
    "LP-1513-IDN",
    "Yes",
    "Balai Besar Keselamatan dan Kesehatan Kerja Jakarta",
    "Jl. A. Yani No. 69-70, Cempaka Putih, Jakarta Pusat, DKI Jakarta",
    "(021) 4267398",
    "Udara Lingkungan Kerja",
    "27 Juni 2026",
    "",
  ],
  [
    "LP-1514-IDN",
    "Yes",
    "PT Coneval Mitra Indonesia",
    "Taman Palem Lestari, Ruko Fantasi Blok X-1, Jalan Lingkar Luar Barat, Jakarta Barat, DKI Jakarta",
    "(021) 22556973",
    "Beton silinder",
    "20 Juli 2026",
    "",
  ],
  [
    "LP-1515-IDN",
    "Yes",
    "PT Riset Perkebunan Nusantara - Pusat Penelitian Karet",
    "Jl. Raya Palembang - Pangkalan Balai Km. 29, Sembawa, Banyuasin, Sumatera Selatan",
    "(0711) 7439493",
    "Tanah, tanaman, Pupuk, Karet mentah",
    "20 Juli 2026",
    "",
  ],
  [
    "LP-1516-IDN",
    "Yes",
    "Balai Besar Perikanan Budidaya Laut Lampung",
    "Jl. Yos Sudarso Desa Hanura Kec. Teluk Pandan, Lampung",
    "(0721) 4001379",
    "Udang Vannamei, Udang Penaed, Ikan Laut (ikan kakap, ikan kerapu, ikan bawal bintang, ikan kobla, ikan nemo, kuda laut), air laut dan air payau, udang, pakan dan bahan baku pakan",
    "20 Juli 2026",
    "",
  ],
  [
    "LP-1517-IDN",
    "Yes",
    "PT PLN Nusantara Power UPK Punagaya",
    "Desa Punagaya, Kec. Bangkala, Kab. Jeneponto, Sulawesi Selatan",
    "081141503000",
    "Batubara",
    "20 Juli 2026",
    "",
  ],
  [
    "LP-1518-IDN",
    "Yes",
    "PT Seamless Pipe Indonesia Jaya - Laboratorium Tenaris",
    "Krakatau Industrial Estate Cilegon, Jl. Antartika 1 Kav. F4, Cilegon, Banten",
    "(0254) 267672",
    "Baja karbon, baja kromium",
    "20 Juli 2026",
    "",
  ],
  [
    "LP-1519-IDN",
    "Yes",
    "Balai Besar Pengujian Minyak dan Gas Bumi LEMIGAS - Laboratorium Eksplorasi",
    "Jl. Ciledug Raya, Kav. 109, Cipulir, Kebayoran Lama, Jakarta Selatan, DKI Jakarta",
    "(021) 7251413",
    "Percontoh batuan (batuan inti (core)), batuan teras sampling (sidewall core), serbuk bor (cutting), pecontoh permukaan (surface sample), bitumen, minyak bumi",
    "20 Juli 2026",
    "",
  ],
  [
    "LP-1520-IDN",
    "Yes",
    "Balai Besar Survei dan Pengujian Ketenagalistrikan, Energi Baru, Terbarukan, dan Konservasi Energi",
    "Jl. Pendidikan, Kampung Cibarengkok RT04/RW03, Desa Pengasinan, Kecamatan Gunung Sindur, Kabupaten Bogor, Jawa Barat",
    "(021) 8063405051 ; (021) 72798311",
    "Lampu swabalast untuk pelayanan pencahayaan umum - persyaratan keselamatan, Lampu swabalast untuk pelayanan pencahayaan umum - persyaratan unjuk kerja, lampu LED swabalast untuk pelayanan umum dengan ketegangan 50 V - spesifikasi keselamatan, lampu LED swabalast untuk pelayanan umum dengan ketegangan 50 V - persyaratan kinerja, tusuk kontak dan kotak kontak untuk keperluan rumah tangga dan sejenisnya, sakelar untuk instalasi rumah tangga dan instalasi listrik magun dan sejenisn, ya, pemutus-sirkit untuk proteksi arus lebih untuk instalasi rumah tangga dan sejenisnya, penanak nasi",
    "20 Juli 2026",
    "",
  ],
  [
    "LP-1521-IDN",
    "Yes",
    "PT Karyadibya Mahardhika - Laboratorium Chemical",
    "Jl. Raya A. Yani KM. 45, No. 11, Tawangrejo, Pandaan, Kab. Pasuruan, Jawa Timur",
    "(0343) 636706",
    "White cigarettes, kretek cigarettes",
    "20 Juli 2026",
    "",
  ],
  [
    "LP-1522-IDN",
    "Yes",
    "PT Pertamina Hulu Mahakam",
    "Handil II Base Muara Jawa, Kab. Kutai Kertanegara, Kalimantan Timur",
    "085246836523",
    "Gas bumi, crude oil",
    "20 Juli 2026",
    "",
  ],
  [
    "LP-1523-IDN",
    "Yes",
    "PT Minamas Nabati Asahan - Serang",
    "Jl. Raya Bojonegara Km. 5 Kav. 162, Desa Terate, kec. Kramatwatu, Kab. Serang, Banten",
    "(0254) 8495283",
    "Minyak goreng sawit (RBD Palm Oil), minyak stearin kelapa sawit (RBD Palm Stearin), minyak olein kepala sawit (RBD Palm Olein), Refine Kernel Oil (RKO), Refine Kernel Olein (RKL), Refine Kernel Stearin (RKS), Refine Hydrogenated Kernel Oil",
    "20 Juli 2026",
    "",
  ],
  [
    "LP-1524-IDN",
    "Yes",
    "PT Kimia Farma Diagnostika - Equitrust Lab",
    "Jl. Bendungan Hilir Raya No. 60, Jakarta Pusat, DKI Jakarta",
    "08122174119",
    "Plasma Darah Manusia",
    "20 Juli 2026",
    "",
  ],
  [
    "LP-1525-IDN",
    "Yes",
    "UPT Laboratorium Kesehatan Kota Tangerang",
    "Jl. TMP Taruna No. 1, Kel. Suka Asih, Kec. Tangerang, Kota Tangerang, Banten",
    "(021) 5588737",
    "Swab nasopharyngeal and oropharyngeal, Air sungai, Air limbah, Air minum, Air untuk keperluan higiene dan sanitasi, Minuman teh dalam kemasan, Roti, Nata de coco dalam kemasan, Naget ayam, Garam, Madu, Keripik tempe, Es krim, Minuman sari buah, Saus cabe, Bakso ikan, Mie basah, Kerupuk , Bakso daging, Tahu, Jelly, Kecap kedelai, Minuman tradisional, Sirup, Minuman isotonik , Cairan flavor ekstra tanaman, buah dalam kemasan, produk fermentasi tumbuhan : minuman dan minuman beralkohol, saos, kecap, cuka, jamu, obat cair, propolis, yogurt, susu, probiotik, pembersih mulut, Daging (daging segar, daging variasi segar, daging beku, daging kering, daging cincang), produk olahan daging (daging fermentasi, daging kornet, daging marinasi, daging asap, tepung daging, kaldu daging, dendeng, abon, sosis, bakso, nugget, burger) mie instan, pasta, bumbu",
    "20 Juli 2026",
    "",
  ],
  [
    "LP-1526-IDN",
    "Yes",
    "Balai Karantina Ikan, Pengendalian Mutu dan Keamanan Hasil Perikanan Jayapura",
    "Jl. Pasir No. 06, Sentani, Jayapura",
    "(0967) 593462",
    "Ikan air laut (tuna, tongkol, cakalang, kakap, bandeng, udang putih, udang tiger, cumi-cumi, salmon), ikan air tawar (ikan nila, lele, patin, komet, koki, koi, mas), crustacea, kepiting, lobster, rajungan, ikan segar/beku (nila, mas, lele, kembung, layang, tuna loin)",
    "1 Agustus 2026",
    "",
  ],
  [
    "LP-1527-IDN",
    "Yes",
    "Dinas Lingkungan Hidup Kabupaten Katingan",
    "Komplek Perkantoran Kereng Humbang, Jl. MT. Haryono Kasongan Kab. Katingan, Kalimantan Tengah",
    "(0536) 4043543",
    "Air limbah, air minum, air sungai, Air Untuk Keperluan Higiene &amp; Sanitasi",
    "24 Agustus 2026",
    "",
  ],
  [
    "LP-1528-IDN",
    "Yes",
    "PT Eksperta Adi Manusa",
    "Ruko Boulevard Tekno G15, Jl. Raya Tekno Widya, Kel. Setu, Kec. Setu, Kota Tangerang Selatan, Banten",
    "(021) 75673577 08118876 667",
    "Udara emisi sumber tidak bergerak",
    "24 Agustus 2026",
    "",
  ],
  [
    "LP-1529-IDN",
    "Yes",
    "PT Dynapack Indonesia - Central Laboratory",
    "Dynaplast Cikarang II, Jababeka Industrial Estate, Jawa Barat",
    "(021) 8934011",
    "Produk Packaging (Cap, botol plastik)",
    "24 Agustus 2026",
    "",
  ],
  [
    "LP-1530-IDN",
    "Yes",
    "PT Alas Emas Abadi - Laboratorium Kesehatan Lingkungan, Dept. Public Health and Malaria Control (PHMC)",
    "Jl. Kertajasa Kuala Kencana, Mimika, Papua",
    "(0901) 463254",
    "Nyamuk Anopheles ssp., air minum, air untuk keperluan higiene sanitasi, air kolam renang, air limbah, air sumur, air danau, air sungai, air muara, air rawa, air akuifer, air situ, air mata air, air waduk, usap permukaan (swab): peralatan makan, lantai, kontak tangan",
    "24 Agustus 2026",
    "",
  ],
  [
    "LP-1531-IDN",
    "Yes",
    "UPTD Rumah Sakit Hewan dan Laboratorium Veteriner",
    "Jl. Wisata Lelede, Kec. Kediri, Kab. Lombok Barat, Nusa Tenggara Barat",
    "(0370) 622658",
    "Serum sapi, serum kerbau, serum ayam, feses sapi/kerbau/kambing, daging dan produk olahannya (dendeng, bakso, sosis, nuget), telur (ayam dan itik), daging dan telur segar (ayam dan itik), preparat ulas darah",
    "24 Agustus 2026",
    "",
  ],
  [
    "LP-1532-IDN",
    "Yes",
    "PT Sanghiang Perkasa",
    "Kawasan Industri Indotaisei, Sektor 1A Block Q2 Desa Kalihurip, Kec. Cikampek, Kab. Karawang, Jawa Barat",
    "(0264) 8302120/22",
    "Susu bubuk, bubur, susu cair, biskuit, keripik, sereal olahan, air minum, air minum dalam kemasan, MP ASI Biskuit, MP ASI Bubuk Instant (Bubur Instan), Keripik / Chip, Lemak dan Minyak Nabati, Lemak Susu Anhidrat (AMF), Premix Vitamin, Susu Fermentasi dan Produk Susu Fermentasi",
    "21 September 2026",
    "",
  ],
  [
    "LP-1533-IDN",
    "Yes",
    "PT Lestari Banten Energi",
    "Desa Salira, Kab. Serang, Banten",
    "(0254) 2252130",
    "Batubara",
    "21 September 2026",
    "",
  ],
  ["LP-1534-IDN", "No", "", "", "", "", "", "Nomor Akreditasi dicabut"],
  [
    "LP-1535-IDN",
    "Yes",
    "Laboratorium Lingkungan Dinas Lingkungan Hidup Kabupaten Wonosobo",
    "Jl. S. Parman 159, Wonosobo, Jawa Tengah",
    "(0286) 324056",
    "Air limbah",
    "21 September 2026",
    "",
  ],
  [
    "LP-1536-IDN",
    "Yes",
    "UPTD Laboratorium Lingkungan Dinas Lingkungan Hidup Kabupaten Batang Hari",
    "Jl. Sultan Thaha, Kel. Rengas Condong, Kec. Muara Bulian, Kab. Batang Hari, Jambi",
    "",
    "Air sungai, air limbah",
    "21 September 2026",
    "",
  ],
  [
    "LP-1537-IDN",
    "Yes",
    "PT Tribhakti Inspektama Cabang Kendari",
    "Jl. Brigjen Katamso, Kel. Baruga, Kec. Baruga, Kendari, Sulawesi Tenggara",
    "(0401) 3094755",
    "Bijih Nikel",
    "21 September 2026",
    "",
  ],
  [
    "LP-1538-IDN",
    "Yes",
    "PT Toyo Lab Indonesia",
    "Jl. Poin Mas Raya No.2, RT 004/RW 009, Kel. Mampang, Kec. Pancoran Mas, Depok, Jawa Barat",
    "(021) 77805007",
    "Udara emisi sumber tidak bergerak, udara emisi sumber bergerak",
    "21 September 2026",
    "",
  ],
  [
    "LP-1539-IDN",
    "Yes",
    "Balai Besar Penangkapan Ikan",
    "Jl. Yos Sudarso Kalibaru Barat Tanjung Emas, Bandarharjo, Semarang Utara, Kota Semarang, Jawa Tengah",
    "(024) 3583065 ; 0895375636688",
    "Benang jaring penangkap ikan, jaring penangkap ikan, Motor kapal perikanan berbahan bakar minyak (BBM), Motor kapal perikanan berbahan bakar gas (BBG)",
    "3 Oktober 2026",
    "",
  ],
  [
    "LP-1540-IDN",
    "Yes",
    "UPTD Laboratorium Bahan Konstruksi Dinas Bina Marga dan Bina Konstruksi Provinsi Lampung",
    "Jl. Z.A. Pagar Alam KM.11 Rajabasa Bandar Lampung",
    "(0721) 702684",
    "Beton silinder, beton, agregat kasar, agregat halus",
    "3 Oktober 2026",
    "",
  ],
  [
    "LP-1541-IDN",
    "Yes",
    "UPT Laboratorium Konstruksi dan Unit Pemeliharaan Rutin Jalan/Alat Berat, Dinas Pekerjaan Umum Kabupaten Kutai Timur",
    "Jl. Dinas Kawasan Pusat Pemerintahan Bukit Pelangi, Sangatta, Kutai Timur, Kalimantan Timur",
    "(052) 2029442",
    "Agregat halus dan kasar, tanah, beton, beton silinder",
    "3 Oktober 2026",
    "",
  ],
  [
    "LP-1542-IDN",
    "Yes",
    "PT Mitra Stania Prima",
    "Kawasan Industri dan Pelabuhan Jelitik, Sungailiat, Kab. Bangka, Provinsi Kepulauan Bangka Belitung",
    "(0717) 92350, 96016 (hunting)",
    "Logam timah (kadar pengotor), pasir timah (ore)",
    "26 Oktober 2026",
    "",
  ],
  [
    "LP-1543-IDN",
    "Yes",
    "Petrogas (Basin) Limited - Laboratorium Arar",
    "Arar Marine Terminal - Sorong, Papua Barat",
    "(0951) 321959/322460",
    "Air limbah",
    "26 Oktober 2026",
    "",
  ],
  [
    "LP-1544-IDN",
    "Yes",
    "PT Pertamina Gas Operation West Java Area",
    "Jl. Raya Industri Cikarang Tegalgede, Bekasi, Jawa Barat",
    "(021) 89833854",
    "Gas alam",
    "26 Oktober 2026",
    "",
  ],
  [
    "LP-1545-IDN",
    "Yes",
    "UPT Laboratorium Lingkungan Dinas Lingkungan Hidup Kota Lubuklinggau",
    "Jl. Perbakin No. 02, Komplek Perkantoran Kayuara, Kec. Lubuklinggau Barat 1, Kota Lubuklinggau, Sumatera Selatan",
    "(0733) 326769",
    "Air limbah, air sungai, air waduk, air untuk keperluan higiene dan sanitasi",
    "26 Oktober 2026",
    "",
  ],
  [
    "LP-1546-IDN",
    "Yes",
    "Fakultas Perikanan dan Ilmu Kelautan, Universitas Sam Ratulangi \x{2013} Laboratorium Pengujian Produk Perikanan dan Kelautan",
    "Jl. Kampus Unsrat, Bahu, Manado, Sulawesi Utara",
    "(0431) 868027",
    "Ikan segar, ikan dan produk perikanan (siap makan dan beku)",
    "26 Oktober 2026",
    "",
  ],
  [
    "LP-1547-IDN",
    "Yes",
    "PT Bumi Ventila Indonesia",
    "Kampung Gedong RT 004/RW 001 Desa Benteng, Kec. Ciampea, Kab. Bogor, Jawa Barat",
    "(0251) 8422353",
    "Tanah, udara ambient, udara lingkungan kerja, air sungai, air limbah, air untuk keperluan higiene dan sanitasi",
    "7 November 2026",
    "",
  ],
  [
    "LP-1548-IDN",
    "Yes",
    "UPT Laboratorium Lingkungan Dinas Lingkungan Hidup Kabupaten Pesisir Selatan",
    "Jl. Makam Pahlawan Sago, Kec. IV Jurai, Kab. Pesisir Selatan, Sumatera Barat",
    "(0756) 21509",
    "Air sungai, air limbah",
    "7 November 2026",
    "",
  ],
  [
    "LP-1549-IDN",
    "Yes",
    "PT Jasa Mutu Mineral Indonesia Cabang Kendari",
    "Jl. R. Suprapto RT 010 RW 004, Kel. Tobuuha, Kec. Puuwatu, Kendari, Sulawesi Tenggara",
    "(0401) 3420483",
    "Nickel ore",
    "23 November 2026",
    "",
  ],
  [
    "LP-1550-IDN",
    "Yes",
    "Centre of Advance Science and Technology (C-DAST) Universitas Jember",
    "Jl. Kalimantan No. 37, Kampus Bumi Tegal Boto, Kotak Pos 159, Jember, Jawa Timur",
    "(033) 321825",
    "Pupuk NPK Padat, tepung terigu, Biskuit",
    "23 November 2026",
    "",
  ],
  [
    "LP-1551-IDN",
    "Yes",
    "UPTD Laboratorium Lingkungan Dinas Lingkungan Hidup Kabupaten Merangin",
    "Jl. Pemuda Kel. Pematang Kandis, Bangko, Kab. Merangin, Jambi",
    "(0746) 322381",
    "Air sungai",
    "23 November 2026",
    "",
  ],
  ["LP-1552-IDN", "No", "", "", "", "", "", "Nomor akreditasi dicabut"],
  [
    "LP-1553-IDN",
    "Yes",
    "PT Indonesia Power - PLTU Barru Operation and Maintenance Services Unit",
    "Dusun Bawasalo, Lampoko, Kec. Balusu, Kab. Barru, Sulawesi Selatan",
    "(021) 52676666",
    "Batubara",
    "23 November 2026",
    "",
  ],
  [
    "LP-1554-IDN",
    "Yes",
    "PT Penilai Standar Nasional",
    "Jl. Cipinang Muara 1, No. 21, R 006/RW 003, Kel. Pondok Bambu, Kec. Duren Sawit, Jakarta Timur, DKI Jakarta",
    "(021) 8602367",
    "Peralatan masak (cookware) dari logam, peralatan makan dan perlengkapan masak dari baja tahan karat (stainless steel flatware), Pupuk SP 36, Pupuk Fosfat Alam Untuk Pertanian, Pupuk Kalium Klorida, Pupuk Triple Super Fosfat (TSP), Pupuk NPK Padat, Pupuk Amonium Sulfat (ZA), Pupuk Urea",
    "23 November 2026",
    "",
  ],
  [
    "LP-1555-IDN",
    "Yes",
    "PT Geoservices Kendari",
    "Jl. Poros Bandara Haluoleo, Desa Onewila, Kec. Ranoometo, Kab. Konawe Selatan, Kendari, Sulawesi Tenggara",
    "082196022776",
    "Mineral nikel (nikel ore)",
    "23 November 2026",
    "",
  ],
  [
    "LP-1556-IDN",
    "Yes",
    "UPTD Laboratorium Pengujian Mutu dan Keamanan Pangan - Dinas Ketahanan Pangan Kota Medan",
    "Jl. Budi Pembangunan No. 3, Pulo Brayan, Medan, Sumatera Utara",
    "(061) 6614224",
    "Wortel, cabe merah, mie kuning, tahu, bakso, manisan mangga madu, manisan pepaya, minuman es jagung, beras",
    "5 Desember 2026",
    "",
  ],
  [
    "LP-1557-IDN",
    "Yes",
    "PT Penta Sinergi Azima",
    "Kinan City Blok G, No. 10, Kel. Pakansari, Kec. Cibinong, Kab. Bogor, Jawa Barat",
    "(021) 83724685",
    "Lingkungan kerja",
    "5 Desember 2026",
    "",
  ],
  [
    "LP-1558-IDN",
    "Yes",
    "UPTD Laboratorium Lingkungan Hidup Kabupaten Banyumas",
    "Jl. Warga Bakti No. 3, Kel. Purwekerto Lor, Kec. Purwokerto Timur, Kab. Banyumas, Jawa Tengah",
    "(0281) 637036",
    "Air limbah, air sungai, air embung/air danau",
    "5 Desember 2026",
    "",
  ],
  [
    "LP-1559-IDN",
    "Yes",
    "UPTD Laboratorium Lingkungan Dinas Lingkungan Hidup dan Pengelolaan Sampah Kabupaten Brebes",
    "Jl. Jend. Sudirman No. 163, Kabupaten Brebes, Jawa Tengah",
    "(0283) 671522",
    "Air limbah, air sungai",
    "5 Desember 2026",
    "",
  ],
  [
    "LP-1560-IDN",
    "Yes",
    "UPTD Laboratorium Lingkungan Dinas Lingkungan Hidup Kota Payakumbuh",
    "Jl. Anggrek I No. 24, Komplek Terminal Koto Nan IV, Kel. Bulakan Balai Kandi, Kota Payakumbuh, Sumatera Barat",
    "(0752) 94496",
    "Air minum, air higiene sanitasi, air kolam renang, air limbah domestik, air limbah industri, air sungai, air sumur",
    "5 Desember 2026",
    "",
  ],
  [
    "LP-1561-IDN",
    "Yes",
    "PT Indominco Mandiri",
    "Jl. Poros Bontang-Samarinda Km. 10, Kec. Teluk Panda, Kab. Kutai Timur, Kalimantan Timur",
    "(0548) 26235",
    "Batubara",
    "21 Desember 2026",
    "",
  ],
  [
    "LP-1562-IDN",
    "Yes",
    "PT Nugen Bioscience Indonesia",
    "Jl. Parangtritis Raya Blok A-5E No. 12, Ancol, Jakarta Utara, DKI Jakarta",
    "(021) 6919999",
    "Pakan, air minum",
    "21 Desember 2026",
    "",
  ],
  [
    "LP-1563-IDN",
    "Yes",
    "UPT Laboratorium Kesehatan Hewan dan Kesehatan Masyarakat Veteriner Provinsi Kalimantan Tengah",
    "Jl. Tjilik Riwut Km. 3,5, Palangka Raya, Kalimantan Tengah",
    "(0536) 4262802",
    "Otak anjing, serum darah sapi",
    "21 Desember 2026",
    "",
  ],
  [
    "LP-1564-IDN",
    "Yes",
    "PT Mahardhika Aurora Sinergi",
    "Jl. Yasir Hadibroto, Komplek Bank Indonesia No. 14, Kel. Tanjunggading, Kec. Kedamaian, Bandarlampung, Lampung",
    "(0721) 6015273",
    "Arang tempurung kelapa, arang kayu, briket arang kayu",
    "21 Desember 2026",
    "",
  ],
  [
    "LP-1565-IDN",
    "Yes",
    "UPTD Laboratorium Lingkungan Dinas Lingkungan Hidup Kabupaten Kolaka",
    "Jl. Pemuda No.130, Kel. Laloeha, Kab. Kolaka, Sulawesi Tenggara",
    "(0405) 232196",
    "Air permukaan (air sungai, air sumur, air danau), air limbah, kebisingan",
    "21 Desember 2026",
    "",
  ],
  [
    "LP-1566-IDN",
    "Yes",
    "PT Solusi Bangun Andalas",
    "Jl. Banda Aceh Meulaboh Km. 17, Lhoknga, Banda Aceh, Aceh",
    "(0651) 7550001",
    "Semen portland",
    "21 Desember 2026",
    "",
  ],
  [
    "LP-1567-IDN",
    "Yes",
    "PT Sri Intan Perkasa",
    "Ruko Harapan Indah Blok EN No. 7, 8 dan 15, Kota Bekasi, Jawa Barat",
    "(021) 88984397",
    "Pesawat sinat X Radiografi Umum, Pesawat sinat X Radiografi Mobile, Pesawat sinat X Intra Oral, Pesawat sinat X Ekstra Oral (Panoramik &amp; Cephalometrik)",
    "21 Desember 2026",
    "",
  ],
  [
    "LP-1568-IDN",
    "Yes",
    "PT Ceria Nugraha Indotama",
    "Desa Samaenre-Ponre, Kec. Wolo, Kab Kolaka, Sulawesi Tenggara",
    "(021) 22769324",
    "Nickel Laterite Ore",
    "21 Desember 2026",
    "",
  ],
  [
    "LP-1569-IDN",
    "Yes",
    "UPTD Laboratorium Lingkungan Kabupaten Bantaeng",
    "Jl. A. Mannappiang, Kompleks Perkantoran, Kab. Bantaeng, Sulawesi Selatan",
    "085214856123",
    "Air sungai, air waduk, air untuk keperluan higiene dan sanitasi, air limbah, air laut",
    "21 Desember 2026",
    "",
  ],
  [
    "LP-1570-IDN",
    "Yes",
    "PT Indo Borneo Inspeksi Services - Laboratorium Palembang",
    "Jl. Tembus Terminal Alang-alang Lebar, Komplek Pergudangan, Kel. Alang-alang Lebar Palembang, Sumatera Selatan",
    "08127100205",
    "Batubara, Nikel Ore",
    "21 Desember 2026",
    "",
  ],
  [
    "LP-1571-IDN",
    "Yes",
    "Stasiun Karantina Pertanian Kelas I Sumbawa Besar",
    "Jl. Pelabuhan Badas No. 1, Sumbawa Besar, Nusa Tenggara Barat",
    "(0371) 2629152",
    "Serum (sapi, kerbau), ulas darah (sapi, kerbau, kambing, kuda), spesimen lalat buah",
    "21 Desember 2026",
    "",
  ],
  [
    "LP-1572-IDN",
    "Yes",
    "PT Pertamina Fuel Terminal Maumere",
    "Jl. Nairoa KM.4, Ds. Tanaduen, Kec. Kangae, Sikka Flores, Nusa Tenggara Timur",
    "",
    "Premium, Pertalite, Pertamax, Pertamax Turbo, Solar, Biosolar, Dexlite, Pertamina Dex, MFO, MDF, Avtur",
    "2 Januari 2027",
    "",
  ],
  [
    "LP-1573-IDN",
    "Yes",
    "Balai Pengawas Obat dan Makanan di Gorontalo",
    "Jl. Tengah Toto Selatan, Kab. Bone Bolango, Gorontalo",
    "(0435) 822052",
    "Terapetik dan Napza, obat tradisional, kosmetik, pangan, mikrobiologi (obat tradisional, obat,suplemen kesehatan, kosmetik)",
    "2 Januari 2027",
    "",
  ],
  [
    "LP-1574-IDN",
    "Yes",
    "UPTD Penerapan Mutu Hasil Perikanan Dinas Kelautan dan Perikanan Lampung",
    "Jl. P. Emir M. Noer No. 5, Teluk Betung, Bandar Lampung, Lampung",
    "(0721) 488128",
    "Udang beku, lobster, cum/sotong, Ikan beku, bekicot beku, bekicot kaleng, Kepiting/ rajungan (segar dan kaleng), kerang, bekicot, pakan ikan, Produk olahan perikanan (breaded,crab cake,Pempek,Kerupuk ikan,abon ikan,bandeng presto, bandeng cabut duri, bakso ikan, ikan asin), Ikan giling, Rumput laut, Kerupuk Ikan, Abon Ikan, cangkang rajungan, udang beku, ikan beku, rajungan kaleng, ikan dalam kaleng, pempek, Ikan segar, produk olahan perikanan (Ikan asin, ikan kering, terasi)",
    "2 Januari 2027",
    "",
  ],
  [
    "LP-1575-IDN",
    "Yes",
    "PT PJB UBJOM PLTU Tenayan",
    "Jl. Ringroad 70, RT 4 RW 2, Kel. Tenayan Raya, Kota Pekanbaru, Riau",
    "082244828200",
    "Batubara",
    "18 Januari 2027",
    "",
  ],
  [
    "LP-1576-IDN",
    "Yes",
    "PT Atmos Laboratorium Indonesia",
    "Ruko Green Valley Soho, Blok A2, No. 1, Desa Sukamantri, Kec. Taman Sari, Kab. Bogor, Jawa Barat",
    "(0251) 8481227",
    "Air sumur, air sungai, air untuk keperluan higiene dan sanitasi, air limbah, air laut, udara ambien, lingkungan kerja, lingkungan kerja, kebisingan, emisi sumber tidak bergerak",
    "18 Januari 2027",
    "",
  ],
  [
    "LP-1577-IDN",
    "Yes",
    "PT Mane Indonesia",
    "Lokasi 1: Jl. Jababeka XVI Blok V-66, Kawasan Industri Jababeka, Cikarang, Desa Pasir Gembong, Cikarang Utara, Jawa Barat Lokasi 2: Jl. Selayar Blok A-8, Kawasan Industri MM2100, Desa Mekarwangi, Cikarang Barat - Bekasi, Jawa Barat Lokasi 3: Kawasan Industri Indotaisei Sektor IA Blok K4 Kalihurip, Cikampek, Karawang, Jawa Barat",
    "(021) 8937639",
    "Perisa bubuk, bumbu cair, bumbu bubuk, perisa bubuk non vanilla, perisa bubuk vanilla, Lingkungan udara, Swab lingkungan dan peralatan (peralatan, laboratorium, personil, uniform, fasiltas pabrik)",
    "30 Januari 2027",
    "",
  ],
  [
    "LP-1578-IDN",
    "Yes",
    "PT Sinarmas Bio Energy - Marunda",
    "Kawasan Industri dan Pergudangan Blok D No.1 Marunda Center, Tarumajaya, Kab. Bekasi, Jawa Barat",
    "(021) 88991121",
    "Fatty Acid Methyl Esters (FAME)",
    "30 Januari 2027",
    "",
  ],
  [
    "LP-1579-IDN",
    "Yes",
    "Program Studi DIII Kesehatan Lingkungan Kampus Magetan - Laboratorium Uji Lingkungan",
    "Jl. Tripandita No. 6, Magetan, Jawa Timur",
    "(0351) 895215",
    "Air limbah, air bersih, air sungai, air waduk, air minum",
    "30 Januari 2027",
    "",
  ],
  [
    "LP-1580-IDN",
    "Yes",
    "Laboratorium Pengujian Teknologi Informasi dan Komunikasi \x{2013} BRIN",
    "Gedung Teknologi Informasi Komunikasi dan Elektronika - BRIN Lantai 2, Kawasan PUSPIPTEK - Serpong, Tangerang Selatan, Banten",
    "(021) 75791272",
    "Pembaca kartu cerdas nirkontak, kartu cerdas nirkontak, kartu cerdas kontak, alat kesehatan (ECG, vital sign monitor, USG), perangkat yang berpotensi mengeluarkan harmonisa nda flicker, perangkat multimedia (notebook, access point, computer monitor, TV)",
    "30 Januari 2027",
    "",
  ],
  [
    "LP-1581-IDN",
    "Yes",
    "PT Tempo Research - Laboratorium Pengembangan Analisa",
    "Kawasan Industri Ejip Plot 1H, Lemah Abang, Cikarang, Jawa Barat",
    "(021) 89677004/5",
    "Minuman kesehatan serbuk, minuman kesehatan liquid, minuman kesehatan effevescent",
    "30 Januari 2027",
    "",
  ],
  [
    "LP-1582-IDN",
    "Yes",
    "UPTD Laboratorium Bahan Konstruksi, Dinas Bina Marga dan Penataan Ruang Provinsi Jawa Barat",
    "Jl. A.H. Nasution No. 117, Ujung Berung, Bandung, Jawa Barat",
    "(022) 63734300",
    "Campuran beraspal, benda uji inti campuran beraspal, agregat kasar dan halus, aspal",
    "30 Januari 2027",
    "",
  ],
  [
    "LP-1583-IDN",
    "Yes",
    "UPTD Laboratorium Kesehatan Sleman",
    "Jl. Kalimantan Gang Ambalat, Purwosari, Sinduadi, Kec. Mlati, Kab. Sleman, DI Yogyakarta",
    "(0274) 884226",
    "Makanan ringan (berbahan dasar kentang, umbi, serealia, tepung atau pati, olahan kacang, makana ringan berbasis ikan), nasi olahan sayur, lauk hewani, minuman teh, air untuk keperluan higiene sanitasi dan air minum",
    "22 Februari 2027",
    "",
  ],
  [
    "LP-1584-IDN",
    "Yes",
    "PDAM Tirtanadi Provinsi Sumatera Utara",
    "Jl. Sisingamangaraja No. 1, Medan, Sumatera Utara",
    "(061) 4571 666 ext. 555",
    "Air minum, air sungai, air danau, air mata air, air sumur dan air tanah",
    "22 Februari 2027",
    "",
  ],
  [
    "LP-1585-IDN",
    "Yes",
    "PT Bukaka Teknik Utama (multilokasi)",
    "Lokasi 1: Jl. Raya Narogong - Bekasi KM 19,5, Kec. Cileungsi, Kab. Bogor, Jawa Barat Lokasi 2: Jl. Raya Bojonegara KM. 19, Desa Ragas Grenanyang, Argawana, Kec. Pulo Ample, Serang, Banten",
    "(021) 8232323",
    "Logam, baja dan produk baja, struktur tower transmisi",
    "22 Februari 2027",
    "",
  ],
  [
    "LP-1586-IDN",
    "Yes",
    "UPTD Balai Laboratorium Kesehatan Provinsi Bali",
    "Jl. Angsoka No. 12, Denpasar, Bali",
    "(0361) 221698",
    "Air limbah, air minum, air untuk keperluan higiene sanitasi (air tanah)",
    "22 Februari 2027",
    "",
  ],
  [
    "LP-1587-IDN",
    "Yes",
    "PT AICE Ice Cream Jatim Industry",
    "Kawasan Industri Ngoro Industrial Park (NIP) Kavling D3B, Jarang Sari, Kutogirang, Kec. Ngoro, Mojokerto, Jawa Timur",
    "081217602709",
    "Makanan pencuci mulut berbahan dasar susu (es krim, es susu), es untuk dimakan (Edible Ice /Es Stik), susu bubuk dan krim bubuk, buah olahan, tepung, air minum",
    "22 Februari 2027",
    "",
  ],
  [
    "LP-1588-IDN",
    "Yes",
    "Fakultas Kesehatan Masyarakat, Universitas Diponegoro - Laboratorium Keselamatan dan Kesehatan Kerja",
    "Jl. Prof Soedarto, Kampus FKM Undip, Tembalang, Semarang, Jawa Tengah",
    "(024) 7460044",
    "Lingkungan kerja",
    "22 Februari 2027",
    "",
  ],
  [
    "LP-1589-IDN",
    "Yes",
    "UPTD Laboratorium Lingkungan Dinas Lingkungan Hidup Kabupaten Tulungagung",
    "Jl. Sultan Agung III No. 7, Ketanon, Kec. Kedungwaru, Kab. Tulungagung, Jawa Timur",
    "(0355) 5250445",
    "Air limbah, air sungai, air mata air, air waduk, air sumur pantau",
    "22 Februari 2027",
    "",
  ],
  [
    "LP-1590-IDN",
    "Yes",
    "PT Geoservices Pangkep",
    "Jl. Lempangan, Desa Bowong Cindea, Kab. Pangkep, Sulawesi Selatan",
    "08119465350",
    "Batubara",
    "22 Februari 2027",
    "",
  ],
  [
    "LP-1591-IDN",
    "Yes",
    "PT Indofood CBP Sukses Makmur - Nutrition and Special Foods Division",
    "Jl. Raya Caringin No. 353, Padalarang, Bandung Barat, Jawa Barat",
    "(022) 6868210, 6809815 ext. 229",
    "Makanan bayi, susu bubuk ibu hamil/menyusui, dan biskuit",
    "22 Februari 2027",
    "",
  ],
  [
    "LP-1592-IDN",
    "Yes",
    "PT Citrabuana Indoloka",
    "Lokasi 1: Jl. Wolter Monginsidi, Poros Bandara, Kel. Ranomeeto, Kab. Konawe Selatan, Sulawesi Tenggara Lokasi 2: Jl. Politeknik II, Kel. Kalragi Dua, kec. Mapanget, Kodya Manado, Sulawesi Utara Lokasi 3: Jl. Raya Bogor KM. 28, RT. 004/07, Pasar Rebo, Kel. Pekayon, Kec. Pasar Rebo, Jakarta Timur, DKI Jakarta",
    "081119220653",
    "Lokasi 1: Nickel Laterite Ore Extended Suite (Exploration and Production)",
    "22 Februari 2027",
    "",
  ],
  [
    "LP-1593-IDN",
    "Yes",
    "PT Sucofindo (Persero) - Laboratorium Cabang Timika",
    "Jl. Kuala Kuningan Kav. D1-Light Industrial Park, Kuala Kencana, Timika, Papua",
    "(0901) 301951",
    "Konsentrat tembaga, batuan eksplorasi mineral tembaga, beton kubus, beton silinder, baja",
    "22 Februari 2027",
    "",
  ],
  [
    "LP-1594-IDN",
    "Yes",
    "PT Unilab Perdana Cabang Surabaya",
    "Kompleks Ruko Section One, Blok B-3, Jl. Rungkut Industri Raya No. 1, SIER, Surabaya, Jawa Timur",
    "(031) 8415839",
    "Air limbah, air sungai, air minum, udara ambien, kebisingan, getaran, lingkungan kerja, udara emisi sumber tidak bergerak, udara emisi sumber bergerak",
    "22 Februari 2027",
    "",
  ],
  [
    "LP-1595-IDN",
    "Yes",
    "UPTD Laboratorium Lingkungan Dinas Lingkungan Hidup Kabupaten Kutai Kartanegara",
    "Jl. KH. Ahmad Dahlan, Sukarame, Tenggarong, Kutai Kartanegara, Kalimantan Timur",
    "(0541) 661169",
    "Air sungai, air limbah",
    "8 Maret 2027",
    "",
  ],
  [
    "LP-1596-IDN",
    "Yes",
    "PT The Master Steel Manufactory (Multilokasi)",
    "Lokasi: Jl. Raya Bekasi KM.21, Rawa Terate, Cakung, Jakarta Timur, DKI Jakarta Lokasi 2: Jl. Alpha Maspion, Blok L &amp; M, KIM, Suko Mulyo, Manyar, Gresik, Jawa Timur",
    "(021) 4606188 / (031) 3952936",
    "Baja tulangan beton sirip, baja tulangan beton polos, baja karbon",
    "8 Maret 2027",
    "",
  ],
  [
    "LP-1597-IDN",
    "Yes",
    "Balai Karantina Ikan, Pengendalian Mutu dan Keamanan Hasil Perikanan Mataram",
    "Jl. Adi Sucipto, Kel. Pejarakan Karya, Kec. Ampenan, Mataram, Nusa Tenggara Barat",
    "(0370) 6194701",
    "Ikan kerapu, lobster, kepiting , udang vanname, kakap segar, cakalang segar, cumi-cumi segar, udang segar, baronang segar, kerapu segar, layang segar, tongkol segar, lemuru segar,gurita segar, kepiting segar, bulubabi segar, kerang segar, tuna segar, kakak tua segar, abalone segar, kerapu beku, cakalang beku, udang beku, kerapu beku, tongkol beku, kakap beku, gurita beku, tuna beku, udang windu, ikan mas, ikan koi, ikan mas koki, ikan kurisi segar, ikan kembung segar, ikan bawal bintang segar, ikan kuwe segar, ikan amberjack segar, ikan barongan segar.",
    "8 Maret 2027",
    "",
  ],
  [
    "LP-1598-IDN",
    "Yes",
    "PT Preformed Line Products Indonesia",
    "Jl. Irian VII Blok MM2100, Cikarang Barat, Bekasi, Jawa Barat",
    "(021) 85933899",
    "Insulator Set Fitting and Earth Wire Fitting, Suspension Clamp Tension Fittings, Tension Joint &amp; Tension Clamps, Repair Sleeve, Insulator Protective Fitting (Arching Horn), Insulator Protective Fitting (Vibration Damper), Spacer Damper, Flexible Spacer, and Rigid Spacer, Insulator Pin, Helical Fitting (Anchor &amp; Support Fitting), Aluminium",
    "8 Maret 2027",
    "",
  ],
  [
    "LP-1599-IDN",
    "Yes",
    "PT Cheil Jedang Indonesia - Jombang Plant",
    "Jl. Raya Brantas KM 3,4, Desa Jatigedong, Kec. Ploso, Kab. Jombang, Jawa Timur",
    "(0321) 887700",
    "L-Arginine",
    "15 Maret 2027",
    "",
  ],
  [
    "LP-1600-IDN",
    "Yes",
    "UPT Laboratorium Kesehatan Kabupaten Serang",
    "Jl. Palka Palima, Desa Sindangsari, Kec. Pabuaran, Kab. Serang, Banten",
    "(0254) 250814",
    "Air untuk keperluan higiene dan sanitasi, air minum, air limbah, peralatan makan (piring, sendok, garpu, mangkok, gelas, nampan), air mineral dan air demineral",
    "15 Maret 2027",
    "",
  ],
  [
    "LP-1601-IDN",
    "Yes",
    "PT PLN (Persero) Unit Induk Pembangkitan Sumatera Bagian Utara - Unit Pelaksana Pembangkitan Nagan Raya",
    "Jl. Meulaboh - Tapak Tuan Km 8,5, Nagan Raya, Aceh",
    "",
    "Batubara",
    "15 Maret 2027",
    "",
  ],
  [
    "LP-1602-IDN",
    "Yes",
    "PT Intim Harmonis Foods Industri",
    "Jl. Raya Jombor Bawah KM. 53, Lemahbang, Sukorejo, Kab. Pasuruan, Jawa Timur",
    "(0343) 634835",
    "Tepung terigu, biskuit, minyak goreng, Baker's fat, sirup glukosa",
    "15 Maret 2027",
    "",
  ],
  [
    "LP-1603-IDN",
    "Yes",
    "UPTD Laboratorium Kesehatan Provinsi Jawa Barat",
    "Jl. Sederhana No. 3-5, Bandung, Jawa Barat",
    "(022) 2033517",
    "Air limbah, air permukaan (air sungai), air bersih, air minum dan air kolam renang, air minum, air bersih, air limbah, udara, makanan hasil olahan siap saji (nasi, lauk, sayur) dan minuman (teh)",
    "15 Maret 2027",
    "",
  ],
  [
    "LP-1604-IDN",
    "Yes",
    "PT Bumitangerang Mesindotama",
    "Jl. Dipati Unus No. 30, Cibodas, Tangerang, Banten",
    "(021) 5585870",
    "Cocoa bean, cocoa liquor, cocoa butter, cocoa cake, cocoa powder",
    "15 Maret 2027",
    "",
  ],
  [
    "LP-1605-IDN",
    "Yes",
    "UPT Laboratorium Kesehatan Hewan Kabupaten Gunung Kidul",
    "Jl. Wonosari-Yogya Km 6,5, Jamburejo, Bandung, Playen, Gunungkidul, DI Yogyakarta",
    "'082137113282",
    "Darah dan serum sapi, kambing, dan domba, darah dan serum ayam",
    "15 Maret 2027",
    "",
  ],
  ["LP-1606-IDN", "No", "", "", "", "", "", "Nomor tidak digunakan"],
  [
    "LP-1607-IDN",
    "Yes",
    "Cenre for Drug Evaluation and Analysis (CDEA) Fakultas Farmasi Universitas Surabaya",
    "Jl. Raya Kalirungkut, Surabaya, Jawa Timur",
    "(031) 2981110",
    "Air sungai, batuan",
    "15 Maret 2027",
    "",
  ],
  [
    "LP-1608-IDN",
    "Yes",
    "Kedeputian Bidang Infrastruktur Riset dan Inovasi - Direktorat Pengelolaan Laboratorium, Fasilitas Riset, dan Kawasan Sains - Laboratorium Pengujian Teknologi Bahan Galian Nuklir - BRIN",
    "Jl. Lebakbulus Raya 9, Pasar Jumat, Jakarta Selatan, DKI Jakarta",
    "(021) 7691775",
    "Batuan, mineral, serbuk, bahan nuklir, dan larutan radioaktif, padat dan cairan anorganik",
    "28 Maret 2027",
    "",
  ],
  [
    "LP-1609-IDN",
    "Yes",
    "UPTD Laboratorium Lingkungan Dinas Lingkungan Hidup Kota Palangka Raya",
    "Jl. Cilik Riwut Km 2.5, Palangkaraya, Kalimantan Tengah",
    "(0536) 3239764",
    "Air limbah",
    "28 Maret 2027",
    "",
  ],
  [
    "LP-1610-IDN",
    "Yes",
    "PT Alfa Delta Ceprindo",
    "Green Sedayu Bizpark Cakung, Blok GS8, No. 17A, Jl. Cakung Cilincing Timur Raya KM. 2, DKI Jakarta",
    "081217698250",
    "Ubin keramik, tableware, kloset duduk, kaca lembaran, kaca pengaman diperkeras untuk kendaraan bermotor, kaca pengaman berlapis (laminated glass) untuk kendaraan bermotor, kaca cermin lembaran untuk penggunaan umum / cermin kaca lembaran berlampis aluminium, cermin kaca lembaran berlapis perak",
    "28 Maret 2027",
    "",
  ],
  [
    "LP-1611-IDN",
    "Yes",
    "Balai Karantina Ikan Pengendalian Mutu dan Keamanan Hasil Perikanan Jakarta II",
    "Jl. Swasemabada Timur XII No. 64, Tanjung Priok, Jakarta Utara, DKI Jakarta",
    "(021) 43903634",
    "Salmon (salmonidae), carp (Cyprinus sp), Sidat ( Anguilla sp), Katak (Rana sp), Nila (Oreochromis niloticus), Catfish (Clarias sp) Brook trout (Salvelinus fontinalis), Brown trout (Salmo trutta), Rainbow trout (Oncorhynchus mykiss) Cod (Gadus morhua), Chanel catfish (Pangasius spp), Eel (Anguilla spp), Salmon (Salmonid), Nila (Oreochromis niloticus), Carp (Cyprinus carpio), Clarias spp, Goldfish (Carasius auratus), dan Gurami (Osphronemus gouramy), Ikan mas, arwana (ikan hias air tawar), Oyster, shell, Kelompok Crustacea perairan khususnya Decapoda (Udang, Kepiting, Crayfish, Lobster) yang hidup di laut, payau dan air tawar, Udang, Kepting Blue shrimp (Penaeus stylirostris), Giant tiger prawn (Penaeus monodon), Greasyback shrimp (Metapenaeus ensis), Northern brown shrimp (Penaeus aztecus), Northern white shrimp (Penaeus setiferus), Whiteleg shrimp (Litopenaeus vannamei), Common carp (Cyprinus carpio), Crucian carp, Koi carp hybrids, Crucian carp Common carp Goldfish (Carassius auratus), Goldfish Common carp hybrids, Goldfish Koi carp hybrids, Asian sea bass (Lates calcarifer), Atlantic cod (Gadus morhua)Cobia (Rachycentron canadum), Guppy ( Poecilia reticulata) ,red snapper (Lutjanus sp)Nile tilapia (Oreochromis niloticus), Milkfish (Chanos chanos), Nile tilapia (Oreochromis niloticus), Alaska pollock (Theragra chalcogramma), Atlantic cod (Gadus morhua)Atlantic salmon (Salmo salar) Brown trout (Salmo trutta), Coho salmon (Oncorhynchus kisutch), mackerel,Turbot (Scophthalmus maximus), Common carp (Cyprinus carpio) ,Goldfish (Carassius auratus) Grass carp (Ctenopharyngodon idella), Guppy (Poecilia reticulata), Koi carp (Cyprinus carpio), Salmon, Trout, Ikan air payau: udang vannamei, udang windu",
    "28 Maret 2027",
    "",
  ],
  [
    "LP-1612-IDN",
    "Yes",
    "Balai Besar Pengujian Standar Instrumen Bioteknologi dan Sumber Daya Genetik Pertanian (BBPSI Biogen)",
    "Jl. Tentara Pelajar 3A, Bogor, Jawa Barat",
    "(0251) 8337975",
    "Akar, batang, daun, buah atau biji tanaman (jagung dan produk turunannya, kedelai dan produk turunannya), tanaman dan benih (padi, jagung, beras, kedelai, tomat, mangga, manggis, terung, kecap, kacang-kacangan, anggrek, sorgum, gandum)",
    "28 Maret 2027",
    "",
  ],
  [
    "LP-1613-IDN",
    "Yes",
    "Dinas Lingkungan Hidup Kabupaten Lumajang",
    "Jl. Langsep No. 15, Lumajang, Jawa Timur",
    "(0334) 888031",
    "Air sungai, air limbah, air tanah",
    "19 April 2027",
    "",
  ],
  [
    "LP-1614-IDN",
    "Yes",
    "UPT Pengawasan dan Sertifikasi Benih Perkebunan Dinas Perkebunan Provinsi Jawa Timur",
    "Jl. Pondok Maritim No. 5, Balas Klumprik, Wiyung, Surabaya, Jawa Timur",
    "(031) 7670939",
    "Tembakau",
    "19 April 2027",
    "",
  ],
  [
    "LP-1615-IDN",
    "Yes",
    "UPTD Balai Pengembangan Teknologi dan Sumber Daya Tuah Sakato, Dinas Peternakan dan Kesehatan Hewan Provinsi Sumatera Barat",
    "Jl. Riau No. 15, Kel. Ibuh, Kec. Payakumbuh Barat, Sumatera Barat",
    "(0752) 93545",
    "Semen beku sapi, semen beku kerbau",
    "19 April 2027",
    "",
  ],
  [
    "LP-1616-IDN",
    "Yes",
    "PT Kilang Pertamina Internasional Refinery Unit II Dumai - Laboratory Engineering and Developtment",
    "Jl. Kilang Putri Tujuh, Dumai, Riau",
    "(0765) 442241",
    "LPG, Green Coke, Premium",
    "19 April 2027",
    "",
  ],
  [
    "LP-1617-IDN",
    "Yes",
    "PT Seafood Inspection Laboratory",
    "Jl. Bedugul No. 37B, Sidakarya, Denpasar Selatan, Bali",
    "(0361) 4484924",
    "Ikan beku, ikan segar, ikan tuna, ikan kakap, ikan kerapu, Chepalopoda, ikan lemuru, udang, swab VTM produk perikanan dan kemasan dalamnya, air bersih, air minum, air limbah",
    "19 April 2027",
    "",
  ],
  [
    "LP-1618-IDN",
    "Yes",
    "Balai Pengujian Standar Instrumen Tanaman Pemanis dan Serat",
    "Jl. Raya Karangploso Km. 4, Kab. Malang, Jawa Timur",
    "(0341) 491447",
    "Benih tembakau, benih kapas, benih jarak kepyar, benih kenaf, benih jarak pagar, benih wijen, benih kenaf",
    "19 April 2027",
    "",
  ],
  [
    "LP-1619-IDN",
    "Yes",
    "Balai Karantina Ikan, Pengendalian Mutu dan Keamanan Hasil Perikanan Manado",
    "Kompleks Pelabuhan Perikanan Samudera Bitung, Kel. Aertembaga I, Kec. Aertembaga, Kota Bitung, Sulawesi Utara",
    "(0431) 814628",
    "Ikan mas, ikan nila, tuna, ikan tongkol, cakalang, selar, ikan lele, ikan koi, capungan banggai, ikan mujair, ikan hias air laut, lobster air laut, kepiting, udang, ikan kerapu, air sumur, es, ikan kaleng",
    "19 April 2027",
    "",
  ],
  [
    "LP-1620-IDN",
    "Yes",
    "UPTD Laboratorium Lingkungan Dinas Lingkungan Hidup Kabupaten Blora",
    "Jl. Gunung Wilis No. 24, Kab. Blora, Jawa Tengah",
    "(0296) 5298523",
    "Air sungai, air higiene dan sanitasi",
    "19 April 2027",
    "",
  ],
  [
    "LP-1621-IDN",
    "Yes",
    "Balai Laboratorium Kesehatan, Pengujian dan Kalibrasi Provinsi Nusa Tenggara Barat",
    "Jl. Catur Warga No. 9, Mataram, Nusa Tenggara Barat",
    "(0370) 784918",
    "Air sungai dan sejenisnya, air danau dan sejenisnya, mata air, air sumur bor, air sumur gali, air untuk keperluan higiene sanitasi, air limbah, air hemodialisa",
    "19 April 2027",
    "",
  ],
  [
    "LP-1622-IDN",
    "Yes",
    "Fakultas Teknik Universitas Diponegoro",
    "Jl. Prof. Soedarto, SH, Tembalang, Semarang, Jawa Tengah",
    "(024) 7460053",
    "Air untuk keperluan higiene dan sanitasi, air limbah",
    "19 April 2027",
    "",
  ],
  [
    "LP-1623-IDN",
    "Yes",
    "PERUMDA Air Minum Kota Padang",
    "Jl. Penjernihan Utama No. 1, Gunung Pangilun, Padang Utara, Kota Padang, Sumatera Barat",
    "08116619804",
    "Air permukaan (air sungai, air mata air), air bersih (air perpipaan)",
    "19 April 2027",
    "",
  ],
  [
    "LP-1624-IDN",
    "Yes",
    "PT Triyasa Pirsa Utama - Laboratorium Kendari",
    "Jl. Poros Bandara Haluoleo No. 99, RT. 05, DSN. III, Desa Onewila, Kec. Ranomeeto, Kab. Konawe Selatan, Kendari, Sulawesi Tenggara",
    "081312111903",
    "Batubara, nikel ore",
    "19 April 2027",
    "",
  ],
  [
    "LP-1625-IDN",
    "Yes",
    "Laboratorium Integrated Terminal BBM Panjang, PT Pertamina Patra Niaga",
    "Jl. Sumatera Pelabuhan Panjang No. 01, Panjang, Bandar Lampung, Lampung",
    "(0721) 31207",
    "MFO 180, solar, biosolar, pertamina Dex, Dexlite, FAME, premium, pertalite, pertamax\\",
    "19 April 2027",
    "",
  ],
  [
    "LP-1626-IDN",
    "Yes",
    "UPTD Balai Laboratorium Kesehatan dan Pengujian Alat Kesehatan Dinas Kesehatan Aceh",
    "Jl. Tgk. H. Mohd. Daud Beureueh No. 168, Banda Aceh, Aceh",
    "(0651) 23834",
    "Air minum, air untuk keperluan higiene dan sanitasi, air limbah, air sungai dan air danau",
    "19 April 2027",
    "",
  ],
  [
    "LP-1627-IDN",
    "Yes",
    "UPTD Balai Pelayanan Kesehatan Hewan, Kesehatan Masyarakat Veteriner dan Klinik Hewan Provinsi Jambi",
    "Jl. Lingkar Barat KM 12 No. 78, Kota Baru, Jambi",
    "08127413539",
    "Feses (sapi, kerbau, kambng, domba), preparat ulas darah (sapi, kerbau, kmanbing, domba), serum (sapi, kerbau, kambing), daging (sapi), telur (ayam), susu (sapi) serta hasil olahannya (bakso sapi), daging ayam",
    "19 April 2027",
    "",
  ],
  [
    "LP-1628-IDN",
    "Yes",
    "Balai Pelaksanaan Jalan Nasional Sulawesi Tengah",
    "Kompleks Pergudangan, Jl. Soekarno Hatta, Kel. Layana Indah, Kec. Mantikulore, Kota palu, Sulawesi Tengah",
    "(0451) 425611",
    "Aspal, beton, tanah, agregat",
    "27 April 2027",
    "",
  ],
  [
    "LP-1629-IDN",
    "Yes",
    "PT Hydrocore",
    "Kompleks Pilar Mas Ruko No. 12, 13 dan 14, Jl. K.H Ahmad Dahlan, Tangerang Selatan, Banten",
    "(021) 7426115",
    "Tanah, tanah/pasir/batuan, tanah/pasir",
    "27 April 2027",
    "",
  ],
  [
    "LP-1630-IDN",
    "Yes",
    "Laboratorium Pengujian Minyak Isolasi Trafo PT PLN (Persero) UIT - JBT",
    "Lokasi 1: Jl. Moh. Toha, Bandung, Jawa Barat Lokasi 2: Jl. Brigjen Darsono No. 198, Cirebon, Jawa Barat Lokasi 3: Jl. Jend. Sudirman, Ungaran, Semarang, Jawa Tengah",
    "(022) 5201723",
    "Minyak trafo pakai",
    "27 April 2027",
    "",
  ],
  [
    "LP-1631-IDN",
    "Yes",
    "PT Triyasa Pirsa Utama - Laboratorium Banjarbaru",
    "Jl. Ahmad Yani KM 21,5, Landasan Ulin Utara, Banjarbaru, Kalimantan Selatan",
    "085247536526",
    "Batubara, Silika",
    "27 April 2027",
    "",
  ],
  [
    "LP-1632-IDN",
    "Yes",
    "PT Triyasa Pirsa Utama - Laboratorium Samarinda",
    "Jl. Pangeran Suryanata RT. 15, Kel. Bukit Pinang, Kec. Samarinda Ulu, Kota Samarinda, Kalimantan Timur",
    "081347425006",
    "Batubara, Nikel ore",
    "27 April 2027",
    "",
  ],
  [
    "LP-1633-IDN",
    "Yes",
    "UPTD Pengawas dan Sertifikasi Mutu Benih Provinsi Kepulauan Bangka Belitung",
    "Jl. Raya Pangkalpinang - Muntok Km.8 Desa Kace, Kec. Mendo Barat, Bangka Belitung, Kepulauan Riau",
    "081373158490",
    "Jagung, padi",
    "24 Mei 2027",
    "",
  ],
  [
    "LP-1634-IDN",
    "Yes",
    "PT Honda Prospect Motor",
    "Jl. Mitra Utara II Kawasan Industri Mitra Karawang, Jawa Barat",
    "(0267) 440777",
    "Kendaraan bermotor",
    "24 Mei 2027",
    "",
  ],
  [
    "LP-1635-IDN",
    "Yes",
    "PT Cipta MandiriTeknik",
    "Perum Pondok Ungu Permai Blok LL2 No. 15 Jl. Kenanga,Kaliabang Tengah, Bekasi Utara, Kota Bekasi, Jawa Barat",
    "081384572993",
    "Biological Safety Cabinet",
    "24 Mei 2027",
    "",
  ],
  [
    "LP-1636-IDN",
    "Yes",
    "UPTD Laboratorium Bahan Konstruksi Dinas Bina Marga, Cipta Karya dan Tata Ruang Provinsi Sumatera Barat",
    "Jl. Taman Siswa No. 1, Padang, Sumatera Barat",
    "(0751) 7051700",
    "Beton silinder, beton kubus, beton",
    "24 Mei 2027",
    "",
  ],
  [
    "LP-1637-IDN",
    "Yes",
    "UPTD Balai Perbenihan, Pengawasan dan Sertifikasi Benih Pertanian Provinsi Gorontalo",
    "Jl. Prof. DR. Aloe Saboe Desa Toto Selatan, Kec. Kabila, Kab. Bone Bolango, Gorontalo",
    "085240735018",
    "Padi, kedelai, jagung, cabe",
    "24 Mei 2027",
    "",
  ],
  [
    "LP-1638-IDN",
    "Yes",
    "PT Indo Energy Solutions",
    "Jl. Bayur Atas, Campang Raya, Kec. Tanjung Karang Timur, Bandar Lampung, Lampung",
    "(0721) 5615097",
    "Palm Oil Mill Effluent (POME), Crude Palm Oil (CPO)",
    "24 Mei 2027",
    "",
  ],
  [
    "LP-1639-IDN",
    "Yes",
    "UPTD Laboratorium Konstruksi Dinas Sumber Daya Air dan Bina Marga Provinsi Sulawesi Tenggara",
    "Jl. S. Parman No. 1A, Kendari, Sulawesi Tenggara",
    "(0401) 3124046",
    "Beton, beton silinder, aspal, tanah, agregat kasar dan halus",
    "24 Mei 2027",
    "",
  ],
  [
    "LP-1640-IDN",
    "Yes",
    "PT Halqilab Karya Indonesia",
    "Komplek Ruko Bubulak No. 11, Jl. KH. Abdullah Bin Nuh, Bogor Barat, Kota Bogor, Jawa Barat",
    "(0251) 8474536",
    "Air limbah, air minum, air untuk keperluan higiene dan sanitasi, udara ambien, kebisingan, industrial hygiene, udara emisi sumber tidak bergerak",
    "24 Mei 2027",
    "",
  ],
  [
    "LP-1641-IDN",
    "Yes",
    "Laboratorium Terpadu Universitas Negeri Padang",
    "Jl. Prof. Dr. Hamka, Air Tawar, Padang, Sumatera Barat",
    "(0751) 7058692",
    "Baja tulangan beton, beton silinder, logam dan paduan logam, batubara",
    "24 Mei 2027",
    "",
  ],
  [
    "LP-1642-IDN",
    "Yes",
    "Laboratorium Sentral Universitas Muhammadaiyah Malang Kampus 3 UMM",
    "Jl. Raya Tlogomas No. 246, Malang, Jawa Timur",
    "(0341) 464318",
    "Bahan paka asal hewan, bahan pakan asal tumbuhan, bahan pakan hijauan, pakan ternak ruminansia, pakan ternak non ruminansia, ekstrak hortikultura, ekstrak umbi",
    "24 Mei 2027",
    "",
  ],
  ["LP-1643-IDN", "No", "", "", "", "", "", "Nomor tidak digunakan"],
  [
    "LP-1644-IDN",
    "Yes",
    "Balai Pengawasan Pengujian Mutu dan Sertifikasi Benih Tanaman Pertanian (BP2STP) Dinas Pertanian Provinsi Maluku Utara",
    "Desa Kusu, Kec. Oba Utara Sofifi, Kota Tidore, Kepulauan Provinsi Maluku Utara",
    "082190203886",
    "Padi, kedelai, jagung",
    "24 Mei 2027",
    "",
  ],
  [
    "LP-1645-IDN",
    "Yes",
    "Dinas Pekerjaan Umum dan Penataan Ruang Kabupaten Tulungagung",
    "Jl. Raya Tulungagung - Blitar KM 6 +350, Sumbergempol, Kab. Tulungagung, Jawa Timur",
    "(0355) 322605",
    "Beton silinder, beton kubus, beton, mortar, bata beton (paving block), aspal, agregat kasar, agregat halus",
    "24 Mei 2027",
    "",
  ],
  [
    "LP-1646-IDN",
    "Yes",
    "Perum Jasa Tirta I",
    "Lokasi 1: Jl. Surabaya No. 2A, Malang, Jawa Timur Lokasi 2: Desa lengkong, Kec. Mojoanyar, Kab. Mojokerto, Jawa Timur Lokasi 3: Jl Raya Kartasura KM7, Pabelan, Surakarta, Kab. Sukoharjo, Jawa Tengah",
    "Lokasi 1: (0341) 551971 Lokasi 2: (0321) 331860 Lokasi 3: (0271) 7469176",
    "Lokasi 1 dan 2: Air sungai, air waduk, air limbah, air bersih dan air minum, air minum dalam kemasan, udara ambien, kebisingan",
    "24 Mei 2027",
    "",
  ],
  [
    "LP-1647-IDN",
    "Yes",
    "PT Kurita Indonesia",
    "Jl. Jababeka XII A, Kav. 6, Cikarang, Bekasi, Jawa Barat",
    "(021) 8936245",
    "Air sungai, air keperluan higiene dan sanitasi",
    "24 Mei 2027",
    "",
  ],
  [
    "LP-1648-IDN",
    "Yes",
    "Bidang Laboratorium Forensik (BIDLABFOR) Polda Papua",
    "Jl. Jeruk Nipis IV, No. 4, Kotaraja, Abepura, Jayapura, Papua",
    "(0967) 5572686",
    "Raw Material (identifikasi methampetamine), daun-daun kering, batang dan biji",
    "24 Mei 2027",
    "",
  ],
  [
    "LP-1649-IDN",
    "Yes",
    "UPTD Balai Laboratorium Lingkungan Dinas Lingkungan Hidup dan Kehutanan Provinsi Nusa Tenggara Barat",
    "Jl. Majapahit No. 56A, Mataram, Nusa Tenggara Barat",
    "(0370) 7506904",
    "Air sungai, air keperluan higiene dan sanitasi",
    "24 Mei 2027",
    "",
  ],
  [
    "LP-1650-IDN",
    "Yes",
    "UPTD Laboratorium Lingkungan Dinas Lingkungan Hidup Kota Banjarmasin",
    "Jl. Sultan Adam Komplek Mandiri II RT 28, Banjarmasin Utara, Kalimantan Selatan",
    "(0511) 4323349",
    "Air sungai, air limbah",
    "21 Juni 2027",
    "",
  ],
  [
    "LP-1651-IDN",
    "Yes",
    "PT Akalab Mahardika Indonesia",
    "Jl. Raya Jogja-Solo Ruko Kalitirto Square No. B9-10, Berbah, Sleman, DI Yogyakarta",
    "082225303509",
    "Air sungai",
    "21 Juni 2027",
    "",
  ],
  [
    "LP-1652-IDN",
    "Yes",
    "PT Sariwiguna Binasentosa",
    "Jl. Ketapang Kawasan Industri Kel. Air Mawar Kec. Bukit Intan, Pangkalpinang, Kepulauan Bangka Belitung",
    "(0717) 4262398",
    "Logam timah (Tin Ingot)",
    "21 Juni 2027",
    "",
  ],
  [
    "LP-1653-IDN",
    "Yes",
    "UPTD Pengujian Mutu Produk Peternakan Dinas Peternakan dan Kesehatan Hewan Provinsi Sulawesi Selatan",
    "Jl. Daeng Ngeppe No. 12, Makassar, Sulawesi Selatan",
    "(0411) 868678",
    "Bahan asal hewan (daging sapi, daging ayam, susu sapi, telur ayam), pakan (unggas, sapi, babi) dan bahan pakan asal tumbuhan, bahan pakan hewan, bahan asal hewan (daging sapi, daging ayam) dan olahannya (bakso, sosis, dan nugget)",
    "21 Juni 2027",
    "",
  ],
  [
    "LP-1654-IDN",
    "Yes",
    "PT Selatan Jadi Jaya",
    "Jl. Raya Panjunan No. 8 Panjuna Sukodono, Sidoarjo, Jawa Timur",
    "(031) 7873183, 7860012",
    "Aki kendaraan bermotor roda empat atau lebih, aki kendaraan bemotor kategori L",
    "21 Juni 2027",
    "",
  ],
  [
    "LP-1655-IDN",
    "Yes",
    "PT Pramatek Andal Analitika",
    "Jl. Dr. Ratna No. 108 A, Jatikramat Jati Asih, Bekasi, Jawa Barat",
    "(021) 22106968",
    "Air bersih, air limbah, air sungai, udara ambien, kebisingan, udara lingkungan kerja, kualitas udara dalam ruang, air minum, darah",
    "21 Juni 2027",
    "",
  ],
  [
    "LP-1656-IDN",
    "Yes",
    "PT Indopangan Sentosa - Laboratorium QA &amp; QC",
    "Jl. Tlajung Udik No. 28, Gunung Putri, Bogor, Jawa Barat",
    "(021) 86722828, 8672830",
    "Saus emulsi (mayonaise, salad dressing), saus non emulsi (saus cabe, saus tomat), cuka makan",
    "21 Juni 2027",
    "",
  ],
  [
    "LP-1657-IDN",
    "Yes",
    "PT Andini Sarana",
    "Jl. Rawa Sumur III Blok DD No. 11, Kawasan Industri Pulogadung, Jakarta Timur, DKI Jakarta",
    "(021) 4610515",
    "Pesawat Sinar-X Dental Intra Oral, Pesawat Sinar-X Dental Extra Oral (Panoramic/Chepalometric)",
    "21 Juni 2027",
    "",
  ],
  [
    "LP-1658-IDN",
    "Yes",
    "PT Kilang Pertamina Internasional Refinery Unit IV Cilacap",
    "Jl. MT Haryono 77, Lomanis, Kab. Cilacap, Jawa Tengah",
    "(0282) 5088230",
    "Avtur/Jet A-1, Gasoline Series (Premium, Pertalite, Pertamax), Solar 48, Marine Fuel Oil (MFO), Asphalt, Slack Wax, Lube Base Oil (HVI 60, HVI 95, HVI 160 S, HVI 650), Minarex, Paraffinic Oil, LPG, Benzene, Paraxylene, Propylene, Air Limbah",
    "21 Juni 2027",
    "",
  ],
  [
    "LP-1659-IDN",
    "Yes",
    "Stasiun Karantina Ikan Pengendalian Mutu dan Keamanan Hasil Perikanan Merak",
    "Jl. Raya Tol Merak Km. 01, No. 01, Pelabuhan Penyebrangan Merak, Banten",
    "(0254) 573266, 5732309",
    "Udang Penaeid",
    "21 Juni 2027",
    "",
  ],
  [
    "LP-1660-IDN",
    "Yes",
    "UPTD Laboratorium Lingkungan Dinas Perumahan Rakyat, Kawasan Permukiman dan Lingkungan Hidup Kabupaten Ciamis",
    "Jl. Baru Komplek Perkantoran Kertasari, Kabupaten Ciamis, Jawa Barat",
    "(0265) 7578871",
    "Air sungai, air danau/air situ, air limbah",
    "21 Juni 2027",
    "",
  ],
  [
    "LP-1661-IDN",
    "Yes",
    "Sekolah Tinggi Teknologi Warga Surakarta - Laboratorium Pengujian Logam",
    "Jl. Raya Solo - Baki No. Km.2, Dayung, Kwarasan, Kec. Grogol, Sukoharjo, Jawa Tengah",
    "(0271) 621176, 621178",
    "Material logam(ferro dan non ferro)",
    "3 Juli 2027",
    "",
  ],
  [
    "LP-1662-IDN",
    "Yes",
    "Laboratorium Fuel Terminal Tenau - PT Pertamina Patra Niaga",
    "Jl. Yos Sudarso No. 1, Kec. Alak, Kab. Kupang, Nusa Tenggara Timur",
    "081322172221",
    "Premium, pertalite, pertamax, soalr, biosolar, dexlite, pertamina dex, FAME, avtur, kerosene",
    "3 Juli 2027",
    "",
  ],
  [
    "LP-1663-IDN",
    "Yes",
    "PT Synergy Oil Nusantara",
    "Jl. Raya Pelabuhan Kabil, Km. 12,5 Kabil, Batam, Kepulauan Riau",
    "(0778) 711171",
    "Crude Palm Oil (CPO). RBD Palm Oil, RBD Palm Stearin, RBD Palm Olein (Cooking Oil)",
    "3 Juli 2027",
    "",
  ],
  [
    "LP-1664-IDN",
    "Yes",
    "PT Mengniu Dairy Indonesia",
    "Jl. Kawasan Industri Terpadu Indonesia China, Kav. 72, GIIC, Kota Deltamas Nagasari, Serang Baru, Kab. Bekasi, Jawa Barat",
    "(021) 25555801",
    "Susu fermentasi dan produk susu fermentasi, susu bubuk dan krim bubuk",
    "3 Juli 2027",
    "",
  ],
  [
    "LP-1665-IDN",
    "Yes",
    "Bidang Laboratorium Forensik (BIDLABFOR) Polda Riau",
    "Jl. Sisingamangaraja No. 48, Rintis Lima Puluh, Pekanbaru, Riau",
    "(0761) 865001",
    "Narkoba (kristal, tablet, bong, daun ganja kering)",
    "3 Juli 2027",
    "",
  ],
  [
    "LP-1666-IDN",
    "Yes",
    "PT VS Technology Indonesia",
    "Jl. Cendana Raya Blok F10 No. 06B, Delta Silicon III, Industrial Park Lippo Cikarang, Kab. Bekasi, Jawa Barat",
    "(021) 29288998/29617850",
    "kWh Meteran Listrik - Meter statis untuk energi aktif/reaktif (kelas 1)",
    "3 Juli 2027",
    "",
  ],
  [
    "LP-1667-IDN",
    "Yes",
    "PT Mutu Bina Inspeksi",
    "Jl. Raya Bogor Km. 33,5 No. 19, Gedung Inspeksi, Cimanggis, Depok, Jawa Barat",
    "(021) 8740202",
    "Industrial Hygiene (Lingkungan kerja)",
    "19 Juli 2027",
    "",
  ],
  [
    "LP-1668-IDN",
    "Yes",
    "Prodia Food Health Laboratory",
    "Jl. Danau Buyan No. 10, Sanur, Denpasar Selatan, Bali",
    "(0361) 4491897",
    "Air untuk keperluan higiene sanitasi, ikan dan produk perikanan, roti dan produk serupa roti, daging dan produk daging",
    "19 Juli 2027",
    "",
  ],
  [
    "LP-1669-IDN",
    "Yes",
    "PT Kenzlab Kanaka Indonesia",
    "Jl. Raya Wangun No. 307, Sindang Rasa, Bogor Timur, Bogor, Jawa Barat",
    "(0251) 8248750",
    "Air limbah",
    "19 Juli 2027",
    "",
  ],
  [
    "LP-1670-IDN",
    "Yes",
    "PT Pertamina Gas Operation South Sumatera Area (OSSA) - Laboratorium Gas",
    "Jl. AKBP Cek Agus No. 10, Palembang, Sumatera Selatan",
    "(0711) 5648511",
    "Gas alam (natural gas)",
    "19 Juli 2027",
    "",
  ],
  [
    "LP-1671-IDN",
    "Yes",
    "UPTD Laboratorium dan Pengujian Dinas Pekerjaan Umum dan Tata Ruang Kabupaten Indragiri Hilir Provinsi Riau",
    "Jl. Prof. Moh. Yamin Tembilan Indragiri Hilir, Riau",
    "082391742308",
    "Agregat kasar dan halus, beton",
    "19 Juli 2027",
    "",
  ],
  [
    "LP-1672-IDN",
    "Yes",
    "PT Asiatrust Technovima Qualiti cabang Morowali",
    "Jl. Teratai No.9, Poros Trans Sulawesi (Gedung Wisata laut), Tofoiso, Bungku Tengah, Morowali, Sulawesi Tengah",
    "",
    "Mineral nikel, mineral pasir kuarsa/silika, mineral limestone",
    "19 Juli 2027",
    "",
  ],
  [
    "LP-1673-IDN",
    "Yes",
    "UPT Laboratorium Lingkungan Hidup Dinas Lingkungan Hidup Kota Banjarbaru",
    "Jl. Trikora/Soekarno Hatta No. 8, Banjarbaru, Kalimantan Selatan",
    "(0511) 6749675",
    "Air limbah, air sungai, air untuk keperluan higiene dan sanitasi",
    "19 Juli 2027",
    "",
  ],
  [
    "LP-1674-IDN",
    "Yes",
    "Politeknik Kesehatan Kementerian Kesehatan Makassar",
    "Jl. Baji Gau No. 10, Makassar, Sulawesi Selatan",
    "(0411) 854021",
    "Sediaan farmasi setengan padat (gel dan krim), sediaan farmasi cair (sirup), tablet",
    "23 Agustus 2027",
    "",
  ],
  [
    "LP-1675-IDN",
    "Yes",
    "PT Alina Bestari - Laboratorium Adikalpa",
    "Jl. Ciawitali No. 45, Kel. Citeureuo, Kec. Cimahi Utara, Cimahi, Jawa Barat",
    "(022) 20663823",
    "Udara emisi sumber tidak bergerak",
    "23 Agustus 2027",
    "",
  ],
  [
    "LP-1676-IDN",
    "Yes",
    "UPTD Pengujian Bahan, Konstruksi Bangunan dan Informasi Konstruksi, Dinas Pekerjaan Umum dan Perumahan Rakyat Provinsi Banten",
    "Jl. Bhayangkara No. 21, Kel. Sumur Pecung, Kec. Cipocok Jaya, Kota Serang, Banten",
    "",
    "Baja beton, beton silinder, beton kubus, paving block, aspal, agregat kasar, agregat halus, tanah dan batuan",
    "23 Agustus 2027",
    "",
  ],
  [
    "LP-1677-IDN",
    "Yes",
    "PT SGS Indonesia Laboratorium Agriculture (multilokasi)",
    "Lokasi 1: Jl. Pulau Karimun Blok B No. 18, Kompleks Pergudangan Medan Mas Karimun, Sumatera Utara Lokasi 2: Jl. Ahmad Yani Km. 12.9 No. 105, Gambut-Banjar, Kalimantan Selatan",
    "(061) 6871113",
    "Feedingstuffs Palm Kernel Expeller, Grains Cereal, Grains Maize, minyak dan lemak (CPO, CPKO, RBDPO, RBDPOL, RBDPS, RBDPKO, RBDCNO, PFAD, PAO, UCO)",
    "23 Agustus 2027",
    "",
  ],
  [
    "LP-1678-IDN",
    "Yes",
    "UPTD Laboratorium Lingkungan Dinas Lingkungan Hidup Kabupaten Barito Kuala",
    "Jl. Jend. Sudirman No.76, Marabahan, Kab. Barito Kuala, Kalimantan Selatan",
    "(0511) 4799497",
    "Air limbah, air permukaan (air sungai, air rawa)",
    "23 Agustus 2027",
    "",
  ],
  [
    "LP-1679-IDN",
    "Yes",
    "UPT Laboratorium Lingkungan Dinas Lingkungan Hidup Provinsi Sulawesi Tengah",
    "Jl. Dr. Suharso No. 419, Kel. Besusu Barat, Kec. Palu Timur, Palu, Sulawesi Tengah",
    "082394143005",
    "Air limbah, air untuk keperluan higiene sanitasi, air sungai",
    "23 Agustus 2027",
    "",
  ],
  [
    "LP-1680-IDN",
    "Yes",
    "PT Indo Borneo Inspeksi Services Kendari",
    "Jl. Bahagia No. 21, Kel. Boggoeya, Kec. Wua-wua, Kendari, Sulawesi Tenggara",
    "(0541) 766063",
    "Nikel ore",
    "23 Agustus 2027",
    "",
  ],
  [
    "LP-1681-IDN",
    "Yes",
    "PT Bhirawa Steel",
    "Jl. Margomulyo No. 6, Tandes, Surabaya, Jawa Timur",
    "(031) 7491719",
    "Baja tulangan sirip, baja tulangan polos, billet",
    "23 Agustus 2027",
    "",
  ],
  [
    "LP-1682-IDN",
    "Yes",
    "PT Beckjorindo Paryaweksana Cabang Semarang",
    "Jl. Madukoro Perum Semarang Indah, DXVIII No. 20, Semarang, Jawa Tengah",
    "(024) 7615603",
    "Biji kopi, arang tempurung kelapa",
    "23 Agustus 2027",
    "",
  ],
  [
    "LP-1683-IDN",
    "Yes",
    "UPTD Laboratorium Kesehatan Daerah Kabupaten Sukabumi",
    "Komplek Alun-alun Cisaat, Kab. Sukabumi, Jawa Barat",
    "(0266) 6229553",
    "Air untuk keperluan higiene sanitasi, air minum",
    "23 Agustus 2027",
    "",
  ],
  [
    "LP-1684-IDN",
    "Yes",
    "Laboratorium Forensik Digital - Direktorat Jenderal Pajak",
    "Jl. Gatot Subroto No. 40-42, Jakarta, DKI Jakarta",
    "(021) 5250208",
    "Komputer dan media penyimpanan portabel, telepon seluler, akun internet",
    "23 Agustus 2027",
    "",
  ],
  [
    "LP-1685-IDN",
    "Yes",
    "PT Panasonic Manufacturing Indonesia",
    "Jl. Raya Bogor Km. 29, Pekayon, Pasar Rebo, Jakarta Timur, DKI Jakarta",
    "(021) 8710221 Ext. 2721, 2722",
    "Air conditioner, kipas angin listrik, pompa air listrik, mesin cuci, lemari es, water dispenser, plastik, logam, air limbah",
    "23 Agustus 2027",
    "",
  ],
  [
    "LP-1686-IDN",
    "Yes",
    "PT Rajawali Baskara Perkasa",
    "Lokasi 1: Ruko Boulevard Taman Tekno BSD Sektor XI Blok A21, Kel. Setu, Kec. Setu, Kota Tangerang Selatan, Banten Lokasi 2: Jl. Karang Tengah Raya No.7, Kel. Lebak Bulus, Kec. Cilandak, Jakarta Selatan, DKI Jakarta",
    "(021) 29313344",
    "Lokasi 1: Mainan anak, mainan aktivitas untuk penggunaan domestik, tableware, mainan yang memiliki fungsi elektrikal dalam penggunaannya, kipas angin, tekstil dan produk tekstil, mainan bayi, polimer, pakaian bayi",
    "23 Agustus 2027",
    "",
  ],
  [
    "LP-1687-IDN",
    "Yes",
    "PT Kaltim Parna Industri",
    "Kawasan Kaltim Industrial Estate, PT Pupuk Kaltim, Bontang Utara, Kalimantan Timur",
    "(0548) 41091-92 Ext. 5120, 5121",
    "Natural gas, Anhydrous Ammonia, air Proses, Air laut, Air Limbah, Udara Ambien, Udara dalam ruangan, Udara emisi sumber tidak bergerak",
    "22 September 2027",
    "",
  ],
  [
    "LP-1688-IDN",
    "Yes",
    "Balai Teknologi Sanitasi",
    "Jl. Raya Menganti, Wiyung, Surabaya, Jawa Timur",
    "(031) 7524149",
    "Air limbah domestik",
    "22 September 2027",
    "",
  ],
  [
    "LP-1689-IDN",
    "Yes",
    "PT Thermochem Indonesia",
    "Komplek Cimareme Indah Blok A4 No. 14, Cimareme-Ngamprah, Bandung Barat, Jawa Barat",
    "(022) 6868-110",
    "Air Kawah, NCG (Non Condensable Gas), Gas SF",
    "22 September 2027",
    "",
  ],
  [
    "LP-1690-IDN",
    "Yes",
    "PT Oshindo Medika Pratama",
    "Jl. Jend. A. Yani Ruko Taman Niaga Sukajadi Blok J No. 1, Batam, Kepulauan Riau",
    "(0778) 7372022 ; 7372023",
    "Lingkungan kerja",
    "4 Oktober 2027",
    "",
  ],
  [
    "LP-1691-IDN",
    "Yes",
    "UPT Balai Bahan Jalan - Direktorat Jenderal Bina Marga, Kementerian Pekerjaan Umum &amp; Perumahan Rakyat",
    "Jl. A.H. Nasution No. 264, Ujung Berung, Bandung, Jawa Barat",
    "(022) 7811878",
    "Aspal keras, campuran aspal, agregat halus, agregat kasar",
    "4 Oktober 2027",
    "",
  ],
  [
    "LP-1692-IDN",
    "Yes",
    "PT Multi Surveyor Indonesia Cabang Kendari",
    "Jl. Patimura Puuwatu Kel. Watulondo, Kec. Puuwatu, kendari, Sulawesi Tenggara",
    "082148918670",
    "Bijih Nikel (Nickel Ore)",
    "4 Oktober 2027",
    "",
  ],
  [
    "LP-1693-IDN",
    "Yes",
    "PT Pengujian Produk Indonesia",
    "Jl. Desa Ranca Iyuh RT 12/ RW 03, Kec. Panongan, Kab. Tangerang, Banten",
    "(021) 59987017",
    "Alat Pemadam Api Ringan (APAR) &lt;18 kg, Alat Pemadam Api Beroda (APAB) &gt;18 kg",
    "04 Oktober 2027",
    "",
  ],
  [
    "LP-1694-IDN",
    "Yes",
    "PT Radar Akurasi Laboratorium",
    "Jl. Bromo No. 65, Kel. Tegal Sari, Kec. Medan Area, Medan, Sumatera Utara",
    "(061) 7361598",
    "Air sungai, air danau, air limbah, air bersih, kebisingan, udara ambien, udara emisi sumber tidak bergerak",
    "23 Oktober 2027",
    "",
  ],
  [
    "LP-1695-IDN",
    "Yes",
    "Fakultas Teknik Sipil dan Lingkungan, Institut Teknologi Bandung - Laboratorium Rekayasa Struktur",
    "Jl. Ganesha No. 10, Gedung CIBE Lt. 1, B1-2, Bandung, Jawa Barat",
    "082216221399",
    "Beton kubus, beton silinder, beton silinder coring, mortar semen, paving block, balok beton, beton, baja tulangan, bahan baja profil, baja ringan, baut, tulangan, baja, agregat kasar, agregat halus",
    "23 Oktober 2027",
    "",
  ],
  [
    "LP-1696-IDN",
    "Yes",
    "UPT Pengukuran dan Pengujian Bahan Konstruksi Dinas Pekerjaan Umum dan Penataan Ruang Kota Tangerang",
    "Jl. K.S Tubun No. 96, Kota Tangerang, Banten",
    "(021) 5534067",
    "Beton",
    "23 Oktober 2027",
    "",
  ],
  [
    "LP-1697-IDN",
    "Yes",
    "UPTD Laboratorium Lingkungan Dinas Lingkungan Hidup Kabupaten Nganjuk",
    "Jl. Raya Kedondong No. 1, Kec. Bogor, Kab. Nganjuk, Jawa Timur",
    "(0358) 328380",
    "Air sungai, air limbah",
    "23 Oktober 2027",
    "",
  ],
  [
    "LP-1698-IDN",
    "Yes",
    "PDAM Tirta Musi Palembang",
    "Jl. Rambutan Ujung No. 1, Kel. 30 Ilir, Kec. Ilir Barat II, Kota Palembang, Sumatera Selatan",
    "(0711) 355222",
    "Air minum, air sungai",
    "23 Oktober 2027",
    "",
  ],
  [
    "LP-1699-IDN",
    "Yes",
    "PT PLN (Persero) Unit Induk Transmisi Jawa Bagian Barat \x{2013} Bidang Pemeliharaan Transmisi",
    "Jl. MayJend Soetoyo No. 1, Ciliitan Besar, Jakarta Timur, DKI Jakarta",
    "081299465547",
    "Minyak trafo pakai",
    "23 Oktober 2027",
    "",
  ],
  [
    "LP-1700-IDN",
    "Yes",
    "PT Saraswanti Indo Genetech Surabaya",
    "Gedung AMG Tower Lt.12, Jl. Dukuh Menanggal No. 1-A, Kel Dukuh Menanggal, Kec. Gayungan, Surabaya, Jawa Timur",
    "(031) 82531288",
    "Krimer minuman (bukan susu), susu bubuk full cream, susu bubuk berlemak, susu, susu segar, susu pasteurisasi, susu UHT, susu steril, susu rendah lemak, susu rekonstitusi, susu rekombinan, minyak sayur, produk kakao dan cokelat, kakao bubuk, kembang gula keras/permen keras, kembang gula/permen lunka, tepung terigu, biskuit, bakso daging, nugget ayam, udang beku, saus sambal, AMDK, air mineral, air demineral, air bermineral, air sida, air minum beroksigen, air mineral alami, air bersih, kopi bubuk, makanan ringan berbahan dasar kentang, umbi, serealia, tepung atau pati, bedak tabur, produk cair (toner), kosmetik (bedak, lipstik, krim), obat, suplemen, obat tradisional (sediaan padat, cair, dan semi padat), dan bahan baku farmasi (sediaan padat, cair, dan semi padat), pakan ternak",
    "23 Oktober 2027",
    "",
  ],
  [
    "LP-1701-IDN",
    "Yes",
    "PT McDermott Indonesia - Bend Test Facility",
    "Jl. Bawal, Batu Ampar, Batam, Kepulauan Riau",
    "(0778) 411001",
    "Bahan baja",
    "6 November 2027",
    "",
  ],
  [
    "LP-1702-IDN",
    "Yes",
    "PT Shell Manufacturing Indonesia",
    "Jl. Kawasan Industri dan Pergudangan Marunda Centre Blok P1 No. 1, Bekasi, Jawa Barat",
    "(021) 28510921",
    "Minyak lumas motor bensin 4 (empat) langkah kendaraan bermotor, minyak lumas motor bensin 4 (empat) langkah sepeda motor, minyak lumas motor bensin 2 (dua) langkah dengan pendingin udara, minyak lumas motor diesel putaran tinggi,minyak lumas roda gigi transmisi manual dan gardan, minyak lumas transmisi otomatis, minyak lumas hidrolik industri, minyak lumas roda gigi industri tertutup",
    "6 November 2027",
    "",
  ],
  [
    "LP-1703-IDN",
    "Yes",
    "PT Betajulu Enviro Laboratorium",
    "Jl. Sei Silau No. 93, Kel. Padang Bulan Selayang I, Kec. Medan Selayang, Medan, Sumatera Utara",
    "(061) 42404227",
    "Air sungai, air danau, air limbah (limbah domestik, limbah industri), air untuk keperluan higiene sanitasi, udara emisi sumber tidak bergerak, udara ambien, kebisingan lingkungan",
    "6 November 2027",
    "",
  ],
  [
    "LP-1704-IDN",
    "Yes",
    "PT Shafera Enviro Laboratorium",
    "Jl. Jamin Ginting No. 37, Kel. Sidomulyo, Kec. Medan Tuntungan, Medan, Sumatera Utara",
    "08121551018",
    "Air danau, air sungai, air tanah, air waduk, air sumur, mata air, air limbah, air untuk keperluan higiene sanitasi, air laut, udara ambien, kebisingan, lingkungan kerja, udara emisi sumber tidak bergerak",
    "6 November 2027",
    "",
  ],
  [
    "LP-1705-IDN",
    "Yes",
    "Balai Karantina Ikan, Pengendalian Mutu dan Keamanan Hasil Perikanan Medan I",
    "Jl. Karantina Ikan Desa Araskabu, Kec. Beringin, Kab. Deli Serdang, Sumatera Utara",
    "(061) 42079683",
    "Ikan air laut, ikan air tawar, produk olahan ikan, produk perikanan",
    "6 November 2027",
    "",
  ],
  [
    "LP-1706-IDN",
    "Yes",
    "Center for Medical Physics and Biophysics (CPMB) Lembaga Sains Terapan (LST) FMIPA Universitas Indonesia",
    "Gedung Multidisiplin Pertamina Lt. 8 FMIPA Universitas Indonesia, Kampus UI Depok, Kota Depok, Jawa Barat",
    "(021) 7871254",
    "Pesawat sinar-x radiografi umum, Pesawat sinar-x radiografi mobile, pesawat sinar-x fluoroskopi mode fluoroskopi, pesawat sinar x radiografi CT-scan, pesawat sinar-x dental intraoral, pesawat sinar-x dental panoramic, pesawat sinar-x dental cephalometric",
    "27 November 2027",
    "",
  ],
  [
    "LP-1707-IDN",
    "Yes",
    "PT Global Quality Indonesia",
    "Komplek Kopo Mas Regency Blok N No. 7c, Bandung, Jawa Barat",
    "(022) 5436775",
    "Pesawat sinar-x radiografi umum, Pesawat sinar-x radiografi mobile, bola baja abrasi, cetakan silinder beton uji, cetakan kubus beton uji",
    "27 November 2027",
    "",
  ],
  [
    "LP-1708-IDN",
    "Yes",
    "PT OOWL Indonesia (Multilokasi)",
    "Lokasi 1: Jl. A. Yani Km 29,5, Guntung Manggis, Landasan Ulin, Banjarbaru, Kalimantan Selatan Lokasi 2: Jl. A. Yani KM 5 Rt 13, Kel. Tamiyang Layang, Kec. Dusun Timur, Kab. Barito Timur, Kalimantan Tengah Lokasi 2: Jl. Ring Road 2, Kel. Lok Bahu, Kec. Sungai Kunjang, Kota Samarinda, Kalimantan Timur",
    "082156616686",
    "Batubara, pasir silika, bijih nikel",
    "27 November 2027",
    "",
  ],
  [
    "LP-1709-IDN",
    "Yes",
    "Fakultas Teknologi Pertanian Universitas Gadjah Mada - Laboratorium Pascapanen",
    "Jl. Flora No. 1, Bulaksumur, Yogyakarta, DI Yogyakarta",
    "(0274) 8350508",
    "Mesin pengering tipe bak dasar",
    "27 November 2027",
    "",
  ],
  [
    "LP-1710-IDN",
    "Yes",
    "PT Asiatrust Technovima Qualiti Cabang Banjarmasin",
    "Jl. A. Yani Km. 13 No. 99, Gambut, Kota Banjarmasin, Kalimantan Selatan",
    "(0511) 4221539",
    "Batubara, pasir silika",
    "27 November 2027",
    "",
  ],
  [
    "LP-1711-IDN",
    "Yes",
    "PT Asiatrust Technovima Qualiti Cabang Samarinda",
    "Jl. Damanhuri No. 06, RT. 27, Kel. Mugirejo, Kec. Sungai Pinang, Samarinda, Kalimantan Timur",
    "(0541) 283177",
    "Mineral (Ni-ore), batubara",
    "27 November 2027",
    "",
  ],
  [
    "LP-1712-IDN",
    "Yes",
    "UPTD Laboratorium Lingkungan Dinas Lingkungan Hidup Kabupaten Sampang",
    "Jl. Jamaluddin No. 1-C, Kel. Gunung Sekar, Kab. Sampang, Jawa Timur",
    "082332625788",
    "Air limbah",
    "27 November 2027",
    "",
  ],
  [
    "LP-1713-IDN",
    "Yes",
    "PT Molten Aluminium Produser Indonesia",
    "Kawasan Industri Indotaisei Sektor IA Blok K1, Kel. Kalihurip, Kec. Cikampek, Kab. Karawang, Jawa Barat",
    "(0264) 350460",
    "Aluminum alloy, aluminum alloy ingots for die casting, aluminum alloy ingots for casting",
    "27 November 2027",
    "",
  ],
  [
    "LP-1714-IDN",
    "Yes",
    "Laboratorium Digital Forensik - Kejaksaan Republik Indonesia",
    "Gedung DGC Komplek Adhyaksa Loka, Jl. Mabes Hankam No. 60, Ceger, Cipayung, Jakarta Timur, DKI Jakarta",
    "",
    "Smartphone",
    "27 November 2027",
    "",
  ],
  [
    "LP-1715-IDN",
    "Yes",
    "PT Adaro Indonesia (Multilokasi)",
    "Lokasi 1: Hauling Road KM 0, Desa Kelanis, Kec. Mengkatip, Kab. Barito Selatan, Kalimantan Tengah Lokasi 2: Hauling Road KM 68, Kec. Murung Pudak, Kab. Tabalong, Kalimantan Selatan",
    "(0526) 2021997",
    "Batubara, tanah, air proses kegiatan pertambangan (air limbah)",
    "27 November 2027",
    "",
  ],
  [
    "LP-1716-IDN",
    "Yes",
    "Stasiun Karantina Ikan, Pengendalian Mutu dan Keamanan Hasil Perikanan Baubau",
    "Jl. Dayanu Ikhsanuddin No. 20, Kel. Lipu, Kec. Betoambari, Baubau, Sulawesi Tenggara",
    "(0402) 2823214",
    "Produk perikanan (ikan beku dan segar), rumput laut kering, crustacea (udang windu, udang vannamei), ikan segar, ikan beku, tuna loin segar, rumput laut kering, teripang kering, ikan asin kering, teri asin kering, sirip hiu kering, telur ikan terbang kering, cumi-cumi dan sotong kering, udang segar, gurita segar, ikan asap, udang beku, daging rajungan rebus",
    "27 November 2027",
    "",
  ],
  [
    "LP-1717-IDN",
    "Yes",
    "Balai Besar Pengembangan Mekanisasi Pertanian",
    "Jl. Sinarmas Boulevard, Pegedangan, Tangerang, Banten",
    "(021) 75675918",
    "Traktor pertanian roda dua, traktor pertanian roda empat gandar ganda, pompa air sentrifugal untuk irigasi, mesin penggiling gabah sekali umpan, mesin perontok padi tipe pelemparan jerami, mesin pemipil jagung, mesin pengering biji-bijian tipe sirkulasi, mesin tanam bibit padi tipe dorong, sprayer gendong semi-otomatis, mesin penghancur (crusher) bahan baku pupuk organik, mesin sangrai kopi dan kakao tipe slinder datar berputar, pengabut gendong bermotor, mesin perontok multi komoditi untuk padi, jagung, dan kedelai, mesin panen padi tipe kombinasi, mesin pengasap tipe jinjing sistem pulsa jet, mini tiller - mesin pengolah tanah sekunder, sprayer gendong elektrik, mesin pemotong rumput tipe gendong, mesin panen jagung kombinasi tipe",
    "27 November 2027",
    "",
  ],
  [
    "LP-1718-IDN",
    "Yes",
    "PT Inti Lautan Fajar Abadi",
    "Jl. Wonokoyo 1 Desa Wonokoyo, Beji, Pasuruan, Jawa Timur",
    "(0343) 655999",
    "Ikan segar beku",
    "7 Desember 2027",
    "",
  ],
  [
    "LP-1719-IDN",
    "Yes",
    "PT Surveyor Carbon Consulting Indonesia Cabang Palembang (Multilokasi)",
    "Lokasi 1: Jl. Tembus Terminal B Perumnas RT 048 / RW 005, Talang Kelapa, Alang-alang Lebar, Palrmbang, Sumatera Selatan Lokasi 2: Jl. Letjend. R. Suprapto RT 10 / RW 04 No.89, Kel. Ramanuju, Kec. Purwakarta, Kota Cilegon, Banten",
    "(0711) 5645155",
    "Batubara, Kokas (Coke)",
    "7 Desember 2027",
    "",
  ],
  [
    "LP-1720-IDN",
    "Yes",
    "PT Laboratorium Medio Pratama",
    "Ruko Alicante Boulevard Blok B No. 52-53, Jl. Jend. Gatot Subroto, Medang, Pagedangan, Kab. Tangerang, Banten",
    "(021) 22229988",
    "Air limbah, air minum, air untuk keperluan higiene &amp; sanitasi, udara ambien, udara lingkungan kerja, emisi sumber tidak bergerak",
    "7 Desember 2027",
    "",
  ],
  [
    "LP-1721-IDN",
    "Yes",
    "UPTD Laboratorium Lingkungan Dinas Lingkungan Hidup Provinsi Sumatera Barat",
    "Jl. Khatib Sulaiman No 22, Kota Padang, Sumatera Barat",
    "(0751) 7055231",
    "Air sungai, air sumur, air tanah, air danau, air higiene sanitasi, air limbah",
    "7 Desember 2027",
    "",
  ],
  [
    "LP-1722-IDN",
    "Yes",
    "PT Jembayan Muarabara",
    "Desa Separi RT. 07 Kec. Tenggarong Seberang, Kab. Kutai Kartanegara, Kalimantan Timur",
    "(0541) 7771100",
    "Batubara, air limbah dan air bersih",
    "7 Desember 2027",
    "",
  ],
  [
    "LP-1723-IDN",
    "Yes",
    "PT Semesta Esa Laboratorium",
    "Jl. Raden Patah RT 006 RW 005, Kelurahan Ledug, Kecamatan Kembaran, Kabupaten Banyumas, Jawa Tengah",
    "(0281) 628594",
    "Air sungai, air untuk keperluan higiene dan sanitasi, air limbah, kebisingan, udara ambien, udara lingkungan kerja, udara emisi sumber tidak bergerak",
    "7 Desember 2027",
    "",
  ],
  [
    "LP-1724-IDN",
    "Yes",
    "Laboratorium Integrated Terminal BBM Manggis, PT Pertamina Patra Niaga",
    "Jl. Raya Ulakan Kec. Manggis, Kab Karangasem, Bali",
    "(0363) 41594",
    "Pertalite, Pertamax, Solar, Biosolar (B30), Fame, Avtur, Minyak Bakar (MFO), Minyak Diesel (MDF)",
    "27 Desember 2027",
    "",
  ],
  [
    "LP-1725-IDN",
    "Yes",
    "Balai Besar Perbenihan dan Proteksi Tanaman Perkebunan (BBPPTP) Medan",
    "Jl. Asrama No. 124 Helvetia Sei Sikambing B, Kec. Medan Helvetia, Medan, Sumatera Utara",
    "(061) 8470504",
    "Benih kopi, benih kakao, benih karet, agen pengendali hayati (APH): potato dextrosa agar (PDA), tepung, kompos, formulasi pestisida berbentuk cair",
    "27 Desember 2027",
    "",
  ],
  [
    "LP-1726-IDN",
    "Yes",
    "PT Pertamina Hulu Rokan (Multilokasi)",
    "Lokasi 1: Duri Laboratory PT PHR, Kel. Pematang Pudu, Kec. Mandau, Kab. Bengkalis, Provinsi Riau Lokasi 2: Minas Laboratory PT PHR, Kel. Minas Barat, Kec. Minas, Kab. Siak, Provinsi Riau",
    "(0765) 825111",
    "Lokasi 1: Air bersih, air limbah, tanah, lumpur, sedimen, gas alam, minyak bumi",
    "27 Desember 2027",
    "",
  ],
  [
    "LP-1727-IDN",
    "Yes",
    "PT Artada Nusa Analitika",
    "Grand Galaxy City, Jl. Rose Garden Blok RRGB No. 67/69, Bekasi Selatan, Kota Bekasi, Jawa Barat",
    "(021) 82734096",
    "Air limbah, air sungai, air danau, air bersih, udara ambien, kebisingan, udara emisi sumber tidak bergerak, lingkungan kerja, Air Minum Dalam Kemasan",
    "27 Desember 2027",
    "",
  ],
  [
    "LP-1728-IDN",
    "Yes",
    "Laboratorium Pengujian Beton, Fakultas Teknik dan Program Studi Teknis Sipil - Universitas Medan Area",
    "Jl. Kolam No. 1 Medan Estate, Sumatera Utara",
    "(061) 7360168",
    "Beton silinder",
    "27 Desember 2027",
    "",
  ],
  [
    "LP-1729-IDN",
    "Yes",
    "PT Vale Indonesia, Tbk - Laboratorium &amp; Sample House Process Technology",
    "Plant Site Sorowako, Luwu Timur, Sulawesi Selatan",
    "(021) 5249100",
    "Hasil Proses dyer &amp; klim, bijih nickel laterite, produk akhir tambang (nickle matte), air limbah, air danau, air sungai,air hujan, air lindi",
    "27 Desember 2027",
    "",
  ],
  [
    "LP-1730-IDN",
    "Yes",
    "Stasiun Karantina Ikan, Pengendalian Mutu dan Keamanan Hasil Perikanan Bima",
    "Jl. Raya Lintas Sumbawa, Talabiu, Woha, Bima, Nusa Tenggara Barat",
    "(0374) 81588",
    "Ikan air laut, crustacea, ikan segar, ikan kering, ikan beku dan produk perikanan, udang, lobster, kerapu, dan rumput laut",
    "27 Desember 2027",
    "",
  ],
  [
    "LP-1731-IDN",
    "Yes",
    "PT Asmin Bara Bronang",
    "Sepan Uring Km. 68 JAB ABB, Desa Barunang, Kapuas, Kabupaten Kapuas, Kalimantan Tengah",
    "082150539528",
    "Batubara",
    "27 Desember 2027",
    "",
  ],
  [
    "LP-1732-IDN",
    "Yes",
    "PT Geo Gea Laboratory",
    "Jl. Halu Oleo Kompleks Perkantoran, Kel. Mokoau, Kec. Kambu, Kendari, Sulawesi Tenggara",
    "08114009009",
    "Nickel Ore",
    "27 Desember 2027",
    "",
  ],
  [
    "LP-1733-IDN",
    "Yes",
    "PT Asiatrust Technovima Qualiti Cabang Palembang",
    "Jl. By Pass Tembusan Terminal Km. 12, Komplek Ruko H. Nasrun No. 3 Talang Kelapa, Alang-alang Lebar, Palembang, Sumatera Selatan",
    "(0711) 5720870",
    "Batubara",
    "27 Desember 2027",
    "",
  ],
  [
    "LP-1734-IDN",
    "Yes",
    "Balai Karantina Ikan, Pengendalian Mutu dan Keamanan Hasil Perikanan Tanjung Pinang",
    "Jl. Yos Sudarso No 25A, Batu Hitam, Tanjungpinang, Kep. Riau",
    "(0771) 314172",
    "Ikan air laut (kerapu, kakap), udang, lobster, ikan nila, ikan air tawar, ikan dan produk perikanan, ikan segar",
    "27 Desember 2027",
    "",
  ],
  [
    "LP-1735-IDN",
    "Yes",
    "PT Natura Perisa Aroma",
    "Jl. Ir. Sutami Km 9, Sukanegara, Tanjung Bintang, Lampung Selatan, Lampung",
    "(0721) 351091",
    "Produk black pepper (lada hitam utuh (non steril dan steril) dan bubuk steril)",
    "27 Desember 2027",
    "",
  ],
  [
    "LP-1736-IDN",
    "Yes",
    "PT Medan Sugar Industry",
    "Jl. Pulau Tanah Masa KIM Tahap II Saentis - Percut Sei Tuan, Deli Serdang, Sumatera Utara",
    "(061) 6871955",
    "Gula kristal rafinasi",
    "27 Desember 2027",
    "",
  ],
  [
    "LP-1737-IDN",
    "Yes",
    "UPTD Laboratorium Lingkungan Dinas Lingkungan Hidup Kabupaten Tegal",
    "Jl. Prof. M. Yamin - Slawi, Kab. Tegal, Jawa Tengah",
    "(0283) 491159",
    "Air limbah, air sungai, air danau, air embung",
    "27 Desember 2027",
    "",
  ],
  [
    "LP-1738-IDN",
    "Yes",
    "Unit Pelaksana Teknis Dinas Balai Proteksi Tanaman Pertanian Provinsi DIY",
    "Gesikan, Wijirejo, Pandak, Bantul, Daerah Istimewa Yogyakarta",
    "(0274) 582829",
    "Agens pengendali hayati Beauveria bassiana pada media padat (beras/Oryza sativa dan jagung/Zea mays), Agens pengendali hayati Trichoderma spp. pada media padat (beras/Oryza sativa dan jagung/Zea mays)",
    "27 Desember 2027",
    "",
  ],
  [
    "LP-1739-IDN",
    "Yes",
    "UPTD Laboratorium Lingkungan Dinas Lingkungan Hidup Kabupaten Lampung Tengah",
    "Komplek Perkantoran Dinas, Jl. Hi. Muchtar Gunung Sugih, Kabupaten Lampung Tengah, Lampung",
    "(0725) 5260983",
    "Air limbah, air sungai",
    "27 Desember 2027",
    "",
  ],
  [
    "LP-1740-IDN",
    "Yes",
    "Laboratorium Forensik Digital PT Bank Mandiri, Tbk",
    "PLAZA MANDIRI, lantai 26, CISO Office Group, Jl. Jenderal Gatot Subroto Kav. 36-38, DKI Jakarta",
    "(021) 52997777",
    "Komputer dan Media Penyimpanan Portabel (hardisk)",
    "27 Desember 2027",
    "",
  ],
  [
    "LP-1741-IDN",
    "Yes",
    "Laboratorium UI - CHEM Departemen Kimia FMIPA UI",
    "Gedung G Departemen Kimia, Fakultas Matematika dan Ilmu Pengetahuan Alam Kampus UI Depok, Jawa Barat",
    "(021) 78849006",
    "Air sungai, air sumur, air limbah",
    "24 Januari 2028",
    "",
  ],
  [
    "LP-1742-IDN",
    "Yes",
    "PT Semesta Envirotec Admira Laboratorium",
    "Ruko Grand Galaxy City RGC 3 No. 32 RT 001/RW 002 Jaka Setia, Bekasi Selatan, Kota Bekasi, Jawa Barat",
    "(021) 82744157",
    "Air sungai, air limbah, lingkungan kerja",
    "24 Januari 2028",
    "",
  ],
  [
    "LP-1743-IDN",
    "Yes",
    "Yayasan Global Halal Indonesia",
    "Tekno III, Blok E-III No. 36 Lt. 2 Laboratory Section, Kawasan Industri BSD, Tangerang Selatan, Banten",
    "(021) 75880000",
    "Daging yang dihaluskan tanpa pemasakan (daging giling)",
    "24 Januari 2028",
    "",
  ],
  [
    "LP-1744-IDN",
    "Yes",
    "PT Sumber Inti Pangan",
    "Kampung Pahing RT. 016 RW. 004 Desa Cilowa, Kec. Kramatmulya, Kuningan, Jawa Barat",
    "(0232) 8894707",
    "Herba dan rempah, bumbu dan kondimen, saus teremulsi, sayuran kering, tepung ikan dan tepung udang",
    "24 Januari 2028",
    "",
  ],
  [
    "LP-1745-IDN",
    "Yes",
    "Balai Veteriner Banjarbaru",
    "Jl. Ambulung No. 24 Loktabat Selatan, Banjarbaru, Kalimantan Selatan",
    "(0511) 4774449",
    "Organ otak hewan, cadaver hewan utuh, jaringan hewan, darah hewan, serum, darah hewan, swab unggas, fesee hewan.",
    "24 Januari 2028",
    "",
  ],
  [
    "LP-1746-IDN",
    "Yes",
    "PT Salim Ivomas Pratama Tbk - Quality Control Tanjung Priok Laboratory",
    "Jl. Industri I No. 3, Tanjung Priok, Jakarta Utara, DKI Jakarta",
    "(021) 43937788",
    "Minyak goreng, shortening, Crude Palm Oil (CPO), Refined Bleached Deodorized Palm Oil, Refined Bleached Deodorized Palm Stearin, Refined Bleached Deodorized Palm Olein, margarin, Palm Fatty Acid Destilated",
    "24 Januari 2028",
    "",
  ],
  [
    "LP-1747-IDN",
    "Yes",
    "PT Indra Karya (Persero) - Laboratorium Geoteknik",
    "Jl. Janti Barat No. 27, Kota Malang, Jawa Timur",
    "(0341) 362261",
    "Tanah, pasir, dan batu",
    "24 Januari 2028",
    "",
  ],
  [
    "LP-1748-IDN",
    "Yes",
    "Stasiun Karantina Ikan, Pengendalian Mutu dan Keamanan Hasil Perikanan Gorontalo",
    "Jl. Achmad Nadjamuddin No. 20, Gorontalo",
    "(0435) 824071",
    "Tuna, tongkol, cakalang, lele, nila, mas, mujair, udang vannamei, udang windu, kepiting, lobster, kerapu, bandeng, kakap, kerapu, layang, nike, rajungan",
    "24 Januari 2028",
    "",
  ],
  [
    "LP-1749-IDN",
    "Yes",
    "PT Dua Kelinci",
    "Jl. Raya Pati Kudus Km 6.3 Pati, Jawa Tengah",
    "(0295) 381407",
    "Biskuit (wafer roll, wafer crapes)",
    "24 Januari 2028",
    "",
  ],
  [
    "LP-1750-IDN",
    "Yes",
    "PT Consult International Indonesia Samarinda",
    "Jl. Ir. H. Nusyirwan Ismail, Msi. (Ring Road 2) No.11 RT.40 Kel. Air Putih, Kec. Samarinda Ulu, Samarinda, Kalimantan Timur",
    "085157998870",
    "Batubara, Nickel Ore",
    "24 Januari 2028",
    "",
  ],
  [
    "LP-1751-IDN",
    "Yes",
    "Balai Penerapan Standar Instrumen Pertanian Yogyakarta",
    "Karangsari, Wedomartani, Ngemplak, Sleman, Yogyakarta",
    "085790665191",
    "Tanah, pupuk organik, pupuk urea, pupuk NPK padat, tanaman",
    "24 Januari 2028",
    "",
  ],
  [
    "LP-1753-IDN",
    "Yes",
    "Balai Kesehatan Kerja Pelayaran Kementerian Perhubungan-Laboratorium Kesehatan Lingkungan Kerja Pelayaran",
    "Jl. Raya Ancol Baru No.1, Tanjung Priok, Jakarta Utara, DKI Jakarta",
    "(021) 4372447",
    "Lingkungan kerja",
    "05 Februari 2028",
    "",
  ],
  [
    "LP-1754-IDN",
    "Yes",
    "Badan Penyelenggara Jaminan Produk Halal - Laboratorium Halal",
    "Jl. Raya Pd. Gede No.13, RT.1/RW.1, Pinang Ranti, Kec. Makasar, Jakarta Timur, DKI Jakarta",
    "",
    "Sari buah, minuman beralkohol (bir dan minuman malt), produk olahan daging (sosis dan bakso), daging (karkas sapi, karkas celeng, karkas babi)",
    "05 Februari 2028",
    "",
  ],
  [
    "LP-1755-IDN",
    "Yes",
    "PT Kilang Pertamina Internasional \x{2013} Refinery Unit VI Balongan",
    "JI. Raya Balongan Km. 9 lndramayu, Jawa Barat",
    "(0234) 5256296",
    "Avtur, Pertamax, Premium, Pertalite, Pertamax Turbo, Solar, Decant Oil. LPG, Propylene, Air Limbah",
    "05 Februari 2028",
    "",
  ],
  [
    "LP-1756-IDN",
    "Yes",
    "PT Surya Sarana Ujitama",
    "Jl. Majapahit No. 202, Gayamsari, Semarang, Jawa Tengah",
    "(024) 6703819",
    "Air limbah, air sungai",
    "05 Februari 2028",
    "",
  ],
  [
    "LP-1757-IDN",
    "Yes",
    "Laboratorium Lingkungan Dinas Lingkungan Hidup Kota Pekalongan",
    "Jl. Tentara Pelajar No. 1, Kota Pekalongan, Jawa Tengah",
    "(0285) 421370",
    "Air limbah, air permukaan (air sungai)",
    "21 Februari 2028",
    "",
  ],
  [
    "LP-1758-IDN",
    "Yes",
    "Politeknik Kesehatan Kementerian Kesehatan Kupang",
    "Jl. Piet A Tallo, Kupang, Nusa Tenggara Timur",
    "(0380) 8800256",
    "Air bersih, air limbah",
    "21 Februari 2028",
    "",
  ],
  [
    "LP-1759-IDN",
    "Yes",
    "Unit Pelaksana Teknis Daerah Laboratorium Lingkungan Hidup Dinas Lingkungan Hidup Kabupaten Karawang",
    "Jl. By Pass Tanjungpura No. 1, Kab. Karawang, Jawa Barat",
    "(0267) 406087",
    "Air permukaan (air sungai, air danau, air waduk, air situ, air irigasi), air limbah, air untuk keperluan higiene sanitasi",
    "21 Februari 2028",
    "",
  ],
  [
    "LP-1760-IDN",
    "Yes",
    "PT Indonesia Power - PLTU Jeranjang Operation and Maintenance Services Unit",
    "Jl. Raya PLTU Jeranjang, Dusun Jeranjang, Desa Taman Ayu, Kec. Gerung, Lombok Barat, Nusa Tenggara Barat",
    "(0370) 7858897",
    "Batubara",
    "21 Februari 2028",
    "",
  ],
  [
    "LP-1761-IDN",
    "Yes",
    "PT Wijaya Karya (Persero) Tbk, Laboratorium Jasa Konstruksi",
    "Jl. Raya Kelapa Dua Wetan No. 6, Ciracas, Jakarta Timur, DKI Jakarta",
    "(021) 8729057",
    "Tanah, batuan, agregat, beton",
    "21 Februari 2028",
    "",
  ],
  [
    "LP-1762-IDN",
    "Yes",
    "PT Kilang Pertamina Internasional - Refinery Unit VII Kasim",
    "Jl. Raya Kilang No. 1, Kasim Kec. Seget, Sorong, Papua Barat",
    "(021) 3815777",
    "Pertalite, Kerosene, Biosolar (B30), Residue, Crude Oil",
    "21 Februari 2028",
    "",
  ],
  [
    "LP-1763-IDN",
    "Yes",
    "PT Transformator Servis Indonesia",
    "Wisma Elok No. 15, Jl. Cipinang Elok Blok J-136, Jakarta Timur, DKI Jakarta",
    "(021) 22850743",
    "Minyak transformator",
    "21 Februari 2028",
    "",
  ],
  [
    "LP-1764-IDN",
    "Yes",
    "PT Anindya Wiraputra Konsult Cabang Weda Bay",
    "Dusun II Desa Gemaf, Kec. Weda Utara, Kab. Halmahera Tengah, Maluku Utara",
    "082124042869",
    "Batubara, Nickel Ore",
    "21 Februari 2028",
    "",
  ],
  [
    "LP-1765-IDN",
    "Yes",
    "PT Anindya Certification and Testing",
    "Jl. Rotan No. 23C, Cicau, Kec. Cikarang Pusat, Kab. Bekasi, Jawa Barat",
    "081213371408",
    "Mainan, mainan elektrik, kain pada mainan, pakaian bayi, tekstil dan produk tekstil, alas kaki karet/plastik, alat tulis (penghapus karet, krayon)",
    "21 Februari 2028",
    "",
  ],
  [
    "LP-1766-IDN",
    "Yes",
    "PT Morowali Industri Teknologi",
    "Desa Bente Dusun IV, Kel. Bente, Kec. Bungku Tengah, Kab. Morowali, Sulawesi Tengah",
    "082236262774",
    "Nickel Ore",
    "21 Februari 2028",
    "",
  ],
  [
    "LP-1767-IDN",
    "Yes",
    "PT Solusi Sertiifkasi Nasional Indonesia",
    "Komplek Pergudangan OCBD Park, Jl. Cahaya Raya Blok H10 No. 11, Kel. Leuwinutug, Kec. Citeureup, Kab. Bogor, Jawa Barat",
    "082161598888",
    "Cookware, Flatware, Tableware, Kloset Duduk, Ubin Keramik",
    "21 Februari 2028",
    "",
  ],
  [
    "LP-1768-IDN",
    "Yes",
    "Stasiun Karantina Ikan Pengendalian Mutu dan Keamanan Hasil Perikanan Sorong",
    "Jl. A. Yani, Kuda Laut (Kompleks Pelabuhan Perikanan Pantai), Sorong, Papua Barat",
    "(0951) 325671",
    "Ikan dan produk perikanan (ikan air tawar, air laut, ikan segar, ikan beku)",
    "21 Februari 2028",
    "",
  ],
  [
    "LP-1769-IDN",
    "Yes",
    "PT Shenhua Guohua Pembangkitan Jawa Bali",
    "PLTU Jawa 7 - Jl. Raya Bojonegara, Desa Terate, Kec. Kramatwatu, Kab. Serang, Banten",
    "08111256703",
    "Batubara",
    "05 Maret 2028",
    "",
  ],
  [
    "LP-1770-IDN",
    "Yes",
    "PT Carsurin Jambi",
    "Jl. Lingkar Timur 1 N0. 02 RT/RW 036, Kel. Talang Bakung, Kec. Jambi Selatan, Jambi",
    "(0741) 3081029",
    "Batubara",
    "05 Maret 2028",
    "",
  ],
  [
    "LP-1771-IDN",
    "Yes",
    "PT Pertamina Patra Niaga, Laboratorium Integrated Terminal Tanjung Wangi",
    "Jl. Gatot Subroto No. 72, Banyuwangi, Jawa Timur",
    "(0333) 510900",
    "Pertalite, Pertamax, Solar, Biosolar, Pertadex, Dexlite (B30) Fame, Avtur, Minyak Bakar (MFO)",
    "05 Maret 2028",
    "",
  ],
  [
    "LP-1772-IDN",
    "Yes",
    "PT Indesso Aroma Cileungsi - Laboratorium QC (Microbiology &amp; Advanced Analytical)",
    "Jl. Alternatif Cibubur - Cileungsi KM9, Cileungsi, Bogor, Jawa Barat",
    "(021) 82491808",
    "Sari wortel, essential oil dan turunannya, tepung pati, puree buah, seasoning powder, natural extract powder, beef powder, dan milk powder",
    "05 Maret 2028",
    "",
  ],
  [
    "LP-1773-IDN",
    "Yes",
    "PT Kilang Pertamina Internasional - Refinery Unit V Balikpapan",
    "Jl. Yos Sudarso No. 1, Balikpapan, Kalimantan Timur",
    "(0542) 511000",
    "Pertamax, Pertalite, Premium, Naphtha, Avtur, Kerosine, ADO (Solar 48), Pertamina Dex 50 PPM, Medium Distilate Fuel (MDF), Marine Fuel Oil (MFO), LSFO (LSWR), Crude Oil, LPG, Natural Gas, Air limbah",
    "28 Maret 2028",
    "",
  ],
  [
    "LP-1774-IDN",
    "Yes",
    "Unit Pelaksana Teknis (UPT) Laboratorium Dasar dan Terpadu Universitas Jambi",
    "Jl. Raya Jambi - Muara Bulian KM. 15, Mendalo Indah, Jambi",
    "",
    "Pakan ternak non ruminansia, pakan ternak ruminansia, bahan pakan Soya Bean Meal",
    "28 Maret 2028",
    "",
  ],
  [
    "LP-1775-IDN",
    "Yes",
    "PT Pertamina Patra Niaga - Laboratorium Fuel Terminal Tuban",
    "Jl. Tanjung Awa-awar, Jenu, Tuban, Jawa Timur",
    "(0356) 491140",
    "Pertalite, Pertamax, Solar, Biosolar, FAME",
    "28 Maret 2028",
    "",
  ],
  [
    "LP-1776-IDN",
    "Yes",
    "Balai Pengawas Obat dan Makanan di Mamuju",
    "Jl. Poros Mamuju - Kalukku, KM. 13 Bambu, Kab. Mamuju, Sulawesi Barat",
    "(0426) 2322759",
    "Tablet Guafenisin, Minuman Ringan (Sirup)",
    "28 Maret 2028",
    "",
  ],
  [
    "LP-1777-IDN",
    "Yes",
    "PT Reka Banu Pratama - Synergy Geoenvi Laboratory",
    "Jl. Dago Resort Sentra Dago Ruko No. A2 RT 02 RW 07, Mekarsaluyu, Cimenyan, Kab. Bandung, Jawa Barat",
    "(022) 20469340",
    "Tanah, air tanah, air limbah",
    "28 Maret 2028",
    "",
  ],
  [
    "LP-1778-IDN",
    "Yes",
    "Loka Pengujian Standar Instrumen Ruminansia Besar",
    "Jl. Pahlawan No. 02, Grati-Pasuruan, Jawa Timur",
    "(0343) 48131/481132",
    "Pakan (konsentrat sapi, konsentrat kambing, dan konsentrat ayam), dan bahan pakan ternak (dedak, tepung jagung, rumput, legum)",
    "28 Maret 2028",
    "",
  ],
  [
    "LP-1779-IDN",
    "Yes",
    "Unit Pelaksana Teknis (UPT) Laboratorium Penelitian Terpadu Universitas Sumatera Utara",
    "Jl. Tridharma, Kampus Universitas Sumatera Utara, Medan, Sumatera Utara",
    "",
    "Air untuk keperluan higiene sanitasi, air limbah",
    "28 Maret 2028",
    "",
  ],
  [
    "LP-1780-IDN",
    "Yes",
    "Unit Pelaksana Teknis Daerah (UPTD) Laboratorium Lingkungan Kabupaten Tabalong",
    "Jl. A. Yani, Desa Maburai, Kec. Murung Pudak, Kab. Tabalong, Kalimantan Selatan",
    "(0526) 2021390",
    "Air limbah, air sungai dan air danau",
    "28 Maret 2028",
    "",
  ],
  [
    "LP-1781-IDN",
    "Yes",
    "PT ICP Elaborasi Surabaya",
    "Jl. Raya Bangkingan No. 89A, Surabaya, Jawa Timur",
    "(031) 99429766",
    "Pupuk fosfat alam untuk pertanian, pupuk NPK padat, pupuk SP-36, pupuk triple super fosfat, pupuk urea, pupuk amonium sulfat, pupuk kalium klorida, pupuk dolomit, pupuk organik padat, garam konsumsi beryodium, beras, minyak goreng sawit",
    "28 Maret 2028",
    "",
  ],
  [
    "LP-1782-IDN",
    "Yes",
    "Perumda Air Minum Tirta Pakuan Kota Bogor",
    "Jl. Raya Cipaku No. 8, Bogor, Jawa Barat",
    "(0251) 8324111",
    "Air sungai, air bersih, air minum",
    "28 Maret 2028",
    "",
  ],
  [
    "LP-1783-IDN",
    "Yes",
    "Biro Laboratorium Kedokteran Kesehatan Pusdokkes Polri-Bidang Laboratorium Biomedik",
    "Jl. Cipinang Baru Raya No. 3b, Cipinang, Pulogadung, Jakarta Timur, DKI Jakarta",
    "(021) 4722055",
    "Urin",
    "28 Maret 2028",
    "",
  ],
  [
    "LP-1784-IDN",
    "Yes",
    "PT Global Inspeksi Sistem (multilokasi)",
    "Lokasi 1: Jl. Daan Mogot No. 89, RTm002 RW 002 Kel. Wijaya Kusuma, Kec. Grogol Petamburan, Jakarta Barat, DKI Jakarta Lokasi 2: Jl. Pahlawan No. 2, Kwadengan Barat, Kab. Sidoarjo, Jawa Timur",
    "081382621619",
    "Lokasi 1: CPO, RBD Palm Stearin, RBD Palm Olein, Palm Kernel, Pupuk NPK padat, pupuk urea, pupuk KCl, pupuk fosfat alam untuk pertanian, pupuk ZA, pupuk TSP, pupuk SP36, minyak makan merah, minyak goreng sawit.",
    "28 Maret 2028",
    "",
  ],
  [
    "LP-1785-IDN",
    "Yes",
    "Unit Pelaksana Teknis Daerah (UPTD) Pengujian Pakan dan Pembibitan Ternak, Dinas Pertanian Provinsi Banten \x{2013} Laboratorium Pengujian Mutu Pakan Ternak (LPMPT)",
    "Jl. Syech Nawawi Al Bantani, Kawasan Sistem Pertanian Terpadu, Curug, Serang, Banten",
    "(0254) 7916377",
    "Pakan unggas, ruminansia, monogastrik",
    "10 April 2028",
    "",
  ],
  [
    "LP-1786-IDN",
    "Yes",
    "Politeknik Kesehatan Kementerian Kesehatan Semarang - Laboratorium Radiologi Jurusan Teknik Radiodiagnostik dan Radioterapi",
    "Jl. Tirto Agung Pedalangan Banyumanik, Semarang, Jawa Tengah",
    "(024) 7471258",
    "Pesawat sinar-X Dental Intra Oral/Extra Oral, pesawat sinar-X Radiografi umum/mobile",
    "10 April 2028",
    "",
  ],
  [
    "LP-1787-IDN",
    "Yes",
    "Balai Besar Pelaksanaan Jalan Nasional Sulawesi Selatan",
    "Jl. Batara Bira No.14 Km.16 Baddoka, Makassar, Sulawesi Selatan",
    "(0411) 510210",
    "Aspal keras, tanah, beton silinder, agregat halus dan kasar, campuran beraspal",
    "16 April 2028",
    "",
  ],
  [
    "LP-1788-IDN",
    "Yes",
    "PT Pertamina Energy Terminal - Fuel Terminal Kotabaru",
    "Jl. Hasan Basri Km. 4,5, Kotabaru, Kalimantan Selatan",
    "(0518) 21624",
    "Pertalite, Pertamax, Pertadex, Biosolar, Dexlite, MFO",
    "16 April 2028",
    "",
  ],
  [
    "LP-1789-IDN",
    "Yes",
    "PT Prima Agro Tech",
    "Jl. Imam Bonjol No.9A Rt 02 Rw 04 Desa/Kel. Bojong Jaya, Kec. Karawaci, Kota Tangerang, Banten",
    "(021) 5520461",
    "Bioinsektisida (metarizep, BT plus), Biofungsida (Primadeco), Pupuk Hayati (Oriza Plus)",
    "16 April 2028",
    "",
  ],
  [
    "LP-1790-IDN",
    "Yes",
    "Unit Pelaksana Teknis (UPT) Balai Kesehatan Hewan, Kesehatan Masyarakat Veteriner dan Klinik Hewan Sulawesi Selatan",
    "Jl. Veteran Selatan No. 234, Makassar, Sulawesi Selatan",
    "(0411) 873770",
    "Serum darah sapi, serum darah ayam",
    "16 April 2028",
    "",
  ],
  [
    "LP-1791-IDN",
    "Yes",
    "PT Bintang Gasing Persada",
    "Jl. Tanjung Api-api KM. 10 Desa Gasing Kec. Talang Kelapa, Kab. Banyuasin, Sumatera Selatan",
    "(0711) 5717288",
    "Karet alam (SIR)",
    "16 April 2028",
    "",
  ],
  [
    "LP-1792-IDN",
    "Yes",
    "PT Mustika Sembuluh - Laboratorium EMU R&amp;D",
    "Jl. Jendral Sudirman KM 62, Kec. Mentaya Hilir Utara, Kab. Kotawaringin Timur, Kalimantan Tengah",
    "(0531) 34802",
    "Pupuk NPK Padat",
    "16 April 2028",
    "",
  ],
  [
    "LP-1793-IDN",
    "Yes",
    "PT Energi Sejahtera Mas",
    "Jl. Raya Lubuk Gaung Dusun Nerbit Kecil, Kel. Lubuk Gaung, Kec. Sungai Sembilan, Dumai, Riau",
    "(0765) 7151000",
    "Fatty acid, Fatty Alcohol, Glycerine",
    "16 April 2028",
    "",
  ],
  [
    "LP-1794-IDN",
    "Yes",
    "Unit Pelaksana Teknis (UPT) Laboratorium Kesehatan dan Kalibrasi Provinsi Kalimantan Tengah",
    "Jl. Letjen Soeprapto No.01, Palangkaraya, Kalimantan Tengah",
    "(0536) 3221106",
    "Air untuk keperluan higine dan sanitasi, air limbah, air sungai, air minum",
    "16 April 2028",
    "",
  ],
  [
    "LP-1795-IDN",
    "Yes",
    "Unit Pelaksana Teknis Daerah (UPTD) Balai Pengujian dan Penerapan Mutu Hasil Perikanan Bitung Kelas A",
    "Kompleks PPS Bitung Jl. Cakalang No. 1 Aertembaga, Bitung, Sulawesi Utara",
    "(0438) 34224",
    "Tuna Beku, Tuna Loin, Tuna Steak Beku, Tuna Saku Beku, Tuna Fillet Beku, Tuna Segar, Tuna Chunk Beku Meat Beku, Tuna Cube Beku, Tuna Ground Meat Beku, Tuna Belly Beku, Ikan Layang Beku, Cakalang Beku, Ikan Segar, Ikan Demersal Beku, Fillet Kakap Beku, Cumi-cumi Beku, Lobster Beku, Udang Beku, Udang Segar, Nike Beku, Teripang Kering, Tuna Kaleng, Cakalang Kaleng, Mackerel Kaleng, Sarden Kaleng, Produk Pengasapan (Ikan Asap, dll), Ikan Kayu, Rumput Laut Kering, Air (PDAM, Sumur dan Processing) dan Es",
    "23 Mei 2028",
    "",
  ],
  [
    "LP-1796-IDN",
    "Yes",
    "Lembaga Ilmu Hayati Teknik &amp; Rekayasa Universitas Airlangga",
    "Gedung Airlangga Research Hub Kampus C Merr Universitas Airlangga, Jl. Mulyorejo, Surabaya, Jawa Timur",
    "085732806477, 085791376840",
    "Ekstrak tumbuhan (teh), enzim, daging babi dan olahan, ekstrak tanaman obat",
    "23 Mei 2028",
    "",
  ],
  [
    "LP-1797-IDN",
    "Yes",
    "Unit Pelaksana Teknis (UPT) Laboratorium Kesehatan dan Lingkungan Dinas Kesehatan Provinsi Riau",
    "Jl. Mustika No. 3A. Pekanbaru, Riau",
    "(0761) 22018-22318",
    "Air limbah",
    "23 Mei 2028",
    "",
  ],
  [
    "LP-1798-IDN",
    "Yes",
    "Unit Pelaksana Teknis Daerah (UPTD) Balai Peralatan dan Pengujian Dinas Pekerjaan Umum, Penataan Ruang, Perumahan dan Kawasan Permukiman Provinsi Bali",
    "Jl. Cokroaminoto No. 11, Ubung, Denpasar, Bali",
    "(0361) 420410",
    "Aspal, beton, agregat halus dan kasar, baja tulangan beton",
    "23 Mei 2028",
    "",
  ],
  [
    "LP-1799-IDN",
    "Yes",
    "PT Symbion Mono Lab",
    "Jl. Rancabolang. Nomor 36, Bandung, Jawa Barat",
    "(022) 7502184",
    "Tanah, udara ambien, lingkungan kerja",
    "23 Mei 2028",
    "",
  ],
  [
    "LP-1800-IDN",
    "Yes",
    "PT Pertamina Patra Niaga \x{2013} Laboratorium Integrated Terminal Jakarta",
    "Jl. Yos Sudarso Jembatan I, Plumpang, Jakarta Utara, DKI Jakarta",
    "(021) 43923188-43923101",
    "Pertalite, Pertamax, Pertamax Turbo, Biosolar B30, Biodexlite, Pertamina Dex, FAME, Kerosene",
    "23 Mei 2028",
    "",
  ],
  [
    "LP-1801-IDN",
    "Yes",
    "Laboratorium Terpadu, Universitas Islam Negeri Sunan Gunung Djati",
    "Lokasi Pusat: Gedung Sholahudin Sanusi, Jl. A.H. Nasution No. 105, Cipadung Wetan, Cibiru, Kota Bandung, Jawa Barat Lokasi Laboratorium: Gedung Laboratorium Integrasi MIPA, Jl. Cimencrang, Cimencrang, Gedebage, Kota Bandung, Jawa Barat",
    "(022) 7800525",
    "Daging segar dan produk olahan berbahan daging (kornet, bakso, sosis, nuget, dendeng, daging asap)",
    "23 Mei 2028",
    "",
  ],
  [
    "LP-1802-IDN",
    "Yes",
    "Laboratorium Lingkungan Dinas Lingkungan Hidup Kabupaten Kediri",
    "Jl. Mayor Bismo No. 28 Kelurahan Semampir Kecamatan Mojoroto, Kota Kediri, Jawa Timur",
    "(0354) 699372",
    "Air sungai dan air embung",
    "23 Mei 2028",
    "",
  ],
  [
    "LP-1803-IDN",
    "Yes",
    "PT Wijaya Karya Beton, Tbk - Laboratorium Riset",
    "Jl. Raya Narogong Km.26, Kel. Cileungsi, Kec. Cileungsi, Kab. Bogor, Jawa Barat",
    "(021) 8192802",
    "Agregat halus dan kasar, beton, tiang pancang beton pracetak prategang, turap beton pracetak prategang, baja tulangan beton",
    "23 Mei 2028",
    "",
  ],
  [
    "LP-1804-IDN",
    "Yes",
    "PT Garuda Metalindo Tbk",
    "Jl. Kapuk Kamal Raya No.23, Penjaringan, Jakarta Utara, DKI Jakarta",
    "(021) 5553963",
    "Baja",
    "23 Mei 2028",
    "",
  ],
  [
    "LP-1805-IDN",
    "Yes",
    "Unit Pelaksana Teknis Daerah (UPTD) Laboratorium Lingkungan Hidup Provinsi Sulawesi Tenggara",
    "Kompleks Bumi Praja Anduonohu, Poasia, Kendari, Sulawesi Tenggara",
    "(0401) 3127760",
    "Air Sungai",
    "06 Juni 2028",
    "",
  ],
  [
    "LP-1806-IDN",
    "Yes",
    "Unit Pelaksana Teknis (UPT) Laboratorium Kesehatan Kelas A pada Dinas Kesehatan Kabupaten Bogor",
    "Jl. KSR Dadi Kusmayadi No.27B, Kec. Cibinong, Kabupaten Bogor, Jawa Barat",
    "(021) 8753269",
    "Air untuk keperluan hygiene dan sanitasi, Air minum",
    "06 Juni 2028",
    "",
  ],
  [
    "LP-1807-IDN",
    "Yes",
    "Laboratorium Klaster Molecular Biology and Proteomics Core Facilites (MBPCF) - Indonesian Medical Education and Research Institute (IMERI) Fakultas Kedokteran Universitas Indonesia",
    "Gedung IMERI FKUI Lantai 7 Tower Riset, Jl. Salemba Raya No. 6, Jakarta Pusat, DKI Jakarta",
    "(021) 29189160 ext. 201702",
    "Darah, Jaringan, Sel kultur, Isolat RNA, RNA",
    "06 Juni 2028",
    "",
  ],
  [
    "LP-1808-IDN",
    "Yes",
    "Unit Kerja Khusus Pelayanan dan Pengabdian Masyarakat Laboratorium Mikrobiologi Klinik Fakultas Kedokteran Universitas Indonesia",
    "Jl. Pegangsaan Timur 16, Cikini, RT.1/RW.1, Pegangsaan, Kecamatan Menteng, Jakarta Pusat, DKI Jakarta",
    "(021) 31922850",
    "RDT Antigen Covid-19, Kit PCR Covid-19",
    "06 Juni 2028",
    "",
  ],
  [
    "LP-1809-IDN",
    "Yes",
    "PT Medion Farma Jaya",
    "Jl. Raya Batujajar No. 29, Cimareme, Kec. Ngamprah, Kab. Bandung Barat, Jawa Barat",
    "(022) 6866090",
    "Serum ayam dan itik",
    "06 Juni 2028",
    "",
  ],
  [
    "LP-1810-IDN",
    "Yes",
    "PT Laboratorindo Alam Bestari",
    "Jl. H.M. Ardans Ring Road 3, Rt. 01, Kavling S11 &amp; S12 (Simpang SMA IT Granada); Kel. Bukit Pinang, Kec. Samarinda Ulu, Kota Samarinda, Prov. Kalimantan Timur",
    "(0541) 2923383, 08115833982",
    "Air Sungai, Air untuk kepentingan higiene sanitasi, Air Limbah, Kebisingan , Udara Emisi Sumber Tidak Bergerak",
    "06 Juni 2028",
    "",
  ],
  [
    "LP-1811-IDN",
    "Yes",
    "Direktorat Bina Teknik Permukiman dan Perumahan",
    "Pusat : Jl. Pattimura No. 20, Kebayoran Baru, Jakarta Selatan, DKI Jakarta Laboratorium: Jl. Panyaungan, Cileunyi Wetan, Kabupaten Bandung, Jawa Barat",
    "022) 7798393 ext 273",
    "Tiang pancang beton pracetak prategang, Turap beton pracetak prategang, Baja tulangan beton, Beton silinder, Bata ringan, Bahan bangunan, Pintu, plafound dan komponen struktur non baja (dinding, plat lantai, kolom, balok), Komponen struktur baja (dinding, plat lantai, kolom, balok) dan bahan penghambat api, Komponen partisi bangunan gedung (dinding, pintu, jendela), Komponen bangunan",
    "06 Juni 2028",
    "",
  ],
  [
    "LP-1812-IDN",
    "Yes",
    "PT Sumber IndahPerkasa - QFS",
    "Jl. Raya Tarahan-Bakauheni KM, 17, Dusun Sukamaju, Desa Rangai Tritunggal, Katibung, Bandar Lampung, Lampung",
    "(0721) 341779",
    "Crude Palm Oil (CPO), Crude Palm Kernel Oil (CPKO), RBD Palm Oil (RBDPO), RBD Palm Stearin (RBDPST), RBD Palm Olein (RBDPOL), RBD Palm Kernel Oil (RBDPKO), RBD Palm Kernel Olein (RBDPKOL), RBD Palm Kernel Stearin (RBDPKST), Palm Fatty Acid Distillate (PFAD), Palm Kernel Fatty Acid Distillate (PKFAD), Palm Kernel Expeller (PKE)",
    "06 Juni 2028",
    "",
  ],
  [
    "LP-1813-IDN",
    "Yes",
    "PT Envirotama Solusindo",
    "Jl. Jatiwangi-Cikedokan No. 84, Kp. Kamurang, Cikedokan, Cikarang Barat, Kab. Bekasi, Jawa Barat",
    "(021) 85934498",
    "Fume Hood, Laminar Air Flow, Biological Safety Cabinet, Room/Cabinet/Machine",
    "20 Juni 2028",
    "",
  ],
  [
    "LP-1814-IDN",
    "Yes",
    "Unit Layanan Pengujian Fakultas Farmasi Universitas Airlangga",
    "Kampus B UNAIR, Jl. Dharmawangsa Dalam, Surabaya, Jawa Timur",
    "(031) 5036779",
    "Alat kesehatan (disposable syringe, feeding tube, folley catheter, infusion set, IV catheter, stomach tube, suction catheter steril, surgical gloves, surgical suture, wing needle, stopcock tube, dermafix, catgut surgical), Detergen cuci cair untuk pakaian, Detergen cuci cair untuk alat dapur, Deterjen serbuk, pelembut pakaian, pewangi pelicin pakaian, obat tradisional (serbuk, kapsul, pil, cair), Kosmetik (krim, cair, padat)",
    "20 Juni 2028",
    "",
  ],
  [
    "LP-1815-IDN",
    "Yes",
    "Pusat Pengembangan Ilmu Teknik untuk Pertanian Tropika (CREATA) Lembaga Penelitian dan Pengabdian kepada Masyarakat Institut Pertanian Bogor - Laboratorium Pengujian Alat Mesin dan Prasarana Pertanian",
    "Jl. Lingkar Akademik, Kampus IPB Dramaga, Babakan, Dramaga, Kabupaten Bogor, Jawa Barat",
    "(0251) 8621887/6",
    "Sprayer gendong elektrik, sprayer gendong semi-otomatis",
    "20 Juni 2028",
    "",
  ],
  [
    "LP-1816-IDN",
    "Yes",
    "PT Sehat Cerah Indonesia",
    "Kantor Pusat: Jl. RS. Fatmawati No. 39, Komp. Duta Mas Fatmawati Blok A1 No. 30- 32, Desa/Kelurahan Cipete Utara, Kec. Kebayoran Baru, Kota Adm. Jakarta Selatan, DKI Jakarta Laboratorium: Jl. Otto Iskandardinata No. 136 Kel. Karanganyar, Kec. Subang, Kab. Subang, Jawa Barat",
    "(0260) 416447",
    "Serum ayam",
    "20 Juni 2028",
    "",
  ],
  [
    "LP-1817-IDN",
    "Yes",
    "PT Vaksindo Satwa Nusantara",
    "Jl. Marcedes Benz No. 12, Cicadas, Gunung Putri, Bogor, Jawa Barat",
    "(021) 86770414",
    "Serum ayam, vaksin untuk ayam, antigen untuk pembuatan vaksin, swab trakea, swan kloaka, cairan alantois dan organ ayam",
    "20 Juni 2028",
    "",
  ],
  [
    "LP-1818-IDN",
    "Yes",
    "PT Asiatrust Technovima Qualiti Cabang Tamiang Layang",
    "Jl. Jend. A. Yani Km. 2, Kel. Tamiang Layang, Kec. Dusun Timur, Kab. Barito Timur, Kalimantan Tengah",
    "(0511) 4221539/(0526) 2092977",
    "Batubara",
    "20 Juni 2028",
    "",
  ],
  [
    "LP-1819-IDN",
    "Yes",
    "PT Charoen Pokphand Indonesia \x{2013} Food Division, Regional Laboratory Cikande",
    "Kawasan Modern Industrial Estate Kav. 6-8, Jl. Modern Industri IV, Nambo Ilir, Kec. Cikande, Kab. Serang, Banten",
    "(0254) 402628",
    "Daging dan olahan daging",
    "20 Juni 2028",
    "",
  ],
  [
    "LP-1820-IDN",
    "Yes",
    "Laboratorium Forensik Digital - Direktorat Siber Obat dan Makanan, Badan Pengawas Obat dan Makanan",
    "Jl. Percetakan Negara No. 23, RT.23/RW.7, Johar Baru, Kec. Johar Baru, Jakarta Pusat, DKI Jakarta",
    "(021) 4244691, 4209221, 4263333, 4244755, 4241781",
    "Mobile phone",
    "20 Juni 2028",
    "",
  ],
  [
    "LP-1821-IDN",
    "Yes",
    "PT Global Environment Laboratory Cabang Makassar",
    "Jl. Cendrawasih No. 256 Komplek Ruko Cendrawasih Square Blok D4-E4, Makassar, Sulawesi Selatan",
    "081241627942",
    "Air Untuk Keperluan Hygiene dan Sanitasi, Air Sungai, Air Limbah, Udara Ambien, Kebisingan, Lingkungan Kerja, Udara emisi sumber tidak bergerak, Emisi gas buang kendaraan bermotor tipe M, N, O",
    "05 Juli 2028",
    "",
  ],
  [
    "LP-1822-IDN",
    "Yes",
    "PT Saba Indomedika",
    "Ruko Kedoya Elok Plaza Blok DB-33 Jl. Panjang no 7-9 Jakarta Barat, DKI Jakarta",
    "(021) 58356886",
    "Pesawat sinar X radiografi umum",
    "05 Juli 2028",
    "",
  ],
  [
    "LP-1823-IDN",
    "Yes",
    "PT Sarana Reka Eltra Kencana",
    "Rukan Artha Gading Niaga Blok H Kav. 28 Jl. Boulevard Artha Gading, Kelapa Gading Barat, Jakarta Utara, DKI Jakarta",
    "(021) 29365355",
    "Pesawat Sinar-x Radiografi Umum",
    "05 Juli 2028",
    "",
  ],
  [
    "LP-1824-IDN",
    "Yes",
    "PT Multi Sarana Indotani",
    "Desa Lengkong, Kecamatan Mojoanyar, Kabupaten Mojokerto, Jawa Timur",
    "(0321) 331219 ext 108",
    "Pupuk NPK Padat",
    "05 Juli 2028",
    "",
  ],
  [
    "LP-1825-IDN",
    "Yes",
    "PT Pertamina Patra Niaga, Laboratorium Integrated Terminal Surabaya",
    "Jl. Perak Barat No. 277, Surabaya, Jawa Timur",
    "(031) 3294962, 3293895",
    "Pertalite, Pertamax, Pertamax Turbo, Solar, Biosolar (B30), Dexlite, Pertamina Dex, LSFO, Avtur, FAME",
    "05 Juli 2028",
    "",
  ],
  [
    "LP-1826-IDN",
    "Yes",
    "PT Delta Jaya Globalindo",
    "Jl. Terusan Bukit Dago Selatan I No. 4, RT 01 RW 03, Kelurahan Dago, Kecamatan Coblong, Kota Bandung, Jawa Barat",
    "08112133895, 08998587272",
    "Kebisingan, Lingkungan Kerja",
    "05 Juli 2028",
    "",
  ],
  [
    "LP-1827-IDN",
    "Yes",
    "Laboratorium FSQR (Food Safety Quality and Regulatory) \x{2013} PT Cargill Indonesia",
    "Beta Plot No. 2, Kawasan Industri Maspion Jl. Raya Manyar KM 25, Desa Manyar Sidomukti, Kecamatan Manyar, Gresik, Jawa Timur",
    "(031) 293 7800",
    "Cocoa Powder, Cocoa Butter, Cocoa Cake, Cocoa Mass",
    "05 Juli 2028",
    "",
  ],
  [
    "LP-1828-IDN",
    "Yes",
    "PT Famed Calibration",
    "Jl. Radar Auri Ruko Pondok Cibubur Blok E No.11 Cimanggis, Depok, Jawa Barat",
    "(021) 8730470",
    "Pesawat sinar-x radiografi umum",
    "25 Juli 2028",
    "",
  ],
  [
    "LP-1829-IDN",
    "Yes",
    "PT Asianagro Agungjaya",
    "Jl. Semarang Blok A6 No. 1 KBN Marunda, Jakarta Utara, DKI Jakarta",
    "(021) 4402591",
    "Crude Palm Oil (CPO), Edible Oil Refined Fractionated Oil, Edible Texturized Oil (Fat)",
    "25 Juli 2028",
    "",
  ],
  [
    "LP-1830-IDN",
    "Yes",
    "PT Prima Ediza Jaya",
    "Jl. Ciliwung No. 10, Kav. 2, RT 006 RW 013, Purwantoro Blimbing, Malang, Jawa Timur",
    "(0341) 482400",
    "Air Reverse Osmosis (RO)",
    "06 Agustus 2028",
    "",
  ],
  [
    "LP-1831-IDN",
    "Yes",
    "PT Arasy Analitical Research Laboratories",
    "Graha Niaga Blok H No. 10, Jl Letjen Ibrahim Adji Sindang Barang, Bogor, Jawa Barat",
    "(0251) 7588781",
    "Air sungai, air danau, air laut, air limbah, udara ambien",
    "25 Juli 2028",
    "",
  ],
  [
    "LP-1832-IDN",
    "Yes",
    "PT Eka Akurasi Envitama",
    "Jl. Gema Insani No.37A RT 02 RW 021, Bakti Jaya, Sukmajaya, Depok, Jawa Barat",
    "(021) 77837672",
    "Air limbah, air sungai, air danau, air untuk keperluan higiene sanitasi, udara ambien, udara lingkungan kerja, kebisingan, udara emisi sumber tidak bergerak, tanah",
    "25 Juli 2028",
    "",
  ],
  [
    "LP-1833-IDN",
    "Yes",
    "Unit Pelaksana Teknis Daerah (UPTD) Balai Pengujian Penelitian dan Pengembangan Lingkungan Dinas Lingkungan Hidup dan Kehutanan Aceh",
    "Jl. Tgk. Meulagu No. 6, Desa Tibang, Kec. Syiah Kuala, Kota Banda Aceh, Aceh",
    "082312001976",
    "Air permukaan (air sungai, air sumur, air danau, air rawa), air limbah",
    "25 Juli 2028",
    "",
  ],
  [
    "LP-1834-IDN",
    "Yes",
    "Balai Pengujian dan Sertifikasi Mutu Barang Semarang",
    "Jl. Brigjen Sudiarto No. 327, Pedurungan, Semarang, Jawa Tengah",
    "(024) 76413336",
    "Beras",
    "25 Juli 2028",
    "",
  ],
  [
    "LP-1835-IDN",
    "Yes",
    "PT Kaken Indonesia",
    "Wisma Mampang Lantai 1, Jl. Mampang Prapatan Raya No. 1, Mampang Prapatan, Jakarta Selatan, DKI Jakarta",
    "(021) 79184325/26",
    "Tekstil",
    "25 Juli 2028",
    "",
  ],
  [
    "LP-1836-IDN",
    "Yes",
    "Laboratorium Konstruksi Dinas Pekerjaan Umum dan Penataan Ruang Kabupaten Purworejo",
    "Jl. Yogyakarta Km.5, Purworejo, Jawa Tengah",
    "(0275) 321676",
    "Beton silinder, mortar semen portland, bata beton (paving block)",
    "25 Juli 2028",
    "",
  ],
  [
    "LP-1837-IDN",
    "Yes",
    "PT Asia Sakti Wahid Foods Manufacture",
    "Jl. Pertahanan I No. 7, Kel, Timbang Deli, Kec. Medan Amplas, Medan, Sumatera Utara",
    "(061) 7861008",
    "Biskuit",
    "25 Juli 2028",
    "",
  ],
  [
    "LP-1838-IDN",
    "Yes",
    "Balai Geoteknik, Terowongan dan Struktur",
    "Jl. A.H. Nasution No. 264, Kec. Arcamanik, Bandung, Jawa Barat",
    "(022) 7834487",
    "Tanah, Geosintetik/Geotekstil, Geogrides, Logam, Baja Tulangan Beton, Beton, Karet",
    "06 Agustus 2028",
    "",
  ],
  [
    "LP-1839-IDN",
    "Yes",
    "Politeknik Negeri Lampung - Laboratorium Analisis",
    "Jl. Soekarno Hatta Rajabasa, Bandar Lampung, Lampung",
    "(0721) 703995",
    "Pupuk NPK padat, pupuk organik padat, tanah",
    "22 Agustus 2028",
    "",
  ],
  [
    "LP-1840-IDN",
    "Yes",
    "Unit Pelaksana Teknis Daerah (UPTD) Balai Pengawasan dan Sertifikasi Benih Tanaman Pangan Provinsi Sulawesi Tenggara",
    "Jl. Piere Tendean No. 40 Kecamatan Baruga, Kota Kendari, Sulawesi Tenggara",
    "(0401) 3194090",
    "Benih padi, benih kedelai, benih jagung, benih sorgum",
    "22 Agustus 2028",
    "",
  ],
  [
    "LP-1841-IDN",
    "Yes",
    "PT Geoservices Cabang Sofifi",
    "Jl. Pemuda RT. 009 RW. 005 Kel. Desa Bukit Durian, Kec. Oba Utara Kota Tidore, Kepulauan Maluku Utara",
    "085391267656",
    "Batubara, Nickel Ore, Limestone/Quicklime",
    "22 Agustus 2028",
    "",
  ],
  [
    "LP-1842-IDN",
    "Yes",
    "Unit Pelaksana Teknis Daerah (UPTD) Laboratorium Bahan Konstruksi, Dinas Pekerjaan Umum, Penataan Ruang dan Perumahan Rakyat Provinsi Kalimantan Timur",
    "Jl. Teuku Umar No. 1, Samarinda, Kalimantan Timur",
    "(0541) 2782220",
    "Agregat kasar dan halus",
    "22 Agustus 2028",
    "",
  ],
  [
    "LP-1843-IDN",
    "Yes",
    "Laboratorium Forensik Digital - Direktorat Operasi Keamanan Siber, Badan Siber dan Sandi Negara",
    "Jl. Harsono RM No.70 Ragunan, Kec. Pasar Minggu, Jakarta Selatan, DKI Jakarta",
    "(021) 7805814",
    "Komputer dan media penyimpanan digital, perangkat seluler, sim card &amp; memory card",
    "22 Agustus 2028",
    "",
  ],
  [
    "LP-1844-IDN",
    "Yes",
    "Unit Pelaksana Teknis Daerah (UPTD) Laboratorium Lingkungan Dinas Lingkungan Hidup Kabupaten Bekasi",
    "Komplek Perkantoran Pemerintah Kabupaten Bekasi Desa Sukamahi - Cikarang Pusat, Kab Bekasi, Jawa Barat",
    "",
    "Air sungai, air limbah",
    "22 Agustus 2028",
    "",
  ],
  [
    "LP-1845-IDN",
    "Yes",
    "PT Star Cosmos",
    "Jl. KH. Agus Salim No. 38 Kel. Poris Plawad Kec Cipondoh, Tangerang, Banten",
    "(021) 55762485 ext 24307",
    "Kipas angin, penanak nasi",
    "22 Agustus 2028",
    "",
  ],
  [
    "LP-1846-IDN",
    "Yes",
    "Fakultas Kedokteran Universitas Padjadjaran - Laboratorium Biomedik",
    "Rumah Sakit Pendidikan UNPAD (Gedung PAMITRAN-UP) Jl. Prof. Eyckman No.38, Bandung, Jawa Barat",
    "(022) 84288888",
    "RDT Antigen Covid-19, RDT Antigen Malaria",
    "30 Agustus 2028",
    "",
  ],
  [
    "LP-1847-IDN",
    "Yes",
    "PT Suprabari Mapanindo Mineral",
    "Jl. Pendreh No.70 Lanjas, Desa/Kelurahan Lemo II, Kec.Teweh Tengah, Kab. Barito Utara, Kalimantan Tengah",
    "081318066766",
    "Batubara",
    "30 Agustus 2028",
    "",
  ],
  [
    "LP-1848-IDN",
    "Yes",
    "PT Indal Steel Pipe",
    "Kawasan Industri Maspion Unit V, Sukomulyo, Manyar, Gresik, Jawa Timur",
    "(031) 3952863/64",
    "Logam baja karbon (pipa, plat dan batangan)",
    "12 September 2028",
    "",
  ],
  [
    "LP-1849-IDN",
    "Yes",
    "PT Spektrum Kreasi Pratama",
    "Jl. KH.M.Yusuf Raya No.14, Mekar Jaya, Sukmajaya, Depok, Jawa Barat",
    "(021) 29441428",
    "Pesawat sinar X radiografi umum",
    "12 September 2028",
    "",
  ],
  [
    "LP-1850-IDN",
    "Yes",
    "PT Lotus Lingga Pratama",
    "Jl. Industrial Cimareme No 11B, Bandung, Jawa Barat",
    "(022) 86678996/97/98",
    "Perhiasan emas, gold bar",
    "12 September 2028",
    "",
  ],
  [
    "LP-1851-IDN",
    "Yes",
    "PT Pro Labviron Indonesia",
    "Jl. Modern Industri XV Blok AD No. 4, Kawasan Industri Modern, Sukatani, Cikande, Serang, Banten",
    "",
    "Air sungai, air limbah, air minum, air untuk keperluan higiene dan sanitasi, udara ambien, udara lingkungan kerja, emisi sumber tidak bergerak, padatan (B3) non-TCLP",
    "12 September 2028",
    "",
  ],
  [
    "LP-1852-IDN",
    "Yes",
    "PT Suri Tani Pemuka - Nutrition Lab",
    "Jl. Raya Manyar Barat, Manyarejo, Manyar, Gresik, Jawa Timur",
    "(031) 2931678",
    "Tepung Ikan (Fish Meal), Pakan Udang (Shrimp Feed), Pakan Ikan (Fish Feed)",
    "12 September 2028",
    "",
  ],
];
# END FRAGMENT id=data-idn_kan_client_lab_testing

around new => sub {
    my $orig = shift;
    my $self = shift;

    $orig->(
        $self,
        column_names => [ sort {
            $meta->{fields}{$a}{pos} <=>
            $meta->{fields}{$b}{pos};
        } keys %{ $meta->{fields} } ],
        aoa => $data,
        @_,
    );
};

package TableData::Business::ID::KAN::Client::Lab::Testing;

use 5.010001;
use strict;
use warnings;

use Role::Tiny::With;

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2023-09-23'; # DATE
our $DIST = 'TableData-Business-ID-KAN-Client-Lab-Testing'; # DIST
our $VERSION = '20230922.0'; # VERSION

with 'TableDataRole::Business::ID::KAN::Client::Lab::Testing';

our %STATS = ("num_rows",1597,"num_columns",8); # STATS

1;
# ABSTRACT: Accredited testing laboratories

__END__

=pod

=encoding UTF-8

=head1 NAME

TableDataRole::Business::ID::KAN::Client::Lab::Testing - Accredited testing laboratories

=head1 VERSION

This document describes version 20230922.0 of TableDataRole::Business::ID::KAN::Client::Lab::Testing (from Perl distribution TableData-Business-ID-KAN-Client-Lab-Testing), released on 2023-09-23.

=head1 SYNOPSIS

To use from Perl code:

 use TableData::Business::ID::KAN::Client::Lab::Testing;

 my $td = TableData::Business::ID::KAN::Client::Lab::Testing->new;

 # Iterate rows of the table
 $td->each_row_arrayref(sub { my $row = shift; ... });
 $td->each_row_hashref (sub { my $row = shift; ... });

 # Get the list of column names
 my @columns = $td->get_column_names;

 # Get the number of rows
 my $row_count = $td->get_row_count;

See also L<TableDataRole::Spec::Basic> for other methods.

To use from command-line (using L<tabledata> CLI):

 # Display as ASCII table and view with pager
 % tabledata Business::ID::KAN::Client::Lab::Testing --page

 # Get number of rows
 % tabledata --action count_rows Business::ID::KAN::Client::Lab::Testing

See the L<tabledata> CLI's documentation for other available actions and options.

=head1 DESCRIPTION

Keyword: KAN, laboratorium penguji

=head1 TABLEDATA STATISTICS

 +-------------+-------+
 | key         | value |
 +-------------+-------+
 | num_columns | 8     |
 | num_rows    | 1597  |
 +-------------+-------+

The statistics is available in the C<%STATS> package variable.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/TableData-Business-ID-KAN-Client-Lab-Testing>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-TableData-Business-ID-KAN-Client-Lab-Testing>.

=head1 SEE ALSO

Other C<TableData::Business::ID::KAN::*> modules.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 CONTRIBUTING


To contribute, you can send patches by email/via RT, or send pull requests on
GitHub.

Most of the time, you don't need to build the distribution yourself. You can
simply modify the code, then test via:

 % prove -l

If you want to build the distribution (e.g. to try to install it locally on your
system), you can install L<Dist::Zilla>,
L<Dist::Zilla::PluginBundle::Author::PERLANCAR>,
L<Pod::Weaver::PluginBundle::Author::PERLANCAR>, and sometimes one or two other
Dist::Zilla- and/or Pod::Weaver plugins. Any additional steps required beyond
that are considered a bug and can be reported to me.

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2023 by perlancar <perlancar@cpan.org>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=TableData-Business-ID-KAN-Client-Lab-Testing>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=cut
