#!/usr/bin/perl -T

use Test::More tests => 6;
use Paranoid;
use Paranoid::Debug;
use Paranoid::BerkeleyDB::Env;

use strict;
use warnings;

psecureEnv();

my ( $rv, $dbe, $adbe, $pid, $prv );

mkdir './t/db';

$dbe = new Paranoid::BerkeleyDB::Env;
ok( !defined $dbe, 'invalid invocation - 1' );
$dbe = new Paranoid::BerkeleyDB::Env '-Home' => './t/db';
ok( defined $dbe, 'good invocation - 2' );
$rv = $dbe->env;
is( ref $rv, 'BerkeleyDB::Env', 'env check - 3' );

# Test duplicate handles
$adbe = new Paranoid::BerkeleyDB::Env '-Home' => './t/db';
ok( defined $adbe, 'duplicate handle - 4' );
is( $dbe->env, $adbe->env, 'duplicate handle - 5' );

# Test fork
#PDEBUG = 20;
if ( $pid = fork ) {
    wait;
    $prv = $?;
} else {
    $prv =
        (      ( $rv != $dbe->env )
            && ( $rv != $adbe->env )
            && ( $dbe->env == $adbe->env ) ) ? 0 : 1;
    exit $prv;
    isnt( $rv, $dbe->env,  'reopen environment - 6' );
    isnt( $rv, $adbe->env, 'reopen environment - 7' );
    is( $dbe->env, $adbe->env, 'duplicate handle - 8' );
}

is( $prv, 0, 'forked environment checks - 6' );

# Cleanup
system 'rm -rf t/db';

