/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.server.resource;

import java.io.InputStream;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.cxf.jaxrs.ext.multipart.Attachment;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.RecursiveParserWrapper;
import org.apache.tika.sax.BasicContentHandlerFactory;
import org.apache.tika.sax.RecursiveParserWrapperHandler;
import org.apache.tika.server.MetadataList;
import org.apache.tika.server.resource.TikaResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/rmeta")
public class RecursiveMetadataResource {
    private static final String HANDLER_TYPE_PARAM = "handler";
    private static final BasicContentHandlerFactory.HANDLER_TYPE DEFAULT_HANDLER_TYPE = BasicContentHandlerFactory.HANDLER_TYPE.XML;
    private static final Logger LOG = LoggerFactory.getLogger(RecursiveMetadataResource.class);

    @POST
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"application/json"})
    @Path(value="form{handler : (\\w+)?}")
    public Response getMetadataFromMultipart(Attachment att, @Context UriInfo info, @PathParam(value="handler") String handlerTypeName) throws Exception {
        return Response.ok(this.parseMetadata(att.getObject(InputStream.class), att.getHeaders(), info, handlerTypeName)).build();
    }

    @PUT
    @Produces(value={"application/json"})
    @Path(value="{handler : (\\w+)?}")
    public Response getMetadata(InputStream is, @Context HttpHeaders httpHeaders, @Context UriInfo info, @PathParam(value="handler") String handlerTypeName) throws Exception {
        return Response.ok(this.parseMetadata(TikaResource.getInputStream(is, httpHeaders), httpHeaders.getRequestHeaders(), info, handlerTypeName)).build();
    }

    private MetadataList parseMetadata(InputStream is, MultivaluedMap<String, String> httpHeaders, UriInfo info, String handlerTypeName) throws Exception {
        Metadata metadata = new Metadata();
        ParseContext context = new ParseContext();
        Parser parser = TikaResource.createParser();
        RecursiveParserWrapper wrapper = new RecursiveParserWrapper(parser);
        TikaResource.fillMetadata(parser, metadata, context, httpHeaders);
        TikaResource.fillParseContext(context, httpHeaders, null);
        TikaResource.logRequest(LOG, info, metadata);
        BasicContentHandlerFactory.HANDLER_TYPE type = BasicContentHandlerFactory.parseHandlerType(handlerTypeName, DEFAULT_HANDLER_TYPE);
        RecursiveParserWrapperHandler handler = new RecursiveParserWrapperHandler(new BasicContentHandlerFactory(type, -1), -1);
        TikaResource.parse(wrapper, LOG, info.getPath(), is, handler, metadata, context);
        return new MetadataList(handler.getMetadataList());
    }
}

