# Generated by default/object.tt
package Paws::GreengrassV2::DeploymentIoTJobConfiguration;
  use Moose;
  has AbortConfig => (is => 'ro', isa => 'Paws::GreengrassV2::IoTJobAbortConfig', request_name => 'abortConfig', traits => ['NameInRequest']);
  has JobExecutionsRolloutConfig => (is => 'ro', isa => 'Paws::GreengrassV2::IoTJobExecutionsRolloutConfig', request_name => 'jobExecutionsRolloutConfig', traits => ['NameInRequest']);
  has TimeoutConfig => (is => 'ro', isa => 'Paws::GreengrassV2::IoTJobTimeoutConfig', request_name => 'timeoutConfig', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::GreengrassV2::DeploymentIoTJobConfiguration

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::GreengrassV2::DeploymentIoTJobConfiguration object:

  $service_obj->Method(Att1 => { AbortConfig => $value, ..., TimeoutConfig => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::GreengrassV2::DeploymentIoTJobConfiguration object:

  $result = $service_obj->Method(...);
  $result->Att1->AbortConfig

=head1 DESCRIPTION

Contains information about an AWS IoT job configuration.

=head1 ATTRIBUTES


=head2 AbortConfig => L<Paws::GreengrassV2::IoTJobAbortConfig>

The stop configuration for the job. This configuration defines when and
how to stop a job rollout.


=head2 JobExecutionsRolloutConfig => L<Paws::GreengrassV2::IoTJobExecutionsRolloutConfig>

The rollout configuration for the job. This configuration defines the
rate at which the job rolls out to the fleet of target devices.


=head2 TimeoutConfig => L<Paws::GreengrassV2::IoTJobTimeoutConfig>

The timeout configuration for the job. This configuration defines the
amount of time each device has to complete the job.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::GreengrassV2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

