# Generated by default/object.tt
package Paws::DirectConnect::MacSecKey;
  use Moose;
  has Ckn => (is => 'ro', isa => 'Str', request_name => 'ckn', traits => ['NameInRequest']);
  has SecretARN => (is => 'ro', isa => 'Str', request_name => 'secretARN', traits => ['NameInRequest']);
  has StartOn => (is => 'ro', isa => 'Str', request_name => 'startOn', traits => ['NameInRequest']);
  has State => (is => 'ro', isa => 'Str', request_name => 'state', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::DirectConnect::MacSecKey

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::DirectConnect::MacSecKey object:

  $service_obj->Method(Att1 => { Ckn => $value, ..., State => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::DirectConnect::MacSecKey object:

  $result = $service_obj->Method(...);
  $result->Att1->Ckn

=head1 DESCRIPTION

Information about the MAC Security (MACsec) secret key.

=head1 ATTRIBUTES


=head2 Ckn => Str

The Connection Key Name (CKN) for the MAC Security secret key.


=head2 SecretARN => Str

The Amazon Resource Name (ARN) of the MAC Security (MACsec) secret key.


=head2 StartOn => Str

The date that the MAC Security (MACsec) secret key takes effect. The
value is displayed in UTC format.


=head2 State => Str

The state of the MAC Security (MACsec) secret key.

The possible values are:

=over

=item *

C<associating>: The MAC Security (MACsec) secret key is being validated
and not yet associated with the connection or LAG.

=item *

C<associated>: The MAC Security (MACsec) secret key is validated and
associated with the connection or LAG.

=item *

C<disassociating>: The MAC Security (MACsec) secret key is being
disassociated from the connection or LAG

=item *

C<disassociated>: The MAC Security (MACsec) secret key is no longer
associated with the connection or LAG.

=back




=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::DirectConnect>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

