# Generated by default/object.tt
package Paws::LexModelsV2::BotAliasSummary;
  use Moose;
  has BotAliasId => (is => 'ro', isa => 'Str', request_name => 'botAliasId', traits => ['NameInRequest']);
  has BotAliasName => (is => 'ro', isa => 'Str', request_name => 'botAliasName', traits => ['NameInRequest']);
  has BotAliasStatus => (is => 'ro', isa => 'Str', request_name => 'botAliasStatus', traits => ['NameInRequest']);
  has BotVersion => (is => 'ro', isa => 'Str', request_name => 'botVersion', traits => ['NameInRequest']);
  has CreationDateTime => (is => 'ro', isa => 'Str', request_name => 'creationDateTime', traits => ['NameInRequest']);
  has Description => (is => 'ro', isa => 'Str', request_name => 'description', traits => ['NameInRequest']);
  has LastUpdatedDateTime => (is => 'ro', isa => 'Str', request_name => 'lastUpdatedDateTime', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::LexModelsV2::BotAliasSummary

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::LexModelsV2::BotAliasSummary object:

  $service_obj->Method(Att1 => { BotAliasId => $value, ..., LastUpdatedDateTime => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::LexModelsV2::BotAliasSummary object:

  $result = $service_obj->Method(...);
  $result->Att1->BotAliasId

=head1 DESCRIPTION

Summary information about bot aliases returned from the ListBotAliases
operation.

=head1 ATTRIBUTES


=head2 BotAliasId => Str

The unique identifier assigned to the bot alias. You can use this ID to
get detailed information about the alias using the DescribeBotAlias
operation.


=head2 BotAliasName => Str

The name of the bot alias.


=head2 BotAliasStatus => Str

The current state of the bot alias. If the status is C<Available>, the
alias is ready for use.


=head2 BotVersion => Str

The version of the bot that the bot alias references.


=head2 CreationDateTime => Str

A timestamp of the date and time that the bot alias was created.


=head2 Description => Str

The description of the bot alias.


=head2 LastUpdatedDateTime => Str

A timestamp of the date and time that the bot alias was last updated.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::LexModelsV2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

