package IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::ServerAddressByClientCIDR;
# ABSTRACT: ServerAddressByClientCIDR helps the client to determine the server address that they should use, depending on the clientCIDR that they match.
our $VERSION = '1.002';
use IO::K8s::Resource;

k8s clientCIDR => Str, 'required';


k8s serverAddress => Str, 'required';


1;

__END__

=pod

=encoding UTF-8

=head1 NAME

IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::ServerAddressByClientCIDR - ServerAddressByClientCIDR helps the client to determine the server address that they should use, depending on the clientCIDR that they match.

=head1 VERSION

version 1.002

=head2 clientCIDR

The CIDR with which clients can match their IP to figure out the server address that they should use.

=head2 serverAddress

Address of this server, suitable for a client that matches the above CIDR. This can be a hostname, hostname:port, IP or IP:port.

=head1 SUPPORT

=head2 Issues

Please report bugs and feature requests on GitHub at
L<https://github.com/pplu/io-k8s-p5/issues>.

=head2 IRC

Join C<#kubernetes> on C<irc.perl.org> or message Getty directly.

=head1 CONTRIBUTING

Contributions are welcome! Please fork the repository and submit a pull request.

=head1 AUTHORS

=over 4

=item *

Torsten Raudssus <torsten@raudssus.de>

=item *

Jose Luis Martinez <jlmartin@cpan.org> (original author, inactive)

=back

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2018 by Jose Luis Martinez.

This is free software, licensed under:

  The Apache License, Version 2.0, January 2004

=cut
