
use strict;
use warnings;



use ExtUtils::MakeMaker 6.30;



my %WriteMakefileArgs = (
  "ABSTRACT" => "Dynamically load lexicon from a database table",
  "AUTHOR" => "Pete Smith <pete\@cubabit.net>",
  "BUILD_REQUIRES" => {},
  "CONFIGURE_REQUIRES" => {
    "ExtUtils::MakeMaker" => "6.30"
  },
  "DISTNAME" => "Locale-Maketext-Lexicon-DB",
  "EXE_FILES" => [],
  "LICENSE" => "perl",
  "NAME" => "Locale::Maketext::Lexicon::DB",
  "PREREQ_PM" => {
    "Carp" => 0,
    "Data::Dumper" => 0,
    "Locale::Maketext" => "1.22",
    "Log::Log4perl" => 0,
    "Moose" => 0,
    "namespace::autoclean" => 0
  },
  "TEST_REQUIRES" => {
    "Cache::Memcached::Fast" => 0,
    "DBD::SQLite" => 0,
    "DBI" => 0,
    "File::Temp" => 0,
    "Test::Memcached" => 0,
    "Test::More" => 0,
    "strict" => 0,
    "warnings" => 0
  },
  "VERSION" => "1.141190",
  "test" => {
    "TESTS" => "t/*.t"
  }
);


my %FallbackPrereqs = (
  "Cache::Memcached::Fast" => 0,
  "Carp" => 0,
  "DBD::SQLite" => 0,
  "DBI" => 0,
  "Data::Dumper" => 0,
  "File::Temp" => 0,
  "Locale::Maketext" => "1.22",
  "Log::Log4perl" => 0,
  "Moose" => 0,
  "Test::Memcached" => 0,
  "Test::More" => 0,
  "namespace::autoclean" => 0,
  "strict" => 0,
  "warnings" => 0
);


unless ( eval { ExtUtils::MakeMaker->VERSION(6.63_03) } ) {
  delete $WriteMakefileArgs{TEST_REQUIRES};
  delete $WriteMakefileArgs{BUILD_REQUIRES};
  $WriteMakefileArgs{PREREQ_PM} = \%FallbackPrereqs;
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);



