/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.international.french;

import edu.stanford.nlp.international.morph.MorphoFeatureSpecification;
import edu.stanford.nlp.international.morph.MorphoFeatures;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public class FrenchMorphoFeatureSpecification
extends MorphoFeatureSpecification {
    private static final long serialVersionUID = -58379347760106784L;
    public static final String[] genVals = new String[]{"M", "F"};
    public static final String[] numVals = new String[]{"SG", "PL"};
    public static final String[] perVals = new String[]{"1", "2", "3"};

    @Override
    public List<String> getValues(MorphoFeatureSpecification.MorphoFeatureType feat) {
        if (feat == MorphoFeatureSpecification.MorphoFeatureType.GEN) {
            return Arrays.asList(genVals);
        }
        if (feat == MorphoFeatureSpecification.MorphoFeatureType.NUM) {
            return Arrays.asList(numVals);
        }
        if (feat == MorphoFeatureSpecification.MorphoFeatureType.PER) {
            return Arrays.asList(perVals);
        }
        throw new IllegalArgumentException("French does not support feature type: " + feat.toString());
    }

    @Override
    public MorphoFeatures strToFeatures(String spec) {
        MorphoFeatures feats = new MorphoFeatures();
        if (spec == null || spec.equals("")) {
            return feats;
        }
        boolean isOtherActive = this.isActive(MorphoFeatureSpecification.MorphoFeatureType.OTHER);
        if (spec.startsWith("ADV")) {
            feats.setAltTag("ADV");
            if (spec.contains("int")) {
                if (isOtherActive) {
                    feats.addFeature(MorphoFeatureSpecification.MorphoFeatureType.OTHER, "advint");
                }
                feats.setAltTag("ADVWH");
            }
        } else if (spec.startsWith("A")) {
            feats.setAltTag("ADJ");
            if (spec.contains("int")) {
                if (isOtherActive) {
                    feats.addFeature(MorphoFeatureSpecification.MorphoFeatureType.OTHER, "adjint");
                }
                feats.setAltTag("ADJWH");
            }
            this.addPhiFeatures(feats, spec);
        } else if (spec.equals("CC") || spec.equals("C-C")) {
            if (isOtherActive) {
                feats.addFeature(MorphoFeatureSpecification.MorphoFeatureType.OTHER, "Cc");
            }
            feats.setAltTag("CC");
        } else if (spec.equals("CS") || spec.equals("C-S")) {
            if (isOtherActive) {
                feats.addFeature(MorphoFeatureSpecification.MorphoFeatureType.OTHER, "Cs");
            }
            feats.setAltTag("CS");
        } else if (spec.startsWith("CL")) {
            feats.setAltTag("CL");
            if (spec.contains("suj") || spec.equals("CL-S-3fp")) {
                if (isOtherActive) {
                    feats.addFeature(MorphoFeatureSpecification.MorphoFeatureType.OTHER, "Sbj");
                }
                feats.setAltTag("CLS");
            } else if (spec.contains("obj")) {
                if (isOtherActive) {
                    feats.addFeature(MorphoFeatureSpecification.MorphoFeatureType.OTHER, "Obj");
                }
                feats.setAltTag("CLO");
            } else if (spec.contains("refl")) {
                if (isOtherActive) {
                    feats.addFeature(MorphoFeatureSpecification.MorphoFeatureType.OTHER, "Rfl");
                }
                feats.setAltTag("CLR");
            }
            this.addPhiFeatures(feats, spec);
        } else if (spec.startsWith("D")) {
            feats.setAltTag("DET");
            if (spec.contains("int")) {
                if (isOtherActive) {
                    feats.addFeature(MorphoFeatureSpecification.MorphoFeatureType.OTHER, "dint");
                }
                feats.setAltTag("DETWH");
            }
            this.addPhiFeatures(feats, spec);
        } else if (spec.startsWith("N")) {
            feats.setAltTag("N");
            if (spec.contains("P")) {
                if (isOtherActive) {
                    feats.addFeature(MorphoFeatureSpecification.MorphoFeatureType.OTHER, "Np");
                }
                feats.setAltTag("NPP");
            } else if (spec.contains("C")) {
                if (isOtherActive) {
                    feats.addFeature(MorphoFeatureSpecification.MorphoFeatureType.OTHER, "Nc");
                }
                feats.setAltTag("NC");
            }
            this.addPhiFeatures(feats, spec);
        } else if (spec.startsWith("PRO")) {
            feats.setAltTag("PRO");
            if (spec.contains("int")) {
                if (isOtherActive) {
                    feats.addFeature(MorphoFeatureSpecification.MorphoFeatureType.OTHER, "Ni");
                }
                feats.setAltTag("PROWH");
            } else if (spec.contains("rel")) {
                if (isOtherActive) {
                    feats.addFeature(MorphoFeatureSpecification.MorphoFeatureType.OTHER, "Nr");
                }
                feats.setAltTag("PROREL");
            }
            this.addPhiFeatures(feats, spec);
        } else if (spec.startsWith("V")) {
            feats.setAltTag("V");
            if (spec.contains("Y")) {
                if (isOtherActive) {
                    feats.addFeature(MorphoFeatureSpecification.MorphoFeatureType.OTHER, "Vp");
                }
                feats.setAltTag("VIMP");
            } else if (spec.contains("W")) {
                if (isOtherActive) {
                    feats.addFeature(MorphoFeatureSpecification.MorphoFeatureType.OTHER, "Vf");
                }
                feats.setAltTag("VINF");
            } else if (spec.contains("S") || spec.contains("T")) {
                if (isOtherActive) {
                    feats.addFeature(MorphoFeatureSpecification.MorphoFeatureType.OTHER, "Vs");
                }
                feats.setAltTag("VS");
            } else if (spec.contains("K")) {
                if (isOtherActive) {
                    feats.addFeature(MorphoFeatureSpecification.MorphoFeatureType.OTHER, "Vp");
                }
                feats.setAltTag("VPP");
            } else if (spec.contains("G")) {
                if (isOtherActive) {
                    feats.addFeature(MorphoFeatureSpecification.MorphoFeatureType.OTHER, "Vr");
                }
                feats.setAltTag("VPR");
            }
            this.addPhiFeatures(feats, spec);
        } else if (spec.equals("P") || spec.equals("I")) {
            feats.setAltTag(spec);
        }
        return feats;
    }

    private void addPhiFeatures(MorphoFeatures feats, String spec) {
        String[] toks = spec.split("\\-+");
        String morphStr = toks.length == 3 && toks[0].equals("PRO") && toks[2].equals("neg") ? toks[1] : toks[toks.length - 1];
        morphStr = morphStr.toLowerCase();
        if (this.isActive(MorphoFeatureSpecification.MorphoFeatureType.GEN)) {
            if (morphStr.contains("m")) {
                feats.addFeature(MorphoFeatureSpecification.MorphoFeatureType.GEN, genVals[0]);
            } else if (morphStr.contains("f")) {
                feats.addFeature(MorphoFeatureSpecification.MorphoFeatureType.GEN, genVals[1]);
            }
        }
        if (this.isActive(MorphoFeatureSpecification.MorphoFeatureType.PER)) {
            if (morphStr.contains("1")) {
                feats.addFeature(MorphoFeatureSpecification.MorphoFeatureType.PER, perVals[0]);
            } else if (morphStr.contains("2")) {
                feats.addFeature(MorphoFeatureSpecification.MorphoFeatureType.PER, perVals[1]);
            } else if (morphStr.contains("3")) {
                feats.addFeature(MorphoFeatureSpecification.MorphoFeatureType.PER, perVals[2]);
            }
        }
        if (this.isActive(MorphoFeatureSpecification.MorphoFeatureType.NUM)) {
            if (morphStr.contains("s")) {
                feats.addFeature(MorphoFeatureSpecification.MorphoFeatureType.NUM, numVals[0]);
            } else if (morphStr.contains("p")) {
                feats.addFeature(MorphoFeatureSpecification.MorphoFeatureType.NUM, numVals[1]);
            }
        }
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.err.printf("Usage: java %s file%n", FrenchMorphoFeatureSpecification.class.getName());
            System.exit(-1);
        }
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(args[0]));
            FrenchMorphoFeatureSpecification mfs = new FrenchMorphoFeatureSpecification();
            mfs.activate(MorphoFeatureSpecification.MorphoFeatureType.GEN);
            mfs.activate(MorphoFeatureSpecification.MorphoFeatureType.NUM);
            mfs.activate(MorphoFeatureSpecification.MorphoFeatureType.PER);
            while ((line = br.readLine()) != null) {
                MorphoFeatures feats = ((MorphoFeatureSpecification)mfs).strToFeatures(line);
                System.out.printf("%s\t%s%n", line.trim(), feats.toString());
            }
            br.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

