/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.ling.CyclicCoreLabel;
import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.ling.LabelFactory;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeFactory;
import edu.stanford.nlp.trees.TreeGraphNode;
import java.util.List;

public class TreeGraphNodeFactory
implements TreeFactory {
    private LabelFactory mlf;

    public TreeGraphNodeFactory() {
        this(CyclicCoreLabel.factory());
    }

    public TreeGraphNodeFactory(LabelFactory mlf) {
        this.mlf = mlf;
    }

    @Override
    public Tree newLeaf(String word) {
        return this.newLeaf(this.mlf.newLabel(word));
    }

    @Override
    public Tree newLeaf(Label label) {
        return new TreeGraphNode(label);
    }

    @Override
    public Tree newTreeNode(String parent, List<Tree> children) {
        return this.newTreeNode(this.mlf.newLabel(parent), children);
    }

    @Override
    public Tree newTreeNode(Label parentLabel, List<Tree> children) {
        return new TreeGraphNode(parentLabel, children);
    }
}

