/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ie;

import edu.stanford.nlp.ie.Entity;
import edu.stanford.nlp.ie.EntityCachingAbstractSequencePrior;
import edu.stanford.nlp.ie.pascal.AcronymModel;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.Index;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class SeminarsPrior<IN extends CoreMap>
extends EntityCachingAbstractSequencePrior<IN> {
    double penalty = 2.3;
    private String[] interned;
    private static Map<Pair<String, String>, Boolean> aliasLocCache = new HashMap<Pair<String, String>, Boolean>();
    private static AcronymModel acronymModel;

    public SeminarsPrior(String backgroundSymbol, Index<String> classIndex, List<IN> doc) {
        super(backgroundSymbol, classIndex, doc);
        this.init(doc);
    }

    private void init(List<IN> doc) {
        this.interned = new String[doc.size()];
        int i = 0;
        for (CoreMap wi : doc) {
            this.interned[i++] = ((String)wi.get(CoreAnnotations.TextAnnotation.class)).toLowerCase().intern();
        }
    }

    @Override
    public double scoreOf(int[] sequence) {
        boolean match;
        String time;
        HashSet<String> speakers = new HashSet<String>();
        HashSet<String> locations = new HashSet<String>();
        HashSet<String> stimes = new HashSet<String>();
        HashSet<String> etimes = new HashSet<String>();
        ArrayList<Entity> speakersL = new ArrayList<Entity>();
        ArrayList<Entity> locationsL = new ArrayList<Entity>();
        ArrayList<Entity> stimesL = new ArrayList<Entity>();
        ArrayList<Entity> etimesL = new ArrayList<Entity>();
        double p = 0.0;
        for (int i = 0; i < this.entities.length; ++i) {
            Entity entity = this.entities[i];
            if (i != 0 && this.entities[i - 1] == entity || entity == null) continue;
            String type = (String)this.classIndex.get(entity.type);
            String phrase = StringUtils.join(entity.words, " ").toLowerCase();
            if (type.equalsIgnoreCase("SPEAKER")) {
                speakers.add(phrase);
                speakersL.add(entity);
                continue;
            }
            if (type.equalsIgnoreCase("LOCATION")) {
                locations.add(phrase);
                locationsL.add(entity);
                continue;
            }
            if (type.equals("STIME")) {
                stimes.add(phrase);
                stimesL.add(entity);
                continue;
            }
            if (type.equals("ETIME")) {
                etimes.add(phrase);
                etimesL.add(entity);
                continue;
            }
            System.err.println("unknown entity type: " + type);
            System.exit(0);
        }
        for (Entity stimeE : stimesL) {
            if (stimes.size() == 1) break;
            String stime = StringUtils.join(stimeE.words, " ");
            time = "";
            for (char c : stime.toCharArray()) {
                if (c < '0' || c > '9') continue;
                time = time + c;
            }
            if (time.length() == 1 || time.length() == 2) {
                time = time + "00";
            }
            match = false;
            for (String stime1 : stimes) {
                String time1 = "";
                for (char c : stime1.toCharArray()) {
                    if (c < '0' || c > '9') continue;
                    time1 = time1 + c;
                }
                if (time1.length() == 1 || time1.length() == 2) {
                    time1 = time1 + "00";
                }
                if (time.equals(time1)) continue;
                p -= (double)stimeE.words.size() * this.penalty;
            }
        }
        for (Entity etimeE : etimesL) {
            if (etimes.size() == 1) break;
            String etime = StringUtils.join(etimeE.words, " ");
            time = "";
            for (char c : etime.toCharArray()) {
                if (c < '0' || c > '9') continue;
                time = time + c;
            }
            if (time.length() == 1 || time.length() == 2) {
                time = time + "00";
            }
            match = false;
            for (String etime1 : etimes) {
                String time1 = "";
                for (char c : etime1.toCharArray()) {
                    if (c < '0' || c > '9') continue;
                    time1 = time1 + c;
                }
                if (time1.length() == 1 || time1.length() == 2) {
                    time1 = time1 + "00";
                }
                if (time.equals(time1)) continue;
                p -= (double)etimeE.words.size() * this.penalty;
            }
        }
        int speakerIndex = this.classIndex.indexOf("SPEAKER");
        for (Entity speakerE : speakersL) {
            String lastName = this.interned[speakerE.startPosition + speakerE.words.size() - 1];
            for (int i = 0; i < this.interned.length; ++i) {
                String w = this.interned[i];
                if (w != lastName || sequence[i] == speakerIndex) continue;
                p -= this.penalty;
            }
        }
        return p;
    }

    static {
        try {
            acronymModel = new AcronymModel();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }
}

