package JIRA::REST::Class::Project::Component;
use base qw( JIRA::REST::Class::Abstract );
use strict;
use warnings;
use v5.10;

use JIRA::REST::Class::Version qw( $VERSION );

# ABSTRACT: A helper class for C<JIRA::REST::Class> that represents a component of a JIRA project as an object.

__PACKAGE__->mk_data_ro_accessors(qw( id isAssigneeTypeValid name self ));

1;

__END__

=pod

=encoding UTF-8

=for :stopwords Packy Anderson Alexey Melezhik isAssigneeTypeValid

=head1 NAME

JIRA::REST::Class::Project::Component - A helper class for C<JIRA::REST::Class> that represents a component of a JIRA project as an object.

=head1 VERSION

version 0.04

=head1 READ-ONLY ACCESSORS

=head2 B<id>
The ID of the project category.

=head2 B<isAssigneeTypeValid>
A boolean indicating whether the assignee type is valid.

=head2 B<name>
The name of the project category.

=head2 B<self>
Returns the JIRA REST API URL of the project category.

=head1 AUTHOR

Packy Anderson <packy@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2016 by Packy Anderson.

This is free software, licensed under:

  The Artistic License 2.0 (GPL Compatible)

=cut
