
package Google::Ads::AdWords::v201402::CustomerService::mutate;
use strict;
use warnings;

{ # BLOCK to scope variables

sub get_xmlns { 'https://adwords.google.com/api/adwords/mcm/v201402' }

__PACKAGE__->__set_name('mutate');
__PACKAGE__->__set_nillable();
__PACKAGE__->__set_minOccurs();
__PACKAGE__->__set_maxOccurs();
__PACKAGE__->__set_ref();

use base qw(
    SOAP::WSDL::XSD::Typelib::Element
    Google::Ads::SOAP::Typelib::ComplexType
);

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(Google::Ads::SOAP::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %customer_of :ATTR(:get<customer>);

__PACKAGE__->_factory(
    [ qw(        customer

    ) ],
    {
        'customer' => \%customer_of,
    },
    {
        'customer' => 'Google::Ads::AdWords::v201402::Customer',
    },
    {

        'customer' => 'customer',
    }
);

} # end BLOCK






} # end of BLOCK



1;


=pod

=head1 NAME

Google::Ads::AdWords::v201402::CustomerService::mutate

=head1 DESCRIPTION

Perl data type class for the XML Schema defined element
mutate from the namespace https://adwords.google.com/api/adwords/mcm/v201402.

Update an authorized customer. The only update currently provided is to enable or disable <a href="https://support.google.com/analytics/answer/1033981?hl=en"> auto-tagging </a>; see that link for special cases affecting the use of auto-tagging. @param customer the requested updated value for the customer. @throws ApiException 





=head1 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * customer

 $element->set_customer($data);
 $element->get_customer();





=back


=head1 METHODS

=head2 new

 my $element = Google::Ads::AdWords::v201402::CustomerService::mutate->new($data);

Constructor. The following data structure may be passed to new():

 {
   customer =>  $a_reference_to, # see Google::Ads::AdWords::v201402::Customer
 },

=head1 AUTHOR

Generated by SOAP::WSDL

=cut

