#!/usr/bin/env perl

use strict;
use warnings;

use Test::More tests => 28_503;

BEGIN {use_ok('Finance::AMEX::Transaction')}

use lib '.';
use t::lib::CompareFile;
my $file = 't/data/AMEX/EPPRC test sample file masked.txt';

my $counts = {
  HEADER            => {want => 45,  have => 0},
  TRAILER           => {want => 45,  have => 0},
  SUMMARY           => {want => 60,  have => 0},
  SOC_DETAIL        => {want => 65,  have => 0},
  SOC_PRICING       => {want => 18,  have => 0},
  ROC_DETAIL        => {want => 541, have => 0},
  ROC_PRICING       => {want => 333, have => 0},
  CHARGEBACK_DETAIL => {want => 0,   have => 0},
  ADJUSTMENT_DETAIL => {want => 9,   have => 0},
  OTHER_DETAIL      => {want => 15,  have => 0},
};

my $data = do {local $/ = undef; <DATA>};

t::lib::CompareFile::compare('EPPRC', $file, $data, $counts);

done_testing();

__DATA__
{
  "HEADER": [
    { "DF_HDR_DATE": "09122014", "DF_HDR_FILE_ID": "000000", "DF_HDR_FILE_NAME": "AMEXTEST",            "DF_HDR_RECORD_TYPE": "DFHDR", "DF_HDR_TIME": "0339" },
    { "DF_HDR_DATE": "09122014", "DF_HDR_FILE_ID": "000000", "DF_HDR_FILE_NAME": "AMEXTEST CORPORATIO", "DF_HDR_RECORD_TYPE": "DFHDR", "DF_HDR_TIME": "0339" },
    { "DF_HDR_DATE": "09122014", "DF_HDR_FILE_ID": "000000", "DF_HDR_FILE_NAME": "AMEXTEST CORPORATIO", "DF_HDR_RECORD_TYPE": "DFHDR", "DF_HDR_TIME": "0339" },
    { "DF_HDR_DATE": "09122014", "DF_HDR_FILE_ID": "000000", "DF_HDR_FILE_NAME": "AMEXTEST CORPORATIO", "DF_HDR_RECORD_TYPE": "DFHDR", "DF_HDR_TIME": "0339" },
    { "DF_HDR_DATE": "09122014", "DF_HDR_FILE_ID": "000000", "DF_HDR_FILE_NAME": "AMEXTEST CORPORATIO", "DF_HDR_RECORD_TYPE": "DFHDR", "DF_HDR_TIME": "0339" },
    { "DF_HDR_DATE": "09122014", "DF_HDR_FILE_ID": "000000", "DF_HDR_FILE_NAME": "AMEXTEST CORPORATIO", "DF_HDR_RECORD_TYPE": "DFHDR", "DF_HDR_TIME": "0339" },
    { "DF_HDR_DATE": "09122014", "DF_HDR_FILE_ID": "000000", "DF_HDR_FILE_NAME": "AMEXTEST CORPORATIO", "DF_HDR_RECORD_TYPE": "DFHDR", "DF_HDR_TIME": "0339" },
    { "DF_HDR_DATE": "09122014", "DF_HDR_FILE_ID": "000000", "DF_HDR_FILE_NAME": "AMEXTEST CORPORATIO", "DF_HDR_RECORD_TYPE": "DFHDR", "DF_HDR_TIME": "0339" },
    { "DF_HDR_DATE": "09122014", "DF_HDR_FILE_ID": "000000", "DF_HDR_FILE_NAME": "AMEXTEST CORPORATIO", "DF_HDR_RECORD_TYPE": "DFHDR", "DF_HDR_TIME": "0339" },
    { "DF_HDR_DATE": "09122014", "DF_HDR_FILE_ID": "000000", "DF_HDR_FILE_NAME": "AMEXTEST CORPORATIO", "DF_HDR_RECORD_TYPE": "DFHDR", "DF_HDR_TIME": "0339" },
    { "DF_HDR_DATE": "09122014", "DF_HDR_FILE_ID": "000000", "DF_HDR_FILE_NAME": "AMEXTEST CORPORATIO", "DF_HDR_RECORD_TYPE": "DFHDR", "DF_HDR_TIME": "0339" },
    { "DF_HDR_DATE": "09122014", "DF_HDR_FILE_ID": "000000", "DF_HDR_FILE_NAME": "AMEXTEST CORPORATIO", "DF_HDR_RECORD_TYPE": "DFHDR", "DF_HDR_TIME": "0339" },
    { "DF_HDR_DATE": "09122014", "DF_HDR_FILE_ID": "000000", "DF_HDR_FILE_NAME": "AMEXTEST CORPORATIO", "DF_HDR_RECORD_TYPE": "DFHDR", "DF_HDR_TIME": "0339" },
    { "DF_HDR_DATE": "09122014", "DF_HDR_FILE_ID": "000000", "DF_HDR_FILE_NAME": "AMEXTEST CORPORATIO", "DF_HDR_RECORD_TYPE": "DFHDR", "DF_HDR_TIME": "0339" },
    { "DF_HDR_DATE": "09122014", "DF_HDR_FILE_ID": "000000", "DF_HDR_FILE_NAME": "AMEXTEST CORPORATIO", "DF_HDR_RECORD_TYPE": "DFHDR", "DF_HDR_TIME": "0339" },
    { "DF_HDR_DATE": "09122014", "DF_HDR_FILE_ID": "000000", "DF_HDR_FILE_NAME": "AMEXTEST CORPORATIO", "DF_HDR_RECORD_TYPE": "DFHDR", "DF_HDR_TIME": "0339" },
    { "DF_HDR_DATE": "09122014", "DF_HDR_FILE_ID": "000000", "DF_HDR_FILE_NAME": "AMEXTEST CORPORATIO", "DF_HDR_RECORD_TYPE": "DFHDR", "DF_HDR_TIME": "0339" },
    { "DF_HDR_DATE": "09122014", "DF_HDR_FILE_ID": "000000", "DF_HDR_FILE_NAME": "AMEXTEST CORPORATIO", "DF_HDR_RECORD_TYPE": "DFHDR", "DF_HDR_TIME": "0339" },
    { "DF_HDR_DATE": "09122014", "DF_HDR_FILE_ID": "000000", "DF_HDR_FILE_NAME": "AMEXTEST CORPORATIO", "DF_HDR_RECORD_TYPE": "DFHDR", "DF_HDR_TIME": "0339" },
    { "DF_HDR_DATE": "09122014", "DF_HDR_FILE_ID": "000000", "DF_HDR_FILE_NAME": "AMEXTEST CORPORATIO", "DF_HDR_RECORD_TYPE": "DFHDR", "DF_HDR_TIME": "0339" },
    { "DF_HDR_DATE": "09122014", "DF_HDR_FILE_ID": "000000", "DF_HDR_FILE_NAME": "AMEXTEST CORPORATIO", "DF_HDR_RECORD_TYPE": "DFHDR", "DF_HDR_TIME": "0339" },
    { "DF_HDR_DATE": "09122014", "DF_HDR_FILE_ID": "000000", "DF_HDR_FILE_NAME": "AMEXTEST CORPORATIO", "DF_HDR_RECORD_TYPE": "DFHDR", "DF_HDR_TIME": "0339" },
    { "DF_HDR_DATE": "09122014", "DF_HDR_FILE_ID": "000000", "DF_HDR_FILE_NAME": "AMEXTEST CORPORATIO", "DF_HDR_RECORD_TYPE": "DFHDR", "DF_HDR_TIME": "0339" },
    { "DF_HDR_DATE": "09122014", "DF_HDR_FILE_ID": "000000", "DF_HDR_FILE_NAME": "AMEXTEST CORPORATIO", "DF_HDR_RECORD_TYPE": "DFHDR", "DF_HDR_TIME": "0339" },
    { "DF_HDR_DATE": "09122014", "DF_HDR_FILE_ID": "000000", "DF_HDR_FILE_NAME": "AMEXTEST CORPORATIO", "DF_HDR_RECORD_TYPE": "DFHDR", "DF_HDR_TIME": "0339" },
    { "DF_HDR_DATE": "09122014", "DF_HDR_FILE_ID": "000000", "DF_HDR_FILE_NAME": "AMEXTEST CORPORATIO", "DF_HDR_RECORD_TYPE": "DFHDR", "DF_HDR_TIME": "0339" },
    { "DF_HDR_DATE": "09122014", "DF_HDR_FILE_ID": "000000", "DF_HDR_FILE_NAME": "AMEXTEST CORPORATIO", "DF_HDR_RECORD_TYPE": "DFHDR", "DF_HDR_TIME": "0339" },
    { "DF_HDR_DATE": "09122014", "DF_HDR_FILE_ID": "000000", "DF_HDR_FILE_NAME": "AMEXTEST CORPORATIO", "DF_HDR_RECORD_TYPE": "DFHDR", "DF_HDR_TIME": "0339" },
    { "DF_HDR_DATE": "09122014", "DF_HDR_FILE_ID": "000000", "DF_HDR_FILE_NAME": "AMEXTEST CORPORATIO", "DF_HDR_RECORD_TYPE": "DFHDR", "DF_HDR_TIME": "0339" },
    { "DF_HDR_DATE": "09122014", "DF_HDR_FILE_ID": "000000", "DF_HDR_FILE_NAME": "AMEXTEST CORPORATIO", "DF_HDR_RECORD_TYPE": "DFHDR", "DF_HDR_TIME": "0339" },
    { "DF_HDR_DATE": "09122014", "DF_HDR_FILE_ID": "000000", "DF_HDR_FILE_NAME": "AMEXTEST CORPORATIO", "DF_HDR_RECORD_TYPE": "DFHDR", "DF_HDR_TIME": "0339" },
    { "DF_HDR_DATE": "09122014", "DF_HDR_FILE_ID": "000000", "DF_HDR_FILE_NAME": "AMEXTEST CORPORATIO", "DF_HDR_RECORD_TYPE": "DFHDR", "DF_HDR_TIME": "0339" },
    { "DF_HDR_DATE": "09122014", "DF_HDR_FILE_ID": "000000", "DF_HDR_FILE_NAME": "AMEXTEST CORPORATIO", "DF_HDR_RECORD_TYPE": "DFHDR", "DF_HDR_TIME": "0339" },
    { "DF_HDR_DATE": "09122014", "DF_HDR_FILE_ID": "000000", "DF_HDR_FILE_NAME": "AMEXTEST CORPORATIO", "DF_HDR_RECORD_TYPE": "DFHDR", "DF_HDR_TIME": "0339" },
    { "DF_HDR_DATE": "09122014", "DF_HDR_FILE_ID": "000000", "DF_HDR_FILE_NAME": "AMEXTEST CORPORATIO", "DF_HDR_RECORD_TYPE": "DFHDR", "DF_HDR_TIME": "0339" },
    { "DF_HDR_DATE": "09122014", "DF_HDR_FILE_ID": "000000", "DF_HDR_FILE_NAME": "AMEXTEST CORPORATIO", "DF_HDR_RECORD_TYPE": "DFHDR", "DF_HDR_TIME": "0339" },
    { "DF_HDR_DATE": "09122014", "DF_HDR_FILE_ID": "000000", "DF_HDR_FILE_NAME": "AMEXTEST CORPORATIO", "DF_HDR_RECORD_TYPE": "DFHDR", "DF_HDR_TIME": "0339" },
    { "DF_HDR_DATE": "09122014", "DF_HDR_FILE_ID": "000000", "DF_HDR_FILE_NAME": "AMEXTEST CORPORATIO", "DF_HDR_RECORD_TYPE": "DFHDR", "DF_HDR_TIME": "0339" },
    { "DF_HDR_DATE": "09122014", "DF_HDR_FILE_ID": "000000", "DF_HDR_FILE_NAME": "AMEXTEST CORPORATIO", "DF_HDR_RECORD_TYPE": "DFHDR", "DF_HDR_TIME": "0339" },
    { "DF_HDR_DATE": "09122014", "DF_HDR_FILE_ID": "000000", "DF_HDR_FILE_NAME": "AMEXTEST CORPORATIO", "DF_HDR_RECORD_TYPE": "DFHDR", "DF_HDR_TIME": "0339" },
    { "DF_HDR_DATE": "09122014", "DF_HDR_FILE_ID": "000000", "DF_HDR_FILE_NAME": "AMEXTEST CORPORATIO", "DF_HDR_RECORD_TYPE": "DFHDR", "DF_HDR_TIME": "0339" },
    { "DF_HDR_DATE": "09122014", "DF_HDR_FILE_ID": "000000", "DF_HDR_FILE_NAME": "AMEXTEST PAYMENTS,",  "DF_HDR_RECORD_TYPE": "DFHDR", "DF_HDR_TIME": "0339" },
    { "DF_HDR_DATE": "09122014", "DF_HDR_FILE_ID": "000000", "DF_HDR_FILE_NAME": "AMEXTEST CONVERGYS",  "DF_HDR_RECORD_TYPE": "DFHDR", "DF_HDR_TIME": "0339" },
    { "DF_HDR_DATE": "09122014", "DF_HDR_FILE_ID": "000000", "DF_HDR_FILE_NAME": "AMEXTEST ABC MTKT F", "DF_HDR_RECORD_TYPE": "DFHDR", "DF_HDR_TIME": "0339" },
    { "DF_HDR_DATE": "09122014", "DF_HDR_FILE_ID": "000000", "DF_HDR_FILE_NAME": "AMEXTEST CORP",       "DF_HDR_RECORD_TYPE": "DFHDR", "DF_HDR_TIME": "0339" }
  ],
  "TRAILER": [
    { "DF_TRL_DATE": "09122014", "DF_TRL_FILE_ID": "000000", "DF_TRL_FILE_NAME": "AMEXTEST           0", "DF_TRL_RECIPIENT_KEY": "0000000001049999176           0000000000", "DF_TRL_RECORD_COUNT": "0000033", "DF_TRL_RECORD_TYPE": "DFTRL", "DF_TRL_TIME": "0339" },
    { "DF_TRL_DATE": "09122014", "DF_TRL_FILE_ID": "000000", "DF_TRL_FILE_NAME": "AMEXTEST CORPORATIO0", "DF_TRL_RECIPIENT_KEY": "0000000001049999084           0000000000", "DF_TRL_RECORD_COUNT": "0000023", "DF_TRL_RECORD_TYPE": "DFTRL", "DF_TRL_TIME": "0339" },
    { "DF_TRL_DATE": "09122014", "DF_TRL_FILE_ID": "000000", "DF_TRL_FILE_NAME": "AMEXTEST CORPORATIO0", "DF_TRL_RECIPIENT_KEY": "0000000001049999700           0000000000", "DF_TRL_RECORD_COUNT": "0000029", "DF_TRL_RECORD_TYPE": "DFTRL", "DF_TRL_TIME": "0339" },
    { "DF_TRL_DATE": "09122014", "DF_TRL_FILE_ID": "000000", "DF_TRL_FILE_NAME": "AMEXTEST CORPORATIO0", "DF_TRL_RECIPIENT_KEY": "0000000001049999728           0000000000", "DF_TRL_RECORD_COUNT": "0000141", "DF_TRL_RECORD_TYPE": "DFTRL", "DF_TRL_TIME": "0339" },
    { "DF_TRL_DATE": "09122014", "DF_TRL_FILE_ID": "000000", "DF_TRL_FILE_NAME": "AMEXTEST CORPORATIO0", "DF_TRL_RECIPIENT_KEY": "0000000001049999121           0000000000", "DF_TRL_RECORD_COUNT": "0000047", "DF_TRL_RECORD_TYPE": "DFTRL", "DF_TRL_TIME": "0339" },
    { "DF_TRL_DATE": "09122014", "DF_TRL_FILE_ID": "000000", "DF_TRL_FILE_NAME": "AMEXTEST CORPORATIO0", "DF_TRL_RECIPIENT_KEY": "0000000001049999246           0000000000", "DF_TRL_RECORD_COUNT": "0000019", "DF_TRL_RECORD_TYPE": "DFTRL", "DF_TRL_TIME": "0339" },
    { "DF_TRL_DATE": "09122014", "DF_TRL_FILE_ID": "000000", "DF_TRL_FILE_NAME": "AMEXTEST CORPORATIO0", "DF_TRL_RECIPIENT_KEY": "0000000001059999079           0000000000", "DF_TRL_RECORD_COUNT": "0000019", "DF_TRL_RECORD_TYPE": "DFTRL", "DF_TRL_TIME": "0339" },
    { "DF_TRL_DATE": "09122014", "DF_TRL_FILE_ID": "000000", "DF_TRL_FILE_NAME": "AMEXTEST CORPORATIO0", "DF_TRL_RECIPIENT_KEY": "0000000001099999509           0000000000", "DF_TRL_RECORD_COUNT": "0000026", "DF_TRL_RECORD_TYPE": "DFTRL", "DF_TRL_TIME": "0339" },
    { "DF_TRL_DATE": "09122014", "DF_TRL_FILE_ID": "000000", "DF_TRL_FILE_NAME": "AMEXTEST CORPORATIO0", "DF_TRL_RECIPIENT_KEY": "0000000001159999126           0000000000", "DF_TRL_RECORD_COUNT": "0000013", "DF_TRL_RECORD_TYPE": "DFTRL", "DF_TRL_TIME": "0339" },
    { "DF_TRL_DATE": "09122014", "DF_TRL_FILE_ID": "000000", "DF_TRL_FILE_NAME": "AMEXTEST CORPORATIO0", "DF_TRL_RECIPIENT_KEY": "0000000001269999580           0000000000", "DF_TRL_RECORD_COUNT": "0000008", "DF_TRL_RECORD_TYPE": "DFTRL", "DF_TRL_TIME": "0339" },
    { "DF_TRL_DATE": "09122014", "DF_TRL_FILE_ID": "000000", "DF_TRL_FILE_NAME": "AMEXTEST CORPORATIO0", "DF_TRL_RECIPIENT_KEY": "0000000001319999989           0000000000", "DF_TRL_RECORD_COUNT": "0000030", "DF_TRL_RECORD_TYPE": "DFTRL", "DF_TRL_TIME": "0339" },
    { "DF_TRL_DATE": "09122014", "DF_TRL_FILE_ID": "000000", "DF_TRL_FILE_NAME": "AMEXTEST CORPORATIO0", "DF_TRL_RECIPIENT_KEY": "0000000001319999284           0000000000", "DF_TRL_RECORD_COUNT": "0000012", "DF_TRL_RECORD_TYPE": "DFTRL", "DF_TRL_TIME": "0339" },
    { "DF_TRL_DATE": "09122014", "DF_TRL_FILE_ID": "000000", "DF_TRL_FILE_NAME": "AMEXTEST CORPORATIO0", "DF_TRL_RECIPIENT_KEY": "0000000002049999582           0000000000", "DF_TRL_RECORD_COUNT": "0000008", "DF_TRL_RECORD_TYPE": "DFTRL", "DF_TRL_TIME": "0339" },
    { "DF_TRL_DATE": "09122014", "DF_TRL_FILE_ID": "000000", "DF_TRL_FILE_NAME": "AMEXTEST CORPORATIO0", "DF_TRL_RECIPIENT_KEY": "0000000002049999873           0000000000", "DF_TRL_RECORD_COUNT": "0000012", "DF_TRL_RECORD_TYPE": "DFTRL", "DF_TRL_TIME": "0339" },
    { "DF_TRL_DATE": "09122014", "DF_TRL_FILE_ID": "000000", "DF_TRL_FILE_NAME": "AMEXTEST CORPORATIO0", "DF_TRL_RECIPIENT_KEY": "0000000002069999156           0000000000", "DF_TRL_RECORD_COUNT": "0000017", "DF_TRL_RECORD_TYPE": "DFTRL", "DF_TRL_TIME": "0339" },
    { "DF_TRL_DATE": "09122014", "DF_TRL_FILE_ID": "000000", "DF_TRL_FILE_NAME": "AMEXTEST CORPORATIO0", "DF_TRL_RECIPIENT_KEY": "0000000002199999562           0000000000", "DF_TRL_RECORD_COUNT": "0000016", "DF_TRL_RECORD_TYPE": "DFTRL", "DF_TRL_TIME": "0339" },
    { "DF_TRL_DATE": "09122014", "DF_TRL_FILE_ID": "000000", "DF_TRL_FILE_NAME": "AMEXTEST CORPORATIO0", "DF_TRL_RECIPIENT_KEY": "0000000002199999169           0000000000", "DF_TRL_RECORD_COUNT": "0000008", "DF_TRL_RECORD_TYPE": "DFTRL", "DF_TRL_TIME": "0339" },
    { "DF_TRL_DATE": "09122014", "DF_TRL_FILE_ID": "000000", "DF_TRL_FILE_NAME": "AMEXTEST CORPORATIO0", "DF_TRL_RECIPIENT_KEY": "0000000002299999656           0000000000", "DF_TRL_RECORD_COUNT": "0000017", "DF_TRL_RECORD_TYPE": "DFTRL", "DF_TRL_TIME": "0339" },
    { "DF_TRL_DATE": "09122014", "DF_TRL_FILE_ID": "000000", "DF_TRL_FILE_NAME": "AMEXTEST CORPORATIO0", "DF_TRL_RECIPIENT_KEY": "0000000002299999510           0000000000", "DF_TRL_RECORD_COUNT": "0000025", "DF_TRL_RECORD_TYPE": "DFTRL", "DF_TRL_TIME": "0339" },
    { "DF_TRL_DATE": "09122014", "DF_TRL_FILE_ID": "000000", "DF_TRL_FILE_NAME": "AMEXTEST CORPORATIO0", "DF_TRL_RECIPIENT_KEY": "0000000002299999979           0000000000", "DF_TRL_RECORD_COUNT": "0000030", "DF_TRL_RECORD_TYPE": "DFTRL", "DF_TRL_TIME": "0339" },
    { "DF_TRL_DATE": "09122014", "DF_TRL_FILE_ID": "000000", "DF_TRL_FILE_NAME": "AMEXTEST CORPORATIO0", "DF_TRL_RECIPIENT_KEY": "0000000002379999582           0000000000", "DF_TRL_RECORD_COUNT": "0000008", "DF_TRL_RECORD_TYPE": "DFTRL", "DF_TRL_TIME": "0339" },
    { "DF_TRL_DATE": "09122014", "DF_TRL_FILE_ID": "000000", "DF_TRL_FILE_NAME": "AMEXTEST CORPORATIO0", "DF_TRL_RECIPIENT_KEY": "0000000002429999649           0000000000", "DF_TRL_RECORD_COUNT": "0000005", "DF_TRL_RECORD_TYPE": "DFTRL", "DF_TRL_TIME": "0339" },
    { "DF_TRL_DATE": "09122014", "DF_TRL_FILE_ID": "000000", "DF_TRL_FILE_NAME": "AMEXTEST CORPORATIO0", "DF_TRL_RECIPIENT_KEY": "0000000002429999763           0000000000", "DF_TRL_RECORD_COUNT": "0000005", "DF_TRL_RECORD_TYPE": "DFTRL", "DF_TRL_TIME": "0339" },
    { "DF_TRL_DATE": "09122014", "DF_TRL_FILE_ID": "000000", "DF_TRL_FILE_NAME": "AMEXTEST CORPORATIO0", "DF_TRL_RECIPIENT_KEY": "0000000002429999789           0000000000", "DF_TRL_RECORD_COUNT": "0000005", "DF_TRL_RECORD_TYPE": "DFTRL", "DF_TRL_TIME": "0339" },
    { "DF_TRL_DATE": "09122014", "DF_TRL_FILE_ID": "000000", "DF_TRL_FILE_NAME": "AMEXTEST CORPORATIO0", "DF_TRL_RECIPIENT_KEY": "0000000002429999938           0000000000", "DF_TRL_RECORD_COUNT": "0000005", "DF_TRL_RECORD_TYPE": "DFTRL", "DF_TRL_TIME": "0339" },
    { "DF_TRL_DATE": "09122014", "DF_TRL_FILE_ID": "000000", "DF_TRL_FILE_NAME": "AMEXTEST CORPORATIO0", "DF_TRL_RECIPIENT_KEY": "0000000002429999961           0000000000", "DF_TRL_RECORD_COUNT": "0000204", "DF_TRL_RECORD_TYPE": "DFTRL", "DF_TRL_TIME": "0339" },
    { "DF_TRL_DATE": "09122014", "DF_TRL_FILE_ID": "000000", "DF_TRL_FILE_NAME": "AMEXTEST CORPORATIO0", "DF_TRL_RECIPIENT_KEY": "0000000002429999928           0000000000", "DF_TRL_RECORD_COUNT": "0000025", "DF_TRL_RECORD_TYPE": "DFTRL", "DF_TRL_TIME": "0339" },
    { "DF_TRL_DATE": "09122014", "DF_TRL_FILE_ID": "000000", "DF_TRL_FILE_NAME": "AMEXTEST CORPORATIO0", "DF_TRL_RECIPIENT_KEY": "0000000002429999564           0000000000", "DF_TRL_RECORD_COUNT": "0000015", "DF_TRL_RECORD_TYPE": "DFTRL", "DF_TRL_TIME": "0339" },
    { "DF_TRL_DATE": "09122014", "DF_TRL_FILE_ID": "000000", "DF_TRL_FILE_NAME": "AMEXTEST CORPORATIO0", "DF_TRL_RECIPIENT_KEY": "0000000002429999740           0000000000", "DF_TRL_RECORD_COUNT": "0000020", "DF_TRL_RECORD_TYPE": "DFTRL", "DF_TRL_TIME": "0339" },
    { "DF_TRL_DATE": "09122014", "DF_TRL_FILE_ID": "000000", "DF_TRL_FILE_NAME": "AMEXTEST CORPORATIO0", "DF_TRL_RECIPIENT_KEY": "0000000002429999034           0000000000", "DF_TRL_RECORD_COUNT": "0000008", "DF_TRL_RECORD_TYPE": "DFTRL", "DF_TRL_TIME": "0339" },
    { "DF_TRL_DATE": "09122014", "DF_TRL_FILE_ID": "000000", "DF_TRL_FILE_NAME": "AMEXTEST CORPORATIO0", "DF_TRL_RECIPIENT_KEY": "0000000003129999193           0000000000", "DF_TRL_RECORD_COUNT": "0000021", "DF_TRL_RECORD_TYPE": "DFTRL", "DF_TRL_TIME": "0339" },
    { "DF_TRL_DATE": "09122014", "DF_TRL_FILE_ID": "000000", "DF_TRL_FILE_NAME": "AMEXTEST CORPORATIO0", "DF_TRL_RECIPIENT_KEY": "0000000003229999977           0000000000", "DF_TRL_RECORD_COUNT": "0000025", "DF_TRL_RECORD_TYPE": "DFTRL", "DF_TRL_TIME": "0339" },
    { "DF_TRL_DATE": "09122014", "DF_TRL_FILE_ID": "000000", "DF_TRL_FILE_NAME": "AMEXTEST CORPORATIO0", "DF_TRL_RECIPIENT_KEY": "0000000004109999881           0000000000", "DF_TRL_RECORD_COUNT": "0000031", "DF_TRL_RECORD_TYPE": "DFTRL", "DF_TRL_TIME": "0339" },
    { "DF_TRL_DATE": "09122014", "DF_TRL_FILE_ID": "000000", "DF_TRL_FILE_NAME": "AMEXTEST CORPORATIO0", "DF_TRL_RECIPIENT_KEY": "0000000004109999177           0000000000", "DF_TRL_RECORD_COUNT": "0000008", "DF_TRL_RECORD_TYPE": "DFTRL", "DF_TRL_TIME": "0339" },
    { "DF_TRL_DATE": "09122014", "DF_TRL_FILE_ID": "000000", "DF_TRL_FILE_NAME": "AMEXTEST CORPORATIO0", "DF_TRL_RECIPIENT_KEY": "0000000004169999182           0000000000", "DF_TRL_RECORD_COUNT": "0000020", "DF_TRL_RECORD_TYPE": "DFTRL", "DF_TRL_TIME": "0339" },
    { "DF_TRL_DATE": "09122014", "DF_TRL_FILE_ID": "000000", "DF_TRL_FILE_NAME": "AMEXTEST CORPORATIO0", "DF_TRL_RECIPIENT_KEY": "0000000004329999734           0000000000", "DF_TRL_RECORD_COUNT": "0000018", "DF_TRL_RECORD_TYPE": "DFTRL", "DF_TRL_TIME": "0339" },
    { "DF_TRL_DATE": "09122014", "DF_TRL_FILE_ID": "000000", "DF_TRL_FILE_NAME": "AMEXTEST CORPORATIO0", "DF_TRL_RECIPIENT_KEY": "0000000004419999772           0000000000", "DF_TRL_RECORD_COUNT": "0000010", "DF_TRL_RECORD_TYPE": "DFTRL", "DF_TRL_TIME": "0339" },
    { "DF_TRL_DATE": "09122014", "DF_TRL_FILE_ID": "000000", "DF_TRL_FILE_NAME": "AMEXTEST CORPORATIO0", "DF_TRL_RECIPIENT_KEY": "0000000004459999588           0000000000", "DF_TRL_RECORD_COUNT": "0000027", "DF_TRL_RECORD_TYPE": "DFTRL", "DF_TRL_TIME": "0339" },
    { "DF_TRL_DATE": "09122014", "DF_TRL_FILE_ID": "000000", "DF_TRL_FILE_NAME": "AMEXTEST CORPORATIO0", "DF_TRL_RECIPIENT_KEY": "0000000005029999057           0000000000", "DF_TRL_RECORD_COUNT": "0000017", "DF_TRL_RECORD_TYPE": "DFTRL", "DF_TRL_TIME": "0339" },
    { "DF_TRL_DATE": "09122014", "DF_TRL_FILE_ID": "000000", "DF_TRL_FILE_NAME": "AMEXTEST CORPORATIO0", "DF_TRL_RECIPIENT_KEY": "0000000005029999289           0000000000", "DF_TRL_RECORD_COUNT": "0000012", "DF_TRL_RECORD_TYPE": "DFTRL", "DF_TRL_TIME": "0339" },
    { "DF_TRL_DATE": "09122014", "DF_TRL_FILE_ID": "000000", "DF_TRL_FILE_NAME": "AMEXTEST CORPORATIO0", "DF_TRL_RECIPIENT_KEY": "0000000005279999046           0000000000", "DF_TRL_RECORD_COUNT": "0000006", "DF_TRL_RECORD_TYPE": "DFTRL", "DF_TRL_TIME": "0339" },
    { "DF_TRL_DATE": "09122014", "DF_TRL_FILE_ID": "000000", "DF_TRL_FILE_NAME": "AMEXTEST PAYMENTS, 0", "DF_TRL_RECIPIENT_KEY": "0000000005279999579           0000000000", "DF_TRL_RECORD_COUNT": "0000037", "DF_TRL_RECORD_TYPE": "DFTRL", "DF_TRL_TIME": "0339" },
    { "DF_TRL_DATE": "09122014", "DF_TRL_FILE_ID": "000000", "DF_TRL_FILE_NAME": "AMEXTEST CONVERGYS 0", "DF_TRL_RECIPIENT_KEY": "0000000005439999059           0000000000", "DF_TRL_RECORD_COUNT": "0000012", "DF_TRL_RECORD_TYPE": "DFTRL", "DF_TRL_TIME": "0339" },
    { "DF_TRL_DATE": "09122014", "DF_TRL_FILE_ID": "000000", "DF_TRL_FILE_NAME": "AMEXTEST ABC MTKT F0", "DF_TRL_RECIPIENT_KEY": "0000000005469999720           0000000000", "DF_TRL_RECORD_COUNT": "0000010", "DF_TRL_RECORD_TYPE": "DFTRL", "DF_TRL_TIME": "0339" },
    { "DF_TRL_DATE": "09122014", "DF_TRL_FILE_ID": "000000", "DF_TRL_FILE_NAME": "AMEXTEST CORP      0", "DF_TRL_RECIPIENT_KEY": "0000000005469999267           0000000000", "DF_TRL_RECORD_COUNT": "0000044", "DF_TRL_RECORD_TYPE": "DFTRL", "DF_TRL_TIME": "0339" }
  ],
  "SUMMARY": [
    { "ABA_BANK_NUMBER": "111000012", "AMEX_PAYEE_NUMBER": "1049999176", "AMEX_SORT_FIELD_1": "0009999000", "AMEX_SORT_FIELD_2": "0000000000", "DEBIT_BALANCE_AMOUNT": "00000000{", "DETAIL_RECORD_TYPE": "00", "PAYMENT_AMOUNT": "0000052779D", "PAYMENT_DATE": "2014256", "PAYMENT_NUMBER": "254F8666", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "8666", "PAYMENT_NUMBER_TYPE": "F", "PAYMENT_YEAR": "2014", "RECORD_TYPE": 1, "SE_DDA_NUMBER": "0000000737" },
    { "ABA_BANK_NUMBER": "111000012", "AMEX_PAYEE_NUMBER": "1049999084", "AMEX_SORT_FIELD_1": "0009999000", "AMEX_SORT_FIELD_2": "0000000000", "DEBIT_BALANCE_AMOUNT": "00000000{", "DETAIL_RECORD_TYPE": "00", "PAYMENT_AMOUNT": "0000037319D", "PAYMENT_DATE": "2014256", "PAYMENT_NUMBER": "254H1728", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "1728", "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": "2014", "RECORD_TYPE": 1, "SE_DDA_NUMBER": "0000007254" },
    { "ABA_BANK_NUMBER": "111000012", "AMEX_PAYEE_NUMBER": "1049999700", "AMEX_SORT_FIELD_1": "0009999000", "AMEX_SORT_FIELD_2": "0000000000", "DEBIT_BALANCE_AMOUNT": "00000000{", "DETAIL_RECORD_TYPE": "00", "PAYMENT_AMOUNT": "0000044730F", "PAYMENT_DATE": "2014256", "PAYMENT_NUMBER": "254H3242", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "3242", "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": "2014", "RECORD_TYPE": 1, "SE_DDA_NUMBER": "0000000552" },
    { "ABA_BANK_NUMBER": "111000012", "AMEX_PAYEE_NUMBER": "1049999728", "AMEX_SORT_FIELD_1": "0009999000", "AMEX_SORT_FIELD_2": "0000000000", "DEBIT_BALANCE_AMOUNT": "00000000{", "DETAIL_RECORD_TYPE": "00", "PAYMENT_AMOUNT": "0000142227F", "PAYMENT_DATE": "2014256", "PAYMENT_NUMBER": "254H3651", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "3651", "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": "2014", "RECORD_TYPE": 1, "SE_DDA_NUMBER": "0000002993" },
    { "ABA_BANK_NUMBER": "111000012", "AMEX_PAYEE_NUMBER": "1049999121", "AMEX_SORT_FIELD_1": "0009999000", "AMEX_SORT_FIELD_2": "0000000000", "DEBIT_BALANCE_AMOUNT": "00000000{", "DETAIL_RECORD_TYPE": "00", "PAYMENT_AMOUNT": "0000063927{", "PAYMENT_DATE": "2014256", "PAYMENT_NUMBER": "254H4390", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "4390", "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": "2014", "RECORD_TYPE": 1, "SE_DDA_NUMBER": "0000005390" },
    { "ABA_BANK_NUMBER": "111000012", "AMEX_PAYEE_NUMBER": "1049999246", "AMEX_SORT_FIELD_1": "0009999000", "AMEX_SORT_FIELD_2": "0000000000", "DEBIT_BALANCE_AMOUNT": "00000000{", "DETAIL_RECORD_TYPE": "00", "PAYMENT_AMOUNT": "0000032909{", "PAYMENT_DATE": "2014256", "PAYMENT_NUMBER": "254H5067", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "5067", "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": "2014", "RECORD_TYPE": 1, "SE_DDA_NUMBER": "0000003660" },
    { "ABA_BANK_NUMBER": "111000012", "AMEX_PAYEE_NUMBER": "1059999079", "AMEX_SORT_FIELD_1": "0009999000", "AMEX_SORT_FIELD_2": "0000000000", "DEBIT_BALANCE_AMOUNT": "00000000{", "DETAIL_RECORD_TYPE": "00", "PAYMENT_AMOUNT": "0000029178D", "PAYMENT_DATE": "2014256", "PAYMENT_NUMBER": "254H9133", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "9133", "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": "2014", "RECORD_TYPE": 1, "SE_DDA_NUMBER": "0000007267" },
    { "ABA_BANK_NUMBER": "111000012", "AMEX_PAYEE_NUMBER": "1099999509", "AMEX_SORT_FIELD_1": "0009999000", "AMEX_SORT_FIELD_2": "0000000000", "DEBIT_BALANCE_AMOUNT": "00000000{", "DETAIL_RECORD_TYPE": "00", "PAYMENT_AMOUNT": "0000048183{", "PAYMENT_DATE": "2014256", "PAYMENT_NUMBER": "254E6857", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "6857", "PAYMENT_NUMBER_TYPE": "E", "PAYMENT_YEAR": "2014", "RECORD_TYPE": 1, "SE_DDA_NUMBER": "0000002366" },
    { "ABA_BANK_NUMBER": "111000012", "AMEX_PAYEE_NUMBER": "1099999509", "AMEX_SORT_FIELD_1": "0009999000", "AMEX_SORT_FIELD_2": "0000000000", "DEBIT_BALANCE_AMOUNT": "00000000{", "DETAIL_RECORD_TYPE": "00", "PAYMENT_AMOUNT": "0000001325}", "PAYMENT_DATE": "2014256", "PAYMENT_NUMBER": "254E6858", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "6858", "PAYMENT_NUMBER_TYPE": "E", "PAYMENT_YEAR": "2014", "RECORD_TYPE": 1, "SE_DDA_NUMBER": "0000002366" },
    { "ABA_BANK_NUMBER": "111000012", "AMEX_PAYEE_NUMBER": "1159999126", "AMEX_SORT_FIELD_1": "0009999000", "AMEX_SORT_FIELD_2": "0000000000", "DEBIT_BALANCE_AMOUNT": "00000000{", "DETAIL_RECORD_TYPE": "00", "PAYMENT_AMOUNT": "0000017998E", "PAYMENT_DATE": "2014256", "PAYMENT_NUMBER": "254J2806", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "2806", "PAYMENT_NUMBER_TYPE": "J", "PAYMENT_YEAR": "2014", "RECORD_TYPE": 1, "SE_DDA_NUMBER": "0000008803" },
    { "ABA_BANK_NUMBER": "111000012", "AMEX_PAYEE_NUMBER": "1269999580", "AMEX_SORT_FIELD_1": "0009999000", "AMEX_SORT_FIELD_2": "0000000000", "DEBIT_BALANCE_AMOUNT": "00000000{", "DETAIL_RECORD_TYPE": "00", "PAYMENT_AMOUNT": "0000000855I", "PAYMENT_DATE": "2014256", "PAYMENT_NUMBER": "254J4690", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "4690", "PAYMENT_NUMBER_TYPE": "J", "PAYMENT_YEAR": "2014", "RECORD_TYPE": 1, "SE_DDA_NUMBER": "0000003226" },
    { "ABA_BANK_NUMBER": "111000012", "AMEX_PAYEE_NUMBER": "1269999580", "AMEX_SORT_FIELD_1": "0009999000", "AMEX_SORT_FIELD_2": "0000000000", "DEBIT_BALANCE_AMOUNT": "00000000{", "DETAIL_RECORD_TYPE": "00", "PAYMENT_AMOUNT": "0000000023N", "PAYMENT_DATE": "2014256", "PAYMENT_NUMBER": "254J4691", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "4691", "PAYMENT_NUMBER_TYPE": "J", "PAYMENT_YEAR": "2014", "RECORD_TYPE": 1, "SE_DDA_NUMBER": "0000003226" },
    { "ABA_BANK_NUMBER": "111000012", "AMEX_PAYEE_NUMBER": "1319999989", "AMEX_SORT_FIELD_1": "0009999000", "AMEX_SORT_FIELD_2": "0000000000", "DEBIT_BALANCE_AMOUNT": "00000000{", "DETAIL_RECORD_TYPE": "00", "PAYMENT_AMOUNT": "0000053894I", "PAYMENT_DATE": "2014256", "PAYMENT_NUMBER": "254G2302", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "2302", "PAYMENT_NUMBER_TYPE": "G", "PAYMENT_YEAR": "2014", "RECORD_TYPE": 1, "SE_DDA_NUMBER": "0000000106" },
    { "ABA_BANK_NUMBER": "111000012", "AMEX_PAYEE_NUMBER": "1319999989", "AMEX_SORT_FIELD_1": "0009999000", "AMEX_SORT_FIELD_2": "0000000000", "DEBIT_BALANCE_AMOUNT": "00000000{", "DETAIL_RECORD_TYPE": "00", "PAYMENT_AMOUNT": "0000001482J", "PAYMENT_DATE": "2014256", "PAYMENT_NUMBER": "254G2303", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "2303", "PAYMENT_NUMBER_TYPE": "G", "PAYMENT_YEAR": "2014", "RECORD_TYPE": 1, "SE_DDA_NUMBER": "0000000106" },
    { "ABA_BANK_NUMBER": "111000012", "AMEX_PAYEE_NUMBER": "1319999284", "AMEX_SORT_FIELD_1": "0009999000", "AMEX_SORT_FIELD_2": "0000000000", "DEBIT_BALANCE_AMOUNT": "00000000{", "DETAIL_RECORD_TYPE": "00", "PAYMENT_AMOUNT": "0000015153G", "PAYMENT_DATE": "2014256", "PAYMENT_NUMBER": "254G2626", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "2626", "PAYMENT_NUMBER_TYPE": "G", "PAYMENT_YEAR": "2014", "RECORD_TYPE": 1, "SE_DDA_NUMBER": "0000006061" },
    { "ABA_BANK_NUMBER": "111000012", "AMEX_PAYEE_NUMBER": "1319999284", "AMEX_SORT_FIELD_1": "0009999000", "AMEX_SORT_FIELD_2": "0000000000", "DEBIT_BALANCE_AMOUNT": "00000000{", "DETAIL_RECORD_TYPE": "00", "PAYMENT_AMOUNT": "0000000416P", "PAYMENT_DATE": "2014256", "PAYMENT_NUMBER": "254G2627", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "2627", "PAYMENT_NUMBER_TYPE": "G", "PAYMENT_YEAR": "2014", "RECORD_TYPE": 1, "SE_DDA_NUMBER": "0000006061" },
    { "ABA_BANK_NUMBER": "111000012", "AMEX_PAYEE_NUMBER": "2049999582", "AMEX_SORT_FIELD_1": "0009999000", "AMEX_SORT_FIELD_2": "0000000000", "DEBIT_BALANCE_AMOUNT": "00000000{", "DETAIL_RECORD_TYPE": "00", "PAYMENT_AMOUNT": "0000018244{", "PAYMENT_DATE": "2014256", "PAYMENT_NUMBER": "254M2653", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "2653", "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": "2014", "RECORD_TYPE": 1, "SE_DDA_NUMBER": "0000003132" },
    { "ABA_BANK_NUMBER": "111000012", "AMEX_PAYEE_NUMBER": "2049999582", "AMEX_SORT_FIELD_1": "0009999000", "AMEX_SORT_FIELD_2": "0000000000", "DEBIT_BALANCE_AMOUNT": "00000000{", "DETAIL_RECORD_TYPE": "00", "PAYMENT_AMOUNT": "0000000501P", "PAYMENT_DATE": "2014256", "PAYMENT_NUMBER": "254M2654", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "2654", "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": "2014", "RECORD_TYPE": 1, "SE_DDA_NUMBER": "0000003132" },
    { "ABA_BANK_NUMBER": "111000012", "AMEX_PAYEE_NUMBER": "2049999873", "AMEX_SORT_FIELD_1": "0009999000", "AMEX_SORT_FIELD_2": "0000000000", "DEBIT_BALANCE_AMOUNT": "00000000{", "DETAIL_RECORD_TYPE": "00", "PAYMENT_AMOUNT": "0000000000{", "PAYMENT_DATE": "2014256", "PAYMENT_NUMBER": "254M3251", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "3251", "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": "2014", "RECORD_TYPE": 1, "SE_DDA_NUMBER": "0000002686" },
    { "ABA_BANK_NUMBER": "111000012", "AMEX_PAYEE_NUMBER": "2069999156", "AMEX_SORT_FIELD_1": "0009999000", "AMEX_SORT_FIELD_2": "0000000000", "DEBIT_BALANCE_AMOUNT": "00000000{", "DETAIL_RECORD_TYPE": "00", "PAYMENT_AMOUNT": "0000010000H", "PAYMENT_DATE": "2014256", "PAYMENT_NUMBER": "254G5069", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "5069", "PAYMENT_NUMBER_TYPE": "G", "PAYMENT_YEAR": "2014", "RECORD_TYPE": 1, "SE_DDA_NUMBER": "0000008793" },
    { "ABA_BANK_NUMBER": "111000012", "AMEX_PAYEE_NUMBER": "2199999562", "AMEX_SORT_FIELD_1": "0009999000", "AMEX_SORT_FIELD_2": "0000000000", "DEBIT_BALANCE_AMOUNT": "00000000{", "DETAIL_RECORD_TYPE": "00", "PAYMENT_AMOUNT": "0000015301H", "PAYMENT_DATE": "2014256", "PAYMENT_NUMBER": "254I0352", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "0352", "PAYMENT_NUMBER_TYPE": "I", "PAYMENT_YEAR": "2014", "RECORD_TYPE": 1, "SE_DDA_NUMBER": "0000003103" },
    { "ABA_BANK_NUMBER": "111000012", "AMEX_PAYEE_NUMBER": "2199999562", "AMEX_SORT_FIELD_1": "0009999000", "AMEX_SORT_FIELD_2": "0000000000", "DEBIT_BALANCE_AMOUNT": "00000000{", "DETAIL_RECORD_TYPE": "00", "PAYMENT_AMOUNT": "0000000420Q", "PAYMENT_DATE": "2014256", "PAYMENT_NUMBER": "254I0353", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "0353", "PAYMENT_NUMBER_TYPE": "I", "PAYMENT_YEAR": "2014", "RECORD_TYPE": 1, "SE_DDA_NUMBER": "0000003103" },
    { "ABA_BANK_NUMBER": "111000012", "AMEX_PAYEE_NUMBER": "2199999169", "AMEX_SORT_FIELD_1": "0009999000", "AMEX_SORT_FIELD_2": "0000000000", "DEBIT_BALANCE_AMOUNT": "00000000{", "DETAIL_RECORD_TYPE": "00", "PAYMENT_AMOUNT": "0000000847I", "PAYMENT_DATE": "2014256", "PAYMENT_NUMBER": "254I0383", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "0383", "PAYMENT_NUMBER_TYPE": "I", "PAYMENT_YEAR": "2014", "RECORD_TYPE": 1, "SE_DDA_NUMBER": "0000006168" },
    { "ABA_BANK_NUMBER": "111000012", "AMEX_PAYEE_NUMBER": "2199999169", "AMEX_SORT_FIELD_1": "0009999000", "AMEX_SORT_FIELD_2": "0000000000", "DEBIT_BALANCE_AMOUNT": "00000000{", "DETAIL_RECORD_TYPE": "00", "PAYMENT_AMOUNT": "0000000023L", "PAYMENT_DATE": "2014256", "PAYMENT_NUMBER": "254I0384", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "0384", "PAYMENT_NUMBER_TYPE": "I", "PAYMENT_YEAR": "2014", "RECORD_TYPE": 1, "SE_DDA_NUMBER": "0000006168" },
    { "ABA_BANK_NUMBER": "111000012", "AMEX_PAYEE_NUMBER": "2299999656", "AMEX_SORT_FIELD_1": "0009999000", "AMEX_SORT_FIELD_2": "0000000000", "DEBIT_BALANCE_AMOUNT": "00000000{", "DETAIL_RECORD_TYPE": "00", "PAYMENT_AMOUNT": "0000019338A", "PAYMENT_DATE": "2014256", "PAYMENT_NUMBER": "254L1705", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "1705", "PAYMENT_NUMBER_TYPE": "L", "PAYMENT_YEAR": "2014", "RECORD_TYPE": 1, "SE_DDA_NUMBER": "0000008829" },
    { "ABA_BANK_NUMBER": "111000012", "AMEX_PAYEE_NUMBER": "2299999510", "AMEX_SORT_FIELD_1": "0009999000", "AMEX_SORT_FIELD_2": "0000000000", "DEBIT_BALANCE_AMOUNT": "00000000{", "DETAIL_RECORD_TYPE": "00", "PAYMENT_AMOUNT": "0000088407D", "PAYMENT_DATE": "2014256", "PAYMENT_NUMBER": "254L1727", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "1727", "PAYMENT_NUMBER_TYPE": "L", "PAYMENT_YEAR": "2014", "RECORD_TYPE": 1, "SE_DDA_NUMBER": "0000008816" },
    { "ABA_BANK_NUMBER": "111000012", "AMEX_PAYEE_NUMBER": "2299999979", "AMEX_SORT_FIELD_1": "0009999000", "AMEX_SORT_FIELD_2": "0000000000", "DEBIT_BALANCE_AMOUNT": "00000000{", "DETAIL_RECORD_TYPE": "00", "PAYMENT_AMOUNT": "0000019230C", "PAYMENT_DATE": "2014256", "PAYMENT_NUMBER": "254L2581", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "2581", "PAYMENT_NUMBER_TYPE": "L", "PAYMENT_YEAR": "2014", "RECORD_TYPE": 1, "SE_DDA_NUMBER": "0000000070" },
    { "ABA_BANK_NUMBER": "111000012", "AMEX_PAYEE_NUMBER": "2299999979", "AMEX_SORT_FIELD_1": "0009999000", "AMEX_SORT_FIELD_2": "0000000000", "DEBIT_BALANCE_AMOUNT": "00000000{", "DETAIL_RECORD_TYPE": "00", "PAYMENT_AMOUNT": "0000000528Q", "PAYMENT_DATE": "2014256", "PAYMENT_NUMBER": "254L2582", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "2582", "PAYMENT_NUMBER_TYPE": "L", "PAYMENT_YEAR": "2014", "RECORD_TYPE": 1, "SE_DDA_NUMBER": "0000000070" },
    { "ABA_BANK_NUMBER": "111000012", "AMEX_PAYEE_NUMBER": "2379999582", "AMEX_SORT_FIELD_1": "0009999000", "AMEX_SORT_FIELD_2": "0000000000", "DEBIT_BALANCE_AMOUNT": "00000000{", "DETAIL_RECORD_TYPE": "00", "PAYMENT_AMOUNT": "0000003269C", "PAYMENT_DATE": "2014256", "PAYMENT_NUMBER": "254L8733", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "8733", "PAYMENT_NUMBER_TYPE": "L", "PAYMENT_YEAR": "2014", "RECORD_TYPE": 1, "SE_DDA_NUMBER": "0000003129" },
    { "ABA_BANK_NUMBER": "111000012", "AMEX_PAYEE_NUMBER": "2379999582", "AMEX_SORT_FIELD_1": "0009999000", "AMEX_SORT_FIELD_2": "0000000000", "DEBIT_BALANCE_AMOUNT": "00000000{", "DETAIL_RECORD_TYPE": "00", "PAYMENT_AMOUNT": "0000000089R", "PAYMENT_DATE": "2014256", "PAYMENT_NUMBER": "254L8734", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "8734", "PAYMENT_NUMBER_TYPE": "L", "PAYMENT_YEAR": "2014", "RECORD_TYPE": 1, "SE_DDA_NUMBER": "0000003129" },
    { "ABA_BANK_NUMBER": "111000012", "AMEX_PAYEE_NUMBER": "2429999649", "AMEX_SORT_FIELD_1": "0009999000", "AMEX_SORT_FIELD_2": "0000000000", "DEBIT_BALANCE_AMOUNT": "00000000{", "DETAIL_RECORD_TYPE": "00", "PAYMENT_AMOUNT": "0000000019H", "PAYMENT_DATE": "2014256", "PAYMENT_NUMBER": "254C6019", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "6019", "PAYMENT_NUMBER_TYPE": "C", "PAYMENT_YEAR": "2014", "RECORD_TYPE": 1, "SE_DDA_NUMBER": "0000007954" },
    { "ABA_BANK_NUMBER": "111000012", "AMEX_PAYEE_NUMBER": "2429999763", "AMEX_SORT_FIELD_1": "0009999000", "AMEX_SORT_FIELD_2": "0000000000", "DEBIT_BALANCE_AMOUNT": "00000000{", "DETAIL_RECORD_TYPE": "00", "PAYMENT_AMOUNT": "0000000701C", "PAYMENT_DATE": "2014256", "PAYMENT_NUMBER": "254C6020", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "6020", "PAYMENT_NUMBER_TYPE": "C", "PAYMENT_YEAR": "2014", "RECORD_TYPE": 1, "SE_DDA_NUMBER": "0000007954" },
    { "ABA_BANK_NUMBER": "111000012", "AMEX_PAYEE_NUMBER": "2429999789", "AMEX_SORT_FIELD_1": "0009999000", "AMEX_SORT_FIELD_2": "0000000000", "DEBIT_BALANCE_AMOUNT": "00000000{", "DETAIL_RECORD_TYPE": "00", "PAYMENT_AMOUNT": "0000000146A", "PAYMENT_DATE": "2014256", "PAYMENT_NUMBER": "254C6021", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "6021", "PAYMENT_NUMBER_TYPE": "C", "PAYMENT_YEAR": "2014", "RECORD_TYPE": 1, "SE_DDA_NUMBER": "0000007954" },
    { "ABA_BANK_NUMBER": "111000012", "AMEX_PAYEE_NUMBER": "2429999938", "AMEX_SORT_FIELD_1": "0009999000", "AMEX_SORT_FIELD_2": "0000000000", "DEBIT_BALANCE_AMOUNT": "00000000{", "DETAIL_RECORD_TYPE": "00", "PAYMENT_AMOUNT": "0000001563C", "PAYMENT_DATE": "2014256", "PAYMENT_NUMBER": "254C6022", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "6022", "PAYMENT_NUMBER_TYPE": "C", "PAYMENT_YEAR": "2014", "RECORD_TYPE": 1, "SE_DDA_NUMBER": "0000007954" },
    { "ABA_BANK_NUMBER": "111000012", "AMEX_PAYEE_NUMBER": "2429999961", "AMEX_SORT_FIELD_1": "0009999000", "AMEX_SORT_FIELD_2": "0000000000", "DEBIT_BALANCE_AMOUNT": "00000000{", "DETAIL_RECORD_TYPE": "00", "PAYMENT_AMOUNT": "0000077478G", "PAYMENT_DATE": "2014256", "PAYMENT_NUMBER": "254U1181", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "1181", "PAYMENT_NUMBER_TYPE": "U", "PAYMENT_YEAR": "2014", "RECORD_TYPE": 1, "SE_DDA_NUMBER": "0000007954" },
    { "ABA_BANK_NUMBER": "111000012", "AMEX_PAYEE_NUMBER": "2429999928", "AMEX_SORT_FIELD_1": "0009999000", "AMEX_SORT_FIELD_2": "0000000000", "DEBIT_BALANCE_AMOUNT": "00000000{", "DETAIL_RECORD_TYPE": "00", "PAYMENT_AMOUNT": "0000084315F", "PAYMENT_DATE": "2014256", "PAYMENT_NUMBER": "254M5144", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "5144", "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": "2014", "RECORD_TYPE": 1, "SE_DDA_NUMBER": "0000003002" },
    { "ABA_BANK_NUMBER": "111000012", "AMEX_PAYEE_NUMBER": "2429999564", "AMEX_SORT_FIELD_1": "0009999000", "AMEX_SORT_FIELD_2": "0000000000", "DEBIT_BALANCE_AMOUNT": "00000000{", "DETAIL_RECORD_TYPE": "00", "PAYMENT_AMOUNT": "0000034722B", "PAYMENT_DATE": "2014256", "PAYMENT_NUMBER": "254M5619", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "5619", "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": "2014", "RECORD_TYPE": 1, "SE_DDA_NUMBER": "0000001761" },
    { "ABA_BANK_NUMBER": "111000012", "AMEX_PAYEE_NUMBER": "2429999740", "AMEX_SORT_FIELD_1": "0009999000", "AMEX_SORT_FIELD_2": "0000000000", "DEBIT_BALANCE_AMOUNT": "00000000{", "DETAIL_RECORD_TYPE": "00", "PAYMENT_AMOUNT": "0000069130D", "PAYMENT_DATE": "2014256", "PAYMENT_NUMBER": "254M9006", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "9006", "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": "2014", "RECORD_TYPE": 1, "SE_DDA_NUMBER": "0000000096" },
    { "ABA_BANK_NUMBER": "111000012", "AMEX_PAYEE_NUMBER": "2429999740", "AMEX_SORT_FIELD_1": "0009999000", "AMEX_SORT_FIELD_2": "0000000000", "DEBIT_BALANCE_AMOUNT": "00000000{", "DETAIL_RECORD_TYPE": "00", "PAYMENT_AMOUNT": "0000001901J", "PAYMENT_DATE": "2014256", "PAYMENT_NUMBER": "254M9007", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "9007", "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": "2014", "RECORD_TYPE": 1, "SE_DDA_NUMBER": "0000000096" },
    { "ABA_BANK_NUMBER": "111000012", "AMEX_PAYEE_NUMBER": "2429999034", "AMEX_SORT_FIELD_1": "0009999000", "AMEX_SORT_FIELD_2": "0000000000", "DEBIT_BALANCE_AMOUNT": "00000000{", "DETAIL_RECORD_TYPE": "00", "PAYMENT_AMOUNT": "0000004319C", "PAYMENT_DATE": "2014256", "PAYMENT_NUMBER": "254M9224", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "9224", "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": "2014", "RECORD_TYPE": 1, "SE_DDA_NUMBER": "0000003116" },
    { "ABA_BANK_NUMBER": "111000012", "AMEX_PAYEE_NUMBER": "2429999034", "AMEX_SORT_FIELD_1": "0009999000", "AMEX_SORT_FIELD_2": "0000000000", "DEBIT_BALANCE_AMOUNT": "00000000{", "DETAIL_RECORD_TYPE": "00", "PAYMENT_AMOUNT": "0000000118Q", "PAYMENT_DATE": "2014256", "PAYMENT_NUMBER": "254M9225", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "9225", "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": "2014", "RECORD_TYPE": 1, "SE_DDA_NUMBER": "0000003116" },
    { "ABA_BANK_NUMBER": "111000012", "AMEX_PAYEE_NUMBER": "3129999193", "AMEX_SORT_FIELD_1": "0009999000", "AMEX_SORT_FIELD_2": "0000000000", "DEBIT_BALANCE_AMOUNT": "00000000{", "DETAIL_RECORD_TYPE": "00", "PAYMENT_AMOUNT": "0000063316G", "PAYMENT_DATE": "2014256", "PAYMENT_NUMBER": "254M4165", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "4165", "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": "2014", "RECORD_TYPE": 1, "SE_DDA_NUMBER": "0000003282" },
    { "ABA_BANK_NUMBER": "111000012", "AMEX_PAYEE_NUMBER": "3229999977", "AMEX_SORT_FIELD_1": "0009999000", "AMEX_SORT_FIELD_2": "0000000000", "DEBIT_BALANCE_AMOUNT": "00000000{", "DETAIL_RECORD_TYPE": "00", "PAYMENT_AMOUNT": "0000099245A", "PAYMENT_DATE": "2014256", "PAYMENT_NUMBER": "254M7990", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "7990", "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": "2014", "RECORD_TYPE": 1, "SE_DDA_NUMBER": "0000003279" },
    { "ABA_BANK_NUMBER": "111000012", "AMEX_PAYEE_NUMBER": "4109999881", "AMEX_SORT_FIELD_1": "0009999000", "AMEX_SORT_FIELD_2": "0000000000", "DEBIT_BALANCE_AMOUNT": "00000000{", "DETAIL_RECORD_TYPE": "00", "PAYMENT_AMOUNT": "0000053256D", "PAYMENT_DATE": "2014256", "PAYMENT_NUMBER": "254M5048", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "5048", "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": "2014", "RECORD_TYPE": 1, "SE_DDA_NUMBER": "0000003028" },
    { "ABA_BANK_NUMBER": "111000012", "AMEX_PAYEE_NUMBER": "4109999177", "AMEX_SORT_FIELD_1": "0009999000", "AMEX_SORT_FIELD_2": "0000000000", "DEBIT_BALANCE_AMOUNT": "00000000{", "DETAIL_RECORD_TYPE": "00", "PAYMENT_AMOUNT": "0000000283H", "PAYMENT_DATE": "2014256", "PAYMENT_NUMBER": "254M7145", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "7145", "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": "2014", "RECORD_TYPE": 1, "SE_DDA_NUMBER": "0000000083" },
    { "ABA_BANK_NUMBER": "111000012", "AMEX_PAYEE_NUMBER": "4109999177", "AMEX_SORT_FIELD_1": "0009999000", "AMEX_SORT_FIELD_2": "0000000000", "DEBIT_BALANCE_AMOUNT": "00000000{", "DETAIL_RECORD_TYPE": "00", "PAYMENT_AMOUNT": "0000000007Q", "PAYMENT_DATE": "2014256", "PAYMENT_NUMBER": "254M7146", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "7146", "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": "2014", "RECORD_TYPE": 1, "SE_DDA_NUMBER": "0000000083" },
    { "ABA_BANK_NUMBER": "111000012", "AMEX_PAYEE_NUMBER": "4169999182", "AMEX_SORT_FIELD_1": "0009999000", "AMEX_SORT_FIELD_2": "0000000000", "DEBIT_BALANCE_AMOUNT": "00000000{", "DETAIL_RECORD_TYPE": "00", "PAYMENT_AMOUNT": "0000028035G", "PAYMENT_DATE": "2014256", "PAYMENT_NUMBER": "254M9582", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "9582", "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": "2014", "RECORD_TYPE": 1, "SE_DDA_NUMBER": "0000003158" },
    { "ABA_BANK_NUMBER": "111000012", "AMEX_PAYEE_NUMBER": "4169999182", "AMEX_SORT_FIELD_1": "0009999000", "AMEX_SORT_FIELD_2": "0000000000", "DEBIT_BALANCE_AMOUNT": "00000000{", "DETAIL_RECORD_TYPE": "00", "PAYMENT_AMOUNT": "0000000754Q", "PAYMENT_DATE": "2014256", "PAYMENT_NUMBER": "254M9583", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "9583", "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": "2014", "RECORD_TYPE": 1, "SE_DDA_NUMBER": "0000003158" },
    { "ABA_BANK_NUMBER": "111000012", "AMEX_PAYEE_NUMBER": "4329999734", "AMEX_SORT_FIELD_1": "0009999000", "AMEX_SORT_FIELD_2": "0000000000", "DEBIT_BALANCE_AMOUNT": "00000000{", "DETAIL_RECORD_TYPE": "00", "PAYMENT_AMOUNT": "0000017279E", "PAYMENT_DATE": "2014256", "PAYMENT_NUMBER": "254D6481", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "6481", "PAYMENT_NUMBER_TYPE": "D", "PAYMENT_YEAR": "2014", "RECORD_TYPE": 1, "SE_DDA_NUMBER": "0000002699" },
    { "ABA_BANK_NUMBER": "111000012", "AMEX_PAYEE_NUMBER": "4419999772", "AMEX_SORT_FIELD_1": "0009999000", "AMEX_SORT_FIELD_2": "0000000000", "DEBIT_BALANCE_AMOUNT": "00000000{", "DETAIL_RECORD_TYPE": "00", "PAYMENT_AMOUNT": "0000003266F", "PAYMENT_DATE": "2014256", "PAYMENT_NUMBER": "254M2689", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "2689", "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": "2014", "RECORD_TYPE": 1, "SE_DDA_NUMBER": "0000003145" },
    { "ABA_BANK_NUMBER": "111000012", "AMEX_PAYEE_NUMBER": "4419999772", "AMEX_SORT_FIELD_1": "0009999000", "AMEX_SORT_FIELD_2": "0000000000", "DEBIT_BALANCE_AMOUNT": "00000000{", "DETAIL_RECORD_TYPE": "00", "PAYMENT_AMOUNT": "0000000081R", "PAYMENT_DATE": "2014256", "PAYMENT_NUMBER": "254M2690", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "2690", "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": "2014", "RECORD_TYPE": 1, "SE_DDA_NUMBER": "0000003145" },
    { "ABA_BANK_NUMBER": "111000012", "AMEX_PAYEE_NUMBER": "4459999588", "AMEX_SORT_FIELD_1": "0009999000", "AMEX_SORT_FIELD_2": "0000000000", "DEBIT_BALANCE_AMOUNT": "00000000{", "DETAIL_RECORD_TYPE": "00", "PAYMENT_AMOUNT": "0000030378E", "PAYMENT_DATE": "2014256", "PAYMENT_NUMBER": "254M6699", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "6699", "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": "2014", "RECORD_TYPE": 1, "SE_DDA_NUMBER": "0000005387" },
    { "ABA_BANK_NUMBER": "111000012", "AMEX_PAYEE_NUMBER": "5029999057", "AMEX_SORT_FIELD_1": "0009999000", "AMEX_SORT_FIELD_2": "0000000000", "DEBIT_BALANCE_AMOUNT": "00000000{", "DETAIL_RECORD_TYPE": "00", "PAYMENT_AMOUNT": "0000085830E", "PAYMENT_DATE": "2014256", "PAYMENT_NUMBER": "254M8033", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "8033", "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": "2014", "RECORD_TYPE": 1, "SE_DDA_NUMBER": "0000000724" },
    { "ABA_BANK_NUMBER": "111000012", "AMEX_PAYEE_NUMBER": "5029999289", "AMEX_SORT_FIELD_1": "0009999000", "AMEX_SORT_FIELD_2": "0000000000", "DEBIT_BALANCE_AMOUNT": "00000000{", "DETAIL_RECORD_TYPE": "00", "PAYMENT_AMOUNT": "0000013295D", "PAYMENT_DATE": "2014256", "PAYMENT_NUMBER": "254M0295", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "0295", "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": "2014", "RECORD_TYPE": 1, "SE_DDA_NUMBER": "0000003213" },
    { "ABA_BANK_NUMBER": "111000012", "AMEX_PAYEE_NUMBER": "5029999289", "AMEX_SORT_FIELD_1": "0009999000", "AMEX_SORT_FIELD_2": "0000000000", "DEBIT_BALANCE_AMOUNT": "00000000{", "DETAIL_RECORD_TYPE": "00", "PAYMENT_AMOUNT": "0000000365O", "PAYMENT_DATE": "2014256", "PAYMENT_NUMBER": "254M0296", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "0296", "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": "2014", "RECORD_TYPE": 1, "SE_DDA_NUMBER": "0000003213" },
    { "ABA_BANK_NUMBER": "111000012", "AMEX_PAYEE_NUMBER": "5279999046", "AMEX_SORT_FIELD_1": "0009999000", "AMEX_SORT_FIELD_2": "0000000000", "DEBIT_BALANCE_AMOUNT": "00000000{", "DETAIL_RECORD_TYPE": "00", "PAYMENT_AMOUNT": "0000000966G", "PAYMENT_DATE": "2014256", "PAYMENT_NUMBER": "254S6115", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "6115", "PAYMENT_NUMBER_TYPE": "S", "PAYMENT_YEAR": "2014", "RECORD_TYPE": 1, "SE_DDA_NUMBER": "0000003864" },
    { "ABA_BANK_NUMBER": "021000089", "AMEX_PAYEE_NUMBER": "5279999579", "AMEX_SORT_FIELD_1": "0009999000", "AMEX_SORT_FIELD_2": "0000000000", "DEBIT_BALANCE_AMOUNT": "00000000{", "DETAIL_RECORD_TYPE": "00", "PAYMENT_AMOUNT": "0000001322G", "PAYMENT_DATE": "2014256", "PAYMENT_NUMBER": "254S2139", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "2139", "PAYMENT_NUMBER_TYPE": "S", "PAYMENT_YEAR": "2014", "RECORD_TYPE": 1, "SE_DDA_NUMBER": "00007368"   },
    { "ABA_BANK_NUMBER": "071000013", "AMEX_PAYEE_NUMBER": "5439999059", "AMEX_SORT_FIELD_1": "0009999000", "AMEX_SORT_FIELD_2": "0000000000", "DEBIT_BALANCE_AMOUNT": "00000000{", "DETAIL_RECORD_TYPE": "00", "PAYMENT_AMOUNT": "0000129984C", "PAYMENT_DATE": "2014256", "PAYMENT_NUMBER": "254D8477", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "8477", "PAYMENT_NUMBER_TYPE": "D", "PAYMENT_YEAR": "2014", "RECORD_TYPE": 1, "SE_DDA_NUMBER": "0005730"    },
    { "ABA_BANK_NUMBER": "111000025", "AMEX_PAYEE_NUMBER": "5469999720", "AMEX_SORT_FIELD_1": "0009999000", "AMEX_SORT_FIELD_2": "0000000000", "DEBIT_BALANCE_AMOUNT": "00000000{", "DETAIL_RECORD_TYPE": "00", "PAYMENT_AMOUNT": "0000038575B", "PAYMENT_DATE": "2014256", "PAYMENT_NUMBER": "254A1705", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "1705", "PAYMENT_NUMBER_TYPE": "A", "PAYMENT_YEAR": "2014", "RECORD_TYPE": 1, "SE_DDA_NUMBER": "0000006199" },
    { "ABA_BANK_NUMBER": "111000012", "AMEX_PAYEE_NUMBER": "5469999267", "AMEX_SORT_FIELD_1": "0009999000", "AMEX_SORT_FIELD_2": "0000000000", "DEBIT_BALANCE_AMOUNT": "00000000{", "DETAIL_RECORD_TYPE": "00", "PAYMENT_AMOUNT": "0000009351I", "PAYMENT_DATE": "2014256", "PAYMENT_NUMBER": "254T9183", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "9183", "PAYMENT_NUMBER_TYPE": "T", "PAYMENT_YEAR": "2014", "RECORD_TYPE": 1, "SE_DDA_NUMBER": "0000003921" }
  ],
  "SOC_DETAIL": [
    { "AMEX_GROSS_AMOUNT": "0000052779D", "AMEX_PAYEE_NUMBER": 1049999176, "AMEX_PROCESS_DATE": 2014253, "AMEX_ROC_COUNT": "0001D", "AMEX_ROC_COUNT_POA": "000001D", "AMEX_SE_NUMBER": 1049999176, "BASE_DISCOUNT_AMOUNT": "-000000000013195", "CARD_NOT_PRESENT_BPA_AMOUNT": " 000000000000000", "CARD_NOT_PRESENT_BPA_RATE": " 00000000", "CARD_NOT_PRESENT_PTA_AMOUNT": " 000000000000000", "CARD_NOT_PRESENT_PTA_RATE": " 00000000", "CPC_INDICATOR": "", "DETAIL_RECORD_TYPE": 10, "DISCOUNT_AMOUNT": "00001319E", "DISCOUNT_RATE": "02500", "NET_SOC_AMOUNT": "0000052779D", "PAYMENT_NUMBER": "254F8666", "PAYMENT_NUMBER_DATE": 254, "PAYMENT_NUMBER_NUMBER": 8666, "PAYMENT_NUMBER_TYPE": "F", "PAYMENT_YEAR": 2014, "RECORD_TYPE": 2, "SE_BUSINESS_DATE": 2014253, "SERVICE_FEE_AMOUNT": "000015H", "SERVICE_FEE_RATE": "00030", "SE_UNIT_NUMBER": "0000000002", "SOC_AMOUNT": "0000052779D", "SOC_INVOICE_NUMBER": 253016, "TRACKING_ID": 253013016, "TRACKING_ID_DATE": 253, "TRACKING_ID_PCID": "013016", "TRANSACTION_FEE_AMOUNT": " 000000000000000", "TRANSACTION_FEE_RATE": " 00000000" },
    { "AMEX_GROSS_AMOUNT": "0000037319D", "AMEX_PAYEE_NUMBER": 1049999084, "AMEX_PROCESS_DATE": 2014253, "AMEX_ROC_COUNT": "0000I", "AMEX_ROC_COUNT_POA": "000000I", "AMEX_SE_NUMBER": 1049999084, "BASE_DISCOUNT_AMOUNT": "-000000000010263", "CARD_NOT_PRESENT_BPA_AMOUNT": " 000000000000000", "CARD_NOT_PRESENT_BPA_RATE": " 00000000", "CARD_NOT_PRESENT_PTA_AMOUNT": " 000000000000000", "CARD_NOT_PRESENT_PTA_RATE": " 00000000", "CPC_INDICATOR": "", "DETAIL_RECORD_TYPE": 10, "DISCOUNT_AMOUNT": "00001026C", "DISCOUNT_RATE": "02750", "NET_SOC_AMOUNT": "0000037319D", "PAYMENT_NUMBER": "254H1728", "PAYMENT_NUMBER_DATE": 254, "PAYMENT_NUMBER_NUMBER": 1728, "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": 2014, "RECORD_TYPE": 2, "SE_BUSINESS_DATE": 2014253, "SERVICE_FEE_AMOUNT": "000011B", "SERVICE_FEE_RATE": "00030", "SE_UNIT_NUMBER": "0SAN DIEGO", "SOC_AMOUNT": "0000037319D", "SOC_INVOICE_NUMBER": 253016, "TRACKING_ID": 253013016, "TRACKING_ID_DATE": 253, "TRACKING_ID_PCID": "013016", "TRANSACTION_FEE_AMOUNT": " 000000000000000", "TRANSACTION_FEE_RATE": " 00000000" },
    { "AMEX_GROSS_AMOUNT": "0000044730F", "AMEX_PAYEE_NUMBER": 1049999700, "AMEX_PROCESS_DATE": 2014253, "AMEX_ROC_COUNT": "0001B", "AMEX_ROC_COUNT_POA": "000001B", "AMEX_SE_NUMBER": 1049999700, "BASE_DISCOUNT_AMOUNT": "-000000000012301", "CARD_NOT_PRESENT_BPA_AMOUNT": " 000000000000000", "CARD_NOT_PRESENT_BPA_RATE": " 00000000", "CARD_NOT_PRESENT_PTA_AMOUNT": " 000000000000000", "CARD_NOT_PRESENT_PTA_RATE": " 00000000", "CPC_INDICATOR": "", "DETAIL_RECORD_TYPE": 10, "DISCOUNT_AMOUNT": "00001230A", "DISCOUNT_RATE": "02750", "NET_SOC_AMOUNT": "0000044730F", "PAYMENT_NUMBER": "254H3242", "PAYMENT_NUMBER_DATE": 254, "PAYMENT_NUMBER_NUMBER": 3242, "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": 2014, "RECORD_TYPE": 2, "SE_BUSINESS_DATE": 2014253, "SERVICE_FEE_AMOUNT": "000013D", "SERVICE_FEE_RATE": "00030", "SE_UNIT_NUMBER": "0000000007", "SOC_AMOUNT": "0000044730F", "SOC_INVOICE_NUMBER": 253016, "TRACKING_ID": 253013016, "TRACKING_ID_DATE": 253, "TRACKING_ID_PCID": "013016", "TRANSACTION_FEE_AMOUNT": " 000000000000000", "TRANSACTION_FEE_RATE": " 00000000" },
    { "AMEX_GROSS_AMOUNT": "0000142227F", "AMEX_PAYEE_NUMBER": 1049999728, "AMEX_PROCESS_DATE": 2014253, "AMEX_ROC_COUNT": "0006H", "AMEX_ROC_COUNT_POA": "000006H", "AMEX_SE_NUMBER": 1049999728, "BASE_DISCOUNT_AMOUNT": "-000000000038895", "CARD_NOT_PRESENT_BPA_AMOUNT": " 000000000000000", "CARD_NOT_PRESENT_BPA_RATE": " 00000000", "CARD_NOT_PRESENT_PTA_AMOUNT": " 000000000000000", "CARD_NOT_PRESENT_PTA_RATE": " 00000000", "CPC_INDICATOR": "", "DETAIL_RECORD_TYPE": 10, "DISCOUNT_AMOUNT": "00003889E", "DISCOUNT_RATE": "02750", "NET_SOC_AMOUNT": "0000142227F", "PAYMENT_NUMBER": "254H3651", "PAYMENT_NUMBER_DATE": 254, "PAYMENT_NUMBER_NUMBER": 3651, "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": 2014, "RECORD_TYPE": 2, "SE_BUSINESS_DATE": 2014253, "SERVICE_FEE_AMOUNT": "000042G", "SERVICE_FEE_RATE": "00030", "SE_UNIT_NUMBER": "0000000009", "SOC_AMOUNT": "0000142227F", "SOC_INVOICE_NUMBER": 253016, "TRACKING_ID": 253013016, "TRACKING_ID_DATE": 253, "TRACKING_ID_PCID": "013016", "TRANSACTION_FEE_AMOUNT": " 000000000000000", "TRANSACTION_FEE_RATE": " 00000000" },
    { "AMEX_GROSS_AMOUNT": "0000063927{", "AMEX_PAYEE_NUMBER": 1049999121, "AMEX_PROCESS_DATE": 2014253, "AMEX_ROC_COUNT": "0002A", "AMEX_ROC_COUNT_POA": "000002A", "AMEX_SE_NUMBER": 1049999121, "BASE_DISCOUNT_AMOUNT": "-000000000017580", "CARD_NOT_PRESENT_BPA_AMOUNT": " 000000000000000", "CARD_NOT_PRESENT_BPA_RATE": " 00000000", "CARD_NOT_PRESENT_PTA_AMOUNT": " 000000000000000", "CARD_NOT_PRESENT_PTA_RATE": " 00000000", "CPC_INDICATOR": "", "DETAIL_RECORD_TYPE": 10, "DISCOUNT_AMOUNT": "00001758{", "DISCOUNT_RATE": "02750", "NET_SOC_AMOUNT": "0000063927{", "PAYMENT_NUMBER": "254H4390", "PAYMENT_NUMBER_DATE": 254, "PAYMENT_NUMBER_NUMBER": 4390, "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": 2014, "RECORD_TYPE": 2, "SE_BUSINESS_DATE": 2014253, "SERVICE_FEE_AMOUNT": "000019B", "SERVICE_FEE_RATE": "00030", "SE_UNIT_NUMBER": "0000000015", "SOC_AMOUNT": "0000063927{", "SOC_INVOICE_NUMBER": 253016, "TRACKING_ID": 253013016, "TRACKING_ID_DATE": 253, "TRACKING_ID_PCID": "013016", "TRANSACTION_FEE_AMOUNT": " 000000000000000", "TRANSACTION_FEE_RATE": " 00000000" },
    { "AMEX_GROSS_AMOUNT": "0000032909{", "AMEX_PAYEE_NUMBER": 1049999246, "AMEX_PROCESS_DATE": 2014253, "AMEX_ROC_COUNT": "0000G", "AMEX_ROC_COUNT_POA": "000000G", "AMEX_SE_NUMBER": 1049999246, "BASE_DISCOUNT_AMOUNT": "-000000000009050", "CARD_NOT_PRESENT_BPA_AMOUNT": " 000000000000000", "CARD_NOT_PRESENT_BPA_RATE": " 00000000", "CARD_NOT_PRESENT_PTA_AMOUNT": " 000000000000000", "CARD_NOT_PRESENT_PTA_RATE": " 00000000", "CPC_INDICATOR": "", "DETAIL_RECORD_TYPE": 10, "DISCOUNT_AMOUNT": "00000905{", "DISCOUNT_RATE": "02750", "NET_SOC_AMOUNT": "0000032909{", "PAYMENT_NUMBER": "254H5067", "PAYMENT_NUMBER_DATE": 254, "PAYMENT_NUMBER_NUMBER": 5067, "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": 2014, "RECORD_TYPE": 2, "SE_BUSINESS_DATE": 2014253, "SERVICE_FEE_AMOUNT": "000009I", "SERVICE_FEE_RATE": "00030", "SE_UNIT_NUMBER": "0000000017", "SOC_AMOUNT": "0000032909{", "SOC_INVOICE_NUMBER": 253016, "TRACKING_ID": 253013016, "TRACKING_ID_DATE": 253, "TRACKING_ID_PCID": "013016", "TRANSACTION_FEE_AMOUNT": " 000000000000000", "TRANSACTION_FEE_RATE": " 00000000" },
    { "AMEX_GROSS_AMOUNT": "0000029178D", "AMEX_PAYEE_NUMBER": 1059999079, "AMEX_PROCESS_DATE": 2014253, "AMEX_ROC_COUNT": "0000G", "AMEX_ROC_COUNT_POA": "000000G", "AMEX_SE_NUMBER": 1059999079, "BASE_DISCOUNT_AMOUNT": "-000000000007962", "CARD_NOT_PRESENT_BPA_AMOUNT": " 000000000000000", "CARD_NOT_PRESENT_BPA_RATE": " 00000000", "CARD_NOT_PRESENT_PTA_AMOUNT": " 000000000000000", "CARD_NOT_PRESENT_PTA_RATE": " 00000000", "CPC_INDICATOR": "", "DETAIL_RECORD_TYPE": 10, "DISCOUNT_AMOUNT": "00000796B", "DISCOUNT_RATE": "02750", "NET_SOC_AMOUNT": "0000029178D", "PAYMENT_NUMBER": "254H9133", "PAYMENT_NUMBER_DATE": 254, "PAYMENT_NUMBER_NUMBER": 9133, "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": 2014, "RECORD_TYPE": 2, "SE_BUSINESS_DATE": 2014253, "SERVICE_FEE_AMOUNT": "000008H", "SERVICE_FEE_RATE": "00030", "SE_UNIT_NUMBER": "PARK MEADO", "SOC_AMOUNT": "0000029178D", "SOC_INVOICE_NUMBER": 253016, "TRACKING_ID": 253013016, "TRACKING_ID_DATE": 253, "TRACKING_ID_PCID": "013016", "TRANSACTION_FEE_AMOUNT": " 000000000000000", "TRANSACTION_FEE_RATE": " 00000000" },
    { "AMEX_GROSS_AMOUNT": "0000048183{", "AMEX_PAYEE_NUMBER": 1099999509, "AMEX_PROCESS_DATE": 2014253, "AMEX_ROC_COUNT": "0001{", "AMEX_ROC_COUNT_POA": "000001{", "AMEX_SE_NUMBER": 1099999509, "BASE_DISCOUNT_AMOUNT": "-000000000013250", "CARD_NOT_PRESENT_BPA_AMOUNT": " 000000000000000", "CARD_NOT_PRESENT_BPA_RATE": " 00000000", "CARD_NOT_PRESENT_PTA_AMOUNT": " 000000000000000", "CARD_NOT_PRESENT_PTA_RATE": " 00000000", "CPC_INDICATOR": "", "DETAIL_RECORD_TYPE": 10, "DISCOUNT_AMOUNT": "00001325{", "DISCOUNT_RATE": "02750", "NET_SOC_AMOUNT": "0000048183{", "PAYMENT_NUMBER": "254E6857", "PAYMENT_NUMBER_DATE": 254, "PAYMENT_NUMBER_NUMBER": 6857, "PAYMENT_NUMBER_TYPE": "E", "PAYMENT_YEAR": 2014, "RECORD_TYPE": 2, "SE_BUSINESS_DATE": 2014253, "SERVICE_FEE_AMOUNT": "000000{", "SERVICE_FEE_RATE": "00000", "SE_UNIT_NUMBER": "0000STR#60", "SOC_AMOUNT": "0000048183{", "SOC_INVOICE_NUMBER": 253016, "TRACKING_ID": 253013016, "TRACKING_ID_DATE": 253, "TRACKING_ID_PCID": "013016", "TRANSACTION_FEE_AMOUNT": " 000000000000000", "TRANSACTION_FEE_RATE": " 00000000" },
    { "AMEX_GROSS_AMOUNT": "0000017998E", "AMEX_PAYEE_NUMBER": 1159999126, "AMEX_PROCESS_DATE": 2014253, "AMEX_ROC_COUNT": "0000D", "AMEX_ROC_COUNT_POA": "000000D", "AMEX_SE_NUMBER": 1159999126, "BASE_DISCOUNT_AMOUNT": "-000000000004950", "CARD_NOT_PRESENT_BPA_AMOUNT": " 000000000000000", "CARD_NOT_PRESENT_BPA_RATE": " 00000000", "CARD_NOT_PRESENT_PTA_AMOUNT": " 000000000000000", "CARD_NOT_PRESENT_PTA_RATE": " 00000000", "CPC_INDICATOR": "", "DETAIL_RECORD_TYPE": 10, "DISCOUNT_AMOUNT": "00000495{", "DISCOUNT_RATE": "02750", "NET_SOC_AMOUNT": "0000017998E", "PAYMENT_NUMBER": "254J2806", "PAYMENT_NUMBER_DATE": 254, "PAYMENT_NUMBER_NUMBER": 2806, "PAYMENT_NUMBER_TYPE": "J", "PAYMENT_YEAR": 2014, "RECORD_TYPE": 2, "SE_BUSINESS_DATE": 2014253, "SERVICE_FEE_AMOUNT": "000005D", "SERVICE_FEE_RATE": "00030", "SE_UNIT_NUMBER": "000STR #25", "SOC_AMOUNT": "0000017998E", "SOC_INVOICE_NUMBER": 253016, "TRACKING_ID": 253013016, "TRACKING_ID_DATE": 253, "TRACKING_ID_PCID": "013016", "TRANSACTION_FEE_AMOUNT": " 000000000000000", "TRANSACTION_FEE_RATE": " 00000000" },
    { "AMEX_GROSS_AMOUNT": "0000000855I", "AMEX_PAYEE_NUMBER": 1269999580, "AMEX_PROCESS_DATE": 2014253, "AMEX_ROC_COUNT": "0000A", "AMEX_ROC_COUNT_POA": "000000A", "AMEX_SE_NUMBER": 1269999580, "BASE_DISCOUNT_AMOUNT": "-000000000000235", "CARD_NOT_PRESENT_BPA_AMOUNT": " 000000000000000", "CARD_NOT_PRESENT_BPA_RATE": " 00000000", "CARD_NOT_PRESENT_PTA_AMOUNT": " 000000000000000", "CARD_NOT_PRESENT_PTA_RATE": " 00000000", "CPC_INDICATOR": "", "DETAIL_RECORD_TYPE": 10, "DISCOUNT_AMOUNT": "00000023E", "DISCOUNT_RATE": "02750", "NET_SOC_AMOUNT": "0000000855I", "PAYMENT_NUMBER": "254J4690", "PAYMENT_NUMBER_DATE": 254, "PAYMENT_NUMBER_NUMBER": 4690, "PAYMENT_NUMBER_TYPE": "J", "PAYMENT_YEAR": 2014, "RECORD_TYPE": 2, "SE_BUSINESS_DATE": 2014253, "SERVICE_FEE_AMOUNT": "000000{", "SERVICE_FEE_RATE": "00000", "SE_UNIT_NUMBER": "00STR#8070", "SOC_AMOUNT": "0000000855I", "SOC_INVOICE_NUMBER": 253016, "TRACKING_ID": 253013016, "TRACKING_ID_DATE": 253, "TRACKING_ID_PCID": "013016", "TRANSACTION_FEE_AMOUNT": " 000000000000000", "TRANSACTION_FEE_RATE": " 00000000" },
    { "AMEX_GROSS_AMOUNT": "0000053894I", "AMEX_PAYEE_NUMBER": 1319999989, "AMEX_PROCESS_DATE": 2014253, "AMEX_ROC_COUNT": "0001B", "AMEX_ROC_COUNT_POA": "000001B", "AMEX_SE_NUMBER": 1319999989, "BASE_DISCOUNT_AMOUNT": "-000000000014821", "CARD_NOT_PRESENT_BPA_AMOUNT": " 000000000000000", "CARD_NOT_PRESENT_BPA_RATE": " 00000000", "CARD_NOT_PRESENT_PTA_AMOUNT": " 000000000000000", "CARD_NOT_PRESENT_PTA_RATE": " 00000000", "CPC_INDICATOR": "", "DETAIL_RECORD_TYPE": 10, "DISCOUNT_AMOUNT": "00001482A", "DISCOUNT_RATE": "02750", "NET_SOC_AMOUNT": "0000053894I", "PAYMENT_NUMBER": "254G2302", "PAYMENT_NUMBER_DATE": 254, "PAYMENT_NUMBER_NUMBER": 2302, "PAYMENT_NUMBER_TYPE": "G", "PAYMENT_YEAR": 2014, "RECORD_TYPE": 2, "SE_BUSINESS_DATE": 2014253, "SERVICE_FEE_AMOUNT": "000000{", "SERVICE_FEE_RATE": "00000", "SE_UNIT_NUMBER": "0000000044", "SOC_AMOUNT": "0000053894I", "SOC_INVOICE_NUMBER": 253016, "TRACKING_ID": 253013016, "TRACKING_ID_DATE": 253, "TRACKING_ID_PCID": "013016", "TRANSACTION_FEE_AMOUNT": " 000000000000000", "TRANSACTION_FEE_RATE": " 00000000" },
    { "AMEX_GROSS_AMOUNT": "0000015153G", "AMEX_PAYEE_NUMBER": 1319999284, "AMEX_PROCESS_DATE": 2014253, "AMEX_ROC_COUNT": "0000C", "AMEX_ROC_COUNT_POA": "000000C", "AMEX_SE_NUMBER": 1319999284, "BASE_DISCOUNT_AMOUNT": "-000000000004167", "CARD_NOT_PRESENT_BPA_AMOUNT": " 000000000000000", "CARD_NOT_PRESENT_BPA_RATE": " 00000000", "CARD_NOT_PRESENT_PTA_AMOUNT": " 000000000000000", "CARD_NOT_PRESENT_PTA_RATE": " 00000000", "CPC_INDICATOR": "", "DETAIL_RECORD_TYPE": 10, "DISCOUNT_AMOUNT": "00000416G", "DISCOUNT_RATE": "02750", "NET_SOC_AMOUNT": "0000015153G", "PAYMENT_NUMBER": "254G2626", "PAYMENT_NUMBER_DATE": 254, "PAYMENT_NUMBER_NUMBER": 2626, "PAYMENT_NUMBER_TYPE": "G", "PAYMENT_YEAR": 2014, "RECORD_TYPE": 2, "SE_BUSINESS_DATE": 2014253, "SERVICE_FEE_AMOUNT": "000000{", "SERVICE_FEE_RATE": "00000", "SE_UNIT_NUMBER": "00STR#8082", "SOC_AMOUNT": "0000015153G", "SOC_INVOICE_NUMBER": 253016, "TRACKING_ID": 253013016, "TRACKING_ID_DATE": 253, "TRACKING_ID_PCID": "013016", "TRANSACTION_FEE_AMOUNT": " 000000000000000", "TRANSACTION_FEE_RATE": " 00000000" },
    { "AMEX_GROSS_AMOUNT": "0000018244{", "AMEX_PAYEE_NUMBER": 2049999582, "AMEX_PROCESS_DATE": 2014253, "AMEX_ROC_COUNT": "0000A", "AMEX_ROC_COUNT_POA": "000000A", "AMEX_SE_NUMBER": 2049999582, "BASE_DISCOUNT_AMOUNT": "-000000000005017", "CARD_NOT_PRESENT_BPA_AMOUNT": " 000000000000000", "CARD_NOT_PRESENT_BPA_RATE": " 00000000", "CARD_NOT_PRESENT_PTA_AMOUNT": " 000000000000000", "CARD_NOT_PRESENT_PTA_RATE": " 00000000", "CPC_INDICATOR": "", "DETAIL_RECORD_TYPE": 10, "DISCOUNT_AMOUNT": "00000501G", "DISCOUNT_RATE": "02750", "NET_SOC_AMOUNT": "0000018244{", "PAYMENT_NUMBER": "254M2653", "PAYMENT_NUMBER_DATE": 254, "PAYMENT_NUMBER_NUMBER": 2653, "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": 2014, "RECORD_TYPE": 2, "SE_BUSINESS_DATE": 2014253, "SERVICE_FEE_AMOUNT": "000000{", "SERVICE_FEE_RATE": "00000", "SE_UNIT_NUMBER": "0000008063", "SOC_AMOUNT": "0000018244{", "SOC_INVOICE_NUMBER": 253016, "TRACKING_ID": 253013016, "TRACKING_ID_DATE": 253, "TRACKING_ID_PCID": "013016", "TRANSACTION_FEE_AMOUNT": " 000000000000000", "TRANSACTION_FEE_RATE": " 00000000" },
    { "AMEX_GROSS_AMOUNT": "0000000000{", "AMEX_PAYEE_NUMBER": 2049999873, "AMEX_PROCESS_DATE": 2014253, "AMEX_ROC_COUNT": "0000D", "AMEX_ROC_COUNT_POA": "000000D", "AMEX_SE_NUMBER": 2049999873, "BASE_DISCOUNT_AMOUNT": " 000000000000000", "CARD_NOT_PRESENT_BPA_AMOUNT": " 000000000000000", "CARD_NOT_PRESENT_BPA_RATE": " 00000000", "CARD_NOT_PRESENT_PTA_AMOUNT": " 000000000000000", "CARD_NOT_PRESENT_PTA_RATE": " 00000000", "CPC_INDICATOR": "", "DETAIL_RECORD_TYPE": 10, "DISCOUNT_AMOUNT": "00000000{", "DISCOUNT_RATE": "02750", "NET_SOC_AMOUNT": "0000000000{", "PAYMENT_NUMBER": "254M3251", "PAYMENT_NUMBER_DATE": 254, "PAYMENT_NUMBER_NUMBER": 3251, "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": 2014, "RECORD_TYPE": 2, "SE_BUSINESS_DATE": 2014253, "SERVICE_FEE_AMOUNT": "000000{", "SERVICE_FEE_RATE": "00000", "SE_UNIT_NUMBER": "000STR #62", "SOC_AMOUNT": "0000000000{", "SOC_INVOICE_NUMBER": 253016, "TRACKING_ID": 253013016, "TRACKING_ID_DATE": 253, "TRACKING_ID_PCID": "013016", "TRANSACTION_FEE_AMOUNT": " 000000000000000", "TRANSACTION_FEE_RATE": " 00000000" },
    { "AMEX_GROSS_AMOUNT": "0000010000H", "AMEX_PAYEE_NUMBER": 2069999156, "AMEX_PROCESS_DATE": 2014253, "AMEX_ROC_COUNT": "0000F", "AMEX_ROC_COUNT_POA": "000000F", "AMEX_SE_NUMBER": 2069999156, "BASE_DISCOUNT_AMOUNT": "-000000000002684", "CARD_NOT_PRESENT_BPA_AMOUNT": " 000000000000000", "CARD_NOT_PRESENT_BPA_RATE": " 00000000", "CARD_NOT_PRESENT_PTA_AMOUNT": " 000000000000000", "CARD_NOT_PRESENT_PTA_RATE": " 00000000", "CPC_INDICATOR": "", "DETAIL_RECORD_TYPE": 10, "DISCOUNT_AMOUNT": "00000268D", "DISCOUNT_RATE": "02750", "NET_SOC_AMOUNT": "0000010000H", "PAYMENT_NUMBER": "254G5069", "PAYMENT_NUMBER_DATE": 254, "PAYMENT_NUMBER_NUMBER": 5069, "PAYMENT_NUMBER_TYPE": "G", "PAYMENT_YEAR": 2014, "RECORD_TYPE": 2, "SE_BUSINESS_DATE": 2014253, "SERVICE_FEE_AMOUNT": "000003{", "SERVICE_FEE_RATE": "00030", "SE_UNIT_NUMBER": "000STR #18", "SOC_AMOUNT": "0000010000H", "SOC_INVOICE_NUMBER": 253016, "TRACKING_ID": 253013016, "TRACKING_ID_DATE": 253, "TRACKING_ID_PCID": "013016", "TRANSACTION_FEE_AMOUNT": " 000000000000000", "TRANSACTION_FEE_RATE": " 00000000" },
    { "AMEX_GROSS_AMOUNT": "0000015301H", "AMEX_PAYEE_NUMBER": 2199999562, "AMEX_PROCESS_DATE": 2014253, "AMEX_ROC_COUNT": "0000E", "AMEX_ROC_COUNT_POA": "000000E", "AMEX_SE_NUMBER": 2199999562, "BASE_DISCOUNT_AMOUNT": "-000000000004208", "CARD_NOT_PRESENT_BPA_AMOUNT": " 000000000000000", "CARD_NOT_PRESENT_BPA_RATE": " 00000000", "CARD_NOT_PRESENT_PTA_AMOUNT": " 000000000000000", "CARD_NOT_PRESENT_PTA_RATE": " 00000000", "CPC_INDICATOR": "", "DETAIL_RECORD_TYPE": 10, "DISCOUNT_AMOUNT": "00000420H", "DISCOUNT_RATE": "02750", "NET_SOC_AMOUNT": "0000015301H", "PAYMENT_NUMBER": "254I0352", "PAYMENT_NUMBER_DATE": 254, "PAYMENT_NUMBER_NUMBER": "0352", "PAYMENT_NUMBER_TYPE": "I", "PAYMENT_YEAR": 2014, "RECORD_TYPE": 2, "SE_BUSINESS_DATE": 2014253, "SERVICE_FEE_AMOUNT": "000000{", "SERVICE_FEE_RATE": "00000", "SE_UNIT_NUMBER": "00STR#8060", "SOC_AMOUNT": "0000015301H", "SOC_INVOICE_NUMBER": 253016, "TRACKING_ID": 253013016, "TRACKING_ID_DATE": 253, "TRACKING_ID_PCID": "013016", "TRANSACTION_FEE_AMOUNT": " 000000000000000", "TRANSACTION_FEE_RATE": " 00000000" },
    { "AMEX_GROSS_AMOUNT": "0000000847I", "AMEX_PAYEE_NUMBER": 2199999169, "AMEX_PROCESS_DATE": 2014253, "AMEX_ROC_COUNT": "0000A", "AMEX_ROC_COUNT_POA": "000000A", "AMEX_SE_NUMBER": 2199999169, "BASE_DISCOUNT_AMOUNT": "-000000000000233", "CARD_NOT_PRESENT_BPA_AMOUNT": " 000000000000000", "CARD_NOT_PRESENT_BPA_RATE": " 00000000", "CARD_NOT_PRESENT_PTA_AMOUNT": " 000000000000000", "CARD_NOT_PRESENT_PTA_RATE": " 00000000", "CPC_INDICATOR": "", "DETAIL_RECORD_TYPE": 10, "DISCOUNT_AMOUNT": "00000023C", "DISCOUNT_RATE": "02750", "NET_SOC_AMOUNT": "0000000847I", "PAYMENT_NUMBER": "254I0383", "PAYMENT_NUMBER_DATE": 254, "PAYMENT_NUMBER_NUMBER": "0383", "PAYMENT_NUMBER_TYPE": "I", "PAYMENT_YEAR": 2014, "RECORD_TYPE": 2, "SE_BUSINESS_DATE": 2014253, "SERVICE_FEE_AMOUNT": "000000{", "SERVICE_FEE_RATE": "00000", "SE_UNIT_NUMBER": "0Str #8085", "SOC_AMOUNT": "0000000847I", "SOC_INVOICE_NUMBER": 253016, "TRACKING_ID": 253013016, "TRACKING_ID_DATE": 253, "TRACKING_ID_PCID": "013016", "TRANSACTION_FEE_AMOUNT": " 000000000000000", "TRANSACTION_FEE_RATE": " 00000000" },
    { "AMEX_GROSS_AMOUNT": "0000019338A", "AMEX_PAYEE_NUMBER": 2299999656, "AMEX_PROCESS_DATE": 2014253, "AMEX_ROC_COUNT": "0000F", "AMEX_ROC_COUNT_POA": "000000F", "AMEX_SE_NUMBER": 2299999656, "BASE_DISCOUNT_AMOUNT": "-000000000005158", "CARD_NOT_PRESENT_BPA_AMOUNT": " 000000000000000", "CARD_NOT_PRESENT_BPA_RATE": " 00000000", "CARD_NOT_PRESENT_PTA_AMOUNT": " 000000000000000", "CARD_NOT_PRESENT_PTA_RATE": " 00000000", "CPC_INDICATOR": "", "DETAIL_RECORD_TYPE": 10, "DISCOUNT_AMOUNT": "00000515H", "DISCOUNT_RATE": "02750", "NET_SOC_AMOUNT": "0000019338A", "PAYMENT_NUMBER": "254L1705", "PAYMENT_NUMBER_DATE": 254, "PAYMENT_NUMBER_NUMBER": 1705, "PAYMENT_NUMBER_TYPE": "L", "PAYMENT_YEAR": 2014, "RECORD_TYPE": 2, "SE_BUSINESS_DATE": 2014253, "SERVICE_FEE_AMOUNT": "000005H", "SERVICE_FEE_RATE": "00030", "SE_UNIT_NUMBER": "0000000022", "SOC_AMOUNT": "0000019338A", "SOC_INVOICE_NUMBER": 253016, "TRACKING_ID": 253013016, "TRACKING_ID_DATE": 253, "TRACKING_ID_PCID": "013016", "TRANSACTION_FEE_AMOUNT": " 000000000000000", "TRANSACTION_FEE_RATE": " 00000000" },
    { "AMEX_GROSS_AMOUNT": "0000088407D", "AMEX_PAYEE_NUMBER": 2299999510, "AMEX_PROCESS_DATE": 2014253, "AMEX_ROC_COUNT": "0001{", "AMEX_ROC_COUNT_POA": "000001{", "AMEX_SE_NUMBER": 2299999510, "BASE_DISCOUNT_AMOUNT": "-000000000024312", "CARD_NOT_PRESENT_BPA_AMOUNT": " 000000000000000", "CARD_NOT_PRESENT_BPA_RATE": " 00000000", "CARD_NOT_PRESENT_PTA_AMOUNT": " 000000000000000", "CARD_NOT_PRESENT_PTA_RATE": " 00000000", "CPC_INDICATOR": "", "DETAIL_RECORD_TYPE": 10, "DISCOUNT_AMOUNT": "00002431B", "DISCOUNT_RATE": "02750", "NET_SOC_AMOUNT": "0000088407D", "PAYMENT_NUMBER": "254L1727", "PAYMENT_NUMBER_DATE": 254, "PAYMENT_NUMBER_NUMBER": 1727, "PAYMENT_NUMBER_TYPE": "L", "PAYMENT_YEAR": 2014, "RECORD_TYPE": 2, "SE_BUSINESS_DATE": 2014253, "SERVICE_FEE_AMOUNT": "000026E", "SERVICE_FEE_RATE": "00030", "SE_UNIT_NUMBER": "0000000023", "SOC_AMOUNT": "0000088407D", "SOC_INVOICE_NUMBER": 253016, "TRACKING_ID": 253013016, "TRACKING_ID_DATE": 253, "TRACKING_ID_PCID": "013016", "TRANSACTION_FEE_AMOUNT": " 000000000000000", "TRANSACTION_FEE_RATE": " 00000000" },
    { "AMEX_GROSS_AMOUNT": "0000019230C", "AMEX_PAYEE_NUMBER": 2299999979, "AMEX_PROCESS_DATE": 2014253, "AMEX_ROC_COUNT": "0001B", "AMEX_ROC_COUNT_POA": "000001B", "AMEX_SE_NUMBER": 2299999979, "BASE_DISCOUNT_AMOUNT": "-000000000005288", "CARD_NOT_PRESENT_BPA_AMOUNT": " 000000000000000", "CARD_NOT_PRESENT_BPA_RATE": " 00000000", "CARD_NOT_PRESENT_PTA_AMOUNT": " 000000000000000", "CARD_NOT_PRESENT_PTA_RATE": " 00000000", "CPC_INDICATOR": "", "DETAIL_RECORD_TYPE": 10, "DISCOUNT_AMOUNT": "00000528H", "DISCOUNT_RATE": "02750", "NET_SOC_AMOUNT": "0000019230C", "PAYMENT_NUMBER": "254L2581", "PAYMENT_NUMBER_DATE": 254, "PAYMENT_NUMBER_NUMBER": 2581, "PAYMENT_NUMBER_TYPE": "L", "PAYMENT_YEAR": 2014, "RECORD_TYPE": 2, "SE_BUSINESS_DATE": 2014253, "SERVICE_FEE_AMOUNT": "000000{", "SERVICE_FEE_RATE": "00000", "SE_UNIT_NUMBER": "0000000055", "SOC_AMOUNT": "0000019230C", "SOC_INVOICE_NUMBER": 253016, "TRACKING_ID": 253013016, "TRACKING_ID_DATE": 253, "TRACKING_ID_PCID": "013016", "TRANSACTION_FEE_AMOUNT": " 000000000000000", "TRANSACTION_FEE_RATE": " 00000000" },
    { "AMEX_GROSS_AMOUNT": "0000003269C", "AMEX_PAYEE_NUMBER": 2379999582, "AMEX_PROCESS_DATE": 2014253, "AMEX_ROC_COUNT": "0000A", "AMEX_ROC_COUNT_POA": "000000A", "AMEX_SE_NUMBER": 2379999582, "BASE_DISCOUNT_AMOUNT": "-000000000000899", "CARD_NOT_PRESENT_BPA_AMOUNT": " 000000000000000", "CARD_NOT_PRESENT_BPA_RATE": " 00000000", "CARD_NOT_PRESENT_PTA_AMOUNT": " 000000000000000", "CARD_NOT_PRESENT_PTA_RATE": " 00000000", "CPC_INDICATOR": "", "DETAIL_RECORD_TYPE": 10, "DISCOUNT_AMOUNT": "00000089I", "DISCOUNT_RATE": "02750", "NET_SOC_AMOUNT": "0000003269C", "PAYMENT_NUMBER": "254L8733", "PAYMENT_NUMBER_DATE": 254, "PAYMENT_NUMBER_NUMBER": 8733, "PAYMENT_NUMBER_TYPE": "L", "PAYMENT_YEAR": 2014, "RECORD_TYPE": 2, "SE_BUSINESS_DATE": 2014253, "SERVICE_FEE_AMOUNT": "000000{", "SERVICE_FEE_RATE": "00000", "SE_UNIT_NUMBER": "0000008062", "SOC_AMOUNT": "0000003269C", "SOC_INVOICE_NUMBER": 253016, "TRACKING_ID": 253013016, "TRACKING_ID_DATE": 253, "TRACKING_ID_PCID": "013016", "TRANSACTION_FEE_AMOUNT": " 000000000000000", "TRANSACTION_FEE_RATE": " 00000000" },
    { "AMEX_GROSS_AMOUNT": "0000000020C", "AMEX_PAYEE_NUMBER": 2429999649, "AMEX_PROCESS_DATE": 2014253, "AMEX_ROC_COUNT": "0000A", "AMEX_ROC_COUNT_POA": "000000A", "AMEX_SE_NUMBER": 2429999649, "BASE_DISCOUNT_AMOUNT": "-000000000000005", "CARD_NOT_PRESENT_BPA_AMOUNT": " 000000000000000", "CARD_NOT_PRESENT_BPA_RATE": " 00000000", "CARD_NOT_PRESENT_PTA_AMOUNT": " 000000000000000", "CARD_NOT_PRESENT_PTA_RATE": " 00000000", "CPC_INDICATOR": "", "DETAIL_RECORD_TYPE": 10, "DISCOUNT_AMOUNT": "00000000E", "DISCOUNT_RATE": "02350", "NET_SOC_AMOUNT": "0000000019H", "PAYMENT_NUMBER": "254C6019", "PAYMENT_NUMBER_DATE": 254, "PAYMENT_NUMBER_NUMBER": 6019, "PAYMENT_NUMBER_TYPE": "C", "PAYMENT_YEAR": 2014, "RECORD_TYPE": 2, "SE_BUSINESS_DATE": 2014253, "SERVICE_FEE_AMOUNT": "000000{", "SERVICE_FEE_RATE": "00000", "SE_UNIT_NUMBER": 2420622649, "SOC_AMOUNT": "0000000020C", "SOC_INVOICE_NUMBER": 253016, "TRACKING_ID": 253013016, "TRACKING_ID_DATE": 253, "TRACKING_ID_PCID": "013016", "TRANSACTION_FEE_AMOUNT": " 000000000000000", "TRANSACTION_FEE_RATE": " 00000000" },
    { "AMEX_GROSS_AMOUNT": "0000000720{", "AMEX_PAYEE_NUMBER": 2429999763, "AMEX_PROCESS_DATE": 2014253, "AMEX_ROC_COUNT": "0000A", "AMEX_ROC_COUNT_POA": "000000A", "AMEX_SE_NUMBER": 2429999763, "BASE_DISCOUNT_AMOUNT": "-000000000000187", "CARD_NOT_PRESENT_BPA_AMOUNT": " 000000000000000", "CARD_NOT_PRESENT_BPA_RATE": " 00000000", "CARD_NOT_PRESENT_PTA_AMOUNT": " 000000000000000", "CARD_NOT_PRESENT_PTA_RATE": " 00000000", "CPC_INDICATOR": "", "DETAIL_RECORD_TYPE": 10, "DISCOUNT_AMOUNT": "00000018G", "DISCOUNT_RATE": "02600", "NET_SOC_AMOUNT": "0000000701C", "PAYMENT_NUMBER": "254C6020", "PAYMENT_NUMBER_DATE": 254, "PAYMENT_NUMBER_NUMBER": 6020, "PAYMENT_NUMBER_TYPE": "C", "PAYMENT_YEAR": 2014, "RECORD_TYPE": 2, "SE_BUSINESS_DATE": 2014253, "SERVICE_FEE_AMOUNT": "000000{", "SERVICE_FEE_RATE": "00000", "SE_UNIT_NUMBER": 2420622763, "SOC_AMOUNT": "0000000720{", "SOC_INVOICE_NUMBER": 253016, "TRACKING_ID": 253013016, "TRACKING_ID_DATE": 253, "TRACKING_ID_PCID": "013016", "TRANSACTION_FEE_AMOUNT": " 000000000000000", "TRANSACTION_FEE_RATE": " 00000000" },
    { "AMEX_GROSS_AMOUNT": "0000000150{", "AMEX_PAYEE_NUMBER": 2429999789, "AMEX_PROCESS_DATE": 2014253, "AMEX_ROC_COUNT": "0000A", "AMEX_ROC_COUNT_POA": "000000A", "AMEX_SE_NUMBER": 2429999789, "BASE_DISCOUNT_AMOUNT": "-000000000000039", "CARD_NOT_PRESENT_BPA_AMOUNT": " 000000000000000", "CARD_NOT_PRESENT_BPA_RATE": " 00000000", "CARD_NOT_PRESENT_PTA_AMOUNT": " 000000000000000", "CARD_NOT_PRESENT_PTA_RATE": " 00000000", "CPC_INDICATOR": "", "DETAIL_RECORD_TYPE": 10, "DISCOUNT_AMOUNT": "00000003I", "DISCOUNT_RATE": "02600", "NET_SOC_AMOUNT": "0000000146A", "PAYMENT_NUMBER": "254C6021", "PAYMENT_NUMBER_DATE": 254, "PAYMENT_NUMBER_NUMBER": 6021, "PAYMENT_NUMBER_TYPE": "C", "PAYMENT_YEAR": 2014, "RECORD_TYPE": 2, "SE_BUSINESS_DATE": 2014253, "SERVICE_FEE_AMOUNT": "000000{", "SERVICE_FEE_RATE": "00000", "SE_UNIT_NUMBER": 2420622789, "SOC_AMOUNT": "0000000150{", "SOC_INVOICE_NUMBER": 253016, "TRACKING_ID": 253013016, "TRACKING_ID_DATE": 253, "TRACKING_ID_PCID": "013016", "TRANSACTION_FEE_AMOUNT": " 000000000000000", "TRANSACTION_FEE_RATE": " 00000000" },
    { "AMEX_GROSS_AMOUNT": "0000001605{", "AMEX_PAYEE_NUMBER": 2429999938, "AMEX_PROCESS_DATE": 2014253, "AMEX_ROC_COUNT": "0000A", "AMEX_ROC_COUNT_POA": "000000A", "AMEX_SE_NUMBER": 2429999938, "BASE_DISCOUNT_AMOUNT": "-000000000000417", "CARD_NOT_PRESENT_BPA_AMOUNT": " 000000000000000", "CARD_NOT_PRESENT_BPA_RATE": " 00000000", "CARD_NOT_PRESENT_PTA_AMOUNT": " 000000000000000", "CARD_NOT_PRESENT_PTA_RATE": " 00000000", "CPC_INDICATOR": "", "DETAIL_RECORD_TYPE": 10, "DISCOUNT_AMOUNT": "00000041G", "DISCOUNT_RATE": "02600", "NET_SOC_AMOUNT": "0000001563C", "PAYMENT_NUMBER": "254C6022", "PAYMENT_NUMBER_DATE": 254, "PAYMENT_NUMBER_NUMBER": 6022, "PAYMENT_NUMBER_TYPE": "C", "PAYMENT_YEAR": 2014, "RECORD_TYPE": 2, "SE_BUSINESS_DATE": 2014253, "SERVICE_FEE_AMOUNT": "000000{", "SERVICE_FEE_RATE": "00000", "SE_UNIT_NUMBER": 2420622938, "SOC_AMOUNT": "0000001605{", "SOC_INVOICE_NUMBER": 253016, "TRACKING_ID": 253013016, "TRACKING_ID_DATE": 253, "TRACKING_ID_PCID": "013016", "TRANSACTION_FEE_AMOUNT": " 000000000000000", "TRANSACTION_FEE_RATE": " 00000000" },
    { "AMEX_GROSS_AMOUNT": "0000038410}", "AMEX_PAYEE_NUMBER": 2429999961, "AMEX_PROCESS_DATE": 2014253, "AMEX_ROC_COUNT": "0001I", "AMEX_ROC_COUNT_POA": "000001I", "AMEX_SE_NUMBER": 2429999961, "BASE_DISCOUNT_AMOUNT": " 000000000009987", "CARD_NOT_PRESENT_BPA_AMOUNT": " 000000000000000", "CARD_NOT_PRESENT_BPA_RATE": " 00000000", "CARD_NOT_PRESENT_PTA_AMOUNT": " 000000000000000", "CARD_NOT_PRESENT_PTA_RATE": " 00000000", "CPC_INDICATOR": "", "DETAIL_RECORD_TYPE": 10, "DISCOUNT_AMOUNT": "00000998P", "DISCOUNT_RATE": "02600", "NET_SOC_AMOUNT": "0000037411L", "PAYMENT_NUMBER": "254U1181", "PAYMENT_NUMBER_DATE": 254, "PAYMENT_NUMBER_NUMBER": 1181, "PAYMENT_NUMBER_TYPE": "U", "PAYMENT_YEAR": 2014, "RECORD_TYPE": 2, "SE_BUSINESS_DATE": 2014253, "SERVICE_FEE_AMOUNT": "000000{", "SERVICE_FEE_RATE": "00000", "SE_UNIT_NUMBER": 2420622961, "SOC_AMOUNT": "0000038410}", "SOC_INVOICE_NUMBER": 253016, "TRACKING_ID": 253013016, "TRACKING_ID_DATE": 253, "TRACKING_ID_PCID": "013016", "TRANSACTION_FEE_AMOUNT": " 000000000000000", "TRANSACTION_FEE_RATE": " 00000000" },
    { "AMEX_GROSS_AMOUNT": "0000017747L", "AMEX_PAYEE_NUMBER": 2429999961, "AMEX_PROCESS_DATE": 2014253, "AMEX_ROC_COUNT": "0000C", "AMEX_ROC_COUNT_POA": "000000C", "AMEX_SE_NUMBER": 2429999961, "BASE_DISCOUNT_AMOUNT": " 000000000004614", "CARD_NOT_PRESENT_BPA_AMOUNT": " 000000000000000", "CARD_NOT_PRESENT_BPA_RATE": " 00000000", "CARD_NOT_PRESENT_PTA_AMOUNT": " 000000000000000", "CARD_NOT_PRESENT_PTA_RATE": " 00000000", "CPC_INDICATOR": "", "DETAIL_RECORD_TYPE": 10, "DISCOUNT_AMOUNT": "00000461M", "DISCOUNT_RATE": "02600", "NET_SOC_AMOUNT": "0000017285R", "PAYMENT_NUMBER": "254U1181", "PAYMENT_NUMBER_DATE": 254, "PAYMENT_NUMBER_NUMBER": 1181, "PAYMENT_NUMBER_TYPE": "U", "PAYMENT_YEAR": 2014, "RECORD_TYPE": 2, "SE_BUSINESS_DATE": 2014253, "SERVICE_FEE_AMOUNT": "000000{", "SERVICE_FEE_RATE": "00000", "SE_UNIT_NUMBER": 2420622961, "SOC_AMOUNT": "0000017747L", "SOC_INVOICE_NUMBER": 253016, "TRACKING_ID": 253013016, "TRACKING_ID_DATE": 253, "TRACKING_ID_PCID": "013016", "TRANSACTION_FEE_AMOUNT": " 000000000000000", "TRANSACTION_FEE_RATE": " 00000000" },
    { "AMEX_GROSS_AMOUNT": "0000011193N", "AMEX_PAYEE_NUMBER": 2429999961, "AMEX_PROCESS_DATE": 2014253, "AMEX_ROC_COUNT": "0000B", "AMEX_ROC_COUNT_POA": "000000B", "AMEX_SE_NUMBER": 2429999961, "BASE_DISCOUNT_AMOUNT": " 000000000002910", "CARD_NOT_PRESENT_BPA_AMOUNT": " 000000000000000", "CARD_NOT_PRESENT_BPA_RATE": " 00000000", "CARD_NOT_PRESENT_PTA_AMOUNT": " 000000000000000", "CARD_NOT_PRESENT_PTA_RATE": " 00000000", "CPC_INDICATOR": "", "DETAIL_RECORD_TYPE": 10, "DISCOUNT_AMOUNT": "00000291}", "DISCOUNT_RATE": "02600", "NET_SOC_AMOUNT": "0000010902N", "PAYMENT_NUMBER": "254U1181", "PAYMENT_NUMBER_DATE": 254, "PAYMENT_NUMBER_NUMBER": 1181, "PAYMENT_NUMBER_TYPE": "U", "PAYMENT_YEAR": 2014, "RECORD_TYPE": 2, "SE_BUSINESS_DATE": 2014253, "SERVICE_FEE_AMOUNT": "000000{", "SERVICE_FEE_RATE": "00000", "SE_UNIT_NUMBER": 2420622961, "SOC_AMOUNT": "0000011193N", "SOC_INVOICE_NUMBER": 253016, "TRACKING_ID": 253013016, "TRACKING_ID_DATE": 253, "TRACKING_ID_PCID": "013016", "TRANSACTION_FEE_AMOUNT": " 000000000000000", "TRANSACTION_FEE_RATE": " 00000000" },
    { "AMEX_GROSS_AMOUNT": "0000004377P", "AMEX_PAYEE_NUMBER": 2429999961, "AMEX_PROCESS_DATE": 2014253, "AMEX_ROC_COUNT": "0000H", "AMEX_ROC_COUNT_POA": "000000H", "AMEX_SE_NUMBER": 2429999961, "BASE_DISCOUNT_AMOUNT": " 000000000001138", "CARD_NOT_PRESENT_BPA_AMOUNT": " 000000000000000", "CARD_NOT_PRESENT_BPA_RATE": " 00000000", "CARD_NOT_PRESENT_PTA_AMOUNT": " 000000000000000", "CARD_NOT_PRESENT_PTA_RATE": " 00000000", "CPC_INDICATOR": "", "DETAIL_RECORD_TYPE": 10, "DISCOUNT_AMOUNT": "00000113Q", "DISCOUNT_RATE": "02600", "NET_SOC_AMOUNT": "0000004263R", "PAYMENT_NUMBER": "254U1181", "PAYMENT_NUMBER_DATE": 254, "PAYMENT_NUMBER_NUMBER": 1181, "PAYMENT_NUMBER_TYPE": "U", "PAYMENT_YEAR": 2014, "RECORD_TYPE": 2, "SE_BUSINESS_DATE": 2014253, "SERVICE_FEE_AMOUNT": "000000{", "SERVICE_FEE_RATE": "00000", "SE_UNIT_NUMBER": 2420622961, "SOC_AMOUNT": "0000004377P", "SOC_INVOICE_NUMBER": 253016, "TRACKING_ID": 253013016, "TRACKING_ID_DATE": 253, "TRACKING_ID_PCID": "013016", "TRANSACTION_FEE_AMOUNT": " 000000000000000", "TRANSACTION_FEE_RATE": " 00000000" },
    { "AMEX_GROSS_AMOUNT": "0000000968L", "AMEX_PAYEE_NUMBER": 2429999961, "AMEX_PROCESS_DATE": 2014253, "AMEX_ROC_COUNT": "0000G", "AMEX_ROC_COUNT_POA": "000000G", "AMEX_SE_NUMBER": 2429999961, "BASE_DISCOUNT_AMOUNT": " 000000000000252", "CARD_NOT_PRESENT_BPA_AMOUNT": " 000000000000000", "CARD_NOT_PRESENT_BPA_RATE": " 00000000", "CARD_NOT_PRESENT_PTA_AMOUNT": " 000000000000000", "CARD_NOT_PRESENT_PTA_RATE": " 00000000", "CPC_INDICATOR": "", "DETAIL_RECORD_TYPE": 10, "DISCOUNT_AMOUNT": "00000025K", "DISCOUNT_RATE": "02600", "NET_SOC_AMOUNT": "0000000943J", "PAYMENT_NUMBER": "254U1181", "PAYMENT_NUMBER_DATE": 254, "PAYMENT_NUMBER_NUMBER": 1181, "PAYMENT_NUMBER_TYPE": "U", "PAYMENT_YEAR": 2014, "RECORD_TYPE": 2, "SE_BUSINESS_DATE": 2014253, "SERVICE_FEE_AMOUNT": "000000{", "SERVICE_FEE_RATE": "00000", "SE_UNIT_NUMBER": 2420622961, "SOC_AMOUNT": "0000000968L", "SOC_INVOICE_NUMBER": 253016, "TRACKING_ID": 253013016, "TRACKING_ID_DATE": 253, "TRACKING_ID_PCID": "013016", "TRANSACTION_FEE_AMOUNT": " 000000000000000", "TRANSACTION_FEE_RATE": " 00000000" },
    { "AMEX_GROSS_AMOUNT": "0000000051F", "AMEX_PAYEE_NUMBER": 2429999961, "AMEX_PROCESS_DATE": 2014253, "AMEX_ROC_COUNT": "0000A", "AMEX_ROC_COUNT_POA": "000000A", "AMEX_SE_NUMBER": 2429999961, "BASE_DISCOUNT_AMOUNT": "-000000000000013", "CARD_NOT_PRESENT_BPA_AMOUNT": " 000000000000000", "CARD_NOT_PRESENT_BPA_RATE": " 00000000", "CARD_NOT_PRESENT_PTA_AMOUNT": " 000000000000000", "CARD_NOT_PRESENT_PTA_RATE": " 00000000", "CPC_INDICATOR": "", "DETAIL_RECORD_TYPE": 10, "DISCOUNT_AMOUNT": "00000001C", "DISCOUNT_RATE": "02600", "NET_SOC_AMOUNT": "0000000050C", "PAYMENT_NUMBER": "254U1181", "PAYMENT_NUMBER_DATE": 254, "PAYMENT_NUMBER_NUMBER": 1181, "PAYMENT_NUMBER_TYPE": "U", "PAYMENT_YEAR": 2014, "RECORD_TYPE": 2, "SE_BUSINESS_DATE": 2014253, "SERVICE_FEE_AMOUNT": "000000{", "SERVICE_FEE_RATE": "00000", "SE_UNIT_NUMBER": 2420622961, "SOC_AMOUNT": "0000000051F", "SOC_INVOICE_NUMBER": 253016, "TRACKING_ID": 253013016, "TRACKING_ID_DATE": 253, "TRACKING_ID_PCID": "013016", "TRANSACTION_FEE_AMOUNT": " 000000000000000", "TRANSACTION_FEE_RATE": " 00000000" },
    { "AMEX_GROSS_AMOUNT": "0000001980}", "AMEX_PAYEE_NUMBER": 2429999961, "AMEX_PROCESS_DATE": 2014253, "AMEX_ROC_COUNT": "0000B", "AMEX_ROC_COUNT_POA": "000000B", "AMEX_SE_NUMBER": 2429999961, "BASE_DISCOUNT_AMOUNT": " 000000000000515", "CARD_NOT_PRESENT_BPA_AMOUNT": " 000000000000000", "CARD_NOT_PRESENT_BPA_RATE": " 00000000", "CARD_NOT_PRESENT_PTA_AMOUNT": " 000000000000000", "CARD_NOT_PRESENT_PTA_RATE": " 00000000", "CPC_INDICATOR": "", "DETAIL_RECORD_TYPE": 10, "DISCOUNT_AMOUNT": "00000051N", "DISCOUNT_RATE": "02600", "NET_SOC_AMOUNT": "0000001928N", "PAYMENT_NUMBER": "254U1181", "PAYMENT_NUMBER_DATE": 254, "PAYMENT_NUMBER_NUMBER": 1181, "PAYMENT_NUMBER_TYPE": "U", "PAYMENT_YEAR": 2014, "RECORD_TYPE": 2, "SE_BUSINESS_DATE": 2014253, "SERVICE_FEE_AMOUNT": "000000{", "SERVICE_FEE_RATE": "00000", "SE_UNIT_NUMBER": 2420622961, "SOC_AMOUNT": "0000001980}", "SOC_INVOICE_NUMBER": 253016, "TRACKING_ID": 253013016, "TRACKING_ID_DATE": 253, "TRACKING_ID_PCID": "013016", "TRANSACTION_FEE_AMOUNT": " 000000000000000", "TRANSACTION_FEE_RATE": " 00000000" },
    { "AMEX_GROSS_AMOUNT": "0000000913D", "AMEX_PAYEE_NUMBER": 2429999961, "AMEX_PROCESS_DATE": 2014253, "AMEX_ROC_COUNT": "0000B", "AMEX_ROC_COUNT_POA": "000000B", "AMEX_SE_NUMBER": 2429999961, "BASE_DISCOUNT_AMOUNT": "-000000000000237", "CARD_NOT_PRESENT_BPA_AMOUNT": " 000000000000000", "CARD_NOT_PRESENT_BPA_RATE": " 00000000", "CARD_NOT_PRESENT_PTA_AMOUNT": " 000000000000000", "CARD_NOT_PRESENT_PTA_RATE": " 00000000", "CPC_INDICATOR": "", "DETAIL_RECORD_TYPE": 10, "DISCOUNT_AMOUNT": "00000023G", "DISCOUNT_RATE": "02600", "NET_SOC_AMOUNT": "0000000889G", "PAYMENT_NUMBER": "254U1181", "PAYMENT_NUMBER_DATE": 254, "PAYMENT_NUMBER_NUMBER": 1181, "PAYMENT_NUMBER_TYPE": "U", "PAYMENT_YEAR": 2014, "RECORD_TYPE": 2, "SE_BUSINESS_DATE": 2014253, "SERVICE_FEE_AMOUNT": "000000{", "SERVICE_FEE_RATE": "00000", "SE_UNIT_NUMBER": 2420622961, "SOC_AMOUNT": "0000000913D", "SOC_INVOICE_NUMBER": 253016, "TRACKING_ID": 253013016, "TRACKING_ID_DATE": 253, "TRACKING_ID_PCID": "013016", "TRANSACTION_FEE_AMOUNT": " 000000000000000", "TRANSACTION_FEE_RATE": " 00000000" },
    { "AMEX_GROSS_AMOUNT": "0000006915A", "AMEX_PAYEE_NUMBER": 2429999961, "AMEX_PROCESS_DATE": 2014253, "AMEX_ROC_COUNT": "0000C", "AMEX_ROC_COUNT_POA": "000000C", "AMEX_SE_NUMBER": 2429999961, "BASE_DISCOUNT_AMOUNT": "-000000000001798", "CARD_NOT_PRESENT_BPA_AMOUNT": " 000000000000000", "CARD_NOT_PRESENT_BPA_RATE": " 00000000", "CARD_NOT_PRESENT_PTA_AMOUNT": " 000000000000000", "CARD_NOT_PRESENT_PTA_RATE": " 00000000", "CPC_INDICATOR": "", "DETAIL_RECORD_TYPE": 10, "DISCOUNT_AMOUNT": "00000179H", "DISCOUNT_RATE": "02600", "NET_SOC_AMOUNT": "0000006735C", "PAYMENT_NUMBER": "254U1181", "PAYMENT_NUMBER_DATE": 254, "PAYMENT_NUMBER_NUMBER": 1181, "PAYMENT_NUMBER_TYPE": "U", "PAYMENT_YEAR": 2014, "RECORD_TYPE": 2, "SE_BUSINESS_DATE": 2014253, "SERVICE_FEE_AMOUNT": "000000{", "SERVICE_FEE_RATE": "00000", "SE_UNIT_NUMBER": 2420622961, "SOC_AMOUNT": "0000006915A", "SOC_INVOICE_NUMBER": 253016, "TRACKING_ID": 253013016, "TRACKING_ID_DATE": 253, "TRACKING_ID_PCID": "013016", "TRANSACTION_FEE_AMOUNT": " 000000000000000", "TRANSACTION_FEE_RATE": " 00000000" },
    { "AMEX_GROSS_AMOUNT": "0000003411{", "AMEX_PAYEE_NUMBER": 2429999961, "AMEX_PROCESS_DATE": 2014253, "AMEX_ROC_COUNT": "0000A", "AMEX_ROC_COUNT_POA": "000000A", "AMEX_SE_NUMBER": 2429999961, "BASE_DISCOUNT_AMOUNT": "-000000000000887", "CARD_NOT_PRESENT_BPA_AMOUNT": " 000000000000000", "CARD_NOT_PRESENT_BPA_RATE": " 00000000", "CARD_NOT_PRESENT_PTA_AMOUNT": " 000000000000000", "CARD_NOT_PRESENT_PTA_RATE": " 00000000", "CPC_INDICATOR": "", "DETAIL_RECORD_TYPE": 10, "DISCOUNT_AMOUNT": "00000088G", "DISCOUNT_RATE": "02600", "NET_SOC_AMOUNT": "0000003322C", "PAYMENT_NUMBER": "254U1181", "PAYMENT_NUMBER_DATE": 254, "PAYMENT_NUMBER_NUMBER": 1181, "PAYMENT_NUMBER_TYPE": "U", "PAYMENT_YEAR": 2014, "RECORD_TYPE": 2, "SE_BUSINESS_DATE": 2014253, "SERVICE_FEE_AMOUNT": "000000{", "SERVICE_FEE_RATE": "00000", "SE_UNIT_NUMBER": 2420622961, "SOC_AMOUNT": "0000003411{", "SOC_INVOICE_NUMBER": 253016, "TRACKING_ID": 253013016, "TRACKING_ID_DATE": 253, "TRACKING_ID_PCID": "013016", "TRANSACTION_FEE_AMOUNT": " 000000000000000", "TRANSACTION_FEE_RATE": " 00000000" },
    { "AMEX_GROSS_AMOUNT": "0000000212Q", "AMEX_PAYEE_NUMBER": 2429999961, "AMEX_PROCESS_DATE": 2014253, "AMEX_ROC_COUNT": "0000C", "AMEX_ROC_COUNT_POA": "000000C", "AMEX_SE_NUMBER": 2429999961, "BASE_DISCOUNT_AMOUNT": " 000000000000055", "CARD_NOT_PRESENT_BPA_AMOUNT": " 000000000000000", "CARD_NOT_PRESENT_BPA_RATE": " 00000000", "CARD_NOT_PRESENT_PTA_AMOUNT": " 000000000000000", "CARD_NOT_PRESENT_PTA_RATE": " 00000000", "CPC_INDICATOR": "", "DETAIL_RECORD_TYPE": 10, "DISCOUNT_AMOUNT": "00000005N", "DISCOUNT_RATE": "02600", "NET_SOC_AMOUNT": "0000000207L", "PAYMENT_NUMBER": "254U1181", "PAYMENT_NUMBER_DATE": 254, "PAYMENT_NUMBER_NUMBER": 1181, "PAYMENT_NUMBER_TYPE": "U", "PAYMENT_YEAR": 2014, "RECORD_TYPE": 2, "SE_BUSINESS_DATE": 2014253, "SERVICE_FEE_AMOUNT": "000000{", "SERVICE_FEE_RATE": "00000", "SE_UNIT_NUMBER": 2420622961, "SOC_AMOUNT": "0000000212Q", "SOC_INVOICE_NUMBER": 253016, "TRACKING_ID": 253013016, "TRACKING_ID_DATE": 253, "TRACKING_ID_PCID": "013016", "TRANSACTION_FEE_AMOUNT": " 000000000000000", "TRANSACTION_FEE_RATE": " 00000000" },
    { "AMEX_GROSS_AMOUNT": "0000038992H", "AMEX_PAYEE_NUMBER": 2429999961, "AMEX_PROCESS_DATE": 2014253, "AMEX_ROC_COUNT": "0002D", "AMEX_ROC_COUNT_POA": "000002D", "AMEX_SE_NUMBER": 2429999961, "BASE_DISCOUNT_AMOUNT": "-000000000010116", "CARD_NOT_PRESENT_BPA_AMOUNT": " 000000000000000", "CARD_NOT_PRESENT_BPA_RATE": " 00000000", "CARD_NOT_PRESENT_PTA_AMOUNT": " 000000000000000", "CARD_NOT_PRESENT_PTA_RATE": " 00000000", "CPC_INDICATOR": "", "DETAIL_RECORD_TYPE": 10, "DISCOUNT_AMOUNT": "00001011F", "DISCOUNT_RATE": "02600", "NET_SOC_AMOUNT": "0000037981B", "PAYMENT_NUMBER": "254U1181", "PAYMENT_NUMBER_DATE": 254, "PAYMENT_NUMBER_NUMBER": 1181, "PAYMENT_NUMBER_TYPE": "U", "PAYMENT_YEAR": 2014, "RECORD_TYPE": 2, "SE_BUSINESS_DATE": 2014253, "SERVICE_FEE_AMOUNT": "000000{", "SERVICE_FEE_RATE": "00000", "SE_UNIT_NUMBER": 2420622961, "SOC_AMOUNT": "0000038992H", "SOC_INVOICE_NUMBER": 253016, "TRACKING_ID": 253013016, "TRACKING_ID_DATE": 253, "TRACKING_ID_PCID": "013016", "TRANSACTION_FEE_AMOUNT": " 000000000000000", "TRANSACTION_FEE_RATE": " 00000000" },
    { "AMEX_GROSS_AMOUNT": "0000120549I", "AMEX_PAYEE_NUMBER": 2429999961, "AMEX_PROCESS_DATE": 2014253, "AMEX_ROC_COUNT": "0010D", "AMEX_ROC_COUNT_POA": "000010D", "AMEX_SE_NUMBER": 2429999961, "BASE_DISCOUNT_AMOUNT": "-000000000031324", "CARD_NOT_PRESENT_BPA_AMOUNT": " 000000000000000", "CARD_NOT_PRESENT_BPA_RATE": " 00000000", "CARD_NOT_PRESENT_PTA_AMOUNT": " 000000000000000", "CARD_NOT_PRESENT_PTA_RATE": " 00000000", "CPC_INDICATOR": "", "DETAIL_RECORD_TYPE": 10, "DISCOUNT_AMOUNT": "00003132D", "DISCOUNT_RATE": "02600", "NET_SOC_AMOUNT": "0000117417E", "PAYMENT_NUMBER": "254U1181", "PAYMENT_NUMBER_DATE": 254, "PAYMENT_NUMBER_NUMBER": 1181, "PAYMENT_NUMBER_TYPE": "U", "PAYMENT_YEAR": 2014, "RECORD_TYPE": 2, "SE_BUSINESS_DATE": 2014253, "SERVICE_FEE_AMOUNT": "000000{", "SERVICE_FEE_RATE": "00000", "SE_UNIT_NUMBER": 2420622961, "SOC_AMOUNT": "0000120549I", "SOC_INVOICE_NUMBER": 253016, "TRACKING_ID": 253013016, "TRACKING_ID_DATE": 253, "TRACKING_ID_PCID": "013016", "TRANSACTION_FEE_AMOUNT": " 000000000000000", "TRANSACTION_FEE_RATE": " 00000000" },
    { "AMEX_GROSS_AMOUNT": "0000084315F", "AMEX_PAYEE_NUMBER": 2429999928, "AMEX_PROCESS_DATE": 2014253, "AMEX_ROC_COUNT": "0001{", "AMEX_ROC_COUNT_POA": "000001{", "AMEX_SE_NUMBER": 2429999928, "BASE_DISCOUNT_AMOUNT": "-000000000023187", "CARD_NOT_PRESENT_BPA_AMOUNT": " 000000000000000", "CARD_NOT_PRESENT_BPA_RATE": " 00000000", "CARD_NOT_PRESENT_PTA_AMOUNT": " 000000000000000", "CARD_NOT_PRESENT_PTA_RATE": " 00000000", "CPC_INDICATOR": "", "DETAIL_RECORD_TYPE": 10, "DISCOUNT_AMOUNT": "00002318G", "DISCOUNT_RATE": "02750", "NET_SOC_AMOUNT": "0000084315F", "PAYMENT_NUMBER": "254M5144", "PAYMENT_NUMBER_DATE": 254, "PAYMENT_NUMBER_NUMBER": 5144, "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": 2014, "RECORD_TYPE": 2, "SE_BUSINESS_DATE": 2014253, "SERVICE_FEE_AMOUNT": "000025C", "SERVICE_FEE_RATE": "00030", "SE_UNIT_NUMBER": "0000000012", "SOC_AMOUNT": "0000084315F", "SOC_INVOICE_NUMBER": 253016, "TRACKING_ID": 253013016, "TRACKING_ID_DATE": 253, "TRACKING_ID_PCID": "013016", "TRANSACTION_FEE_AMOUNT": " 000000000000000", "TRANSACTION_FEE_RATE": " 00000000" },
    { "AMEX_GROSS_AMOUNT": "0000034722B", "AMEX_PAYEE_NUMBER": 2429999564, "AMEX_PROCESS_DATE": 2014253, "AMEX_ROC_COUNT": "0000E", "AMEX_ROC_COUNT_POA": "000000E", "AMEX_SE_NUMBER": 2429999564, "BASE_DISCOUNT_AMOUNT": "-000000000009549", "CARD_NOT_PRESENT_BPA_AMOUNT": " 000000000000000", "CARD_NOT_PRESENT_BPA_RATE": " 00000000", "CARD_NOT_PRESENT_PTA_AMOUNT": " 000000000000000", "CARD_NOT_PRESENT_PTA_RATE": " 00000000", "CPC_INDICATOR": "", "DETAIL_RECORD_TYPE": 10, "DISCOUNT_AMOUNT": "00000954I", "DISCOUNT_RATE": "02750", "NET_SOC_AMOUNT": "0000034722B", "PAYMENT_NUMBER": "254M5619", "PAYMENT_NUMBER_DATE": 254, "PAYMENT_NUMBER_NUMBER": 5619, "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": 2014, "RECORD_TYPE": 2, "SE_BUSINESS_DATE": 2014253, "SERVICE_FEE_AMOUNT": "000010D", "SERVICE_FEE_RATE": "00030", "SE_UNIT_NUMBER": "0000000011", "SOC_AMOUNT": "0000034722B", "SOC_INVOICE_NUMBER": 253016, "TRACKING_ID": 253013016, "TRACKING_ID_DATE": 253, "TRACKING_ID_PCID": "013016", "TRANSACTION_FEE_AMOUNT": " 000000000000000", "TRANSACTION_FEE_RATE": " 00000000" },
    { "AMEX_GROSS_AMOUNT": "0000069130D", "AMEX_PAYEE_NUMBER": 2429999740, "AMEX_PROCESS_DATE": 2014253, "AMEX_ROC_COUNT": "0000G", "AMEX_ROC_COUNT_POA": "000000G", "AMEX_SE_NUMBER": 2429999740, "BASE_DISCOUNT_AMOUNT": "-000000000019011", "CARD_NOT_PRESENT_BPA_AMOUNT": " 000000000000000", "CARD_NOT_PRESENT_BPA_RATE": " 00000000", "CARD_NOT_PRESENT_PTA_AMOUNT": " 000000000000000", "CARD_NOT_PRESENT_PTA_RATE": " 00000000", "CPC_INDICATOR": "", "DETAIL_RECORD_TYPE": 10, "DISCOUNT_AMOUNT": "00001901A", "DISCOUNT_RATE": "02750", "NET_SOC_AMOUNT": "0000069130D", "PAYMENT_NUMBER": "254M9006", "PAYMENT_NUMBER_DATE": 254, "PAYMENT_NUMBER_NUMBER": 9006, "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": 2014, "RECORD_TYPE": 2, "SE_BUSINESS_DATE": 2014253, "SERVICE_FEE_AMOUNT": "000000{", "SERVICE_FEE_RATE": "00000", "SE_UNIT_NUMBER": "0000000061", "SOC_AMOUNT": "0000069130D", "SOC_INVOICE_NUMBER": 253016, "TRACKING_ID": 253013016, "TRACKING_ID_DATE": 253, "TRACKING_ID_PCID": "013016", "TRANSACTION_FEE_AMOUNT": " 000000000000000", "TRANSACTION_FEE_RATE": " 00000000" },
    { "AMEX_GROSS_AMOUNT": "0000004319C", "AMEX_PAYEE_NUMBER": 2429999034, "AMEX_PROCESS_DATE": 2014253, "AMEX_ROC_COUNT": "0000A", "AMEX_ROC_COUNT_POA": "000000A", "AMEX_SE_NUMBER": 2429999034, "BASE_DISCOUNT_AMOUNT": "-000000000001188", "CARD_NOT_PRESENT_BPA_AMOUNT": " 000000000000000", "CARD_NOT_PRESENT_BPA_RATE": " 00000000", "CARD_NOT_PRESENT_PTA_AMOUNT": " 000000000000000", "CARD_NOT_PRESENT_PTA_RATE": " 00000000", "CPC_INDICATOR": "", "DETAIL_RECORD_TYPE": 10, "DISCOUNT_AMOUNT": "00000118H", "DISCOUNT_RATE": "02750", "NET_SOC_AMOUNT": "0000004319C", "PAYMENT_NUMBER": "254M9224", "PAYMENT_NUMBER_DATE": 254, "PAYMENT_NUMBER_NUMBER": 9224, "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": 2014, "RECORD_TYPE": 2, "SE_BUSINESS_DATE": 2014253, "SERVICE_FEE_AMOUNT": "000000{", "SERVICE_FEE_RATE": "00000", "SE_UNIT_NUMBER": "0STR #8061", "SOC_AMOUNT": "0000004319C", "SOC_INVOICE_NUMBER": 253016, "TRACKING_ID": 253013016, "TRACKING_ID_DATE": 253, "TRACKING_ID_PCID": "013016", "TRANSACTION_FEE_AMOUNT": " 000000000000000", "TRANSACTION_FEE_RATE": " 00000000" },
    { "AMEX_GROSS_AMOUNT": "0000063316G", "AMEX_PAYEE_NUMBER": 3129999193, "AMEX_PROCESS_DATE": 2014253, "AMEX_ROC_COUNT": "0000H", "AMEX_ROC_COUNT_POA": "000000H", "AMEX_SE_NUMBER": 3129999193, "BASE_DISCOUNT_AMOUNT": "-000000000017324", "CARD_NOT_PRESENT_BPA_AMOUNT": " 000000000000000", "CARD_NOT_PRESENT_BPA_RATE": " 00000000", "CARD_NOT_PRESENT_PTA_AMOUNT": " 000000000000000", "CARD_NOT_PRESENT_PTA_RATE": " 00000000", "CPC_INDICATOR": "", "DETAIL_RECORD_TYPE": 10, "DISCOUNT_AMOUNT": "00001732D", "DISCOUNT_RATE": "02750", "NET_SOC_AMOUNT": "0000063316G", "PAYMENT_NUMBER": "254M4165", "PAYMENT_NUMBER_DATE": 254, "PAYMENT_NUMBER_NUMBER": 4165, "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": 2014, "RECORD_TYPE": 2, "SE_BUSINESS_DATE": 2014253, "SERVICE_FEE_AMOUNT": "000019{", "SERVICE_FEE_RATE": "00030", "SE_UNIT_NUMBER": "0000000008", "SOC_AMOUNT": "0000063316G", "SOC_INVOICE_NUMBER": 253016, "TRACKING_ID": 253013016, "TRACKING_ID_DATE": 253, "TRACKING_ID_PCID": "013016", "TRANSACTION_FEE_AMOUNT": " 000000000000000", "TRANSACTION_FEE_RATE": " 00000000" },
    { "AMEX_GROSS_AMOUNT": "0000099245A", "AMEX_PAYEE_NUMBER": 3229999977, "AMEX_PROCESS_DATE": 2014253, "AMEX_ROC_COUNT": "0001{", "AMEX_ROC_COUNT_POA": "000001{", "AMEX_SE_NUMBER": 3229999977, "BASE_DISCOUNT_AMOUNT": "-000000000027253", "CARD_NOT_PRESENT_BPA_AMOUNT": " 000000000000000", "CARD_NOT_PRESENT_BPA_RATE": " 00000000", "CARD_NOT_PRESENT_PTA_AMOUNT": " 000000000000000", "CARD_NOT_PRESENT_PTA_RATE": " 00000000", "CPC_INDICATOR": "", "DETAIL_RECORD_TYPE": 10, "DISCOUNT_AMOUNT": "00002725C", "DISCOUNT_RATE": "02750", "NET_SOC_AMOUNT": "0000099245A", "PAYMENT_NUMBER": "254M7990", "PAYMENT_NUMBER_DATE": 254, "PAYMENT_NUMBER_NUMBER": 7990, "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": 2014, "RECORD_TYPE": 2, "SE_BUSINESS_DATE": 2014253, "SERVICE_FEE_AMOUNT": "000029H", "SERVICE_FEE_RATE": "00030", "SE_UNIT_NUMBER": "0000000005", "SOC_AMOUNT": "0000099245A", "SOC_INVOICE_NUMBER": 253016, "TRACKING_ID": 253013016, "TRACKING_ID_DATE": 253, "TRACKING_ID_PCID": "013016", "TRANSACTION_FEE_AMOUNT": " 000000000000000", "TRANSACTION_FEE_RATE": " 00000000" },
    { "AMEX_GROSS_AMOUNT": "0000053256D", "AMEX_PAYEE_NUMBER": 4109999881, "AMEX_PROCESS_DATE": 2014253, "AMEX_ROC_COUNT": "0001C", "AMEX_ROC_COUNT_POA": "000001C", "AMEX_SE_NUMBER": 4109999881, "BASE_DISCOUNT_AMOUNT": "-000000000014470", "CARD_NOT_PRESENT_BPA_AMOUNT": " 000000000000000", "CARD_NOT_PRESENT_BPA_RATE": " 00000000", "CARD_NOT_PRESENT_PTA_AMOUNT": " 000000000000000", "CARD_NOT_PRESENT_PTA_RATE": " 00000000", "CPC_INDICATOR": "", "DETAIL_RECORD_TYPE": 10, "DISCOUNT_AMOUNT": "00001447{", "DISCOUNT_RATE": "02750", "NET_SOC_AMOUNT": "0000053256D", "PAYMENT_NUMBER": "254M5048", "PAYMENT_NUMBER_DATE": 254, "PAYMENT_NUMBER_NUMBER": 5048, "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": 2014, "RECORD_TYPE": 2, "SE_BUSINESS_DATE": 2014253, "SERVICE_FEE_AMOUNT": "000016{", "SERVICE_FEE_RATE": "00030", "SE_UNIT_NUMBER": "0000000014", "SOC_AMOUNT": "0000053256D", "SOC_INVOICE_NUMBER": 253016, "TRACKING_ID": 253013016, "TRACKING_ID_DATE": 253, "TRACKING_ID_PCID": "013016", "TRANSACTION_FEE_AMOUNT": " 000000000000000", "TRANSACTION_FEE_RATE": " 00000000" },
    { "AMEX_GROSS_AMOUNT": "0000000283H", "AMEX_PAYEE_NUMBER": 4109999177, "AMEX_PROCESS_DATE": 2014253, "AMEX_ROC_COUNT": "0000A", "AMEX_ROC_COUNT_POA": "000000A", "AMEX_SE_NUMBER": 4109999177, "BASE_DISCOUNT_AMOUNT": "-000000000000078", "CARD_NOT_PRESENT_BPA_AMOUNT": " 000000000000000", "CARD_NOT_PRESENT_BPA_RATE": " 00000000", "CARD_NOT_PRESENT_PTA_AMOUNT": " 000000000000000", "CARD_NOT_PRESENT_PTA_RATE": " 00000000", "CPC_INDICATOR": "", "DETAIL_RECORD_TYPE": 10, "DISCOUNT_AMOUNT": "00000007H", "DISCOUNT_RATE": "02750", "NET_SOC_AMOUNT": "0000000283H", "PAYMENT_NUMBER": "254M7145", "PAYMENT_NUMBER_DATE": 254, "PAYMENT_NUMBER_NUMBER": 7145, "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": 2014, "RECORD_TYPE": 2, "SE_BUSINESS_DATE": 2014253, "SERVICE_FEE_AMOUNT": "000000{", "SERVICE_FEE_RATE": "00000", "SE_UNIT_NUMBER": "0000000056", "SOC_AMOUNT": "0000000283H", "SOC_INVOICE_NUMBER": 253016, "TRACKING_ID": 253013016, "TRACKING_ID_DATE": 253, "TRACKING_ID_PCID": "013016", "TRANSACTION_FEE_AMOUNT": " 000000000000000", "TRANSACTION_FEE_RATE": " 00000000" },
    { "AMEX_GROSS_AMOUNT": "0000028035G", "AMEX_PAYEE_NUMBER": 4169999182, "AMEX_PROCESS_DATE": 2014253, "AMEX_ROC_COUNT": "0000G", "AMEX_ROC_COUNT_POA": "000000G", "AMEX_SE_NUMBER": 4169999182, "BASE_DISCOUNT_AMOUNT": "-000000000007548", "CARD_NOT_PRESENT_BPA_AMOUNT": " 000000000000000", "CARD_NOT_PRESENT_BPA_RATE": " 00000000", "CARD_NOT_PRESENT_PTA_AMOUNT": " 000000000000000", "CARD_NOT_PRESENT_PTA_RATE": " 00000000", "CPC_INDICATOR": "", "DETAIL_RECORD_TYPE": 10, "DISCOUNT_AMOUNT": "00000754H", "DISCOUNT_RATE": "02750", "NET_SOC_AMOUNT": "0000028035G", "PAYMENT_NUMBER": "254M9582", "PAYMENT_NUMBER_DATE": 254, "PAYMENT_NUMBER_NUMBER": 9582, "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": 2014, "RECORD_TYPE": 2, "SE_BUSINESS_DATE": 2014253, "SERVICE_FEE_AMOUNT": "000000{", "SERVICE_FEE_RATE": "00000", "SE_UNIT_NUMBER": "00STR#8065", "SOC_AMOUNT": "0000028035G", "SOC_INVOICE_NUMBER": 253016, "TRACKING_ID": 253013016, "TRACKING_ID_DATE": 253, "TRACKING_ID_PCID": "013016", "TRANSACTION_FEE_AMOUNT": " 000000000000000", "TRANSACTION_FEE_RATE": " 00000000" },
    { "AMEX_GROSS_AMOUNT": "0000017768A", "AMEX_PAYEE_NUMBER": 4329999734, "AMEX_PROCESS_DATE": 2014253, "AMEX_ROC_COUNT": "0000G", "AMEX_ROC_COUNT_POA": "000000G", "AMEX_SE_NUMBER": 4329999734, "BASE_DISCOUNT_AMOUNT": "-000000000004886", "CARD_NOT_PRESENT_BPA_AMOUNT": " 000000000000000", "CARD_NOT_PRESENT_BPA_RATE": " 00000000", "CARD_NOT_PRESENT_PTA_AMOUNT": " 000000000000000", "CARD_NOT_PRESENT_PTA_RATE": " 00000000", "CPC_INDICATOR": "", "DETAIL_RECORD_TYPE": 10, "DISCOUNT_AMOUNT": "00000488F", "DISCOUNT_RATE": "02750", "NET_SOC_AMOUNT": "0000017279E", "PAYMENT_NUMBER": "254D6481", "PAYMENT_NUMBER_DATE": 254, "PAYMENT_NUMBER_NUMBER": 6481, "PAYMENT_NUMBER_TYPE": "D", "PAYMENT_YEAR": 2014, "RECORD_TYPE": 2, "SE_BUSINESS_DATE": 2014253, "SERVICE_FEE_AMOUNT": "000000{", "SERVICE_FEE_RATE": "00000", "SE_UNIT_NUMBER": "0000STR#65", "SOC_AMOUNT": "0000017768A", "SOC_INVOICE_NUMBER": 253016, "TRACKING_ID": 253013016, "TRACKING_ID_DATE": 253, "TRACKING_ID_PCID": "013016", "TRANSACTION_FEE_AMOUNT": " 000000000000000", "TRANSACTION_FEE_RATE": " 00000000" },
    { "AMEX_GROSS_AMOUNT": "0000003266F", "AMEX_PAYEE_NUMBER": 4419999772, "AMEX_PROCESS_DATE": 2014253, "AMEX_ROC_COUNT": "0000B", "AMEX_ROC_COUNT_POA": "000000B", "AMEX_SE_NUMBER": 4419999772, "BASE_DISCOUNT_AMOUNT": "-000000000000819", "CARD_NOT_PRESENT_BPA_AMOUNT": " 000000000000000", "CARD_NOT_PRESENT_BPA_RATE": " 00000000", "CARD_NOT_PRESENT_PTA_AMOUNT": " 000000000000000", "CARD_NOT_PRESENT_PTA_RATE": " 00000000", "CPC_INDICATOR": "", "DETAIL_RECORD_TYPE": 10, "DISCOUNT_AMOUNT": "00000081I", "DISCOUNT_RATE": "02750", "NET_SOC_AMOUNT": "0000003266F", "PAYMENT_NUMBER": "254M2689", "PAYMENT_NUMBER_DATE": 254, "PAYMENT_NUMBER_NUMBER": 2689, "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": 2014, "RECORD_TYPE": 2, "SE_BUSINESS_DATE": 2014253, "SERVICE_FEE_AMOUNT": "000000{", "SERVICE_FEE_RATE": "00000", "SE_UNIT_NUMBER": "00Str#8064", "SOC_AMOUNT": "0000003266F", "SOC_INVOICE_NUMBER": 253016, "TRACKING_ID": 253013016, "TRACKING_ID_DATE": 253, "TRACKING_ID_PCID": "013016", "TRANSACTION_FEE_AMOUNT": " 000000000000000", "TRANSACTION_FEE_RATE": " 00000000" },
    { "AMEX_GROSS_AMOUNT": "0000030378E", "AMEX_PAYEE_NUMBER": 4459999588, "AMEX_PROCESS_DATE": 2014253, "AMEX_ROC_COUNT": "0001A", "AMEX_ROC_COUNT_POA": "000001A", "AMEX_SE_NUMBER": 4459999588, "BASE_DISCOUNT_AMOUNT": "-000000000008354", "CARD_NOT_PRESENT_BPA_AMOUNT": " 000000000000000", "CARD_NOT_PRESENT_BPA_RATE": " 00000000", "CARD_NOT_PRESENT_PTA_AMOUNT": " 000000000000000", "CARD_NOT_PRESENT_PTA_RATE": " 00000000", "CPC_INDICATOR": "", "DETAIL_RECORD_TYPE": 10, "DISCOUNT_AMOUNT": "00000835D", "DISCOUNT_RATE": "02750", "NET_SOC_AMOUNT": "0000030378E", "PAYMENT_NUMBER": "254M6699", "PAYMENT_NUMBER_DATE": 254, "PAYMENT_NUMBER_NUMBER": 6699, "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": 2014, "RECORD_TYPE": 2, "SE_BUSINESS_DATE": 2014253, "SERVICE_FEE_AMOUNT": "000009A", "SERVICE_FEE_RATE": "00030", "SE_UNIT_NUMBER": "0000000010", "SOC_AMOUNT": "0000030378E", "SOC_INVOICE_NUMBER": 253016, "TRACKING_ID": 253013016, "TRACKING_ID_DATE": 253, "TRACKING_ID_PCID": "013016", "TRANSACTION_FEE_AMOUNT": " 000000000000000", "TRANSACTION_FEE_RATE": " 00000000" },
    { "AMEX_GROSS_AMOUNT": "0000085830E", "AMEX_PAYEE_NUMBER": 5029999057, "AMEX_PROCESS_DATE": 2014253, "AMEX_ROC_COUNT": "0000F", "AMEX_ROC_COUNT_POA": "000000F", "AMEX_SE_NUMBER": 5029999057, "BASE_DISCOUNT_AMOUNT": "-000000000023603", "CARD_NOT_PRESENT_BPA_AMOUNT": " 000000000000000", "CARD_NOT_PRESENT_BPA_RATE": " 00000000", "CARD_NOT_PRESENT_PTA_AMOUNT": " 000000000000000", "CARD_NOT_PRESENT_PTA_RATE": " 00000000", "CPC_INDICATOR": "", "DETAIL_RECORD_TYPE": 10, "DISCOUNT_AMOUNT": "00002360C", "DISCOUNT_RATE": "02750", "NET_SOC_AMOUNT": "0000085830E", "PAYMENT_NUMBER": "254M8033", "PAYMENT_NUMBER_DATE": 254, "PAYMENT_NUMBER_NUMBER": 8033, "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": 2014, "RECORD_TYPE": 2, "SE_BUSINESS_DATE": 2014253, "SERVICE_FEE_AMOUNT": "000025G", "SERVICE_FEE_RATE": "00030", "SE_UNIT_NUMBER": "0000000001", "SOC_AMOUNT": "0000085830E", "SOC_INVOICE_NUMBER": 253016, "TRACKING_ID": 253013016, "TRACKING_ID_DATE": 253, "TRACKING_ID_PCID": "013016", "TRANSACTION_FEE_AMOUNT": " 000000000000000", "TRANSACTION_FEE_RATE": " 00000000" },
    { "AMEX_GROSS_AMOUNT": "0000013295D", "AMEX_PAYEE_NUMBER": 5029999289, "AMEX_PROCESS_DATE": 2014253, "AMEX_ROC_COUNT": "0000C", "AMEX_ROC_COUNT_POA": "000000C", "AMEX_SE_NUMBER": 5029999289, "BASE_DISCOUNT_AMOUNT": "-000000000003656", "CARD_NOT_PRESENT_BPA_AMOUNT": " 000000000000000", "CARD_NOT_PRESENT_BPA_RATE": " 00000000", "CARD_NOT_PRESENT_PTA_AMOUNT": " 000000000000000", "CARD_NOT_PRESENT_PTA_RATE": " 00000000", "CPC_INDICATOR": "", "DETAIL_RECORD_TYPE": 10, "DISCOUNT_AMOUNT": "00000365F", "DISCOUNT_RATE": "02750", "NET_SOC_AMOUNT": "0000013295D", "PAYMENT_NUMBER": "254M0295", "PAYMENT_NUMBER_DATE": 254, "PAYMENT_NUMBER_NUMBER": "0295", "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": 2014, "RECORD_TYPE": 2, "SE_BUSINESS_DATE": 2014253, "SERVICE_FEE_AMOUNT": "000000{", "SERVICE_FEE_RATE": "00000", "SE_UNIT_NUMBER": "00STR#8069", "SOC_AMOUNT": "0000013295D", "SOC_INVOICE_NUMBER": 253016, "TRACKING_ID": 253013016, "TRACKING_ID_DATE": 253, "TRACKING_ID_PCID": "013016", "TRANSACTION_FEE_AMOUNT": " 000000000000000", "TRANSACTION_FEE_RATE": " 00000000" },
    { "AMEX_GROSS_AMOUNT": "0000000990{", "AMEX_PAYEE_NUMBER": 5279999046, "AMEX_PROCESS_DATE": 2014253, "AMEX_ROC_COUNT": "0000A", "AMEX_ROC_COUNT_POA": "000000A", "AMEX_SE_NUMBER": 5279999046, "BASE_DISCOUNT_AMOUNT": "-000000000000233", "CARD_NOT_PRESENT_BPA_AMOUNT": " 000000000000000", "CARD_NOT_PRESENT_BPA_RATE": " 00000000", "CARD_NOT_PRESENT_PTA_AMOUNT": " 000000000000000", "CARD_NOT_PRESENT_PTA_RATE": " 00000000", "CPC_INDICATOR": "", "DETAIL_RECORD_TYPE": 10, "DISCOUNT_AMOUNT": "00000023C", "DISCOUNT_RATE": "02350", "NET_SOC_AMOUNT": "0000000966G", "PAYMENT_NUMBER": "254S6115", "PAYMENT_NUMBER_DATE": 254, "PAYMENT_NUMBER_NUMBER": 6115, "PAYMENT_NUMBER_TYPE": "S", "PAYMENT_YEAR": 2014, "RECORD_TYPE": 2, "SE_BUSINESS_DATE": 2014253, "SERVICE_FEE_AMOUNT": "000000{", "SERVICE_FEE_RATE": "00000", "SE_UNIT_NUMBER": "", "SOC_AMOUNT": "0000000990{", "SOC_INVOICE_NUMBER": 253034, "TRACKING_ID": 253013034, "TRACKING_ID_DATE": 253, "TRACKING_ID_PCID": "013034", "TRANSACTION_FEE_AMOUNT": " 000000000000000", "TRANSACTION_FEE_RATE": " 00000000" },
    { "AMEX_GROSS_AMOUNT": "0000000104I", "AMEX_PAYEE_NUMBER": 5279999579, "AMEX_PROCESS_DATE": 2014253, "AMEX_ROC_COUNT": "0000A", "AMEX_ROC_COUNT_POA": "000000A", "AMEX_SE_NUMBER": 5279999579, "BASE_DISCOUNT_AMOUNT": "-000000000000029", "CARD_NOT_PRESENT_BPA_AMOUNT": " 000000000000000", "CARD_NOT_PRESENT_BPA_RATE": " 00000000", "CARD_NOT_PRESENT_PTA_AMOUNT": " 000000000000000", "CARD_NOT_PRESENT_PTA_RATE": " 00000000", "CPC_INDICATOR": "", "DETAIL_RECORD_TYPE": 10, "DISCOUNT_AMOUNT": "00000002I", "DISCOUNT_RATE": "02750", "NET_SOC_AMOUNT": "0000000102{", "PAYMENT_NUMBER": "254S2139", "PAYMENT_NUMBER_DATE": 254, "PAYMENT_NUMBER_NUMBER": 2139, "PAYMENT_NUMBER_TYPE": "S", "PAYMENT_YEAR": 2014, "RECORD_TYPE": 2, "SE_BUSINESS_DATE": 2014253, "SERVICE_FEE_AMOUNT": "000000{", "SERVICE_FEE_RATE": "00000", "SE_UNIT_NUMBER": "", "SOC_AMOUNT": "0000000104I", "SOC_INVOICE_NUMBER": 253016, "TRACKING_ID": 253013016, "TRACKING_ID_DATE": 253, "TRACKING_ID_PCID": "013016", "TRANSACTION_FEE_AMOUNT": " 000000000000000", "TRANSACTION_FEE_RATE": " 00000000" },
    { "AMEX_GROSS_AMOUNT": "0000000079I", "AMEX_PAYEE_NUMBER": 5279999579, "AMEX_PROCESS_DATE": 2014253, "AMEX_ROC_COUNT": "0000A", "AMEX_ROC_COUNT_POA": "000000A", "AMEX_SE_NUMBER": 5279999579, "BASE_DISCOUNT_AMOUNT": "-000000000000022", "CARD_NOT_PRESENT_BPA_AMOUNT": " 000000000000000", "CARD_NOT_PRESENT_BPA_RATE": " 00000000", "CARD_NOT_PRESENT_PTA_AMOUNT": " 000000000000000", "CARD_NOT_PRESENT_PTA_RATE": " 00000000", "CPC_INDICATOR": "", "DETAIL_RECORD_TYPE": 10, "DISCOUNT_AMOUNT": "00000002B", "DISCOUNT_RATE": "02750", "NET_SOC_AMOUNT": "0000000077G", "PAYMENT_NUMBER": "254S2139", "PAYMENT_NUMBER_DATE": 254, "PAYMENT_NUMBER_NUMBER": 2139, "PAYMENT_NUMBER_TYPE": "S", "PAYMENT_YEAR": 2014, "RECORD_TYPE": 2, "SE_BUSINESS_DATE": 2014253, "SERVICE_FEE_AMOUNT": "000000{", "SERVICE_FEE_RATE": "00000", "SE_UNIT_NUMBER": "", "SOC_AMOUNT": "0000000079I", "SOC_INVOICE_NUMBER": 253016, "TRACKING_ID": 253013016, "TRACKING_ID_DATE": 253, "TRACKING_ID_PCID": "013016", "TRANSACTION_FEE_AMOUNT": " 000000000000000", "TRANSACTION_FEE_RATE": " 00000000" },
    { "AMEX_GROSS_AMOUNT": "0000000351F", "AMEX_PAYEE_NUMBER": 5279999579, "AMEX_PROCESS_DATE": 2014253, "AMEX_ROC_COUNT": "0001B", "AMEX_ROC_COUNT_POA": "000001B", "AMEX_SE_NUMBER": 5279999579, "BASE_DISCOUNT_AMOUNT": "-000000000000095", "CARD_NOT_PRESENT_BPA_AMOUNT": " 000000000000000", "CARD_NOT_PRESENT_BPA_RATE": " 00000000", "CARD_NOT_PRESENT_PTA_AMOUNT": " 000000000000000", "CARD_NOT_PRESENT_PTA_RATE": " 00000000", "CPC_INDICATOR": "", "DETAIL_RECORD_TYPE": 10, "DISCOUNT_AMOUNT": "00000009E", "DISCOUNT_RATE": "02750", "NET_SOC_AMOUNT": "0000000342A", "PAYMENT_NUMBER": "254S2139", "PAYMENT_NUMBER_DATE": 254, "PAYMENT_NUMBER_NUMBER": 2139, "PAYMENT_NUMBER_TYPE": "S", "PAYMENT_YEAR": 2014, "RECORD_TYPE": 2, "SE_BUSINESS_DATE": 2014253, "SERVICE_FEE_AMOUNT": "000000{", "SERVICE_FEE_RATE": "00000", "SE_UNIT_NUMBER": "", "SOC_AMOUNT": "0000000351F", "SOC_INVOICE_NUMBER": 253016, "TRACKING_ID": 253013016, "TRACKING_ID_DATE": 253, "TRACKING_ID_PCID": "013016", "TRANSACTION_FEE_AMOUNT": " 000000000000000", "TRANSACTION_FEE_RATE": " 00000000" },
    { "AMEX_GROSS_AMOUNT": "0000000042I", "AMEX_PAYEE_NUMBER": 5279999579, "AMEX_PROCESS_DATE": 2014253, "AMEX_ROC_COUNT": "0000A", "AMEX_ROC_COUNT_POA": "000000A", "AMEX_SE_NUMBER": 5279999579, "BASE_DISCOUNT_AMOUNT": "-000000000000012", "CARD_NOT_PRESENT_BPA_AMOUNT": " 000000000000000", "CARD_NOT_PRESENT_BPA_RATE": " 00000000", "CARD_NOT_PRESENT_PTA_AMOUNT": " 000000000000000", "CARD_NOT_PRESENT_PTA_RATE": " 00000000", "CPC_INDICATOR": "", "DETAIL_RECORD_TYPE": 10, "DISCOUNT_AMOUNT": "00000001B", "DISCOUNT_RATE": "02750", "NET_SOC_AMOUNT": "0000000041G", "PAYMENT_NUMBER": "254S2139", "PAYMENT_NUMBER_DATE": 254, "PAYMENT_NUMBER_NUMBER": 2139, "PAYMENT_NUMBER_TYPE": "S", "PAYMENT_YEAR": 2014, "RECORD_TYPE": 2, "SE_BUSINESS_DATE": 2014253, "SERVICE_FEE_AMOUNT": "000000{", "SERVICE_FEE_RATE": "00000", "SE_UNIT_NUMBER": "", "SOC_AMOUNT": "0000000042I", "SOC_INVOICE_NUMBER": 253016, "TRACKING_ID": 253013016, "TRACKING_ID_DATE": 253, "TRACKING_ID_PCID": "013016", "TRANSACTION_FEE_AMOUNT": " 000000000000000", "TRANSACTION_FEE_RATE": " 00000000" },
    { "AMEX_GROSS_AMOUNT": "0000000096B", "AMEX_PAYEE_NUMBER": 5279999579, "AMEX_PROCESS_DATE": 2014253, "AMEX_ROC_COUNT": "0000C", "AMEX_ROC_COUNT_POA": "000000C", "AMEX_SE_NUMBER": 5279999579, "BASE_DISCOUNT_AMOUNT": "-000000000000026", "CARD_NOT_PRESENT_BPA_AMOUNT": " 000000000000000", "CARD_NOT_PRESENT_BPA_RATE": " 00000000", "CARD_NOT_PRESENT_PTA_AMOUNT": " 000000000000000", "CARD_NOT_PRESENT_PTA_RATE": " 00000000", "CPC_INDICATOR": "", "DETAIL_RECORD_TYPE": 10, "DISCOUNT_AMOUNT": "00000002F", "DISCOUNT_RATE": "02750", "NET_SOC_AMOUNT": "0000000093F", "PAYMENT_NUMBER": "254S2139", "PAYMENT_NUMBER_DATE": 254, "PAYMENT_NUMBER_NUMBER": 2139, "PAYMENT_NUMBER_TYPE": "S", "PAYMENT_YEAR": 2014, "RECORD_TYPE": 2, "SE_BUSINESS_DATE": 2014253, "SERVICE_FEE_AMOUNT": "000000{", "SERVICE_FEE_RATE": "00000", "SE_UNIT_NUMBER": "", "SOC_AMOUNT": "0000000096B", "SOC_INVOICE_NUMBER": 253016, "TRACKING_ID": 253013016, "TRACKING_ID_DATE": 253, "TRACKING_ID_PCID": "013016", "TRANSACTION_FEE_AMOUNT": " 000000000000000", "TRANSACTION_FEE_RATE": " 00000000" },
    { "AMEX_GROSS_AMOUNT": "0000000199H", "AMEX_PAYEE_NUMBER": 5279999579, "AMEX_PROCESS_DATE": 2014253, "AMEX_ROC_COUNT": "0000B", "AMEX_ROC_COUNT_POA": "000000B", "AMEX_SE_NUMBER": 5279999579, "BASE_DISCOUNT_AMOUNT": "-000000000000055", "CARD_NOT_PRESENT_BPA_AMOUNT": " 000000000000000", "CARD_NOT_PRESENT_BPA_RATE": " 00000000", "CARD_NOT_PRESENT_PTA_AMOUNT": " 000000000000000", "CARD_NOT_PRESENT_PTA_RATE": " 00000000", "CPC_INDICATOR": "", "DETAIL_RECORD_TYPE": 10, "DISCOUNT_AMOUNT": "00000005E", "DISCOUNT_RATE": "02750", "NET_SOC_AMOUNT": "0000000194C", "PAYMENT_NUMBER": "254S2139", "PAYMENT_NUMBER_DATE": 254, "PAYMENT_NUMBER_NUMBER": 2139, "PAYMENT_NUMBER_TYPE": "S", "PAYMENT_YEAR": 2014, "RECORD_TYPE": 2, "SE_BUSINESS_DATE": 2014253, "SERVICE_FEE_AMOUNT": "000000{", "SERVICE_FEE_RATE": "00000", "SE_UNIT_NUMBER": "", "SOC_AMOUNT": "0000000199H", "SOC_INVOICE_NUMBER": 253016, "TRACKING_ID": 253013016, "TRACKING_ID_DATE": 253, "TRACKING_ID_PCID": "013016", "TRANSACTION_FEE_AMOUNT": " 000000000000000", "TRANSACTION_FEE_RATE": " 00000000" },
    { "AMEX_GROSS_AMOUNT": "0000000044I", "AMEX_PAYEE_NUMBER": 5279999579, "AMEX_PROCESS_DATE": 2014253, "AMEX_ROC_COUNT": "0000A", "AMEX_ROC_COUNT_POA": "000000A", "AMEX_SE_NUMBER": 5279999579, "BASE_DISCOUNT_AMOUNT": "-000000000000012", "CARD_NOT_PRESENT_BPA_AMOUNT": " 000000000000000", "CARD_NOT_PRESENT_BPA_RATE": " 00000000", "CARD_NOT_PRESENT_PTA_AMOUNT": " 000000000000000", "CARD_NOT_PRESENT_PTA_RATE": " 00000000", "CPC_INDICATOR": "", "DETAIL_RECORD_TYPE": 10, "DISCOUNT_AMOUNT": "00000001B", "DISCOUNT_RATE": "02750", "NET_SOC_AMOUNT": "0000000043G", "PAYMENT_NUMBER": "254S2139", "PAYMENT_NUMBER_DATE": 254, "PAYMENT_NUMBER_NUMBER": 2139, "PAYMENT_NUMBER_TYPE": "S", "PAYMENT_YEAR": 2014, "RECORD_TYPE": 2, "SE_BUSINESS_DATE": 2014253, "SERVICE_FEE_AMOUNT": "000000{", "SERVICE_FEE_RATE": "00000", "SE_UNIT_NUMBER": "", "SOC_AMOUNT": "0000000044I", "SOC_INVOICE_NUMBER": 253016, "TRACKING_ID": 253013016, "TRACKING_ID_DATE": 253, "TRACKING_ID_PCID": "013016", "TRANSACTION_FEE_AMOUNT": " 000000000000000", "TRANSACTION_FEE_RATE": " 00000000" },
    { "AMEX_GROSS_AMOUNT": "0000000179H", "AMEX_PAYEE_NUMBER": 5279999579, "AMEX_PROCESS_DATE": 2014253, "AMEX_ROC_COUNT": "0000B", "AMEX_ROC_COUNT_POA": "000000B", "AMEX_SE_NUMBER": 5279999579, "BASE_DISCOUNT_AMOUNT": "-000000000000049", "CARD_NOT_PRESENT_BPA_AMOUNT": " 000000000000000", "CARD_NOT_PRESENT_BPA_RATE": " 00000000", "CARD_NOT_PRESENT_PTA_AMOUNT": " 000000000000000", "CARD_NOT_PRESENT_PTA_RATE": " 00000000", "CPC_INDICATOR": "", "DETAIL_RECORD_TYPE": 10, "DISCOUNT_AMOUNT": "00000004I", "DISCOUNT_RATE": "02750", "NET_SOC_AMOUNT": "0000000174I", "PAYMENT_NUMBER": "254S2139", "PAYMENT_NUMBER_DATE": 254, "PAYMENT_NUMBER_NUMBER": 2139, "PAYMENT_NUMBER_TYPE": "S", "PAYMENT_YEAR": 2014, "RECORD_TYPE": 2, "SE_BUSINESS_DATE": 2014253, "SERVICE_FEE_AMOUNT": "000000{", "SERVICE_FEE_RATE": "00000", "SE_UNIT_NUMBER": "", "SOC_AMOUNT": "0000000179H", "SOC_INVOICE_NUMBER": 253016, "TRACKING_ID": 253013016, "TRACKING_ID_DATE": 253, "TRACKING_ID_PCID": "013016", "TRANSACTION_FEE_AMOUNT": " 000000000000000", "TRANSACTION_FEE_RATE": " 00000000" },
    { "AMEX_GROSS_AMOUNT": "0000000259H", "AMEX_PAYEE_NUMBER": 5279999579, "AMEX_PROCESS_DATE": 2014253, "AMEX_ROC_COUNT": "0000B", "AMEX_ROC_COUNT_POA": "000000B", "AMEX_SE_NUMBER": 5279999579, "BASE_DISCOUNT_AMOUNT": "-000000000000071", "CARD_NOT_PRESENT_BPA_AMOUNT": " 000000000000000", "CARD_NOT_PRESENT_BPA_RATE": " 00000000", "CARD_NOT_PRESENT_PTA_AMOUNT": " 000000000000000", "CARD_NOT_PRESENT_PTA_RATE": " 00000000", "CPC_INDICATOR": "", "DETAIL_RECORD_TYPE": 10, "DISCOUNT_AMOUNT": "00000007A", "DISCOUNT_RATE": "02750", "NET_SOC_AMOUNT": "0000000252G", "PAYMENT_NUMBER": "254S2139", "PAYMENT_NUMBER_DATE": 254, "PAYMENT_NUMBER_NUMBER": 2139, "PAYMENT_NUMBER_TYPE": "S", "PAYMENT_YEAR": 2014, "RECORD_TYPE": 2, "SE_BUSINESS_DATE": 2014253, "SERVICE_FEE_AMOUNT": "000000{", "SERVICE_FEE_RATE": "00000", "SE_UNIT_NUMBER": "", "SOC_AMOUNT": "0000000259H", "SOC_INVOICE_NUMBER": 253016, "TRACKING_ID": 253013016, "TRACKING_ID_DATE": 253, "TRACKING_ID_PCID": "013016", "TRANSACTION_FEE_AMOUNT": " 000000000000000", "TRANSACTION_FEE_RATE": " 00000000" },
    { "AMEX_GROSS_AMOUNT": "0000133112D", "AMEX_PAYEE_NUMBER": 5439999059, "AMEX_PROCESS_DATE": 2014253, "AMEX_ROC_COUNT": "0000D", "AMEX_ROC_COUNT_POA": "000000D", "AMEX_SE_NUMBER": 5439999059, "BASE_DISCOUNT_AMOUNT": "-000000000031281", "CARD_NOT_PRESENT_BPA_AMOUNT": " 000000000000000", "CARD_NOT_PRESENT_BPA_RATE": " 00000000", "CARD_NOT_PRESENT_PTA_AMOUNT": " 000000000000000", "CARD_NOT_PRESENT_PTA_RATE": " 00000000", "CPC_INDICATOR": "", "DETAIL_RECORD_TYPE": 10, "DISCOUNT_AMOUNT": "00003128A", "DISCOUNT_RATE": "02350", "NET_SOC_AMOUNT": "0000129984C", "PAYMENT_NUMBER": "254D8477", "PAYMENT_NUMBER_DATE": 254, "PAYMENT_NUMBER_NUMBER": 8477, "PAYMENT_NUMBER_TYPE": "D", "PAYMENT_YEAR": 2014, "RECORD_TYPE": 2, "SE_BUSINESS_DATE": 2014253, "SERVICE_FEE_AMOUNT": "000000{", "SERVICE_FEE_RATE": "00000", "SE_UNIT_NUMBER": "", "SOC_AMOUNT": "0000133112D", "SOC_INVOICE_NUMBER": 907286, "TRACKING_ID": 253098583, "TRACKING_ID_DATE": 253, "TRACKING_ID_PCID": "098583", "TRANSACTION_FEE_AMOUNT": " 000000000000000", "TRANSACTION_FEE_RATE": " 00000000" },
    { "AMEX_GROSS_AMOUNT": "0000039503E", "AMEX_PAYEE_NUMBER": 5469999720, "AMEX_PROCESS_DATE": 2014253, "AMEX_ROC_COUNT": "0000C", "AMEX_ROC_COUNT_POA": "000000C", "AMEX_SE_NUMBER": 5469999720, "BASE_DISCOUNT_AMOUNT": "-000000000009283", "CARD_NOT_PRESENT_BPA_AMOUNT": " 000000000000000", "CARD_NOT_PRESENT_BPA_RATE": " 00000000", "CARD_NOT_PRESENT_PTA_AMOUNT": " 000000000000000", "CARD_NOT_PRESENT_PTA_RATE": " 00000000", "CPC_INDICATOR": "", "DETAIL_RECORD_TYPE": 10, "DISCOUNT_AMOUNT": "00000928C", "DISCOUNT_RATE": "02350", "NET_SOC_AMOUNT": "0000038575B", "PAYMENT_NUMBER": "254A1705", "PAYMENT_NUMBER_DATE": 254, "PAYMENT_NUMBER_NUMBER": 1705, "PAYMENT_NUMBER_TYPE": "A", "PAYMENT_YEAR": 2014, "RECORD_TYPE": 2, "SE_BUSINESS_DATE": 2014253, "SERVICE_FEE_AMOUNT": "000000{", "SERVICE_FEE_RATE": "00000", "SE_UNIT_NUMBER": "EVENTS", "SOC_AMOUNT": "0000039503E", "SOC_INVOICE_NUMBER": 253034, "TRACKING_ID": 253013034, "TRACKING_ID_DATE": 253, "TRACKING_ID_PCID": "013034", "TRANSACTION_FEE_AMOUNT": " 000000000000000", "TRANSACTION_FEE_RATE": " 00000000" },
    { "AMEX_GROSS_AMOUNT": "0000009616C", "AMEX_PAYEE_NUMBER": 5469999267, "AMEX_PROCESS_DATE": 2014253, "AMEX_ROC_COUNT": "0002{", "AMEX_ROC_COUNT_POA": "000002{", "AMEX_SE_NUMBER": 5469999267, "BASE_DISCOUNT_AMOUNT": "-000000000002644", "CARD_NOT_PRESENT_BPA_AMOUNT": " 000000000000000", "CARD_NOT_PRESENT_BPA_RATE": " 00000000", "CARD_NOT_PRESENT_PTA_AMOUNT": " 000000000000000", "CARD_NOT_PRESENT_PTA_RATE": " 00000000", "CPC_INDICATOR": "", "DETAIL_RECORD_TYPE": 10, "DISCOUNT_AMOUNT": "00000264D", "DISCOUNT_RATE": "02750", "NET_SOC_AMOUNT": "0000009351I", "PAYMENT_NUMBER": "254T9183", "PAYMENT_NUMBER_DATE": 254, "PAYMENT_NUMBER_NUMBER": 9183, "PAYMENT_NUMBER_TYPE": "T", "PAYMENT_YEAR": 2014, "RECORD_TYPE": 2, "SE_BUSINESS_DATE": 2014253, "SERVICE_FEE_AMOUNT": "000000{", "SERVICE_FEE_RATE": "00000", "SE_UNIT_NUMBER": "", "SOC_AMOUNT": "0000009616C", "SOC_INVOICE_NUMBER": 321487, "TRACKING_ID": 253106544, "TRACKING_ID_DATE": 253, "TRACKING_ID_PCID": 106544, "TRANSACTION_FEE_AMOUNT": " 000000000000000", "TRANSACTION_FEE_RATE": " 00000000" }
  ],
  "SOC_PRICING": [
    { "AMEX_PAYEE_NUMBER": 1049999176, "AMEX_SE_NUMBER": 1049999176, "DETAIL_RECORD_TYPE": 12, "DISCOUNT_AMOUNT": " 00000000000000", "DISCOUNT_RATE": " 00000000", "FEE_AMOUNT": "+00000000000158", "FEE_CODE": "PG", "FEE_DESCRIPTION": "2PGPIG SERVICE FEE", "FEE_RATE": "+00000030", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254F8666", "PAYMENT_NUMBER_DATE": 254, "PAYMENT_NUMBER_NUMBER": 8666, "PAYMENT_NUMBER_TYPE": "F", "PAYMENT_YEAR": 2014, "RECORD_TYPE": 2, "SE_UNIT_NUMBER": "0000000002" },
    { "AMEX_PAYEE_NUMBER": 1049999084, "AMEX_SE_NUMBER": 1049999084, "DETAIL_RECORD_TYPE": 12, "DISCOUNT_AMOUNT": " 00000000000000", "DISCOUNT_RATE": " 00000000", "FEE_AMOUNT": "+00000000000112", "FEE_CODE": "PG", "FEE_DESCRIPTION": "2PGPIG SERVICE FEE", "FEE_RATE": "+00000030", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254H1728", "PAYMENT_NUMBER_DATE": 254, "PAYMENT_NUMBER_NUMBER": 1728, "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": 2014, "RECORD_TYPE": 2, "SE_UNIT_NUMBER": "0SAN DIEGO" },
    { "AMEX_PAYEE_NUMBER": 1049999700, "AMEX_SE_NUMBER": 1049999700, "DETAIL_RECORD_TYPE": 12, "DISCOUNT_AMOUNT": " 00000000000000", "DISCOUNT_RATE": " 00000000", "FEE_AMOUNT": "+00000000000134", "FEE_CODE": "PG", "FEE_DESCRIPTION": "2PGPIG SERVICE FEE", "FEE_RATE": "+00000030", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254H3242", "PAYMENT_NUMBER_DATE": 254, "PAYMENT_NUMBER_NUMBER": 3242, "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": 2014, "RECORD_TYPE": 2, "SE_UNIT_NUMBER": "0000000007" },
    { "AMEX_PAYEE_NUMBER": 1049999728, "AMEX_SE_NUMBER": 1049999728, "DETAIL_RECORD_TYPE": 12, "DISCOUNT_AMOUNT": " 00000000000000", "DISCOUNT_RATE": " 00000000", "FEE_AMOUNT": "+00000000000427", "FEE_CODE": "PG", "FEE_DESCRIPTION": "2PGPIG SERVICE FEE", "FEE_RATE": "+00000030", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254H3651", "PAYMENT_NUMBER_DATE": 254, "PAYMENT_NUMBER_NUMBER": 3651, "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": 2014, "RECORD_TYPE": 2, "SE_UNIT_NUMBER": "0000000009" },
    { "AMEX_PAYEE_NUMBER": 1049999121, "AMEX_SE_NUMBER": 1049999121, "DETAIL_RECORD_TYPE": 12, "DISCOUNT_AMOUNT": " 00000000000000", "DISCOUNT_RATE": " 00000000", "FEE_AMOUNT": "+00000000000192", "FEE_CODE": "PG", "FEE_DESCRIPTION": "2PGPIG SERVICE FEE", "FEE_RATE": "+00000030", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254H4390", "PAYMENT_NUMBER_DATE": 254, "PAYMENT_NUMBER_NUMBER": 4390, "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": 2014, "RECORD_TYPE": 2, "SE_UNIT_NUMBER": "0000000015" },
    { "AMEX_PAYEE_NUMBER": 1049999246, "AMEX_SE_NUMBER": 1049999246, "DETAIL_RECORD_TYPE": 12, "DISCOUNT_AMOUNT": " 00000000000000", "DISCOUNT_RATE": " 00000000", "FEE_AMOUNT": "+00000000000099", "FEE_CODE": "PG", "FEE_DESCRIPTION": "2PGPIG SERVICE FEE", "FEE_RATE": "+00000030", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254H5067", "PAYMENT_NUMBER_DATE": 254, "PAYMENT_NUMBER_NUMBER": 5067, "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": 2014, "RECORD_TYPE": 2, "SE_UNIT_NUMBER": "0000000017" },
    { "AMEX_PAYEE_NUMBER": 1059999079, "AMEX_SE_NUMBER": 1059999079, "DETAIL_RECORD_TYPE": 12, "DISCOUNT_AMOUNT": " 00000000000000", "DISCOUNT_RATE": " 00000000", "FEE_AMOUNT": "+00000000000088", "FEE_CODE": "PG", "FEE_DESCRIPTION": "2PGPIG SERVICE FEE", "FEE_RATE": "+00000030", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254H9133", "PAYMENT_NUMBER_DATE": 254, "PAYMENT_NUMBER_NUMBER": 9133, "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": 2014, "RECORD_TYPE": 2, "SE_UNIT_NUMBER": "PARK MEADO" },
    { "AMEX_PAYEE_NUMBER": 1159999126, "AMEX_SE_NUMBER": 1159999126, "DETAIL_RECORD_TYPE": 12, "DISCOUNT_AMOUNT": " 00000000000000", "DISCOUNT_RATE": " 00000000", "FEE_AMOUNT": "+00000000000054", "FEE_CODE": "PG", "FEE_DESCRIPTION": "2PGPIG SERVICE FEE", "FEE_RATE": "+00000030", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254J2806", "PAYMENT_NUMBER_DATE": 254, "PAYMENT_NUMBER_NUMBER": 2806, "PAYMENT_NUMBER_TYPE": "J", "PAYMENT_YEAR": 2014, "RECORD_TYPE": 2, "SE_UNIT_NUMBER": "000STR #25" },
    { "AMEX_PAYEE_NUMBER": 2069999156, "AMEX_SE_NUMBER": 2069999156, "DETAIL_RECORD_TYPE": 12, "DISCOUNT_AMOUNT": " 00000000000000", "DISCOUNT_RATE": " 00000000", "FEE_AMOUNT": "+00000000000030", "FEE_CODE": "PG", "FEE_DESCRIPTION": "2PGPIG SERVICE FEE", "FEE_RATE": "+00000030", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254G5069", "PAYMENT_NUMBER_DATE": 254, "PAYMENT_NUMBER_NUMBER": 5069, "PAYMENT_NUMBER_TYPE": "G", "PAYMENT_YEAR": 2014, "RECORD_TYPE": 2, "SE_UNIT_NUMBER": "000STR #18" },
    { "AMEX_PAYEE_NUMBER": 2299999656, "AMEX_SE_NUMBER": 2299999656, "DETAIL_RECORD_TYPE": 12, "DISCOUNT_AMOUNT": " 00000000000000", "DISCOUNT_RATE": " 00000000", "FEE_AMOUNT": "+00000000000058", "FEE_CODE": "PG", "FEE_DESCRIPTION": "2PGPIG SERVICE FEE", "FEE_RATE": "+00000030", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254L1705", "PAYMENT_NUMBER_DATE": 254, "PAYMENT_NUMBER_NUMBER": 1705, "PAYMENT_NUMBER_TYPE": "L", "PAYMENT_YEAR": 2014, "RECORD_TYPE": 2, "SE_UNIT_NUMBER": "0000000022" },
    { "AMEX_PAYEE_NUMBER": 2299999510, "AMEX_SE_NUMBER": 2299999510, "DETAIL_RECORD_TYPE": 12, "DISCOUNT_AMOUNT": " 00000000000000", "DISCOUNT_RATE": " 00000000", "FEE_AMOUNT": "+00000000000265", "FEE_CODE": "PG", "FEE_DESCRIPTION": "2PGPIG SERVICE FEE", "FEE_RATE": "+00000030", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254L1727", "PAYMENT_NUMBER_DATE": 254, "PAYMENT_NUMBER_NUMBER": 1727, "PAYMENT_NUMBER_TYPE": "L", "PAYMENT_YEAR": 2014, "RECORD_TYPE": 2, "SE_UNIT_NUMBER": "0000000023" },
    { "AMEX_PAYEE_NUMBER": 2429999928, "AMEX_SE_NUMBER": 2429999928, "DETAIL_RECORD_TYPE": 12, "DISCOUNT_AMOUNT": " 00000000000000", "DISCOUNT_RATE": " 00000000", "FEE_AMOUNT": "+00000000000253", "FEE_CODE": "PG", "FEE_DESCRIPTION": "2PGPIG SERVICE FEE", "FEE_RATE": "+00000030", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254M5144", "PAYMENT_NUMBER_DATE": 254, "PAYMENT_NUMBER_NUMBER": 5144, "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": 2014, "RECORD_TYPE": 2, "SE_UNIT_NUMBER": "0000000012" },
    { "AMEX_PAYEE_NUMBER": 2429999564, "AMEX_SE_NUMBER": 2429999564, "DETAIL_RECORD_TYPE": 12, "DISCOUNT_AMOUNT": " 00000000000000", "DISCOUNT_RATE": " 00000000", "FEE_AMOUNT": "+00000000000104", "FEE_CODE": "PG", "FEE_DESCRIPTION": "2PGPIG SERVICE FEE", "FEE_RATE": "+00000030", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254M5619", "PAYMENT_NUMBER_DATE": 254, "PAYMENT_NUMBER_NUMBER": 5619, "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": 2014, "RECORD_TYPE": 2, "SE_UNIT_NUMBER": "0000000011" },
    { "AMEX_PAYEE_NUMBER": 3129999193, "AMEX_SE_NUMBER": 3129999193, "DETAIL_RECORD_TYPE": 12, "DISCOUNT_AMOUNT": " 00000000000000", "DISCOUNT_RATE": " 00000000", "FEE_AMOUNT": "+00000000000190", "FEE_CODE": "PG", "FEE_DESCRIPTION": "2PGPIG SERVICE FEE", "FEE_RATE": "+00000030", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254M4165", "PAYMENT_NUMBER_DATE": 254, "PAYMENT_NUMBER_NUMBER": 4165, "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": 2014, "RECORD_TYPE": 2, "SE_UNIT_NUMBER": "0000000008" },
    { "AMEX_PAYEE_NUMBER": 3229999977, "AMEX_SE_NUMBER": 3229999977, "DETAIL_RECORD_TYPE": 12, "DISCOUNT_AMOUNT": " 00000000000000", "DISCOUNT_RATE": " 00000000", "FEE_AMOUNT": "+00000000000298", "FEE_CODE": "PG", "FEE_DESCRIPTION": "2PGPIG SERVICE FEE", "FEE_RATE": "+00000030", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254M7990", "PAYMENT_NUMBER_DATE": 254, "PAYMENT_NUMBER_NUMBER": 7990, "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": 2014, "RECORD_TYPE": 2, "SE_UNIT_NUMBER": "0000000005" },
    { "AMEX_PAYEE_NUMBER": 4109999881, "AMEX_SE_NUMBER": 4109999881, "DETAIL_RECORD_TYPE": 12, "DISCOUNT_AMOUNT": " 00000000000000", "DISCOUNT_RATE": " 00000000", "FEE_AMOUNT": "+00000000000160", "FEE_CODE": "PG", "FEE_DESCRIPTION": "2PGPIG SERVICE FEE", "FEE_RATE": "+00000030", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254M5048", "PAYMENT_NUMBER_DATE": 254, "PAYMENT_NUMBER_NUMBER": 5048, "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": 2014, "RECORD_TYPE": 2, "SE_UNIT_NUMBER": "0000000014" },
    { "AMEX_PAYEE_NUMBER": 4459999588, "AMEX_SE_NUMBER": 4459999588, "DETAIL_RECORD_TYPE": 12, "DISCOUNT_AMOUNT": " 00000000000000", "DISCOUNT_RATE": " 00000000", "FEE_AMOUNT": "+00000000000091", "FEE_CODE": "PG", "FEE_DESCRIPTION": "2PGPIG SERVICE FEE", "FEE_RATE": "+00000030", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254M6699", "PAYMENT_NUMBER_DATE": 254, "PAYMENT_NUMBER_NUMBER": 6699, "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": 2014, "RECORD_TYPE": 2, "SE_UNIT_NUMBER": "0000000010" },
    { "AMEX_PAYEE_NUMBER": 5029999057, "AMEX_SE_NUMBER": 5029999057, "DETAIL_RECORD_TYPE": 12, "DISCOUNT_AMOUNT": " 00000000000000", "DISCOUNT_RATE": " 00000000", "FEE_AMOUNT": "+00000000000257", "FEE_CODE": "PG", "FEE_DESCRIPTION": "2PGPIG SERVICE FEE", "FEE_RATE": "+00000030", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254M8033", "PAYMENT_NUMBER_DATE": 254, "PAYMENT_NUMBER_NUMBER": 8033, "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": 2014, "RECORD_TYPE": 2, "SE_UNIT_NUMBER": "0000000001" }
  ],
  "ROC_DETAIL": [
    { "APPROVAL_CODE": "", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "", "TLRR_AMEX_PAYEE_NUMBER": "1049999176", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1049999176", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "372352XXXXX3008", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254F8666", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "8666", "TLRR_PAYMENT_NUMBER_TYPE": "F", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000022843M", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "747101", "TLRR_SE_REF_POA": "747101", "TLRR_SE_UNIT_NUMBER": "0000000002", "TLRR_SOC_AMOUNT": "000000052779D", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "582508", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "0932", "TLRR_AMEX_PAYEE_NUMBER": "1049999176", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1049999176", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371333XXXXX4017", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254F8666", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "8666", "TLRR_PAYMENT_NUMBER_TYPE": "F", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000431I", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280199784", "TLRR_SE_REF_POA": "280199784787", "TLRR_SE_UNIT_NUMBER": "0000000002", "TLRR_SOC_AMOUNT": "000000052779D", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "528601", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "0932", "TLRR_AMEX_PAYEE_NUMBER": "1049999176", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1049999176", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "375282XXXXX2002", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254F8666", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "8666", "TLRR_PAYMENT_NUMBER_TYPE": "F", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000431I", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "891901", "TLRR_SE_REF_POA": "891901", "TLRR_SE_UNIT_NUMBER": "0000000002", "TLRR_SOC_AMOUNT": "000000052779D", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "575135", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "0932", "TLRR_AMEX_PAYEE_NUMBER": "1049999176", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1049999176", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371754XXXXX2009", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254F8666", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "8666", "TLRR_PAYMENT_NUMBER_TYPE": "F", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000547I", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "821901", "TLRR_SE_REF_POA": "821901", "TLRR_SE_UNIT_NUMBER": "0000000002", "TLRR_SOC_AMOUNT": "000000052779D", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "581856", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "0932", "TLRR_AMEX_PAYEE_NUMBER": "1049999176", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1049999176", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "379763XXXXX1005", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254F8666", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "8666", "TLRR_PAYMENT_NUMBER_TYPE": "F", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000971I", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280199785", "TLRR_SE_REF_POA": "280199785023", "TLRR_SE_UNIT_NUMBER": "0000000002", "TLRR_SOC_AMOUNT": "000000052779D", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "591915", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "0932", "TLRR_AMEX_PAYEE_NUMBER": "1049999176", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1049999176", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371381XXXXX7512", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254F8666", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "8666", "TLRR_PAYMENT_NUMBER_TYPE": "F", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000001652G", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "747301", "TLRR_SE_REF_POA": "747301", "TLRR_SE_UNIT_NUMBER": "0000000002", "TLRR_SOC_AMOUNT": "000000052779D", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "503928", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "0932", "TLRR_AMEX_PAYEE_NUMBER": "1049999176", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1049999176", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "373277XXXXX2021", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254F8666", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "8666", "TLRR_PAYMENT_NUMBER_TYPE": "F", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000003093I", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "747801", "TLRR_SE_REF_POA": "747801", "TLRR_SE_UNIT_NUMBER": "0000000002", "TLRR_SOC_AMOUNT": "000000052779D", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "544121", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "0932", "TLRR_AMEX_PAYEE_NUMBER": "1049999176", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1049999176", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371347XXXXX3012", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254F8666", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "8666", "TLRR_PAYMENT_NUMBER_TYPE": "F", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000003422C", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "821201", "TLRR_SE_REF_POA": "821201", "TLRR_SE_UNIT_NUMBER": "0000000002", "TLRR_SOC_AMOUNT": "000000052779D", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "526947", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "0932", "TLRR_AMEX_PAYEE_NUMBER": "1049999176", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1049999176", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "379715XXXXX2001", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254F8666", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "8666", "TLRR_PAYMENT_NUMBER_TYPE": "F", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000006329H", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "238601", "TLRR_SE_REF_POA": "238601", "TLRR_SE_UNIT_NUMBER": "0000000002", "TLRR_SOC_AMOUNT": "000000052779D", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "540456", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "0932", "TLRR_AMEX_PAYEE_NUMBER": "1049999176", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1049999176", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371287XXXXX6004", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254F8666", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "8666", "TLRR_PAYMENT_NUMBER_TYPE": "F", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000009533I", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "270401", "TLRR_SE_REF_POA": "270401", "TLRR_SE_UNIT_NUMBER": "0000000002", "TLRR_SOC_AMOUNT": "000000052779D", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "566219", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "0932", "TLRR_AMEX_PAYEE_NUMBER": "1049999176", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1049999176", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "373277XXXXX2021", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254F8666", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "8666", "TLRR_PAYMENT_NUMBER_TYPE": "F", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000009740C", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "747701", "TLRR_SE_REF_POA": "747701", "TLRR_SE_UNIT_NUMBER": "0000000002", "TLRR_SOC_AMOUNT": "000000052779D", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "582653", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "0932", "TLRR_AMEX_PAYEE_NUMBER": "1049999176", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1049999176", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371287XXXXX6004", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254F8666", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "8666", "TLRR_PAYMENT_NUMBER_TYPE": "F", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000010073H", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "270202", "TLRR_SE_REF_POA": "270202", "TLRR_SE_UNIT_NUMBER": "0000000002", "TLRR_SOC_AMOUNT": "000000052779D", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "544438", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "0932", "TLRR_AMEX_PAYEE_NUMBER": "1049999176", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1049999176", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371507XXXXX5003", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254F8666", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "8666", "TLRR_PAYMENT_NUMBER_TYPE": "F", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000013919G", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "230701", "TLRR_SE_REF_POA": "230701", "TLRR_SE_UNIT_NUMBER": "0000000002", "TLRR_SOC_AMOUNT": "000000052779D", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "515620", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "0932", "TLRR_AMEX_PAYEE_NUMBER": "1049999176", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1049999176", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "372219XXXXX2018", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254F8666", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "8666", "TLRR_PAYMENT_NUMBER_TYPE": "F", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000015472H", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280199784", "TLRR_SE_REF_POA": "280199784789", "TLRR_SE_UNIT_NUMBER": "0000000002", "TLRR_SOC_AMOUNT": "000000052779D", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "561903", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1290", "TLRR_AMEX_PAYEE_NUMBER": "1049999084", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1049999084", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371556XXXXX2008", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254H1728", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1728", "TLRR_PAYMENT_NUMBER_TYPE": "H", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000520D", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "281478511", "TLRR_SE_REF_POA": "281478511484", "TLRR_SE_UNIT_NUMBER": "0SAN DIEGO", "TLRR_SOC_AMOUNT": "000000037319D", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "523904", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1290", "TLRR_AMEX_PAYEE_NUMBER": "1049999084", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1049999084", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "379737XXXXX1004", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254H1728", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1728", "TLRR_PAYMENT_NUMBER_TYPE": "H", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000647I", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "281478511", "TLRR_SE_REF_POA": "281478511497", "TLRR_SE_UNIT_NUMBER": "0SAN DIEGO", "TLRR_SOC_AMOUNT": "000000037319D", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "584037", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1290", "TLRR_AMEX_PAYEE_NUMBER": "1049999084", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1049999084", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "379725XXXXX2009", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254H1728", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1728", "TLRR_PAYMENT_NUMBER_TYPE": "H", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000001069C", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "713101", "TLRR_SE_REF_POA": "713101", "TLRR_SE_UNIT_NUMBER": "0SAN DIEGO", "TLRR_SOC_AMOUNT": "000000037319D", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "217418", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1290", "TLRR_AMEX_PAYEE_NUMBER": "1049999084", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1049999084", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "377481XXXXX0314", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254H1728", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1728", "TLRR_PAYMENT_NUMBER_TYPE": "H", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000001079I", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280199823", "TLRR_SE_REF_POA": "280199823803", "TLRR_SE_UNIT_NUMBER": "0SAN DIEGO", "TLRR_SOC_AMOUNT": "000000037319D", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "855324", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1290", "TLRR_AMEX_PAYEE_NUMBER": "1049999084", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1049999084", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "374322XXXXX3199", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254H1728", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1728", "TLRR_PAYMENT_NUMBER_TYPE": "H", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000001609A", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280199823", "TLRR_SE_REF_POA": "280199823812", "TLRR_SE_UNIT_NUMBER": "0SAN DIEGO", "TLRR_SOC_AMOUNT": "000000037319D", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "594017", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1290", "TLRR_AMEX_PAYEE_NUMBER": "1049999084", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1049999084", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371307XXXXX1002", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254H1728", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1728", "TLRR_PAYMENT_NUMBER_TYPE": "H", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000001652B", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280199823", "TLRR_SE_REF_POA": "280199823807", "TLRR_SE_UNIT_NUMBER": "0SAN DIEGO", "TLRR_SOC_AMOUNT": "000000037319D", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "547843", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1290", "TLRR_AMEX_PAYEE_NUMBER": "1049999084", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1049999084", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "372713XXXXX3046", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254H1728", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1728", "TLRR_PAYMENT_NUMBER_TYPE": "H", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000004211E", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280199823", "TLRR_SE_REF_POA": "280199823805", "TLRR_SE_UNIT_NUMBER": "0SAN DIEGO", "TLRR_SOC_AMOUNT": "000000037319D", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "582234", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1290", "TLRR_AMEX_PAYEE_NUMBER": "1049999084", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1049999084", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371327XXXXX1006", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254H1728", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1728", "TLRR_PAYMENT_NUMBER_TYPE": "H", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000005399I", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280199823", "TLRR_SE_REF_POA": "280199823810", "TLRR_SE_UNIT_NUMBER": "0SAN DIEGO", "TLRR_SOC_AMOUNT": "000000037319D", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "895354", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1290", "TLRR_AMEX_PAYEE_NUMBER": "1049999084", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1049999084", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "374322XXXXX3199", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254H1728", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1728", "TLRR_PAYMENT_NUMBER_TYPE": "H", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000021129B", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "534601", "TLRR_SE_REF_POA": "534601", "TLRR_SE_UNIT_NUMBER": "0SAN DIEGO", "TLRR_SOC_AMOUNT": "000000037319D", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "", "TLRR_AMEX_PAYEE_NUMBER": "1049999700", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1049999700", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371277XXXXX5004", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254H3242", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "3242", "TLRR_PAYMENT_NUMBER_TYPE": "H", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000001999R", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "611801", "TLRR_SE_REF_POA": "611801", "TLRR_SE_UNIT_NUMBER": "0000000007", "TLRR_SOC_AMOUNT": "000000044730F", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "", "TLRR_AMEX_PAYEE_NUMBER": "1049999700", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1049999700", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "373766XXXXX1008", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254H3242", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "3242", "TLRR_PAYMENT_NUMBER_TYPE": "H", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000001403R", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280199765", "TLRR_SE_REF_POA": "280199765012", "TLRR_SE_UNIT_NUMBER": "0000000007", "TLRR_SOC_AMOUNT": "000000044730F", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "505368", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "0934", "TLRR_AMEX_PAYEE_NUMBER": "1049999700", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1049999700", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "379704XXXXX1015", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254H3242", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "3242", "TLRR_PAYMENT_NUMBER_TYPE": "H", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000547I", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280199764", "TLRR_SE_REF_POA": "280199764039", "TLRR_SE_UNIT_NUMBER": "0000000007", "TLRR_SOC_AMOUNT": "000000044730F", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "507930", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "0934", "TLRR_AMEX_PAYEE_NUMBER": "1049999700", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1049999700", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "379702XXXXX2002", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254H3242", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "3242", "TLRR_PAYMENT_NUMBER_TYPE": "H", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000547I", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280199765", "TLRR_SE_REF_POA": "280199765477", "TLRR_SE_UNIT_NUMBER": "0000000007", "TLRR_SOC_AMOUNT": "000000044730F", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "559521", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "0934", "TLRR_AMEX_PAYEE_NUMBER": "1049999700", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1049999700", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "379766XXXXX1004", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254H3242", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "3242", "TLRR_PAYMENT_NUMBER_TYPE": "H", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000647I", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280199764", "TLRR_SE_REF_POA": "280199764024", "TLRR_SE_UNIT_NUMBER": "0000000007", "TLRR_SOC_AMOUNT": "000000044730F", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "506790", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "0934", "TLRR_AMEX_PAYEE_NUMBER": "1049999700", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1049999700", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "376768XXXXX2000", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254H3242", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "3242", "TLRR_PAYMENT_NUMBER_TYPE": "H", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000647I", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280199764", "TLRR_SE_REF_POA": "280199764032", "TLRR_SE_UNIT_NUMBER": "0000000007", "TLRR_SOC_AMOUNT": "000000044730F", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "520059", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "0934", "TLRR_AMEX_PAYEE_NUMBER": "1049999700", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1049999700", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "373498XXXXX1009", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254H3242", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "3242", "TLRR_PAYMENT_NUMBER_TYPE": "H", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000990{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280199764", "TLRR_SE_REF_POA": "280199764032", "TLRR_SE_UNIT_NUMBER": "0000000007", "TLRR_SOC_AMOUNT": "000000044730F", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "588570", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "0934", "TLRR_AMEX_PAYEE_NUMBER": "1049999700", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1049999700", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "376791XXXXX1032", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254H3242", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "3242", "TLRR_PAYMENT_NUMBER_TYPE": "H", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000999I", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280199765", "TLRR_SE_REF_POA": "280199765479", "TLRR_SE_UNIT_NUMBER": "0000000007", "TLRR_SOC_AMOUNT": "000000044730F", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014253", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "523942", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "0934", "TLRR_AMEX_PAYEE_NUMBER": "1049999700", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1049999700", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371553XXXXX2005", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254H3242", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "3242", "TLRR_PAYMENT_NUMBER_TYPE": "H", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000001403I", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280199765", "TLRR_SE_REF_POA": "280199765469", "TLRR_SE_UNIT_NUMBER": "0000000007", "TLRR_SOC_AMOUNT": "000000044730F", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "598271", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "0934", "TLRR_AMEX_PAYEE_NUMBER": "1049999700", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1049999700", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371314XXXXX3009", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254H3242", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "3242", "TLRR_PAYMENT_NUMBER_TYPE": "H", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000007768C", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280199764", "TLRR_SE_REF_POA": "280199764031", "TLRR_SE_UNIT_NUMBER": "0000000007", "TLRR_SOC_AMOUNT": "000000044730F", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "528493", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "0934", "TLRR_AMEX_PAYEE_NUMBER": "1049999700", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1049999700", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "372322XXXXX1009", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254H3242", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "3242", "TLRR_PAYMENT_NUMBER_TYPE": "H", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000011124E", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280199765", "TLRR_SE_REF_POA": "280199765478", "TLRR_SE_UNIT_NUMBER": "0000000007", "TLRR_SOC_AMOUNT": "000000044730F", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "525789", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "0934", "TLRR_AMEX_PAYEE_NUMBER": "1049999700", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1049999700", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "376791XXXXX1032", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254H3242", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "3242", "TLRR_PAYMENT_NUMBER_TYPE": "H", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000023456B", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280199765", "TLRR_SE_REF_POA": "280199765478", "TLRR_SE_UNIT_NUMBER": "0000000007", "TLRR_SOC_AMOUNT": "000000044730F", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014253", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "", "TLRR_AMEX_PAYEE_NUMBER": "1049999728", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1049999728", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371381XXXXX4000", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254H3651", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "3651", "TLRR_PAYMENT_NUMBER_TYPE": "H", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000023880Q", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "017354", "TLRR_SE_REF_POA": "017354", "TLRR_SE_UNIT_NUMBER": "0000000009", "TLRR_SOC_AMOUNT": "000000142227F", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "", "TLRR_AMEX_PAYEE_NUMBER": "1049999728", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1049999728", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371568XXXXX6006", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254H3651", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "3651", "TLRR_PAYMENT_NUMBER_TYPE": "H", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000023827J", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "017476", "TLRR_SE_REF_POA": "017476", "TLRR_SE_UNIT_NUMBER": "0000000009", "TLRR_SOC_AMOUNT": "000000142227F", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "", "TLRR_AMEX_PAYEE_NUMBER": "1049999728", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1049999728", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371328XXXXX5029", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254H3651", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "3651", "TLRR_PAYMENT_NUMBER_TYPE": "H", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000023235P", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "017528", "TLRR_SE_REF_POA": "017528", "TLRR_SE_UNIT_NUMBER": "0000000009", "TLRR_SOC_AMOUNT": "000000142227F", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "", "TLRR_AMEX_PAYEE_NUMBER": "1049999728", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1049999728", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "374716XXXXX5147", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254H3651", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "3651", "TLRR_PAYMENT_NUMBER_TYPE": "H", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000020424P", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "017460", "TLRR_SE_REF_POA": "017460", "TLRR_SE_UNIT_NUMBER": "0000000009", "TLRR_SOC_AMOUNT": "000000142227F", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "", "TLRR_AMEX_PAYEE_NUMBER": "1049999728", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1049999728", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "379724XXXXX1001", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254H3651", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "3651", "TLRR_PAYMENT_NUMBER_TYPE": "H", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000012773L", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "017466", "TLRR_SE_REF_POA": "017466", "TLRR_SE_UNIT_NUMBER": "0000000009", "TLRR_SOC_AMOUNT": "000000142227F", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "", "TLRR_AMEX_PAYEE_NUMBER": "1049999728", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1049999728", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "377256XXXXX4001", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254H3651", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "3651", "TLRR_PAYMENT_NUMBER_TYPE": "H", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000012179M", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "017583", "TLRR_SE_REF_POA": "017583", "TLRR_SE_UNIT_NUMBER": "0000000009", "TLRR_SOC_AMOUNT": "000000142227F", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "", "TLRR_AMEX_PAYEE_NUMBER": "1049999728", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1049999728", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "377256XXXXX4001", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254H3651", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "3651", "TLRR_PAYMENT_NUMBER_TYPE": "H", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000003103P", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "017584", "TLRR_SE_REF_POA": "017584", "TLRR_SE_UNIT_NUMBER": "0000000009", "TLRR_SOC_AMOUNT": "000000142227F", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "", "TLRR_AMEX_PAYEE_NUMBER": "1049999728", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1049999728", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371381XXXXX4000", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254H3651", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "3651", "TLRR_PAYMENT_NUMBER_TYPE": "H", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000002179R", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "017355", "TLRR_SE_REF_POA": "017355", "TLRR_SE_UNIT_NUMBER": "0000000009", "TLRR_SOC_AMOUNT": "000000142227F", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "", "TLRR_AMEX_PAYEE_NUMBER": "1049999728", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1049999728", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "378292XXXXX1215", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254H3651", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "3651", "TLRR_PAYMENT_NUMBER_TYPE": "H", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000002167Q", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "017480", "TLRR_SE_REF_POA": "017480", "TLRR_SE_UNIT_NUMBER": "0000000009", "TLRR_SOC_AMOUNT": "000000142227F", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "", "TLRR_AMEX_PAYEE_NUMBER": "1049999728", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1049999728", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371241XXXXX1000", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254H3651", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "3651", "TLRR_PAYMENT_NUMBER_TYPE": "H", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000001089N", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "017395", "TLRR_SE_REF_POA": "017395", "TLRR_SE_UNIT_NUMBER": "0000000009", "TLRR_SOC_AMOUNT": "000000142227F", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "795894", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1373", "TLRR_AMEX_PAYEE_NUMBER": "1049999728", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1049999728", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "374327XXXXX7341", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254H3651", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "3651", "TLRR_PAYMENT_NUMBER_TYPE": "H", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000053B", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "345001", "TLRR_SE_REF_POA": "345001", "TLRR_SE_UNIT_NUMBER": "0000000009", "TLRR_SOC_AMOUNT": "000000142227F", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "548457", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1373", "TLRR_AMEX_PAYEE_NUMBER": "1049999728", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1049999728", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "379743XXXXX1002", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254H3651", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "3651", "TLRR_PAYMENT_NUMBER_TYPE": "H", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000062I", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "255702", "TLRR_SE_REF_POA": "255702", "TLRR_SE_UNIT_NUMBER": "0000000009", "TLRR_SOC_AMOUNT": "000000142227F", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "562186", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1373", "TLRR_AMEX_PAYEE_NUMBER": "1049999728", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1049999728", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "372065XXXXX4008", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254H3651", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "3651", "TLRR_PAYMENT_NUMBER_TYPE": "H", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000100{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "366301", "TLRR_SE_REF_POA": "366301", "TLRR_SE_UNIT_NUMBER": "0000000009", "TLRR_SOC_AMOUNT": "000000142227F", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "566105", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1373", "TLRR_AMEX_PAYEE_NUMBER": "1049999728", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1049999728", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "374328XXXXX9657", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254H3651", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "3651", "TLRR_PAYMENT_NUMBER_TYPE": "H", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000150{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "294801", "TLRR_SE_REF_POA": "294801", "TLRR_SE_UNIT_NUMBER": "0000000009", "TLRR_SOC_AMOUNT": "000000142227F", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "502040", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1373", "TLRR_AMEX_PAYEE_NUMBER": "1049999728", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1049999728", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371545XXXXX4038", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254H3651", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "3651", "TLRR_PAYMENT_NUMBER_TYPE": "H", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000153I", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "233402", "TLRR_SE_REF_POA": "233402", "TLRR_SE_UNIT_NUMBER": "0000000009", "TLRR_SOC_AMOUNT": "000000142227F", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "522062", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1373", "TLRR_AMEX_PAYEE_NUMBER": "1049999728", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1049999728", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "379752XXXXX1005", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254H3651", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "3651", "TLRR_PAYMENT_NUMBER_TYPE": "H", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000153I", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280199754", "TLRR_SE_REF_POA": "280199754379", "TLRR_SE_UNIT_NUMBER": "0000000009", "TLRR_SOC_AMOUNT": "000000142227F", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "564164", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1373", "TLRR_AMEX_PAYEE_NUMBER": "1049999728", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1049999728", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371530XXXXX1109", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254H3651", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "3651", "TLRR_PAYMENT_NUMBER_TYPE": "H", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000250D", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280876936", "TLRR_SE_REF_POA": "280876936466", "TLRR_SE_UNIT_NUMBER": "0000000009", "TLRR_SOC_AMOUNT": "000000142227F", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "567629", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1373", "TLRR_AMEX_PAYEE_NUMBER": "1049999728", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1049999728", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371547XXXXX5004", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254H3651", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "3651", "TLRR_PAYMENT_NUMBER_TYPE": "H", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000326I", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280876936", "TLRR_SE_REF_POA": "280876936460", "TLRR_SE_UNIT_NUMBER": "0000000009", "TLRR_SOC_AMOUNT": "000000142227F", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "507532", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1373", "TLRR_AMEX_PAYEE_NUMBER": "1049999728", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1049999728", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371561XXXXX4004", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254H3651", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "3651", "TLRR_PAYMENT_NUMBER_TYPE": "H", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000435I", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "352501", "TLRR_SE_REF_POA": "352501", "TLRR_SE_UNIT_NUMBER": "0000000009", "TLRR_SOC_AMOUNT": "000000142227F", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "501860", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1373", "TLRR_AMEX_PAYEE_NUMBER": "1049999728", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1049999728", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "377296XXXXX3012", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254H3651", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "3651", "TLRR_PAYMENT_NUMBER_TYPE": "H", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000465E", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280876936", "TLRR_SE_REF_POA": "280876936375", "TLRR_SE_UNIT_NUMBER": "0000000009", "TLRR_SOC_AMOUNT": "000000142227F", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "528142", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1373", "TLRR_AMEX_PAYEE_NUMBER": "1049999728", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1049999728", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "372719XXXXX1011", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254H3651", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "3651", "TLRR_PAYMENT_NUMBER_TYPE": "H", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000490B", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "292501", "TLRR_SE_REF_POA": "292501", "TLRR_SE_UNIT_NUMBER": "0000000009", "TLRR_SOC_AMOUNT": "000000142227F", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "439677", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1373", "TLRR_AMEX_PAYEE_NUMBER": "1049999728", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1049999728", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "379016XXXXX2580", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254H3651", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "3651", "TLRR_PAYMENT_NUMBER_TYPE": "H", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000500{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "367002", "TLRR_SE_REF_POA": "367002", "TLRR_SE_UNIT_NUMBER": "0000000009", "TLRR_SOC_AMOUNT": "000000142227F", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "530959", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1373", "TLRR_AMEX_PAYEE_NUMBER": "1049999728", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1049999728", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "377268XXXXX2007", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254H3651", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "3651", "TLRR_PAYMENT_NUMBER_TYPE": "H", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000533I", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280876936", "TLRR_SE_REF_POA": "280876936465", "TLRR_SE_UNIT_NUMBER": "0000000009", "TLRR_SOC_AMOUNT": "000000142227F", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "544291", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1373", "TLRR_AMEX_PAYEE_NUMBER": "1049999728", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1049999728", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "377299XXXXX4002", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254H3651", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "3651", "TLRR_PAYMENT_NUMBER_TYPE": "H", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000553I", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280876936", "TLRR_SE_REF_POA": "280876936457", "TLRR_SE_UNIT_NUMBER": "0000000009", "TLRR_SOC_AMOUNT": "000000142227F", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "560822", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1373", "TLRR_AMEX_PAYEE_NUMBER": "1049999728", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1049999728", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "372809XXXXX2014", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254H3651", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "3651", "TLRR_PAYMENT_NUMBER_TYPE": "H", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000553I", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280199754", "TLRR_SE_REF_POA": "280199754380", "TLRR_SE_UNIT_NUMBER": "0000000009", "TLRR_SOC_AMOUNT": "000000142227F", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "188840", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1373", "TLRR_AMEX_PAYEE_NUMBER": "1049999728", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1049999728", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "379016XXXXX9857", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254H3651", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "3651", "TLRR_PAYMENT_NUMBER_TYPE": "H", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000653I", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "275201", "TLRR_SE_REF_POA": "275201", "TLRR_SE_UNIT_NUMBER": "0000000009", "TLRR_SOC_AMOUNT": "000000142227F", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "519746", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1373", "TLRR_AMEX_PAYEE_NUMBER": "1049999728", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1049999728", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "379761XXXXX1007", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254H3651", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "3651", "TLRR_PAYMENT_NUMBER_TYPE": "H", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000653I", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "316101", "TLRR_SE_REF_POA": "316101", "TLRR_SE_UNIT_NUMBER": "0000000009", "TLRR_SOC_AMOUNT": "000000142227F", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "586550", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1373", "TLRR_AMEX_PAYEE_NUMBER": "1049999728", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1049999728", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371388XXXXX1012", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254H3651", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "3651", "TLRR_PAYMENT_NUMBER_TYPE": "H", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000653I", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "345901", "TLRR_SE_REF_POA": "345901", "TLRR_SE_UNIT_NUMBER": "0000000009", "TLRR_SOC_AMOUNT": "000000142227F", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "588866", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1373", "TLRR_AMEX_PAYEE_NUMBER": "1049999728", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1049999728", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "377242XXXXX2008", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254H3651", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "3651", "TLRR_PAYMENT_NUMBER_TYPE": "H", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000653I", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "346001", "TLRR_SE_REF_POA": "346001", "TLRR_SE_UNIT_NUMBER": "0000000009", "TLRR_SOC_AMOUNT": "000000142227F", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "508852", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1373", "TLRR_AMEX_PAYEE_NUMBER": "1049999728", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1049999728", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "377263XXXXX9003", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254H3651", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "3651", "TLRR_PAYMENT_NUMBER_TYPE": "H", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000653I", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "362601", "TLRR_SE_REF_POA": "362601", "TLRR_SE_UNIT_NUMBER": "0000000009", "TLRR_SOC_AMOUNT": "000000142227F", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "500022", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1373", "TLRR_AMEX_PAYEE_NUMBER": "1049999728", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1049999728", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "376750XXXXX4011", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254H3651", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "3651", "TLRR_PAYMENT_NUMBER_TYPE": "H", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000653I", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "364301", "TLRR_SE_REF_POA": "364301", "TLRR_SE_UNIT_NUMBER": "0000000009", "TLRR_SOC_AMOUNT": "000000142227F", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "501772", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1373", "TLRR_AMEX_PAYEE_NUMBER": "1049999728", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1049999728", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371153XXXXX6007", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254H3651", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "3651", "TLRR_PAYMENT_NUMBER_TYPE": "H", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000653I", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280199754", "TLRR_SE_REF_POA": "280199754380", "TLRR_SE_UNIT_NUMBER": "0000000009", "TLRR_SOC_AMOUNT": "000000142227F", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "552798", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1373", "TLRR_AMEX_PAYEE_NUMBER": "1049999728", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1049999728", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371701XXXXX2008", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254H3651", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "3651", "TLRR_PAYMENT_NUMBER_TYPE": "H", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000653I", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280876936", "TLRR_SE_REF_POA": "280876936470", "TLRR_SE_UNIT_NUMBER": "0000000009", "TLRR_SOC_AMOUNT": "000000142227F", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "586129", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1373", "TLRR_AMEX_PAYEE_NUMBER": "1049999728", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1049999728", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371537XXXXX1008", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254H3651", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "3651", "TLRR_PAYMENT_NUMBER_TYPE": "H", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000751I", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "314301", "TLRR_SE_REF_POA": "314301", "TLRR_SE_UNIT_NUMBER": "0000000009", "TLRR_SOC_AMOUNT": "000000142227F", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "591913", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1373", "TLRR_AMEX_PAYEE_NUMBER": "1049999728", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1049999728", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371553XXXXX3002", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254H3651", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "3651", "TLRR_PAYMENT_NUMBER_TYPE": "H", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000762E", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280876936", "TLRR_SE_REF_POA": "280876936459", "TLRR_SE_UNIT_NUMBER": "0000000009", "TLRR_SOC_AMOUNT": "000000142227F", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "548811", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1373", "TLRR_AMEX_PAYEE_NUMBER": "1049999728", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1049999728", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "373353XXXXX2003", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254H3651", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "3651", "TLRR_PAYMENT_NUMBER_TYPE": "H", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000817A", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "337701", "TLRR_SE_REF_POA": "337701", "TLRR_SE_UNIT_NUMBER": "0000000009", "TLRR_SOC_AMOUNT": "000000142227F", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "509236", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1373", "TLRR_AMEX_PAYEE_NUMBER": "1049999728", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1049999728", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "372846XXXXX8002", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254H3651", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "3651", "TLRR_PAYMENT_NUMBER_TYPE": "H", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000980I", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "313201", "TLRR_SE_REF_POA": "313201", "TLRR_SE_UNIT_NUMBER": "0000000009", "TLRR_SOC_AMOUNT": "000000142227F", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "565605", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1373", "TLRR_AMEX_PAYEE_NUMBER": "1049999728", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1049999728", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371566XXXXX3000", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254H3651", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "3651", "TLRR_PAYMENT_NUMBER_TYPE": "H", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000001089H", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "278901", "TLRR_SE_REF_POA": "278901", "TLRR_SE_UNIT_NUMBER": "0000000009", "TLRR_SOC_AMOUNT": "000000142227F", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "562800", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1373", "TLRR_AMEX_PAYEE_NUMBER": "1049999728", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1049999728", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371513XXXXX3006", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254H3651", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "3651", "TLRR_PAYMENT_NUMBER_TYPE": "H", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000001307H", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280876936", "TLRR_SE_REF_POA": "280876936457", "TLRR_SE_UNIT_NUMBER": "0000000009", "TLRR_SOC_AMOUNT": "000000142227F", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "584612", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1373", "TLRR_AMEX_PAYEE_NUMBER": "1049999728", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1049999728", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371536XXXXX2005", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254H3651", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "3651", "TLRR_PAYMENT_NUMBER_TYPE": "H", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000001307H", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "248301", "TLRR_SE_REF_POA": "248301", "TLRR_SE_UNIT_NUMBER": "0000000009", "TLRR_SOC_AMOUNT": "000000142227F", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "570955", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1373", "TLRR_AMEX_PAYEE_NUMBER": "1049999728", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1049999728", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "378261XXXXX5002", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254H3651", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "3651", "TLRR_PAYMENT_NUMBER_TYPE": "H", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000001416D", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "232601", "TLRR_SE_REF_POA": "232601", "TLRR_SE_UNIT_NUMBER": "0000000009", "TLRR_SOC_AMOUNT": "000000142227F", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "165012", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1373", "TLRR_AMEX_PAYEE_NUMBER": "1049999728", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1049999728", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "374716XXXXX5738", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254H3651", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "3651", "TLRR_PAYMENT_NUMBER_TYPE": "H", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000001490{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "344001", "TLRR_SE_REF_POA": "344001", "TLRR_SE_UNIT_NUMBER": "0000000009", "TLRR_SOC_AMOUNT": "000000142227F", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "596657", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1373", "TLRR_AMEX_PAYEE_NUMBER": "1049999728", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1049999728", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371530XXXXX1109", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254H3651", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "3651", "TLRR_PAYMENT_NUMBER_TYPE": "H", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000001490{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280876936", "TLRR_SE_REF_POA": "280876936466", "TLRR_SE_UNIT_NUMBER": "0000000009", "TLRR_SOC_AMOUNT": "000000142227F", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "501592", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1373", "TLRR_AMEX_PAYEE_NUMBER": "1049999728", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1049999728", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371386XXXXX1037", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254H3651", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "3651", "TLRR_PAYMENT_NUMBER_TYPE": "H", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000001623I", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "291301", "TLRR_SE_REF_POA": "291301", "TLRR_SE_UNIT_NUMBER": "0000000009", "TLRR_SOC_AMOUNT": "000000142227F", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "521788", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1373", "TLRR_AMEX_PAYEE_NUMBER": "1049999728", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1049999728", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "376011XXXXX7005", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254H3651", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "3651", "TLRR_PAYMENT_NUMBER_TYPE": "H", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000002070H", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "410301", "TLRR_SE_REF_POA": "410301", "TLRR_SE_UNIT_NUMBER": "0000000009", "TLRR_SOC_AMOUNT": "000000142227F", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "536180", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1373", "TLRR_AMEX_PAYEE_NUMBER": "1049999728", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1049999728", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371539XXXXX2005", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254H3651", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "3651", "TLRR_PAYMENT_NUMBER_TYPE": "H", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000002199C", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "307301", "TLRR_SE_REF_POA": "307301", "TLRR_SE_UNIT_NUMBER": "0000000009", "TLRR_SOC_AMOUNT": "000000142227F", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "517019", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1373", "TLRR_AMEX_PAYEE_NUMBER": "1049999728", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1049999728", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "372727XXXXX3004", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254H3651", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "3651", "TLRR_PAYMENT_NUMBER_TYPE": "H", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000003247H", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280199754", "TLRR_SE_REF_POA": "280199754378", "TLRR_SE_UNIT_NUMBER": "0000000009", "TLRR_SOC_AMOUNT": "000000142227F", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "542660", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1373", "TLRR_AMEX_PAYEE_NUMBER": "1049999728", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1049999728", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371277XXXXX2009", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254H3651", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "3651", "TLRR_PAYMENT_NUMBER_TYPE": "H", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000003785B", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "270302", "TLRR_SE_REF_POA": "270302", "TLRR_SE_UNIT_NUMBER": "0000000009", "TLRR_SOC_AMOUNT": "000000142227F", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "321704", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1373", "TLRR_AMEX_PAYEE_NUMBER": "1049999728", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1049999728", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "374350XXXXX4929", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254H3651", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "3651", "TLRR_PAYMENT_NUMBER_TYPE": "H", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000003849C", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "245001", "TLRR_SE_REF_POA": "245001", "TLRR_SE_UNIT_NUMBER": "0000000009", "TLRR_SOC_AMOUNT": "000000142227F", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "500832", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1373", "TLRR_AMEX_PAYEE_NUMBER": "1049999728", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1049999728", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "379728XXXXX1001", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254H3651", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "3651", "TLRR_PAYMENT_NUMBER_TYPE": "H", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000004166E", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "283202", "TLRR_SE_REF_POA": "283202", "TLRR_SE_UNIT_NUMBER": "0000000009", "TLRR_SOC_AMOUNT": "000000142227F", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "569376", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1373", "TLRR_AMEX_PAYEE_NUMBER": "1049999728", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1049999728", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371558XXXXX1003", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254H3651", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "3651", "TLRR_PAYMENT_NUMBER_TYPE": "H", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000004457H", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "332301", "TLRR_SE_REF_POA": "332301", "TLRR_SE_UNIT_NUMBER": "0000000009", "TLRR_SOC_AMOUNT": "000000142227F", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "517577", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1373", "TLRR_AMEX_PAYEE_NUMBER": "1049999728", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1049999728", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371538XXXXX6008", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254H3651", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "3651", "TLRR_PAYMENT_NUMBER_TYPE": "H", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000005003B", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "300101", "TLRR_SE_REF_POA": "300101", "TLRR_SE_UNIT_NUMBER": "0000000009", "TLRR_SOC_AMOUNT": "000000142227F", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "562878", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1373", "TLRR_AMEX_PAYEE_NUMBER": "1049999728", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1049999728", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371568XXXXX6006", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254H3651", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "3651", "TLRR_PAYMENT_NUMBER_TYPE": "H", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000005297D", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "323901", "TLRR_SE_REF_POA": "323901", "TLRR_SE_UNIT_NUMBER": "0000000009", "TLRR_SOC_AMOUNT": "000000142227F", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "529376", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1373", "TLRR_AMEX_PAYEE_NUMBER": "1049999728", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1049999728", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371514XXXXX1002", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254H3651", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "3651", "TLRR_PAYMENT_NUMBER_TYPE": "H", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000005559C", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "287501", "TLRR_SE_REF_POA": "287501", "TLRR_SE_UNIT_NUMBER": "0000000009", "TLRR_SOC_AMOUNT": "000000142227F", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "563322", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1373", "TLRR_AMEX_PAYEE_NUMBER": "1049999728", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1049999728", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371718XXXXX2006", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254H3651", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "3651", "TLRR_PAYMENT_NUMBER_TYPE": "H", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000008378I", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "348501", "TLRR_SE_REF_POA": "348501", "TLRR_SE_UNIT_NUMBER": "0000000009", "TLRR_SOC_AMOUNT": "000000142227F", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "545667", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1373", "TLRR_AMEX_PAYEE_NUMBER": "1049999728", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1049999728", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "372718XXXXX1003", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254H3651", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "3651", "TLRR_PAYMENT_NUMBER_TYPE": "H", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000010239B", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "253201", "TLRR_SE_REF_POA": "253201", "TLRR_SE_UNIT_NUMBER": "0000000009", "TLRR_SOC_AMOUNT": "000000142227F", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "542169", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1373", "TLRR_AMEX_PAYEE_NUMBER": "1049999728", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1049999728", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "372525XXXXX1015", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254H3651", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "3651", "TLRR_PAYMENT_NUMBER_TYPE": "H", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000010910G", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "315301", "TLRR_SE_REF_POA": "315301", "TLRR_SE_UNIT_NUMBER": "0000000009", "TLRR_SOC_AMOUNT": "000000142227F", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "534627", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1373", "TLRR_AMEX_PAYEE_NUMBER": "1049999728", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1049999728", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "376656XXXXX9314", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254H3651", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "3651", "TLRR_PAYMENT_NUMBER_TYPE": "H", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000011105C", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "358601", "TLRR_SE_REF_POA": "358601", "TLRR_SE_UNIT_NUMBER": "0000000009", "TLRR_SOC_AMOUNT": "000000142227F", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "563248", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1373", "TLRR_AMEX_PAYEE_NUMBER": "1049999728", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1049999728", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371382XXXXX3001", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254H3651", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "3651", "TLRR_PAYMENT_NUMBER_TYPE": "H", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000011890H", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "233901", "TLRR_SE_REF_POA": "233901", "TLRR_SE_UNIT_NUMBER": "0000000009", "TLRR_SOC_AMOUNT": "000000142227F", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "582688", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1373", "TLRR_AMEX_PAYEE_NUMBER": "1049999728", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1049999728", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "379715XXXXX1001", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254H3651", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "3651", "TLRR_PAYMENT_NUMBER_TYPE": "H", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000011890H", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "247801", "TLRR_SE_REF_POA": "247801", "TLRR_SE_UNIT_NUMBER": "0000000009", "TLRR_SOC_AMOUNT": "000000142227F", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "521137", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1373", "TLRR_AMEX_PAYEE_NUMBER": "1049999728", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1049999728", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "372733XXXXX1008", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254H3651", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "3651", "TLRR_PAYMENT_NUMBER_TYPE": "H", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000012361F", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "298301", "TLRR_SE_REF_POA": "298301", "TLRR_SE_UNIT_NUMBER": "0000000009", "TLRR_SOC_AMOUNT": "000000142227F", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "505757", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1373", "TLRR_AMEX_PAYEE_NUMBER": "1049999728", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1049999728", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371747XXXXX2007", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254H3651", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "3651", "TLRR_PAYMENT_NUMBER_TYPE": "H", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000012409B", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "274301", "TLRR_SE_REF_POA": "274301", "TLRR_SE_UNIT_NUMBER": "0000000009", "TLRR_SOC_AMOUNT": "000000142227F", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "556377", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1373", "TLRR_AMEX_PAYEE_NUMBER": "1049999728", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1049999728", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371388XXXXX5006", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254H3651", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "3651", "TLRR_PAYMENT_NUMBER_TYPE": "H", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000014026B", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "356001", "TLRR_SE_REF_POA": "356001", "TLRR_SE_UNIT_NUMBER": "0000000009", "TLRR_SOC_AMOUNT": "000000142227F", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "504596", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1373", "TLRR_AMEX_PAYEE_NUMBER": "1049999728", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1049999728", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "372585XXXXX2008", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254H3651", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "3651", "TLRR_PAYMENT_NUMBER_TYPE": "H", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000014165H", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "234601", "TLRR_SE_REF_POA": "234601", "TLRR_SE_UNIT_NUMBER": "0000000009", "TLRR_SOC_AMOUNT": "000000142227F", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "524139", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1373", "TLRR_AMEX_PAYEE_NUMBER": "1049999728", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1049999728", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "377268XXXXX1006", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254H3651", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "3651", "TLRR_PAYMENT_NUMBER_TYPE": "H", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000015660H", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "299001", "TLRR_SE_REF_POA": "299001", "TLRR_SE_UNIT_NUMBER": "0000000009", "TLRR_SOC_AMOUNT": "000000142227F", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "588360", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1373", "TLRR_AMEX_PAYEE_NUMBER": "1049999728", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1049999728", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "379739XXXXX1000", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254H3651", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "3651", "TLRR_PAYMENT_NUMBER_TYPE": "H", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000019956G", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "293801", "TLRR_SE_REF_POA": "293801", "TLRR_SE_UNIT_NUMBER": "0000000009", "TLRR_SOC_AMOUNT": "000000142227F", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "547645", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1373", "TLRR_AMEX_PAYEE_NUMBER": "1049999728", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1049999728", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371753XXXXX5003", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254H3651", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "3651", "TLRR_PAYMENT_NUMBER_TYPE": "H", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000024661B", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280876936", "TLRR_SE_REF_POA": "280876936468", "TLRR_SE_UNIT_NUMBER": "0000000009", "TLRR_SOC_AMOUNT": "000000142227F", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "515305", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1373", "TLRR_AMEX_PAYEE_NUMBER": "1049999728", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1049999728", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371757XXXXX4001", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254H3651", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "3651", "TLRR_PAYMENT_NUMBER_TYPE": "H", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000026741I", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "275001", "TLRR_SE_REF_POA": "275001", "TLRR_SE_UNIT_NUMBER": "0000000009", "TLRR_SOC_AMOUNT": "000000142227F", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "", "TLRR_AMEX_PAYEE_NUMBER": "1049999121", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1049999121", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "376731XXXXX1008", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254H4390", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "4390", "TLRR_PAYMENT_NUMBER_TYPE": "H", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000016760K", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280199899", "TLRR_SE_REF_POA": "280199899020", "TLRR_SE_UNIT_NUMBER": "0000000015", "TLRR_SOC_AMOUNT": "000000063927{", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "", "TLRR_AMEX_PAYEE_NUMBER": "1049999121", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1049999121", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "379758XXXXX1008", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254H4390", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "4390", "TLRR_PAYMENT_NUMBER_TYPE": "H", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000009262Q", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "751301", "TLRR_SE_REF_POA": "751301", "TLRR_SE_UNIT_NUMBER": "0000000015", "TLRR_SOC_AMOUNT": "000000063927{", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "", "TLRR_AMEX_PAYEE_NUMBER": "1049999121", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1049999121", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "379763XXXXX1004", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254H4390", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "4390", "TLRR_PAYMENT_NUMBER_TYPE": "H", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000003739N", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280199624", "TLRR_SE_REF_POA": "280199624021", "TLRR_SE_UNIT_NUMBER": "0000000015", "TLRR_SOC_AMOUNT": "000000063927{", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "", "TLRR_AMEX_PAYEE_NUMBER": "1049999121", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1049999121", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371511XXXXX3003", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254H4390", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "4390", "TLRR_PAYMENT_NUMBER_TYPE": "H", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000385L", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280199624", "TLRR_SE_REF_POA": "280199624021", "TLRR_SE_UNIT_NUMBER": "0000000015", "TLRR_SOC_AMOUNT": "000000063927{", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "569833", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1400", "TLRR_AMEX_PAYEE_NUMBER": "1049999121", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1049999121", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371319XXXXX1006", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254H4390", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "4390", "TLRR_PAYMENT_NUMBER_TYPE": "H", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000387B", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "021204", "TLRR_SE_REF_POA": "021204", "TLRR_SE_UNIT_NUMBER": "0000000015", "TLRR_SOC_AMOUNT": "000000063927{", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "538940", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1400", "TLRR_AMEX_PAYEE_NUMBER": "1049999121", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1049999121", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371327XXXXX1006", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254H4390", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "4390", "TLRR_PAYMENT_NUMBER_TYPE": "H", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000434I", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "751801", "TLRR_SE_REF_POA": "751801", "TLRR_SE_UNIT_NUMBER": "0000000015", "TLRR_SOC_AMOUNT": "000000063927{", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "527306", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1400", "TLRR_AMEX_PAYEE_NUMBER": "1049999121", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1049999121", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "372586XXXXX1008", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254H4390", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "4390", "TLRR_PAYMENT_NUMBER_TYPE": "H", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000552C", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "021215", "TLRR_SE_REF_POA": "021215", "TLRR_SE_UNIT_NUMBER": "0000000015", "TLRR_SOC_AMOUNT": "000000063927{", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "541729", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1400", "TLRR_AMEX_PAYEE_NUMBER": "1049999121", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1049999121", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "379722XXXXX1003", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254H4390", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "4390", "TLRR_PAYMENT_NUMBER_TYPE": "H", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000552C", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "699201", "TLRR_SE_REF_POA": "699201", "TLRR_SE_UNIT_NUMBER": "0000000015", "TLRR_SOC_AMOUNT": "000000063927{", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "589901", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1400", "TLRR_AMEX_PAYEE_NUMBER": "1049999121", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1049999121", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "379722XXXXX1003", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254H4390", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "4390", "TLRR_PAYMENT_NUMBER_TYPE": "H", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000552C", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "699302", "TLRR_SE_REF_POA": "699302", "TLRR_SE_UNIT_NUMBER": "0000000015", "TLRR_SOC_AMOUNT": "000000063927{", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "567480", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1400", "TLRR_AMEX_PAYEE_NUMBER": "1049999121", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1049999121", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "373749XXXXX2002", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254H4390", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "4390", "TLRR_PAYMENT_NUMBER_TYPE": "H", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000001490{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280199899", "TLRR_SE_REF_POA": "280199899919", "TLRR_SE_UNIT_NUMBER": "0000000015", "TLRR_SOC_AMOUNT": "000000063927{", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "529875", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1400", "TLRR_AMEX_PAYEE_NUMBER": "1049999121", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1049999121", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "372719XXXXX1029", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254H4390", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "4390", "TLRR_PAYMENT_NUMBER_TYPE": "H", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000002881B", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280199899", "TLRR_SE_REF_POA": "280199899920", "TLRR_SE_UNIT_NUMBER": "0000000015", "TLRR_SOC_AMOUNT": "000000063927{", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "589396", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1400", "TLRR_AMEX_PAYEE_NUMBER": "1049999121", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1049999121", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "377283XXXXX3000", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254H4390", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "4390", "TLRR_PAYMENT_NUMBER_TYPE": "H", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000003339B", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280199899", "TLRR_SE_REF_POA": "280199899923", "TLRR_SE_UNIT_NUMBER": "0000000015", "TLRR_SOC_AMOUNT": "000000063927{", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "543856", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1400", "TLRR_AMEX_PAYEE_NUMBER": "1049999121", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1049999121", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "379763XXXXX1004", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254H4390", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "4390", "TLRR_PAYMENT_NUMBER_TYPE": "H", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000003739E", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "021219", "TLRR_SE_REF_POA": "021219", "TLRR_SE_UNIT_NUMBER": "0000000015", "TLRR_SOC_AMOUNT": "000000063927{", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "515389", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1400", "TLRR_AMEX_PAYEE_NUMBER": "1049999121", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1049999121", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "379763XXXXX1004", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254H4390", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "4390", "TLRR_PAYMENT_NUMBER_TYPE": "H", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000003739E", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "021221", "TLRR_SE_REF_POA": "021221", "TLRR_SE_UNIT_NUMBER": "0000000015", "TLRR_SOC_AMOUNT": "000000063927{", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "549257", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1400", "TLRR_AMEX_PAYEE_NUMBER": "1049999121", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1049999121", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "372390XXXXX3008", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254H4390", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "4390", "TLRR_PAYMENT_NUMBER_TYPE": "H", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000004339B", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "021188", "TLRR_SE_REF_POA": "021188", "TLRR_SE_UNIT_NUMBER": "0000000015", "TLRR_SOC_AMOUNT": "000000063927{", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "520429", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1400", "TLRR_AMEX_PAYEE_NUMBER": "1049999121", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1049999121", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "376767XXXXX1001", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254H4390", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "4390", "TLRR_PAYMENT_NUMBER_TYPE": "H", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000004339B", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "021235", "TLRR_SE_REF_POA": "021235", "TLRR_SE_UNIT_NUMBER": "0000000015", "TLRR_SOC_AMOUNT": "000000063927{", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "522784", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1400", "TLRR_AMEX_PAYEE_NUMBER": "1049999121", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1049999121", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "379748XXXXX2009", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254H4390", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "4390", "TLRR_PAYMENT_NUMBER_TYPE": "H", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000005192E", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280199899", "TLRR_SE_REF_POA": "280199899925", "TLRR_SE_UNIT_NUMBER": "0000000015", "TLRR_SOC_AMOUNT": "000000063927{", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "575773", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1400", "TLRR_AMEX_PAYEE_NUMBER": "1049999121", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1049999121", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371511XXXXX3003", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254H4390", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "4390", "TLRR_PAYMENT_NUMBER_TYPE": "H", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000007316D", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "502201", "TLRR_SE_REF_POA": "502201", "TLRR_SE_UNIT_NUMBER": "0000000015", "TLRR_SOC_AMOUNT": "000000063927{", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "568716", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1400", "TLRR_AMEX_PAYEE_NUMBER": "1049999121", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1049999121", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "377227XXXXX1009", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254H4390", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "4390", "TLRR_PAYMENT_NUMBER_TYPE": "H", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000013997H", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "482501", "TLRR_SE_REF_POA": "482501", "TLRR_SE_UNIT_NUMBER": "0000000015", "TLRR_SOC_AMOUNT": "000000063927{", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "520794", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1400", "TLRR_AMEX_PAYEE_NUMBER": "1049999121", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1049999121", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "372727XXXXX1003", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254H4390", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "4390", "TLRR_PAYMENT_NUMBER_TYPE": "H", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000016131E", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "021213", "TLRR_SE_REF_POA": "021213", "TLRR_SE_UNIT_NUMBER": "0000000015", "TLRR_SOC_AMOUNT": "000000063927{", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "566966", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1400", "TLRR_AMEX_PAYEE_NUMBER": "1049999121", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1049999121", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "376665XXXXX3000", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254H4390", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "4390", "TLRR_PAYMENT_NUMBER_TYPE": "H", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000025089H", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "021231", "TLRR_SE_REF_POA": "021231", "TLRR_SE_UNIT_NUMBER": "0000000015", "TLRR_SOC_AMOUNT": "000000063927{", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "528419", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1417", "TLRR_AMEX_PAYEE_NUMBER": "1049999246", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1049999246", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "376781XXXXX1002", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254H5067", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "5067", "TLRR_PAYMENT_NUMBER_TYPE": "H", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000271G", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280199773", "TLRR_SE_REF_POA": "280199773382", "TLRR_SE_UNIT_NUMBER": "0000000017", "TLRR_SOC_AMOUNT": "000000032909{", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "585860", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1417", "TLRR_AMEX_PAYEE_NUMBER": "1049999246", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1049999246", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "378295XXXXX1476", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254H5067", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "5067", "TLRR_PAYMENT_NUMBER_TYPE": "H", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000326B", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280199772", "TLRR_SE_REF_POA": "280199772518", "TLRR_SE_UNIT_NUMBER": "0000000017", "TLRR_SOC_AMOUNT": "000000032909{", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "533720", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1417", "TLRR_AMEX_PAYEE_NUMBER": "1049999246", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1049999246", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "379751XXXXX1004", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254H5067", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "5067", "TLRR_PAYMENT_NUMBER_TYPE": "H", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000001957C", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280199772", "TLRR_SE_REF_POA": "280199772522", "TLRR_SE_UNIT_NUMBER": "0000000017", "TLRR_SOC_AMOUNT": "000000032909{", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "527063", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1417", "TLRR_AMEX_PAYEE_NUMBER": "1049999246", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1049999246", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "376764XXXXX1007", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254H5067", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "5067", "TLRR_PAYMENT_NUMBER_TYPE": "H", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000004239B", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280199773", "TLRR_SE_REF_POA": "280199773380", "TLRR_SE_UNIT_NUMBER": "0000000017", "TLRR_SOC_AMOUNT": "000000032909{", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "504697", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1417", "TLRR_AMEX_PAYEE_NUMBER": "1049999246", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1049999246", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "376781XXXXX2005", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254H5067", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "5067", "TLRR_PAYMENT_NUMBER_TYPE": "H", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000004339B", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280199773", "TLRR_SE_REF_POA": "280199773390", "TLRR_SE_UNIT_NUMBER": "0000000017", "TLRR_SOC_AMOUNT": "000000032909{", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "520249", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1417", "TLRR_AMEX_PAYEE_NUMBER": "1049999246", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1049999246", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "376765XXXXX1005", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254H5067", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "5067", "TLRR_PAYMENT_NUMBER_TYPE": "H", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000005443H", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280199772", "TLRR_SE_REF_POA": "280199772514", "TLRR_SE_UNIT_NUMBER": "0000000017", "TLRR_SOC_AMOUNT": "000000032909{", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "551750", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1417", "TLRR_AMEX_PAYEE_NUMBER": "1049999246", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1049999246", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "379650XXXXX2004", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254H5067", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "5067", "TLRR_PAYMENT_NUMBER_TYPE": "H", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000016331F", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280199772", "TLRR_SE_REF_POA": "280199772517", "TLRR_SE_UNIT_NUMBER": "0000000017", "TLRR_SOC_AMOUNT": "000000032909{", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "548474", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1284", "TLRR_AMEX_PAYEE_NUMBER": "1059999079", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1059999079", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "378368XXXXX3005", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254H9133", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "9133", "TLRR_PAYMENT_NUMBER_TYPE": "H", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000320C", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "009694", "TLRR_SE_REF_POA": "009694", "TLRR_SE_UNIT_NUMBER": "PARK MEADO", "TLRR_SOC_AMOUNT": "000000029178D", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "919660", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1284", "TLRR_AMEX_PAYEE_NUMBER": "1059999079", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1059999079", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "379016XXXXX9858", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254H9133", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "9133", "TLRR_PAYMENT_NUMBER_TYPE": "H", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000390H", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "765402", "TLRR_SE_REF_POA": "765402", "TLRR_SE_UNIT_NUMBER": "PARK MEADO", "TLRR_SOC_AMOUNT": "000000029178D", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "569982", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1284", "TLRR_AMEX_PAYEE_NUMBER": "1059999079", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1059999079", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "376774XXXXX1000", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254H9133", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "9133", "TLRR_PAYMENT_NUMBER_TYPE": "H", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000427A", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "009720", "TLRR_SE_REF_POA": "009720", "TLRR_SE_UNIT_NUMBER": "PARK MEADO", "TLRR_SOC_AMOUNT": "000000029178D", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "532954", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1284", "TLRR_AMEX_PAYEE_NUMBER": "1059999079", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1059999079", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "377298XXXXX3006", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254H9133", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "9133", "TLRR_PAYMENT_NUMBER_TYPE": "H", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000968{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280199858", "TLRR_SE_REF_POA": "280199858764", "TLRR_SE_UNIT_NUMBER": "PARK MEADO", "TLRR_SOC_AMOUNT": "000000029178D", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "592658", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1284", "TLRR_AMEX_PAYEE_NUMBER": "1059999079", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1059999079", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371718XXXXX5008", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254H9133", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "9133", "TLRR_PAYMENT_NUMBER_TYPE": "H", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000002136A", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "855101", "TLRR_SE_REF_POA": "855101", "TLRR_SE_UNIT_NUMBER": "PARK MEADO", "TLRR_SOC_AMOUNT": "000000029178D", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "504718", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1284", "TLRR_AMEX_PAYEE_NUMBER": "1059999079", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1059999079", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "372354XXXXX1005", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254H9133", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "9133", "TLRR_PAYMENT_NUMBER_TYPE": "H", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000004449B", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "009705", "TLRR_SE_REF_POA": "009705", "TLRR_SE_UNIT_NUMBER": "PARK MEADO", "TLRR_SOC_AMOUNT": "000000029178D", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "542044", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1284", "TLRR_AMEX_PAYEE_NUMBER": "1059999079", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1059999079", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "377273XXXXX2005", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254H9133", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "9133", "TLRR_PAYMENT_NUMBER_TYPE": "H", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000020486I", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "763801", "TLRR_SE_REF_POA": "763801", "TLRR_SE_UNIT_NUMBER": "PARK MEADO", "TLRR_SOC_AMOUNT": "000000029178D", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "584198", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1322", "TLRR_AMEX_PAYEE_NUMBER": "1099999509", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1099999509", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371244XXXXX1017", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254E6857", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "6857", "TLRR_PAYMENT_NUMBER_TYPE": "E", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000420I", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280199958", "TLRR_SE_REF_POA": "280199958019", "TLRR_SE_UNIT_NUMBER": "0000STR#60", "TLRR_SOC_AMOUNT": "000000048183{", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "580513", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1322", "TLRR_AMEX_PAYEE_NUMBER": "1099999509", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1099999509", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "379734XXXXX1007", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254E6857", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "6857", "TLRR_PAYMENT_NUMBER_TYPE": "E", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000855H", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "070701", "TLRR_SE_REF_POA": "070701", "TLRR_SE_UNIT_NUMBER": "0000STR#60", "TLRR_SOC_AMOUNT": "000000048183{", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "528307", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1322", "TLRR_AMEX_PAYEE_NUMBER": "1099999509", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1099999509", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "376772XXXXX2002", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254E6857", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "6857", "TLRR_PAYMENT_NUMBER_TYPE": "E", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000001840A", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280199958", "TLRR_SE_REF_POA": "280199958029", "TLRR_SE_UNIT_NUMBER": "0000STR#60", "TLRR_SOC_AMOUNT": "000000048183{", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "427239", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1322", "TLRR_AMEX_PAYEE_NUMBER": "1099999509", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1099999509", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "374350XXXXX5947", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254E6857", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "6857", "TLRR_PAYMENT_NUMBER_TYPE": "E", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000002139I", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "043901", "TLRR_SE_REF_POA": "043901", "TLRR_SE_UNIT_NUMBER": "0000STR#60", "TLRR_SOC_AMOUNT": "000000048183{", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "580411", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1322", "TLRR_AMEX_PAYEE_NUMBER": "1099999509", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1099999509", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "372764XXXXX2011", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254E6857", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "6857", "TLRR_PAYMENT_NUMBER_TYPE": "E", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000002209I", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280199958", "TLRR_SE_REF_POA": "280199958029", "TLRR_SE_UNIT_NUMBER": "0000STR#60", "TLRR_SOC_AMOUNT": "000000048183{", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "540552", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1322", "TLRR_AMEX_PAYEE_NUMBER": "1099999509", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1099999509", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "379736XXXXX2000", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254E6857", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "6857", "TLRR_PAYMENT_NUMBER_TYPE": "E", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000003769C", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "068706", "TLRR_SE_REF_POA": "068706", "TLRR_SE_UNIT_NUMBER": "0000STR#60", "TLRR_SOC_AMOUNT": "000000048183{", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "543879", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1322", "TLRR_AMEX_PAYEE_NUMBER": "1099999509", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1099999509", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371537XXXXX2004", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254E6857", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "6857", "TLRR_PAYMENT_NUMBER_TYPE": "E", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000006377B", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280199958", "TLRR_SE_REF_POA": "280199958016", "TLRR_SE_UNIT_NUMBER": "0000STR#60", "TLRR_SOC_AMOUNT": "000000048183{", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "563415", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1322", "TLRR_AMEX_PAYEE_NUMBER": "1099999509", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1099999509", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371537XXXXX1000", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254E6857", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "6857", "TLRR_PAYMENT_NUMBER_TYPE": "E", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000006730D", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280199958", "TLRR_SE_REF_POA": "280199958015", "TLRR_SE_UNIT_NUMBER": "0000STR#60", "TLRR_SOC_AMOUNT": "000000048183{", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "562006", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1322", "TLRR_AMEX_PAYEE_NUMBER": "1099999509", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1099999509", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "374671XXXXX2008", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254E6857", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "6857", "TLRR_PAYMENT_NUMBER_TYPE": "E", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000009940B", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "052001", "TLRR_SE_REF_POA": "052001", "TLRR_SE_UNIT_NUMBER": "0000STR#60", "TLRR_SOC_AMOUNT": "000000048183{", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "565212", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1322", "TLRR_AMEX_PAYEE_NUMBER": "1099999509", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1099999509", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "372764XXXXX2011", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254E6857", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "6857", "TLRR_PAYMENT_NUMBER_TYPE": "E", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000013899C", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280199958", "TLRR_SE_REF_POA": "280199958028", "TLRR_SE_UNIT_NUMBER": "0000STR#60", "TLRR_SOC_AMOUNT": "000000048183{", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "521105", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1422", "TLRR_AMEX_PAYEE_NUMBER": "1159999126", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1159999126", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "372323XXXXX1008", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254J2806", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "2806", "TLRR_PAYMENT_NUMBER_TYPE": "J", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000392B", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280199872", "TLRR_SE_REF_POA": "280199872757", "TLRR_SE_UNIT_NUMBER": "000STR #25", "TLRR_SOC_AMOUNT": "000000017998E", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "529446", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1422", "TLRR_AMEX_PAYEE_NUMBER": "1159999126", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1159999126", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "372373XXXXX2003", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254J2806", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "2806", "TLRR_PAYMENT_NUMBER_TYPE": "J", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000653H", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "199601", "TLRR_SE_REF_POA": "199601", "TLRR_SE_UNIT_NUMBER": "000STR #25", "TLRR_SOC_AMOUNT": "000000017998E", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "595332", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1422", "TLRR_AMEX_PAYEE_NUMBER": "1159999126", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1159999126", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "374716XXXXX9591", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254J2806", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "2806", "TLRR_PAYMENT_NUMBER_TYPE": "J", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000003349B", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "199402", "TLRR_SE_REF_POA": "199402", "TLRR_SE_UNIT_NUMBER": "000STR #25", "TLRR_SOC_AMOUNT": "000000017998E", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "579733", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1422", "TLRR_AMEX_PAYEE_NUMBER": "1159999126", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1159999126", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "372323XXXXX1008", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254J2806", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "2806", "TLRR_PAYMENT_NUMBER_TYPE": "J", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000013603C", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280199872", "TLRR_SE_REF_POA": "280199872757", "TLRR_SE_UNIT_NUMBER": "000STR #25", "TLRR_SOC_AMOUNT": "000000017998E", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "594013", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8019", "TLRR_AMEX_PAYEE_NUMBER": "1269999580", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1269999580", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371348XXXXX3008", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254J4690", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "4690", "TLRR_PAYMENT_NUMBER_TYPE": "J", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000855I", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "282111098", "TLRR_SE_REF_POA": "282111098304", "TLRR_SE_UNIT_NUMBER": "00STR#8070", "TLRR_SOC_AMOUNT": "000000000855I", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "504990", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "9724", "TLRR_AMEX_PAYEE_NUMBER": "1319999989", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1319999989", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371559XXXXX1387", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254G2302", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "2302", "TLRR_PAYMENT_NUMBER_TYPE": "G", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000249H", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "108001", "TLRR_SE_REF_POA": "108001", "TLRR_SE_UNIT_NUMBER": "0000000044", "TLRR_SOC_AMOUNT": "000000053894I", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "517937", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "9724", "TLRR_AMEX_PAYEE_NUMBER": "1319999989", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1319999989", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "376767XXXXX1004", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254G2302", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "2302", "TLRR_PAYMENT_NUMBER_TYPE": "G", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000651F", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "061801", "TLRR_SE_REF_POA": "061801", "TLRR_SE_UNIT_NUMBER": "0000000044", "TLRR_SOC_AMOUNT": "000000053894I", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "529908", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "9724", "TLRR_AMEX_PAYEE_NUMBER": "1319999989", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1319999989", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "372717XXXXX2004", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254G2302", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "2302", "TLRR_PAYMENT_NUMBER_TYPE": "G", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000823D", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "088202", "TLRR_SE_REF_POA": "088202", "TLRR_SE_UNIT_NUMBER": "0000000044", "TLRR_SOC_AMOUNT": "000000053894I", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "275013", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "9724", "TLRR_AMEX_PAYEE_NUMBER": "1319999989", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1319999989", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "374322XXXXX9142", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254G2302", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "2302", "TLRR_PAYMENT_NUMBER_TYPE": "G", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000001075D", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280199999", "TLRR_SE_REF_POA": "280199999754", "TLRR_SE_UNIT_NUMBER": "0000000044", "TLRR_SOC_AMOUNT": "000000053894I", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "537900", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "9724", "TLRR_AMEX_PAYEE_NUMBER": "1319999989", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1319999989", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "372765XXXXX5004", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254G2302", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "2302", "TLRR_PAYMENT_NUMBER_TYPE": "G", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000001303D", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "083501", "TLRR_SE_REF_POA": "083501", "TLRR_SE_UNIT_NUMBER": "0000000044", "TLRR_SOC_AMOUNT": "000000053894I", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "508808", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "9724", "TLRR_AMEX_PAYEE_NUMBER": "1319999989", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1319999989", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "372717XXXXX2004", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254G2302", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "2302", "TLRR_PAYMENT_NUMBER_TYPE": "G", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000001368E", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "088301", "TLRR_SE_REF_POA": "088301", "TLRR_SE_UNIT_NUMBER": "0000000044", "TLRR_SOC_AMOUNT": "000000053894I", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "588734", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "9724", "TLRR_AMEX_PAYEE_NUMBER": "1319999989", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1319999989", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "372765XXXXX5004", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254G2302", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "2302", "TLRR_PAYMENT_NUMBER_TYPE": "G", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000001520F", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "083601", "TLRR_SE_REF_POA": "083601", "TLRR_SE_UNIT_NUMBER": "0000000044", "TLRR_SOC_AMOUNT": "000000053894I", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "593839", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "9724", "TLRR_AMEX_PAYEE_NUMBER": "1319999989", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1319999989", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "372586XXXXX1000", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254G2302", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "2302", "TLRR_PAYMENT_NUMBER_TYPE": "G", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000004334B", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "093401", "TLRR_SE_REF_POA": "093401", "TLRR_SE_UNIT_NUMBER": "0000000044", "TLRR_SOC_AMOUNT": "000000053894I", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "535550", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "9724", "TLRR_AMEX_PAYEE_NUMBER": "1319999989", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1319999989", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "374716XXXXX5940", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254G2302", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "2302", "TLRR_PAYMENT_NUMBER_TYPE": "G", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000004431A", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "088502", "TLRR_SE_REF_POA": "088502", "TLRR_SE_UNIT_NUMBER": "0000000044", "TLRR_SOC_AMOUNT": "000000053894I", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "506064", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "9724", "TLRR_AMEX_PAYEE_NUMBER": "1319999989", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1319999989", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "372311XXXXX6014", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254G2302", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "2302", "TLRR_PAYMENT_NUMBER_TYPE": "G", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000005907{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "107501", "TLRR_SE_REF_POA": "107501", "TLRR_SE_UNIT_NUMBER": "0000000044", "TLRR_SOC_AMOUNT": "000000053894I", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "580620", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "9724", "TLRR_AMEX_PAYEE_NUMBER": "1319999989", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1319999989", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "372717XXXXX2004", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254G2302", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "2302", "TLRR_PAYMENT_NUMBER_TYPE": "G", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000012699C", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "088101", "TLRR_SE_REF_POA": "088101", "TLRR_SE_UNIT_NUMBER": "0000000044", "TLRR_SOC_AMOUNT": "000000053894I", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "508942", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "9724", "TLRR_AMEX_PAYEE_NUMBER": "1319999989", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1319999989", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "373278XXXXX5003", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254G2302", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "2302", "TLRR_PAYMENT_NUMBER_TYPE": "G", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000019530F", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280199999", "TLRR_SE_REF_POA": "280199999754", "TLRR_SE_UNIT_NUMBER": "0000000044", "TLRR_SOC_AMOUNT": "000000053894I", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "525600", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "4468", "TLRR_AMEX_PAYEE_NUMBER": "1319999284", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1319999284", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371311XXXXX1006", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254G2626", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "2626", "TLRR_PAYMENT_NUMBER_TYPE": "G", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000553A", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "282111038", "TLRR_SE_REF_POA": "282111038235", "TLRR_SE_UNIT_NUMBER": "00STR#8082", "TLRR_SOC_AMOUNT": "000000015153G", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "548822", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "4468", "TLRR_AMEX_PAYEE_NUMBER": "1319999284", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1319999284", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371714XXXXX1003", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254G2626", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "2626", "TLRR_PAYMENT_NUMBER_TYPE": "G", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000653A", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "282111038", "TLRR_SE_REF_POA": "282111038231", "TLRR_SE_UNIT_NUMBER": "00STR#8082", "TLRR_SOC_AMOUNT": "000000015153G", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "502700", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "4468", "TLRR_AMEX_PAYEE_NUMBER": "1319999284", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "1319999284", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "372468XXXXX6007", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254G2626", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "2626", "TLRR_PAYMENT_NUMBER_TYPE": "G", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000013947E", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "282111038", "TLRR_SE_REF_POA": "282111038231", "TLRR_SE_UNIT_NUMBER": "00STR#8082", "TLRR_SOC_AMOUNT": "000000015153G", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "580200", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "7991", "TLRR_AMEX_PAYEE_NUMBER": "2049999582", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2049999582", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "372266XXXXX4008", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254M2653", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "2653", "TLRR_PAYMENT_NUMBER_TYPE": "M", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000018244{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "282111058", "TLRR_SE_REF_POA": "282111058413", "TLRR_SE_UNIT_NUMBER": "0000008063", "TLRR_SOC_AMOUNT": "000000018244{", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "", "TLRR_AMEX_PAYEE_NUMBER": "2049999873", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2049999873", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "375150XXXXX6014", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254M3251", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "3251", "TLRR_PAYMENT_NUMBER_TYPE": "M", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000000K", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280199667", "TLRR_SE_REF_POA": "280199667000", "TLRR_SE_UNIT_NUMBER": "000STR #62", "TLRR_SOC_AMOUNT": "000000000000{", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "", "TLRR_AMEX_PAYEE_NUMBER": "2049999873", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2049999873", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "375150XXXXX6014", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254M3251", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "3251", "TLRR_PAYMENT_NUMBER_TYPE": "M", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000000J", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "000601", "TLRR_SE_REF_POA": "000601", "TLRR_SE_UNIT_NUMBER": "000STR #62", "TLRR_SOC_AMOUNT": "000000000000{", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "601401", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "3811", "TLRR_AMEX_PAYEE_NUMBER": "2049999873", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2049999873", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "375150XXXXX6014", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254M3251", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "3251", "TLRR_PAYMENT_NUMBER_TYPE": "M", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000000A", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "000501", "TLRR_SE_REF_POA": "000501", "TLRR_SE_UNIT_NUMBER": "000STR #62", "TLRR_SOC_AMOUNT": "000000000000{", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "563866", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "3811", "TLRR_AMEX_PAYEE_NUMBER": "2049999873", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2049999873", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "375150XXXXX6014", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254M3251", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "3251", "TLRR_PAYMENT_NUMBER_TYPE": "M", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000000B", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280199667", "TLRR_SE_REF_POA": "280199667006", "TLRR_SE_UNIT_NUMBER": "000STR #62", "TLRR_SOC_AMOUNT": "000000000000{", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "498758", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1452", "TLRR_AMEX_PAYEE_NUMBER": "2069999156", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2069999156", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "375150XXXXX6011", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254G5069", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "5069", "TLRR_PAYMENT_NUMBER_TYPE": "G", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000417A", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280199762", "TLRR_SE_REF_POA": "280199762972", "TLRR_SE_UNIT_NUMBER": "000STR #18", "TLRR_SOC_AMOUNT": "000000010000H", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "523962", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1452", "TLRR_AMEX_PAYEE_NUMBER": "2069999156", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2069999156", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "372393XXXXX1003", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254G5069", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "5069", "TLRR_PAYMENT_NUMBER_TYPE": "G", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000538{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "365801", "TLRR_SE_REF_POA": "365801", "TLRR_SE_UNIT_NUMBER": "000STR #18", "TLRR_SOC_AMOUNT": "000000010000H", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "525827", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1452", "TLRR_AMEX_PAYEE_NUMBER": "2069999156", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2069999156", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "377284XXXXX1002", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254G5069", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "5069", "TLRR_PAYMENT_NUMBER_TYPE": "G", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000638{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "441301", "TLRR_SE_REF_POA": "441301", "TLRR_SE_UNIT_NUMBER": "000STR #18", "TLRR_SOC_AMOUNT": "000000010000H", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "532318", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1452", "TLRR_AMEX_PAYEE_NUMBER": "2069999156", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2069999156", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371384XXXXX4006", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254G5069", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "5069", "TLRR_PAYMENT_NUMBER_TYPE": "G", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000001504I", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "426701", "TLRR_SE_REF_POA": "426701", "TLRR_SE_UNIT_NUMBER": "000STR #18", "TLRR_SOC_AMOUNT": "000000010000H", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "547040", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1452", "TLRR_AMEX_PAYEE_NUMBER": "2069999156", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2069999156", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371576XXXXX2003", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254G5069", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "5069", "TLRR_PAYMENT_NUMBER_TYPE": "G", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000003340E", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280199762", "TLRR_SE_REF_POA": "280199762977", "TLRR_SE_UNIT_NUMBER": "000STR #18", "TLRR_SOC_AMOUNT": "000000010000H", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "584062", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1452", "TLRR_AMEX_PAYEE_NUMBER": "2069999156", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2069999156", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "379746XXXXX1001", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254G5069", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "5069", "TLRR_PAYMENT_NUMBER_TYPE": "G", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000003562C", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280199762", "TLRR_SE_REF_POA": "280199762971", "TLRR_SE_UNIT_NUMBER": "000STR #18", "TLRR_SOC_AMOUNT": "000000010000H", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "580387", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "7971", "TLRR_AMEX_PAYEE_NUMBER": "2199999562", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2199999562", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "379609XXXXX1009", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254I0352", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "0352", "TLRR_PAYMENT_NUMBER_TYPE": "I", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000847I", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "282111147", "TLRR_SE_REF_POA": "282111147390", "TLRR_SE_UNIT_NUMBER": "00STR#8060", "TLRR_SOC_AMOUNT": "000000015301H", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "561818", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "7971", "TLRR_AMEX_PAYEE_NUMBER": "2199999562", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2199999562", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "376750XXXXX3004", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254I0352", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "0352", "TLRR_PAYMENT_NUMBER_TYPE": "I", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000001165H", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "282111147", "TLRR_SE_REF_POA": "282111147390", "TLRR_SE_UNIT_NUMBER": "00STR#8060", "TLRR_SOC_AMOUNT": "000000015301H", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "543638", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "7971", "TLRR_AMEX_PAYEE_NUMBER": "2199999562", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2199999562", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "379741XXXXX1017", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254I0352", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "0352", "TLRR_PAYMENT_NUMBER_TYPE": "I", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000004229D", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "282111147", "TLRR_SE_REF_POA": "282111147394", "TLRR_SE_UNIT_NUMBER": "00STR#8060", "TLRR_SOC_AMOUNT": "000000015301H", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "515443", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "7971", "TLRR_AMEX_PAYEE_NUMBER": "2199999562", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2199999562", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "377266XXXXX5000", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254I0352", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "0352", "TLRR_PAYMENT_NUMBER_TYPE": "I", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000004229D", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "282111147", "TLRR_SE_REF_POA": "282111147394", "TLRR_SE_UNIT_NUMBER": "00STR#8060", "TLRR_SOC_AMOUNT": "000000015301H", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "549787", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "7971", "TLRR_AMEX_PAYEE_NUMBER": "2199999562", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2199999562", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "379765XXXXX2002", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254I0352", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "0352", "TLRR_PAYMENT_NUMBER_TYPE": "I", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000004829C", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "282111147", "TLRR_SE_REF_POA": "282111147394", "TLRR_SE_UNIT_NUMBER": "00STR#8060", "TLRR_SOC_AMOUNT": "000000015301H", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "540439", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "4527", "TLRR_AMEX_PAYEE_NUMBER": "2199999169", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2199999169", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371550XXXXX3029", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254I0383", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "0383", "TLRR_PAYMENT_NUMBER_TYPE": "I", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000847I", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "282111060", "TLRR_SE_REF_POA": "282111060207", "TLRR_SE_UNIT_NUMBER": "0Str #8085", "TLRR_SOC_AMOUNT": "000000000847I", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "", "TLRR_AMEX_PAYEE_NUMBER": "2299999656", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2299999656", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "377235XXXXX1004", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254L1705", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1705", "TLRR_PAYMENT_NUMBER_TYPE": "L", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000270J", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280199786", "TLRR_SE_REF_POA": "280199786008", "TLRR_SE_UNIT_NUMBER": "0000000022", "TLRR_SOC_AMOUNT": "000000019338A", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "586920", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1269", "TLRR_AMEX_PAYEE_NUMBER": "2299999656", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2299999656", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "379754XXXXX1009", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254L1705", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1705", "TLRR_PAYMENT_NUMBER_TYPE": "L", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000641E", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280199786", "TLRR_SE_REF_POA": "280199786352", "TLRR_SE_UNIT_NUMBER": "0000000022", "TLRR_SOC_AMOUNT": "000000019338A", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "174917", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1269", "TLRR_AMEX_PAYEE_NUMBER": "2299999656", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2299999656", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "374327XXXXX8021", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254L1705", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1705", "TLRR_PAYMENT_NUMBER_TYPE": "L", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000001000{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "347404", "TLRR_SE_REF_POA": "347404", "TLRR_SE_UNIT_NUMBER": "0000000022", "TLRR_SOC_AMOUNT": "000000019338A", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "587625", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1269", "TLRR_AMEX_PAYEE_NUMBER": "2299999656", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2299999656", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "374182XXXXX1005", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254L1705", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1705", "TLRR_PAYMENT_NUMBER_TYPE": "L", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000002199I", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280199786", "TLRR_SE_REF_POA": "280199786360", "TLRR_SE_UNIT_NUMBER": "0000000022", "TLRR_SOC_AMOUNT": "000000019338A", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "513970", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1269", "TLRR_AMEX_PAYEE_NUMBER": "2299999656", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2299999656", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "372819XXXXX1019", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254L1705", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1705", "TLRR_PAYMENT_NUMBER_TYPE": "L", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000003686F", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280199859", "TLRR_SE_REF_POA": "280199859529", "TLRR_SE_UNIT_NUMBER": "0000000022", "TLRR_SOC_AMOUNT": "000000019338A", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "515287", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1269", "TLRR_AMEX_PAYEE_NUMBER": "2299999656", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2299999656", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371275XXXXX3006", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254L1705", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1705", "TLRR_PAYMENT_NUMBER_TYPE": "L", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000012080B", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280199786", "TLRR_SE_REF_POA": "280199786361", "TLRR_SE_UNIT_NUMBER": "0000000022", "TLRR_SOC_AMOUNT": "000000019338A", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "", "TLRR_AMEX_PAYEE_NUMBER": "2299999510", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2299999510", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371708XXXXX1000", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254L1727", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1727", "TLRR_PAYMENT_NUMBER_TYPE": "L", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000716R", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280199871", "TLRR_SE_REF_POA": "280199871009", "TLRR_SE_UNIT_NUMBER": "0000000023", "TLRR_SOC_AMOUNT": "000000088407D", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "", "TLRR_AMEX_PAYEE_NUMBER": "2299999510", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2299999510", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371708XXXXX1000", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254L1727", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1727", "TLRR_PAYMENT_NUMBER_TYPE": "L", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000024O", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280199871", "TLRR_SE_REF_POA": "280199871009", "TLRR_SE_UNIT_NUMBER": "0000000023", "TLRR_SOC_AMOUNT": "000000088407D", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "586705", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1429", "TLRR_AMEX_PAYEE_NUMBER": "2299999510", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2299999510", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371573XXXXX2015", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254L1727", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1727", "TLRR_PAYMENT_NUMBER_TYPE": "L", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000524C", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "473701", "TLRR_SE_REF_POA": "473701", "TLRR_SE_UNIT_NUMBER": "0000000023", "TLRR_SOC_AMOUNT": "000000088407D", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "362224", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1429", "TLRR_AMEX_PAYEE_NUMBER": "2299999510", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2299999510", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "374350XXXXX7246", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254L1727", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1727", "TLRR_PAYMENT_NUMBER_TYPE": "L", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000534I", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "474101", "TLRR_SE_REF_POA": "474101", "TLRR_SE_UNIT_NUMBER": "0000000023", "TLRR_SOC_AMOUNT": "000000088407D", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "508748", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1429", "TLRR_AMEX_PAYEE_NUMBER": "2299999510", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2299999510", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371717XXXXX2000", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254L1727", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1727", "TLRR_PAYMENT_NUMBER_TYPE": "L", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000541I", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280199871", "TLRR_SE_REF_POA": "280199871073", "TLRR_SE_UNIT_NUMBER": "0000000023", "TLRR_SOC_AMOUNT": "000000088407D", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "561666", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1429", "TLRR_AMEX_PAYEE_NUMBER": "2299999510", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2299999510", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "379740XXXXX1001", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254L1727", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1727", "TLRR_PAYMENT_NUMBER_TYPE": "L", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000001283I", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280199685", "TLRR_SE_REF_POA": "280199685814", "TLRR_SE_UNIT_NUMBER": "0000000023", "TLRR_SOC_AMOUNT": "000000088407D", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "561668", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1429", "TLRR_AMEX_PAYEE_NUMBER": "2299999510", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2299999510", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371519XXXXX3006", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254L1727", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1727", "TLRR_PAYMENT_NUMBER_TYPE": "L", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000003734C", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280199871", "TLRR_SE_REF_POA": "280199871073", "TLRR_SE_UNIT_NUMBER": "0000000023", "TLRR_SOC_AMOUNT": "000000088407D", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "506168", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1429", "TLRR_AMEX_PAYEE_NUMBER": "2299999510", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2299999510", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "377257XXXXX1016", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254L1727", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1727", "TLRR_PAYMENT_NUMBER_TYPE": "L", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000007694D", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280199685", "TLRR_SE_REF_POA": "280199685816", "TLRR_SE_UNIT_NUMBER": "0000000023", "TLRR_SOC_AMOUNT": "000000088407D", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "586693", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1429", "TLRR_AMEX_PAYEE_NUMBER": "2299999510", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2299999510", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "372723XXXXX1007", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254L1727", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1727", "TLRR_PAYMENT_NUMBER_TYPE": "L", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000021913E", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280199871", "TLRR_SE_REF_POA": "280199871073", "TLRR_SE_UNIT_NUMBER": "0000000023", "TLRR_SOC_AMOUNT": "000000088407D", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "503212", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1429", "TLRR_AMEX_PAYEE_NUMBER": "2299999510", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2299999510", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371576XXXXX6010", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254L1727", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1727", "TLRR_PAYMENT_NUMBER_TYPE": "L", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000052921G", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280199685", "TLRR_SE_REF_POA": "280199685817", "TLRR_SE_UNIT_NUMBER": "0000000023", "TLRR_SOC_AMOUNT": "000000088407D", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "", "TLRR_AMEX_PAYEE_NUMBER": "2299999979", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2299999979", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "379725XXXXX1006", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254L2581", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "2581", "TLRR_PAYMENT_NUMBER_TYPE": "L", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000009940K", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "053401", "TLRR_SE_REF_POA": "053401", "TLRR_SE_UNIT_NUMBER": "0000000055", "TLRR_SOC_AMOUNT": "000000019230C", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "", "TLRR_AMEX_PAYEE_NUMBER": "2299999979", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2299999979", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "378267XXXXX2029", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254L2581", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "2581", "TLRR_PAYMENT_NUMBER_TYPE": "L", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000009084L", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280280210", "TLRR_SE_REF_POA": "280280210003", "TLRR_SE_UNIT_NUMBER": "0000000055", "TLRR_SOC_AMOUNT": "000000019230C", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "", "TLRR_AMEX_PAYEE_NUMBER": "2299999979", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2299999979", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "378267XXXXX2029", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254L2581", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "2581", "TLRR_PAYMENT_NUMBER_TYPE": "L", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000004793O", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280280210", "TLRR_SE_REF_POA": "280280210003", "TLRR_SE_UNIT_NUMBER": "0000000055", "TLRR_SOC_AMOUNT": "000000019230C", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "557387", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "9727", "TLRR_AMEX_PAYEE_NUMBER": "2299999979", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2299999979", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "379761XXXXX1003", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254L2581", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "2581", "TLRR_PAYMENT_NUMBER_TYPE": "L", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000441I", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280280210", "TLRR_SE_REF_POA": "280280210033", "TLRR_SE_UNIT_NUMBER": "0000000055", "TLRR_SOC_AMOUNT": "000000019230C", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "541814", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "9727", "TLRR_AMEX_PAYEE_NUMBER": "2299999979", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2299999979", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "372502XXXXX8001", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254L2581", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "2581", "TLRR_PAYMENT_NUMBER_TYPE": "L", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000534I", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "057801", "TLRR_SE_REF_POA": "057801", "TLRR_SE_UNIT_NUMBER": "0000000055", "TLRR_SOC_AMOUNT": "000000019230C", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "583957", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "9727", "TLRR_AMEX_PAYEE_NUMBER": "2299999979", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2299999979", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371545XXXXX4001", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254L2581", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "2581", "TLRR_PAYMENT_NUMBER_TYPE": "L", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000001594C", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "072601", "TLRR_SE_REF_POA": "072601", "TLRR_SE_UNIT_NUMBER": "0000000055", "TLRR_SOC_AMOUNT": "000000019230C", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "582381", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "9727", "TLRR_AMEX_PAYEE_NUMBER": "2299999979", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2299999979", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "372579XXXXX6008", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254L2581", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "2581", "TLRR_PAYMENT_NUMBER_TYPE": "L", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000001605{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280200001", "TLRR_SE_REF_POA": "280200001957", "TLRR_SE_UNIT_NUMBER": "0000000055", "TLRR_SOC_AMOUNT": "000000019230C", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "524617", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "9727", "TLRR_AMEX_PAYEE_NUMBER": "2299999979", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2299999979", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371538XXXXX4005", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254L2581", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "2581", "TLRR_PAYMENT_NUMBER_TYPE": "L", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000002084D", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "087801", "TLRR_SE_REF_POA": "087801", "TLRR_SE_UNIT_NUMBER": "0000000055", "TLRR_SOC_AMOUNT": "000000019230C", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "522581", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "9727", "TLRR_AMEX_PAYEE_NUMBER": "2299999979", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2299999979", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "378200XXXXX9009", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254L2581", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "2581", "TLRR_PAYMENT_NUMBER_TYPE": "L", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000003423G", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "066301", "TLRR_SE_REF_POA": "066301", "TLRR_SE_UNIT_NUMBER": "0000000055", "TLRR_SOC_AMOUNT": "000000019230C", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "587305", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "9727", "TLRR_AMEX_PAYEE_NUMBER": "2299999979", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2299999979", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371538XXXXX4005", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254L2581", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "2581", "TLRR_PAYMENT_NUMBER_TYPE": "L", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000004323I", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "087701", "TLRR_SE_REF_POA": "087701", "TLRR_SE_UNIT_NUMBER": "0000000055", "TLRR_SOC_AMOUNT": "000000019230C", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "521377", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "9727", "TLRR_AMEX_PAYEE_NUMBER": "2299999979", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2299999979", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "379717XXXXX3007", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254L2581", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "2581", "TLRR_PAYMENT_NUMBER_TYPE": "L", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000007549C", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280200001", "TLRR_SE_REF_POA": "280200001954", "TLRR_SE_UNIT_NUMBER": "0000000055", "TLRR_SOC_AMOUNT": "000000019230C", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "585278", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "9727", "TLRR_AMEX_PAYEE_NUMBER": "2299999979", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2299999979", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371246XXXXX3009", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254L2581", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "2581", "TLRR_PAYMENT_NUMBER_TYPE": "L", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000021491{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280280210", "TLRR_SE_REF_POA": "280280210045", "TLRR_SE_UNIT_NUMBER": "0000000055", "TLRR_SOC_AMOUNT": "000000019230C", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "575009", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "7990", "TLRR_AMEX_PAYEE_NUMBER": "2379999582", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2379999582", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "374355XXXXX9403", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254L8733", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "8733", "TLRR_PAYMENT_NUMBER_TYPE": "L", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000003269C", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "282111158", "TLRR_SE_REF_POA": "282111158375", "TLRR_SE_UNIT_NUMBER": "0000008062", "TLRR_SOC_AMOUNT": "000000003269C", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "109064", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "5802", "TLRR_AMEX_PAYEE_NUMBER": "2429999649", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999649", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "376449XXXXX4001", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254C6019", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "6019", "TLRR_PAYMENT_NUMBER_TYPE": "C", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000020C", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS0081LWL", "TLRR_SE_REF_POA": "PS0081LWLQT1", "TLRR_SE_UNIT_NUMBER": "2420622649", "TLRR_SOC_AMOUNT": "000000000020C", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "141860", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8269", "TLRR_AMEX_PAYEE_NUMBER": "2429999763", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999763", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "376669XXXXX2009", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254C6020", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "6020", "TLRR_PAYMENT_NUMBER_TYPE": "C", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000720{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS00EXHVR", "TLRR_SE_REF_POA": "PS00EXHVRW42", "TLRR_SE_UNIT_NUMBER": "2420622763", "TLRR_SOC_AMOUNT": "000000000720{", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "940338", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8442", "TLRR_AMEX_PAYEE_NUMBER": "2429999789", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999789", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "377752XXXXX7402", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254C6021", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "6021", "TLRR_PAYMENT_NUMBER_TYPE": "C", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000150{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS006Q0JS", "TLRR_SE_REF_POA": "PS006Q0JSKJD", "TLRR_SE_UNIT_NUMBER": "2420622789", "TLRR_SOC_AMOUNT": "000000000150{", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "181588", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8756", "TLRR_AMEX_PAYEE_NUMBER": "2429999938", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999938", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371043XXXXX1004", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254C6022", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "6022", "TLRR_PAYMENT_NUMBER_TYPE": "C", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000001605{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS0082W7N", "TLRR_SE_REF_POA": "PS0082W7NVPB", "TLRR_SE_UNIT_NUMBER": "2420622938", "TLRR_SOC_AMOUNT": "000000001605{", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "378533XXXXX4004", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000017546R", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS00F9T4E", "TLRR_SE_REF_POA": "PS00F9T4E33B", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000038410}", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014253", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371242XXXXX1009", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000017212N", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS00EPET5", "TLRR_SE_REF_POA": "PS00EPET5NPC", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000038410}", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014253", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "378533XXXXX4004", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000002881J", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS00F92NS", "TLRR_SE_REF_POA": "PS00F92NSJFP", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000038410}", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014253", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "372717XXXXX4007", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000001583R", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS010D3EP", "TLRR_SE_REF_POA": "PS010D3EP58E", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000038410}", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014253", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "376750XXXXX4007", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000001200}", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS00FBTW2", "TLRR_SE_REF_POA": "PS00FBTW2HWC", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000038410}", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014253", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "378533XXXXX4004", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000001090P", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS00F9T4E", "TLRR_SE_REF_POA": "PS00F9T4E33C", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000038410}", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014253", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371554XXXXX1006", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000534K", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS00E7L58", "TLRR_SE_REF_POA": "PS00E7L58OEH", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000038410}", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014253", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "378533XXXXX4004", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000523Q", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS00F92NS", "TLRR_SE_REF_POA": "PS00F92NSJFO", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000038410}", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014253", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371332XXXXX5001", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000423N", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS00FH5PQ", "TLRR_SE_REF_POA": "PS00FH5PQT6A", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000038410}", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014253", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "372738XXXXX1007", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000309P", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS00ACUL7", "TLRR_SE_REF_POA": "PS00ACUL767H", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000038410}", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014253", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "378533XXXXX4004", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000259M", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS00F9T4E", "TLRR_SE_REF_POA": "PS00F9T4E339", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000038410}", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014253", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "376741XXXXX1008", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000174K", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS009VKQU", "TLRR_SE_REF_POA": "PS009VKQUG3N", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000038410}", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014253", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "378533XXXXX4004", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000049L", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS00F9T4E", "TLRR_SE_REF_POA": "PS00F9T4E338", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000038410}", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014253", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371243XXXXX1004", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000042O", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS01NFOF2", "TLRR_SE_REF_POA": "PS01NFOF2QON", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000038410}", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014253", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371568XXXXX1005", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000024P", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS00B4YPN", "TLRR_SE_REF_POA": "PS00B4YPNE07", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000038410}", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014253", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "376741XXXXX1008", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000010L", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS009VKQU", "TLRR_SE_REF_POA": "PS009VKQUG3O", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000038410}", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014253", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "378533XXXXX4004", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000006}", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS00F9T4E", "TLRR_SE_REF_POA": "PS00F9T4E33A", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000038410}", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014253", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "127944", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "372322XXXXX3052", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000290{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS007Z1AH", "TLRR_SE_REF_POA": "PS007Z1AHMJY", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000038410}", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014253", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "158316", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "378750XXXXX1015", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000005172H", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS007XQZG", "TLRR_SE_REF_POA": "PS007XQZG6R0", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000038410}", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014253", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "376732XXXXX1005", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000017237L", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS00SRNVY", "TLRR_SE_REF_POA": "PS00SRNVYTES", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000017747L", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014253", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "378342XXXXX1000", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000800}", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS00AIJND", "TLRR_SE_REF_POA": "PS00AIJNDRRC", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000017747L", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014253", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "131541", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "372734XXXXX1022", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000290{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS00EGENT", "TLRR_SE_REF_POA": "PS00EGENTPY0", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000017747L", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014253", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "378750XXXXX1025", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000011473N", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS03LTICQ", "TLRR_SE_REF_POA": "PS03LTICQE6D", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000011193N", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014253", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "180572", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "378204XXXXX3008", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000280{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS0072IDZ", "TLRR_SE_REF_POA": "PS0072IDZAOL", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000011193N", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014253", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "379601XXXXX1003", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000002409}", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS007AEUF", "TLRR_SE_REF_POA": "PS007AEUFFNO", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000004377P", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014253", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371550XXXXX4000", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000001460R", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS00AH9DS", "TLRR_SE_REF_POA": "PS00AH9DSTGJ", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000004377P", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014253", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371244XXXXX1009", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000581O", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS007H7LY", "TLRR_SE_REF_POA": "PS007H7LYQN5", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000004377P", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014253", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "372719XXXXX1026", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000375O", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS00D3W8Q", "TLRR_SE_REF_POA": "PS00D3W8QCOB", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000004377P", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014253", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371731XXXXX1003", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000072}", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS00GDBDY", "TLRR_SE_REF_POA": "PS00GDBDY2IP", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000004377P", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014253", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371327XXXXX2004", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000061R", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS00EN0T8", "TLRR_SE_REF_POA": "PS00EN0T8BGU", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000004377P", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014253", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "374716XXXXX7955", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000054K", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS0081Z4W", "TLRR_SE_REF_POA": "PS0081Z4WN5V", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000004377P", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014253", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "735312", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "374716XXXXX8338", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000637E", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS007SYZK", "TLRR_SE_REF_POA": "PS007SYZKLS0", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000004377P", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014253", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "378752XXXXX1132", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000001590M", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS009WB7Q", "TLRR_SE_REF_POA": "PS009WB7QVHA", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000000968L", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014253", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "372714XXXXX1033", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000001200}", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS007V6DC", "TLRR_SE_REF_POA": "PS007V6DCGZM", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000000968L", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014253", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "377221XXXXX2001", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000159}", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS0065M98", "TLRR_SE_REF_POA": "PS0065M98XXM", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000000968L", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014253", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371553XXXXX2004", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000102}", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS00ATXT4", "TLRR_SE_REF_POA": "PS00ATXT48IT", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000000968L", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014253", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "163670", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "378299XXXXX1070", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000160{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS008AFFS", "TLRR_SE_REF_POA": "PS008AFFSUMZ", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000000968L", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014253", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "186512", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "379614XXXXX2003", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000290{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS0089ID1", "TLRR_SE_REF_POA": "PS0089ID1T0M", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000000968L", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014253", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "125235", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371538XXXXX6002", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000001633A", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS006YGUO", "TLRR_SE_REF_POA": "PS006YGUOX8Z", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000000968L", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014253", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "185572", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "378298XXXXX1145", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000051F", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS006663M", "TLRR_SE_REF_POA": "PS006663M9D5", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000000051F", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014253", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "379611XXXXX1005", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000990}", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS008Z1VL", "TLRR_SE_REF_POA": "PS008Z1VLVZ2", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000001980}", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014253", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "379611XXXXX1005", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000990}", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS008Z1VL", "TLRR_SE_REF_POA": "PS008Z1VLVZ3", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000001980}", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014253", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "100418", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "376733XXXXX1004", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000240{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS0070O8J", "TLRR_SE_REF_POA": "PS0070O8JRKT", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000000913D", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014253", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "165875", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371739XXXXX1002", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000673D", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS008WH84", "TLRR_SE_REF_POA": "PS008WH8464N", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000000913D", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014253", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "182391", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "379626XXXXX1001", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000115A", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS00IVWQ6", "TLRR_SE_REF_POA": "PS00IVWQ67XR", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000006915A", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014253", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "142943", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "378262XXXXX7035", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000400{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS007MWOM", "TLRR_SE_REF_POA": "PS007MWOM9H9", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000006915A", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014253", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "113170", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "373278XXXXX2009", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000006400{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS007CSUD", "TLRR_SE_REF_POA": "PS007CSUD824", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000006915A", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014253", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "161259", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "372714XXXXX3008", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000003411{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS00846IP", "TLRR_SE_REF_POA": "PS00846IP4WZ", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000003411{", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371739XXXXX1005", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000175N", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS00DBSOH", "TLRR_SE_REF_POA": "PS00DBSOHI6Q", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000000212Q", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "372584XXXXX1000", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000020}", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS009DKG1", "TLRR_SE_REF_POA": "PS009DKG10RW", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000000212Q", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "372714XXXXX4006", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000017L", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS00XG62W", "TLRR_SE_REF_POA": "PS00XG62W1OG", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000000212Q", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "381041", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "372741XXXXX3986", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000150{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS00LUUTA", "TLRR_SE_REF_POA": "PS00LUUTAQNH", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000038992H", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "162986", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "376740XXXXX2026", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000250{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS0073SP1", "TLRR_SE_REF_POA": "PS0073SP1UBK", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000038992H", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "181100", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371710XXXXX1007", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000290{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS00B4S3M", "TLRR_SE_REF_POA": "PS00B4S3MZSR", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000038992H", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "180357", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "377279XXXXX1004", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000290{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS009M0R0", "TLRR_SE_REF_POA": "PS009M0R0O9K", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000038992H", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "115062", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "379616XXXXX2008", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000290{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS00DBM30", "TLRR_SE_REF_POA": "PS00DBM30MN7", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000038992H", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "122761", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371542XXXXX5019", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000290{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS00CJV6K", "TLRR_SE_REF_POA": "PS00CJV6KZNJ", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000038992H", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "155332", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "372712XXXXX5006", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000290{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS00AI6F3", "TLRR_SE_REF_POA": "PS00AI6F3CCN", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000038992H", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "100718", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "372269XXXXX3003", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000290{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS00GTO5J", "TLRR_SE_REF_POA": "PS00GTO5JK16", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000038992H", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "123263", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "376761XXXXX3002", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000290{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS00GBNV8", "TLRR_SE_REF_POA": "PS00GBNV82MM", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000038992H", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "143441", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "379625XXXXX1001", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000313I", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS00W4XYS", "TLRR_SE_REF_POA": "PS00W4XYSB5Z", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000038992H", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "168130", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "372723XXXXX1009", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000313I", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS00BTEL0", "TLRR_SE_REF_POA": "PS00BTEL0M8K", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000038992H", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "102448", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371558XXXXX1001", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000328{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS00ET340", "TLRR_SE_REF_POA": "PS00ET340CAG", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000038992H", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "133960", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "379748XXXXX1004", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000360{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS00DWK8A", "TLRR_SE_REF_POA": "PS00DWK8AZHW", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000038992H", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "161072", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "378262XXXXX7035", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000397D", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS007MWOM", "TLRR_SE_REF_POA": "PS007MWOM9EX", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000038992H", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "163736", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371546XXXXX3004", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000438{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS007OQU4", "TLRR_SE_REF_POA": "PS007OQU468S", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000038992H", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "180567", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "379748XXXXX1004", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000440{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS00DWK8A", "TLRR_SE_REF_POA": "PS00DWK8AZHU", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000038992H", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "184394", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "372727XXXXX1001", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000001132I", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS007HRGF", "TLRR_SE_REF_POA": "PS007HRGF4J1", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000038992H", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "134343", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371537XXXXX6007", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000001492D", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS006IAPI", "TLRR_SE_REF_POA": "PS006IAPIBWD", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000038992H", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "151186", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371736XXXXX3002", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000001500{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS003ZC5I", "TLRR_SE_REF_POA": "PS003ZC5ITAA", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000038992H", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "214563", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "370291XXXXX1004", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000003000{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS00GDI03", "TLRR_SE_REF_POA": "PS00GDI03G6K", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000038992H", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "122482", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "372719XXXXX1038", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000003000{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS00SRNVY", "TLRR_SE_REF_POA": "PS00SRNVYT8P", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000038992H", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "115983", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "378209XXXXX5009", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000003054H", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS04WYBQT", "TLRR_SE_REF_POA": "PS04WYBQTFWG", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000038992H", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "101994", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371555XXXXX2007", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000003480{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS007NN3I", "TLRR_SE_REF_POA": "PS007NN3IJZC", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000038992H", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "160314", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "378298XXXXX2035", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000017311E", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS00EU6TN", "TLRR_SE_REF_POA": "PS00EU6TNODU", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000038992H", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "161974", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "378292XXXXX2076", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000002H", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS006WTBC", "TLRR_SE_REF_POA": "PS006WTBC4KQ", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000120549I", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "160128", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "379729XXXXX1000", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000005A", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS006YGUO", "TLRR_SE_REF_POA": "PS006YGUOOUQ", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000120549I", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "126046", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "377218XXXXX3005", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000025{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS007KIOO", "TLRR_SE_REF_POA": "PS007KIOOYH1", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000120549I", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "123284", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "377214XXXXX3004", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000025{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS007Z1AI", "TLRR_SE_REF_POA": "PS007Z1AI7A4", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000120549I", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "144557", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "376740XXXXX1076", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000030{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS007CSUE", "TLRR_SE_REF_POA": "PS007CSUEZLD", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000120549I", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "338009", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "374355XXXXX0609", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000040{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS004IZZE", "TLRR_SE_REF_POA": "PS004IZZEWRL", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000120549I", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "136132", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "377275XXXXX3001", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000040{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS0078KOX", "TLRR_SE_REF_POA": "PS0078KOXBCC", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000120549I", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "775310", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "374322XXXXX0129", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000040{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS007XQZG", "TLRR_SE_REF_POA": "PS007XQZG6NJ", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000120549I", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "165020", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "372716XXXXX6002", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000046D", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS005VP13", "TLRR_SE_REF_POA": "PS005VP135LY", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000120549I", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "101260", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "378269XXXXX3002", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000046E", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS003K9P3", "TLRR_SE_REF_POA": "PS003K9P3TCO", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000120549I", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "145039", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "372725XXXXX1007", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000053C", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS007PHAP", "TLRR_SE_REF_POA": "PS007PHAP4XL", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000120549I", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "155184", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "372719XXXXX1014", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000063F", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS005Y311", "TLRR_SE_REF_POA": "PS005Y311DCK", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000120549I", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "191937", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "379624XXXXX1001", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000070{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS007ALGK", "TLRR_SE_REF_POA": "PS007ALGKUBN", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000120549I", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "164435", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "379727XXXXX1007", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000075{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS0074WDX", "TLRR_SE_REF_POA": "PS0074WDX9TB", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000120549I", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "143475", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "378367XXXXX7000", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000080{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS007UZPR", "TLRR_SE_REF_POA": "PS007UZPRMF8", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000120549I", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "121705", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "373270XXXXX3007", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000080{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS006Z7BA", "TLRR_SE_REF_POA": "PS006Z7BAR2B", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000120549I", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "109768", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371556XXXXX1005", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000120{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS00JS90D", "TLRR_SE_REF_POA": "PS00JS90D544", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000120549I", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "146443", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371554XXXXX1215", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000125{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS007MWOM", "TLRR_SE_REF_POA": "PS007MWOM3G5", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000120549I", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "178654", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "378750XXXXX1372", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000125{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS0072BRT", "TLRR_SE_REF_POA": "PS0072BRTTDW", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000120549I", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "183819", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371557XXXXX1001", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000130{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS00A4Y4H", "TLRR_SE_REF_POA": "PS00A4Y4HCPO", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000120549I", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "864720", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "372741XXXXX0482", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000130{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS0073M2V", "TLRR_SE_REF_POA": "PS0073M2VLQS", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000120549I", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "133544", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371315XXXXX5004", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000130I", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS00804ZF", "TLRR_SE_REF_POA": "PS00804ZF2F2", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000120549I", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "165512", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "376730XXXXX4018", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000132H", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS0078XX7", "TLRR_SE_REF_POA": "PS0078XX7VKU", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000120549I", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "115061", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371723XXXXX3004", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000150{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS007MWOM", "TLRR_SE_REF_POA": "PS007MWOM3G7", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000120549I", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "198958", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371551XXXXX3009", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000160{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS008HLFM", "TLRR_SE_REF_POA": "PS008HLFMXAU", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000120549I", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "165049", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "373274XXXXX2032", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000162I", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS007VWTY", "TLRR_SE_REF_POA": "PS007VWTY36V", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000120549I", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "146794", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371332XXXXX4007", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000180{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS007NN58", "TLRR_SE_REF_POA": "PS007NN58MFI", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000120549I", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "142953", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "376740XXXXX4008", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000200{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS0078KOX", "TLRR_SE_REF_POA": "PS0078KOXBCB", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000120549I", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "141841", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371553XXXXX1005", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000200{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS00CWD0L", "TLRR_SE_REF_POA": "PS00CWD0L3W1", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000120549I", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "104382", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "372765XXXXX4006", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000200{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS007HRGF", "TLRR_SE_REF_POA": "PS007HRGF4IW", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000120549I", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "156584", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "378205XXXXX3008", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000212E", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS006YGUO", "TLRR_SE_REF_POA": "PS006YGUOX5R", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000120549I", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "129549", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "372521XXXXX4001", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000240{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS0040MGF", "TLRR_SE_REF_POA": "PS0040MGFH0K", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000120549I", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "166874", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371282XXXXX5009", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000240{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS0069NSJ", "TLRR_SE_REF_POA": "PS0069NSJGNH", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000120549I", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "184843", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "378750XXXXX1019", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000266E", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS003OV2V", "TLRR_SE_REF_POA": "PS003OV2V2DS", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000120549I", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "153376", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "379626XXXXX2008", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000280{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS00745XC", "TLRR_SE_REF_POA": "PS00745XC10I", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000120549I", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "169058", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371740XXXXX1005", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000290{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS00EAPL1", "TLRR_SE_REF_POA": "PS00EAPL1UBZ", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000120549I", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "168604", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "378298XXXXX1037", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000290{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS007UFVH", "TLRR_SE_REF_POA": "PS007UFVHWSR", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000120549I", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "126130", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "376741XXXXX1031", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000290{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS00F166L", "TLRR_SE_REF_POA": "PS00F166LOGQ", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000120549I", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "187869", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "379219XXXXX1006", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000290{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS009PVOD", "TLRR_SE_REF_POA": "PS009PVODG6J", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000120549I", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "161982", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371246XXXXX5004", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000290{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS00DKM8J", "TLRR_SE_REF_POA": "PS00DKM8J25P", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000120549I", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "160250", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "378208XXXXX1046", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000290{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS00TS8BS", "TLRR_SE_REF_POA": "PS00TS8BSSNB", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000120549I", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "196711", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "373274XXXXX7002", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000292I", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS00DYRLH", "TLRR_SE_REF_POA": "PS00DYRLHMR9", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000120549I", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "161266", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371386XXXXX3003", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000330{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS006LLS9", "TLRR_SE_REF_POA": "PS006LLS9TQ8", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000120549I", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "123829", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371248XXXXX1000", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000360{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS007L959", "TLRR_SE_REF_POA": "PS007L959FZG", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000120549I", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "145765", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371714XXXXX6038", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000400{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS0081Z4W", "TLRR_SE_REF_POA": "PS0081Z4WV3B", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000120549I", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "160836", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371535XXXXX2007", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000400{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS007LFRF", "TLRR_SE_REF_POA": "PS007LFRF3ZN", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000120549I", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "102554", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371535XXXXX2060", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000406E", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS00QQPMJ", "TLRR_SE_REF_POA": "PS00QQPMJNFI", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000120549I", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "115845", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "372762XXXXX6006", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000426D", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS007T5LQ", "TLRR_SE_REF_POA": "PS007T5LQMXH", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000120549I", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "188267", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "372713XXXXX1735", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000480{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS007MCU5", "TLRR_SE_REF_POA": "PS007MCU5Y8A", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000120549I", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "122750", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "372575XXXXX2002", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000480{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS006D5HB", "TLRR_SE_REF_POA": "PS006D5HBVT8", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000120549I", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "122798", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "372716XXXXX4094", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000586H", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS00IOK40", "TLRR_SE_REF_POA": "PS00IOK402VN", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000120549I", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "123503", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "376733XXXXX1000", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000600{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS006DPBR", "TLRR_SE_REF_POA": "PS006DPBRKT0", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000120549I", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "197372", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "372581XXXXX1003", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000600{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS004A6GC", "TLRR_SE_REF_POA": "PS004A6GCHC9", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000120549I", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "113605", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371757XXXXX2001", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000600{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS007C2DS", "TLRR_SE_REF_POA": "PS007C2DS1L3", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000120549I", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "103212", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "372321XXXXX1000", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000629G", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS007AYOV", "TLRR_SE_REF_POA": "PS007AYOVFV4", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000120549I", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "163619", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "378266XXXXX7004", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000639F", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS00DT94Z", "TLRR_SE_REF_POA": "PS00DT94ZGZ8", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000120549I", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "101661", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371702XXXXX3001", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000651H", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS008KCNV", "TLRR_SE_REF_POA": "PS008KCNVG4T", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000120549I", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "108934", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371739XXXXX3005", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000691E", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS00F57QO", "TLRR_SE_REF_POA": "PS00F57QO15Y", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000120549I", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "127848", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371535XXXXX2045", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000840{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS013EFHD", "TLRR_SE_REF_POA": "PS013EFHDGHL", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000120549I", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "147274", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371716XXXXX5000", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000875{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS007BP5I", "TLRR_SE_REF_POA": "PS007BP5IXG2", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000120549I", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "169318", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "373956XXXXX1006", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000925H", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS006SL5W", "TLRR_SE_REF_POA": "PS006SL5WH65", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000120549I", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "164251", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "378262XXXXX1009", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000960{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS007AYOW", "TLRR_SE_REF_POA": "PS007AYOWE00", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000120549I", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "192655", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371557XXXXX2016", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000960{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS007DWJA", "TLRR_SE_REF_POA": "PS007DWJAJ4F", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000120549I", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "144489", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "376751XXXXX1003", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000001000{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS007CSUD", "TLRR_SE_REF_POA": "PS007CSUD0AC", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000120549I", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "162970", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371554XXXXX2107", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000001095{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS0047LU4", "TLRR_SE_REF_POA": "PS0047LU4R1J", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000120549I", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "105160", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371559XXXXX1017", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000001095{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS008DJWC", "TLRR_SE_REF_POA": "PS008DJWC29W", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000120549I", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "145075", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "376751XXXXX3001", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000001121A", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS00A2DID", "TLRR_SE_REF_POA": "PS00A2DIDOA3", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000120549I", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "167270", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "379624XXXXX1001", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000001440{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS00510A3", "TLRR_SE_REF_POA": "PS00510A329A", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000120549I", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "126688", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371552XXXXX2019", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000001440{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS007NN58", "TLRR_SE_REF_POA": "PS007NN58MFL", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000120549I", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "148377", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "378750XXXXX1010", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000001440{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS0082W7N", "TLRR_SE_REF_POA": "PS0082W7NVPD", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000120549I", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "100609", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "372889XXXXX3002", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000001500{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS007UMIW", "TLRR_SE_REF_POA": "PS007UMIWXLM", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000120549I", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "180861", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "378294XXXXX2585", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000001500{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS005RNHS", "TLRR_SE_REF_POA": "PS005RNHSN1P", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000120549I", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "101806", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "378750XXXXX1372", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000001500{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS0072BRT", "TLRR_SE_REF_POA": "PS0072BRTTDP", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000120549I", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "105959", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "378349XXXXX4003", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000001500{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS00693Y1", "TLRR_SE_REF_POA": "PS00693Y1BMQ", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000120549I", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "179539", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "372727XXXXX1008", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000001500{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS00457U6", "TLRR_SE_REF_POA": "PS00457U6LTV", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000120549I", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "120790", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371299XXXXX1003", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000001500{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS0069NSJ", "TLRR_SE_REF_POA": "PS0069NSJGND", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000120549I", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "102410", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "372723XXXXX1008", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000001500{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS006SL5Y", "TLRR_SE_REF_POA": "PS006SL5YFCX", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000120549I", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "184316", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371336XXXXX1007", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000001500{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS005B44B", "TLRR_SE_REF_POA": "PS005B44BB57", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000120549I", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "111605", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "379771XXXXX1004", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000001500{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS005L7YN", "TLRR_SE_REF_POA": "PS005L7YNGCZ", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000120549I", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "100002", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "378877XXXXX1006", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000001500{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS007CM87", "TLRR_SE_REF_POA": "PS007CM87LJQ", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000120549I", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "103361", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "373273XXXXX4001", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000001500{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS00839FY", "TLRR_SE_REF_POA": "PS00839FY9MF", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000120549I", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "109375", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "372711XXXXX1012", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000001500{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS0080OTU", "TLRR_SE_REF_POA": "PS0080OTUIKE", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000120549I", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "109699", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "372322XXXXX1003", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000001500{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS006Y3MD", "TLRR_SE_REF_POA": "PS006Y3MDL5F", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000120549I", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "157739", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "372733XXXXX1002", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000001500{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS007VWTY", "TLRR_SE_REF_POA": "PS007VWTY36W", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000120549I", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "141787", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371725XXXXX3028", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000001530{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS007AYOW", "TLRR_SE_REF_POA": "PS007AYOWDZY", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000120549I", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "189602", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371292XXXXX1000", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000001599{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS00693Y0", "TLRR_SE_REF_POA": "PS00693Y0TYL", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000120549I", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "125972", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "372322XXXXX1007", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000001642E", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS007WTWQ", "TLRR_SE_REF_POA": "PS007WTWQ56I", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000120549I", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "176733", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "373274XXXXX5016", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000001800{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS004BNDF", "TLRR_SE_REF_POA": "PS004BNDF9PB", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000120549I", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "115208", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371559XXXXX5002", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000001879B", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS007SF54", "TLRR_SE_REF_POA": "PS007SF54CCG", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000120549I", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "109740", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "376765XXXXX1000", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000002100{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS00631N3", "TLRR_SE_REF_POA": "PS00631N37K3", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000120549I", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "120584", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "372738XXXXX1008", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000002250{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS026D8G3", "TLRR_SE_REF_POA": "PS026D8G3MB6", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000120549I", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "186251", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371505XXXXX3047", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000003000{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS0061RC1", "TLRR_SE_REF_POA": "PS0061RC147T", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000120549I", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "108193", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371557XXXXX1028", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000003180{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS007CM87", "TLRR_SE_REF_POA": "PS007CM87LJS", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000120549I", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "192692", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "378340XXXXX9097", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000003667A", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS007CSUD", "TLRR_SE_REF_POA": "PS007CSUDDW2", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000120549I", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "160089", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "372712XXXXX2045", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000003750{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS007UFWR", "TLRR_SE_REF_POA": "PS007UFWR0XD", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000120549I", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "127790", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "377284XXXXX2009", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000004000{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS0068DHF", "TLRR_SE_REF_POA": "PS0068DHFCYM", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000120549I", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "151969", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371551XXXXX2018", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000004080{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS008RBZU", "TLRR_SE_REF_POA": "PS008RBZUR2N", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000120549I", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "195514", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "378340XXXXX9097", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000004690D", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS007LZLU", "TLRR_SE_REF_POA": "PS007LZLUS66", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000120549I", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "186232", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "379697XXXXX1005", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000004750{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS007LFRF", "TLRR_SE_REF_POA": "PS007LFRF3ZM", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000120549I", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "132345", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "373135XXXXX7004", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000004837E", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS006YGUO", "TLRR_SE_REF_POA": "PS006YGUOX5N", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000120549I", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "163592", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "378348XXXXX1066", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000005280{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS007VWTY", "TLRR_SE_REF_POA": "PS007VWTY36S", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000120549I", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "131589", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "379422XXXXX3005", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000005801C", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS0080OTU", "TLRR_SE_REF_POA": "PS0080OTUQLS", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000120549I", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "181701", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "372521XXXXX4000", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000006000{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS006CF0Q", "TLRR_SE_REF_POA": "PS006CF0Q14Z", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000120549I", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "106860", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8181", "TLRR_AMEX_PAYEE_NUMBER": "2429999961", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999961", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371719XXXXX1004", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254U1181", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1181", "TLRR_PAYMENT_NUMBER_TYPE": "U", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000006097E", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS008A8TN", "TLRR_SE_REF_POA": "PS008A8TN16E", "TLRR_SE_UNIT_NUMBER": "2420622961", "TLRR_SOC_AMOUNT": "000000120549I", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "", "TLRR_AMEX_PAYEE_NUMBER": "2429999928", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999928", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371244XXXXX2003", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254M5144", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "5144", "TLRR_PAYMENT_NUMBER_TYPE": "M", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000002706K", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280199755", "TLRR_SE_REF_POA": "280199755012", "TLRR_SE_UNIT_NUMBER": "0000000012", "TLRR_SOC_AMOUNT": "000000084315F", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "529988", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1345", "TLRR_AMEX_PAYEE_NUMBER": "2429999928", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999928", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "378519XXXXX2005", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254M5144", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "5144", "TLRR_PAYMENT_NUMBER_TYPE": "M", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000162D", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280199941", "TLRR_SE_REF_POA": "280199941400", "TLRR_SE_UNIT_NUMBER": "0000000012", "TLRR_SOC_AMOUNT": "000000084315F", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "586071", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1345", "TLRR_AMEX_PAYEE_NUMBER": "2429999928", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999928", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "376718XXXXX3009", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254M5144", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "5144", "TLRR_PAYMENT_NUMBER_TYPE": "M", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000001839G", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280199755", "TLRR_SE_REF_POA": "280199755440", "TLRR_SE_UNIT_NUMBER": "0000000012", "TLRR_SOC_AMOUNT": "000000084315F", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "542684", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1345", "TLRR_AMEX_PAYEE_NUMBER": "2429999928", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999928", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "376740XXXXX1074", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254M5144", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "5144", "TLRR_PAYMENT_NUMBER_TYPE": "M", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000003228D", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280199941", "TLRR_SE_REF_POA": "280199941398", "TLRR_SE_UNIT_NUMBER": "0000000012", "TLRR_SOC_AMOUNT": "000000084315F", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "185252", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1345", "TLRR_AMEX_PAYEE_NUMBER": "2429999928", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999928", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "374322XXXXX7718", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254M5144", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "5144", "TLRR_PAYMENT_NUMBER_TYPE": "M", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000004828B", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280199941", "TLRR_SE_REF_POA": "280199941403", "TLRR_SE_UNIT_NUMBER": "0000000012", "TLRR_SOC_AMOUNT": "000000084315F", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "500789", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1345", "TLRR_AMEX_PAYEE_NUMBER": "2429999928", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999928", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "372263XXXXX9000", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254M5144", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "5144", "TLRR_PAYMENT_NUMBER_TYPE": "M", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000007239F", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "636701", "TLRR_SE_REF_POA": "636701", "TLRR_SE_UNIT_NUMBER": "0000000012", "TLRR_SOC_AMOUNT": "000000084315F", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "555315", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1345", "TLRR_AMEX_PAYEE_NUMBER": "2429999928", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999928", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "374634XXXXX9381", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254M5144", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "5144", "TLRR_PAYMENT_NUMBER_TYPE": "M", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000007336I", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "312001", "TLRR_SE_REF_POA": "312001", "TLRR_SE_UNIT_NUMBER": "0000000012", "TLRR_SOC_AMOUNT": "000000084315F", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "589810", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1345", "TLRR_AMEX_PAYEE_NUMBER": "2429999928", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999928", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371244XXXXX2003", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254M5144", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "5144", "TLRR_PAYMENT_NUMBER_TYPE": "M", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000019996C", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280199755", "TLRR_SE_REF_POA": "280199755438", "TLRR_SE_UNIT_NUMBER": "0000000012", "TLRR_SOC_AMOUNT": "000000084315F", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "557533", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1345", "TLRR_AMEX_PAYEE_NUMBER": "2429999928", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999928", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371702XXXXX1026", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254M5144", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "5144", "TLRR_PAYMENT_NUMBER_TYPE": "M", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000020112G", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280199755", "TLRR_SE_REF_POA": "280199755443", "TLRR_SE_UNIT_NUMBER": "0000000012", "TLRR_SOC_AMOUNT": "000000084315F", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "544845", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1345", "TLRR_AMEX_PAYEE_NUMBER": "2429999928", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999928", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "378299XXXXX1262", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254M5144", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "5144", "TLRR_PAYMENT_NUMBER_TYPE": "M", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000022277F", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280199941", "TLRR_SE_REF_POA": "280199941396", "TLRR_SE_UNIT_NUMBER": "0000000012", "TLRR_SOC_AMOUNT": "000000084315F", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "523700", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1416", "TLRR_AMEX_PAYEE_NUMBER": "2429999564", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999564", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "372522XXXXX2015", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254M5619", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "5619", "TLRR_PAYMENT_NUMBER_TYPE": "M", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000516I", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280199793", "TLRR_SE_REF_POA": "280199793216", "TLRR_SE_UNIT_NUMBER": "0000000011", "TLRR_SOC_AMOUNT": "000000034722B", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "503430", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1416", "TLRR_AMEX_PAYEE_NUMBER": "2429999564", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999564", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "378750XXXXX1320", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254M5619", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "5619", "TLRR_PAYMENT_NUMBER_TYPE": "M", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000540F", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280199793", "TLRR_SE_REF_POA": "280199793216", "TLRR_SE_UNIT_NUMBER": "0000000011", "TLRR_SOC_AMOUNT": "000000034722B", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "582638", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1416", "TLRR_AMEX_PAYEE_NUMBER": "2429999564", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999564", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "379768XXXXX1005", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254M5619", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "5619", "TLRR_PAYMENT_NUMBER_TYPE": "M", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000006577A", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280199793", "TLRR_SE_REF_POA": "280199793218", "TLRR_SE_UNIT_NUMBER": "0000000011", "TLRR_SOC_AMOUNT": "000000034722B", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "529022", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1416", "TLRR_AMEX_PAYEE_NUMBER": "2429999564", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999564", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371718XXXXX3002", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254M5619", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "5619", "TLRR_PAYMENT_NUMBER_TYPE": "M", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000010447B", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280199812", "TLRR_SE_REF_POA": "280199812416", "TLRR_SE_UNIT_NUMBER": "0000000011", "TLRR_SOC_AMOUNT": "000000034722B", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "515544", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1416", "TLRR_AMEX_PAYEE_NUMBER": "2429999564", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999564", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "372879XXXXX4002", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254M5619", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "5619", "TLRR_PAYMENT_NUMBER_TYPE": "M", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000016640D", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280199793", "TLRR_SE_REF_POA": "280199793215", "TLRR_SE_UNIT_NUMBER": "0000000011", "TLRR_SOC_AMOUNT": "000000034722B", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "568187", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "9742", "TLRR_AMEX_PAYEE_NUMBER": "2429999740", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999740", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "372358XXXXX3016", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254M9006", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "9006", "TLRR_PAYMENT_NUMBER_TYPE": "M", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000649D", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280199802", "TLRR_SE_REF_POA": "280199802498", "TLRR_SE_UNIT_NUMBER": "0000000061", "TLRR_SOC_AMOUNT": "000000069130D", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "525439", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "9742", "TLRR_AMEX_PAYEE_NUMBER": "2429999740", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999740", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "374193XXXXX1005", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254M9006", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "9006", "TLRR_PAYMENT_NUMBER_TYPE": "M", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000004860D", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "061401", "TLRR_SE_REF_POA": "061401", "TLRR_SE_UNIT_NUMBER": "0000000061", "TLRR_SOC_AMOUNT": "000000069130D", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "582373", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "9742", "TLRR_AMEX_PAYEE_NUMBER": "2429999740", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999740", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "376771XXXXX2008", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254M9006", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "9006", "TLRR_PAYMENT_NUMBER_TYPE": "M", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000004958G", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "070201", "TLRR_SE_REF_POA": "070201", "TLRR_SE_UNIT_NUMBER": "0000000061", "TLRR_SOC_AMOUNT": "000000069130D", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "561476", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "9742", "TLRR_AMEX_PAYEE_NUMBER": "2429999740", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999740", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371385XXXXX2069", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254M9006", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "9006", "TLRR_PAYMENT_NUMBER_TYPE": "M", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000011012F", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280199679", "TLRR_SE_REF_POA": "280199679594", "TLRR_SE_UNIT_NUMBER": "0000000061", "TLRR_SOC_AMOUNT": "000000069130D", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "588410", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "9742", "TLRR_AMEX_PAYEE_NUMBER": "2429999740", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999740", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "378353XXXXX2009", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254M9006", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "9006", "TLRR_PAYMENT_NUMBER_TYPE": "M", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000012000{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280199802", "TLRR_SE_REF_POA": "280199802494", "TLRR_SE_UNIT_NUMBER": "0000000061", "TLRR_SOC_AMOUNT": "000000069130D", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "521304", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "9742", "TLRR_AMEX_PAYEE_NUMBER": "2429999740", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999740", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "378201XXXXX4096", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254M9006", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "9006", "TLRR_PAYMENT_NUMBER_TYPE": "M", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000013921I", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280199679", "TLRR_SE_REF_POA": "280199679595", "TLRR_SE_UNIT_NUMBER": "0000000061", "TLRR_SOC_AMOUNT": "000000069130D", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "563820", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "9742", "TLRR_AMEX_PAYEE_NUMBER": "2429999740", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999740", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "372764XXXXX2007", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254M9006", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "9006", "TLRR_PAYMENT_NUMBER_TYPE": "M", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000021727D", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280199802", "TLRR_SE_REF_POA": "280199802498", "TLRR_SE_UNIT_NUMBER": "0000000061", "TLRR_SOC_AMOUNT": "000000069130D", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "572950", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "7989", "TLRR_AMEX_PAYEE_NUMBER": "2429999034", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "2429999034", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "377226XXXXX2006", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254M9224", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "9224", "TLRR_PAYMENT_NUMBER_TYPE": "M", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000004319C", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "282113048", "TLRR_SE_REF_POA": "282113048317", "TLRR_SE_UNIT_NUMBER": "0STR #8061", "TLRR_SOC_AMOUNT": "000000004319C", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "149105", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "0933", "TLRR_AMEX_PAYEE_NUMBER": "3129999193", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "3129999193", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "374326XXXXX5623", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254M4165", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "4165", "TLRR_PAYMENT_NUMBER_TYPE": "M", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000100{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280199619", "TLRR_SE_REF_POA": "280199619929", "TLRR_SE_UNIT_NUMBER": "0000000008", "TLRR_SOC_AMOUNT": "000000063316G", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "579593", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "0933", "TLRR_AMEX_PAYEE_NUMBER": "3129999193", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "3129999193", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "372734XXXXX1003", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254M4165", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "4165", "TLRR_PAYMENT_NUMBER_TYPE": "M", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000107F", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280199619", "TLRR_SE_REF_POA": "280199619933", "TLRR_SE_UNIT_NUMBER": "0000000008", "TLRR_SOC_AMOUNT": "000000063316G", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "960001", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "0933", "TLRR_AMEX_PAYEE_NUMBER": "3129999193", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "3129999193", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "374326XXXXX5368", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254M4165", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "4165", "TLRR_PAYMENT_NUMBER_TYPE": "M", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000200{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280199619", "TLRR_SE_REF_POA": "280199619929", "TLRR_SE_UNIT_NUMBER": "0000000008", "TLRR_SOC_AMOUNT": "000000063316G", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "828418", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "0933", "TLRR_AMEX_PAYEE_NUMBER": "3129999193", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "3129999193", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "379016XXXXX9924", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254M4165", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "4165", "TLRR_PAYMENT_NUMBER_TYPE": "M", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000250{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "741801", "TLRR_SE_REF_POA": "741801", "TLRR_SE_UNIT_NUMBER": "0000000008", "TLRR_SOC_AMOUNT": "000000063316G", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "574090", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "0933", "TLRR_AMEX_PAYEE_NUMBER": "3129999193", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "3129999193", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "373218XXXXX1017", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254M4165", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "4165", "TLRR_PAYMENT_NUMBER_TYPE": "M", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000538E", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280199622", "TLRR_SE_REF_POA": "280199622335", "TLRR_SE_UNIT_NUMBER": "0000000008", "TLRR_SOC_AMOUNT": "000000063316G", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "502692", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "0933", "TLRR_AMEX_PAYEE_NUMBER": "3129999193", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "3129999193", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "379713XXXXX2017", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254M4165", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "4165", "TLRR_PAYMENT_NUMBER_TYPE": "M", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000001292I", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280199619", "TLRR_SE_REF_POA": "280199619928", "TLRR_SE_UNIT_NUMBER": "0000000008", "TLRR_SOC_AMOUNT": "000000063316G", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "185650", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "0933", "TLRR_AMEX_PAYEE_NUMBER": "3129999193", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "3129999193", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "376750XXXXX4057", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254M4165", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "4165", "TLRR_PAYMENT_NUMBER_TYPE": "M", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000019980{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280199619", "TLRR_SE_REF_POA": "280199619927", "TLRR_SE_UNIT_NUMBER": "0000000008", "TLRR_SOC_AMOUNT": "000000063316G", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "106184", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "0933", "TLRR_AMEX_PAYEE_NUMBER": "3129999193", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "3129999193", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "378343XXXXX1139", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254M4165", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "4165", "TLRR_PAYMENT_NUMBER_TYPE": "M", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000040847G", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280199619", "TLRR_SE_REF_POA": "280199619941", "TLRR_SE_UNIT_NUMBER": "0000000008", "TLRR_SOC_AMOUNT": "000000063316G", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "504450", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1328", "TLRR_AMEX_PAYEE_NUMBER": "3229999977", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "3229999977", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "379738XXXXX3008", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254M7990", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "7990", "TLRR_PAYMENT_NUMBER_TYPE": "M", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000143E", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280876924", "TLRR_SE_REF_POA": "280876924272", "TLRR_SE_UNIT_NUMBER": "0000000005", "TLRR_SOC_AMOUNT": "000000099245A", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "151313", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1328", "TLRR_AMEX_PAYEE_NUMBER": "3229999977", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "3229999977", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "379016XXXXX8602", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254M7990", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "7990", "TLRR_PAYMENT_NUMBER_TYPE": "M", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000250{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280199895", "TLRR_SE_REF_POA": "280199895431", "TLRR_SE_UNIT_NUMBER": "0000000005", "TLRR_SOC_AMOUNT": "000000099245A", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "585327", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1328", "TLRR_AMEX_PAYEE_NUMBER": "3229999977", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "3229999977", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "379720XXXXX1000", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254M7990", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "7990", "TLRR_PAYMENT_NUMBER_TYPE": "M", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000001061G", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280199895", "TLRR_SE_REF_POA": "280199895425", "TLRR_SE_UNIT_NUMBER": "0000000005", "TLRR_SOC_AMOUNT": "000000099245A", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "502950", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1328", "TLRR_AMEX_PAYEE_NUMBER": "3229999977", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "3229999977", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "377252XXXXX1002", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254M7990", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "7990", "TLRR_PAYMENT_NUMBER_TYPE": "M", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000001373{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280199895", "TLRR_SE_REF_POA": "280199895428", "TLRR_SE_UNIT_NUMBER": "0000000005", "TLRR_SOC_AMOUNT": "000000099245A", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "588333", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1328", "TLRR_AMEX_PAYEE_NUMBER": "3229999977", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "3229999977", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "377212XXXXX4001", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254M7990", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "7990", "TLRR_PAYMENT_NUMBER_TYPE": "M", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000006275A", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "654402", "TLRR_SE_REF_POA": "654402", "TLRR_SE_UNIT_NUMBER": "0000000005", "TLRR_SOC_AMOUNT": "000000099245A", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "501508", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1328", "TLRR_AMEX_PAYEE_NUMBER": "3229999977", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "3229999977", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "372583XXXXX1005", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254M7990", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "7990", "TLRR_PAYMENT_NUMBER_TYPE": "M", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000011093A", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280199895", "TLRR_SE_REF_POA": "280199895430", "TLRR_SE_UNIT_NUMBER": "0000000005", "TLRR_SOC_AMOUNT": "000000099245A", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "188242", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1328", "TLRR_AMEX_PAYEE_NUMBER": "3229999977", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "3229999977", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "372738XXXXX1005", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254M7990", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "7990", "TLRR_PAYMENT_NUMBER_TYPE": "M", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000011815H", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280199895", "TLRR_SE_REF_POA": "280199895429", "TLRR_SE_UNIT_NUMBER": "0000000005", "TLRR_SOC_AMOUNT": "000000099245A", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "536164", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1328", "TLRR_AMEX_PAYEE_NUMBER": "3229999977", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "3229999977", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "372405XXXXX2009", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254M7990", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "7990", "TLRR_PAYMENT_NUMBER_TYPE": "M", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000013095I", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "542801", "TLRR_SE_REF_POA": "542801", "TLRR_SE_UNIT_NUMBER": "0000000005", "TLRR_SOC_AMOUNT": "000000099245A", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "523229", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1328", "TLRR_AMEX_PAYEE_NUMBER": "3229999977", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "3229999977", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "372713XXXXX6025", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254M7990", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "7990", "TLRR_PAYMENT_NUMBER_TYPE": "M", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000021976{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280199895", "TLRR_SE_REF_POA": "280199895426", "TLRR_SE_UNIT_NUMBER": "0000000005", "TLRR_SOC_AMOUNT": "000000099245A", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "190072", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1328", "TLRR_AMEX_PAYEE_NUMBER": "3229999977", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "3229999977", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "379623XXXXX1009", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254M7990", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "7990", "TLRR_PAYMENT_NUMBER_TYPE": "M", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000032161{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280199895", "TLRR_SE_REF_POA": "280199895430", "TLRR_SE_UNIT_NUMBER": "0000000005", "TLRR_SOC_AMOUNT": "000000099245A", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "", "TLRR_AMEX_PAYEE_NUMBER": "4109999881", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "4109999881", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "379733XXXXX1003", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254M5048", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "5048", "TLRR_PAYMENT_NUMBER_TYPE": "M", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000002916}", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280199821", "TLRR_SE_REF_POA": "280199821009", "TLRR_SE_UNIT_NUMBER": "0000000014", "TLRR_SOC_AMOUNT": "000000053256D", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "", "TLRR_AMEX_PAYEE_NUMBER": "4109999881", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "4109999881", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371556XXXXX1128", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254M5048", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "5048", "TLRR_PAYMENT_NUMBER_TYPE": "M", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000001403Q", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280199821", "TLRR_SE_REF_POA": "280199821009", "TLRR_SE_UNIT_NUMBER": "0000000014", "TLRR_SOC_AMOUNT": "000000053256D", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "465967", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1342", "TLRR_AMEX_PAYEE_NUMBER": "4109999881", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "4109999881", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "372300XXXXX3245", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254M5048", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "5048", "TLRR_PAYMENT_NUMBER_TYPE": "M", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000100{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280199821", "TLRR_SE_REF_POA": "280199821154", "TLRR_SE_UNIT_NUMBER": "0000000014", "TLRR_SOC_AMOUNT": "000000053256D", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "567103", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1342", "TLRR_AMEX_PAYEE_NUMBER": "4109999881", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "4109999881", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371503XXXXX5006", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254M5048", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "5048", "TLRR_PAYMENT_NUMBER_TYPE": "M", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000447I", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280199821", "TLRR_SE_REF_POA": "280199821154", "TLRR_SE_UNIT_NUMBER": "0000000014", "TLRR_SOC_AMOUNT": "000000053256D", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "571575", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1342", "TLRR_AMEX_PAYEE_NUMBER": "4109999881", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "4109999881", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "379762XXXXX1001", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254M5048", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "5048", "TLRR_PAYMENT_NUMBER_TYPE": "M", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000547I", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280199815", "TLRR_SE_REF_POA": "280199815478", "TLRR_SE_UNIT_NUMBER": "0000000014", "TLRR_SOC_AMOUNT": "000000053256D", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "588137", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1342", "TLRR_AMEX_PAYEE_NUMBER": "4109999881", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "4109999881", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "372544XXXXX1010", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254M5048", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "5048", "TLRR_PAYMENT_NUMBER_TYPE": "M", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000755I", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280199821", "TLRR_SE_REF_POA": "280199821160", "TLRR_SE_UNIT_NUMBER": "0000000014", "TLRR_SOC_AMOUNT": "000000053256D", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "509106", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1342", "TLRR_AMEX_PAYEE_NUMBER": "4109999881", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "4109999881", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "372509XXXXX6004", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254M5048", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "5048", "TLRR_PAYMENT_NUMBER_TYPE": "M", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000999I", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280199821", "TLRR_SE_REF_POA": "280199821156", "TLRR_SE_UNIT_NUMBER": "0000000014", "TLRR_SOC_AMOUNT": "000000053256D", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "378314", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1342", "TLRR_AMEX_PAYEE_NUMBER": "4109999881", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "4109999881", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "374326XXXXX5768", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254M5048", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "5048", "TLRR_PAYMENT_NUMBER_TYPE": "M", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000001000{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280199821", "TLRR_SE_REF_POA": "280199821159", "TLRR_SE_UNIT_NUMBER": "0000000014", "TLRR_SOC_AMOUNT": "000000053256D", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "569317", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1342", "TLRR_AMEX_PAYEE_NUMBER": "4109999881", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "4109999881", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "379733XXXXX1003", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254M5048", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "5048", "TLRR_PAYMENT_NUMBER_TYPE": "M", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000001846F", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280199815", "TLRR_SE_REF_POA": "280199815473", "TLRR_SE_UNIT_NUMBER": "0000000014", "TLRR_SOC_AMOUNT": "000000053256D", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "597379", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1342", "TLRR_AMEX_PAYEE_NUMBER": "4109999881", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "4109999881", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371553XXXXX1142", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254M5048", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "5048", "TLRR_PAYMENT_NUMBER_TYPE": "M", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000009682B", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280199821", "TLRR_SE_REF_POA": "280199821158", "TLRR_SE_UNIT_NUMBER": "0000000014", "TLRR_SOC_AMOUNT": "000000053256D", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "548463", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1342", "TLRR_AMEX_PAYEE_NUMBER": "4109999881", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "4109999881", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "372314XXXXX5004", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254M5048", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "5048", "TLRR_PAYMENT_NUMBER_TYPE": "M", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000013883A", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280199821", "TLRR_SE_REF_POA": "280199821165", "TLRR_SE_UNIT_NUMBER": "0000000014", "TLRR_SOC_AMOUNT": "000000053256D", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "513532", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1342", "TLRR_AMEX_PAYEE_NUMBER": "4109999881", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "4109999881", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "376748XXXXX1007", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254M5048", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "5048", "TLRR_PAYMENT_NUMBER_TYPE": "M", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000013889G", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280199821", "TLRR_SE_REF_POA": "280199821155", "TLRR_SE_UNIT_NUMBER": "0000000014", "TLRR_SOC_AMOUNT": "000000053256D", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "566194", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1342", "TLRR_AMEX_PAYEE_NUMBER": "4109999881", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "4109999881", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "372544XXXXX1010", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254M5048", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "5048", "TLRR_PAYMENT_NUMBER_TYPE": "M", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000014423{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "500201", "TLRR_SE_REF_POA": "500201", "TLRR_SE_UNIT_NUMBER": "0000000014", "TLRR_SOC_AMOUNT": "000000053256D", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "506910", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "9736", "TLRR_AMEX_PAYEE_NUMBER": "4109999177", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "4109999177", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "379777XXXXX1008", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254M7145", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "7145", "TLRR_PAYMENT_NUMBER_TYPE": "M", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000283H", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280199964", "TLRR_SE_REF_POA": "280199964891", "TLRR_SE_UNIT_NUMBER": "0000000056", "TLRR_SOC_AMOUNT": "000000000283H", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "709934", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "7994", "TLRR_AMEX_PAYEE_NUMBER": "4169999182", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "4169999182", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "372741XXXXX2856", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254M9582", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "9582", "TLRR_PAYMENT_NUMBER_TYPE": "M", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000001009D", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "282111141", "TLRR_SE_REF_POA": "282111141355", "TLRR_SE_UNIT_NUMBER": "00STR#8065", "TLRR_SOC_AMOUNT": "000000028035G", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "566358", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "7994", "TLRR_AMEX_PAYEE_NUMBER": "4169999182", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "4169999182", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "379214XXXXX2000", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254M9582", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "9582", "TLRR_PAYMENT_NUMBER_TYPE": "M", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000002119I", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "282111151", "TLRR_SE_REF_POA": "282111151382", "TLRR_SE_UNIT_NUMBER": "00STR#8065", "TLRR_SOC_AMOUNT": "000000028035G", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "586572", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "7994", "TLRR_AMEX_PAYEE_NUMBER": "4169999182", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "4169999182", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "378264XXXXX6000", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254M9582", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "9582", "TLRR_PAYMENT_NUMBER_TYPE": "M", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000002543H", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "282111151", "TLRR_SE_REF_POA": "282111151385", "TLRR_SE_UNIT_NUMBER": "00STR#8065", "TLRR_SOC_AMOUNT": "000000028035G", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "567480", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "7994", "TLRR_AMEX_PAYEE_NUMBER": "4169999182", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "4169999182", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371720XXXXX2006", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254M9582", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "9582", "TLRR_PAYMENT_NUMBER_TYPE": "M", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000003097I", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "282111141", "TLRR_SE_REF_POA": "282111141354", "TLRR_SE_UNIT_NUMBER": "00STR#8065", "TLRR_SOC_AMOUNT": "000000028035G", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "568700", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "7994", "TLRR_AMEX_PAYEE_NUMBER": "4169999182", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "4169999182", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "372418XXXXX1001", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254M9582", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "9582", "TLRR_PAYMENT_NUMBER_TYPE": "M", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000003229D", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "282111141", "TLRR_SE_REF_POA": "282111141357", "TLRR_SE_UNIT_NUMBER": "00STR#8065", "TLRR_SOC_AMOUNT": "000000028035G", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "501298", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "7994", "TLRR_AMEX_PAYEE_NUMBER": "4169999182", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "4169999182", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "372357XXXXX3000", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254M9582", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "9582", "TLRR_PAYMENT_NUMBER_TYPE": "M", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000003642H", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "282111151", "TLRR_SE_REF_POA": "282111151382", "TLRR_SE_UNIT_NUMBER": "00STR#8065", "TLRR_SOC_AMOUNT": "000000028035G", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "582834", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "7994", "TLRR_AMEX_PAYEE_NUMBER": "4169999182", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "4169999182", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371720XXXXX2006", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254M9582", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "9582", "TLRR_PAYMENT_NUMBER_TYPE": "M", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000012392E", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "282111141", "TLRR_SE_REF_POA": "282111141354", "TLRR_SE_UNIT_NUMBER": "00STR#8065", "TLRR_SOC_AMOUNT": "000000028035G", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "", "TLRR_AMEX_PAYEE_NUMBER": "4329999734", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "4329999734", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "372582XXXXX1003", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254D6481", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "6481", "TLRR_PAYMENT_NUMBER_TYPE": "D", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000012192}", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280280251", "TLRR_SE_REF_POA": "280280251000", "TLRR_SE_UNIT_NUMBER": "0000STR#65", "TLRR_SOC_AMOUNT": "000000017768A", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "524485", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "3825", "TLRR_AMEX_PAYEE_NUMBER": "4329999734", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "4329999734", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "376768XXXXX1007", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254D6481", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "6481", "TLRR_PAYMENT_NUMBER_TYPE": "D", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000580C", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "206501", "TLRR_SE_REF_POA": "206501", "TLRR_SE_UNIT_NUMBER": "0000STR#65", "TLRR_SOC_AMOUNT": "000000017768A", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "705455", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "3825", "TLRR_AMEX_PAYEE_NUMBER": "4329999734", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "4329999734", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "374716XXXXX5771", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254D6481", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "6481", "TLRR_PAYMENT_NUMBER_TYPE": "D", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000752C", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280280251", "TLRR_SE_REF_POA": "280280251215", "TLRR_SE_UNIT_NUMBER": "0000STR#65", "TLRR_SOC_AMOUNT": "000000017768A", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "544057", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "3825", "TLRR_AMEX_PAYEE_NUMBER": "4329999734", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "4329999734", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "379626XXXXX1003", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254D6481", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "6481", "TLRR_PAYMENT_NUMBER_TYPE": "D", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000976F", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280280251", "TLRR_SE_REF_POA": "280280251213", "TLRR_SE_UNIT_NUMBER": "0000STR#65", "TLRR_SOC_AMOUNT": "000000017768A", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "524729", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "3825", "TLRR_AMEX_PAYEE_NUMBER": "4329999734", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "4329999734", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371759XXXXX1055", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254D6481", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "6481", "TLRR_PAYMENT_NUMBER_TYPE": "D", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000003289C", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280199651", "TLRR_SE_REF_POA": "280199651200", "TLRR_SE_UNIT_NUMBER": "0000STR#65", "TLRR_SOC_AMOUNT": "000000017768A", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "517891", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "3825", "TLRR_AMEX_PAYEE_NUMBER": "4329999734", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "4329999734", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371242XXXXX1008", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254D6481", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "6481", "TLRR_PAYMENT_NUMBER_TYPE": "D", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000009000{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280280251", "TLRR_SE_REF_POA": "280280251213", "TLRR_SE_UNIT_NUMBER": "0000STR#65", "TLRR_SOC_AMOUNT": "000000017768A", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "549209", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "3825", "TLRR_AMEX_PAYEE_NUMBER": "4329999734", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "4329999734", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "373272XXXXX4006", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254D6481", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "6481", "TLRR_PAYMENT_NUMBER_TYPE": "D", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000015361F", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280280251", "TLRR_SE_REF_POA": "280280251216", "TLRR_SE_UNIT_NUMBER": "0000STR#65", "TLRR_SOC_AMOUNT": "000000017768A", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "538201", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "7992", "TLRR_AMEX_PAYEE_NUMBER": "4419999772", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "4419999772", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "379016XXXXX2396", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254M2689", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "2689", "TLRR_PAYMENT_NUMBER_TYPE": "M", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000500{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "282111160", "TLRR_SE_REF_POA": "282111160276", "TLRR_SE_UNIT_NUMBER": "00Str#8064", "TLRR_SOC_AMOUNT": "000000003266F", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "583577", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "7992", "TLRR_AMEX_PAYEE_NUMBER": "4419999772", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "4419999772", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "373761XXXXX1002", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254M2689", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "2689", "TLRR_PAYMENT_NUMBER_TYPE": "M", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000002766F", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "282111160", "TLRR_SE_REF_POA": "282111160276", "TLRR_SE_UNIT_NUMBER": "00Str#8064", "TLRR_SOC_AMOUNT": "000000003266F", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "", "TLRR_AMEX_PAYEE_NUMBER": "4459999588", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "4459999588", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371294XXXXX1008", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254M6699", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "6699", "TLRR_PAYMENT_NUMBER_TYPE": "M", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000540O", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280199854", "TLRR_SE_REF_POA": "280199854012", "TLRR_SE_UNIT_NUMBER": "0000000010", "TLRR_SOC_AMOUNT": "000000030378E", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "", "TLRR_AMEX_PAYEE_NUMBER": "4459999588", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "4459999588", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "374292XXXXX1004", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254M6699", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "6699", "TLRR_PAYMENT_NUMBER_TYPE": "M", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000423R", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "650001", "TLRR_SE_REF_POA": "650001", "TLRR_SE_UNIT_NUMBER": "0000000010", "TLRR_SOC_AMOUNT": "000000030378E", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "", "TLRR_AMEX_PAYEE_NUMBER": "4459999588", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "4459999588", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371294XXXXX1008", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254M6699", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "6699", "TLRR_PAYMENT_NUMBER_TYPE": "M", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000413M", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280199854", "TLRR_SE_REF_POA": "280199854012", "TLRR_SE_UNIT_NUMBER": "0000000010", "TLRR_SOC_AMOUNT": "000000030378E", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "145005", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1387", "TLRR_AMEX_PAYEE_NUMBER": "4459999588", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "4459999588", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "374716XXXXX4011", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254M6699", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "6699", "TLRR_PAYMENT_NUMBER_TYPE": "M", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000535I", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280199854", "TLRR_SE_REF_POA": "280199854883", "TLRR_SE_UNIT_NUMBER": "0000000010", "TLRR_SOC_AMOUNT": "000000030378E", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "523803", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1387", "TLRR_AMEX_PAYEE_NUMBER": "4459999588", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "4459999588", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "378346XXXXX1145", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254M6699", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "6699", "TLRR_PAYMENT_NUMBER_TYPE": "M", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000953H", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "710401", "TLRR_SE_REF_POA": "710401", "TLRR_SE_UNIT_NUMBER": "0000000010", "TLRR_SOC_AMOUNT": "000000030378E", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "586510", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1387", "TLRR_AMEX_PAYEE_NUMBER": "4459999588", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "4459999588", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "372583XXXXX1005", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254M6699", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "6699", "TLRR_PAYMENT_NUMBER_TYPE": "M", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000999H", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280199854", "TLRR_SE_REF_POA": "280199854885", "TLRR_SE_UNIT_NUMBER": "0000000010", "TLRR_SOC_AMOUNT": "000000030378E", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "523343", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1387", "TLRR_AMEX_PAYEE_NUMBER": "4459999588", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "4459999588", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "372583XXXXX1005", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254M6699", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "6699", "TLRR_PAYMENT_NUMBER_TYPE": "M", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000001071H", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280199854", "TLRR_SE_REF_POA": "280199854885", "TLRR_SE_UNIT_NUMBER": "0000000010", "TLRR_SOC_AMOUNT": "000000030378E", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "541355", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1387", "TLRR_AMEX_PAYEE_NUMBER": "4459999588", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "4459999588", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "376762XXXXX2005", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254M6699", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "6699", "TLRR_PAYMENT_NUMBER_TYPE": "M", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000001208C", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "711001", "TLRR_SE_REF_POA": "711001", "TLRR_SE_UNIT_NUMBER": "0000000010", "TLRR_SOC_AMOUNT": "000000030378E", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "551146", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1387", "TLRR_AMEX_PAYEE_NUMBER": "4459999588", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "4459999588", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "376764XXXXX3002", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254M6699", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "6699", "TLRR_PAYMENT_NUMBER_TYPE": "M", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000003179F", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280199856", "TLRR_SE_REF_POA": "280199856890", "TLRR_SE_UNIT_NUMBER": "0000000010", "TLRR_SOC_AMOUNT": "000000030378E", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "525844", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1387", "TLRR_AMEX_PAYEE_NUMBER": "4459999588", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "4459999588", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "379740XXXXX2014", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254M6699", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "6699", "TLRR_PAYMENT_NUMBER_TYPE": "M", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000007387H", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "710701", "TLRR_SE_REF_POA": "710701", "TLRR_SE_UNIT_NUMBER": "0000000010", "TLRR_SOC_AMOUNT": "000000030378E", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "576816", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1387", "TLRR_AMEX_PAYEE_NUMBER": "4459999588", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "4459999588", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "376765XXXXX2004", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254M6699", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "6699", "TLRR_PAYMENT_NUMBER_TYPE": "M", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000016419D", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280199854", "TLRR_SE_REF_POA": "280199854879", "TLRR_SE_UNIT_NUMBER": "0000000010", "TLRR_SOC_AMOUNT": "000000030378E", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "504102", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1278", "TLRR_AMEX_PAYEE_NUMBER": "5029999057", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "5029999057", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "379720XXXXX2003", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254M8033", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "8033", "TLRR_PAYMENT_NUMBER_TYPE": "M", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000003897D", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280199696", "TLRR_SE_REF_POA": "280199696426", "TLRR_SE_UNIT_NUMBER": "0000000001", "TLRR_SOC_AMOUNT": "000000085830E", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "565619", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1278", "TLRR_AMEX_PAYEE_NUMBER": "5029999057", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "5029999057", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "379778XXXXX1008", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254M8033", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "8033", "TLRR_PAYMENT_NUMBER_TYPE": "M", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000006650I", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280280185", "TLRR_SE_REF_POA": "280280185078", "TLRR_SE_UNIT_NUMBER": "0000000001", "TLRR_SOC_AMOUNT": "000000085830E", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "502663", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1278", "TLRR_AMEX_PAYEE_NUMBER": "5029999057", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "5029999057", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "376767XXXXX3003", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254M8033", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "8033", "TLRR_PAYMENT_NUMBER_TYPE": "M", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000007456A", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280280185", "TLRR_SE_REF_POA": "280280185070", "TLRR_SE_UNIT_NUMBER": "0000000001", "TLRR_SOC_AMOUNT": "000000085830E", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "585008", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1278", "TLRR_AMEX_PAYEE_NUMBER": "5029999057", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "5029999057", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "378260XXXXX1036", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254M8033", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "8033", "TLRR_PAYMENT_NUMBER_TYPE": "M", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000013917{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "765601", "TLRR_SE_REF_POA": "765601", "TLRR_SE_UNIT_NUMBER": "0000000001", "TLRR_SOC_AMOUNT": "000000085830E", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "566968", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1278", "TLRR_AMEX_PAYEE_NUMBER": "5029999057", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "5029999057", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371240XXXXX1008", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254M8033", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "8033", "TLRR_PAYMENT_NUMBER_TYPE": "M", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000024374F", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280280185", "TLRR_SE_REF_POA": "280280185074", "TLRR_SE_UNIT_NUMBER": "0000000001", "TLRR_SOC_AMOUNT": "000000085830E", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "517433", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1278", "TLRR_AMEX_PAYEE_NUMBER": "5029999057", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "5029999057", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "378298XXXXX2109", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254M8033", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "8033", "TLRR_PAYMENT_NUMBER_TYPE": "M", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000029534E", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "280280185", "TLRR_SE_REF_POA": "280280185072", "TLRR_SE_UNIT_NUMBER": "0000000001", "TLRR_SOC_AMOUNT": "000000085830E", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "504009", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8018", "TLRR_AMEX_PAYEE_NUMBER": "5029999289", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "5029999289", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "370276XXXXX5978", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254M0295", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "0295", "TLRR_PAYMENT_NUMBER_TYPE": "M", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000440D", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "282111111", "TLRR_SE_REF_POA": "282111111331", "TLRR_SE_UNIT_NUMBER": "00STR#8069", "TLRR_SOC_AMOUNT": "000000013295D", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "580645", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8018", "TLRR_AMEX_PAYEE_NUMBER": "5029999289", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "5029999289", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "377254XXXXX2006", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254M0295", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "0295", "TLRR_PAYMENT_NUMBER_TYPE": "M", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000003135G", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "282111111", "TLRR_SE_REF_POA": "282111111330", "TLRR_SE_UNIT_NUMBER": "00STR#8069", "TLRR_SOC_AMOUNT": "000000013295D", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "500250", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "8018", "TLRR_AMEX_PAYEE_NUMBER": "5029999289", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "5029999289", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "377254XXXXX2006", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254M0295", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "0295", "TLRR_PAYMENT_NUMBER_TYPE": "M", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000009719C", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "282111111", "TLRR_SE_REF_POA": "282111111330", "TLRR_SE_UNIT_NUMBER": "00STR#8069", "TLRR_SOC_AMOUNT": "000000013295D", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "143426", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1110", "TLRR_AMEX_PAYEE_NUMBER": "5279999046", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "5279999046", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "378735XXXXX1005", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254S6115", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "6115", "TLRR_PAYMENT_NUMBER_TYPE": "S", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000990{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "Y250LZW3D", "TLRR_SE_REF_POA": "Y250LZW3DC6J", "TLRR_SE_UNIT_NUMBER": "", "TLRR_SOC_AMOUNT": "000000000990{", "TLRR_SOC_INVOICE_NUMBER": "253034", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "179514", "MERCHANT_CATEGORY_CODE": "5967", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1765", "TLRR_AMEX_PAYEE_NUMBER": "5279999579", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "5279999579", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "372521XXXXX3001", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254S2139", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "2139", "TLRR_PAYMENT_NUMBER_TYPE": "S", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000104I", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS0087AXE", "TLRR_SE_REF_POA": "PS0087AXEP5S", "TLRR_SE_UNIT_NUMBER": "", "TLRR_SOC_AMOUNT": "000000000104I", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014253", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "125313", "MERCHANT_CATEGORY_CODE": "5967", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1765", "TLRR_AMEX_PAYEE_NUMBER": "5279999579", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "5279999579", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371703XXXXX3017", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254S2139", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "2139", "TLRR_PAYMENT_NUMBER_TYPE": "S", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000079I", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS00572L4", "TLRR_SE_REF_POA": "PS00572L4UAQ", "TLRR_SE_UNIT_NUMBER": "", "TLRR_SOC_AMOUNT": "000000000079I", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014253", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "315565", "MERCHANT_CATEGORY_CODE": "5967", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1765", "TLRR_AMEX_PAYEE_NUMBER": "5279999579", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "5279999579", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "375150XXXXX1206", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254S2139", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "2139", "TLRR_PAYMENT_NUMBER_TYPE": "S", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000010G", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS011CXDJ", "TLRR_SE_REF_POA": "PS011CXDJH16", "TLRR_SE_UNIT_NUMBER": "", "TLRR_SOC_AMOUNT": "000000000351F", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "127263", "MERCHANT_CATEGORY_CODE": "5967", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1765", "TLRR_AMEX_PAYEE_NUMBER": "5279999579", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "5279999579", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "372346XXXXX1002", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254S2139", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "2139", "TLRR_PAYMENT_NUMBER_TYPE": "S", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000012E", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS00JYHXP", "TLRR_SE_REF_POA": "PS00JYHXPAFU", "TLRR_SE_UNIT_NUMBER": "", "TLRR_SOC_AMOUNT": "000000000351F", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014253", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "189446", "MERCHANT_CATEGORY_CODE": "5967", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1765", "TLRR_AMEX_PAYEE_NUMBER": "5279999579", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "5279999579", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "372346XXXXX1002", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254S2139", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "2139", "TLRR_PAYMENT_NUMBER_TYPE": "S", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000015{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS00JYBBJ", "TLRR_SE_REF_POA": "PS00JYBBJWPH", "TLRR_SE_UNIT_NUMBER": "", "TLRR_SOC_AMOUNT": "000000000351F", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014253", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "136102", "MERCHANT_CATEGORY_CODE": "5967", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1765", "TLRR_AMEX_PAYEE_NUMBER": "5279999579", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "5279999579", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371744XXXXX3006", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254S2139", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "2139", "TLRR_PAYMENT_NUMBER_TYPE": "S", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000019I", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS03SGRFM", "TLRR_SE_REF_POA": "PS03SGRFM0P5", "TLRR_SE_UNIT_NUMBER": "", "TLRR_SOC_AMOUNT": "000000000351F", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014253", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "119943", "MERCHANT_CATEGORY_CODE": "5967", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1765", "TLRR_AMEX_PAYEE_NUMBER": "5279999579", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "5279999579", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371744XXXXX3006", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254S2139", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "2139", "TLRR_PAYMENT_NUMBER_TYPE": "S", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000019I", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS03SHV4I", "TLRR_SE_REF_POA": "PS03SHV4IC5Z", "TLRR_SE_UNIT_NUMBER": "", "TLRR_SOC_AMOUNT": "000000000351F", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014253", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "146362", "MERCHANT_CATEGORY_CODE": "5967", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1765", "TLRR_AMEX_PAYEE_NUMBER": "5279999579", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "5279999579", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "372346XXXXX1002", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254S2139", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "2139", "TLRR_PAYMENT_NUMBER_TYPE": "S", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000019I", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS00JYHXP", "TLRR_SE_REF_POA": "PS00JYHXPAFV", "TLRR_SE_UNIT_NUMBER": "", "TLRR_SOC_AMOUNT": "000000000351F", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014253", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "187347", "MERCHANT_CATEGORY_CODE": "5967", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1765", "TLRR_AMEX_PAYEE_NUMBER": "5279999579", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "5279999579", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "372346XXXXX1002", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254S2139", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "2139", "TLRR_PAYMENT_NUMBER_TYPE": "S", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000019I", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS00JYOJU", "TLRR_SE_REF_POA": "PS00JYOJUOE9", "TLRR_SE_UNIT_NUMBER": "", "TLRR_SOC_AMOUNT": "000000000351F", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014253", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "129747", "MERCHANT_CATEGORY_CODE": "5967", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1765", "TLRR_AMEX_PAYEE_NUMBER": "5279999579", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "5279999579", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "379754XXXXX1005", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254S2139", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "2139", "TLRR_PAYMENT_NUMBER_TYPE": "S", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000020I", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS00L3AIU", "TLRR_SE_REF_POA": "PS00L3AIUI0J", "TLRR_SE_UNIT_NUMBER": "", "TLRR_SOC_AMOUNT": "000000000351F", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014253", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "163713", "MERCHANT_CATEGORY_CODE": "5967", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1765", "TLRR_AMEX_PAYEE_NUMBER": "5279999579", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "5279999579", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "378683XXXXX2010", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254S2139", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "2139", "TLRR_PAYMENT_NUMBER_TYPE": "S", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000021C", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS00T94C0", "TLRR_SE_REF_POA": "PS00T94C0MHJ", "TLRR_SE_UNIT_NUMBER": "", "TLRR_SOC_AMOUNT": "000000000351F", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014253", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "127145", "MERCHANT_CATEGORY_CODE": "5967", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1765", "TLRR_AMEX_PAYEE_NUMBER": "5279999579", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "5279999579", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "372863XXXXX1097", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254S2139", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "2139", "TLRR_PAYMENT_NUMBER_TYPE": "S", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000021H", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS008FDZO", "TLRR_SE_REF_POA": "PS008FDZOZYT", "TLRR_SE_UNIT_NUMBER": "", "TLRR_SOC_AMOUNT": "000000000351F", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "117517", "MERCHANT_CATEGORY_CODE": "5967", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1765", "TLRR_AMEX_PAYEE_NUMBER": "5279999579", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "5279999579", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "376213XXXXX5005", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254S2139", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "2139", "TLRR_PAYMENT_NUMBER_TYPE": "S", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000059I", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS007MJGA", "TLRR_SE_REF_POA": "PS007MJGAZT3", "TLRR_SE_UNIT_NUMBER": "", "TLRR_SOC_AMOUNT": "000000000351F", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "121604", "MERCHANT_CATEGORY_CODE": "5967", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1765", "TLRR_AMEX_PAYEE_NUMBER": "5279999579", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "5279999579", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "376781XXXXX1003", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254S2139", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "2139", "TLRR_PAYMENT_NUMBER_TYPE": "S", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000109I", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS00H1KM5", "TLRR_SE_REF_POA": "PS00H1KM54QD", "TLRR_SE_UNIT_NUMBER": "", "TLRR_SOC_AMOUNT": "000000000351F", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "147297", "MERCHANT_CATEGORY_CODE": "5967", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1765", "TLRR_AMEX_PAYEE_NUMBER": "5279999579", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "5279999579", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371739XXXXX2001", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254S2139", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "2139", "TLRR_PAYMENT_NUMBER_TYPE": "S", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000042I", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS00EM3Q6", "TLRR_SE_REF_POA": "PS00EM3Q6MAB", "TLRR_SE_UNIT_NUMBER": "", "TLRR_SOC_AMOUNT": "000000000042I", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "176553", "MERCHANT_CATEGORY_CODE": "5967", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1765", "TLRR_AMEX_PAYEE_NUMBER": "5279999579", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "5279999579", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371707XXXXX5006", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254S2139", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "2139", "TLRR_PAYMENT_NUMBER_TYPE": "S", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000014I", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS00YGDAQ", "TLRR_SE_REF_POA": "PS00YGDAQ9GU", "TLRR_SE_UNIT_NUMBER": "", "TLRR_SOC_AMOUNT": "000000000096B", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "127882", "MERCHANT_CATEGORY_CODE": "5967", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1765", "TLRR_AMEX_PAYEE_NUMBER": "5279999579", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "5279999579", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371739XXXXX2001", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254S2139", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "2139", "TLRR_PAYMENT_NUMBER_TYPE": "S", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000021D", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS00ENKND", "TLRR_SE_REF_POA": "PS00ENKNDQ2K", "TLRR_SE_UNIT_NUMBER": "", "TLRR_SOC_AMOUNT": "000000000096B", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "159936", "MERCHANT_CATEGORY_CODE": "5967", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1765", "TLRR_AMEX_PAYEE_NUMBER": "5279999579", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "5279999579", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "376782XXXXX3005", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254S2139", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "2139", "TLRR_PAYMENT_NUMBER_TYPE": "S", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000059I", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS00RFPAW", "TLRR_SE_REF_POA": "PS00RFPAWAVG", "TLRR_SE_UNIT_NUMBER": "", "TLRR_SOC_AMOUNT": "000000000096B", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "173374", "MERCHANT_CATEGORY_CODE": "5967", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1765", "TLRR_AMEX_PAYEE_NUMBER": "5279999579", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "5279999579", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "376782XXXXX3005", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254S2139", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "2139", "TLRR_PAYMENT_NUMBER_TYPE": "S", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000099I", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS00RE1RJ", "TLRR_SE_REF_POA": "PS00RE1RJTCO", "TLRR_SE_UNIT_NUMBER": "", "TLRR_SOC_AMOUNT": "000000000199H", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "186089", "MERCHANT_CATEGORY_CODE": "5967", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1765", "TLRR_AMEX_PAYEE_NUMBER": "5279999579", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "5279999579", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "376782XXXXX3005", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254S2139", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "2139", "TLRR_PAYMENT_NUMBER_TYPE": "S", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000099I", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS00RDV5E", "TLRR_SE_REF_POA": "PS00RDV5EFLZ", "TLRR_SE_UNIT_NUMBER": "", "TLRR_SOC_AMOUNT": "000000000199H", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "127360", "MERCHANT_CATEGORY_CODE": "5967", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1765", "TLRR_AMEX_PAYEE_NUMBER": "5279999579", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "5279999579", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "379705XXXXX2006", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254S2139", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "2139", "TLRR_PAYMENT_NUMBER_TYPE": "S", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000044I", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS005KO43", "TLRR_SE_REF_POA": "PS005KO43WFR", "TLRR_SE_UNIT_NUMBER": "", "TLRR_SOC_AMOUNT": "000000000044I", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "197010", "MERCHANT_CATEGORY_CODE": "5967", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1765", "TLRR_AMEX_PAYEE_NUMBER": "5279999579", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "5279999579", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371566XXXXX3003", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254S2139", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "2139", "TLRR_PAYMENT_NUMBER_TYPE": "S", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000069I", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS0084QD5", "TLRR_SE_REF_POA": "PS0084QD5O8G", "TLRR_SE_UNIT_NUMBER": "", "TLRR_SOC_AMOUNT": "000000000179H", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "109712", "MERCHANT_CATEGORY_CODE": "5967", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1765", "TLRR_AMEX_PAYEE_NUMBER": "5279999579", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "5279999579", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "372322XXXXX1009", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254S2139", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "2139", "TLRR_PAYMENT_NUMBER_TYPE": "S", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000109I", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS00I4J1V", "TLRR_SE_REF_POA": "PS00I4J1VOBE", "TLRR_SE_UNIT_NUMBER": "", "TLRR_SOC_AMOUNT": "000000000179H", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "148930", "MERCHANT_CATEGORY_CODE": "5967", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1765", "TLRR_AMEX_PAYEE_NUMBER": "5279999579", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "5279999579", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "372574XXXXX2005", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254S2139", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "2139", "TLRR_PAYMENT_NUMBER_TYPE": "S", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000109I", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS007LMDK", "TLRR_SE_REF_POA": "PS007LMDKF4N", "TLRR_SE_UNIT_NUMBER": "", "TLRR_SOC_AMOUNT": "000000000259H", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "123169", "MERCHANT_CATEGORY_CODE": "5967", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1765", "TLRR_AMEX_PAYEE_NUMBER": "5279999579", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "5279999579", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "372574XXXXX2005", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254S2139", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "2139", "TLRR_PAYMENT_NUMBER_TYPE": "S", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000149I", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "PS007MWOM", "TLRR_SE_REF_POA": "PS007MWOM4XW", "TLRR_SE_UNIT_NUMBER": "", "TLRR_SOC_AMOUNT": "000000000259H", "TLRR_SOC_INVOICE_NUMBER": "253016", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "207069", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1111", "TLRR_AMEX_PAYEE_NUMBER": "5439999059", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "5439999059", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371539XXXXX3000", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254D8477", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "8477", "TLRR_PAYMENT_NUMBER_TYPE": "D", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000014589C", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "319004288", "TLRR_SE_REF_POA": "319004288", "TLRR_SE_UNIT_NUMBER": "", "TLRR_SOC_AMOUNT": "000000133112D", "TLRR_SOC_INVOICE_NUMBER": "907286", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "131657", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "291990", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1111", "TLRR_AMEX_PAYEE_NUMBER": "5439999059", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "5439999059", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "376730XXXXX1009", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254D8477", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "8477", "TLRR_PAYMENT_NUMBER_TYPE": "D", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000017845{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "360004701", "TLRR_SE_REF_POA": "360004701", "TLRR_SE_UNIT_NUMBER": "", "TLRR_SOC_AMOUNT": "000000133112D", "TLRR_SOC_INVOICE_NUMBER": "907286", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "144649", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "221100", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1111", "TLRR_AMEX_PAYEE_NUMBER": "5439999059", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "5439999059", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371326XXXXX4013", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254D8477", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "8477", "TLRR_PAYMENT_NUMBER_TYPE": "D", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000050138{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "303004339", "TLRR_SE_REF_POA": "303004339", "TLRR_SE_UNIT_NUMBER": "", "TLRR_SOC_AMOUNT": "000000133112D", "TLRR_SOC_INVOICE_NUMBER": "907286", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "173945", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "222442", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1111", "TLRR_AMEX_PAYEE_NUMBER": "5439999059", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "5439999059", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "372321XXXXX1033", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254D8477", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "8477", "TLRR_PAYMENT_NUMBER_TYPE": "D", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000050540A", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "339004608", "TLRR_SE_REF_POA": "339004608", "TLRR_SE_UNIT_NUMBER": "", "TLRR_SOC_AMOUNT": "000000133112D", "TLRR_SOC_INVOICE_NUMBER": "907286", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "193627", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "126640", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1110", "TLRR_AMEX_PAYEE_NUMBER": "5469999720", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "5469999720", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371333XXXXX1030", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254A1705", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1705", "TLRR_PAYMENT_NUMBER_TYPE": "A", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000001649C", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "WWNSIZR6R", "TLRR_SE_REF_POA": "WWNSIZR6R2NL", "TLRR_SE_UNIT_NUMBER": "EVENTS", "TLRR_SOC_AMOUNT": "000000039503E", "TLRR_SOC_INVOICE_NUMBER": "253034", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "180903", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1110", "TLRR_AMEX_PAYEE_NUMBER": "5469999720", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "5469999720", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "379063XXXXX1008", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254A1705", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1705", "TLRR_PAYMENT_NUMBER_TYPE": "A", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000012854B", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "WWNS4ZVV1", "TLRR_SE_REF_POA": "WWNS4ZVV1TKK", "TLRR_SE_UNIT_NUMBER": "EVENTS", "TLRR_SOC_AMOUNT": "000000039503E", "TLRR_SOC_INVOICE_NUMBER": "253034", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "165373", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "1110", "TLRR_AMEX_PAYEE_NUMBER": "5469999720", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "5469999720", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "378298XXXXX2031", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254A1705", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "1705", "TLRR_PAYMENT_NUMBER_TYPE": "A", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000025000{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "WWNSNZRAK", "TLRR_SE_REF_POA": "WWNSNZRAK70O", "TLRR_SE_UNIT_NUMBER": "EVENTS", "TLRR_SOC_AMOUNT": "000000039503E", "TLRR_SOC_INVOICE_NUMBER": "253034", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "000000", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "03330041", "TLRR_AMEX_PAYEE_NUMBER": "5469999267", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "5469999267", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "379719XXXXX1002", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254T9183", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "9183", "TLRR_PAYMENT_NUMBER_TYPE": "T", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000109R", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "820283115", "TLRR_SE_REF_POA": "820283115413", "TLRR_SE_UNIT_NUMBER": "", "TLRR_SOC_AMOUNT": "000000009616C", "TLRR_SOC_INVOICE_NUMBER": "321487", "TLRR_TRAN_DATE": "2014253", "TRANSACTION_TIME": "054417", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "180932", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "03330041", "TLRR_AMEX_PAYEE_NUMBER": "5469999267", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "5469999267", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "379780XXXXX2007", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254T9183", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "9183", "TLRR_PAYMENT_NUMBER_TYPE": "T", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000108C", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "820945017", "TLRR_SE_REF_POA": "820945017181", "TLRR_SE_UNIT_NUMBER": "", "TLRR_SOC_AMOUNT": "000000009616C", "TLRR_SOC_INVOICE_NUMBER": "321487", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "234104", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "142137", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "03330041", "TLRR_AMEX_PAYEE_NUMBER": "5469999267", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "5469999267", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "379719XXXXX1002", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254T9183", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "9183", "TLRR_PAYMENT_NUMBER_TYPE": "T", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000109I", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "639446996", "TLRR_SE_REF_POA": "639446996488", "TLRR_SE_UNIT_NUMBER": "", "TLRR_SOC_AMOUNT": "000000009616C", "TLRR_SOC_INVOICE_NUMBER": "321487", "TLRR_TRAN_DATE": "2014253", "TRANSACTION_TIME": "051025", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "107040", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "03330041", "TLRR_AMEX_PAYEE_NUMBER": "5469999267", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "5469999267", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371712XXXXX2000", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254T9183", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "9183", "TLRR_PAYMENT_NUMBER_TYPE": "T", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000112A", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "702334123", "TLRR_SE_REF_POA": "702334123334", "TLRR_SE_UNIT_NUMBER": "", "TLRR_SOC_AMOUNT": "000000009616C", "TLRR_SOC_INVOICE_NUMBER": "321487", "TLRR_TRAN_DATE": "2014253", "TRANSACTION_TIME": "002240", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "144410", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "03330041", "TLRR_AMEX_PAYEE_NUMBER": "5469999267", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "5469999267", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "373122XXXXX1040", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254T9183", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "9183", "TLRR_PAYMENT_NUMBER_TYPE": "T", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000112D", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "708660152", "TLRR_SE_REF_POA": "708660152460", "TLRR_SE_UNIT_NUMBER": "", "TLRR_SOC_AMOUNT": "000000009616C", "TLRR_SOC_INVOICE_NUMBER": "321487", "TLRR_TRAN_DATE": "2014253", "TRANSACTION_TIME": "022221", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "182036", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "03330041", "TLRR_AMEX_PAYEE_NUMBER": "5469999267", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "5469999267", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "372401XXXXX4009", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254T9183", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "9183", "TLRR_PAYMENT_NUMBER_TYPE": "T", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000112I", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "212565429", "TLRR_SE_REF_POA": "212565429697", "TLRR_SE_UNIT_NUMBER": "", "TLRR_SOC_AMOUNT": "000000009616C", "TLRR_SOC_INVOICE_NUMBER": "321487", "TLRR_TRAN_DATE": "2014253", "TRANSACTION_TIME": "002117", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "183483", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "03330041", "TLRR_AMEX_PAYEE_NUMBER": "5469999267", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "5469999267", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "379728XXXXX1008", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254T9183", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "9183", "TLRR_PAYMENT_NUMBER_TYPE": "T", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000115{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "622913135", "TLRR_SE_REF_POA": "622913135666", "TLRR_SE_UNIT_NUMBER": "", "TLRR_SOC_AMOUNT": "000000009616C", "TLRR_SOC_INVOICE_NUMBER": "321487", "TLRR_TRAN_DATE": "2014253", "TRANSACTION_TIME": "043635", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "180753", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "03330041", "TLRR_AMEX_PAYEE_NUMBER": "5469999267", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "5469999267", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "377276XXXXX1006", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254T9183", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "9183", "TLRR_PAYMENT_NUMBER_TYPE": "T", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000150{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "510872693", "TLRR_SE_REF_POA": "510872693329", "TLRR_SE_UNIT_NUMBER": "", "TLRR_SOC_AMOUNT": "000000009616C", "TLRR_SOC_INVOICE_NUMBER": "321487", "TLRR_TRAN_DATE": "2014253", "TRANSACTION_TIME": "021521", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "433009", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "03330041", "TLRR_AMEX_PAYEE_NUMBER": "5469999267", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "5469999267", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "374355XXXXX4198", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254T9183", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "9183", "TLRR_PAYMENT_NUMBER_TYPE": "T", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000156{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "167462335", "TLRR_SE_REF_POA": "167462335778", "TLRR_SE_UNIT_NUMBER": "", "TLRR_SOC_AMOUNT": "000000009616C", "TLRR_SOC_INVOICE_NUMBER": "321487", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "214846", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "129023", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "03330041", "TLRR_AMEX_PAYEE_NUMBER": "5469999267", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "5469999267", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371243XXXXX2003", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254T9183", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "9183", "TLRR_PAYMENT_NUMBER_TYPE": "T", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000159D", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "816055282", "TLRR_SE_REF_POA": "816055282170", "TLRR_SE_UNIT_NUMBER": "", "TLRR_SOC_AMOUNT": "000000009616C", "TLRR_SOC_INVOICE_NUMBER": "321487", "TLRR_TRAN_DATE": "2014253", "TRANSACTION_TIME": "000718", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "107236", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "03330041", "TLRR_AMEX_PAYEE_NUMBER": "5469999267", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "5469999267", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "377285XXXXX1009", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254T9183", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "9183", "TLRR_PAYMENT_NUMBER_TYPE": "T", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000160A", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "734729082", "TLRR_SE_REF_POA": "734729082952", "TLRR_SE_UNIT_NUMBER": "", "TLRR_SOC_AMOUNT": "000000009616C", "TLRR_SOC_INVOICE_NUMBER": "321487", "TLRR_TRAN_DATE": "2014253", "TRANSACTION_TIME": "031742", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "142447", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "03330041", "TLRR_AMEX_PAYEE_NUMBER": "5469999267", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "5469999267", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371905XXXXX2009", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254T9183", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "9183", "TLRR_PAYMENT_NUMBER_TYPE": "T", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000160E", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "829944123", "TLRR_SE_REF_POA": "829944123819", "TLRR_SE_UNIT_NUMBER": "", "TLRR_SOC_AMOUNT": "000000009616C", "TLRR_SOC_INVOICE_NUMBER": "321487", "TLRR_TRAN_DATE": "2014253", "TRANSACTION_TIME": "014554", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "186267", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "03330041", "TLRR_AMEX_PAYEE_NUMBER": "5469999267", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "5469999267", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371734XXXXX1006", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254T9183", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "9183", "TLRR_PAYMENT_NUMBER_TYPE": "T", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000161C", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "408018580", "TLRR_SE_REF_POA": "408018580880", "TLRR_SE_UNIT_NUMBER": "", "TLRR_SOC_AMOUNT": "000000009616C", "TLRR_SOC_INVOICE_NUMBER": "321487", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "223105", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "182586", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "03330041", "TLRR_AMEX_PAYEE_NUMBER": "5469999267", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "5469999267", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371571XXXXX4009", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254T9183", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "9183", "TLRR_PAYMENT_NUMBER_TYPE": "T", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000162D", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "613689033", "TLRR_SE_REF_POA": "613689033465", "TLRR_SE_UNIT_NUMBER": "", "TLRR_SOC_AMOUNT": "000000009616C", "TLRR_SOC_INVOICE_NUMBER": "321487", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "231741", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "143857", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "03330041", "TLRR_AMEX_PAYEE_NUMBER": "5469999267", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "5469999267", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "377226XXXXX1009", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254T9183", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "9183", "TLRR_PAYMENT_NUMBER_TYPE": "T", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000339B", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "394107259", "TLRR_SE_REF_POA": "394107259950", "TLRR_SE_UNIT_NUMBER": "", "TLRR_SOC_AMOUNT": "000000009616C", "TLRR_SOC_INVOICE_NUMBER": "321487", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "221629", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "104874", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "03330041", "TLRR_AMEX_PAYEE_NUMBER": "5469999267", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "5469999267", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "376761XXXXX2036", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254T9183", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "9183", "TLRR_PAYMENT_NUMBER_TYPE": "T", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000720B", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "311249520", "TLRR_SE_REF_POA": "311249520916", "TLRR_SE_UNIT_NUMBER": "", "TLRR_SOC_AMOUNT": "000000009616C", "TLRR_SOC_INVOICE_NUMBER": "321487", "TLRR_TRAN_DATE": "2014253", "TRANSACTION_TIME": "001354", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "127040", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "03330041", "TLRR_AMEX_PAYEE_NUMBER": "5469999267", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "5469999267", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "372762XXXXX3011", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254T9183", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "9183", "TLRR_PAYMENT_NUMBER_TYPE": "T", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000840B", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "869638189", "TLRR_SE_REF_POA": "869638189734", "TLRR_SE_UNIT_NUMBER": "", "TLRR_SOC_AMOUNT": "000000009616C", "TLRR_SOC_INVOICE_NUMBER": "321487", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "224024", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "132319", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "03330041", "TLRR_AMEX_PAYEE_NUMBER": "5469999267", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "5469999267", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "379729XXXXX2011", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254T9183", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "9183", "TLRR_PAYMENT_NUMBER_TYPE": "T", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000844A", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "868067988", "TLRR_SE_REF_POA": "868067988993", "TLRR_SE_UNIT_NUMBER": "", "TLRR_SOC_AMOUNT": "000000009616C", "TLRR_SOC_INVOICE_NUMBER": "321487", "TLRR_TRAN_DATE": "2014252", "TRANSACTION_TIME": "224900", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "853009", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "03330041", "TLRR_AMEX_PAYEE_NUMBER": "5469999267", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "5469999267", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "374355XXXXX8332", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254T9183", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "9183", "TLRR_PAYMENT_NUMBER_TYPE": "T", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000000857B", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "913955523", "TLRR_SE_REF_POA": "913955523672", "TLRR_SE_UNIT_NUMBER": "", "TLRR_SOC_AMOUNT": "000000009616C", "TLRR_SOC_INVOICE_NUMBER": "321487", "TLRR_TRAN_DATE": "2014253", "TRANSACTION_TIME": "023845", "US_MR_INDICATOR": "" },
    { "APPROVAL_CODE": "189488", "MERCHANT_CATEGORY_CODE": "5943", "NON_COMPLIANT_ERROR_CODE_1": "", "NON_COMPLIANT_ERROR_CODE_2": "", "NON_COMPLIANT_ERROR_CODE_3": "", "NON_COMPLIANT_ERROR_CODE_4": "", "NON_COMPLIANT_INDICATOR": "", "NON_SWIPED_INDICATOR": "", "SE_REJ_IND": "", "TERMINAL_ID": "03330041", "TLRR_AMEX_PAYEE_NUMBER": "5469999267", "TLRR_AMEX_PROCESS_DATE": "2014253", "TLRR_AMEX_SE_NUMBER": "5469999267", "TLRR_CM_NUMB_EXD": "", "TLRR_CM_NUMBER": "371311XXXXX5018", "TLRR_CM_REF_NO": "", "TLRR_DETAIL_RECORD_TYPE": "11", "TLRR_PAYMENT_NUMBER": "254T9183", "TLRR_PAYMENT_NUMBER_DATE": "254", "TLRR_PAYMENT_NUMBER_NUMBER": "9183", "TLRR_PAYMENT_NUMBER_TYPE": "T", "TLRR_PAYMENT_YEAR": "2014", "TLRR_RECORD_TYPE": 3, "TLRR_ROC_AMOUNT": "000000004345{", "TLRR_ROC_NUMBER": "", "TLRR_SE_BUSINESS_DATE": "2014253", "TLRR_SE_REF": "627854115", "TLRR_SE_REF_POA": "627854115392", "TLRR_SE_UNIT_NUMBER": "", "TLRR_SOC_AMOUNT": "000000009616C", "TLRR_SOC_INVOICE_NUMBER": "321487", "TLRR_TRAN_DATE": "2014253", "TRANSACTION_TIME": "070843", "US_MR_INDICATOR": "" }
  ],
  "ROC_PRICING": [
    { "AMEX_PAYEE_NUMBER": "1049999176", "AMEX_SE_NUMBER": "1049999176", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "-00000000005711", "DISCOUNT_RATE": "+00002500", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254F8666", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "8666", "PAYMENT_NUMBER_TYPE": "F", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000002" },
    { "AMEX_PAYEE_NUMBER": "1049999176", "AMEX_SE_NUMBER": "1049999176", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000108", "DISCOUNT_RATE": "+00002500", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254F8666", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "8666", "PAYMENT_NUMBER_TYPE": "F", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000002" },
    { "AMEX_PAYEE_NUMBER": "1049999176", "AMEX_SE_NUMBER": "1049999176", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000108", "DISCOUNT_RATE": "+00002500", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254F8666", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "8666", "PAYMENT_NUMBER_TYPE": "F", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000002" },
    { "AMEX_PAYEE_NUMBER": "1049999176", "AMEX_SE_NUMBER": "1049999176", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000137", "DISCOUNT_RATE": "+00002500", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254F8666", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "8666", "PAYMENT_NUMBER_TYPE": "F", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000002" },
    { "AMEX_PAYEE_NUMBER": "1049999176", "AMEX_SE_NUMBER": "1049999176", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000244", "DISCOUNT_RATE": "+00002500", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254F8666", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "8666", "PAYMENT_NUMBER_TYPE": "F", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000002" },
    { "AMEX_PAYEE_NUMBER": "1049999176", "AMEX_SE_NUMBER": "1049999176", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000413", "DISCOUNT_RATE": "+00002500", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254F8666", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "8666", "PAYMENT_NUMBER_TYPE": "F", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000002" },
    { "AMEX_PAYEE_NUMBER": "1049999176", "AMEX_SE_NUMBER": "1049999176", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000773", "DISCOUNT_RATE": "+00002500", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254F8666", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "8666", "PAYMENT_NUMBER_TYPE": "F", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000002" },
    { "AMEX_PAYEE_NUMBER": "1049999176", "AMEX_SE_NUMBER": "1049999176", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000856", "DISCOUNT_RATE": "+00002500", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254F8666", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "8666", "PAYMENT_NUMBER_TYPE": "F", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000002" },
    { "AMEX_PAYEE_NUMBER": "1049999176", "AMEX_SE_NUMBER": "1049999176", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000001582", "DISCOUNT_RATE": "+00002500", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254F8666", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "8666", "PAYMENT_NUMBER_TYPE": "F", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000002" },
    { "AMEX_PAYEE_NUMBER": "1049999176", "AMEX_SE_NUMBER": "1049999176", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000002383", "DISCOUNT_RATE": "+00002500", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254F8666", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "8666", "PAYMENT_NUMBER_TYPE": "F", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000002" },
    { "AMEX_PAYEE_NUMBER": "1049999176", "AMEX_SE_NUMBER": "1049999176", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000002435", "DISCOUNT_RATE": "+00002500", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254F8666", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "8666", "PAYMENT_NUMBER_TYPE": "F", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000002" },
    { "AMEX_PAYEE_NUMBER": "1049999176", "AMEX_SE_NUMBER": "1049999176", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000002518", "DISCOUNT_RATE": "+00002500", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254F8666", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "8666", "PAYMENT_NUMBER_TYPE": "F", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000002" },
    { "AMEX_PAYEE_NUMBER": "1049999176", "AMEX_SE_NUMBER": "1049999176", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000003481", "DISCOUNT_RATE": "+00002500", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254F8666", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "8666", "PAYMENT_NUMBER_TYPE": "F", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000002" },
    { "AMEX_PAYEE_NUMBER": "1049999176", "AMEX_SE_NUMBER": "1049999176", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000003868", "DISCOUNT_RATE": "+00002500", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254F8666", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "8666", "PAYMENT_NUMBER_TYPE": "F", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000002" },
    { "AMEX_PAYEE_NUMBER": "1049999084", "AMEX_SE_NUMBER": "1049999084", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000143", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254H1728", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "1728", "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0SAN DIEGO" },
    { "AMEX_PAYEE_NUMBER": "1049999084", "AMEX_SE_NUMBER": "1049999084", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000178", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254H1728", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "1728", "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0SAN DIEGO" },
    { "AMEX_PAYEE_NUMBER": "1049999084", "AMEX_SE_NUMBER": "1049999084", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000294", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254H1728", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "1728", "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0SAN DIEGO" },
    { "AMEX_PAYEE_NUMBER": "1049999084", "AMEX_SE_NUMBER": "1049999084", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000297", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254H1728", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "1728", "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0SAN DIEGO" },
    { "AMEX_PAYEE_NUMBER": "1049999084", "AMEX_SE_NUMBER": "1049999084", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000443", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254H1728", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "1728", "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0SAN DIEGO" },
    { "AMEX_PAYEE_NUMBER": "1049999084", "AMEX_SE_NUMBER": "1049999084", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000454", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254H1728", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "1728", "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0SAN DIEGO" },
    { "AMEX_PAYEE_NUMBER": "1049999084", "AMEX_SE_NUMBER": "1049999084", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000001158", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254H1728", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "1728", "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0SAN DIEGO" },
    { "AMEX_PAYEE_NUMBER": "1049999084", "AMEX_SE_NUMBER": "1049999084", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000001485", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254H1728", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "1728", "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0SAN DIEGO" },
    { "AMEX_PAYEE_NUMBER": "1049999084", "AMEX_SE_NUMBER": "1049999084", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000005811", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254H1728", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "1728", "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0SAN DIEGO" },
    { "AMEX_PAYEE_NUMBER": "1049999700", "AMEX_SE_NUMBER": "1049999700", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "-00000000000550", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254H3242", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "3242", "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000007" },
    { "AMEX_PAYEE_NUMBER": "1049999700", "AMEX_SE_NUMBER": "1049999700", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "-00000000000386", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254H3242", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "3242", "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000007" },
    { "AMEX_PAYEE_NUMBER": "1049999700", "AMEX_SE_NUMBER": "1049999700", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000151", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254H3242", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "3242", "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000007" },
    { "AMEX_PAYEE_NUMBER": "1049999700", "AMEX_SE_NUMBER": "1049999700", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000151", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254H3242", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "3242", "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000007" },
    { "AMEX_PAYEE_NUMBER": "1049999700", "AMEX_SE_NUMBER": "1049999700", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000179", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254H3242", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "3242", "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000007" },
    { "AMEX_PAYEE_NUMBER": "1049999700", "AMEX_SE_NUMBER": "1049999700", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000178", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254H3242", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "3242", "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000007" },
    { "AMEX_PAYEE_NUMBER": "1049999700", "AMEX_SE_NUMBER": "1049999700", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000272", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254H3242", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "3242", "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000007" },
    { "AMEX_PAYEE_NUMBER": "1049999700", "AMEX_SE_NUMBER": "1049999700", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000275", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254H3242", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "3242", "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000007" },
    { "AMEX_PAYEE_NUMBER": "1049999700", "AMEX_SE_NUMBER": "1049999700", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000386", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254H3242", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "3242", "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000007" },
    { "AMEX_PAYEE_NUMBER": "1049999700", "AMEX_SE_NUMBER": "1049999700", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000002136", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254H3242", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "3242", "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000007" },
    { "AMEX_PAYEE_NUMBER": "1049999700", "AMEX_SE_NUMBER": "1049999700", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000003059", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254H3242", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "3242", "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000007" },
    { "AMEX_PAYEE_NUMBER": "1049999700", "AMEX_SE_NUMBER": "1049999700", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000006450", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254H3242", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "3242", "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000007" },
    { "AMEX_PAYEE_NUMBER": "1049999728", "AMEX_SE_NUMBER": "1049999728", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "-00000000006568", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254H3651", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "3651", "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000009" },
    { "AMEX_PAYEE_NUMBER": "1049999728", "AMEX_SE_NUMBER": "1049999728", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "-00000000006552", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254H3651", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "3651", "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000009" },
    { "AMEX_PAYEE_NUMBER": "1049999728", "AMEX_SE_NUMBER": "1049999728", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "-00000000006390", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254H3651", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "3651", "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000009" },
    { "AMEX_PAYEE_NUMBER": "1049999728", "AMEX_SE_NUMBER": "1049999728", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "-00000000005617", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254H3651", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "3651", "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000009" },
    { "AMEX_PAYEE_NUMBER": "1049999728", "AMEX_SE_NUMBER": "1049999728", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "-00000000003513", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254H3651", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "3651", "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000009" },
    { "AMEX_PAYEE_NUMBER": "1049999728", "AMEX_SE_NUMBER": "1049999728", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "-00000000003349", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254H3651", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "3651", "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000009" },
    { "AMEX_PAYEE_NUMBER": "1049999728", "AMEX_SE_NUMBER": "1049999728", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "-00000000000854", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254H3651", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "3651", "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000009" },
    { "AMEX_PAYEE_NUMBER": "1049999728", "AMEX_SE_NUMBER": "1049999728", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "-00000000000599", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254H3651", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "3651", "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000009" },
    { "AMEX_PAYEE_NUMBER": "1049999728", "AMEX_SE_NUMBER": "1049999728", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "-00000000000596", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254H3651", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "3651", "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000009" },
    { "AMEX_PAYEE_NUMBER": "1049999728", "AMEX_SE_NUMBER": "1049999728", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "-00000000000300", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254H3651", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "3651", "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000009" },
    { "AMEX_PAYEE_NUMBER": "1049999728", "AMEX_SE_NUMBER": "1049999728", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000006", "DISCOUNT_RATE": "+00001150", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "SV", "FEE_DESCRIPTION": "STORED VAL",         "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254H3651", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "3651", "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000009" },
    { "AMEX_PAYEE_NUMBER": "1049999728", "AMEX_SE_NUMBER": "1049999728", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000017", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254H3651", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "3651", "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000009" },
    { "AMEX_PAYEE_NUMBER": "1049999728", "AMEX_SE_NUMBER": "1049999728", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000028", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254H3651", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "3651", "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000009" },
    { "AMEX_PAYEE_NUMBER": "1049999728", "AMEX_SE_NUMBER": "1049999728", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000017", "DISCOUNT_RATE": "+00001150", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "SV", "FEE_DESCRIPTION": "STORED VAL",         "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254H3651", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "3651", "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000009" },
    { "AMEX_PAYEE_NUMBER": "1049999728", "AMEX_SE_NUMBER": "1049999728", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000042", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254H3651", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "3651", "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000009" },
    { "AMEX_PAYEE_NUMBER": "1049999728", "AMEX_SE_NUMBER": "1049999728", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000042", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254H3651", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "3651", "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000009" },
    { "AMEX_PAYEE_NUMBER": "1049999728", "AMEX_SE_NUMBER": "1049999728", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000069", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254H3651", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "3651", "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000009" },
    { "AMEX_PAYEE_NUMBER": "1049999728", "AMEX_SE_NUMBER": "1049999728", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000089", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254H3651", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "3651", "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000009" },
    { "AMEX_PAYEE_NUMBER": "1049999728", "AMEX_SE_NUMBER": "1049999728", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000120", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254H3651", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "3651", "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000009" },
    { "AMEX_PAYEE_NUMBER": "1049999728", "AMEX_SE_NUMBER": "1049999728", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000127", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254H3651", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "3651", "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000009" },
    { "AMEX_PAYEE_NUMBER": "1049999728", "AMEX_SE_NUMBER": "1049999728", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000135", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254H3651", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "3651", "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000009" },
    { "AMEX_PAYEE_NUMBER": "1049999728", "AMEX_SE_NUMBER": "1049999728", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000058", "DISCOUNT_RATE": "+00001150", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "SV", "FEE_DESCRIPTION": "STORED VAL",         "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254H3651", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "3651", "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000009" },
    { "AMEX_PAYEE_NUMBER": "1049999728", "AMEX_SE_NUMBER": "1049999728", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000147", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254H3651", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "3651", "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000009" },
    { "AMEX_PAYEE_NUMBER": "1049999728", "AMEX_SE_NUMBER": "1049999728", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000151", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254H3651", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "3651", "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000009" },
    { "AMEX_PAYEE_NUMBER": "1049999728", "AMEX_SE_NUMBER": "1049999728", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000152", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254H3651", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "3651", "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000009" },
    { "AMEX_PAYEE_NUMBER": "1049999728", "AMEX_SE_NUMBER": "1049999728", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000075", "DISCOUNT_RATE": "+00001150", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "SV", "FEE_DESCRIPTION": "STORED VAL",         "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254H3651", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "3651", "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000009" },
    { "AMEX_PAYEE_NUMBER": "1049999728", "AMEX_SE_NUMBER": "1049999728", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000180", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254H3651", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "3651", "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000009" },
    { "AMEX_PAYEE_NUMBER": "1049999728", "AMEX_SE_NUMBER": "1049999728", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000180", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254H3651", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "3651", "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000009" },
    { "AMEX_PAYEE_NUMBER": "1049999728", "AMEX_SE_NUMBER": "1049999728", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000180", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254H3651", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "3651", "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000009" },
    { "AMEX_PAYEE_NUMBER": "1049999728", "AMEX_SE_NUMBER": "1049999728", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000180", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254H3651", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "3651", "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000009" },
    { "AMEX_PAYEE_NUMBER": "1049999728", "AMEX_SE_NUMBER": "1049999728", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000180", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254H3651", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "3651", "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000009" },
    { "AMEX_PAYEE_NUMBER": "1049999728", "AMEX_SE_NUMBER": "1049999728", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000180", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254H3651", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "3651", "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000009" },
    { "AMEX_PAYEE_NUMBER": "1049999728", "AMEX_SE_NUMBER": "1049999728", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000180", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254H3651", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "3651", "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000009" },
    { "AMEX_PAYEE_NUMBER": "1049999728", "AMEX_SE_NUMBER": "1049999728", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000207", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254H3651", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "3651", "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000009" },
    { "AMEX_PAYEE_NUMBER": "1049999728", "AMEX_SE_NUMBER": "1049999728", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000209", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254H3651", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "3651", "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000009" },
    { "AMEX_PAYEE_NUMBER": "1049999728", "AMEX_SE_NUMBER": "1049999728", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000225", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254H3651", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "3651", "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000009" },
    { "AMEX_PAYEE_NUMBER": "1049999728", "AMEX_SE_NUMBER": "1049999728", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000270", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254H3651", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "3651", "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000009" },
    { "AMEX_PAYEE_NUMBER": "1049999728", "AMEX_SE_NUMBER": "1049999728", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000300", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254H3651", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "3651", "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000009" },
    { "AMEX_PAYEE_NUMBER": "1049999728", "AMEX_SE_NUMBER": "1049999728", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000359", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254H3651", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "3651", "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000009" },
    { "AMEX_PAYEE_NUMBER": "1049999728", "AMEX_SE_NUMBER": "1049999728", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000360", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254H3651", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "3651", "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000009" },
    { "AMEX_PAYEE_NUMBER": "1049999728", "AMEX_SE_NUMBER": "1049999728", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000390", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254H3651", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "3651", "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000009" },
    { "AMEX_PAYEE_NUMBER": "1049999728", "AMEX_SE_NUMBER": "1049999728", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000410", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254H3651", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "3651", "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000009" },
    { "AMEX_PAYEE_NUMBER": "1049999728", "AMEX_SE_NUMBER": "1049999728", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000410", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254H3651", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "3651", "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000009" },
    { "AMEX_PAYEE_NUMBER": "1049999728", "AMEX_SE_NUMBER": "1049999728", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000447", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254H3651", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "3651", "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000009" },
    { "AMEX_PAYEE_NUMBER": "1049999728", "AMEX_SE_NUMBER": "1049999728", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000569", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254H3651", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "3651", "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000009" },
    { "AMEX_PAYEE_NUMBER": "1049999728", "AMEX_SE_NUMBER": "1049999728", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000605", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254H3651", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "3651", "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000009" },
    { "AMEX_PAYEE_NUMBER": "1049999728", "AMEX_SE_NUMBER": "1049999728", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000893", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254H3651", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "3651", "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000009" },
    { "AMEX_PAYEE_NUMBER": "1049999728", "AMEX_SE_NUMBER": "1049999728", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000001041", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254H3651", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "3651", "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000009" },
    { "AMEX_PAYEE_NUMBER": "1049999728", "AMEX_SE_NUMBER": "1049999728", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000001059", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254H3651", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "3651", "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000009" },
    { "AMEX_PAYEE_NUMBER": "1049999728", "AMEX_SE_NUMBER": "1049999728", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000001146", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254H3651", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "3651", "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000009" },
    { "AMEX_PAYEE_NUMBER": "1049999728", "AMEX_SE_NUMBER": "1049999728", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000001226", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254H3651", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "3651", "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000009" },
    { "AMEX_PAYEE_NUMBER": "1049999728", "AMEX_SE_NUMBER": "1049999728", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000001376", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254H3651", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "3651", "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000009" },
    { "AMEX_PAYEE_NUMBER": "1049999728", "AMEX_SE_NUMBER": "1049999728", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000001457", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254H3651", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "3651", "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000009" },
    { "AMEX_PAYEE_NUMBER": "1049999728", "AMEX_SE_NUMBER": "1049999728", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000001529", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254H3651", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "3651", "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000009" },
    { "AMEX_PAYEE_NUMBER": "1049999728", "AMEX_SE_NUMBER": "1049999728", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000002304", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254H3651", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "3651", "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000009" },
    { "AMEX_PAYEE_NUMBER": "1049999728", "AMEX_SE_NUMBER": "1049999728", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000002816", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254H3651", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "3651", "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000009" },
    { "AMEX_PAYEE_NUMBER": "1049999728", "AMEX_SE_NUMBER": "1049999728", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000003000", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254H3651", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "3651", "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000009" },
    { "AMEX_PAYEE_NUMBER": "1049999728", "AMEX_SE_NUMBER": "1049999728", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000003054", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254H3651", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "3651", "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000009" },
    { "AMEX_PAYEE_NUMBER": "1049999728", "AMEX_SE_NUMBER": "1049999728", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000003270", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254H3651", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "3651", "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000009" },
    { "AMEX_PAYEE_NUMBER": "1049999728", "AMEX_SE_NUMBER": "1049999728", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000003270", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254H3651", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "3651", "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000009" },
    { "AMEX_PAYEE_NUMBER": "1049999728", "AMEX_SE_NUMBER": "1049999728", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000003399", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254H3651", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "3651", "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000009" },
    { "AMEX_PAYEE_NUMBER": "1049999728", "AMEX_SE_NUMBER": "1049999728", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000003413", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254H3651", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "3651", "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000009" },
    { "AMEX_PAYEE_NUMBER": "1049999728", "AMEX_SE_NUMBER": "1049999728", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000003857", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254H3651", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "3651", "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000009" },
    { "AMEX_PAYEE_NUMBER": "1049999728", "AMEX_SE_NUMBER": "1049999728", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000003896", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254H3651", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "3651", "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000009" },
    { "AMEX_PAYEE_NUMBER": "1049999728", "AMEX_SE_NUMBER": "1049999728", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000004307", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254H3651", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "3651", "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000009" },
    { "AMEX_PAYEE_NUMBER": "1049999728", "AMEX_SE_NUMBER": "1049999728", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000005488", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254H3651", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "3651", "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000009" },
    { "AMEX_PAYEE_NUMBER": "1049999728", "AMEX_SE_NUMBER": "1049999728", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000006782", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254H3651", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "3651", "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000009" },
    { "AMEX_PAYEE_NUMBER": "1049999728", "AMEX_SE_NUMBER": "1049999728", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000007354", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254H3651", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "3651", "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000009" },
    { "AMEX_PAYEE_NUMBER": "1049999121", "AMEX_SE_NUMBER": "1049999121", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "-00000000004609", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254H4390", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "4390", "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000015" },
    { "AMEX_PAYEE_NUMBER": "1049999121", "AMEX_SE_NUMBER": "1049999121", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "-00000000002547", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254H4390", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "4390", "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000015" },
    { "AMEX_PAYEE_NUMBER": "1049999121", "AMEX_SE_NUMBER": "1049999121", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "-00000000001028", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254H4390", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "4390", "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000015" },
    { "AMEX_PAYEE_NUMBER": "1049999121", "AMEX_SE_NUMBER": "1049999121", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "-00000000000106", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254H4390", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "4390", "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000015" },
    { "AMEX_PAYEE_NUMBER": "1049999121", "AMEX_SE_NUMBER": "1049999121", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000106", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254H4390", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "4390", "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000015" },
    { "AMEX_PAYEE_NUMBER": "1049999121", "AMEX_SE_NUMBER": "1049999121", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000120", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254H4390", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "4390", "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000015" },
    { "AMEX_PAYEE_NUMBER": "1049999121", "AMEX_SE_NUMBER": "1049999121", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000152", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254H4390", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "4390", "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000015" },
    { "AMEX_PAYEE_NUMBER": "1049999121", "AMEX_SE_NUMBER": "1049999121", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000152", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254H4390", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "4390", "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000015" },
    { "AMEX_PAYEE_NUMBER": "1049999121", "AMEX_SE_NUMBER": "1049999121", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000152", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254H4390", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "4390", "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000015" },
    { "AMEX_PAYEE_NUMBER": "1049999121", "AMEX_SE_NUMBER": "1049999121", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000410", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254H4390", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "4390", "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000015" },
    { "AMEX_PAYEE_NUMBER": "1049999121", "AMEX_SE_NUMBER": "1049999121", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000792", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254H4390", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "4390", "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000015" },
    { "AMEX_PAYEE_NUMBER": "1049999121", "AMEX_SE_NUMBER": "1049999121", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000918", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254H4390", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "4390", "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000015" },
    { "AMEX_PAYEE_NUMBER": "1049999121", "AMEX_SE_NUMBER": "1049999121", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000001028", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254H4390", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "4390", "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000015" },
    { "AMEX_PAYEE_NUMBER": "1049999121", "AMEX_SE_NUMBER": "1049999121", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000001028", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254H4390", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "4390", "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000015" },
    { "AMEX_PAYEE_NUMBER": "1049999121", "AMEX_SE_NUMBER": "1049999121", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000001194", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254H4390", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "4390", "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000015" },
    { "AMEX_PAYEE_NUMBER": "1049999121", "AMEX_SE_NUMBER": "1049999121", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000001193", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254H4390", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "4390", "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000015" },
    { "AMEX_PAYEE_NUMBER": "1049999121", "AMEX_SE_NUMBER": "1049999121", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000001428", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254H4390", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "4390", "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000015" },
    { "AMEX_PAYEE_NUMBER": "1049999121", "AMEX_SE_NUMBER": "1049999121", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000002012", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254H4390", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "4390", "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000015" },
    { "AMEX_PAYEE_NUMBER": "1049999121", "AMEX_SE_NUMBER": "1049999121", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000003849", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254H4390", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "4390", "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000015" },
    { "AMEX_PAYEE_NUMBER": "1049999121", "AMEX_SE_NUMBER": "1049999121", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000004436", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254H4390", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "4390", "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000015" },
    { "AMEX_PAYEE_NUMBER": "1049999121", "AMEX_SE_NUMBER": "1049999121", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000006900", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254H4390", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "4390", "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000015" },
    { "AMEX_PAYEE_NUMBER": "1049999246", "AMEX_SE_NUMBER": "1049999246", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000075", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254H5067", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "5067", "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000017" },
    { "AMEX_PAYEE_NUMBER": "1049999246", "AMEX_SE_NUMBER": "1049999246", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000090", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254H5067", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "5067", "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000017" },
    { "AMEX_PAYEE_NUMBER": "1049999246", "AMEX_SE_NUMBER": "1049999246", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000538", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254H5067", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "5067", "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000017" },
    { "AMEX_PAYEE_NUMBER": "1049999246", "AMEX_SE_NUMBER": "1049999246", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000001166", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254H5067", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "5067", "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000017" },
    { "AMEX_PAYEE_NUMBER": "1049999246", "AMEX_SE_NUMBER": "1049999246", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000001193", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254H5067", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "5067", "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000017" },
    { "AMEX_PAYEE_NUMBER": "1049999246", "AMEX_SE_NUMBER": "1049999246", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000001497", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254H5067", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "5067", "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000017" },
    { "AMEX_PAYEE_NUMBER": "1049999246", "AMEX_SE_NUMBER": "1049999246", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000004491", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254H5067", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "5067", "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000017" },
    { "AMEX_PAYEE_NUMBER": "1059999079", "AMEX_SE_NUMBER": "1059999079", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000088", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254H9133", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "9133", "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "PARK MEADO" },
    { "AMEX_PAYEE_NUMBER": "1059999079", "AMEX_SE_NUMBER": "1059999079", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000045", "DISCOUNT_RATE": "+00001150", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "SV", "FEE_DESCRIPTION": "STORED VAL",         "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254H9133", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "9133", "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "PARK MEADO" },
    { "AMEX_PAYEE_NUMBER": "1059999079", "AMEX_SE_NUMBER": "1059999079", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000117", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254H9133", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "9133", "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "PARK MEADO" },
    { "AMEX_PAYEE_NUMBER": "1059999079", "AMEX_SE_NUMBER": "1059999079", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000266", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254H9133", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "9133", "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "PARK MEADO" },
    { "AMEX_PAYEE_NUMBER": "1059999079", "AMEX_SE_NUMBER": "1059999079", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000587", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254H9133", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "9133", "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "PARK MEADO" },
    { "AMEX_PAYEE_NUMBER": "1059999079", "AMEX_SE_NUMBER": "1059999079", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000001224", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254H9133", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "9133", "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "PARK MEADO" },
    { "AMEX_PAYEE_NUMBER": "1059999079", "AMEX_SE_NUMBER": "1059999079", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000005635", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254H9133", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "9133", "PAYMENT_NUMBER_TYPE": "H", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "PARK MEADO" },
    { "AMEX_PAYEE_NUMBER": "1099999509", "AMEX_SE_NUMBER": "1099999509", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000116", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254E6857", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "6857", "PAYMENT_NUMBER_TYPE": "E", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000STR#60" },
    { "AMEX_PAYEE_NUMBER": "1099999509", "AMEX_SE_NUMBER": "1099999509", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000235", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254E6857", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "6857", "PAYMENT_NUMBER_TYPE": "E", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000STR#60" },
    { "AMEX_PAYEE_NUMBER": "1099999509", "AMEX_SE_NUMBER": "1099999509", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000506", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254E6857", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "6857", "PAYMENT_NUMBER_TYPE": "E", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000STR#60" },
    { "AMEX_PAYEE_NUMBER": "1099999509", "AMEX_SE_NUMBER": "1099999509", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000588", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254E6857", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "6857", "PAYMENT_NUMBER_TYPE": "E", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000STR#60" },
    { "AMEX_PAYEE_NUMBER": "1099999509", "AMEX_SE_NUMBER": "1099999509", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000608", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254E6857", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "6857", "PAYMENT_NUMBER_TYPE": "E", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000STR#60" },
    { "AMEX_PAYEE_NUMBER": "1099999509", "AMEX_SE_NUMBER": "1099999509", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000001037", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254E6857", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "6857", "PAYMENT_NUMBER_TYPE": "E", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000STR#60" },
    { "AMEX_PAYEE_NUMBER": "1099999509", "AMEX_SE_NUMBER": "1099999509", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000001753", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254E6857", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "6857", "PAYMENT_NUMBER_TYPE": "E", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000STR#60" },
    { "AMEX_PAYEE_NUMBER": "1099999509", "AMEX_SE_NUMBER": "1099999509", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000001851", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254E6857", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "6857", "PAYMENT_NUMBER_TYPE": "E", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000STR#60" },
    { "AMEX_PAYEE_NUMBER": "1099999509", "AMEX_SE_NUMBER": "1099999509", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000002734", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254E6857", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "6857", "PAYMENT_NUMBER_TYPE": "E", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000STR#60" },
    { "AMEX_PAYEE_NUMBER": "1099999509", "AMEX_SE_NUMBER": "1099999509", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000003822", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254E6857", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "6857", "PAYMENT_NUMBER_TYPE": "E", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000STR#60" },
    { "AMEX_PAYEE_NUMBER": "1159999126", "AMEX_SE_NUMBER": "1159999126", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000108", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254J2806", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "2806", "PAYMENT_NUMBER_TYPE": "J", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "000STR #25" },
    { "AMEX_PAYEE_NUMBER": "1159999126", "AMEX_SE_NUMBER": "1159999126", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000180", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254J2806", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "2806", "PAYMENT_NUMBER_TYPE": "J", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "000STR #25" },
    { "AMEX_PAYEE_NUMBER": "1159999126", "AMEX_SE_NUMBER": "1159999126", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000921", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254J2806", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "2806", "PAYMENT_NUMBER_TYPE": "J", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "000STR #25" },
    { "AMEX_PAYEE_NUMBER": "1159999126", "AMEX_SE_NUMBER": "1159999126", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000003741", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254J2806", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "2806", "PAYMENT_NUMBER_TYPE": "J", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "000STR #25" },
    { "AMEX_PAYEE_NUMBER": "1269999580", "AMEX_SE_NUMBER": "1269999580", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000235", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254J4690", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "4690", "PAYMENT_NUMBER_TYPE": "J", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "00STR#8070" },
    { "AMEX_PAYEE_NUMBER": "1319999989", "AMEX_SE_NUMBER": "1319999989", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000069", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254G2302", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "2302", "PAYMENT_NUMBER_TYPE": "G", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000044" },
    { "AMEX_PAYEE_NUMBER": "1319999989", "AMEX_SE_NUMBER": "1319999989", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000179", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254G2302", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "2302", "PAYMENT_NUMBER_TYPE": "G", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000044" },
    { "AMEX_PAYEE_NUMBER": "1319999989", "AMEX_SE_NUMBER": "1319999989", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000226", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254G2302", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "2302", "PAYMENT_NUMBER_TYPE": "G", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000044" },
    { "AMEX_PAYEE_NUMBER": "1319999989", "AMEX_SE_NUMBER": "1319999989", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000296", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254G2302", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "2302", "PAYMENT_NUMBER_TYPE": "G", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000044" },
    { "AMEX_PAYEE_NUMBER": "1319999989", "AMEX_SE_NUMBER": "1319999989", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000358", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254G2302", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "2302", "PAYMENT_NUMBER_TYPE": "G", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000044" },
    { "AMEX_PAYEE_NUMBER": "1319999989", "AMEX_SE_NUMBER": "1319999989", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000376", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254G2302", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "2302", "PAYMENT_NUMBER_TYPE": "G", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000044" },
    { "AMEX_PAYEE_NUMBER": "1319999989", "AMEX_SE_NUMBER": "1319999989", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000418", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254G2302", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "2302", "PAYMENT_NUMBER_TYPE": "G", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000044" },
    { "AMEX_PAYEE_NUMBER": "1319999989", "AMEX_SE_NUMBER": "1319999989", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000001193", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254G2302", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "2302", "PAYMENT_NUMBER_TYPE": "G", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000044" },
    { "AMEX_PAYEE_NUMBER": "1319999989", "AMEX_SE_NUMBER": "1319999989", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000001219", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254G2302", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "2302", "PAYMENT_NUMBER_TYPE": "G", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000044" },
    { "AMEX_PAYEE_NUMBER": "1319999989", "AMEX_SE_NUMBER": "1319999989", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000001624", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254G2302", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "2302", "PAYMENT_NUMBER_TYPE": "G", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000044" },
    { "AMEX_PAYEE_NUMBER": "1319999989", "AMEX_SE_NUMBER": "1319999989", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000003492", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254G2302", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "2302", "PAYMENT_NUMBER_TYPE": "G", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000044" },
    { "AMEX_PAYEE_NUMBER": "1319999989", "AMEX_SE_NUMBER": "1319999989", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000005371", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254G2302", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "2302", "PAYMENT_NUMBER_TYPE": "G", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000044" },
    { "AMEX_PAYEE_NUMBER": "1319999284", "AMEX_SE_NUMBER": "1319999284", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000152", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254G2626", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "2626", "PAYMENT_NUMBER_TYPE": "G", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "00STR#8082" },
    { "AMEX_PAYEE_NUMBER": "1319999284", "AMEX_SE_NUMBER": "1319999284", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000179", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254G2626", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "2626", "PAYMENT_NUMBER_TYPE": "G", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "00STR#8082" },
    { "AMEX_PAYEE_NUMBER": "1319999284", "AMEX_SE_NUMBER": "1319999284", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000003836", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254G2626", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "2626", "PAYMENT_NUMBER_TYPE": "G", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "00STR#8082" },
    { "AMEX_PAYEE_NUMBER": "2049999582", "AMEX_SE_NUMBER": "2049999582", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000005017", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254M2653", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "2653", "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000008063" },
    { "AMEX_PAYEE_NUMBER": "2049999873", "AMEX_SE_NUMBER": "2049999873", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": " 00000000000000", "DISCOUNT_RATE": "+00001150", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "RP", "FEE_DESCRIPTION": "RELOADABLE",         "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254M3251", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "3251", "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "000STR #62" },
    { "AMEX_PAYEE_NUMBER": "2049999873", "AMEX_SE_NUMBER": "2049999873", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": " 00000000000000", "DISCOUNT_RATE": "+00001150", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "RP", "FEE_DESCRIPTION": "RELOADABLE",         "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254M3251", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "3251", "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "000STR #62" },
    { "AMEX_PAYEE_NUMBER": "2049999873", "AMEX_SE_NUMBER": "2049999873", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": " 00000000000000", "DISCOUNT_RATE": "+00001150", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "RP", "FEE_DESCRIPTION": "RELOADABLE",         "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254M3251", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "3251", "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "000STR #62" },
    { "AMEX_PAYEE_NUMBER": "2049999873", "AMEX_SE_NUMBER": "2049999873", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": " 00000000000000", "DISCOUNT_RATE": "+00001150", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "RP", "FEE_DESCRIPTION": "RELOADABLE",         "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254M3251", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "3251", "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "000STR #62" },
    { "AMEX_PAYEE_NUMBER": "2069999156", "AMEX_SE_NUMBER": "2069999156", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000048", "DISCOUNT_RATE": "+00001150", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "RP", "FEE_DESCRIPTION": "RELOADABLE",         "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254G5069", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "5069", "PAYMENT_NUMBER_TYPE": "G", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "000STR #18" },
    { "AMEX_PAYEE_NUMBER": "2069999156", "AMEX_SE_NUMBER": "2069999156", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000148", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254G5069", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "5069", "PAYMENT_NUMBER_TYPE": "G", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "000STR #18" },
    { "AMEX_PAYEE_NUMBER": "2069999156", "AMEX_SE_NUMBER": "2069999156", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000175", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254G5069", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "5069", "PAYMENT_NUMBER_TYPE": "G", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "000STR #18" },
    { "AMEX_PAYEE_NUMBER": "2069999156", "AMEX_SE_NUMBER": "2069999156", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000414", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254G5069", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "5069", "PAYMENT_NUMBER_TYPE": "G", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "000STR #18" },
    { "AMEX_PAYEE_NUMBER": "2069999156", "AMEX_SE_NUMBER": "2069999156", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000919", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254G5069", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "5069", "PAYMENT_NUMBER_TYPE": "G", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "000STR #18" },
    { "AMEX_PAYEE_NUMBER": "2069999156", "AMEX_SE_NUMBER": "2069999156", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000980", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254G5069", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "5069", "PAYMENT_NUMBER_TYPE": "G", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "000STR #18" },
    { "AMEX_PAYEE_NUMBER": "2199999562", "AMEX_SE_NUMBER": "2199999562", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000233", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254I0352", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "0352", "PAYMENT_NUMBER_TYPE": "I", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "00STR#8060" },
    { "AMEX_PAYEE_NUMBER": "2199999562", "AMEX_SE_NUMBER": "2199999562", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000321", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254I0352", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "0352", "PAYMENT_NUMBER_TYPE": "I", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "00STR#8060" },
    { "AMEX_PAYEE_NUMBER": "2199999562", "AMEX_SE_NUMBER": "2199999562", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000001163", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254I0352", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "0352", "PAYMENT_NUMBER_TYPE": "I", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "00STR#8060" },
    { "AMEX_PAYEE_NUMBER": "2199999562", "AMEX_SE_NUMBER": "2199999562", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000001163", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254I0352", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "0352", "PAYMENT_NUMBER_TYPE": "I", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "00STR#8060" },
    { "AMEX_PAYEE_NUMBER": "2199999562", "AMEX_SE_NUMBER": "2199999562", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000001328", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254I0352", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "0352", "PAYMENT_NUMBER_TYPE": "I", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "00STR#8060" },
    { "AMEX_PAYEE_NUMBER": "2199999169", "AMEX_SE_NUMBER": "2199999169", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000233", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254I0383", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "0383", "PAYMENT_NUMBER_TYPE": "I", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0Str #8085" },
    { "AMEX_PAYEE_NUMBER": "2299999656", "AMEX_SE_NUMBER": "2299999656", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "-00000000000074", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254L1705", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "1705", "PAYMENT_NUMBER_TYPE": "L", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000022" },
    { "AMEX_PAYEE_NUMBER": "2299999656", "AMEX_SE_NUMBER": "2299999656", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000176", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254L1705", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "1705", "PAYMENT_NUMBER_TYPE": "L", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000022" },
    { "AMEX_PAYEE_NUMBER": "2299999656", "AMEX_SE_NUMBER": "2299999656", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000115", "DISCOUNT_RATE": "+00001150", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "SV", "FEE_DESCRIPTION": "STORED VAL",         "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254L1705", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "1705", "PAYMENT_NUMBER_TYPE": "L", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000022" },
    { "AMEX_PAYEE_NUMBER": "2299999656", "AMEX_SE_NUMBER": "2299999656", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000605", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254L1705", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "1705", "PAYMENT_NUMBER_TYPE": "L", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000022" },
    { "AMEX_PAYEE_NUMBER": "2299999656", "AMEX_SE_NUMBER": "2299999656", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000001014", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254L1705", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "1705", "PAYMENT_NUMBER_TYPE": "L", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000022" },
    { "AMEX_PAYEE_NUMBER": "2299999656", "AMEX_SE_NUMBER": "2299999656", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000003322", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254L1705", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "1705", "PAYMENT_NUMBER_TYPE": "L", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000022" },
    { "AMEX_PAYEE_NUMBER": "2299999510", "AMEX_SE_NUMBER": "2299999510", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "-00000000000197", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254L1727", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "1727", "PAYMENT_NUMBER_TYPE": "L", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000023" },
    { "AMEX_PAYEE_NUMBER": "2299999510", "AMEX_SE_NUMBER": "2299999510", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "-00000000000007", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254L1727", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "1727", "PAYMENT_NUMBER_TYPE": "L", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000023" },
    { "AMEX_PAYEE_NUMBER": "2299999510", "AMEX_SE_NUMBER": "2299999510", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000144", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254L1727", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "1727", "PAYMENT_NUMBER_TYPE": "L", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000023" },
    { "AMEX_PAYEE_NUMBER": "2299999510", "AMEX_SE_NUMBER": "2299999510", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000147", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254L1727", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "1727", "PAYMENT_NUMBER_TYPE": "L", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000023" },
    { "AMEX_PAYEE_NUMBER": "2299999510", "AMEX_SE_NUMBER": "2299999510", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000149", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254L1727", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "1727", "PAYMENT_NUMBER_TYPE": "L", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000023" },
    { "AMEX_PAYEE_NUMBER": "2299999510", "AMEX_SE_NUMBER": "2299999510", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000353", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254L1727", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "1727", "PAYMENT_NUMBER_TYPE": "L", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000023" },
    { "AMEX_PAYEE_NUMBER": "2299999510", "AMEX_SE_NUMBER": "2299999510", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000001027", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254L1727", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "1727", "PAYMENT_NUMBER_TYPE": "L", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000023" },
    { "AMEX_PAYEE_NUMBER": "2299999510", "AMEX_SE_NUMBER": "2299999510", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000002117", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254L1727", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "1727", "PAYMENT_NUMBER_TYPE": "L", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000023" },
    { "AMEX_PAYEE_NUMBER": "2299999510", "AMEX_SE_NUMBER": "2299999510", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000006026", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254L1727", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "1727", "PAYMENT_NUMBER_TYPE": "L", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000023" },
    { "AMEX_PAYEE_NUMBER": "2299999510", "AMEX_SE_NUMBER": "2299999510", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000014553", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254L1727", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "1727", "PAYMENT_NUMBER_TYPE": "L", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000023" },
    { "AMEX_PAYEE_NUMBER": "2299999979", "AMEX_SE_NUMBER": "2299999979", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "-00000000002734", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254L2581", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "2581", "PAYMENT_NUMBER_TYPE": "L", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000055" },
    { "AMEX_PAYEE_NUMBER": "2299999979", "AMEX_SE_NUMBER": "2299999979", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "-00000000002498", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254L2581", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "2581", "PAYMENT_NUMBER_TYPE": "L", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000055" },
    { "AMEX_PAYEE_NUMBER": "2299999979", "AMEX_SE_NUMBER": "2299999979", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "-00000000001318", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254L2581", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "2581", "PAYMENT_NUMBER_TYPE": "L", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000055" },
    { "AMEX_PAYEE_NUMBER": "2299999979", "AMEX_SE_NUMBER": "2299999979", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000122", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254L2581", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "2581", "PAYMENT_NUMBER_TYPE": "L", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000055" },
    { "AMEX_PAYEE_NUMBER": "2299999979", "AMEX_SE_NUMBER": "2299999979", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000147", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254L2581", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "2581", "PAYMENT_NUMBER_TYPE": "L", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000055" },
    { "AMEX_PAYEE_NUMBER": "2299999979", "AMEX_SE_NUMBER": "2299999979", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000438", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254L2581", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "2581", "PAYMENT_NUMBER_TYPE": "L", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000055" },
    { "AMEX_PAYEE_NUMBER": "2299999979", "AMEX_SE_NUMBER": "2299999979", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000441", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254L2581", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "2581", "PAYMENT_NUMBER_TYPE": "L", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000055" },
    { "AMEX_PAYEE_NUMBER": "2299999979", "AMEX_SE_NUMBER": "2299999979", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000573", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254L2581", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "2581", "PAYMENT_NUMBER_TYPE": "L", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000055" },
    { "AMEX_PAYEE_NUMBER": "2299999979", "AMEX_SE_NUMBER": "2299999979", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000942", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254L2581", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "2581", "PAYMENT_NUMBER_TYPE": "L", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000055" },
    { "AMEX_PAYEE_NUMBER": "2299999979", "AMEX_SE_NUMBER": "2299999979", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000001189", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254L2581", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "2581", "PAYMENT_NUMBER_TYPE": "L", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000055" },
    { "AMEX_PAYEE_NUMBER": "2299999979", "AMEX_SE_NUMBER": "2299999979", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000002076", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254L2581", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "2581", "PAYMENT_NUMBER_TYPE": "L", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000055" },
    { "AMEX_PAYEE_NUMBER": "2299999979", "AMEX_SE_NUMBER": "2299999979", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000005910", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254L2581", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "2581", "PAYMENT_NUMBER_TYPE": "L", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000055" },
    { "AMEX_PAYEE_NUMBER": "2379999582", "AMEX_SE_NUMBER": "2379999582", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000899", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254L8733", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "8733", "PAYMENT_NUMBER_TYPE": "L", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000008062" },
    { "AMEX_PAYEE_NUMBER": "2429999928", "AMEX_SE_NUMBER": "2429999928", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "-00000000000744", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254M5144", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "5144", "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000012" },
    { "AMEX_PAYEE_NUMBER": "2429999928", "AMEX_SE_NUMBER": "2429999928", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000045", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254M5144", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "5144", "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000012" },
    { "AMEX_PAYEE_NUMBER": "2429999928", "AMEX_SE_NUMBER": "2429999928", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000506", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254M5144", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "5144", "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000012" },
    { "AMEX_PAYEE_NUMBER": "2429999928", "AMEX_SE_NUMBER": "2429999928", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000888", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254M5144", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "5144", "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000012" },
    { "AMEX_PAYEE_NUMBER": "2429999928", "AMEX_SE_NUMBER": "2429999928", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000001328", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254M5144", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "5144", "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000012" },
    { "AMEX_PAYEE_NUMBER": "2429999928", "AMEX_SE_NUMBER": "2429999928", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000001991", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254M5144", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "5144", "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000012" },
    { "AMEX_PAYEE_NUMBER": "2429999928", "AMEX_SE_NUMBER": "2429999928", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000002018", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254M5144", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "5144", "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000012" },
    { "AMEX_PAYEE_NUMBER": "2429999928", "AMEX_SE_NUMBER": "2429999928", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000005499", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254M5144", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "5144", "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000012" },
    { "AMEX_PAYEE_NUMBER": "2429999928", "AMEX_SE_NUMBER": "2429999928", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000005531", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254M5144", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "5144", "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000012" },
    { "AMEX_PAYEE_NUMBER": "2429999928", "AMEX_SE_NUMBER": "2429999928", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000006125", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254M5144", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "5144", "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000012" },
    { "AMEX_PAYEE_NUMBER": "2429999564", "AMEX_SE_NUMBER": "2429999564", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000142", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254M5619", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "5619", "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000011" },
    { "AMEX_PAYEE_NUMBER": "2429999564", "AMEX_SE_NUMBER": "2429999564", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000149", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254M5619", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "5619", "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000011" },
    { "AMEX_PAYEE_NUMBER": "2429999564", "AMEX_SE_NUMBER": "2429999564", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000001809", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254M5619", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "5619", "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000011" },
    { "AMEX_PAYEE_NUMBER": "2429999564", "AMEX_SE_NUMBER": "2429999564", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000002873", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254M5619", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "5619", "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000011" },
    { "AMEX_PAYEE_NUMBER": "2429999564", "AMEX_SE_NUMBER": "2429999564", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000004576", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254M5619", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "5619", "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000011" },
    { "AMEX_PAYEE_NUMBER": "2429999740", "AMEX_SE_NUMBER": "2429999740", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000179", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254M9006", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "9006", "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000061" },
    { "AMEX_PAYEE_NUMBER": "2429999740", "AMEX_SE_NUMBER": "2429999740", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000001337", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254M9006", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "9006", "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000061" },
    { "AMEX_PAYEE_NUMBER": "2429999740", "AMEX_SE_NUMBER": "2429999740", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000001364", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254M9006", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "9006", "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000061" },
    { "AMEX_PAYEE_NUMBER": "2429999740", "AMEX_SE_NUMBER": "2429999740", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000003028", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254M9006", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "9006", "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000061" },
    { "AMEX_PAYEE_NUMBER": "2429999740", "AMEX_SE_NUMBER": "2429999740", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000003299", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254M9006", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "9006", "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000061" },
    { "AMEX_PAYEE_NUMBER": "2429999740", "AMEX_SE_NUMBER": "2429999740", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000003829", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254M9006", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "9006", "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000061" },
    { "AMEX_PAYEE_NUMBER": "2429999740", "AMEX_SE_NUMBER": "2429999740", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000005975", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254M9006", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "9006", "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000061" },
    { "AMEX_PAYEE_NUMBER": "2429999034", "AMEX_SE_NUMBER": "2429999034", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000001188", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254M9224", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "9224", "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0STR #8061" },
    { "AMEX_PAYEE_NUMBER": "3129999193", "AMEX_SE_NUMBER": "3129999193", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000012", "DISCOUNT_RATE": "+00001150", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "SV", "FEE_DESCRIPTION": "STORED VAL",         "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254M4165", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "4165", "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000008" },
    { "AMEX_PAYEE_NUMBER": "3129999193", "AMEX_SE_NUMBER": "3129999193", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000030", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254M4165", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "4165", "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000008" },
    { "AMEX_PAYEE_NUMBER": "3129999193", "AMEX_SE_NUMBER": "3129999193", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000023", "DISCOUNT_RATE": "+00001150", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "SV", "FEE_DESCRIPTION": "STORED VAL",         "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254M4165", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "4165", "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000008" },
    { "AMEX_PAYEE_NUMBER": "3129999193", "AMEX_SE_NUMBER": "3129999193", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000028", "DISCOUNT_RATE": "+00001150", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "SV", "FEE_DESCRIPTION": "STORED VAL",         "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254M4165", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "4165", "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000008" },
    { "AMEX_PAYEE_NUMBER": "3129999193", "AMEX_SE_NUMBER": "3129999193", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000148", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254M4165", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "4165", "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000008" },
    { "AMEX_PAYEE_NUMBER": "3129999193", "AMEX_SE_NUMBER": "3129999193", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000356", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254M4165", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "4165", "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000008" },
    { "AMEX_PAYEE_NUMBER": "3129999193", "AMEX_SE_NUMBER": "3129999193", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000005494", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254M4165", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "4165", "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000008" },
    { "AMEX_PAYEE_NUMBER": "3129999193", "AMEX_SE_NUMBER": "3129999193", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000011233", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254M4165", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "4165", "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000008" },
    { "AMEX_PAYEE_NUMBER": "3229999977", "AMEX_SE_NUMBER": "3229999977", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000039", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254M7990", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "7990", "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000005" },
    { "AMEX_PAYEE_NUMBER": "3229999977", "AMEX_SE_NUMBER": "3229999977", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000029", "DISCOUNT_RATE": "+00001150", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "SV", "FEE_DESCRIPTION": "STORED VAL",         "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254M7990", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "7990", "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000005" },
    { "AMEX_PAYEE_NUMBER": "3229999977", "AMEX_SE_NUMBER": "3229999977", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000293", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254M7990", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "7990", "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000005" },
    { "AMEX_PAYEE_NUMBER": "3229999977", "AMEX_SE_NUMBER": "3229999977", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000378", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254M7990", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "7990", "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000005" },
    { "AMEX_PAYEE_NUMBER": "3229999977", "AMEX_SE_NUMBER": "3229999977", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000001726", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254M7990", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "7990", "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000005" },
    { "AMEX_PAYEE_NUMBER": "3229999977", "AMEX_SE_NUMBER": "3229999977", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000003051", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254M7990", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "7990", "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000005" },
    { "AMEX_PAYEE_NUMBER": "3229999977", "AMEX_SE_NUMBER": "3229999977", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000003249", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254M7990", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "7990", "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000005" },
    { "AMEX_PAYEE_NUMBER": "3229999977", "AMEX_SE_NUMBER": "3229999977", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000003601", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254M7990", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "7990", "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000005" },
    { "AMEX_PAYEE_NUMBER": "3229999977", "AMEX_SE_NUMBER": "3229999977", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000006043", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254M7990", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "7990", "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000005" },
    { "AMEX_PAYEE_NUMBER": "3229999977", "AMEX_SE_NUMBER": "3229999977", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000008844", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254M7990", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "7990", "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000005" },
    { "AMEX_PAYEE_NUMBER": "4109999881", "AMEX_SE_NUMBER": "4109999881", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "-00000000000803", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254M5048", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "5048", "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000014" },
    { "AMEX_PAYEE_NUMBER": "4109999881", "AMEX_SE_NUMBER": "4109999881", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "-00000000000386", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254M5048", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "5048", "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000014" },
    { "AMEX_PAYEE_NUMBER": "4109999881", "AMEX_SE_NUMBER": "4109999881", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000012", "DISCOUNT_RATE": "+00001150", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "SV", "FEE_DESCRIPTION": "STORED VAL",         "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254M5048", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "5048", "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000014" },
    { "AMEX_PAYEE_NUMBER": "4109999881", "AMEX_SE_NUMBER": "4109999881", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000123", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254M5048", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "5048", "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000014" },
    { "AMEX_PAYEE_NUMBER": "4109999881", "AMEX_SE_NUMBER": "4109999881", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000151", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254M5048", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "5048", "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000014" },
    { "AMEX_PAYEE_NUMBER": "4109999881", "AMEX_SE_NUMBER": "4109999881", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000208", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254M5048", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "5048", "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000014" },
    { "AMEX_PAYEE_NUMBER": "4109999881", "AMEX_SE_NUMBER": "4109999881", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000275", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254M5048", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "5048", "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000014" },
    { "AMEX_PAYEE_NUMBER": "4109999881", "AMEX_SE_NUMBER": "4109999881", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000115", "DISCOUNT_RATE": "+00001150", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "SV", "FEE_DESCRIPTION": "STORED VAL",         "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254M5048", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "5048", "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000014" },
    { "AMEX_PAYEE_NUMBER": "4109999881", "AMEX_SE_NUMBER": "4109999881", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000508", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254M5048", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "5048", "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000014" },
    { "AMEX_PAYEE_NUMBER": "4109999881", "AMEX_SE_NUMBER": "4109999881", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000002663", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254M5048", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "5048", "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000014" },
    { "AMEX_PAYEE_NUMBER": "4109999881", "AMEX_SE_NUMBER": "4109999881", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000003818", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254M5048", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "5048", "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000014" },
    { "AMEX_PAYEE_NUMBER": "4109999881", "AMEX_SE_NUMBER": "4109999881", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000003820", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254M5048", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "5048", "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000014" },
    { "AMEX_PAYEE_NUMBER": "4109999881", "AMEX_SE_NUMBER": "4109999881", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000003966", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254M5048", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "5048", "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000014" },
    { "AMEX_PAYEE_NUMBER": "4109999177", "AMEX_SE_NUMBER": "4109999177", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000078", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254M7145", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "7145", "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000056" },
    { "AMEX_PAYEE_NUMBER": "4169999182", "AMEX_SE_NUMBER": "4169999182", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000116", "DISCOUNT_RATE": "+00001150", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "RP", "FEE_DESCRIPTION": "RELOADABLE",         "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254M9582", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "9582", "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "00STR#8065" },
    { "AMEX_PAYEE_NUMBER": "4169999182", "AMEX_SE_NUMBER": "4169999182", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000583", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254M9582", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "9582", "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "00STR#8065" },
    { "AMEX_PAYEE_NUMBER": "4169999182", "AMEX_SE_NUMBER": "4169999182", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000700", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254M9582", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "9582", "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "00STR#8065" },
    { "AMEX_PAYEE_NUMBER": "4169999182", "AMEX_SE_NUMBER": "4169999182", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000851", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254M9582", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "9582", "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "00STR#8065" },
    { "AMEX_PAYEE_NUMBER": "4169999182", "AMEX_SE_NUMBER": "4169999182", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000888", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254M9582", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "9582", "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "00STR#8065" },
    { "AMEX_PAYEE_NUMBER": "4169999182", "AMEX_SE_NUMBER": "4169999182", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000001002", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254M9582", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "9582", "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "00STR#8065" },
    { "AMEX_PAYEE_NUMBER": "4169999182", "AMEX_SE_NUMBER": "4169999182", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000003408", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254M9582", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "9582", "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "00STR#8065" },
    { "AMEX_PAYEE_NUMBER": "4329999734", "AMEX_SE_NUMBER": "4329999734", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "-00000000003353", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254D6481", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "6481", "PAYMENT_NUMBER_TYPE": "D", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000STR#65" },
    { "AMEX_PAYEE_NUMBER": "4329999734", "AMEX_SE_NUMBER": "4329999734", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000160", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254D6481", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "6481", "PAYMENT_NUMBER_TYPE": "D", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000STR#65" },
    { "AMEX_PAYEE_NUMBER": "4329999734", "AMEX_SE_NUMBER": "4329999734", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000207", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254D6481", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "6481", "PAYMENT_NUMBER_TYPE": "D", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000STR#65" },
    { "AMEX_PAYEE_NUMBER": "4329999734", "AMEX_SE_NUMBER": "4329999734", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000269", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254D6481", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "6481", "PAYMENT_NUMBER_TYPE": "D", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000STR#65" },
    { "AMEX_PAYEE_NUMBER": "4329999734", "AMEX_SE_NUMBER": "4329999734", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000905", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254D6481", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "6481", "PAYMENT_NUMBER_TYPE": "D", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000STR#65" },
    { "AMEX_PAYEE_NUMBER": "4329999734", "AMEX_SE_NUMBER": "4329999734", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000002474", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254D6481", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "6481", "PAYMENT_NUMBER_TYPE": "D", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000STR#65" },
    { "AMEX_PAYEE_NUMBER": "4329999734", "AMEX_SE_NUMBER": "4329999734", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000004224", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254D6481", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "6481", "PAYMENT_NUMBER_TYPE": "D", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000STR#65" },
    { "AMEX_PAYEE_NUMBER": "4419999772", "AMEX_SE_NUMBER": "4419999772", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000058", "DISCOUNT_RATE": "+00001150", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "SV", "FEE_DESCRIPTION": "STORED VAL",         "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254M2689", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "2689", "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "00Str#8064" },
    { "AMEX_PAYEE_NUMBER": "4419999772", "AMEX_SE_NUMBER": "4419999772", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000761", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254M2689", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "2689", "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "00Str#8064" },
    { "AMEX_PAYEE_NUMBER": "4459999588", "AMEX_SE_NUMBER": "4459999588", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "-00000000000149", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254M6699", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "6699", "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000010" },
    { "AMEX_PAYEE_NUMBER": "4459999588", "AMEX_SE_NUMBER": "4459999588", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "-00000000000117", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254M6699", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "6699", "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000010" },
    { "AMEX_PAYEE_NUMBER": "4459999588", "AMEX_SE_NUMBER": "4459999588", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "-00000000000113", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254M6699", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "6699", "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000010" },
    { "AMEX_PAYEE_NUMBER": "4459999588", "AMEX_SE_NUMBER": "4459999588", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000147", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254M6699", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "6699", "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000010" },
    { "AMEX_PAYEE_NUMBER": "4459999588", "AMEX_SE_NUMBER": "4459999588", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000262", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254M6699", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "6699", "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000010" },
    { "AMEX_PAYEE_NUMBER": "4459999588", "AMEX_SE_NUMBER": "4459999588", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000275", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254M6699", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "6699", "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000010" },
    { "AMEX_PAYEE_NUMBER": "4459999588", "AMEX_SE_NUMBER": "4459999588", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000295", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254M6699", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "6699", "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000010" },
    { "AMEX_PAYEE_NUMBER": "4459999588", "AMEX_SE_NUMBER": "4459999588", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000332", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254M6699", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "6699", "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000010" },
    { "AMEX_PAYEE_NUMBER": "4459999588", "AMEX_SE_NUMBER": "4459999588", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000874", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254M6699", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "6699", "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000010" },
    { "AMEX_PAYEE_NUMBER": "4459999588", "AMEX_SE_NUMBER": "4459999588", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000002032", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254M6699", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "6699", "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000010" },
    { "AMEX_PAYEE_NUMBER": "4459999588", "AMEX_SE_NUMBER": "4459999588", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000004516", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254M6699", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "6699", "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000010" },
    { "AMEX_PAYEE_NUMBER": "5029999057", "AMEX_SE_NUMBER": "5029999057", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000001072", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254M8033", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "8033", "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000001" },
    { "AMEX_PAYEE_NUMBER": "5029999057", "AMEX_SE_NUMBER": "5029999057", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000001829", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254M8033", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "8033", "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000001" },
    { "AMEX_PAYEE_NUMBER": "5029999057", "AMEX_SE_NUMBER": "5029999057", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000002050", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254M8033", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "8033", "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000001" },
    { "AMEX_PAYEE_NUMBER": "5029999057", "AMEX_SE_NUMBER": "5029999057", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000003827", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254M8033", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "8033", "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000001" },
    { "AMEX_PAYEE_NUMBER": "5029999057", "AMEX_SE_NUMBER": "5029999057", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000006703", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254M8033", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "8033", "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000001" },
    { "AMEX_PAYEE_NUMBER": "5029999057", "AMEX_SE_NUMBER": "5029999057", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000008122", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254M8033", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "8033", "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "0000000001" },
    { "AMEX_PAYEE_NUMBER": "5029999289", "AMEX_SE_NUMBER": "5029999289", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000121", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254M0295", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "0295", "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "00STR#8069" },
    { "AMEX_PAYEE_NUMBER": "5029999289", "AMEX_SE_NUMBER": "5029999289", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000862", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254M0295", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "0295", "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "00STR#8069" },
    { "AMEX_PAYEE_NUMBER": "5029999289", "AMEX_SE_NUMBER": "5029999289", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000002673", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254M0295", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "0295", "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "00STR#8069" },
    { "AMEX_PAYEE_NUMBER": "5279999046", "AMEX_SE_NUMBER": "5279999046", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000233", "DISCOUNT_RATE": "+00002350", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254S6115", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "6115", "PAYMENT_NUMBER_TYPE": "S", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "" },
    { "AMEX_PAYEE_NUMBER": "5439999059", "AMEX_SE_NUMBER": "5439999059", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000003428", "DISCOUNT_RATE": "+00002350", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254D8477", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "8477", "PAYMENT_NUMBER_TYPE": "D", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "" },
    { "AMEX_PAYEE_NUMBER": "5439999059", "AMEX_SE_NUMBER": "5439999059", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000004194", "DISCOUNT_RATE": "+00002350", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254D8477", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "8477", "PAYMENT_NUMBER_TYPE": "D", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "" },
    { "AMEX_PAYEE_NUMBER": "5439999059", "AMEX_SE_NUMBER": "5439999059", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000011782", "DISCOUNT_RATE": "+00002350", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254D8477", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "8477", "PAYMENT_NUMBER_TYPE": "D", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "" },
    { "AMEX_PAYEE_NUMBER": "5439999059", "AMEX_SE_NUMBER": "5439999059", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000011877", "DISCOUNT_RATE": "+00002350", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254D8477", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "8477", "PAYMENT_NUMBER_TYPE": "D", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "" },
    { "AMEX_PAYEE_NUMBER": "5469999720", "AMEX_SE_NUMBER": "5469999720", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000387", "DISCOUNT_RATE": "+00002350", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254A1705", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "1705", "PAYMENT_NUMBER_TYPE": "A", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "EVENTS" },
    { "AMEX_PAYEE_NUMBER": "5469999720", "AMEX_SE_NUMBER": "5469999720", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000003021", "DISCOUNT_RATE": "+00002350", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254A1705", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "1705", "PAYMENT_NUMBER_TYPE": "A", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "EVENTS" },
    { "AMEX_PAYEE_NUMBER": "5469999720", "AMEX_SE_NUMBER": "5469999720", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000005875", "DISCOUNT_RATE": "+00002350", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254A1705", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "1705", "PAYMENT_NUMBER_TYPE": "A", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "EVENTS" },
    { "AMEX_PAYEE_NUMBER": "5469999267", "AMEX_SE_NUMBER": "5469999267", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "-00000000000030", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254T9183", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "9183", "PAYMENT_NUMBER_TYPE": "T", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "" },
    { "AMEX_PAYEE_NUMBER": "5469999267", "AMEX_SE_NUMBER": "5469999267", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000030", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254T9183", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "9183", "PAYMENT_NUMBER_TYPE": "T", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "" },
    { "AMEX_PAYEE_NUMBER": "5469999267", "AMEX_SE_NUMBER": "5469999267", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000030", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254T9183", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "9183", "PAYMENT_NUMBER_TYPE": "T", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "" },
    { "AMEX_PAYEE_NUMBER": "5469999267", "AMEX_SE_NUMBER": "5469999267", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000031", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254T9183", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "9183", "PAYMENT_NUMBER_TYPE": "T", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "" },
    { "AMEX_PAYEE_NUMBER": "5469999267", "AMEX_SE_NUMBER": "5469999267", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000031", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254T9183", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "9183", "PAYMENT_NUMBER_TYPE": "T", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "" },
    { "AMEX_PAYEE_NUMBER": "5469999267", "AMEX_SE_NUMBER": "5469999267", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000031", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254T9183", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "9183", "PAYMENT_NUMBER_TYPE": "T", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "" },
    { "AMEX_PAYEE_NUMBER": "5469999267", "AMEX_SE_NUMBER": "5469999267", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000032", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254T9183", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "9183", "PAYMENT_NUMBER_TYPE": "T", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "" },
    { "AMEX_PAYEE_NUMBER": "5469999267", "AMEX_SE_NUMBER": "5469999267", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000041", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254T9183", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "9183", "PAYMENT_NUMBER_TYPE": "T", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "" },
    { "AMEX_PAYEE_NUMBER": "5469999267", "AMEX_SE_NUMBER": "5469999267", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000042", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254T9183", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "9183", "PAYMENT_NUMBER_TYPE": "T", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "" },
    { "AMEX_PAYEE_NUMBER": "5469999267", "AMEX_SE_NUMBER": "5469999267", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000044", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254T9183", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "9183", "PAYMENT_NUMBER_TYPE": "T", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "" },
    { "AMEX_PAYEE_NUMBER": "5469999267", "AMEX_SE_NUMBER": "5469999267", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000044", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254T9183", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "9183", "PAYMENT_NUMBER_TYPE": "T", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "" },
    { "AMEX_PAYEE_NUMBER": "5469999267", "AMEX_SE_NUMBER": "5469999267", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000044", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254T9183", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "9183", "PAYMENT_NUMBER_TYPE": "T", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "" },
    { "AMEX_PAYEE_NUMBER": "5469999267", "AMEX_SE_NUMBER": "5469999267", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000044", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254T9183", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "9183", "PAYMENT_NUMBER_TYPE": "T", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "" },
    { "AMEX_PAYEE_NUMBER": "5469999267", "AMEX_SE_NUMBER": "5469999267", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000045", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254T9183", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "9183", "PAYMENT_NUMBER_TYPE": "T", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "" },
    { "AMEX_PAYEE_NUMBER": "5469999267", "AMEX_SE_NUMBER": "5469999267", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000093", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254T9183", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "9183", "PAYMENT_NUMBER_TYPE": "T", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "" },
    { "AMEX_PAYEE_NUMBER": "5469999267", "AMEX_SE_NUMBER": "5469999267", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000198", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254T9183", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "9183", "PAYMENT_NUMBER_TYPE": "T", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "" },
    { "AMEX_PAYEE_NUMBER": "5469999267", "AMEX_SE_NUMBER": "5469999267", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000231", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254T9183", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "9183", "PAYMENT_NUMBER_TYPE": "T", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "" },
    { "AMEX_PAYEE_NUMBER": "5469999267", "AMEX_SE_NUMBER": "5469999267", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000232", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254T9183", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "9183", "PAYMENT_NUMBER_TYPE": "T", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "" },
    { "AMEX_PAYEE_NUMBER": "5469999267", "AMEX_SE_NUMBER": "5469999267", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000000236", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254T9183", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "9183", "PAYMENT_NUMBER_TYPE": "T", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "" },
    { "AMEX_PAYEE_NUMBER": "5469999267", "AMEX_SE_NUMBER": "5469999267", "DETAIL_RECORD_TYPE": "13", "DISCOUNT_AMOUNT": "+00000000001195", "DISCOUNT_RATE": "+00002750", "FEE_AMOUNT": " 00000000000000", "FEE_CODE": "NA", "FEE_DESCRIPTION": "REGULAR SUBMISSION", "FEE_RATE": " 00000000", "MERCHANT_ID": "", "PAYMENT_NUMBER": "254T9183", "PAYMENT_NUMBER_DATE": "254", "PAYMENT_NUMBER_NUMBER": "9183", "PAYMENT_NUMBER_TYPE": "T", "PAYMENT_YEAR": "2014", "RECORD_TYPE": "3", "SE_UNIT_NUMBER": "" }
  ],
  "CHARGEBACK_DETAIL": [
  ],
  "ADJUSTMENT_DETAIL": [
    { "ADJUSTMENT_AMOUNT": "00003000}", "ADJUSTMENT_NUMBER": 572080, "ADJUSTMENT_REASON": "CHARGEBACK - CARDMEMBER DISPUTE", "AMEX_PAYEE_NUMBER": 2429999961, "AMEX_PROCESS_DATE": 2014254, "AMEX_SE_NUMBER": 2429999961, "BATCH_CODE": 560, "BILL_CODE": "037", "CARDMEMBER_NUMBER": "00372727XXXXX1017", "DETAIL_RECORD_TYPE": 30, "DISCOUNT_AMOUNT": "00000000{", "DISCOUNT_RATE": "02600", "MEMBERSHIP_REWARDS": "", "NET_ADJUSTMENT_AMOUNT": "00003000}", "PAYMENT_NUMBER": "254U1181", "PAYMENT_NUMBER_DATE": 254, "PAYMENT_NUMBER_NUMBER": 1181, "PAYMENT_NUMBER_TYPE": "U", "PAYMENT_YEAR": 2014, "RECORD_TYPE": 2, "SERVICE_AGENT_MERCHANT_ID": "", "SERVICE_FEE_AMOUNT": "000000{", "SERVICE_FEE_RATE": "00000", "SE_UNIT_NUMBER": 2420622961 },
    { "ADJUSTMENT_AMOUNT": "00000292K", "ADJUSTMENT_NUMBER": 572366, "ADJUSTMENT_REASON": "CHARGEBACK - CARDMEMBER DISPUTE", "AMEX_PAYEE_NUMBER": 2429999961, "AMEX_PROCESS_DATE": 2014254, "AMEX_SE_NUMBER": 2429999961, "BATCH_CODE": 560, "BILL_CODE": "047", "CARDMEMBER_NUMBER": "00372710XXXXX2003", "DETAIL_RECORD_TYPE": 30, "DISCOUNT_AMOUNT": "00000000{", "DISCOUNT_RATE": "02600", "MEMBERSHIP_REWARDS": "", "NET_ADJUSTMENT_AMOUNT": "00000292K", "PAYMENT_NUMBER": "254U1181", "PAYMENT_NUMBER_DATE": 254, "PAYMENT_NUMBER_NUMBER": 1181, "PAYMENT_NUMBER_TYPE": "U", "PAYMENT_YEAR": 2014, "RECORD_TYPE": 2, "SERVICE_AGENT_MERCHANT_ID": "", "SERVICE_FEE_AMOUNT": "000000{", "SERVICE_FEE_RATE": "00000", "SE_UNIT_NUMBER": 2420622961 },
    { "ADJUSTMENT_AMOUNT": "00005000}", "ADJUSTMENT_NUMBER": 575538, "ADJUSTMENT_REASON": "DEBIT-INCOMPLETE/ILLEGIBLE SUPPORT", "AMEX_PAYEE_NUMBER": 2429999961, "AMEX_PROCESS_DATE": 2014254, "AMEX_SE_NUMBER": 2429999961, "BATCH_CODE": 564, "BILL_CODE": 460, "CARDMEMBER_NUMBER": "00379659XXXXX2000", "DETAIL_RECORD_TYPE": 30, "DISCOUNT_AMOUNT": "00000000{", "DISCOUNT_RATE": "02600", "MEMBERSHIP_REWARDS": "", "NET_ADJUSTMENT_AMOUNT": "00005000}", "PAYMENT_NUMBER": "254U1181", "PAYMENT_NUMBER_DATE": 254, "PAYMENT_NUMBER_NUMBER": 1181, "PAYMENT_NUMBER_TYPE": "U", "PAYMENT_YEAR": 2014, "RECORD_TYPE": 2, "SERVICE_AGENT_MERCHANT_ID": "", "SERVICE_FEE_AMOUNT": "000000{", "SERVICE_FEE_RATE": "00000", "SE_UNIT_NUMBER": 2420622961 },
    { "ADJUSTMENT_AMOUNT": "00000400}", "ADJUSTMENT_NUMBER": 575552, "ADJUSTMENT_REASON": "DEBIT-INCOMPLETE/ILLEGIBLE SUPPORT", "AMEX_PAYEE_NUMBER": 2429999961, "AMEX_PROCESS_DATE": 2014254, "AMEX_SE_NUMBER": 2429999961, "BATCH_CODE": 564, "BILL_CODE": 460, "CARDMEMBER_NUMBER": "00379659XXXXX2000", "DETAIL_RECORD_TYPE": 30, "DISCOUNT_AMOUNT": "00000000{", "DISCOUNT_RATE": "02600", "MEMBERSHIP_REWARDS": "", "NET_ADJUSTMENT_AMOUNT": "00000400}", "PAYMENT_NUMBER": "254U1181", "PAYMENT_NUMBER_DATE": 254, "PAYMENT_NUMBER_NUMBER": 1181, "PAYMENT_NUMBER_TYPE": "U", "PAYMENT_YEAR": 2014, "RECORD_TYPE": 2, "SERVICE_AGENT_MERCHANT_ID": "", "SERVICE_FEE_AMOUNT": "000000{", "SERVICE_FEE_RATE": "00000", "SE_UNIT_NUMBER": 2420622961 },
    { "ADJUSTMENT_AMOUNT": "00000400}", "ADJUSTMENT_NUMBER": 575557, "ADJUSTMENT_REASON": "DEBIT-INCOMPLETE/ILLEGIBLE SUPPORT", "AMEX_PAYEE_NUMBER": 2429999961, "AMEX_PROCESS_DATE": 2014254, "AMEX_SE_NUMBER": 2429999961, "BATCH_CODE": 564, "BILL_CODE": 460, "CARDMEMBER_NUMBER": "00379659XXXXX2000", "DETAIL_RECORD_TYPE": 30, "DISCOUNT_AMOUNT": "00000000{", "DISCOUNT_RATE": "02600", "MEMBERSHIP_REWARDS": "", "NET_ADJUSTMENT_AMOUNT": "00000400}", "PAYMENT_NUMBER": "254U1181", "PAYMENT_NUMBER_DATE": 254, "PAYMENT_NUMBER_NUMBER": 1181, "PAYMENT_NUMBER_TYPE": "U", "PAYMENT_YEAR": 2014, "RECORD_TYPE": 2, "SERVICE_AGENT_MERCHANT_ID": "", "SERVICE_FEE_AMOUNT": "000000{", "SERVICE_FEE_RATE": "00000", "SE_UNIT_NUMBER": 2420622961 },
    { "ADJUSTMENT_AMOUNT": "00001605}", "ADJUSTMENT_NUMBER": 575696, "ADJUSTMENT_REASON": "CHARGEBACK - RESPONSE PAST DEADLINE OR INSUFFICIENT", "AMEX_PAYEE_NUMBER": 2429999961, "AMEX_PROCESS_DATE": 2014254, "AMEX_SE_NUMBER": 2429999961, "BATCH_CODE": 560, "BILL_CODE": "052", "CARDMEMBER_NUMBER": "00379487XXXXX2007", "DETAIL_RECORD_TYPE": 30, "DISCOUNT_AMOUNT": "00000000{", "DISCOUNT_RATE": "02600", "MEMBERSHIP_REWARDS": "", "NET_ADJUSTMENT_AMOUNT": "00001605}", "PAYMENT_NUMBER": "254U1181", "PAYMENT_NUMBER_DATE": 254, "PAYMENT_NUMBER_NUMBER": 1181, "PAYMENT_NUMBER_TYPE": "U", "PAYMENT_YEAR": 2014, "RECORD_TYPE": 2, "SERVICE_AGENT_MERCHANT_ID": "", "SERVICE_FEE_AMOUNT": "000000{", "SERVICE_FEE_RATE": "00000", "SE_UNIT_NUMBER": 2420622961 },
    { "ADJUSTMENT_AMOUNT": "00001500}", "ADJUSTMENT_NUMBER": 616942, "ADJUSTMENT_REASON": "CHARGEBACK - CARDMEMBER DISPUTE", "AMEX_PAYEE_NUMBER": 2429999961, "AMEX_PROCESS_DATE": 2014254, "AMEX_SE_NUMBER": 2429999961, "BATCH_CODE": 560, "BILL_CODE": "047", "CARDMEMBER_NUMBER": "00379737XXXXX1007", "DETAIL_RECORD_TYPE": 30, "DISCOUNT_AMOUNT": "00000000{", "DISCOUNT_RATE": "02600", "MEMBERSHIP_REWARDS": "", "NET_ADJUSTMENT_AMOUNT": "00001500}", "PAYMENT_NUMBER": "254U1181", "PAYMENT_NUMBER_DATE": 254, "PAYMENT_NUMBER_NUMBER": 1181, "PAYMENT_NUMBER_TYPE": "U", "PAYMENT_YEAR": 2014, "RECORD_TYPE": 2, "SERVICE_AGENT_MERCHANT_ID": "", "SERVICE_FEE_AMOUNT": "000000{", "SERVICE_FEE_RATE": "00000", "SE_UNIT_NUMBER": 2420622961 },
    { "ADJUSTMENT_AMOUNT": "00000511O", "ADJUSTMENT_NUMBER": 720831, "ADJUSTMENT_REASON": "CHARGEBACK - RESPONSE PAST DEADLINE OR INSUFFICIENT", "AMEX_PAYEE_NUMBER": 2429999961, "AMEX_PROCESS_DATE": 2014254, "AMEX_SE_NUMBER": 2429999961, "BATCH_CODE": 560, "BILL_CODE": "052", "CARDMEMBER_NUMBER": "00373171XXXXX6006", "DETAIL_RECORD_TYPE": 30, "DISCOUNT_AMOUNT": "00000000{", "DISCOUNT_RATE": "02600", "MEMBERSHIP_REWARDS": "", "NET_ADJUSTMENT_AMOUNT": "00000511O", "PAYMENT_NUMBER": "254U1181", "PAYMENT_NUMBER_DATE": 254, "PAYMENT_NUMBER_NUMBER": 1181, "PAYMENT_NUMBER_TYPE": "U", "PAYMENT_YEAR": 2014, "RECORD_TYPE": 2, "SERVICE_AGENT_MERCHANT_ID": "", "SERVICE_FEE_AMOUNT": "000000{", "SERVICE_FEE_RATE": "00000", "SE_UNIT_NUMBER": 2420622961 },
    { "ADJUSTMENT_AMOUNT": "00003266L", "ADJUSTMENT_NUMBER": 872307, "ADJUSTMENT_REASON": "CHARGEBACK - RESPONSE PAST DEADLINE OR INSUFFICIENT", "AMEX_PAYEE_NUMBER": 2429999961, "AMEX_PROCESS_DATE": 2014254, "AMEX_SE_NUMBER": 2429999961, "BATCH_CODE": 560, "BILL_CODE": "052", "CARDMEMBER_NUMBER": "00372738XXXXX1003", "DETAIL_RECORD_TYPE": 30, "DISCOUNT_AMOUNT": "00000000{", "DISCOUNT_RATE": "02600", "MEMBERSHIP_REWARDS": "", "NET_ADJUSTMENT_AMOUNT": "00003266L", "PAYMENT_NUMBER": "254U1181", "PAYMENT_NUMBER_DATE": 254, "PAYMENT_NUMBER_NUMBER": 1181, "PAYMENT_NUMBER_TYPE": "U", "PAYMENT_YEAR": 2014, "RECORD_TYPE": 2, "SERVICE_AGENT_MERCHANT_ID": "", "SERVICE_FEE_AMOUNT": "000000{", "SERVICE_FEE_RATE": "00000", "SE_UNIT_NUMBER": 2420622961 }
  ],
  "OTHER_DETAIL": [
    { "AMEX_PAYEE_NUMBER": 1099999509, "AMEX_PROCESS_DATE": 2014253, "AMEX_SE_NUMBER": 1099999509, "ASSET_BILLING_AMOUNT": "00000000{", "ASSET_BILLING_DESCRIPTION": "", "ASSET_BILLING_TAX": "00000000{", "BATCH_CODE": 999, "BILL_CODE": "", "DETAIL_RECORD_TYPE": 50, "OTHER_FEE_AMOUNT": "00001325}", "OTHER_FEE_DESCRIPTION": "DISCOUNT RECOVERY", "PAY_IN_GROSS_INDICATOR": "", "PAYMENT_NUMBER": "254E6858", "PAYMENT_NUMBER_DATE": 254, "PAYMENT_NUMBER_NUMBER": 6858, "PAYMENT_NUMBER_TYPE": "E", "PAYMENT_YEAR": 2014, "RECORD_TYPE": 2, "SERVICE_AGENT_MERCHANT_ID": "", "SE_UNIT_NUMBER": "0000STR#60", "TAKE_ONE_COMMISSION_AMOUNT": "00000000{", "TAKE_ONE_DESCRIPTION": "" },
    { "AMEX_PAYEE_NUMBER": 1269999580, "AMEX_PROCESS_DATE": 2014253, "AMEX_SE_NUMBER": 1269999580, "ASSET_BILLING_AMOUNT": "00000000{", "ASSET_BILLING_DESCRIPTION": "", "ASSET_BILLING_TAX": "00000000{", "BATCH_CODE": 999, "BILL_CODE": "", "DETAIL_RECORD_TYPE": 50, "OTHER_FEE_AMOUNT": "00000023N", "OTHER_FEE_DESCRIPTION": "DISCOUNT RECOVERY", "PAY_IN_GROSS_INDICATOR": "", "PAYMENT_NUMBER": "254J4691", "PAYMENT_NUMBER_DATE": 254, "PAYMENT_NUMBER_NUMBER": 4691, "PAYMENT_NUMBER_TYPE": "J", "PAYMENT_YEAR": 2014, "RECORD_TYPE": 2, "SERVICE_AGENT_MERCHANT_ID": "", "SE_UNIT_NUMBER": "00STR#8070", "TAKE_ONE_COMMISSION_AMOUNT": "00000000{", "TAKE_ONE_DESCRIPTION": "" },
    { "AMEX_PAYEE_NUMBER": 1319999989, "AMEX_PROCESS_DATE": 2014253, "AMEX_SE_NUMBER": 1319999989, "ASSET_BILLING_AMOUNT": "00000000{", "ASSET_BILLING_DESCRIPTION": "", "ASSET_BILLING_TAX": "00000000{", "BATCH_CODE": 999, "BILL_CODE": "", "DETAIL_RECORD_TYPE": 50, "OTHER_FEE_AMOUNT": "00001482J", "OTHER_FEE_DESCRIPTION": "DISCOUNT RECOVERY", "PAY_IN_GROSS_INDICATOR": "", "PAYMENT_NUMBER": "254G2303", "PAYMENT_NUMBER_DATE": 254, "PAYMENT_NUMBER_NUMBER": 2303, "PAYMENT_NUMBER_TYPE": "G", "PAYMENT_YEAR": 2014, "RECORD_TYPE": 2, "SERVICE_AGENT_MERCHANT_ID": "", "SE_UNIT_NUMBER": "0000000044", "TAKE_ONE_COMMISSION_AMOUNT": "00000000{", "TAKE_ONE_DESCRIPTION": "" },
    { "AMEX_PAYEE_NUMBER": 1319999284, "AMEX_PROCESS_DATE": 2014253, "AMEX_SE_NUMBER": 1319999284, "ASSET_BILLING_AMOUNT": "00000000{", "ASSET_BILLING_DESCRIPTION": "", "ASSET_BILLING_TAX": "00000000{", "BATCH_CODE": 999, "BILL_CODE": "", "DETAIL_RECORD_TYPE": 50, "OTHER_FEE_AMOUNT": "00000416P", "OTHER_FEE_DESCRIPTION": "DISCOUNT RECOVERY", "PAY_IN_GROSS_INDICATOR": "", "PAYMENT_NUMBER": "254G2627", "PAYMENT_NUMBER_DATE": 254, "PAYMENT_NUMBER_NUMBER": 2627, "PAYMENT_NUMBER_TYPE": "G", "PAYMENT_YEAR": 2014, "RECORD_TYPE": 2, "SERVICE_AGENT_MERCHANT_ID": "", "SE_UNIT_NUMBER": "00STR#8082", "TAKE_ONE_COMMISSION_AMOUNT": "00000000{", "TAKE_ONE_DESCRIPTION": "" },
    { "AMEX_PAYEE_NUMBER": 2049999582, "AMEX_PROCESS_DATE": 2014253, "AMEX_SE_NUMBER": 2049999582, "ASSET_BILLING_AMOUNT": "00000000{", "ASSET_BILLING_DESCRIPTION": "", "ASSET_BILLING_TAX": "00000000{", "BATCH_CODE": 999, "BILL_CODE": "", "DETAIL_RECORD_TYPE": 50, "OTHER_FEE_AMOUNT": "00000501P", "OTHER_FEE_DESCRIPTION": "DISCOUNT RECOVERY", "PAY_IN_GROSS_INDICATOR": "", "PAYMENT_NUMBER": "254M2654", "PAYMENT_NUMBER_DATE": 254, "PAYMENT_NUMBER_NUMBER": 2654, "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": 2014, "RECORD_TYPE": 2, "SERVICE_AGENT_MERCHANT_ID": "", "SE_UNIT_NUMBER": "0000008063", "TAKE_ONE_COMMISSION_AMOUNT": "00000000{", "TAKE_ONE_DESCRIPTION": "" },
    { "AMEX_PAYEE_NUMBER": 2199999562, "AMEX_PROCESS_DATE": 2014253, "AMEX_SE_NUMBER": 2199999562, "ASSET_BILLING_AMOUNT": "00000000{", "ASSET_BILLING_DESCRIPTION": "", "ASSET_BILLING_TAX": "00000000{", "BATCH_CODE": 999, "BILL_CODE": "", "DETAIL_RECORD_TYPE": 50, "OTHER_FEE_AMOUNT": "00000420Q", "OTHER_FEE_DESCRIPTION": "DISCOUNT RECOVERY", "PAY_IN_GROSS_INDICATOR": "", "PAYMENT_NUMBER": "254I0353", "PAYMENT_NUMBER_DATE": 254, "PAYMENT_NUMBER_NUMBER": "0353", "PAYMENT_NUMBER_TYPE": "I", "PAYMENT_YEAR": 2014, "RECORD_TYPE": 2, "SERVICE_AGENT_MERCHANT_ID": "", "SE_UNIT_NUMBER": "00STR#8060", "TAKE_ONE_COMMISSION_AMOUNT": "00000000{", "TAKE_ONE_DESCRIPTION": "" },
    { "AMEX_PAYEE_NUMBER": 2199999169, "AMEX_PROCESS_DATE": 2014253, "AMEX_SE_NUMBER": 2199999169, "ASSET_BILLING_AMOUNT": "00000000{", "ASSET_BILLING_DESCRIPTION": "", "ASSET_BILLING_TAX": "00000000{", "BATCH_CODE": 999, "BILL_CODE": "", "DETAIL_RECORD_TYPE": 50, "OTHER_FEE_AMOUNT": "00000023L", "OTHER_FEE_DESCRIPTION": "DISCOUNT RECOVERY", "PAY_IN_GROSS_INDICATOR": "", "PAYMENT_NUMBER": "254I0384", "PAYMENT_NUMBER_DATE": 254, "PAYMENT_NUMBER_NUMBER": "0384", "PAYMENT_NUMBER_TYPE": "I", "PAYMENT_YEAR": 2014, "RECORD_TYPE": 2, "SERVICE_AGENT_MERCHANT_ID": "", "SE_UNIT_NUMBER": "0Str #8085", "TAKE_ONE_COMMISSION_AMOUNT": "00000000{", "TAKE_ONE_DESCRIPTION": "" },
    { "AMEX_PAYEE_NUMBER": 2299999979, "AMEX_PROCESS_DATE": 2014253, "AMEX_SE_NUMBER": 2299999979, "ASSET_BILLING_AMOUNT": "00000000{", "ASSET_BILLING_DESCRIPTION": "", "ASSET_BILLING_TAX": "00000000{", "BATCH_CODE": 999, "BILL_CODE": "", "DETAIL_RECORD_TYPE": 50, "OTHER_FEE_AMOUNT": "00000528Q", "OTHER_FEE_DESCRIPTION": "DISCOUNT RECOVERY", "PAY_IN_GROSS_INDICATOR": "", "PAYMENT_NUMBER": "254L2582", "PAYMENT_NUMBER_DATE": 254, "PAYMENT_NUMBER_NUMBER": 2582, "PAYMENT_NUMBER_TYPE": "L", "PAYMENT_YEAR": 2014, "RECORD_TYPE": 2, "SERVICE_AGENT_MERCHANT_ID": "", "SE_UNIT_NUMBER": "0000000055", "TAKE_ONE_COMMISSION_AMOUNT": "00000000{", "TAKE_ONE_DESCRIPTION": "" },
    { "AMEX_PAYEE_NUMBER": 2379999582, "AMEX_PROCESS_DATE": 2014253, "AMEX_SE_NUMBER": 2379999582, "ASSET_BILLING_AMOUNT": "00000000{", "ASSET_BILLING_DESCRIPTION": "", "ASSET_BILLING_TAX": "00000000{", "BATCH_CODE": 999, "BILL_CODE": "", "DETAIL_RECORD_TYPE": 50, "OTHER_FEE_AMOUNT": "00000089R", "OTHER_FEE_DESCRIPTION": "DISCOUNT RECOVERY", "PAY_IN_GROSS_INDICATOR": "", "PAYMENT_NUMBER": "254L8734", "PAYMENT_NUMBER_DATE": 254, "PAYMENT_NUMBER_NUMBER": 8734, "PAYMENT_NUMBER_TYPE": "L", "PAYMENT_YEAR": 2014, "RECORD_TYPE": 2, "SERVICE_AGENT_MERCHANT_ID": "", "SE_UNIT_NUMBER": "0000008062", "TAKE_ONE_COMMISSION_AMOUNT": "00000000{", "TAKE_ONE_DESCRIPTION": "" },
    { "AMEX_PAYEE_NUMBER": 2429999740, "AMEX_PROCESS_DATE": 2014253, "AMEX_SE_NUMBER": 2429999740, "ASSET_BILLING_AMOUNT": "00000000{", "ASSET_BILLING_DESCRIPTION": "", "ASSET_BILLING_TAX": "00000000{", "BATCH_CODE": 999, "BILL_CODE": "", "DETAIL_RECORD_TYPE": 50, "OTHER_FEE_AMOUNT": "00001901J", "OTHER_FEE_DESCRIPTION": "DISCOUNT RECOVERY", "PAY_IN_GROSS_INDICATOR": "", "PAYMENT_NUMBER": "254M9007", "PAYMENT_NUMBER_DATE": 254, "PAYMENT_NUMBER_NUMBER": 9007, "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": 2014, "RECORD_TYPE": 2, "SERVICE_AGENT_MERCHANT_ID": "", "SE_UNIT_NUMBER": "0000000061", "TAKE_ONE_COMMISSION_AMOUNT": "00000000{", "TAKE_ONE_DESCRIPTION": "" },
    { "AMEX_PAYEE_NUMBER": 2429999034, "AMEX_PROCESS_DATE": 2014253, "AMEX_SE_NUMBER": 2429999034, "ASSET_BILLING_AMOUNT": "00000000{", "ASSET_BILLING_DESCRIPTION": "", "ASSET_BILLING_TAX": "00000000{", "BATCH_CODE": 999, "BILL_CODE": "", "DETAIL_RECORD_TYPE": 50, "OTHER_FEE_AMOUNT": "00000118Q", "OTHER_FEE_DESCRIPTION": "DISCOUNT RECOVERY", "PAY_IN_GROSS_INDICATOR": "", "PAYMENT_NUMBER": "254M9225", "PAYMENT_NUMBER_DATE": 254, "PAYMENT_NUMBER_NUMBER": 9225, "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": 2014, "RECORD_TYPE": 2, "SERVICE_AGENT_MERCHANT_ID": "", "SE_UNIT_NUMBER": "0STR #8061", "TAKE_ONE_COMMISSION_AMOUNT": "00000000{", "TAKE_ONE_DESCRIPTION": "" },
    { "AMEX_PAYEE_NUMBER": 4109999177, "AMEX_PROCESS_DATE": 2014253, "AMEX_SE_NUMBER": 4109999177, "ASSET_BILLING_AMOUNT": "00000000{", "ASSET_BILLING_DESCRIPTION": "", "ASSET_BILLING_TAX": "00000000{", "BATCH_CODE": 999, "BILL_CODE": "", "DETAIL_RECORD_TYPE": 50, "OTHER_FEE_AMOUNT": "00000007Q", "OTHER_FEE_DESCRIPTION": "DISCOUNT RECOVERY", "PAY_IN_GROSS_INDICATOR": "", "PAYMENT_NUMBER": "254M7146", "PAYMENT_NUMBER_DATE": 254, "PAYMENT_NUMBER_NUMBER": 7146, "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": 2014, "RECORD_TYPE": 2, "SERVICE_AGENT_MERCHANT_ID": "", "SE_UNIT_NUMBER": "0000000056", "TAKE_ONE_COMMISSION_AMOUNT": "00000000{", "TAKE_ONE_DESCRIPTION": "" },
    { "AMEX_PAYEE_NUMBER": 4169999182, "AMEX_PROCESS_DATE": 2014253, "AMEX_SE_NUMBER": 4169999182, "ASSET_BILLING_AMOUNT": "00000000{", "ASSET_BILLING_DESCRIPTION": "", "ASSET_BILLING_TAX": "00000000{", "BATCH_CODE": 999, "BILL_CODE": "", "DETAIL_RECORD_TYPE": 50, "OTHER_FEE_AMOUNT": "00000754Q", "OTHER_FEE_DESCRIPTION": "DISCOUNT RECOVERY", "PAY_IN_GROSS_INDICATOR": "", "PAYMENT_NUMBER": "254M9583", "PAYMENT_NUMBER_DATE": 254, "PAYMENT_NUMBER_NUMBER": 9583, "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": 2014, "RECORD_TYPE": 2, "SERVICE_AGENT_MERCHANT_ID": "", "SE_UNIT_NUMBER": "00STR#8065", "TAKE_ONE_COMMISSION_AMOUNT": "00000000{", "TAKE_ONE_DESCRIPTION": "" },
    { "AMEX_PAYEE_NUMBER": 4419999772, "AMEX_PROCESS_DATE": 2014253, "AMEX_SE_NUMBER": 4419999772, "ASSET_BILLING_AMOUNT": "00000000{", "ASSET_BILLING_DESCRIPTION": "", "ASSET_BILLING_TAX": "00000000{", "BATCH_CODE": 999, "BILL_CODE": "", "DETAIL_RECORD_TYPE": 50, "OTHER_FEE_AMOUNT": "00000081R", "OTHER_FEE_DESCRIPTION": "DISCOUNT RECOVERY", "PAY_IN_GROSS_INDICATOR": "", "PAYMENT_NUMBER": "254M2690", "PAYMENT_NUMBER_DATE": 254, "PAYMENT_NUMBER_NUMBER": 2690, "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": 2014, "RECORD_TYPE": 2, "SERVICE_AGENT_MERCHANT_ID": "", "SE_UNIT_NUMBER": "00Str#8064", "TAKE_ONE_COMMISSION_AMOUNT": "00000000{", "TAKE_ONE_DESCRIPTION": "" },
    { "AMEX_PAYEE_NUMBER": 5029999289, "AMEX_PROCESS_DATE": 2014253, "AMEX_SE_NUMBER": 5029999289, "ASSET_BILLING_AMOUNT": "00000000{", "ASSET_BILLING_DESCRIPTION": "", "ASSET_BILLING_TAX": "00000000{", "BATCH_CODE": 999, "BILL_CODE": "", "DETAIL_RECORD_TYPE": 50, "OTHER_FEE_AMOUNT": "00000365O", "OTHER_FEE_DESCRIPTION": "DISCOUNT RECOVERY", "PAY_IN_GROSS_INDICATOR": "", "PAYMENT_NUMBER": "254M0296", "PAYMENT_NUMBER_DATE": 254, "PAYMENT_NUMBER_NUMBER": "0296", "PAYMENT_NUMBER_TYPE": "M", "PAYMENT_YEAR": 2014, "RECORD_TYPE": 2, "SERVICE_AGENT_MERCHANT_ID": "", "SE_UNIT_NUMBER": "00STR#8069", "TAKE_ONE_COMMISSION_AMOUNT": "00000000{", "TAKE_ONE_DESCRIPTION": "" }
  ]

}
