##############################
#
# Bio::MAGE::BioAssayData::BioAssayData
#
##############################
# C O P Y R I G H T   N O T I C E
#  Copyright (c) 2001-2002 by:
#    * The MicroArray Gene Expression Database Society (MGED)
#    * Rosetta Inpharmatics
#
# Permission is hereby granted, free of charge, to any person
# obtaining a copy of this software and associated documentation files
# (the "Software"), to deal in the Software without restriction,
# including without limitation the rights to use, copy, modify, merge,
# publish, distribute, sublicense, and/or sell copies of the Software,
# and to permit persons to whom the Software is furnished to do so,
# subject to the following conditions:
#
# The above copyright notice and this permission notice shall be
# included in all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
# EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
# MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
# NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
# BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
# ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
# CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
# SOFTWARE.

package Bio::MAGE::BioAssayData::BioAssayData;

use strict;
use Carp;
use Bio::MAGE::Base;
use Bio::MAGE::Association;
use Bio::MAGE::Identifiable;


use vars qw($VERSION @ISA @EXPORT @EXPORT_OK $__ASSOCIATIONS);

require Exporter;

@ISA = qw(Bio::MAGE::Base Bio::MAGE::Identifiable Exporter);
$VERSION = q[$Id: BioAssayData.pm,v 1.2 2002/12/11 01:32:18 jason_e_stewart Exp $];

# Items to export into callers namespace by default. Note: do not export
# names by default without a very good reason. Use EXPORT_OK instead.
# Do not simply export all your public functions/methods/constants.
@EXPORT_OK = qw();


=head1 Bio::MAGE::BioAssayData::BioAssayData

=head2 SYNOPSIS

  use Bio::MAGE::BioAssayData::BioAssayData;

    # Bio::MAGE::BioAssayData::BioAssayData is an abstract base class and should not be directly 
    # instanciated. These examples indicate how subclass objects behave

    # setting and retrieving object associations
  my $designElementDimension_val = $bioassaydata->designElementDimension();
  $bioassaydata->designElementDimension($value);

  my $bioAssayDimension_val = $bioassaydata->bioAssayDimension();
  $bioassaydata->bioAssayDimension($value);

  my $bioDataValues_val = $bioassaydata->bioDataValues();
  $bioassaydata->bioDataValues($value);

  my $quantitationTypeDimension_val = $bioassaydata->quantitationTypeDimension();
  $bioassaydata->quantitationTypeDimension($value);

  my $summaryStatistics_val = $bioassaydata->summaryStatistics();
  $bioassaydata->summaryStatistics($value);


=head2 DESCRIPTION

From the MAGE-OM documentation for the C<BioAssayData> class:

Represents the dataset created when the BioAssays are created.  BioAssayData is the entry point to the values.  Because the actual values are represented by a different object, BioDataValues, which can be memory intensive, the annotation of the transformation can be gotten separate from the data.

Bio::MAGE::BioAssayData::BioAssayData is an abstract base class and should not be
directly instanciated. Instead it serves as an interface definition
for its subclasses.



=cut


=head2 INHERITANCE


Bio::MAGE::BioAssayData::BioAssayData has the following super classes

=over 


=item * Bio::MAGE::Identifiable


=back


Bio::MAGE::BioAssayData::BioAssayData has the following subclasses

=over 


=item * Bio::MAGE::BioAssayData::MeasuredBioAssayData


=item * Bio::MAGE::BioAssayData::DerivedBioAssayData


=back


=head2 CLASS METHODS

The following methods can all be called without first having an
instance of the class via the Bio::MAGE::BioAssayData::BioAssayData->methodname() syntax.


Bio::MAGE::BioAssayData::BioAssayData is an abstract base class and should not be directly
instantiated using the C<new()> constructor. It is listed here to
indicate what arguments will be accepted for its subclasses.


=item new()

=item new(%args)


The object constructor C<new()> accepts the following optional
named-value style arguments:

=over


=item * designElementDimension

Sets the value of the designElementDimension association (from C<Bio::MAGE::BioAssayData::BioAssayData>).


=item * bioAssayDimension

Sets the value of the bioAssayDimension association (from C<Bio::MAGE::BioAssayData::BioAssayData>).


=item * bioDataValues

Sets the value of the bioDataValues association (from C<Bio::MAGE::BioAssayData::BioAssayData>).


=item * quantitationTypeDimension

Sets the value of the quantitationTypeDimension association (from C<Bio::MAGE::BioAssayData::BioAssayData>).


=item * summaryStatistics

Sets the value of the summaryStatistics association (from C<Bio::MAGE::BioAssayData::BioAssayData>).


=item * identifier

Sets the value of the identifier attribute (from C<Bio::MAGE::Identifiable>).


=item * name

Sets the value of the name attribute (from C<Bio::MAGE::Identifiable>).


=item * security

Sets the value of the security association (from C<Bio::MAGE::Describable>).


=item * auditTrail

Sets the value of the auditTrail association (from C<Bio::MAGE::Describable>).


=item * descriptions

Sets the value of the descriptions association (from C<Bio::MAGE::Describable>).


=item * propertySets

Sets the value of the propertySets association (from C<Bio::MAGE::Extendable>).


=back



=cut

#
# code for new() inherited from Base.pm
#

=item $obj->set_slots(%parameters)

=item $obj->set_slots(\@name_list, \@value_list)

The C<set_slots()> method is used to set a number of slots at the same
time. It has two different invocation methods. The first takes a named
parameter list, and the second takes two array references.

B<Return value>: none

B<Side effects>: will call C<croak()> if a slot_name is used that the class
does not define.

=cut

#
# code for set_slots() inherited from Base.pm
#

=item $obj->get_slots(@name_list)

The C<get_slots()> method is used to get the values of a number of
slots at the same time.

B<Return value>: a list of instance objects

B<Side effects>: none

=cut

#
# code for get_slots() inherited from Base.pm
#

=item $val = $obj->set_slot($name,$val)

The C<set_slot()> method sets the slot C<$name> to the value C<$val>

B<Return value>: the new value of the slot, i.e. C<$val>

B<Side effects>: none

=cut

#
# code for set_slot() inherited from Base.pm
#

=item $val = $obj->get_slot($name)

The C<get_slot()> method is used to get the values of a number of
slots at the same time.

B<Return value>: a single slot value, or undef if the slot has not been
initialized.

B<Side effects>: none

=cut

#
# code for get_slot() inherited from Base.pm
#

=item @names = $obj->get_slot_names()

The C<get_slot_names()> method is used to retrieve the name of all
slots defined for a given object.

B<Return value>: a single slot value, or undef if the slot has not been
initialized.

B<Side effects>: none

=cut

#
# code for get_slot_names() inherited from Base.pm
#



=item $name = class_name()

Returns the full class name for this class, Bio::MAGE::BioAssayData::BioAssayData.

=cut

sub class_name {
  return q[Bio::MAGE::BioAssayData::BioAssayData];
}

=item $package_name = package()

Returns the unresolved package name (i.e. no 'Bio::MAGE::') of the
package that contains class, Bio::MAGE::BioAssayData::BioAssayData.

=cut

sub package {
  return q[BioAssayData];
}

=item @classes = subclasses()

returns the list of subclasses for this class.

=cut

sub subclasses {
  my @list = ('Bio::MAGE::BioAssayData::MeasuredBioAssayData', 'Bio::MAGE::BioAssayData::DerivedBioAssayData');
  return @list;
}

=item @classes = superclasses()

returns the list of superclasses for this class.

=cut

sub superclasses {
  my @list = ('Bio::MAGE::Identifiable');
  return @list;
}

=item @methods = attribute_methods()

returns the list of attribute accessor methods for this class.

=cut

sub attribute_methods {
  my $class = shift;
  my @list = ();
  if ($class->superclasses()) {
    foreach ($class->superclasses()) {
      push(@list,$_->attribute_methods());
    }
  }
  return @list;
}

=item @methods = association_methods()

returns the list of association accessor methods for this class.

=cut

sub association_methods {
  my $class = shift;
  my @list = ('designElementDimension', 'bioAssayDimension', 'bioDataValues', 'quantitationTypeDimension', 'summaryStatistics');
  if ($class->superclasses()) {
    foreach ($class->superclasses()) {
      push(@list,$_->association_methods());
    }
  }
  return @list;
}

=item %assns = associations()

returns the association meta-information in a hash where the keys are
the association names and the values are C<Bio::MAGE::Association>
objects that provide the meta-information for the association.

=cut

sub associations {
  my $class = shift;
  my @list = ();
  # superclasses first
  if ($class->superclasses()) {
    foreach ($class->superclasses()) {
      push(@list,$_->associations());
    }
  }
  # then associations from this class
  if (defined $__ASSOCIATIONS) {
    push(@list,@{$__ASSOCIATIONS})
  }
  return @list;
}


=head2 ATTRIBUTES

Attributes are simple data types that belong to a single instance of a
class. In the Perl implementation of the MAGE-OM classes, the
interface to attributes is implemented using separate setter and
getter methods for each attribute.

Bio::MAGE::BioAssayData::BioAssayData: has the following attribute accessor methods:

=over

Attributes Inherited from Bio::MAGE::Identifiable


=item identifier

From the MAGE-OM documentation for the C<identifier> attribute:

An identifier is an unambiguous string that is unique within the scope (i.e. a document, a set of related documents, or a repository) of its use.



=over


=item $val = $identifiable->setIdentifier($val)

The restricted setter method for the identifier attribute.

Input parameters: the value to which the identifier attribute will be set 

Return value: the current value of the identifier attribute 

Side effects: none

Exceptions: will call C<croak()> if no input parameters are specified, or
if too many input parameters are specified 

=cut


=item $val = $identifiable->getIdentifier()

The restricted getter method for the identifier attribute.

Input parameters: none

Return value: the current value of the identifier attribute 

Side effects: none

Exceptions: will call C<croak()> if any input parameters are specified

=cut



=back


=item name

From the MAGE-OM documentation for the C<name> attribute:

The potentially ambiguous common identifier.



=over


=item $val = $identifiable->setName($val)

The restricted setter method for the name attribute.

Input parameters: the value to which the name attribute will be set 

Return value: the current value of the name attribute 

Side effects: none

Exceptions: will call C<croak()> if no input parameters are specified, or
if too many input parameters are specified 

=cut


=item $val = $identifiable->getName()

The restricted getter method for the name attribute.

Input parameters: none

Return value: the current value of the name attribute 

Side effects: none

Exceptions: will call C<croak()> if any input parameters are specified

=cut



=back



=back


=cut



BEGIN {
  $__ASSOCIATIONS = [
          'summaryStatistics',
          bless( {
                   '__SELF' => bless( {
                                        '__NAME' => undef,
                                        '__IS_REF' => 0,
                                        '__CARDINALITY' => '1',
                                        '__DOCUMENTATION' => 'Statistics on the Quality of the BioAssayData.',
                                        '__CLASS_NAME' => 'BioAssayData',
                                        '__RANK' => undef,
                                        '__ORDERED' => undef
                                      }, 'Bio::MAGE::Association::End' ),
                   '__OTHER' => bless( {
                                         '__NAME' => 'summaryStatistics',
                                         '__IS_REF' => 1,
                                         '__CARDINALITY' => '0..N',
                                         '__DOCUMENTATION' => 'Statistics on the Quality of the BioAssayData.',
                                         '__CLASS_NAME' => 'NameValueType',
                                         '__RANK' => '1',
                                         '__ORDERED' => 0
                                       }, 'Bio::MAGE::Association::End' )
                 }, 'Bio::MAGE::Association' ),
          'bioAssayDimension',
          bless( {
                   '__SELF' => bless( {
                                        '__NAME' => undef,
                                        '__IS_REF' => 1,
                                        '__CARDINALITY' => '1',
                                        '__DOCUMENTATION' => 'The BioAssays of the BioAssayData.',
                                        '__CLASS_NAME' => 'BioAssayData',
                                        '__RANK' => undef,
                                        '__ORDERED' => undef
                                      }, 'Bio::MAGE::Association::End' ),
                   '__OTHER' => bless( {
                                         '__NAME' => 'bioAssayDimension',
                                         '__IS_REF' => 1,
                                         '__CARDINALITY' => '1',
                                         '__DOCUMENTATION' => 'The BioAssays of the BioAssayData.',
                                         '__CLASS_NAME' => 'BioAssayDimension',
                                         '__RANK' => '2',
                                         '__ORDERED' => 0
                                       }, 'Bio::MAGE::Association::End' )
                 }, 'Bio::MAGE::Association' ),
          'designElementDimension',
          bless( {
                   '__SELF' => bless( {
                                        '__NAME' => undef,
                                        '__IS_REF' => 1,
                                        '__CARDINALITY' => '1',
                                        '__DOCUMENTATION' => 'The DesignElements of the BioAssayData.',
                                        '__CLASS_NAME' => 'BioAssayData',
                                        '__RANK' => undef,
                                        '__ORDERED' => undef
                                      }, 'Bio::MAGE::Association::End' ),
                   '__OTHER' => bless( {
                                         '__NAME' => 'designElementDimension',
                                         '__IS_REF' => 1,
                                         '__CARDINALITY' => '1',
                                         '__DOCUMENTATION' => 'The DesignElements of the BioAssayData.',
                                         '__CLASS_NAME' => 'DesignElementDimension',
                                         '__RANK' => '3',
                                         '__ORDERED' => 0
                                       }, 'Bio::MAGE::Association::End' )
                 }, 'Bio::MAGE::Association' ),
          'quantitationTypeDimension',
          bless( {
                   '__SELF' => bless( {
                                        '__NAME' => undef,
                                        '__IS_REF' => 1,
                                        '__CARDINALITY' => '1',
                                        '__DOCUMENTATION' => 'The QuantitationTypes of the BioAssayData.',
                                        '__CLASS_NAME' => 'BioAssayData',
                                        '__RANK' => undef,
                                        '__ORDERED' => undef
                                      }, 'Bio::MAGE::Association::End' ),
                   '__OTHER' => bless( {
                                         '__NAME' => 'quantitationTypeDimension',
                                         '__IS_REF' => 1,
                                         '__CARDINALITY' => '1',
                                         '__DOCUMENTATION' => 'The QuantitationTypes of the BioAssayData.',
                                         '__CLASS_NAME' => 'QuantitationTypeDimension',
                                         '__RANK' => '4',
                                         '__ORDERED' => 0
                                       }, 'Bio::MAGE::Association::End' )
                 }, 'Bio::MAGE::Association' ),
          'bioDataValues',
          bless( {
                   '__SELF' => bless( {
                                        '__NAME' => undef,
                                        '__IS_REF' => 0,
                                        '__CARDINALITY' => '1',
                                        '__DOCUMENTATION' => 'The data values of the BioAssayData.',
                                        '__CLASS_NAME' => 'BioAssayData',
                                        '__RANK' => undef,
                                        '__ORDERED' => undef
                                      }, 'Bio::MAGE::Association::End' ),
                   '__OTHER' => bless( {
                                         '__NAME' => 'bioDataValues',
                                         '__IS_REF' => 1,
                                         '__CARDINALITY' => '0..1',
                                         '__DOCUMENTATION' => 'The data values of the BioAssayData.',
                                         '__CLASS_NAME' => 'BioDataValues',
                                         '__RANK' => '5',
                                         '__ORDERED' => 0
                                       }, 'Bio::MAGE::Association::End' )
                 }, 'Bio::MAGE::Association' )
        ]

}

=head2 ASSOCIATIONS

Associations are references to other class objects which can be shared
by multiple class instances at the same time. In the Perl
implementation of MAGE-OM classes, associations are implemented using
three separate methods:

=over

=item get*

Retrieves the current value. If the association has list cardinality,
an array reference is returned.

=item set*

Sets the current value B<replacing> any existing value. If the
association has list cardinality, the argument must be an array
reference. Unless you know what you are doing, you probably should be
using the add* methods.

=item add*

This method exists only for associations with list cardinality. It
appends a list of objects to any values that may already be stored in
the association.

=back

Bio::MAGE::BioAssayData::BioAssayData: has the following association accessor methods:

=over


=item designElementDimension


From the MAGE-OM documentation for the C<designElementDimension> association:

The DesignElements of the BioAssayData.



=over


=item $val = $bioassaydata->setDesignElementDimension($val)

The restricted setter method for the designElementDimension association.

Input parameters: the value to which the designElementDimension association will be set : an instance of type C<Bio::MAGE::BioAssayData::DesignElementDimension>.

Return value: the current value of the designElementDimension association : an instance of type C<Bio::MAGE::BioAssayData::DesignElementDimension>.

Side effects: none

Exceptions: will call C<croak()> if no input parameters are specified, or
if too many input parameters are specified , or if $val is not an instance of class C<Bio::MAGE::BioAssayData::DesignElementDimension>

=cut

sub setDesignElementDimension {
  my $self = shift;
  croak(__PACKAGE__ . "::setDesignElementDimension: no arguments passed to setter")
    unless @_;
  croak(__PACKAGE__ . "::setDesignElementDimension: too many arguments passed to setter")
    if @_ > 1;
  my $val = shift;
  croak(__PACKAGE__ . "::setDesignElementDimension: wrong type: " . ref($val) . " expected Bio::MAGE::BioAssayData::DesignElementDimension") unless UNIVERSAL::isa($val,'Bio::MAGE::BioAssayData::DesignElementDimension');
  return $self->{__DESIGNELEMENTDIMENSION} = $val;
}



=item $val = $bioassaydata->getDesignElementDimension()

The restricted getter method for the designElementDimension association.

Input parameters: none

Return value: the current value of the designElementDimension association : an instance of type C<Bio::MAGE::BioAssayData::DesignElementDimension>.

Side effects: none

Exceptions: will call C<croak()> if any input parameters are specified

=cut

sub getDesignElementDimension {
  my $self = shift;
  croak(__PACKAGE__ . "::getDesignElementDimension: arguments passed to getter")
    if @_;
  return $self->{__DESIGNELEMENTDIMENSION};
}




=back


=item bioAssayDimension


From the MAGE-OM documentation for the C<bioAssayDimension> association:

The BioAssays of the BioAssayData.



=over


=item $val = $bioassaydata->setBioAssayDimension($val)

The restricted setter method for the bioAssayDimension association.

Input parameters: the value to which the bioAssayDimension association will be set : an instance of type C<Bio::MAGE::BioAssayData::BioAssayDimension>.

Return value: the current value of the bioAssayDimension association : an instance of type C<Bio::MAGE::BioAssayData::BioAssayDimension>.

Side effects: none

Exceptions: will call C<croak()> if no input parameters are specified, or
if too many input parameters are specified , or if $val is not an instance of class C<Bio::MAGE::BioAssayData::BioAssayDimension>

=cut

sub setBioAssayDimension {
  my $self = shift;
  croak(__PACKAGE__ . "::setBioAssayDimension: no arguments passed to setter")
    unless @_;
  croak(__PACKAGE__ . "::setBioAssayDimension: too many arguments passed to setter")
    if @_ > 1;
  my $val = shift;
  croak(__PACKAGE__ . "::setBioAssayDimension: wrong type: " . ref($val) . " expected Bio::MAGE::BioAssayData::BioAssayDimension") unless UNIVERSAL::isa($val,'Bio::MAGE::BioAssayData::BioAssayDimension');
  return $self->{__BIOASSAYDIMENSION} = $val;
}



=item $val = $bioassaydata->getBioAssayDimension()

The restricted getter method for the bioAssayDimension association.

Input parameters: none

Return value: the current value of the bioAssayDimension association : an instance of type C<Bio::MAGE::BioAssayData::BioAssayDimension>.

Side effects: none

Exceptions: will call C<croak()> if any input parameters are specified

=cut

sub getBioAssayDimension {
  my $self = shift;
  croak(__PACKAGE__ . "::getBioAssayDimension: arguments passed to getter")
    if @_;
  return $self->{__BIOASSAYDIMENSION};
}




=back


=item bioDataValues


From the MAGE-OM documentation for the C<bioDataValues> association:

The data values of the BioAssayData.



=over


=item $val = $bioassaydata->setBioDataValues($val)

The restricted setter method for the bioDataValues association.

Input parameters: the value to which the bioDataValues association will be set : an instance of type C<Bio::MAGE::BioAssayData::BioDataValues>.

Return value: the current value of the bioDataValues association : an instance of type C<Bio::MAGE::BioAssayData::BioDataValues>.

Side effects: none

Exceptions: will call C<croak()> if no input parameters are specified, or
if too many input parameters are specified , or if $val is not an instance of class C<Bio::MAGE::BioAssayData::BioDataValues>

=cut

sub setBioDataValues {
  my $self = shift;
  croak(__PACKAGE__ . "::setBioDataValues: no arguments passed to setter")
    unless @_;
  croak(__PACKAGE__ . "::setBioDataValues: too many arguments passed to setter")
    if @_ > 1;
  my $val = shift;
  croak(__PACKAGE__ . "::setBioDataValues: wrong type: " . ref($val) . " expected Bio::MAGE::BioAssayData::BioDataValues") unless UNIVERSAL::isa($val,'Bio::MAGE::BioAssayData::BioDataValues');
  return $self->{__BIODATAVALUES} = $val;
}



=item $val = $bioassaydata->getBioDataValues()

The restricted getter method for the bioDataValues association.

Input parameters: none

Return value: the current value of the bioDataValues association : an instance of type C<Bio::MAGE::BioAssayData::BioDataValues>.

Side effects: none

Exceptions: will call C<croak()> if any input parameters are specified

=cut

sub getBioDataValues {
  my $self = shift;
  croak(__PACKAGE__ . "::getBioDataValues: arguments passed to getter")
    if @_;
  return $self->{__BIODATAVALUES};
}




=back


=item quantitationTypeDimension


From the MAGE-OM documentation for the C<quantitationTypeDimension> association:

The QuantitationTypes of the BioAssayData.



=over


=item $val = $bioassaydata->setQuantitationTypeDimension($val)

The restricted setter method for the quantitationTypeDimension association.

Input parameters: the value to which the quantitationTypeDimension association will be set : an instance of type C<Bio::MAGE::BioAssayData::QuantitationTypeDimension>.

Return value: the current value of the quantitationTypeDimension association : an instance of type C<Bio::MAGE::BioAssayData::QuantitationTypeDimension>.

Side effects: none

Exceptions: will call C<croak()> if no input parameters are specified, or
if too many input parameters are specified , or if $val is not an instance of class C<Bio::MAGE::BioAssayData::QuantitationTypeDimension>

=cut

sub setQuantitationTypeDimension {
  my $self = shift;
  croak(__PACKAGE__ . "::setQuantitationTypeDimension: no arguments passed to setter")
    unless @_;
  croak(__PACKAGE__ . "::setQuantitationTypeDimension: too many arguments passed to setter")
    if @_ > 1;
  my $val = shift;
  croak(__PACKAGE__ . "::setQuantitationTypeDimension: wrong type: " . ref($val) . " expected Bio::MAGE::BioAssayData::QuantitationTypeDimension") unless UNIVERSAL::isa($val,'Bio::MAGE::BioAssayData::QuantitationTypeDimension');
  return $self->{__QUANTITATIONTYPEDIMENSION} = $val;
}



=item $val = $bioassaydata->getQuantitationTypeDimension()

The restricted getter method for the quantitationTypeDimension association.

Input parameters: none

Return value: the current value of the quantitationTypeDimension association : an instance of type C<Bio::MAGE::BioAssayData::QuantitationTypeDimension>.

Side effects: none

Exceptions: will call C<croak()> if any input parameters are specified

=cut

sub getQuantitationTypeDimension {
  my $self = shift;
  croak(__PACKAGE__ . "::getQuantitationTypeDimension: arguments passed to getter")
    if @_;
  return $self->{__QUANTITATIONTYPEDIMENSION};
}




=back


=item summaryStatistics


From the MAGE-OM documentation for the C<summaryStatistics> association:

Statistics on the Quality of the BioAssayData.



=over


=item $array_ref = $bioassaydata->setSummaryStatistics($array_ref)

The restricted setter method for the summaryStatistics association.

Input parameters: the value to which the summaryStatistics association will be set : a reference to an array of objects of type C<Bio::MAGE::NameValueType>

Return value: the current value of the summaryStatistics association : a reference to an array of objects of type C<Bio::MAGE::NameValueType>

Side effects: none

Exceptions: will call C<croak()> if no input parameters are specified, or
if too many input parameters are specified , or if $array_ref is not a reference to an array class C<Bio::MAGE::NameValueType> instances

=cut

sub setSummaryStatistics {
  my $self = shift;
  croak(__PACKAGE__ . "::setSummaryStatistics: no arguments passed to setter")
    unless @_;
  croak(__PACKAGE__ . "::setSummaryStatistics: too many arguments passed to setter")
    if @_ > 1;
  my $val = shift;
    croak(__PACKAGE__ . "::setSummaryStatistics: expected array reference, got $self")
    unless UNIVERSAL::isa($val,'ARRAY');
  foreach my $val (@{$val}) {
    croak(__PACKAGE__ . "::setSummaryStatistics: wrong type: " . ref($val) . " expected Bio::MAGE::NameValueType")
      unless UNIVERSAL::isa($val,'Bio::MAGE::NameValueType');
  }

  return $self->{__SUMMARYSTATISTICS} = $val;
}



=item $array_ref = $bioassaydata->getSummaryStatistics()

The restricted getter method for the summaryStatistics association.

Input parameters: none

Return value: the current value of the summaryStatistics association : a reference to an array of objects of type C<Bio::MAGE::NameValueType>

Side effects: none

Exceptions: will call C<croak()> if any input parameters are specified

=cut

sub getSummaryStatistics {
  my $self = shift;
  croak(__PACKAGE__ . "::getSummaryStatistics: arguments passed to getter")
    if @_;
  return $self->{__SUMMARYSTATISTICS};
}



=item $bioassaydata->addSummaryStatistics(@vals)

Because the summaryStatistics association has list cardinality, it may store more
than one value. This method adds the current list of objects in the summaryStatistics
association.

Input parameters: the list of values C<@vals> to add to the summaryStatistics
association. B<NOTE>: submitting a single value is permitted.

Return value: none

Side effects: none

Exceptions: will call C<croak()> if no input parameters are specified
, or if any of the objects in @vals is not an instance of class C<Bio::MAGE::NameValueType>

=cut

sub addSummaryStatistics {
  my $self = shift;
  croak(__PACKAGE__ . "::addSummaryStatistics: no arguments passed to setter")
    unless @_;
  my @vals = @_;
    foreach my $val (@vals) {
    croak(__PACKAGE__ . "::addSummaryStatistics: wrong type: " . ref($val) . " expected Bio::MAGE::NameValueType")
      unless UNIVERSAL::isa($val,'Bio::MAGE::NameValueType');
  }

  push(@{$self->{__SUMMARYSTATISTICS}},@vals);
}



=back

Associations Inherited from Bio::MAGE::Describable


=item security


From the MAGE-OM documentation for the C<security> association:

Information on the security for the instance of the class.



=over


=item $val = $describable->setSecurity($val)

The restricted setter method for the security association.

Input parameters: the value to which the security association will be set : an instance of type C<Bio::MAGE::AuditAndSecurity::Security>.

Return value: the current value of the security association : an instance of type C<Bio::MAGE::AuditAndSecurity::Security>.

Side effects: none

Exceptions: will call C<croak()> if no input parameters are specified, or
if too many input parameters are specified , or if $val is not an instance of class C<Bio::MAGE::AuditAndSecurity::Security>

=cut


=item $val = $describable->getSecurity()

The restricted getter method for the security association.

Input parameters: none

Return value: the current value of the security association : an instance of type C<Bio::MAGE::AuditAndSecurity::Security>.

Side effects: none

Exceptions: will call C<croak()> if any input parameters are specified

=cut



=back


=item auditTrail


From the MAGE-OM documentation for the C<auditTrail> association:

A list of Audit instances that track changes to the instance of Describable.



=over


=item $array_ref = $describable->setAuditTrail($array_ref)

The restricted setter method for the auditTrail association.

Input parameters: the value to which the auditTrail association will be set : a reference to an array of objects of type C<Bio::MAGE::AuditAndSecurity::Audit>

Return value: the current value of the auditTrail association : a reference to an array of objects of type C<Bio::MAGE::AuditAndSecurity::Audit>

Side effects: none

Exceptions: will call C<croak()> if no input parameters are specified, or
if too many input parameters are specified , or if $array_ref is not a reference to an array class C<Bio::MAGE::AuditAndSecurity::Audit> instances

=cut


=item $array_ref = $describable->getAuditTrail()

The restricted getter method for the auditTrail association.

Input parameters: none

Return value: the current value of the auditTrail association : a reference to an array of objects of type C<Bio::MAGE::AuditAndSecurity::Audit>

Side effects: none

Exceptions: will call C<croak()> if any input parameters are specified

=cut


=item $describable->addAuditTrail(@vals)

Because the auditTrail association has list cardinality, it may store more
than one value. This method adds the current list of objects in the auditTrail
association.

Input parameters: the list of values C<@vals> to add to the auditTrail
association. B<NOTE>: submitting a single value is permitted.

Return value: none

Side effects: none

Exceptions: will call C<croak()> if no input parameters are specified
, or if any of the objects in @vals is not an instance of class C<Bio::MAGE::AuditAndSecurity::Audit>

=cut



=back


=item descriptions


From the MAGE-OM documentation for the C<descriptions> association:

Free hand text descriptions.  Makes available the associations of Description to an instance of Describable.



=over


=item $array_ref = $describable->setDescriptions($array_ref)

The restricted setter method for the descriptions association.

Input parameters: the value to which the descriptions association will be set : a reference to an array of objects of type C<Bio::MAGE::Description::Description>

Return value: the current value of the descriptions association : a reference to an array of objects of type C<Bio::MAGE::Description::Description>

Side effects: none

Exceptions: will call C<croak()> if no input parameters are specified, or
if too many input parameters are specified , or if $array_ref is not a reference to an array class C<Bio::MAGE::Description::Description> instances

=cut


=item $array_ref = $describable->getDescriptions()

The restricted getter method for the descriptions association.

Input parameters: none

Return value: the current value of the descriptions association : a reference to an array of objects of type C<Bio::MAGE::Description::Description>

Side effects: none

Exceptions: will call C<croak()> if any input parameters are specified

=cut


=item $describable->addDescriptions(@vals)

Because the descriptions association has list cardinality, it may store more
than one value. This method adds the current list of objects in the descriptions
association.

Input parameters: the list of values C<@vals> to add to the descriptions
association. B<NOTE>: submitting a single value is permitted.

Return value: none

Side effects: none

Exceptions: will call C<croak()> if no input parameters are specified
, or if any of the objects in @vals is not an instance of class C<Bio::MAGE::Description::Description>

=cut



=back

Associations Inherited from Bio::MAGE::Extendable


=item propertySets


From the MAGE-OM documentation for the C<propertySets> association:

Allows specification of name/value pairs.  Meant to primarily help in-house, pipeline processing of instances by providing a place for values that aren't part of the specification proper.



=over


=item $array_ref = $extendable->setPropertySets($array_ref)

The restricted setter method for the propertySets association.

Input parameters: the value to which the propertySets association will be set : a reference to an array of objects of type C<Bio::MAGE::NameValueType>

Return value: the current value of the propertySets association : a reference to an array of objects of type C<Bio::MAGE::NameValueType>

Side effects: none

Exceptions: will call C<croak()> if no input parameters are specified, or
if too many input parameters are specified , or if $array_ref is not a reference to an array class C<Bio::MAGE::NameValueType> instances

=cut


=item $array_ref = $extendable->getPropertySets()

The restricted getter method for the propertySets association.

Input parameters: none

Return value: the current value of the propertySets association : a reference to an array of objects of type C<Bio::MAGE::NameValueType>

Side effects: none

Exceptions: will call C<croak()> if any input parameters are specified

=cut


=item $extendable->addPropertySets(@vals)

Because the propertySets association has list cardinality, it may store more
than one value. This method adds the current list of objects in the propertySets
association.

Input parameters: the list of values C<@vals> to add to the propertySets
association. B<NOTE>: submitting a single value is permitted.

Return value: none

Side effects: none

Exceptions: will call C<croak()> if no input parameters are specified
, or if any of the objects in @vals is not an instance of class C<Bio::MAGE::NameValueType>

=cut



=back



=back


=cut



sub initialize {
  carp "Bio::MAGE::BioAssayData::BioAssayData::initialize: abstract base classes should not be instantiated";
}



=head1 BUGS

Please send bug reports to mged-mage@lists.sf.net

=head1 AUTHOR

Jason E. Stewart (www.openinformatics.com)

=head1 SEE ALSO

perl(1).

=cut

#
# End the module by returning a true value
#
1;

