# This might look like shell script, but it's actually -*- perl -*-
use strict;
use lib 't/';

use TestUtils;
use Test::More qw(no_plan);
use Data::Dumper;

use html::li;

my @items = qw(bread butter vodka);

my $tree = html::li->new;
$tree->store_items(@items);
  
my $generated_html = ptree ($tree, html_dir . 'li.gen');
is
  (
   $generated_html,
   File::Slurp::read_file(html_dir . 'li.exp'),
   "list created correctly" 
  );


