package Locales::DB::Territory::kk;

use strict;
use warnings;

# Auto generated from CLDR
use if $Locales::_UNICODE_STRINGS, 'utf8';

$Locales::DB::Territory::kk::VERSION = '0.09';

$Locales::DB::Territory::kk::cldr_version = '2.0';

%Locales::DB::Territory::kk::code_to_name = (
    '001' => 'Әлем',
    '002' => 'Африка',
    '003' => "Солтүстік\ Америка",
    '005' => "Оңтүстік\ Америка",
    '009' => 'Океания',
    '011' => "Батыс\ Африка",
    '013' => "Орталық\ Америка",
    '014' => "Шығыс\ Африка",
    '015' => "Солтүстік\ Африка",
    '017' => "Орталық\ Африка",
    '018' => "Оңтүстік\ Африка",
    '019' => 'Америкалар',
    '021' => "Солтүстік\ Америка\ \(АҚШ\,\ Канада\,\ Гренландия\ және\ Бермуд\ аралдары\)",
    '029' => 'Кариб',
    '030' => "Шығыс\ Азия",
    '034' => "Оңтүстік\ Азия",
    '035' => "Оңтүстік\-шығыс\ Азия",
    '039' => "Оңтүстік\ Еуропа",
    '053' => "Австралия\ және\ Жаңа\ Зеландия",
    '054' => 'Меланезия',
    '057' => "Микронезия\ регионы",
    '061' => 'Полинезия',
    '062' => "South\-Central\ Asia",
    142   => 'Азия',
    143   => "Орталық\ Азия",
    145   => "Батыс\ Азия",
    150   => 'Еуропа',
    151   => "Шығыс\ Еуропа",
    154   => "Солтүстік\ Еуропа",
    155   => "Батыс\ Еуропа",
    172   => "Commonwealth\ of\ Independent\ States",
    200   => 'Czechoslovakia',
    419   => "Латын\ Америкасы",
    830   => "Channel\ Islands",
    'ac'  => "Ascension\ Island",
    'ad'  => 'Андорра',
    'ae'  => "Біріккен\ Араб\ Эмираттары",
    'af'  => 'Ауғанстан',
    'ag'  => "Antigua\ and\ Barbuda",
    'ai'  => 'Anguilla',
    'al'  => 'Албания',
    'am'  => 'Армения',
    'an'  => "Netherlands\ Antilles",
    'ao'  => 'Ангола',
    'aq'  => 'Антарктика',
    'ar'  => 'Аргентина',
    'as'  => "American\ Samoa",
    'at'  => 'Австрия',
    'au'  => 'Австралия',
    'aw'  => 'Аруба',
    'ax'  => "\Ã\land\ Islands",
    'az'  => 'Әзербайжан',
    'ba'  => "Босния\ және\ Герцеговина",
    'bb'  => 'Барбадос',
    'bd'  => 'Бангладеш',
    'be'  => 'Бельгия',
    'bf'  => "Burkina\ Faso",
    'bg'  => 'Болгария',
    'bh'  => 'Бахрейн',
    'bi'  => 'Бурунди',
    'bj'  => 'Бенин',
    'bl'  => "Saint\ Barth\Ã\©lemy",
    'bm'  => 'Bermuda',
    'bn'  => 'Brunei',
    'bo'  => 'Боливия',
    'bq'  => "British\ Antarctic\ Territory",
    'br'  => 'Бразилия',
    'bs'  => 'Bahamas',
    'bt'  => 'Бутан',
    'bv'  => "Bouvet\ Island",
    'bw'  => 'Ботсвана',
    'by'  => 'Беларусь',
    'bz'  => 'Белиз',
    'ca'  => 'Канада',
    'cc'  => "Cocos\ \[Keeling\]\ Islands",
    'cd'  => "Congo\ \[DRC\]",
    'cf'  => "Central\ African\ Republic",
    'cg'  => "Congo\ \[Republic\]",
    'ch'  => 'Швейцария',
    'ci'  => "Ivory\ Coast",
    'ck'  => "Cook\ Islands",
    'cl'  => 'Чили',
    'cm'  => 'Камерун',
    'cn'  => 'Қытай',
    'co'  => 'Колумбия',
    'cp'  => "Clipperton\ Island",
    'cr'  => "Costa\ Rica",
    'cs'  => "Serbia\ and\ Montenegro",
    'ct'  => "Canton\ and\ Enderbury\ Islands",
    'cu'  => 'Cuba',
    'cv'  => "Cape\ Verde",
    'cx'  => "Christmas\ Island",
    'cy'  => 'Cyprus',
    'cz'  => "Czech\ Republic",
    'dd'  => "East\ Germany",
    'de'  => 'Алмания',
    'dg'  => "Diego\ Garcia",
    'dj'  => 'Djibouti',
    'dk'  => 'Дания',
    'dm'  => 'Dominica',
    'do'  => "Dominican\ Republic",
    'dz'  => 'Algeria',
    'ea'  => "Ceuta\ and\ Melilla",
    'ec'  => 'Ecuador',
    'ee'  => 'Estonia',
    'eg'  => 'Egypt',
    'eh'  => "Western\ Sahara",
    'er'  => 'Eritrea',
    'es'  => 'Испания',
    'et'  => 'Ethiopia',
    'eu'  => "European\ Union",
    'fi'  => 'Финляндия',
    'fj'  => 'Fiji',
    'fk'  => "Falkland\ Islands\ \[Islas\ Malvinas\]",
    'fm'  => 'Micronesia',
    'fo'  => "Faroe\ Islands",
    'fq'  => "French\ Southern\ and\ Antarctic\ Territories",
    'fr'  => 'Франция',
    'fx'  => "Metropolitan\ France",
    'ga'  => 'Gabon',
    'gb'  => 'Ұлыбритания',
    'gd'  => 'Grenada',
    'ge'  => 'Georgia',
    'gf'  => "French\ Guiana",
    'gg'  => 'Guernsey',
    'gh'  => 'Ghana',
    'gi'  => 'Gibraltar',
    'gl'  => 'Greenland',
    'gm'  => 'Gambia',
    'gn'  => 'Guinea',
    'gp'  => 'Guadeloupe',
    'gq'  => "Equatorial\ Guinea",
    'gr'  => 'Грекия',
    'gs'  => "South\ Georgia\ and\ the\ South\ Sandwich\ Islands",
    'gt'  => 'Guatemala',
    'gu'  => 'Guam',
    'gw'  => "Guinea\-Bissau",
    'gy'  => 'Guyana',
    'hk'  => "Гонконг\ \(арнайы\ әкімшілік\ аймақ\)",
    'hm'  => "Heard\ Island\ and\ McDonald\ Islands",
    'hn'  => 'Honduras',
    'hr'  => 'Croatia',
    'ht'  => 'Haiti',
    'hu'  => 'Hungary',
    'ic'  => "Canary\ Islands",
    'id'  => 'Индонезия',
    'ie'  => 'Ирландия',
    'il'  => 'Israel',
    'im'  => "Isle\ of\ Man",
    'in'  => 'Индия',
    'io'  => "British\ Indian\ Ocean\ Territory",
    'iq'  => 'Iraq',
    'ir'  => 'Iran',
    'is'  => 'Iceland',
    'it'  => 'Италия',
    'je'  => 'Jersey',
    'jm'  => 'Jamaica',
    'jo'  => 'Jordan',
    'jp'  => 'Жапония',
    'jt'  => "Johnston\ Island",
    'ke'  => 'Kenya',
    'kg'  => 'Kyrgyzstan',
    'kh'  => 'Cambodia',
    'ki'  => 'Kiribati',
    'km'  => 'Comoros',
    'kn'  => "Saint\ Kitts\ and\ Nevis",
    'kp'  => "North\ Korea",
    'kr'  => "Солтүстік\ Корея",
    'kw'  => 'Kuwait',
    'ky'  => "Cayman\ Islands",
    'kz'  => 'Қазақстан',
    'la'  => 'Laos',
    'lb'  => 'Lebanon',
    'lc'  => "Saint\ Lucia",
    'li'  => 'Liechtenstein',
    'lk'  => "Sri\ Lanka",
    'lr'  => 'Liberia',
    'ls'  => 'Lesotho',
    'lt'  => 'Lithuania',
    'lu'  => 'Luxembourg',
    'lv'  => 'Latvia',
    'ly'  => 'Libya',
    'ma'  => 'Morocco',
    'mc'  => 'Monaco',
    'md'  => 'Moldova',
    'me'  => 'Montenegro',
    'mf'  => "Saint\ Martin",
    'mg'  => 'Madagascar',
    'mh'  => "Marshall\ Islands",
    'mi'  => "Midway\ Islands",
    'mk'  => "Macedonia\ \[FYROM\]",
    'ml'  => 'Mali',
    'mm'  => "Myanmar\ \[Burma\]",
    'mn'  => 'Mongolia',
    'mo'  => 'Macau',
    'mp'  => "Northern\ Mariana\ Islands",
    'mq'  => 'Martinique',
    'mr'  => 'Mauritania',
    'ms'  => 'Montserrat',
    'mt'  => 'Malta',
    'mu'  => 'Mauritius',
    'mv'  => 'Maldives',
    'mw'  => 'Malawi',
    'mx'  => 'Мексика',
    'my'  => 'Malaysia',
    'mz'  => 'Mozambique',
    'na'  => 'Namibia',
    'nc'  => "New\ Caledonia",
    'ne'  => 'Niger',
    'nf'  => "Norfolk\ Island",
    'ng'  => 'Nigeria',
    'ni'  => 'Nicaragua',
    'nl'  => 'Голландия',
    'no'  => 'Норвегия',
    'np'  => 'Nepal',
    'nq'  => "Dronning\ Maud\ Land",
    'nr'  => 'Nauru',
    'nt'  => "Neutral\ Zone",
    'nu'  => 'Niue',
    'nz'  => "New\ Zealand",
    'om'  => 'Oman',
    'pa'  => 'Panama',
    'pc'  => "Pacific\ Islands\ Trust\ Territory",
    'pe'  => 'Peru',
    'pf'  => "French\ Polynesia",
    'pg'  => "Papua\ New\ Guinea",
    'ph'  => 'Philippines',
    'pk'  => 'Pakistan',
    'pl'  => 'Польша',
    'pm'  => "Saint\ Pierre\ and\ Miquelon",
    'pn'  => "Pitcairn\ Islands",
    'pr'  => "Puerto\ Rico",
    'ps'  => "Palestinian\ Territories",
    'pt'  => 'Португалия',
    'pu'  => "U\.S\.\ Miscellaneous\ Pacific\ Islands",
    'pw'  => 'Palau',
    'py'  => 'Paraguay',
    'pz'  => "Panama\ Canal\ Zone",
    'qa'  => 'Qatar',
    'qo'  => "Outlying\ Oceania",
    're'  => "R\Ã\©union",
    'ro'  => 'Romania',
    'rs'  => 'Serbia',
    'ru'  => 'Ресей',
    'rw'  => 'Rwanda',
    'sa'  => "Сауд\ Арабиясы",
    'sb'  => "Solomon\ Islands",
    'sc'  => 'Seychelles',
    'sd'  => 'Sudan',
    'se'  => 'Швеция',
    'sg'  => 'Singapore',
    'sh'  => "Saint\ Helena",
    'si'  => 'Slovenia',
    'sj'  => "Svalbard\ and\ Jan\ Mayen",
    'sk'  => 'Slovakia',
    'sl'  => "Sierra\ Leone",
    'sm'  => "San\ Marino",
    'sn'  => 'Senegal',
    'so'  => 'Somalia',
    'sr'  => 'Suriname',
    'st'  => "S\Ã\£o\ Tom\Ã\©\ and\ Pr\Ã\­ncipe",
    'su'  => "Union\ of\ Soviet\ Socialist\ Republics",
    'sv'  => "El\ Salvador",
    'sy'  => 'Syria',
    'sz'  => 'Swaziland',
    'ta'  => "Tristan\ da\ Cunha",
    'tc'  => "Turks\ and\ Caicos\ Islands",
    'td'  => 'Chad',
    'tf'  => "French\ Southern\ Territories",
    'tg'  => 'Togo',
    'th'  => 'Тайланд',
    'tj'  => 'Tajikistan',
    'tk'  => 'Tokelau',
    'tl'  => "East\ Timor",
    'tm'  => 'Turkmenistan',
    'tn'  => 'Tunisia',
    'to'  => 'Тонга',
    'tr'  => 'Түркия',
    'tt'  => "Trinidad\ and\ Tobago",
    'tv'  => 'Tuvalu',
    'tw'  => 'Тайвань',
    'tz'  => 'Tanzania',
    'ua'  => 'Ukraine',
    'ug'  => 'Uganda',
    'um'  => "U\.S\.\ Minor\ Outlying\ Islands",
    'us'  => 'АҚШ',
    'uy'  => 'Uruguay',
    'uz'  => 'Uzbekistan',
    'va'  => "Vatican\ City",
    'vc'  => "Saint\ Vincent\ and\ the\ Grenadines",
    'vd'  => "North\ Vietnam",
    've'  => 'Venezuela',
    'vg'  => "British\ Virgin\ Islands",
    'vi'  => "U\.S\.\ Virgin\ Islands",
    'vn'  => 'Vietnam',
    'vu'  => 'Vanuatu',
    'wf'  => "Wallis\ and\ Futuna",
    'wk'  => "Wake\ Island",
    'ws'  => 'Samoa',
    'yd'  => "People\â\\s\ Democratic\ Republic\ of\ Yemen",
    'ye'  => 'Yemen',
    'yt'  => 'Mayotte',
    'za'  => "Оңтүстік\ Африка\ республикасы",
    'zm'  => 'Zambia',
    'zw'  => 'Zimbabwe',
    'zz'  => "Белгісіз\ аймақ",
);

%Locales::DB::Territory::kk::name_to_code = (
    'algeria'                                                                                                        => 'dz',
    'americansamoa'                                                                                                  => 'as',
    'anguilla'                                                                                                       => 'ai',
    'antiguaandbarbuda'                                                                                              => 'ag',
    'ascensionisland'                                                                                                => 'ac',
    'bahamas'                                                                                                        => 'bs',
    'bermuda'                                                                                                        => 'bm',
    'bouvetisland'                                                                                                   => 'bv',
    'britishantarcticterritory'                                                                                      => 'bq',
    'britishindianoceanterritory'                                                                                    => 'io',
    'britishvirginislands'                                                                                           => 'vg',
    'brunei'                                                                                                         => 'bn',
    'burkinafaso'                                                                                                    => 'bf',
    'cambodia'                                                                                                       => 'kh',
    'canaryislands'                                                                                                  => 'ic',
    'cantonandenderburyislands'                                                                                      => 'ct',
    'capeverde'                                                                                                      => 'cv',
    'caymanislands'                                                                                                  => 'ky',
    'centralafricanrepublic'                                                                                         => 'cf',
    'ceutaandmelilla'                                                                                                => 'ea',
    'chad'                                                                                                           => 'td',
    'channelislands'                                                                                                 => 830,
    'christmasisland'                                                                                                => 'cx',
    'clippertonisland'                                                                                               => 'cp',
    'cocoskeelingislands'                                                                                            => 'cc',
    'commonwealthofindependentstates'                                                                                => 172,
    'comoros'                                                                                                        => 'km',
    'congodrc'                                                                                                       => 'cd',
    'congorepublic'                                                                                                  => 'cg',
    'cookislands'                                                                                                    => 'ck',
    'costarica'                                                                                                      => 'cr',
    'croatia'                                                                                                        => 'hr',
    'cuba'                                                                                                           => 'cu',
    'cyprus'                                                                                                         => 'cy',
    'czechoslovakia'                                                                                                 => 200,
    'czechrepublic'                                                                                                  => 'cz',
    'diegogarcia'                                                                                                    => 'dg',
    'djibouti'                                                                                                       => 'dj',
    'dominica'                                                                                                       => 'dm',
    'dominicanrepublic'                                                                                              => 'do',
    'dronningmaudland'                                                                                               => 'nq',
    'eastgermany'                                                                                                    => 'dd',
    'easttimor'                                                                                                      => 'tl',
    'ecuador'                                                                                                        => 'ec',
    'egypt'                                                                                                          => 'eg',
    'elsalvador'                                                                                                     => 'sv',
    'equatorialguinea'                                                                                               => 'gq',
    'eritrea'                                                                                                        => 'er',
    'estonia'                                                                                                        => 'ee',
    'ethiopia'                                                                                                       => 'et',
    'europeanunion'                                                                                                  => 'eu',
    'falklandislandsislasmalvinas'                                                                                   => 'fk',
    'faroeislands'                                                                                                   => 'fo',
    'fiji'                                                                                                           => 'fj',
    'frenchguiana'                                                                                                   => 'gf',
    'frenchpolynesia'                                                                                                => 'pf',
    'frenchsouthernandantarcticterritories'                                                                          => 'fq',
    'frenchsouthernterritories'                                                                                      => 'tf',
    'gabon'                                                                                                          => 'ga',
    'gambia'                                                                                                         => 'gm',
    'georgia'                                                                                                        => 'ge',
    'ghana'                                                                                                          => 'gh',
    'gibraltar'                                                                                                      => 'gi',
    'greenland'                                                                                                      => 'gl',
    'grenada'                                                                                                        => 'gd',
    'guadeloupe'                                                                                                     => 'gp',
    'guam'                                                                                                           => 'gu',
    'guatemala'                                                                                                      => 'gt',
    'guernsey'                                                                                                       => 'gg',
    'guinea'                                                                                                         => 'gn',
    'guineabissau'                                                                                                   => 'gw',
    'guyana'                                                                                                         => 'gy',
    'haiti'                                                                                                          => 'ht',
    'heardislandandmcdonaldislands'                                                                                  => 'hm',
    'honduras'                                                                                                       => 'hn',
    'hungary'                                                                                                        => 'hu',
    'iceland'                                                                                                        => 'is',
    'iran'                                                                                                           => 'ir',
    'iraq'                                                                                                           => 'iq',
    'isleofman'                                                                                                      => 'im',
    'israel'                                                                                                         => 'il',
    'ivorycoast'                                                                                                     => 'ci',
    'jamaica'                                                                                                        => 'jm',
    'jersey'                                                                                                         => 'je',
    'johnstonisland'                                                                                                 => 'jt',
    'jordan'                                                                                                         => 'jo',
    'kenya'                                                                                                          => 'ke',
    'kiribati'                                                                                                       => 'ki',
    'kuwait'                                                                                                         => 'kw',
    'kyrgyzstan'                                                                                                     => 'kg',
    'laos'                                                                                                           => 'la',
    'latvia'                                                                                                         => 'lv',
    'lebanon'                                                                                                        => 'lb',
    'lesotho'                                                                                                        => 'ls',
    'liberia'                                                                                                        => 'lr',
    'libya'                                                                                                          => 'ly',
    'liechtenstein'                                                                                                  => 'li',
    'lithuania'                                                                                                      => 'lt',
    'luxembourg'                                                                                                     => 'lu',
    'macau'                                                                                                          => 'mo',
    'macedoniafyrom'                                                                                                 => 'mk',
    'madagascar'                                                                                                     => 'mg',
    'malawi'                                                                                                         => 'mw',
    'malaysia'                                                                                                       => 'my',
    'maldives'                                                                                                       => 'mv',
    'mali'                                                                                                           => 'ml',
    'malta'                                                                                                          => 'mt',
    'marshallislands'                                                                                                => 'mh',
    'martinique'                                                                                                     => 'mq',
    'mauritania'                                                                                                     => 'mr',
    'mauritius'                                                                                                      => 'mu',
    'mayotte'                                                                                                        => 'yt',
    'metropolitanfrance'                                                                                             => 'fx',
    'micronesia'                                                                                                     => 'fm',
    'midwayislands'                                                                                                  => 'mi',
    'moldova'                                                                                                        => 'md',
    'monaco'                                                                                                         => 'mc',
    'mongolia'                                                                                                       => 'mn',
    'montenegro'                                                                                                     => 'me',
    'montserrat'                                                                                                     => 'ms',
    'morocco'                                                                                                        => 'ma',
    'mozambique'                                                                                                     => 'mz',
    'myanmarburma'                                                                                                   => 'mm',
    'namibia'                                                                                                        => 'na',
    'nauru'                                                                                                          => 'nr',
    'nepal'                                                                                                          => 'np',
    'netherlandsantilles'                                                                                            => 'an',
    'neutralzone'                                                                                                    => 'nt',
    'newcaledonia'                                                                                                   => 'nc',
    'newzealand'                                                                                                     => 'nz',
    'nicaragua'                                                                                                      => 'ni',
    'niger'                                                                                                          => 'ne',
    'nigeria'                                                                                                        => 'ng',
    'niue'                                                                                                           => 'nu',
    'norfolkisland'                                                                                                  => 'nf',
    'northernmarianaislands'                                                                                         => 'mp',
    'northkorea'                                                                                                     => 'kp',
    'northvietnam'                                                                                                   => 'vd',
    'oman'                                                                                                           => 'om',
    'outlyingoceania'                                                                                                => 'qo',
    'pacificislandstrustterritory'                                                                                   => 'pc',
    'pakistan'                                                                                                       => 'pk',
    'palau'                                                                                                          => 'pw',
    'palestinianterritories'                                                                                         => 'ps',
    'panama'                                                                                                         => 'pa',
    'panamacanalzone'                                                                                                => 'pz',
    'papuanewguinea'                                                                                                 => 'pg',
    'paraguay'                                                                                                       => 'py',
    "people\â\\sdemocraticrepublicofyemen"                                                                      => 'yd',
    'peru'                                                                                                           => 'pe',
    'philippines'                                                                                                    => 'ph',
    'pitcairnislands'                                                                                                => 'pn',
    'puertorico'                                                                                                     => 'pr',
    'qatar'                                                                                                          => 'qa',
    'romania'                                                                                                        => 'ro',
    'rwanda'                                                                                                         => 'rw',
    "r\Ã\©union"                                                                                                   => 're',
    "saintbarth\Ã\©lemy"                                                                                           => 'bl',
    'sainthelena'                                                                                                    => 'sh',
    'saintkittsandnevis'                                                                                             => 'kn',
    'saintlucia'                                                                                                     => 'lc',
    'saintmartin'                                                                                                    => 'mf',
    'saintpierreandmiquelon'                                                                                         => 'pm',
    'saintvincentandthegrenadines'                                                                                   => 'vc',
    'samoa'                                                                                                          => 'ws',
    'sanmarino'                                                                                                      => 'sm',
    'senegal'                                                                                                        => 'sn',
    'serbia'                                                                                                         => 'rs',
    'serbiaandmontenegro'                                                                                            => 'cs',
    'seychelles'                                                                                                     => 'sc',
    'sierraleone'                                                                                                    => 'sl',
    'singapore'                                                                                                      => 'sg',
    'slovakia'                                                                                                       => 'sk',
    'slovenia'                                                                                                       => 'si',
    'solomonislands'                                                                                                 => 'sb',
    'somalia'                                                                                                        => 'so',
    'southcentralasia'                                                                                               => '062',
    'southgeorgiaandthesouthsandwichislands'                                                                         => 'gs',
    'srilanka'                                                                                                       => 'lk',
    'sudan'                                                                                                          => 'sd',
    'suriname'                                                                                                       => 'sr',
    'svalbardandjanmayen'                                                                                            => 'sj',
    'swaziland'                                                                                                      => 'sz',
    'syria'                                                                                                          => 'sy',
    "s\Ã\£otom\Ã\©andpr\Ã\­ncipe"                                                                              => 'st',
    'tajikistan'                                                                                                     => 'tj',
    'tanzania'                                                                                                       => 'tz',
    'togo'                                                                                                           => 'tg',
    'tokelau'                                                                                                        => 'tk',
    'trinidadandtobago'                                                                                              => 'tt',
    'tristandacunha'                                                                                                 => 'ta',
    'tunisia'                                                                                                        => 'tn',
    'turkmenistan'                                                                                                   => 'tm',
    'turksandcaicosislands'                                                                                          => 'tc',
    'tuvalu'                                                                                                         => 'tv',
    "u\.s\.minoroutlyingislands"                                                                                     => 'um',
    "u\.s\.miscellaneouspacificislands"                                                                              => 'pu',
    "u\.s\.virginislands"                                                                                            => 'vi',
    'uganda'                                                                                                         => 'ug',
    'ukraine'                                                                                                        => 'ua',
    'unionofsovietsocialistrepublics'                                                                                => 'su',
    'uruguay'                                                                                                        => 'uy',
    'uzbekistan'                                                                                                     => 'uz',
    'vanuatu'                                                                                                        => 'vu',
    'vaticancity'                                                                                                    => 'va',
    'venezuela'                                                                                                      => 've',
    'vietnam'                                                                                                        => 'vn',
    'wakeisland'                                                                                                     => 'wk',
    'wallisandfutuna'                                                                                                => 'wf',
    'westernsahara'                                                                                                  => 'eh',
    'yemen'                                                                                                          => 'ye',
    'zambia'                                                                                                         => 'zm',
    'zimbabwe'                                                                                                       => 'zw',
    "\Ã\landislands"                                                                                              => 'ax',
    'Австралия'                                                                                             => 'au',
    'АвстралияжәнеЖаңаЗеландия'                                                             => '053',
    'Австрия'                                                                                                 => 'at',
    'Азия'                                                                                                       => 142,
    'Албания'                                                                                                 => 'al',
    'Алмания'                                                                                                 => 'de',
    'Америкалар'                                                                                           => '019',
    'Ангола'                                                                                                   => 'ao',
    'Андорра'                                                                                                 => 'ad',
    'Антарктика'                                                                                           => 'aq',
    'Аргентина'                                                                                             => 'ar',
    'Армения'                                                                                                 => 'am',
    'Аруба'                                                                                                     => 'aw',
    'Ауғанстан'                                                                                             => 'af',
    'Африка'                                                                                                   => '002',
    'АҚШ'                                                                                                         => 'us',
    'Бангладеш'                                                                                             => 'bd',
    'Барбадос'                                                                                               => 'bb',
    'БатысАзия'                                                                                             => 145,
    'БатысАфрика'                                                                                         => '011',
    'БатысЕуропа'                                                                                         => 155,
    'Бахрейн'                                                                                                 => 'bh',
    'Беларусь'                                                                                               => 'by',
    'Белгісізаймақ'                                                                                     => 'zz',
    'Белиз'                                                                                                     => 'bz',
    'Бельгия'                                                                                                 => 'be',
    'Бенин'                                                                                                     => 'bj',
    'Болгария'                                                                                               => 'bg',
    'Боливия'                                                                                                 => 'bo',
    'БоснияжәнеГерцеговина'                                                                     => 'ba',
    'Ботсвана'                                                                                               => 'bw',
    'Бразилия'                                                                                               => 'br',
    'Бурунди'                                                                                                 => 'bi',
    'Бутан'                                                                                                     => 'bt',
    'БіріккенАрабЭмираттары'                                                                   => 'ae',
    'Голландия'                                                                                             => 'nl',
    'Гонконгарнайыәкімшілікаймақ'                                                         => 'hk',
    'Грекия'                                                                                                   => 'gr',
    'Дания'                                                                                                     => 'dk',
    'Еуропа'                                                                                                   => 150,
    'Жапония'                                                                                                 => 'jp',
    'Индия'                                                                                                     => 'in',
    'Индонезия'                                                                                             => 'id',
    'Ирландия'                                                                                               => 'ie',
    'Испания'                                                                                                 => 'es',
    'Италия'                                                                                                   => 'it',
    'Камерун'                                                                                                 => 'cm',
    'Канада'                                                                                                   => 'ca',
    'Кариб'                                                                                                     => '029',
    'Колумбия'                                                                                               => 'co',
    'ЛатынАмерикасы'                                                                                   => 419,
    'Мексика'                                                                                                 => 'mx',
    'Меланезия'                                                                                             => '054',
    'Микронезиярегионы'                                                                             => '057',
    'Норвегия'                                                                                               => 'no',
    'Океания'                                                                                                 => '009',
    'ОрталықАзия'                                                                                         => 143,
    'ОрталықАмерика'                                                                                   => '013',
    'ОрталықАфрика'                                                                                     => '017',
    'ОңтүстікАзия'                                                                                       => '034',
    'ОңтүстікАмерика'                                                                                 => '005',
    'ОңтүстікАфрика'                                                                                   => '018',
    'ОңтүстікАфрикареспубликасы'                                                           => 'za',
    'ОңтүстікЕуропа'                                                                                   => '039',
    'ОңтүстікшығысАзия'                                                                             => '035',
    'Полинезия'                                                                                             => '061',
    'Польша'                                                                                                   => 'pl',
    'Португалия'                                                                                           => 'pt',
    'Ресей'                                                                                                     => 'ru',
    'СаудАрабиясы'                                                                                       => 'sa',
    'СолтүстікАмерика'                                                                               => '003',
    "СолтүстікАмерикаАҚШ\,Канада\,ГренландияжәнеБермударалдары" => '021',
    'СолтүстікАфрика'                                                                                 => '015',
    'СолтүстікЕуропа'                                                                                 => 154,
    'СолтүстікКорея'                                                                                   => 'kr',
    'Тайвань'                                                                                                 => 'tw',
    'Тайланд'                                                                                                 => 'th',
    'Тонга'                                                                                                     => 'to',
    'Түркия'                                                                                                   => 'tr',
    'Финляндия'                                                                                             => 'fi',
    'Франция'                                                                                                 => 'fr',
    'Чили'                                                                                                       => 'cl',
    'Швейцария'                                                                                             => 'ch',
    'Швеция'                                                                                                   => 'se',
    'ШығысАзия'                                                                                             => '030',
    'ШығысАфрика'                                                                                         => '014',
    'ШығысЕуропа'                                                                                         => 151,
    'Қазақстан'                                                                                             => 'kz',
    'Қытай'                                                                                                     => 'cn',
    'Ұлыбритания'                                                                                         => 'gb',
    'Әзербайжан'                                                                                           => 'az',
    'Әлем'                                                                                                       => '001',
);

1;

