
package ZCS::Admin::Elements::context;
use strict;
use warnings;

{ # BLOCK to scope variables

sub get_xmlns { 'urn:zimbra' }

__PACKAGE__->__set_name('context');
__PACKAGE__->__set_nillable();
__PACKAGE__->__set_minOccurs();
__PACKAGE__->__set_maxOccurs();
__PACKAGE__->__set_ref();
use base qw(
    SOAP::WSDL::XSD::Typelib::Element
    ZCS::Admin::Types::HeaderContext
);

}

1;


=pod

=head1 NAME

ZCS::Admin::Elements::context

=head1 DESCRIPTION

Perl data type class for the XML Schema defined element
context from the namespace urn:zimbra.







=head1 METHODS

=head2 new

 my $element = ZCS::Admin::Elements::context->new($data);

Constructor. The following data structure may be passed to new():

 { # ZCS::Admin::Types::HeaderContext
   authToken =>  $some_value, # string
   sessionId =>  { value => $some_value },
   account =>  { value => $some_value },
   change =>  { value => $some_value },
   targetServer =>  $some_value, # string
   userAgent =>  { value => $some_value },
 },

=head1 AUTHOR

Generated by SOAP::WSDL

=cut

