# Generated by default/object.tt
package Paws::Kendra::SeedUrlConfiguration;
  use Moose;
  has SeedUrls => (is => 'ro', isa => 'ArrayRef[Str|Undef]', required => 1);
  has WebCrawlerMode => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Kendra::SeedUrlConfiguration

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Kendra::SeedUrlConfiguration object:

  $service_obj->Method(Att1 => { SeedUrls => $value, ..., WebCrawlerMode => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Kendra::SeedUrlConfiguration object:

  $result = $service_obj->Method(...);
  $result->Att1->SeedUrls

=head1 DESCRIPTION

Provides the configuration information of the seed or starting point
URLs to crawl.

I<When selecting websites to index, you must adhere to the Amazon
Acceptable Use Policy (https://aws.amazon.com/aup/) and all other
Amazon terms. Remember that you must only use the Amazon Kendra web
crawler to index your own webpages, or webpages that you have
authorization to index.>

=head1 ATTRIBUTES


=head2 B<REQUIRED> SeedUrls => ArrayRef[Str|Undef]

The list of seed or starting point URLs of the websites you want to
crawl.

The list can include a maximum of 100 seed URLs.


=head2 WebCrawlerMode => Str

You can choose one of the following modes:

=over

=item *

C<HOST_ONLY> E<ndash> crawl only the website host names. For example,
if the seed URL is "abc.example.com", then only URLs with host name
"abc.example.com" are crawled.

=item *

C<SUBDOMAINS> E<ndash> crawl the website host names with subdomains.
For example, if the seed URL is "abc.example.com", then
"a.abc.example.com" and "b.abc.example.com" are also crawled.

=item *

C<EVERYTHING> E<ndash> crawl the website host names with subdomains and
other domains that the webpages link to.

=back

The default mode is set to C<HOST_ONLY>.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Kendra>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

