/*                                                                
**  Copyright (C) 2007,2010  Smithsonian Astrophysical Observatory 
*/                                                                

/*                                                                          */
/*  This program is free software; you can redistribute it and/or modify    */
/*  it under the terms of the GNU General Public License as published by    */
/*  the Free Software Foundation; either version 3 of the License, or       */
/*  (at your option) any later version.                                     */
/*                                                                          */
/*  This program is distributed in the hope that it will be useful,         */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/*  GNU General Public License for more details.                            */
/*                                                                          */
/*  You should have received a copy of the GNU General Public License along */
/*  with this program; if not, write to the Free Software Foundation, Inc., */
/*  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.             */
/*                                                                          */


#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "pfile.h"
#include "ptemplat.h"
#include "parameter.h"

#include "param_get_via_xpa.h"

char *
param_get_via_xpa (char *tool, char *value)
{

  char *retval;
  char buff[SZ_PFLINE];
  char cmd[SZ_PFLINE * 2];
  char *ss;
  FILE *pp;


  retval = (char *) calloc (SZ_PFLINE, sizeof (char));


  strcpy (cmd, XPAGET);
  strcat (cmd, tool);
  strcat (cmd, " ");

  /* VERY SPECIFIC */
  if (strcmp (value, "region") == 0)
    {
      strcat (cmd, "regions -format ciao");
    }
  else if ((strcmp (value, "ra") == 0) || (strcmp (value, "dec") == 0))
    {
      strcat (cmd, "crosshair fk5");
    }
  else if ((strcmp (value, "x") == 0) || (strcmp (value, "y") == 0))
    {
      strcat (cmd, "crosshair physical");
    }
  else if ((strcmp (value, "lx") == 0) || (strcmp (value, "ly") == 0))
    {
      strcat (cmd, "crosshair image");
    }


  else
    {
      strcat (cmd, value);
    }

  if ((pp = popen (cmd, "r")) == NULL)
    {
      parerr = PARBADINDIRECT;
      free (retval);
      return (NULL);
    }

  memset (buff, 0, SZ_PFLINE * sizeof (char));
  while ((ss = fgets (&buff[0], SZ_PFLINE, pp)))
    {
      char *ll;

      if (*ss == '#')
	continue;

      ll = strchr (ss, '\n');
      if (ll)
	*ll = '\0';

      /* Again, very specific stuff */
      if (strcmp (value, "region") == 0)
	{

	  if (*ss == '-')
	    {
	      if (strlen (retval) == 0)
		{
		  strcat (retval, "field()");
		}
	    }
	  else
	    {
	      if (strlen (retval) != 0)
		{
		  strcat (retval, "+");
		}
	    }

	  strcat (retval, buff);
	}
      else if ((strcmp (value, "x") == 0) ||
	       (strcmp (value, "ra") == 0) || (strcmp (value, "lx") == 0))

	{
	  char *lptr = strtok (ss, " ");
	  strcat (retval, lptr);
	}
      else if ((strcmp (value, "y") == 0) ||
	       (strcmp (value, "dec") == 0) || (strcmp (value, "ly") == 0))
	{
	  char *lptr = strtok (ss, " ");
	  lptr = strtok (NULL, " ");
	  strcat (retval, lptr);
	}
      else			/* Turn  \n's into spaces */
	{

	  strcat (retval, " ");
	  strcat (retval, buff);
	}


    }				/* end while */

  if (pp)
    pclose (pp);


  return (retval);


}
