# Generated by default/object.tt
package Paws::NetworkManager::Connection;
  use Moose;
  has ConnectedDeviceId => (is => 'ro', isa => 'Str');
  has ConnectedLinkId => (is => 'ro', isa => 'Str');
  has ConnectionArn => (is => 'ro', isa => 'Str');
  has ConnectionId => (is => 'ro', isa => 'Str');
  has CreatedAt => (is => 'ro', isa => 'Str');
  has Description => (is => 'ro', isa => 'Str');
  has DeviceId => (is => 'ro', isa => 'Str');
  has GlobalNetworkId => (is => 'ro', isa => 'Str');
  has LinkId => (is => 'ro', isa => 'Str');
  has State => (is => 'ro', isa => 'Str');
  has Tags => (is => 'ro', isa => 'ArrayRef[Paws::NetworkManager::Tag]');

1;

### main pod documentation begin ###

=head1 NAME

Paws::NetworkManager::Connection

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::NetworkManager::Connection object:

  $service_obj->Method(Att1 => { ConnectedDeviceId => $value, ..., Tags => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::NetworkManager::Connection object:

  $result = $service_obj->Method(...);
  $result->Att1->ConnectedDeviceId

=head1 DESCRIPTION

Describes a connection.

=head1 ATTRIBUTES


=head2 ConnectedDeviceId => Str

The ID of the second device in the connection.


=head2 ConnectedLinkId => Str

The ID of the link for the second device in the connection.


=head2 ConnectionArn => Str

The Amazon Resource Name (ARN) of the connection.


=head2 ConnectionId => Str

The ID of the connection.


=head2 CreatedAt => Str

The date and time that the connection was created.


=head2 Description => Str

The description of the connection.


=head2 DeviceId => Str

The ID of the first device in the connection.


=head2 GlobalNetworkId => Str

The ID of the global network.


=head2 LinkId => Str

The ID of the link for the first device in the connection.


=head2 State => Str

The state of the connection.


=head2 Tags => ArrayRef[L<Paws::NetworkManager::Tag>]

The tags for the connection.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::NetworkManager>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

