# Generated by default/object.tt
package Paws::ES::Duration;
  use Moose;
  has Unit => (is => 'ro', isa => 'Str');
  has Value => (is => 'ro', isa => 'Int');

1;

### main pod documentation begin ###

=head1 NAME

Paws::ES::Duration

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::ES::Duration object:

  $service_obj->Method(Att1 => { Unit => $value, ..., Value => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::ES::Duration object:

  $result = $service_obj->Method(...);
  $result->Att1->Unit

=head1 DESCRIPTION

Specifies maintenance schedule duration: duration value and duration
unit. See the Developer Guide
(https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/auto-tune.html)
for more information.

=head1 ATTRIBUTES


=head2 Unit => Str

Specifies the unit of a maintenance schedule duration. Valid value is
HOURS. See the Developer Guide
(https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/auto-tune.html)
for more information.


=head2 Value => Int

Integer to specify the value of a maintenance schedule duration. See
the Developer Guide
(https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/auto-tune.html)
for more information.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::ES>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

