/*
 * Decompiled with CFR 0.152.
 */
package gma;

import gma.AxisTick;
import gma.util.ByteInputFileHandler;
import gma.util.ByteParser;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;

public class BitextSpace {
    public static final String EOS_MARKER = "eosMarker";
    private static final String DOT = ".";
    private static final String AXIS_FILE_SUFFIX = "axisFileSuffix";
    private static final String DEFAULT_SUFFIX = "axis";
    public static final String X_STOP_WORD_FILE = "xStopWordFile";
    public static final String Y_STOP_WORD_FILE = "yStopWordFile";
    public boolean debug = false;
    private static final String X_AXIS_NORM = "xAxisNorm";
    private static final String Y_AXIS_NORM = "yAxisNorm";
    private static final boolean DEFAULT_NORM_MODE = false;
    private Properties properties = null;
    private List xAxisTicks = null;
    private List yAxisTicks = null;

    public BitextSpace(Properties properties) {
        this.properties = properties;
    }

    public void generateAxes() {
        String suffix = DEFAULT_SUFFIX;
        if (this.properties.containsKey(AXIS_FILE_SUFFIX)) {
            suffix = this.properties.getProperty(AXIS_FILE_SUFFIX);
        }
        this.xAxisTicks = this.generateAxis(suffix, "xAxisFile", X_STOP_WORD_FILE, X_AXIS_NORM);
        this.yAxisTicks = this.generateAxis(suffix, "yAxisFile", Y_STOP_WORD_FILE, Y_AXIS_NORM);
    }

    private List generateAxis(String suffix, String axisFileProperty, String stopWordProperty, String normProperty) {
        boolean needNormalization = false;
        if (this.properties.containsKey(normProperty)) {
            needNormalization = Boolean.valueOf(this.properties.getProperty(normProperty));
        }
        List stopWords = this.loadStopWordList(stopWordProperty);
        String axisFile = this.properties.getProperty(axisFileProperty);
        return this.doGenerateAxis(axisFile, suffix, needNormalization, stopWords);
    }

    private List loadStopWordList(String propertyName) {
        String stopWordFile = this.properties.getProperty(propertyName);
        ByteInputFileHandler input = new ByteInputFileHandler(stopWordFile);
        return input.readWordList();
    }

    private List doGenerateAxis(String axisFile, String axisFileSuffix, boolean needNormalization, List stopWords) {
        this.generateAxisFile(axisFile, axisFileSuffix);
        return this.generateAxisTicks(axisFile, needNormalization, stopWords);
    }

    private void generateAxisFile(String axisFile, String axisFileSuffix) {
        if (!axisFile.toLowerCase().endsWith(DOT + axisFileSuffix.toLowerCase())) {
            axisFile.concat(DOT).concat(axisFileSuffix.toLowerCase());
        }
    }

    private List generateAxisTicks(String axisFormatFile, boolean needNormalization, List stopWords) {
        LinkedList<AxisTick> axisTicks = new LinkedList<AxisTick>();
        int counter = -1;
        ByteInputFileHandler input = new ByteInputFileHandler(axisFormatFile);
        while (input.hasLine()) {
            ByteParser bParser;
            List line;
            ++counter;
            List arrayLine = input.nextLine();
            if (this.debug) {
                System.err.println("arrayLine " + arrayLine);
            }
            if ((line = (bParser = new ByteParser(arrayLine)).parseAxisLine()).size() != 2) {
                System.err.println("The input file is not in the axis format.");
                input.close();
                System.exit(1);
            }
            StringBuffer sb = new StringBuffer();
            Iterator li = ((List)line.get(0)).iterator();
            while (li.hasNext()) {
                sb.append((char)((Integer)li.next()).intValue());
            }
            String str = new String(sb);
            float position = Float.parseFloat(str);
            List word = (List)line.get(1);
            ByteParser wParser = new ByteParser(word);
            String wString = new String(wParser.listToString());
            if (wString.equals(this.properties.getProperty(EOS_MARKER)) || stopWords.contains(word)) continue;
            AxisTick axisTick = new AxisTick(counter, position, word);
            axisTicks.add(axisTick);
        }
        input.close();
        return axisTicks;
    }

    public void updateSlopeProperty() {
        if (this.properties.getProperty("slope") != null) {
            return;
        }
        double slope = (double)((AxisTick)this.yAxisTicks.get(this.yAxisTicks.size() - 1)).getPosition() / (double)((AxisTick)this.xAxisTicks.get(this.xAxisTicks.size() - 1)).getPosition();
        this.properties.put("slope", String.valueOf(slope));
    }

    public AxisTick getAxisTick(int index, boolean isXAxis) {
        if (isXAxis) {
            return (AxisTick)this.xAxisTicks.get(0);
        }
        return (AxisTick)this.yAxisTicks.get(0);
    }

    public Iterator getAxisIterator(AxisTick axisTick, boolean isXAxis, int offset) {
        if (isXAxis) {
            int maxXAxisIndex = this.xAxisTicks.indexOf(axisTick) + offset;
            return this.xAxisTicks.listIterator(maxXAxisIndex + 1);
        }
        int maxYAxisIndex = this.yAxisTicks.indexOf(axisTick) + offset;
        return this.yAxisTicks.listIterator(maxYAxisIndex + 1);
    }
}

