/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.authoring.tracks.h264;

import com.coremedia.iso.boxes.CompositionTimeToSample;
import com.coremedia.iso.boxes.SampleDependencyTypeBox;
import com.coremedia.iso.boxes.SampleDescriptionBox;
import com.coremedia.iso.boxes.sampleentry.VisualSampleEntry;
import com.googlecode.mp4parser.DataSource;
import com.googlecode.mp4parser.authoring.Sample;
import com.googlecode.mp4parser.authoring.tracks.AbstractH26XTrack;
import com.googlecode.mp4parser.authoring.tracks.h264.H264NalUnitHeader;
import com.googlecode.mp4parser.authoring.tracks.h264.SliceHeader;
import com.googlecode.mp4parser.h264.model.PictureParameterSet;
import com.googlecode.mp4parser.h264.model.SeqParameterSet;
import com.googlecode.mp4parser.h264.read.CAVLCReader;
import com.googlecode.mp4parser.util.Mp4Arrays;
import com.googlecode.mp4parser.util.RangeStartMap;
import com.mp4parser.iso14496.part15.AvcConfigurationBox;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class H264TrackImpl
extends AbstractH26XTrack {
    private static final Logger LOG = Logger.getLogger(H264TrackImpl.class.getName());
    Map<Integer, byte[]> spsIdToSpsBytes = new HashMap<Integer, byte[]>();
    Map<Integer, SeqParameterSet> spsIdToSps = new HashMap<Integer, SeqParameterSet>();
    Map<Integer, byte[]> ppsIdToPpsBytes = new HashMap<Integer, byte[]>();
    Map<Integer, PictureParameterSet> ppsIdToPps = new HashMap<Integer, PictureParameterSet>();
    SampleDescriptionBox sampleDescriptionBox;
    SeqParameterSet firstSeqParameterSet = null;
    PictureParameterSet firstPictureParameterSet = null;
    SeqParameterSet currentSeqParameterSet = null;
    PictureParameterSet currentPictureParameterSet = null;
    RangeStartMap<Integer, byte[]> seqParameterRangeMap = new RangeStartMap();
    RangeStartMap<Integer, byte[]> pictureParameterRangeMap = new RangeStartMap();
    int frameNrInGop = 0;
    int[] pictureOrderCounts = new int[0];
    int prevPicOrderCntLsb = 0;
    int prevPicOrderCntMsb = 0;
    private List<Sample> samples;
    private int width;
    private int height;
    private long timescale;
    private int frametick;
    private SEIMessage seiMessage;
    private boolean determineFrameRate = true;
    private String lang = "eng";

    public H264TrackImpl(DataSource dataSource, String lang, long timescale, int frametick) throws IOException {
        super(dataSource);
        this.lang = lang;
        this.timescale = timescale;
        this.frametick = frametick;
        if (timescale > 0L && frametick > 0) {
            this.determineFrameRate = false;
        }
        this.parse(new AbstractH26XTrack.LookAhead(dataSource));
    }

    public H264TrackImpl(DataSource dataSource, String lang) throws IOException {
        this(dataSource, lang, -1L, -1);
    }

    public H264TrackImpl(DataSource dataSource) throws IOException {
        this(dataSource, "eng");
    }

    public static H264NalUnitHeader getNalUnitHeader(ByteBuffer nal) {
        H264NalUnitHeader nalUnitHeader = new H264NalUnitHeader();
        byte type = nal.get(0);
        nalUnitHeader.nal_ref_idc = type >> 5 & 3;
        nalUnitHeader.nal_unit_type = type & 0x1F;
        return nalUnitHeader;
    }

    private void parse(AbstractH26XTrack.LookAhead la) throws IOException {
        this.samples = new ArrayList<Sample>();
        if (!this.readSamples(la)) {
            throw new IOException();
        }
        if (!this.readVariables()) {
            throw new IOException();
        }
        this.sampleDescriptionBox = new SampleDescriptionBox();
        VisualSampleEntry visualSampleEntry = new VisualSampleEntry("avc1");
        visualSampleEntry.setDataReferenceIndex(1);
        visualSampleEntry.setDepth(24);
        visualSampleEntry.setFrameCount(1);
        visualSampleEntry.setHorizresolution(72.0);
        visualSampleEntry.setVertresolution(72.0);
        visualSampleEntry.setWidth(this.width);
        visualSampleEntry.setHeight(this.height);
        visualSampleEntry.setCompressorname("AVC Coding");
        AvcConfigurationBox avcConfigurationBox = new AvcConfigurationBox();
        avcConfigurationBox.setSequenceParameterSets(new ArrayList<byte[]>(this.spsIdToSpsBytes.values()));
        avcConfigurationBox.setPictureParameterSets(new ArrayList<byte[]>(this.ppsIdToPpsBytes.values()));
        avcConfigurationBox.setAvcLevelIndication(this.firstSeqParameterSet.level_idc);
        avcConfigurationBox.setAvcProfileIndication(this.firstSeqParameterSet.profile_idc);
        avcConfigurationBox.setBitDepthLumaMinus8(this.firstSeqParameterSet.bit_depth_luma_minus8);
        avcConfigurationBox.setBitDepthChromaMinus8(this.firstSeqParameterSet.bit_depth_chroma_minus8);
        avcConfigurationBox.setChromaFormat(this.firstSeqParameterSet.chroma_format_idc.getId());
        avcConfigurationBox.setConfigurationVersion(1);
        avcConfigurationBox.setLengthSizeMinusOne(3);
        avcConfigurationBox.setProfileCompatibility((this.firstSeqParameterSet.constraint_set_0_flag ? 128 : 0) + (this.firstSeqParameterSet.constraint_set_1_flag ? 64 : 0) + (this.firstSeqParameterSet.constraint_set_2_flag ? 32 : 0) + (this.firstSeqParameterSet.constraint_set_3_flag ? 16 : 0) + (this.firstSeqParameterSet.constraint_set_4_flag ? 8 : 0) + (int)(this.firstSeqParameterSet.reserved_zero_2bits & 3L));
        visualSampleEntry.addBox(avcConfigurationBox);
        this.sampleDescriptionBox.addBox(visualSampleEntry);
        this.trackMetaData.setCreationTime(new Date());
        this.trackMetaData.setModificationTime(new Date());
        this.trackMetaData.setLanguage(this.lang);
        this.trackMetaData.setTimescale(this.timescale);
        this.trackMetaData.setWidth(this.width);
        this.trackMetaData.setHeight(this.height);
    }

    @Override
    public SampleDescriptionBox getSampleDescriptionBox() {
        return this.sampleDescriptionBox;
    }

    @Override
    public String getHandler() {
        return "vide";
    }

    @Override
    public List<Sample> getSamples() {
        return this.samples;
    }

    private boolean readVariables() {
        this.width = (this.firstSeqParameterSet.pic_width_in_mbs_minus1 + 1) * 16;
        int mult = 2;
        if (this.firstSeqParameterSet.frame_mbs_only_flag) {
            mult = 1;
        }
        this.height = 16 * (this.firstSeqParameterSet.pic_height_in_map_units_minus1 + 1) * mult;
        if (this.firstSeqParameterSet.frame_cropping_flag) {
            int chromaArrayType = 0;
            if (!this.firstSeqParameterSet.residual_color_transform_flag) {
                chromaArrayType = this.firstSeqParameterSet.chroma_format_idc.getId();
            }
            int cropUnitX = 1;
            int cropUnitY = mult;
            if (chromaArrayType != 0) {
                cropUnitX = this.firstSeqParameterSet.chroma_format_idc.getSubWidth();
                cropUnitY = this.firstSeqParameterSet.chroma_format_idc.getSubHeight() * mult;
            }
            this.width -= cropUnitX * (this.firstSeqParameterSet.frame_crop_left_offset + this.firstSeqParameterSet.frame_crop_right_offset);
            this.height -= cropUnitY * (this.firstSeqParameterSet.frame_crop_top_offset + this.firstSeqParameterSet.frame_crop_bottom_offset);
        }
        return true;
    }

    private boolean readSamples(AbstractH26XTrack.LookAhead la) throws IOException {
        ByteBuffer nal;
        ArrayList<ByteBuffer> buffered = new ArrayList<ByteBuffer>();
        class FirstVclNalDetector {
            int frame_num;
            int pic_parameter_set_id;
            boolean field_pic_flag;
            boolean bottom_field_flag;
            int nal_ref_idc;
            int pic_order_cnt_type;
            int delta_pic_order_cnt_bottom;
            int pic_order_cnt_lsb;
            int delta_pic_order_cnt_0;
            int delta_pic_order_cnt_1;
            boolean idrPicFlag;
            int idr_pic_id;

            public FirstVclNalDetector(ByteBuffer nal, int nal_ref_idc, int nal_unit_type) {
                InputStream bs = H264TrackImpl.cleanBuffer(new ByteBufferBackedInputStream(nal));
                SliceHeader sh = new SliceHeader(bs, H264TrackImpl.this.spsIdToSps, H264TrackImpl.this.ppsIdToPps, nal_unit_type == 5);
                this.frame_num = sh.frame_num;
                this.pic_parameter_set_id = sh.pic_parameter_set_id;
                this.field_pic_flag = sh.field_pic_flag;
                this.bottom_field_flag = sh.bottom_field_flag;
                this.nal_ref_idc = nal_ref_idc;
                this.pic_order_cnt_type = H264TrackImpl.this.spsIdToSps.get((Object)Integer.valueOf((int)H264TrackImpl.this.ppsIdToPps.get((Object)Integer.valueOf((int)sh.pic_parameter_set_id)).seq_parameter_set_id)).pic_order_cnt_type;
                this.delta_pic_order_cnt_bottom = sh.delta_pic_order_cnt_bottom;
                this.pic_order_cnt_lsb = sh.pic_order_cnt_lsb;
                this.delta_pic_order_cnt_0 = sh.delta_pic_order_cnt_0;
                this.delta_pic_order_cnt_1 = sh.delta_pic_order_cnt_1;
                this.idr_pic_id = sh.idr_pic_id;
            }

            boolean isFirstInNew(FirstVclNalDetector nu) {
                if (nu.frame_num != this.frame_num) {
                    return true;
                }
                if (nu.pic_parameter_set_id != this.pic_parameter_set_id) {
                    return true;
                }
                if (nu.field_pic_flag != this.field_pic_flag) {
                    return true;
                }
                if (nu.field_pic_flag && nu.bottom_field_flag != this.bottom_field_flag) {
                    return true;
                }
                if (nu.nal_ref_idc != this.nal_ref_idc) {
                    return true;
                }
                if (nu.pic_order_cnt_type == 0 && this.pic_order_cnt_type == 0) {
                    if (nu.pic_order_cnt_lsb != this.pic_order_cnt_lsb) {
                        return true;
                    }
                    if (nu.delta_pic_order_cnt_bottom != this.delta_pic_order_cnt_bottom) {
                        return true;
                    }
                }
                if (nu.pic_order_cnt_type == 1 && this.pic_order_cnt_type == 1) {
                    if (nu.delta_pic_order_cnt_0 != this.delta_pic_order_cnt_0) {
                        return true;
                    }
                    if (nu.delta_pic_order_cnt_1 != this.delta_pic_order_cnt_1) {
                        return true;
                    }
                }
                if (nu.idrPicFlag != this.idrPicFlag) {
                    return true;
                }
                return nu.idrPicFlag && this.idrPicFlag && nu.idr_pic_id != this.idr_pic_id;
            }
        }
        FirstVclNalDetector fvnd = null;
        block9: while ((nal = this.findNextNal(la)) != null) {
            H264NalUnitHeader nalUnitHeader = H264TrackImpl.getNalUnitHeader(nal);
            switch (nalUnitHeader.nal_unit_type) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    FirstVclNalDetector current = new FirstVclNalDetector(nal, nalUnitHeader.nal_ref_idc, nalUnitHeader.nal_unit_type);
                    if (fvnd != null && fvnd.isFirstInNew(current)) {
                        LOG.finer("Wrapping up cause of first vcl nal is found");
                        this.createSample(buffered);
                    }
                    fvnd = current;
                    buffered.add((ByteBuffer)nal.rewind());
                    break;
                }
                case 6: {
                    if (fvnd != null) {
                        LOG.finer("Wrapping up cause of SEI after vcl marks new sample");
                        this.createSample(buffered);
                        fvnd = null;
                    }
                    this.seiMessage = new SEIMessage(H264TrackImpl.cleanBuffer(new ByteBufferBackedInputStream(nal)), this.currentSeqParameterSet);
                    buffered.add(nal);
                    break;
                }
                case 9: {
                    if (fvnd != null) {
                        LOG.finer("Wrapping up cause of AU after vcl marks new sample");
                        this.createSample(buffered);
                        fvnd = null;
                    }
                    buffered.add(nal);
                    break;
                }
                case 7: {
                    if (fvnd != null) {
                        LOG.finer("Wrapping up cause of SPS after vcl marks new sample");
                        this.createSample(buffered);
                        fvnd = null;
                    }
                    this.handleSPS((ByteBuffer)nal.rewind());
                    break;
                }
                case 8: {
                    if (fvnd != null) {
                        LOG.finer("Wrapping up cause of PPS after vcl marks new sample");
                        this.createSample(buffered);
                        fvnd = null;
                    }
                    this.handlePPS((ByteBuffer)nal.rewind());
                    break;
                }
                case 10: 
                case 11: {
                    break block9;
                }
                case 13: {
                    throw new RuntimeException("Sequence parameter set extension is not yet handled. Needs TLC.");
                }
                default: {
                    LOG.warning("Unknown NAL unit type: " + nalUnitHeader.nal_unit_type);
                }
            }
        }
        if (buffered.size() > 0) {
            this.createSample(buffered);
        }
        this.calcCtts();
        this.decodingTimes = new long[this.samples.size()];
        Arrays.fill(this.decodingTimes, (long)this.frametick);
        return true;
    }

    public void calcCtts() {
        int pTime = 0;
        int lastPoc = -1;
        int j = 0;
        while (j < this.pictureOrderCounts.length) {
            int minIndex = 0;
            int minValue = Integer.MAX_VALUE;
            int i = Math.max(0, j - 128);
            while (i < Math.min(this.pictureOrderCounts.length, j + 128)) {
                if (this.pictureOrderCounts[i] > lastPoc && this.pictureOrderCounts[i] < minValue) {
                    minIndex = i;
                    minValue = this.pictureOrderCounts[i];
                }
                ++i;
            }
            lastPoc = this.pictureOrderCounts[minIndex];
            this.pictureOrderCounts[minIndex] = pTime++;
            ++j;
        }
        int i = 0;
        while (i < this.pictureOrderCounts.length) {
            this.ctts.add(new CompositionTimeToSample.Entry(1, this.pictureOrderCounts[i] - i));
            ++i;
        }
        this.pictureOrderCounts = new int[0];
    }

    private void createSample(List<ByteBuffer> buffered) throws IOException {
        SampleDependencyTypeBox.Entry sampleDependency = new SampleDependencyTypeBox.Entry(0);
        boolean IdrPicFlag = false;
        H264NalUnitHeader nu = null;
        for (ByteBuffer nal : buffered) {
            H264NalUnitHeader _nu = H264TrackImpl.getNalUnitHeader(nal);
            switch (_nu.nal_unit_type) {
                case 5: {
                    IdrPicFlag = true;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    nu = _nu;
                }
            }
        }
        if (nu == null) {
            LOG.warning("Sample without Slice");
            return;
        }
        if (IdrPicFlag) {
            this.calcCtts();
        }
        InputStream bs = H264TrackImpl.cleanBuffer(new ByteBufferBackedInputStream(buffered.get(buffered.size() - 1)));
        SliceHeader sh = new SliceHeader(bs, this.spsIdToSps, this.ppsIdToPps, IdrPicFlag);
        if (nu.nal_ref_idc == 0) {
            sampleDependency.setSampleIsDependentOn(2);
        } else {
            sampleDependency.setSampleIsDependentOn(1);
        }
        if (sh.slice_type == SliceHeader.SliceType.I || sh.slice_type == SliceHeader.SliceType.SI) {
            sampleDependency.setSampleDependsOn(2);
        } else {
            sampleDependency.setSampleDependsOn(1);
        }
        Sample bb = this.createSampleObject(buffered);
        buffered.clear();
        if (this.seiMessage == null || this.seiMessage.n_frames == 0) {
            this.frameNrInGop = 0;
        }
        if (sh.sps.pic_order_cnt_type == 0) {
            int max_pic_order_count_lsb = 1 << sh.sps.log2_max_pic_order_cnt_lsb_minus4 + 4;
            int picOrderCountLsb = sh.pic_order_cnt_lsb;
            int picOrderCntMsb = 0;
            picOrderCntMsb = picOrderCountLsb < this.prevPicOrderCntLsb && this.prevPicOrderCntLsb - picOrderCountLsb >= max_pic_order_count_lsb / 2 ? this.prevPicOrderCntMsb + max_pic_order_count_lsb : (picOrderCountLsb > this.prevPicOrderCntLsb && picOrderCountLsb - this.prevPicOrderCntLsb > max_pic_order_count_lsb / 2 ? this.prevPicOrderCntMsb - max_pic_order_count_lsb : this.prevPicOrderCntMsb);
            this.pictureOrderCounts = Mp4Arrays.copyOfAndAppend(this.pictureOrderCounts, picOrderCntMsb + picOrderCountLsb);
            this.prevPicOrderCntLsb = picOrderCountLsb;
            this.prevPicOrderCntMsb = picOrderCntMsb;
        } else {
            if (sh.sps.pic_order_cnt_type == 1) {
                throw new RuntimeException("pic_order_cnt_type == 1 needs to be implemented");
            }
            if (sh.sps.pic_order_cnt_type == 2) {
                this.pictureOrderCounts = Mp4Arrays.copyOfAndAppend(this.pictureOrderCounts, this.samples.size());
            }
        }
        this.sdtp.add(sampleDependency);
        ++this.frameNrInGop;
        this.samples.add(bb);
        if (IdrPicFlag) {
            this.stss.add(this.samples.size());
        }
    }

    private int calcPoc(int absFrameNum, H264NalUnitHeader nu, SliceHeader sh) {
        if (sh.sps.pic_order_cnt_type == 0) {
            return this.calcPOC0(nu, sh);
        }
        if (sh.sps.pic_order_cnt_type == 1) {
            return this.calcPOC1(absFrameNum, nu, sh);
        }
        return this.calcPOC2(absFrameNum, nu, sh);
    }

    private int calcPOC2(int absFrameNum, H264NalUnitHeader nu, SliceHeader sh) {
        if (nu.nal_ref_idc == 0) {
            return 2 * absFrameNum - 1;
        }
        return 2 * absFrameNum;
    }

    private int calcPOC1(int absFrameNum, H264NalUnitHeader nu, SliceHeader sh) {
        int expectedPicOrderCnt;
        if (sh.sps.num_ref_frames_in_pic_order_cnt_cycle == 0) {
            absFrameNum = 0;
        }
        if (nu.nal_ref_idc == 0 && absFrameNum > 0) {
            --absFrameNum;
        }
        int expectedDeltaPerPicOrderCntCycle = 0;
        int i = 0;
        while (i < sh.sps.num_ref_frames_in_pic_order_cnt_cycle) {
            expectedDeltaPerPicOrderCntCycle += sh.sps.offsetForRefFrame[i];
            ++i;
        }
        if (absFrameNum > 0) {
            int picOrderCntCycleCnt = (absFrameNum - 1) / sh.sps.num_ref_frames_in_pic_order_cnt_cycle;
            int frameNumInPicOrderCntCycle = (absFrameNum - 1) % sh.sps.num_ref_frames_in_pic_order_cnt_cycle;
            expectedPicOrderCnt = picOrderCntCycleCnt * expectedDeltaPerPicOrderCntCycle;
            int i2 = 0;
            while (i2 <= frameNumInPicOrderCntCycle) {
                expectedPicOrderCnt += sh.sps.offsetForRefFrame[i2];
                ++i2;
            }
        } else {
            expectedPicOrderCnt = 0;
        }
        if (nu.nal_ref_idc == 0) {
            expectedPicOrderCnt += sh.sps.offset_for_non_ref_pic;
        }
        return expectedPicOrderCnt + sh.delta_pic_order_cnt_0;
    }

    private int calcPOC0(H264NalUnitHeader nu, SliceHeader sh) {
        int pocCntLsb = sh.pic_order_cnt_lsb;
        int maxPicOrderCntLsb = 1 << sh.sps.log2_max_pic_order_cnt_lsb_minus4 + 4;
        int picOrderCntMsb = pocCntLsb < this.prevPicOrderCntLsb && this.prevPicOrderCntLsb - pocCntLsb >= maxPicOrderCntLsb / 2 ? this.prevPicOrderCntMsb + maxPicOrderCntLsb : (pocCntLsb > this.prevPicOrderCntLsb && pocCntLsb - this.prevPicOrderCntLsb > maxPicOrderCntLsb / 2 ? this.prevPicOrderCntMsb - maxPicOrderCntLsb : this.prevPicOrderCntMsb);
        if (nu.nal_ref_idc != 0) {
            this.prevPicOrderCntMsb = picOrderCntMsb;
            this.prevPicOrderCntLsb = pocCntLsb;
        }
        return picOrderCntMsb + pocCntLsb;
    }

    private void handlePPS(ByteBuffer data) throws IOException {
        ByteBufferBackedInputStream is = new ByteBufferBackedInputStream(data);
        ((InputStream)is).read();
        PictureParameterSet _pictureParameterSet = PictureParameterSet.read(is);
        if (this.firstPictureParameterSet == null) {
            this.firstPictureParameterSet = _pictureParameterSet;
        }
        this.currentPictureParameterSet = _pictureParameterSet;
        byte[] ppsBytes = H264TrackImpl.toArray((ByteBuffer)data.rewind());
        byte[] oldPpsSameId = this.ppsIdToPpsBytes.get(_pictureParameterSet.pic_parameter_set_id);
        if (oldPpsSameId != null && !Arrays.equals(oldPpsSameId, ppsBytes)) {
            throw new RuntimeException("OMG - I got two SPS with same ID but different settings! (AVC3 is the solution)");
        }
        if (oldPpsSameId == null) {
            this.pictureParameterRangeMap.put(this.samples.size(), ppsBytes);
        }
        this.ppsIdToPpsBytes.put(_pictureParameterSet.pic_parameter_set_id, ppsBytes);
        this.ppsIdToPps.put(_pictureParameterSet.pic_parameter_set_id, _pictureParameterSet);
    }

    private void handleSPS(ByteBuffer data) throws IOException {
        InputStream spsInputStream = H264TrackImpl.cleanBuffer(new ByteBufferBackedInputStream(data));
        spsInputStream.read();
        SeqParameterSet _seqParameterSet = SeqParameterSet.read(spsInputStream);
        if (this.firstSeqParameterSet == null) {
            this.firstSeqParameterSet = _seqParameterSet;
            this.configureFramerate();
        }
        this.currentSeqParameterSet = _seqParameterSet;
        byte[] spsBytes = H264TrackImpl.toArray((ByteBuffer)data.rewind());
        byte[] oldSpsSameId = this.spsIdToSpsBytes.get(_seqParameterSet.seq_parameter_set_id);
        if (oldSpsSameId != null && !Arrays.equals(oldSpsSameId, spsBytes)) {
            throw new RuntimeException("OMG - I got two SPS with same ID but different settings!");
        }
        if (oldSpsSameId != null) {
            this.seqParameterRangeMap.put(this.samples.size(), spsBytes);
        }
        this.spsIdToSpsBytes.put(_seqParameterSet.seq_parameter_set_id, spsBytes);
        this.spsIdToSps.put(_seqParameterSet.seq_parameter_set_id, _seqParameterSet);
    }

    private void configureFramerate() {
        if (this.determineFrameRate) {
            if (this.firstSeqParameterSet.vuiParams != null) {
                this.timescale = this.firstSeqParameterSet.vuiParams.time_scale >> 1;
                this.frametick = this.firstSeqParameterSet.vuiParams.num_units_in_tick;
                if (this.timescale == 0L || this.frametick == 0) {
                    LOG.warning("vuiParams contain invalid values: time_scale: " + this.timescale + " and frame_tick: " + this.frametick + ". Setting frame rate to 25fps");
                    this.timescale = 90000L;
                    this.frametick = 3600;
                }
                if (this.timescale / (long)this.frametick > 100L) {
                    LOG.warning("Framerate is " + this.timescale / (long)this.frametick + ". That is suspicious.");
                }
            } else {
                LOG.warning("Can't determine frame rate. Guessing 25 fps");
                this.timescale = 90000L;
                this.frametick = 3600;
            }
        }
    }

    public class ByteBufferBackedInputStream
    extends InputStream {
        private final ByteBuffer buf;

        public ByteBufferBackedInputStream(ByteBuffer buf) {
            this.buf = buf.duplicate();
        }

        public int read() throws IOException {
            if (!this.buf.hasRemaining()) {
                return -1;
            }
            return this.buf.get() & 0xFF;
        }

        public int read(byte[] bytes, int off, int len) throws IOException {
            if (!this.buf.hasRemaining()) {
                return -1;
            }
            len = Math.min(len, this.buf.remaining());
            this.buf.get(bytes, off, len);
            return len;
        }
    }

    public class SEIMessage {
        int payloadType = 0;
        int payloadSize = 0;
        boolean removal_delay_flag;
        int cpb_removal_delay;
        int dpb_removal_delay;
        boolean clock_timestamp_flag;
        int pic_struct;
        int ct_type;
        int nuit_field_based_flag;
        int counting_type;
        int full_timestamp_flag;
        int discontinuity_flag;
        int cnt_dropped_flag;
        int n_frames;
        int seconds_value;
        int minutes_value;
        int hours_value;
        int time_offset_length;
        int time_offset;
        SeqParameterSet sps;

        public SEIMessage(InputStream is, SeqParameterSet sps) throws IOException {
            this.sps = sps;
            is.read();
            int datasize = is.available();
            int read = 0;
            while (read < datasize) {
                this.payloadType = 0;
                this.payloadSize = 0;
                int last_payload_type_bytes = is.read();
                ++read;
                while (last_payload_type_bytes == 255) {
                    this.payloadType += last_payload_type_bytes;
                    last_payload_type_bytes = is.read();
                    ++read;
                }
                this.payloadType += last_payload_type_bytes;
                int last_payload_size_bytes = is.read();
                ++read;
                while (last_payload_size_bytes == 255) {
                    this.payloadSize += last_payload_size_bytes;
                    last_payload_size_bytes = is.read();
                    ++read;
                }
                this.payloadSize += last_payload_size_bytes;
                if (datasize - read >= this.payloadSize) {
                    if (this.payloadType == 1) {
                        if (sps.vuiParams != null && (sps.vuiParams.nalHRDParams != null || sps.vuiParams.vclHRDParams != null || sps.vuiParams.pic_struct_present_flag)) {
                            byte[] data = new byte[this.payloadSize];
                            is.read(data);
                            read += this.payloadSize;
                            CAVLCReader reader = new CAVLCReader(new ByteArrayInputStream(data));
                            if (sps.vuiParams.nalHRDParams != null || sps.vuiParams.vclHRDParams != null) {
                                this.removal_delay_flag = true;
                                this.cpb_removal_delay = reader.readU(sps.vuiParams.nalHRDParams.cpb_removal_delay_length_minus1 + 1, "SEI: cpb_removal_delay");
                                this.dpb_removal_delay = reader.readU(sps.vuiParams.nalHRDParams.dpb_output_delay_length_minus1 + 1, "SEI: dpb_removal_delay");
                            } else {
                                this.removal_delay_flag = false;
                            }
                            if (sps.vuiParams.pic_struct_present_flag) {
                                int numClockTS;
                                this.pic_struct = reader.readU(4, "SEI: pic_struct");
                                switch (this.pic_struct) {
                                    default: {
                                        numClockTS = 1;
                                        break;
                                    }
                                    case 3: 
                                    case 4: 
                                    case 7: {
                                        numClockTS = 2;
                                        break;
                                    }
                                    case 5: 
                                    case 6: 
                                    case 8: {
                                        numClockTS = 3;
                                    }
                                }
                                int i = 0;
                                while (i < numClockTS) {
                                    this.clock_timestamp_flag = reader.readBool("pic_timing SEI: clock_timestamp_flag[" + i + "]");
                                    if (this.clock_timestamp_flag) {
                                        this.ct_type = reader.readU(2, "pic_timing SEI: ct_type");
                                        this.nuit_field_based_flag = reader.readU(1, "pic_timing SEI: nuit_field_based_flag");
                                        this.counting_type = reader.readU(5, "pic_timing SEI: counting_type");
                                        this.full_timestamp_flag = reader.readU(1, "pic_timing SEI: full_timestamp_flag");
                                        this.discontinuity_flag = reader.readU(1, "pic_timing SEI: discontinuity_flag");
                                        this.cnt_dropped_flag = reader.readU(1, "pic_timing SEI: cnt_dropped_flag");
                                        this.n_frames = reader.readU(8, "pic_timing SEI: n_frames");
                                        if (this.full_timestamp_flag == 1) {
                                            this.seconds_value = reader.readU(6, "pic_timing SEI: seconds_value");
                                            this.minutes_value = reader.readU(6, "pic_timing SEI: minutes_value");
                                            this.hours_value = reader.readU(5, "pic_timing SEI: hours_value");
                                        } else if (reader.readBool("pic_timing SEI: seconds_flag")) {
                                            this.seconds_value = reader.readU(6, "pic_timing SEI: seconds_value");
                                            if (reader.readBool("pic_timing SEI: minutes_flag")) {
                                                this.minutes_value = reader.readU(6, "pic_timing SEI: minutes_value");
                                                if (reader.readBool("pic_timing SEI: hours_flag")) {
                                                    this.hours_value = reader.readU(5, "pic_timing SEI: hours_value");
                                                }
                                            }
                                        }
                                        this.time_offset_length = sps.vuiParams.nalHRDParams != null ? sps.vuiParams.nalHRDParams.time_offset_length : (sps.vuiParams.vclHRDParams != null ? sps.vuiParams.vclHRDParams.time_offset_length : 24);
                                        this.time_offset = reader.readU(24, "pic_timing SEI: time_offset");
                                    }
                                    ++i;
                                }
                            }
                        } else {
                            int i = 0;
                            while (i < this.payloadSize) {
                                is.read();
                                ++read;
                                ++i;
                            }
                        }
                    } else {
                        int i = 0;
                        while (i < this.payloadSize) {
                            is.read();
                            ++read;
                            ++i;
                        }
                    }
                } else {
                    read = datasize;
                }
                LOG.fine(this.toString());
            }
        }

        public String toString() {
            String out = "SEIMessage{payloadType=" + this.payloadType + ", payloadSize=" + this.payloadSize;
            if (this.payloadType == 1) {
                if (this.sps.vuiParams.nalHRDParams != null || this.sps.vuiParams.vclHRDParams != null) {
                    out = String.valueOf(out) + ", cpb_removal_delay=" + this.cpb_removal_delay + ", dpb_removal_delay=" + this.dpb_removal_delay;
                }
                if (this.sps.vuiParams.pic_struct_present_flag) {
                    out = String.valueOf(out) + ", pic_struct=" + this.pic_struct;
                    if (this.clock_timestamp_flag) {
                        out = String.valueOf(out) + ", ct_type=" + this.ct_type + ", nuit_field_based_flag=" + this.nuit_field_based_flag + ", counting_type=" + this.counting_type + ", full_timestamp_flag=" + this.full_timestamp_flag + ", discontinuity_flag=" + this.discontinuity_flag + ", cnt_dropped_flag=" + this.cnt_dropped_flag + ", n_frames=" + this.n_frames + ", seconds_value=" + this.seconds_value + ", minutes_value=" + this.minutes_value + ", hours_value=" + this.hours_value + ", time_offset_length=" + this.time_offset_length + ", time_offset=" + this.time_offset;
                    }
                }
            }
            out = String.valueOf(out) + '}';
            return out;
        }
    }
}

