/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ncml;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.Verifier;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import thredds.catalog.XMLEntityResolver;
import ucar.ma2.Array;
import ucar.ma2.ArrayChar;
import ucar.ma2.DataType;
import ucar.ma2.IndexIterator;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.Variable;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.CoordinateTransform;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VariableDS;
import ucar.unidata.util.Parameter;

public class NcMLGWriter {
    protected static final Namespace ncNS = Namespace.getNamespace("http://www.ucar.edu/schemas/netcdf");
    protected static final String schemaLocation = "http://www.unidata.ucar.edu/schemas/netcdf-cs.xsd";

    public void writeXML(NetcdfDataset ncd, OutputStream os, boolean showCoords, String uri) throws IOException {
        XMLOutputter fmt = new XMLOutputter(Format.getPrettyFormat());
        fmt.output(this.makeDocument(ncd, showCoords, uri), os);
    }

    Document makeDocument(NetcdfDataset ncd, boolean showCoords, String uri) {
        Element rootElem = new Element("netcdf", ncNS);
        Document doc = new Document(rootElem);
        rootElem.addNamespaceDeclaration(ncNS);
        rootElem.addNamespaceDeclaration(XMLEntityResolver.xsiNS);
        rootElem.setAttribute("schemaLocation", ncNS.getURI() + " " + schemaLocation, XMLEntityResolver.xsiNS);
        if (null != ncd.getId()) {
            rootElem.setAttribute("id", ncd.getId());
        }
        if (null != uri) {
            rootElem.setAttribute("uri", uri);
        } else {
            rootElem.setAttribute("uri", ncd.getLocation());
        }
        for (Dimension dim : ncd.getDimensions()) {
            rootElem.addContent(this.makeDim(dim));
        }
        for (Attribute att : ncd.getGlobalAttributes()) {
            rootElem.addContent(this.makeAttribute(att, "attribute"));
        }
        for (Variable var : ncd.getVariables()) {
            if (!(var instanceof CoordinateAxis)) continue;
            rootElem.addContent(this.makeCoordinateAxis((CoordinateAxis)var, showCoords));
        }
        for (Variable var : ncd.getVariables()) {
            if (var instanceof CoordinateAxis) continue;
            rootElem.addContent(this.makeVariable((VariableDS)var));
        }
        for (CoordinateSystem cs : ncd.getCoordinateSystems()) {
            rootElem.addContent(this.makeCoordSys(cs));
        }
        ArrayList<CoordinateTransform> coordTrans = new ArrayList<CoordinateTransform>();
        for (CoordinateSystem cs : ncd.getCoordinateSystems()) {
            List<CoordinateTransform> ctList = cs.getCoordinateTransforms();
            if (ctList == null) continue;
            for (CoordinateTransform ct : ctList) {
                if (coordTrans.contains(ct)) continue;
                coordTrans.add(ct);
            }
        }
        for (CoordinateTransform coordTran : coordTrans) {
            rootElem.addContent(this.makeCoordTransform(coordTran));
        }
        return doc;
    }

    private Element makeAttribute(Attribute att, String elementName) {
        Element attElem = new Element(elementName, ncNS);
        attElem.setAttribute("name", att.getName());
        DataType dt = att.getDataType();
        if (dt != null) {
            attElem.setAttribute("type", dt.toString());
        }
        if (att.isString()) {
            String value = att.getStringValue();
            String err = Verifier.checkCharacterData(value);
            if (err != null) {
                value = "NcMLWriter invalid attribute value, err= " + err;
                System.out.println(value);
            }
            attElem.setAttribute("value", value);
        } else {
            StringBuffer buff = new StringBuffer();
            for (int i = 0; i < att.getLength(); ++i) {
                Number val = att.getNumericValue(i);
                if (i > 0) {
                    buff.append(" ");
                }
                buff.append(val.toString());
            }
            attElem.setAttribute("value", buff.toString());
        }
        return attElem;
    }

    private Element makeAttribute(Parameter att, String elementName) {
        Element attElem = new Element(elementName, ncNS);
        attElem.setAttribute("name", att.getName());
        if (att.isString()) {
            String value = att.getStringValue();
            String err = Verifier.checkCharacterData(value);
            if (err != null) {
                value = "NcMLWriter invalid attribute value, err= " + err;
                System.out.println(value);
            }
            attElem.setAttribute("value", value);
        } else {
            attElem.setAttribute("type", "double");
            StringBuffer buff = new StringBuffer();
            for (int i = 0; i < att.getLength(); ++i) {
                double val = att.getNumericValue(i);
                if (i > 0) {
                    buff.append(" ");
                }
                buff.append(Double.toString(val));
            }
            attElem.setAttribute("value", buff.toString());
        }
        return attElem;
    }

    private Element makeCoordinateAxis(CoordinateAxis var, boolean showCoords) {
        List<CoordinateSystem> csys;
        String boundaryRef;
        String positive;
        Element varElem = new Element("coordinateAxis", ncNS);
        varElem.setAttribute("name", var.getName());
        StringBuffer buff = new StringBuffer();
        List<Dimension> dims = var.getDimensions();
        for (int i = 0; i < dims.size(); ++i) {
            Dimension dim = dims.get(i);
            if (i > 0) {
                buff.append(" ");
            }
            buff.append(dim.getName());
        }
        if (buff.length() > 0) {
            varElem.setAttribute("shape", buff.toString());
        }
        DataType dt = var.getDataType();
        varElem.setAttribute("type", dt.toString());
        for (Attribute att : var.getAttributes()) {
            varElem.addContent(this.makeAttribute(att, "attribute"));
        }
        if (var.isMetadata() || showCoords && var.getRank() <= 1) {
            varElem.addContent(this.makeValues(var));
        }
        varElem.setAttribute("units", var.getUnitsString());
        if (var.getAxisType() != null) {
            varElem.setAttribute("axisType", var.getAxisType().toString());
        }
        if ((positive = var.getPositive()) != null) {
            varElem.setAttribute("positive", positive);
        }
        if ((boundaryRef = var.getBoundaryRef()) != null) {
            varElem.setAttribute("boundaryRef", boundaryRef);
        }
        if ((csys = var.getCoordinateSystems()).size() > 0) {
            buff.setLength(0);
            for (int i = 0; i < csys.size(); ++i) {
                CoordinateSystem cs = csys.get(i);
                if (i > 0) {
                    buff.append(" ");
                }
                buff.append(cs.getName());
            }
            varElem.setAttribute("coordinateSystems", buff.toString());
        }
        return varElem;
    }

    private Element makeCoordSys(CoordinateSystem cs) {
        Element csElem = new Element("coordinateSystem", ncNS);
        csElem.setAttribute("name", cs.getName());
        for (CoordinateAxis axis : cs.getCoordinateAxes()) {
            Element axisElem = new Element("coordinateAxisRef", ncNS);
            axisElem.setAttribute("ref", axis.getName());
            csElem.addContent(axisElem);
        }
        List<CoordinateTransform> transforms = cs.getCoordinateTransforms();
        if (transforms != null) {
            for (CoordinateTransform ct : transforms) {
                if (ct == null) continue;
                Element tElem = new Element("coordinateTransformRef", ncNS);
                tElem.setAttribute("ref", ct.getName());
                csElem.addContent(tElem);
            }
        }
        return csElem;
    }

    private Element makeCoordTransform(CoordinateTransform coordTransform) {
        Element elem = new Element("coordinateTransform", ncNS);
        elem.setAttribute("name", coordTransform.getName());
        elem.setAttribute("authority", coordTransform.getAuthority());
        if (coordTransform.getTransformType() != null) {
            elem.setAttribute("transformType", coordTransform.getTransformType().toString());
        }
        List<Parameter> params = coordTransform.getParameters();
        for (Parameter p : params) {
            elem.addContent(this.makeAttribute(p, "parameter"));
        }
        return elem;
    }

    private Element makeDim(Dimension dim) {
        Element dimElem = new Element("dimension", ncNS);
        dimElem.setAttribute("name", dim.getName());
        dimElem.setAttribute("length", Integer.toString(dim.getLength()));
        if (dim.isUnlimited()) {
            dimElem.setAttribute("isUnlimited", "true");
        }
        return dimElem;
    }

    private Element makeVariable(VariableDS var) {
        List<CoordinateSystem> csys;
        DataType dt;
        Element varElem = new Element("variable", ncNS);
        varElem.setAttribute("name", var.getName());
        StringBuffer buff = new StringBuffer();
        List<Dimension> dims = var.getDimensions();
        for (int i = 0; i < dims.size(); ++i) {
            Dimension dim = dims.get(i);
            if (i > 0) {
                buff.append(" ");
            }
            buff.append(dim.getName());
        }
        if (buff.length() > 0) {
            varElem.setAttribute("shape", buff.toString());
        }
        if ((dt = var.getDataType()) != null) {
            varElem.setAttribute("type", dt.toString());
        }
        for (Attribute att : var.getAttributes()) {
            varElem.addContent(this.makeAttribute(att, "attribute"));
        }
        if (var.isMetadata()) {
            varElem.addContent(this.makeValues(var));
        }
        if ((csys = var.getCoordinateSystems()).size() > 0) {
            buff.setLength(0);
            for (int i = 0; i < csys.size(); ++i) {
                CoordinateSystem cs = csys.get(i);
                if (i > 0) {
                    buff.append(" ");
                }
                buff.append(cs.getName());
            }
            varElem.setAttribute("coordinateSystems", buff.toString());
        }
        return varElem;
    }

    private Element makeValues(VariableDS v) {
        Array a;
        Element elem = new Element("values", ncNS);
        StringBuffer buff = new StringBuffer();
        try {
            a = v.read();
        }
        catch (IOException ioe) {
            return elem;
        }
        if (a instanceof ArrayChar) {
            ArrayChar dataC = (ArrayChar)a;
            for (int i = 0; i < dataC.getShape()[0]; ++i) {
                if (i > 0) {
                    buff.append(" ");
                }
                buff.append("\"").append(dataC.getString(i)).append("\"");
            }
            elem.setText(buff.toString());
        } else if (v instanceof CoordinateAxis1D && ((CoordinateAxis1D)v).isRegular()) {
            CoordinateAxis1D axis = (CoordinateAxis1D)v;
            elem.setAttribute("start", Double.toString(axis.getStart()));
            elem.setAttribute("increment", Double.toString(axis.getIncrement()));
            elem.setAttribute("npts", Long.toString(v.getSize()));
        } else {
            boolean isDouble = v.getDataType() == DataType.DOUBLE;
            boolean isFloat = v.getDataType() == DataType.FLOAT;
            IndexIterator iter = a.getIndexIterator();
            while (iter.hasNext()) {
                if (isDouble) {
                    buff.append(iter.getDoubleNext());
                } else if (isFloat) {
                    buff.append(iter.getFloatNext());
                } else {
                    buff.append(iter.getIntNext());
                }
                buff.append(" ");
            }
            elem.setText(buff.toString());
        }
        return elem;
    }

    public static void main(String[] arg) {
        String urls = "C:/data/galeon/RUC.nc";
        try {
            NetcdfDataset df = NetcdfDataset.openDataset(urls);
            NcMLGWriter ncFactory = new NcMLGWriter();
            System.out.println("NetcdfDataset = " + urls + "\n" + df);
            System.out.println("-----------");
            ncFactory.writeXML(df, System.out, true, null);
        }
        catch (Exception ioe) {
            System.out.println("error = " + urls);
            ioe.printStackTrace();
        }
    }
}

