#!/usr/bin/perl

$mregex = q/(?:aj|emb)/;

$Debug = 0;

while (<>) {
    # --- lines starting with "aj.." or "emb..." ?
    next unless /^($mregex\w+).*\(.*\)/o;

    $method = $1;

    # --- only once
    unless ( $m_hash{ $method } ) {
	push (@methods, $method);
	$m_hash{ $method } = 1;
    }


    # --- the following line starts with "AjP..." ?
    $_ = <>;
    next unless /^\s*(?:const +)?AjP(\w+)/;

    $class = $1;

    # --- only once if method and class are identical
    #     but add method to additional class if classes differ (and warn?)
    if ( ref $m_hash{ $method } ) { # --- already found a class for $method
	my $cl;
	my $go_next = 1;
	# --- test if method has links to different classes
	foreach $cl ( @{$m_hash{ $method }} ) {
	    if ($cl ne $class) {
		push @{$m_hash{ $method }}, $class;
		$go_next = 0;

		if ($Debug) {
		    warn "method $method for those classes: " .
			join (", ", @{$m_hash{ $method }}) . "\n";
		}
	    }
	}
	next if $go_next;
    } else {
	$m_hash{ $method } = [ $class ];
    }
    push @{ $all{$class} }, $method;
}

$thistime = gmtime();
print <<EOF;
package Bio::Emboss::Methods;

# automatically generated by $0 on $thistime

# This file defines the methods that are available for certain classes
# (i.e. certain EMBOSS types "AjP...")
#
# If an EMBOSS library function has an AjP... type as a first parameter,
# this function can be used as a method on that data type.
#
# This information is extracted from .xs files by "$0"
#
# Bio::Emboss.pm can EXPORT several functions on request into the callers
# namespace. Lists of functions are created for some EXPORT tags.


EOF

# --- make aliases in the symbol table

foreach $class (sort keys %all) {
    print "package Bio::Emboss::$class;\n";

    my $arr = $all{$class};

    foreach $method (@$arr) {
	# --- do some formatting (assume tablen == 8)
	my $len = length($method) + 1;
	my $ntabs = int((39 - $len) / 8); # 39 == (5 * 8) - 1
	my $tabs = "\t" x $ntabs;
	print <<EOF;
*$method$tabs = *Bio::Emboss::$method;
EOF
    }
    print "\n";
}

print <<EOF;
# --- list all methods of EMBOSS for the EXPORT :all tag

package Bio::Emboss::Methods;

\@ALL_METHODS = qw(
EOF


foreach $method (@methods){
    print "\t", $method, "\n";
}


print <<EOF;
\t);

# --- list ajAcdGet... methods of EMBOSS for the EXPORT :acd tag

\@ACD_METHODS = qw(
EOF



foreach $method (@methods){
    next unless $method =~ /^ajAcdGet/;

    print "\t", $method, "\n";
}

print <<EOF;
\t);

1;
EOF
