/*
 * Decompiled with CFR 0.152.
 */
package com.javonet.core.protocol;

import com.javonet.core.protocol.TypeSerializer;
import com.javonet.utils.Command;
import com.javonet.utils.RuntimeName;
import com.javonet.utils.connectiondata.IConnectionData;
import java.util.Arrays;

public class CommandSerializer {
    private byte[] buffer;

    public byte[] serialize(Command rootCommand, IConnectionData connectionData) {
        this.buffer = new byte[2];
        this.buffer[0] = (byte)rootCommand.getRuntimeName().ordinal();
        this.buffer[1] = 0;
        if (connectionData != null) {
            this.insertIntoBuffer(connectionData.serializeConnectionData());
        } else {
            this.insertIntoBuffer(new byte[]{0, 0, 0, 0, 0, 0, 0});
        }
        this.insertIntoBuffer(new byte[]{(byte)RuntimeName.Jvm.ordinal(), (byte)rootCommand.getCommandType().ordinal()});
        this.serializeRecursively(rootCommand);
        return this.buffer;
    }

    private void serializeRecursively(Command command) {
        command.getPayload();
        for (Object item : command.getPayload()) {
            if (item instanceof Command) {
                Command innerCommand = (Command)item;
                this.insertIntoBuffer(TypeSerializer.serializeCommand(innerCommand));
                this.serializeRecursively(innerCommand);
                continue;
            }
            this.insertIntoBuffer(TypeSerializer.serializePrimitive(item));
        }
    }

    private void insertIntoBuffer(byte[] arg) {
        byte[] newBuffer = Arrays.copyOf(this.buffer, this.buffer.length + arg.length);
        System.arraycopy(arg, 0, newBuffer, this.buffer.length, arg.length);
        this.buffer = newBuffer;
    }
}

