#############################################################
# This file was automatically generated on 2022-05-11.      #
#                                                           #
# Perl Bindings Version 2.1.31                              #
#                                                           #
# If you have a bugfix for this file and want to commit it, #
# please fix the bug in the generator. You can find a link  #
# to the generators git repository on tinkerforge.com       #
#############################################################

=pod

=encoding utf8

=head1 NAME

Tinkerforge::BrickServo - Drives up to 7 RC Servos with up to 3A

=cut

package Tinkerforge::BrickServo;

use strict;
use warnings;
use Carp;
use threads;
use threads::shared;
use parent 'Tinkerforge::Device';
use Tinkerforge::IPConnection;
use Tinkerforge::Error;

=head1 CONSTANTS

=over

=item DEVICE_IDENTIFIER

This constant is used to identify a Servo Brick.

The get_identity() subroutine and the CALLBACK_ENUMERATE callback of the
IP Connection have a device_identifier parameter to specify the Brick's or
Bricklet's type.

=cut

use constant DEVICE_IDENTIFIER => 14;

=item DEVICE_DISPLAY_NAME

This constant represents the display name of a Servo Brick.

=cut

use constant DEVICE_DISPLAY_NAME => 'Servo Brick';

=item CALLBACK_UNDER_VOLTAGE

This constant is used with the register_callback() subroutine to specify
the CALLBACK_UNDER_VOLTAGE callback.

=cut

use constant CALLBACK_UNDER_VOLTAGE => 26;

=item CALLBACK_POSITION_REACHED

This constant is used with the register_callback() subroutine to specify
the CALLBACK_POSITION_REACHED callback.

=cut

use constant CALLBACK_POSITION_REACHED => 27;

=item CALLBACK_VELOCITY_REACHED

This constant is used with the register_callback() subroutine to specify
the CALLBACK_VELOCITY_REACHED callback.

=cut

use constant CALLBACK_VELOCITY_REACHED => 28;

=item FUNCTION_ENABLE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_ENABLE => 1;

=item FUNCTION_DISABLE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_DISABLE => 2;

=item FUNCTION_IS_ENABLED

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_IS_ENABLED => 3;

=item FUNCTION_SET_POSITION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_POSITION => 4;

=item FUNCTION_GET_POSITION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_POSITION => 5;

=item FUNCTION_GET_CURRENT_POSITION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_CURRENT_POSITION => 6;

=item FUNCTION_SET_VELOCITY

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_VELOCITY => 7;

=item FUNCTION_GET_VELOCITY

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_VELOCITY => 8;

=item FUNCTION_GET_CURRENT_VELOCITY

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_CURRENT_VELOCITY => 9;

=item FUNCTION_SET_ACCELERATION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_ACCELERATION => 10;

=item FUNCTION_GET_ACCELERATION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_ACCELERATION => 11;

=item FUNCTION_SET_OUTPUT_VOLTAGE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_OUTPUT_VOLTAGE => 12;

=item FUNCTION_GET_OUTPUT_VOLTAGE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_OUTPUT_VOLTAGE => 13;

=item FUNCTION_SET_PULSE_WIDTH

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_PULSE_WIDTH => 14;

=item FUNCTION_GET_PULSE_WIDTH

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_PULSE_WIDTH => 15;

=item FUNCTION_SET_DEGREE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_DEGREE => 16;

=item FUNCTION_GET_DEGREE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_DEGREE => 17;

=item FUNCTION_SET_PERIOD

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_PERIOD => 18;

=item FUNCTION_GET_PERIOD

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_PERIOD => 19;

=item FUNCTION_GET_SERVO_CURRENT

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_SERVO_CURRENT => 20;

=item FUNCTION_GET_OVERALL_CURRENT

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_OVERALL_CURRENT => 21;

=item FUNCTION_GET_STACK_INPUT_VOLTAGE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_STACK_INPUT_VOLTAGE => 22;

=item FUNCTION_GET_EXTERNAL_INPUT_VOLTAGE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_EXTERNAL_INPUT_VOLTAGE => 23;

=item FUNCTION_SET_MINIMUM_VOLTAGE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_MINIMUM_VOLTAGE => 24;

=item FUNCTION_GET_MINIMUM_VOLTAGE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_MINIMUM_VOLTAGE => 25;

=item FUNCTION_ENABLE_POSITION_REACHED_CALLBACK

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_ENABLE_POSITION_REACHED_CALLBACK => 29;

=item FUNCTION_DISABLE_POSITION_REACHED_CALLBACK

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_DISABLE_POSITION_REACHED_CALLBACK => 30;

=item FUNCTION_IS_POSITION_REACHED_CALLBACK_ENABLED

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_IS_POSITION_REACHED_CALLBACK_ENABLED => 31;

=item FUNCTION_ENABLE_VELOCITY_REACHED_CALLBACK

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_ENABLE_VELOCITY_REACHED_CALLBACK => 32;

=item FUNCTION_DISABLE_VELOCITY_REACHED_CALLBACK

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_DISABLE_VELOCITY_REACHED_CALLBACK => 33;

=item FUNCTION_IS_VELOCITY_REACHED_CALLBACK_ENABLED

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_IS_VELOCITY_REACHED_CALLBACK_ENABLED => 34;

=item FUNCTION_SET_SPITFP_BAUDRATE_CONFIG

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_SPITFP_BAUDRATE_CONFIG => 231;

=item FUNCTION_GET_SPITFP_BAUDRATE_CONFIG

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_SPITFP_BAUDRATE_CONFIG => 232;

=item FUNCTION_GET_SEND_TIMEOUT_COUNT

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_SEND_TIMEOUT_COUNT => 233;

=item FUNCTION_SET_SPITFP_BAUDRATE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_SPITFP_BAUDRATE => 234;

=item FUNCTION_GET_SPITFP_BAUDRATE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_SPITFP_BAUDRATE => 235;

=item FUNCTION_GET_SPITFP_ERROR_COUNT

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_SPITFP_ERROR_COUNT => 237;

=item FUNCTION_ENABLE_STATUS_LED

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_ENABLE_STATUS_LED => 238;

=item FUNCTION_DISABLE_STATUS_LED

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_DISABLE_STATUS_LED => 239;

=item FUNCTION_IS_STATUS_LED_ENABLED

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_IS_STATUS_LED_ENABLED => 240;

=item FUNCTION_GET_PROTOCOL1_BRICKLET_NAME

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_PROTOCOL1_BRICKLET_NAME => 241;

=item FUNCTION_GET_CHIP_TEMPERATURE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_CHIP_TEMPERATURE => 242;

=item FUNCTION_RESET

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_RESET => 243;

=item FUNCTION_WRITE_BRICKLET_PLUGIN

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_WRITE_BRICKLET_PLUGIN => 246;

=item FUNCTION_READ_BRICKLET_PLUGIN

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_READ_BRICKLET_PLUGIN => 247;

=item FUNCTION_GET_IDENTITY

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_IDENTITY => 255;
use constant COMMUNICATION_METHOD_NONE => 0;
use constant COMMUNICATION_METHOD_USB => 1;
use constant COMMUNICATION_METHOD_SPI_STACK => 2;
use constant COMMUNICATION_METHOD_CHIBI => 3;
use constant COMMUNICATION_METHOD_RS485 => 4;
use constant COMMUNICATION_METHOD_WIFI => 5;
use constant COMMUNICATION_METHOD_ETHERNET => 6;
use constant COMMUNICATION_METHOD_WIFI_V2 => 7;


=back

=head1 FUNCTIONS

=over

=item new()

Creates an object with the unique device ID *uid* and adds it to
the IP Connection *ipcon*.

=cut

sub new
{
	my ($class, $uid, $ipcon) = @_;

	my $self = Tinkerforge::Device->_new($uid, $ipcon, [2, 0, 4], &DEVICE_IDENTIFIER, &DEVICE_DISPLAY_NAME);

	$self->{response_expected}->{&FUNCTION_ENABLE} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_DISABLE} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_IS_ENABLED} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_POSITION} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_GET_POSITION} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_CURRENT_POSITION} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_VELOCITY} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_GET_VELOCITY} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_CURRENT_VELOCITY} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_ACCELERATION} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_GET_ACCELERATION} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_OUTPUT_VOLTAGE} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_GET_OUTPUT_VOLTAGE} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_PULSE_WIDTH} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_GET_PULSE_WIDTH} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_DEGREE} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_GET_DEGREE} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_PERIOD} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_GET_PERIOD} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_SERVO_CURRENT} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_OVERALL_CURRENT} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_STACK_INPUT_VOLTAGE} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_EXTERNAL_INPUT_VOLTAGE} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_MINIMUM_VOLTAGE} = Tinkerforge::Device->_RESPONSE_EXPECTED_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_MINIMUM_VOLTAGE} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_ENABLE_POSITION_REACHED_CALLBACK} = Tinkerforge::Device->_RESPONSE_EXPECTED_TRUE;
	$self->{response_expected}->{&FUNCTION_DISABLE_POSITION_REACHED_CALLBACK} = Tinkerforge::Device->_RESPONSE_EXPECTED_TRUE;
	$self->{response_expected}->{&FUNCTION_IS_POSITION_REACHED_CALLBACK_ENABLED} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_ENABLE_VELOCITY_REACHED_CALLBACK} = Tinkerforge::Device->_RESPONSE_EXPECTED_TRUE;
	$self->{response_expected}->{&FUNCTION_DISABLE_VELOCITY_REACHED_CALLBACK} = Tinkerforge::Device->_RESPONSE_EXPECTED_TRUE;
	$self->{response_expected}->{&FUNCTION_IS_VELOCITY_REACHED_CALLBACK_ENABLED} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_SPITFP_BAUDRATE_CONFIG} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_GET_SPITFP_BAUDRATE_CONFIG} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_SEND_TIMEOUT_COUNT} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_SPITFP_BAUDRATE} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_GET_SPITFP_BAUDRATE} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_SPITFP_ERROR_COUNT} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_ENABLE_STATUS_LED} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_DISABLE_STATUS_LED} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_IS_STATUS_LED_ENABLED} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_PROTOCOL1_BRICKLET_NAME} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_CHIP_TEMPERATURE} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_RESET} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_WRITE_BRICKLET_PLUGIN} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_READ_BRICKLET_PLUGIN} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_IDENTITY} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;

	$self->{callback_formats}->{&CALLBACK_UNDER_VOLTAGE} = shared_clone([10, 'S']);
	$self->{callback_formats}->{&CALLBACK_POSITION_REACHED} = shared_clone([11, 'C s']);
	$self->{callback_formats}->{&CALLBACK_VELOCITY_REACHED} = shared_clone([11, 'C s']);



	bless($self, $class);

	$ipcon->_add_device($self);

	return $self;
}


=item enable()

Enables a servo (0 to 6). If a servo is enabled, the configured position,
velocity, acceleration, etc. are applied immediately.

=cut

sub enable
{
	my ($self, $servo_num) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_ENABLE, [$servo_num], 'C', 0, '');
}

=item disable()

Disables a servo (0 to 6). Disabled servos are not driven at all, i.e. a
disabled servo will not hold its position if a load is applied.

=cut

sub disable
{
	my ($self, $servo_num) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_DISABLE, [$servo_num], 'C', 0, '');
}

=item is_enabled()

Returns *true* if the specified servo is enabled, *false* otherwise.

=cut

sub is_enabled
{
	my ($self, $servo_num) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_IS_ENABLED, [$servo_num], 'C', 9, '?');
}

=item set_position()

Sets the position for the specified servo.

The default range of the position is -9000 to 9000, but it can be specified
according to your servo with :func:`Set Degree`.

If you want to control a linear servo or RC brushless motor controller or
similar with the Servo Brick, you can also define lengths or speeds with
:func:`Set Degree`.

=cut

sub set_position
{
	my ($self, $servo_num, $position) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_SET_POSITION, [$servo_num, $position], 'C s', 0, '');
}

=item get_position()

Returns the position of the specified servo as set by :func:`Set Position`.

=cut

sub get_position
{
	my ($self, $servo_num) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_POSITION, [$servo_num], 'C', 10, 's');
}

=item get_current_position()

Returns the *current* position of the specified servo. This may not be the
value of :func:`Set Position` if the servo is currently approaching a
position goal.

=cut

sub get_current_position
{
	my ($self, $servo_num) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_CURRENT_POSITION, [$servo_num], 'C', 10, 's');
}

=item set_velocity()

Sets the maximum velocity of the specified servo. The velocity
is accelerated according to the value set by :func:`Set Acceleration`.

The minimum velocity is 0 (no movement) and the maximum velocity is 65535.
With a value of 65535 the position will be set immediately (no velocity).

=cut

sub set_velocity
{
	my ($self, $servo_num, $velocity) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_SET_VELOCITY, [$servo_num, $velocity], 'C S', 0, '');
}

=item get_velocity()

Returns the velocity of the specified servo as set by :func:`Set Velocity`.

=cut

sub get_velocity
{
	my ($self, $servo_num) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_VELOCITY, [$servo_num], 'C', 10, 'S');
}

=item get_current_velocity()

Returns the *current* velocity of the specified servo. This may not be the
value of :func:`Set Velocity` if the servo is currently approaching a
velocity goal.

=cut

sub get_current_velocity
{
	my ($self, $servo_num) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_CURRENT_VELOCITY, [$servo_num], 'C', 10, 'S');
}

=item set_acceleration()

Sets the acceleration of the specified servo.

The minimum acceleration is 1 and the maximum acceleration is 65535.
With a value of 65535 the velocity will be set immediately (no acceleration).

=cut

sub set_acceleration
{
	my ($self, $servo_num, $acceleration) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_SET_ACCELERATION, [$servo_num, $acceleration], 'C S', 0, '');
}

=item get_acceleration()

Returns the acceleration for the specified servo as set by
:func:`Set Acceleration`.

=cut

sub get_acceleration
{
	my ($self, $servo_num) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_ACCELERATION, [$servo_num], 'C', 10, 'S');
}

=item set_output_voltage()

Sets the output voltages with which the servos are driven.

.. note::
 We recommend that you set this value to the maximum voltage that is
 specified for your servo, most servos achieve their maximum force only
 with high voltages.

=cut

sub set_output_voltage
{
	my ($self, $voltage) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_SET_OUTPUT_VOLTAGE, [$voltage], 'S', 0, '');
}

=item get_output_voltage()

Returns the output voltage as specified by :func:`Set Output Voltage`.

=cut

sub get_output_voltage
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_OUTPUT_VOLTAGE, [], '', 10, 'S');
}

=item set_pulse_width()

Sets the minimum and maximum pulse width of the specified servo.

Usually, servos are controlled with a
`PWM <https://en.wikipedia.org/wiki/Pulse-width_modulation>`__, whereby the
length of the pulse controls the position of the servo. Every servo has
different minimum and maximum pulse widths, these can be specified with
this function.

If you have a datasheet for your servo that specifies the minimum and
maximum pulse width, you should set the values accordingly. If your servo
comes without any datasheet you have to find the values via trial and error.

The minimum must be smaller than the maximum.

=cut

sub set_pulse_width
{
	my ($self, $servo_num, $min, $max) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_SET_PULSE_WIDTH, [$servo_num, $min, $max], 'C S S', 0, '');
}

=item get_pulse_width()

Returns the minimum and maximum pulse width for the specified servo as set by
:func:`Set Pulse Width`.

=cut

sub get_pulse_width
{
	my ($self, $servo_num) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_PULSE_WIDTH, [$servo_num], 'C', 12, 'S S');
}

=item set_degree()

Sets the minimum and maximum degree for the specified servo (by default
given as °/100).

This only specifies the abstract values between which the minimum and maximum
pulse width is scaled. For example: If you specify a pulse width of 1000µs
to 2000µs and a degree range of -90° to 90°, a call of :func:`Set Position`
with 0 will result in a pulse width of 1500µs
(-90° = 1000µs, 90° = 2000µs, etc.).

Possible usage:

* The datasheet of your servo specifies a range of 200° with the middle position
  at 110°. In this case you can set the minimum to -9000 and the maximum to 11000.
* You measure a range of 220° on your servo and you don't have or need a middle
  position. In this case you can set the minimum to 0 and the maximum to 22000.
* You have a linear servo with a drive length of 20cm, In this case you could
  set the minimum to 0 and the maximum to 20000. Now you can set the Position
  with :func:`Set Position` with a resolution of cm/100. Also the velocity will
  have a resolution of cm/100s and the acceleration will have a resolution of
  cm/100s².
* You don't care about units and just want the highest possible resolution. In
  this case you should set the minimum to -32767 and the maximum to 32767.
* You have a brushless motor with a maximum speed of 10000 rpm and want to
  control it with a RC brushless motor controller. In this case you can set the
  minimum to 0 and the maximum to 10000. :func:`Set Position` now controls the rpm.

The minimum must be smaller than the maximum.

=cut

sub set_degree
{
	my ($self, $servo_num, $min, $max) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_SET_DEGREE, [$servo_num, $min, $max], 'C s s', 0, '');
}

=item get_degree()

Returns the minimum and maximum degree for the specified servo as set by
:func:`Set Degree`.

=cut

sub get_degree
{
	my ($self, $servo_num) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_DEGREE, [$servo_num], 'C', 12, 's s');
}

=item set_period()

Sets the period of the specified servo.

Usually, servos are controlled with a
`PWM <https://en.wikipedia.org/wiki/Pulse-width_modulation>`__. Different
servos expect PWMs with different periods. Most servos run well with a
period of about 20ms.

If your servo comes with a datasheet that specifies a period, you should
set it accordingly. If you don't have a datasheet and you have no idea
what the correct period is, the default value will most likely
work fine.

=cut

sub set_period
{
	my ($self, $servo_num, $period) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_SET_PERIOD, [$servo_num, $period], 'C S', 0, '');
}

=item get_period()

Returns the period for the specified servo as set by :func:`Set Period`.

=cut

sub get_period
{
	my ($self, $servo_num) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_PERIOD, [$servo_num], 'C', 10, 'S');
}

=item get_servo_current()

Returns the current consumption of the specified servo.

=cut

sub get_servo_current
{
	my ($self, $servo_num) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_SERVO_CURRENT, [$servo_num], 'C', 10, 'S');
}

=item get_overall_current()

Returns the current consumption of all servos together.

=cut

sub get_overall_current
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_OVERALL_CURRENT, [], '', 10, 'S');
}

=item get_stack_input_voltage()

Returns the stack input voltage. The stack input voltage is the
voltage that is supplied via the stack, i.e. it is given by a
Step-Down or Step-Up Power Supply.

=cut

sub get_stack_input_voltage
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_STACK_INPUT_VOLTAGE, [], '', 10, 'S');
}

=item get_external_input_voltage()

Returns the external input voltage. The external input voltage is
given via the black power input connector on the Servo Brick.

If there is an external input voltage and a stack input voltage, the motors
will be driven by the external input voltage. If there is only a stack
voltage present, the motors will be driven by this voltage.

.. warning::
 This means, if you have a high stack voltage and a low external voltage,
 the motors will be driven with the low external voltage. If you then remove
 the external connection, it will immediately be driven by the high
 stack voltage

=cut

sub get_external_input_voltage
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_EXTERNAL_INPUT_VOLTAGE, [], '', 10, 'S');
}

=item set_minimum_voltage()

Sets the minimum voltage, below which the :cb:`Under Voltage` callback
is triggered. The minimum possible value that works with the Servo Brick is 5V.
You can use this function to detect the discharge of a battery that is used
to drive the stepper motor. If you have a fixed power supply, you likely do
not need this functionality.

=cut

sub set_minimum_voltage
{
	my ($self, $voltage) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_SET_MINIMUM_VOLTAGE, [$voltage], 'S', 0, '');
}

=item get_minimum_voltage()

Returns the minimum voltage as set by :func:`Set Minimum Voltage`

=cut

sub get_minimum_voltage
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_MINIMUM_VOLTAGE, [], '', 10, 'S');
}

=item enable_position_reached_callback()

Enables the :cb:`Position Reached` callback.

Default is disabled.

.. versionadded:: 2.0.1$nbsp;(Firmware)

=cut

sub enable_position_reached_callback
{
	my ($self) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_ENABLE_POSITION_REACHED_CALLBACK, [], '', 0, '');
}

=item disable_position_reached_callback()

Disables the :cb:`Position Reached` callback.

.. versionadded:: 2.0.1$nbsp;(Firmware)

=cut

sub disable_position_reached_callback
{
	my ($self) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_DISABLE_POSITION_REACHED_CALLBACK, [], '', 0, '');
}

=item is_position_reached_callback_enabled()

Returns *true* if :cb:`Position Reached` callback is enabled, *false* otherwise.

.. versionadded:: 2.0.1$nbsp;(Firmware)

=cut

sub is_position_reached_callback_enabled
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_IS_POSITION_REACHED_CALLBACK_ENABLED, [], '', 9, '?');
}

=item enable_velocity_reached_callback()

Enables the :cb:`Velocity Reached` callback.

Default is disabled.

.. versionadded:: 2.0.1$nbsp;(Firmware)

=cut

sub enable_velocity_reached_callback
{
	my ($self) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_ENABLE_VELOCITY_REACHED_CALLBACK, [], '', 0, '');
}

=item disable_velocity_reached_callback()

Disables the :cb:`Velocity Reached` callback.

Default is disabled.

.. versionadded:: 2.0.1$nbsp;(Firmware)

=cut

sub disable_velocity_reached_callback
{
	my ($self) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_DISABLE_VELOCITY_REACHED_CALLBACK, [], '', 0, '');
}

=item is_velocity_reached_callback_enabled()

Returns *true* if :cb:`Velocity Reached` callback is enabled, *false* otherwise.

.. versionadded:: 2.0.1$nbsp;(Firmware)

=cut

sub is_velocity_reached_callback_enabled
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_IS_VELOCITY_REACHED_CALLBACK_ENABLED, [], '', 9, '?');
}

=item set_spitfp_baudrate_config()

The SPITF protocol can be used with a dynamic baudrate. If the dynamic baudrate is
enabled, the Brick will try to adapt the baudrate for the communication
between Bricks and Bricklets according to the amount of data that is transferred.

The baudrate will be increased exponentially if lots of data is sent/received and
decreased linearly if little data is sent/received.

This lowers the baudrate in applications where little data is transferred (e.g.
a weather station) and increases the robustness. If there is lots of data to transfer
(e.g. Thermal Imaging Bricklet) it automatically increases the baudrate as needed.

In cases where some data has to transferred as fast as possible every few seconds
(e.g. RS485 Bricklet with a high baudrate but small payload) you may want to turn
the dynamic baudrate off to get the highest possible performance.

The maximum value of the baudrate can be set per port with the function
:func:`Set SPITFP Baudrate`. If the dynamic baudrate is disabled, the baudrate
as set by :func:`Set SPITFP Baudrate` will be used statically.

.. versionadded:: 2.3.4$nbsp;(Firmware)

=cut

sub set_spitfp_baudrate_config
{
	my ($self, $enable_dynamic_baudrate, $minimum_dynamic_baudrate) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_SET_SPITFP_BAUDRATE_CONFIG, [$enable_dynamic_baudrate, $minimum_dynamic_baudrate], '? L', 0, '');
}

=item get_spitfp_baudrate_config()

Returns the baudrate config, see :func:`Set SPITFP Baudrate Config`.

.. versionadded:: 2.3.4$nbsp;(Firmware)

=cut

sub get_spitfp_baudrate_config
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_SPITFP_BAUDRATE_CONFIG, [], '', 13, '? L');
}

=item get_send_timeout_count()

Returns the timeout count for the different communication methods.

The methods 0-2 are available for all Bricks, 3-7 only for Master Bricks.

This function is mostly used for debugging during development, in normal operation
the counters should nearly always stay at 0.

.. versionadded:: 2.3.2$nbsp;(Firmware)

=cut

sub get_send_timeout_count
{
	my ($self, $communication_method) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_SEND_TIMEOUT_COUNT, [$communication_method], 'C', 12, 'L');
}

=item set_spitfp_baudrate()

Sets the baudrate for a specific Bricklet port.

If you want to increase the throughput of Bricklets you can increase
the baudrate. If you get a high error count because of high
interference (see :func:`Get SPITFP Error Count`) you can decrease the
baudrate.

If the dynamic baudrate feature is enabled, the baudrate set by this
function corresponds to the maximum baudrate (see :func:`Set SPITFP Baudrate Config`).

Regulatory testing is done with the default baudrate. If CE compatibility
or similar is necessary in your applications we recommend to not change
the baudrate.

.. versionadded:: 2.3.2$nbsp;(Firmware)

=cut

sub set_spitfp_baudrate
{
	my ($self, $bricklet_port, $baudrate) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_SET_SPITFP_BAUDRATE, [$bricklet_port, $baudrate], 'a L', 0, '');
}

=item get_spitfp_baudrate()

Returns the baudrate for a given Bricklet port, see :func:`Set SPITFP Baudrate`.

.. versionadded:: 2.3.2$nbsp;(Firmware)

=cut

sub get_spitfp_baudrate
{
	my ($self, $bricklet_port) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_SPITFP_BAUDRATE, [$bricklet_port], 'a', 12, 'L');
}

=item get_spitfp_error_count()

Returns the error count for the communication between Brick and Bricklet.

The errors are divided into

* ACK checksum errors,
* message checksum errors,
* framing errors and
* overflow errors.

The errors counts are for errors that occur on the Brick side. All
Bricklets have a similar function that returns the errors on the Bricklet side.

.. versionadded:: 2.3.2$nbsp;(Firmware)

=cut

sub get_spitfp_error_count
{
	my ($self, $bricklet_port) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_SPITFP_ERROR_COUNT, [$bricklet_port], 'a', 24, 'L L L L');
}

=item enable_status_led()

Enables the status LED.

The status LED is the blue LED next to the USB connector. If enabled is is
on and it flickers if data is transfered. If disabled it is always off.

The default state is enabled.

.. versionadded:: 2.3.1$nbsp;(Firmware)

=cut

sub enable_status_led
{
	my ($self) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_ENABLE_STATUS_LED, [], '', 0, '');
}

=item disable_status_led()

Disables the status LED.

The status LED is the blue LED next to the USB connector. If enabled is is
on and it flickers if data is transfered. If disabled it is always off.

The default state is enabled.

.. versionadded:: 2.3.1$nbsp;(Firmware)

=cut

sub disable_status_led
{
	my ($self) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_DISABLE_STATUS_LED, [], '', 0, '');
}

=item is_status_led_enabled()

Returns *true* if the status LED is enabled, *false* otherwise.

.. versionadded:: 2.3.1$nbsp;(Firmware)

=cut

sub is_status_led_enabled
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_IS_STATUS_LED_ENABLED, [], '', 9, '?');
}

=item get_protocol1_bricklet_name()

Returns the firmware and protocol version and the name of the Bricklet for a
given port.

This functions sole purpose is to allow automatic flashing of v1.x.y Bricklet
plugins.

=cut

sub get_protocol1_bricklet_name
{
	my ($self, $port) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_PROTOCOL1_BRICKLET_NAME, [$port], 'a', 52, 'C C3 Z40');
}

=item get_chip_temperature()

Returns the temperature as measured inside the microcontroller. The
value returned is not the ambient temperature!

The temperature is only proportional to the real temperature and it has an
accuracy of ±15%. Practically it is only useful as an indicator for
temperature changes.

=cut

sub get_chip_temperature
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_CHIP_TEMPERATURE, [], '', 10, 's');
}

=item reset()

Calling this function will reset the Brick. Calling this function
on a Brick inside of a stack will reset the whole stack.

After a reset you have to create new device objects,
calling functions on the existing ones will result in
undefined behavior!

=cut

sub reset
{
	my ($self) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_RESET, [], '', 0, '');
}

=item write_bricklet_plugin()

Writes 32 bytes of firmware to the bricklet attached at the given port.
The bytes are written to the position offset * 32.

This function is used by Brick Viewer during flashing. It should not be
necessary to call it in a normal user program.

=cut

sub write_bricklet_plugin
{
	my ($self, $port, $offset, $chunk) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_WRITE_BRICKLET_PLUGIN, [$port, $offset, $chunk], 'a C C32', 0, '');
}

=item read_bricklet_plugin()

Reads 32 bytes of firmware from the bricklet attached at the given port.
The bytes are read starting at the position offset * 32.

This function is used by Brick Viewer during flashing. It should not be
necessary to call it in a normal user program.

=cut

sub read_bricklet_plugin
{
	my ($self, $port, $offset) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_READ_BRICKLET_PLUGIN, [$port, $offset], 'a C', 40, 'C32');
}

=item get_identity()

Returns the UID, the UID where the Brick is connected to,
the position, the hardware and firmware version as well as the
device identifier.

The position is the position in the stack from '0' (bottom) to '8' (top).

The device identifier numbers can be found :ref:`here <device_identifier>`.
|device_identifier_constant|

=cut

sub get_identity
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_IDENTITY, [], '', 33, 'Z8 Z8 a C3 C3 S');
}

=back
=cut

1;
