package Mojolicious::Command::generate::controller;
# ABSTRACT: Mojolicious command generator for controllers
use Mojo::Base 'Mojolicious::Command';

# version
our $VERSION = '0.01';


use Mojolicious;
use Mojo::Util qw(class_to_path);

sub run {
  my ($self, $class, $actions) = (shift, shift, [@_]);
  
  # error - controller name undef
  die 'Controller class name cant be undef.' unless $class;
  
  # error - controller name malformed
  die 'Your controller name has to be a well formed (CamelCase) like "MyController".'
    unless $class =~ /^[A-Z](?:\w|::)+$/;

  # controller
  my $controller = "${class}";
  my $path       = class_to_path $controller;

  $self->render_to_rel_file('controller', "lib/$path", $controller, $actions);
}
 
1;

__DATA__

@@ controller
% my ($class, $actions) = @_;
package <%= $class %>;
use Mojo::Base 'Mojolicious::Controller';
 
% for my $a ( sort @$actions ){
# action for <%= $a %>
sub <%= $a %> {
  my $self = shift;
}

% }
 
1;
