(* Copyright (C) 1992, Digital Equipment Corporation                         *)
(* All rights reserved.                                                      *)
(* See the file COPYRIGHT for a full description.                            *)
(*                                                                           *)
(* Last modified on Sat Feb  6 18:05:27 PST 1993 by meehan     *)
(*      modified on Mon Feb  1 00:26:42 PST 1993 by mhb        *)
(*      modified on Tue Jun 16 13:08:30 PDT 1992 by muller     *)
(*      modified on Wed Mar 18 20:35:44 1992 by steveg     *)

MODULE PixmapVBT EXPORTS PixmapVBT;

IMPORT Axis, PaintOp, Pixmap, Point, Rect, Region, VBT;

REVEAL
  T = Public BRANDED OBJECT
        pm: Pixmap.T;
        op: PaintOp.T;
        bg: PaintOp.T;
      OVERRIDES
        init    := Init;
        shape   := Shape;
        repaint := Repaint;
      END;

PROCEDURE Init (v : T;
                pm: Pixmap.T;
                op: PaintOp.T  := PaintOp.BgFg;
                bg: PaintOp.T  := PaintOp.Bg    ): T =
  BEGIN
    v.pm := pm;
    v.op := op;
    v.bg := bg;
    RETURN v
  END Init;

PROCEDURE Put (v: T; pm: Pixmap.T) =
  VAR oldRect := VBT.PixmapDomain(v, v.pm);
  BEGIN
    v.pm := pm;
    IF NOT Rect.Equal(oldRect, VBT.PixmapDomain(v, pm)) THEN
      VBT.NewShape(v);
    END;
    VBT.Mark(v);
  END Put;

PROCEDURE SetColors (v: T; op: PaintOp.T; bg: PaintOp.T := PaintOp.Bg) = 
  BEGIN
    v.op := op;
    v.bg := bg;
    VBT.Mark(v);
  END SetColors;

PROCEDURE Repaint (v: T; READONLY rgn: Region.T) =
  VAR
    dom   : Rect.T;
    bounds: Rect.T;
    delta : Point.T;
    a     : Rect.Partition;
  BEGIN
    dom := VBT.Domain (v);
    bounds := VBT.PixmapDomain (v, v.pm);
    delta := Point.Sub (Rect.Middle (dom), Rect.Middle (bounds));
    Rect.Factor (
      Rect.Meet (dom, rgn.r), Rect.Move (bounds, delta), a, 0, 0);
    VBT.PaintPixmap (v, a [2], v.op, v.pm, delta);
    a [2] := Rect.Empty;
    VBT.PolyTexture (v, a, v.bg, Pixmap.Solid)
  END Repaint;

PROCEDURE Shape (v: T; ax: Axis.T; <* UNUSED *> n: CARDINAL): VBT.SizeRange =
  VAR sr: VBT.SizeRange;
  BEGIN
    sr.lo := Rect.Size(ax, VBT.PixmapDomain(v, v.pm));
    sr.pref := sr.lo;
    sr.hi := MAX(sr.pref + 1, VBT.DefaultShape.hi);
    RETURN sr;
  END Shape;

BEGIN
END PixmapVBT.
