(* Copyright (C) 1993, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)

MODULE SharedBoard;

IMPORT StableError, StableBoardX, Wr, Rd, Pickle, Thread, Atom, AtomList;

<*FATAL Thread.Alerted*>

PROCEDURE ReadCheckpoint (sb: T; rd: Rd.T): StableBoardX.T
  RAISES {StableError.E} =
  BEGIN
    TRY
      IF sb.getState(rd) # NIL THEN
        RETURN sb
      ELSE
        RAISE StableError.E(
            AtomList.List1(
              Atom.FromText(
                "Checkpoint does not contain data of the correct type")))
      END;
    EXCEPT
    | Rd.EndOfFile =>
        RAISE StableError.E(
            AtomList.List1(
              Atom.FromText(
                "unexpected EOF encountered reading checkpointfile")))
    | Rd.Failure (err) =>
        RAISE StableError.E(
                AtomList.Cons(
                  Atom.FromText(
                    "error writing checkpointfile"), err))
    | Pickle.Error (msg) =>
        RAISE StableError.E(
                AtomList.List1(
                  Atom.FromText(
                    "pickle-error (" & msg
                      & ") writing checkpointfile")))
    END
  END ReadCheckpoint;

PROCEDURE WriteCheckpoint (sb: T; wr: Wr.T)
  RAISES {StableError.E} =
  BEGIN
    TRY
      sb.putState(wr);
    EXCEPT
    | Wr.Failure (err) =>
        RAISE StableError.E(
                AtomList.Cons(
                  Atom.FromText(
                    "error writing checkpointfile"), err))
    | Pickle.Error (msg) =>
        RAISE StableError.E(
                AtomList.List1(
                  Atom.FromText(
                    "pickle-error (" & msg
                      & ") writing checkpointfile")))
    END
  END WriteCheckpoint;

BEGIN
END SharedBoard.
