(* Copyright (C) 1994, Digital Equipment Corporation                         *)
(* Digital Internal Use Only                                                 *)
(* All rights reserved.                                                      *)
(*                                                                           *)
(* Last modified on Mon Mar 13 11:59:57 PST 1995 by najork                   *)
(*       Created on Fri Jul 29 14:25:38 PDT 1994 by najork                   *)


MODULE ObAnim3D;


IMPORT Anim3D, ObAux, ObBuiltIn, ObCommand, ObLib, ObValue, RTCollector, 
       SynLocation;


TYPE
  (*** Hack for Lyle's video ***)
  Code = {lock, Collect};

  OpCode = ObLib.OpCode OBJECT
    code: Code;
  END;

  Package = ObLib.T OBJECT
  OVERRIDES
    Eval := DoEval;
  END;

CONST
  pkgname = "Anim3D";


PROCEDURE SetupPackage () =

  PROCEDURE NewOpCode (name: TEXT; arity: INTEGER; code: Code) : OpCode =
    BEGIN
      RETURN NEW (OpCode, name := name, arity := arity, code := code);
    END NewOpCode;

  TYPE 
    OpCodes = ARRAY OF ObLib.OpCode;
  VAR 
    opCodes: REF OpCodes;
  BEGIN
    opCodes := NEW (REF OpCodes, NUMBER (Code));
    opCodes^ := 
        OpCodes {
            NewOpCode ("lock",   -1, Code.lock),
           (*** Hack for Lyle's video ***)
            NewOpCode ("Collect", 0, Code.Collect)
        };

    ObLib.Register (NEW (Package, name := pkgname, opCodes := opCodes));
    ObLib.RegisterHelp (pkgname, Help);
  END SetupPackage;


PROCEDURE DoEval (<* UNUSED *> self         : Package; 
                               opCode       : ObLib.OpCode; 
                  <* UNUSED *> arity        : ObLib.OpArity; 
                  <* UNUSED *> READONLY args: ObValue.ArgArray; 
                  <* UNUSED *> temp         : BOOLEAN;
                  <* UNUSED *> loc          : SynLocation.T) : ObValue.Val =
  BEGIN
    CASE NARROW (opCode, OpCode).code OF
    | Code.lock =>
      RETURN NEW (ObBuiltIn.ValMutex, 
                  what  := "<a Thread.Mutex>", 
                  mutex := Anim3D.lock);
    (*** Hack for Lyle's video ***)
    | Code.Collect =>
      RTCollector.Enable();
      RTCollector.Collect();
      RTCollector.Collect();
      RTCollector.Disable();
      RETURN ObValue.valOk;
    END;
  END DoEval;


(*****************************************************************************)
(* Help                                                                      *)
(*****************************************************************************)


PROCEDURE Help (self : ObCommand.T; arg : TEXT; <* UNUSED *> data : REFANY) =
  BEGIN
    ObAux.Help (self, arg, pkgname);
  END Help;


BEGIN
END ObAnim3D.
