(* Copyright (C) 1992-1993, Digital Equipment Corporation       *)
(* All rights reserved.                                         *)
(* See the file COPYRIGHT for a full description.               *)
(*                                                              *)
(* Last modified on Thu Dec 31 00:35:14 PST 1992 by meehan      *)
<* PRAGMA LL *>

MODULE MForm;

IMPORT FormsVBT, Text, TextPort, VBT;

TYPE
  PublicButtonClosure =
    FormsVBT.Closure OBJECT
    METHODS
      init (model: TextPort.Model; setDefault := TRUE): ButtonClosure
    END;

REVEAL
  ButtonClosure = PublicButtonClosure BRANDED OBJECT
                    model     : TextPort.Model;
                    setDefault: BOOLEAN
                  OVERRIDES
                    init  := InitButtonClosure;
                    apply := DoButton
                  END;

PROCEDURE InitButtonClosure (cl        : ButtonClosure;
                             model     : TextPort.Model;
                             setDefault                   := TRUE):
  ButtonClosure =
  BEGIN
    cl.model := model;
    cl.setDefault := setDefault;
    RETURN cl
  END InitButtonClosure;

PROCEDURE DoButton (             cl  : ButtonClosure;
                    <* UNUSED *> fv  : FormsVBT.T;
                    <* UNUSED *> name: TEXT;
                    <* UNUSED *> time: VBT.TimeStamp  ) =
  BEGIN
    TextPort.ChangeAllTextPorts (cl.model);
    IF cl.setDefault THEN TextPort.DefaultModel := cl.model END
  END DoButton;

TYPE
  PublicRadioClosure =
    FormsVBT.Closure OBJECT
    METHODS
      init (READONLY map: Map; setDefault := TRUE): RadioClosure
    END;

REVEAL
  RadioClosure = PublicRadioClosure BRANDED OBJECT
                   map       : Map;
                   setDefault: BOOLEAN
                 OVERRIDES
                   init  := InitRadioClosure;
                   apply := DoRadio
                 END;

PROCEDURE InitRadioClosure (         cl        : RadioClosure;
                            READONLY map       : Map;
                                     setDefault                 := TRUE):
  RadioClosure =
  BEGIN
    cl.map := map;
    cl.setDefault := setDefault;
    RETURN cl
  END InitRadioClosure;

PROCEDURE DoRadio (             cl  : RadioClosure;
                                fv  : FormsVBT.T;
                                name: TEXT;
                   <* UNUSED *> time: VBT.TimeStamp ) =
  VAR choice: TEXT;
  BEGIN
    TRY
      choice := FormsVBT.GetChoice (fv, name)
    EXCEPT
    | FormsVBT.Error, FormsVBT.Unimplemented => RETURN
    END;
    FOR model := FIRST (TextPort.Model) TO LAST (TextPort.Model) DO
      IF cl.map [model] # NIL AND Text.Equal (cl.map [model], choice) THEN
        TextPort.ChangeAllTextPorts (model);
        IF cl.setDefault THEN TextPort.DefaultModel := model END;
        RETURN
      END
    END
  END DoRadio;



BEGIN END MForm.
