(* Copyright (C) 1992-1993, Digital Equipment Corporation       *)
(* All rights reserved.                                         *)
(* See the file COPYRIGHT for a full description.               *)
(*                                                              *)
(* Last modified on Thu Dec 31 00:28:54 PST 1992 by meehan      *)

INTERFACE MForm;

IMPORT FormsVBT, TextPort;

TYPE
  ButtonClosure <:
    FormsVBT.Closure OBJECT
    METHODS
      init (model: TextPort.Model; setDefault := TRUE): ButtonClosure
    END;

(* If a "ButtonClosure" is attached to a "FormsVBT" component, then the
   event-handler for that component will call
| TextPort.ChangeAllTextPorts (model)
   If "setDefault" is "TRUE", then the event-handler will also set
   "TextPort.DefaultModel" to "model".
*)

TYPE
  RadioClosure <: FormsVBT.Closure OBJECT
                  METHODS
                    init (READONLY map: Map; setDefault := TRUE): RadioClosure
                  END;
  Map = ARRAY TextPort.Model OF TEXT;

(* If a "RadioClosure" is attached to a "Radio"-component named {\it rn} of a
   form {\it fv}, then the event-handler for that component will look for a
   model "m" such that
| map[m] # NIL AND Text.Equal(map[m], FormsVBT.GetChoice(`fv`, `rn`))
   If there is such an "m", then the event-handler will call
| TextPort.ChangeAllTextPorts (m)
   If "setDefault" is "TRUE", then the event-handler will also set
   "TextPort.DefaultModel" to "model".
   This is intended to make it convenient to use a "Radio" component whose
   choices correspond to models.  Clients may wish to initialize such
   components by calling
| FormsVBT.PutChoice (`fv`, `rn`, map[TextPort,DefaultModel])
   *)

END MForm.
