(*
   XDR.i3
   Marshalling routines for SunRPC.
   David Nichols, Xerox PARC
   July, 1991

   $Id: XDR.i3,v 1.4 1992/03/31 01:21:26 nichols Exp $
 *)

(* Copyright (c) 1991, 1992 Xerox Corporation.  All rights reserved.

   Use and copying of this software and preparation of derivative works
   based upon this software are permitted.  Any distribution of this
   software or derivative works must comply with all applicable United
   States export control laws.  This software is made available AS IS, and
   Xerox Corporation makes no warranty about the software, its performance
   or its conformity to any specification. *)

INTERFACE XDR;

IMPORT ExceptionArg, FloatMode;
FROM Thread IMPORT Alerted;

EXCEPTION Failed(Failure);
TYPE
  Failure = ExceptionArg.T BRANDED OBJECT END;
  FloatConversionFailure = Failure BRANDED OBJECT
					     flag: FloatMode.Flag;
					   END;

(* Decoding routines. *)
PROCEDURE GetInteger (s: Source): INTEGER RAISES {Failed, Alerted};
PROCEDURE GetShort (s: Source): INTEGER RAISES {Failed, Alerted};
PROCEDURE GetChar (s: Source): CHAR RAISES {Failed, Alerted};
PROCEDURE GetBoolean (s: Source): BOOLEAN RAISES {Failed, Alerted};
PROCEDURE GetReal (s: Source): REAL RAISES {Failed, Alerted};
PROCEDURE GetLongReal (s: Source): LONGREAL RAISES {Failed, Alerted};
PROCEDURE GetText (s: Source): TEXT RAISES {Failed, Alerted};
PROCEDURE GetBytes (s: Source; VAR v: ARRAY OF CHAR)
  RAISES {Failed, Alerted};

(* Encoding routines. *)
PROCEDURE PutInteger (s: Sink; v: INTEGER) RAISES {Failed, Alerted};
PROCEDURE PutShort (s: Sink; v: INTEGER) RAISES {Failed, Alerted};
PROCEDURE PutChar (s: Sink; v: CHAR) RAISES {Failed, Alerted};
PROCEDURE PutBoolean (s: Sink; v: BOOLEAN) RAISES {Failed, Alerted};
PROCEDURE PutReal (s: Sink; v: REAL) RAISES {Failed, Alerted};
PROCEDURE PutLongReal (s: Sink; v: LONGREAL) RAISES {Failed, Alerted};
PROCEDURE PutText (s: Sink; v: TEXT) RAISES {Failed, Alerted};
PROCEDURE PutBytes (s: Sink; READONLY v: ARRAY OF CHAR)
  RAISES {Failed, Alerted};


(* To create Sink or Source, you must either get one from one of the
   specific interfaces (XDRMem, etc.) or you have to provide routines for
   buffering the data to and from the stream. *)
TYPE
  (* An object for decoding data from a source (e.g.  the network). *)
  Source = OBJECT
           METHODS
             GetLong  (): INTEGER RAISES {Failed, Alerted};
             GetBytes (VAR v: ARRAY OF CHAR) RAISES {Failed, Alerted};
           END;

  (* An object for encoding data to a sink. *)
  Sink = OBJECT
         METHODS
           PutLong  (v: INTEGER) RAISES {Failed, Alerted};
           PutBytes (READONLY v: ARRAY OF CHAR) RAISES {Failed, Alerted};
         END;

END XDR.
