(* Copyright (C) 1989, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* Last modified on Fri Feb  7 00:04:41 PST 1992 by muller         *)
(*      modified on Wed Nov  6 10:49:18 PST 1991 by kalsow         *)


UNSAFE MODULE Stdio;

IMPORT Rd, UnsafeRd, Wr, UnsafeWr, UFileRd, UFileWr, Thread, RTMisc;

PROCEDURE Close (<*UNUSED*> n: INTEGER := 0) 
  RAISES {Rd.Failure, Thread.Alerted, Wr.Failure} = 
  BEGIN
    UnsafeRd.FastClose (stdin);
    UnsafeWr.FastClose (stdout);
    UnsafeWr.FastClose (stderr);
 END Close;

<*FATAL Rd.Failure, Wr.Failure*>
BEGIN
  stdin  := UFileRd.New (fd := 0);
  stdout := UFileWr.New (fd := 1, buffered := TRUE);
  stderr := UFileWr.New (fd := 2, buffered := FALSE);
  bufferedStdout := UFileWr.New (fd := 1, buffered := TRUE);
  bufferedStderr := UFileWr.New (fd := 2, buffered := TRUE);
  EVAL RTMisc.RegisterExitor (Close);
END Stdio.
