(* Copyright (C) 1992, Digital Equipment Corporation                         *)
(* All rights reserved.                                                      *)
(* See the file COPYRIGHT for a full description.                            *)

(* Created by stolfi on Wed Oct 24  2:20:57 PDT 1990           *)
(* Last modified on Tue Feb 11 21:39:41 PST 1992 by muller     *)
(*      modified on Thu Oct 25  9:05:32 PDT 1990 by stolfi     *)

MODULE RGBDist;

IMPORT Intensity, RGB, LDW;

PROCEDURE Perceptual(READONLY a, b: RGB.T; lumWeight: REAL := 1.0): REAL =
  BEGIN
    RETURN LDW.Dist(
      LDW.LDWFromRGB (a), 
      LDW.LDWFromRGB (b), 
      lumWeight
    )
  END Perceptual;

PROCEDURE Quick(READONLY a, b: RGB.T; lumWeight: REAL := 1.0): REAL =
  VAR dr, dg, db: REAL;
  BEGIN
    IF a = RGB.Undefined OR b = RGB.Undefined THEN 
      RETURN Intensity.Undefined 
    END;
    dr := ABS(a[0] - b[0]);
    dg := ABS(a[1] - b[1]);
    db := ABS(a[2] - b[2]);
    RETURN
     ( dr + dg + db + MAX(MAX(dr, dg), db)
      + lumWeight*ABS(RGB.Brightness(a) - RGB.Brightness(b))
      ) / (4.0 + lumWeight);
  END Quick;

BEGIN
END RGBDist.

