(* Copyright (C) 1992, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* File: Value.i3                                              *)
(* Last modified on Mon Feb 10 15:10:29 PST 1992 by kalsow         *)
(*      modified on Fri Dec  7 05:12:46 1990 by muller         *)

INTERFACE Value;

IMPORT M3, Type, MBuf, String;

TYPE
  T = M3.Value;
  CheckState = M3.CheckState;

TYPE
  Class = {Expr, Var, Type, Exception, Procedure,
           Module, Field, Method, Formal, Error};

PROCEDURE TypeCheck (t: T;  VAR cs: CheckState);
PROCEDURE TypeOf    (t: T): Type.T;
PROCEDURE Load      (t: T): M3.Temp;
PROCEDURE Write     (t: T);

PROCEDURE Declare0 (t: T);
  (* generate the C declaration for t; initialize it to the user
     specified value if possible *)

PROCEDURE Declare1 (t: T);
  (* generate language required initialization for t if Declare0 did nothing *)

PROCEDURE Declare2 (t: T);
  (* generate the user specified initialization for t *)

PROCEDURE ClassOf          (t: T): Class;
PROCEDURE Fingerprint      (t: T;  map: Type.FPMap;  wr: MBuf.T);
PROCEDURE GenStorageClass  (t: T);
PROCEDURE IsExternal       (t: T): BOOLEAN;
PROCEDURE IsImported       (t: T): BOOLEAN;
PROCEDURE IsWritable       (t: T): BOOLEAN;
PROCEDURE ToExpr           (t: T): M3.Expr;
PROCEDURE ToType           (t: T): M3.Type;
PROCEDURE Base             (t: T): T;
PROCEDURE CName            (t: T): String.T;
PROCEDURE IllegalRecursion (t: T);

PROCEDURE Initialize ();
PROCEDURE Reset ();

END Value.
