(* Copyright (C) 1992, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* File: Loophole.m3                                           *)
(* Last Modified On Tue Jun 30 09:47:58 PDT 1992 By kalsow     *)
(*      Modified On Sat Dec  8 00:57:40 1990 By muller         *)

MODULE Loophole;

IMPORT CallExpr, Expr, Type, Procedure, CastExpr;
IMPORT Int, Module, TypeExpr, Error, Temp;

VAR Z: CallExpr.MethodList;

PROCEDURE TypeOf (<*UNUSED*> proc: Expr.T;  VAR args: Expr.List): Type.T =
  VAR t: Type.T;
  BEGIN
    IF NOT TypeExpr.Split (args[1], t) THEN t := Int.T END;
    RETURN t;
  END TypeOf;

PROCEDURE Check (<*UNUSED*> proc: Expr.T;  VAR args: Expr.List;  VAR cs: Expr.CheckState): Type.T =
  VAR t: Type.T;
  BEGIN
    IF NOT TypeExpr.Split (args[1], t) THEN
      Error.Msg ("LOOPHOLE: second argument must be a type");
      t := Int.T;
    END;
    args[0] := CastExpr.New (args[0], t, lvalue := TRUE);
    IF Module.IsSafe () THEN Error.Msg ("LOOPHOLE: unsafe operation") END;
    Expr.TypeCheck (args[0], cs);
    RETURN t;
  END Check;

PROCEDURE Compile (<*UNUSED*> proc: Expr.T; args: Expr.List): Temp.T =
  BEGIN
    RETURN Expr.Compile (args[0]);
  END Compile;

PROCEDURE IsWritable (<*UNUSED*> proc: Expr.T; args: Expr.List): BOOLEAN =
  BEGIN
    RETURN Expr.IsWritable (args[0]);
  END IsWritable;

PROCEDURE IsDesignator (<*UNUSED*> proc: Expr.T; args: Expr.List): BOOLEAN =
  BEGIN
    RETURN Expr.IsDesignator (args[0]);
  END IsDesignator;

PROCEDURE NoteWrites (<*UNUSED*> proc: Expr.T;  args: Expr.List) =
  BEGIN
    Expr.NoteWrite (args[0]);
  END NoteWrites;

PROCEDURE Initialize () =
  BEGIN
    Z := CallExpr.NewMethodList (2, 2, TRUE, FALSE, NIL,
                                 TypeOf, Check, Compile,
                                 CallExpr.NoValue, (*fold*)
                                 IsWritable, IsDesignator,
                                 NoteWrites);
    Procedure.Define ("LOOPHOLE", Z, TRUE);
  END Initialize;

BEGIN
END Loophole.
