(* Copyright (C) 1990, Digital Equipment Corporation.         *)
(* All rights reserved.                                       *)
(* See the file COPYRIGHT for a full description.             *)

(* Last modified on Sat Oct  6 02:01:36 1990 by muller        *)


INTERFACE SmallIO;

IMPORT Text;

CONST
  stdin = 0;
  stdout = 1;
  stderr = 2;

TYPE
  File = INTEGER;

PROCEDURE OpenRead (t: Text.T): File;
PROCEDURE OpenWrite (t: Text.T): File;
PROCEDURE Close (f: File);

PROCEDURE EOF (f: File): BOOLEAN;

PROCEDURE GetChar (f: File): CHAR;
PROCEDURE UnGetChar (f: File; c: CHAR);

PROCEDURE PutChar (f: File; c: CHAR);
PROCEDURE PutChars (f: File; c: UNTRACED REF CHAR; n: INTEGER);
PROCEDURE PutText (f: File; t: Text.T);
PROCEDURE PutInt (f: File; i: INTEGER);
PROCEDURE PutHexa (f: File; i: INTEGER);

PROCEDURE Flush (f: File);

END SmallIO.
