(* Copyright (C) 1992, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* File: Module.def                                            *)
(* Last modified on Mon Mar  2 10:16:15 PST 1992 by kalsow         *)
(*      modified on Sat Mar 16 01:55:39 1991 by muller         *)


INTERFACE Module;

IMPORT Value, Scope, String;

TYPE T <: Value.T;

PROCEDURE Parse (interfaceOnly : BOOLEAN := FALSE): T;

PROCEDURE NewDefn (name: TEXT;  safe: BOOLEAN): T;

PROCEDURE LookUp (name: String.T): T;

PROCEDURE ImportRevelations (t: T;  source: Value.T);

PROCEDURE TypeCheck (t: T;  main: BOOLEAN;  VAR cs: Value.CheckState);

PROCEDURE Compile (t: T);

PROCEDURE IsSafe (): BOOLEAN;
PROCEDURE IsInterface (): BOOLEAN;
PROCEDURE IsExternal (): BOOLEAN;

PROCEDURE ExportScope (t: T): Scope.T;

PROCEDURE CurrentName (): String.T;

PROCEDURE CurrentCounter (): ARRAY [0..4] OF CHAR;
PROCEDURE SetCurrentCounter (c: ARRAY [0..4] OF CHAR);

PROCEDURE Initialize ();
PROCEDURE Reset ();

VAR (*READONLY*) depth: INTEGER := 0; (* == 1 in main module *)

END Module.
