(* Copyright (C) 1992, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* File: ArrayType.i3                                          *)
(* Last Modified On Thu Feb 20 12:28:42 PST 1992 By kalsow         *)
(*      Modified On Sat Nov 10 01:11:37 1990 By muller         *)

INTERFACE ArrayType;

IMPORT Type, Token;

PROCEDURE Parse (READONLY fail: Token.Set): Type.T;

PROCEDURE New (index, element: Type.T): Type.T;

PROCEDURE Split (array: Type.T; VAR index, element: Type.T): BOOLEAN;
(* If 'array' is an array type, returns TRUE and sets index and element
   to the appropriate types.  Otherwise, returns FALSE *)

PROCEDURE OpenCousin (t: Type.T): Type.T;
(* If 't' is an 'ARRAY I OF X', returns 'ARRAY OF X', otherwise
   returns 't'. *)

END ArrayType.
