(* Copyright (C) 1992, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* File: OpenArrayExpr.i3                                      *)
(* Last Modified On Tue Nov 13 01:45:59 1990 By muller         *)
(*      Modified On Wed Jul 26 20:26:28 1989 By kalsow         *)

INTERFACE OpenArrayExpr;

IMPORT Type, Expr, AssignStmt, Temp;

TYPE P <: Expr.T;

PROCEDURE New (targetT: Type.T; sourceE: Expr.T; 
               kind := AssignStmt.Kind.assign): Expr.T;

PROCEDURE Is (t: Expr.T): BOOLEAN;

PROCEDURE CompileAssign (p: P; tRHS, tLHS: Temp.T);

END OpenArrayExpr.
