(* Copyright (C) 1989, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* Last modified on Sat Aug  3 00:42:22 1991 by kalsow         *)
(*      modified on Fri Aug 17 01:56:52 1990 by muller         *)

INTERFACE UFileRdWr;

IMPORT Rd, Wr;

(* Both routines try to create a well-adapted reader by looking at the
   kind of file they are connected to. They raise the appropriate Failure
   exception is something goes wrong (see IOFailure). *)

PROCEDURE CreateFileReader (fd: INTEGER): Rd.T RAISES {Rd.Failure};
(* create a reader connected to the opened Ultrix file descriptor fd *)

PROCEDURE CreateFileWriter (fd: INTEGER; buffered := FALSE): Wr.T
          RAISES {Wr.Failure};
(* create a writer connected to the opened Ultrix file descriptor fd.
   If buffered is TRUE, the writer is buffered regardless of the kind
   of Ultrix file (otherwise, terminal writers are not buffered). *)

END UFileRdWr.
