(* Test bitwise operators.  Depends on structures being compiled as separate
   units. *)

structure A =
   struct
     open Bits
     val a = 7
     val b = 12
     val cand1 = fn a => andb(a,255)
     val cand2 = fn a => andb(255,a)
     val cor1 = fn a => orb(a,1)
     val cor2 = fn a => orb(1,a)
     val clshift1 = fn a => lshift(a,1)
     val clshift2 = fn a => lshift(1,a)
     val crshift1 = fn a => rshift(a,1)
     val crshift2 = fn a => rshift(256,a)
     val cxorb1 = fn a => xorb(a,4)
     val cxorb2 = fn a => xorb(4,a)
    end

structure Test9 =
  struct
     val at = ref ""
     val fail = fn a => (at := a; ())
     open A
     val e = if andb(a,b)=4 then () else fail "e"
     val f = if orb(a,b)=15 then () else fail "f"
     val g = if lshift(b,2)=48 then () else fail "g"
     val h = if rshift(a,1)=3 then () else fail "h"
     val i = if andb(b,Bits.notb a)=8 then () else fail "i" 
     val j = if xorb(a,b)=11 then () else fail "j"
     val k = if cand1 15=15 then () else fail "k"
     val l = if cand2 15=15 then () else fail "l"
     val m = if cor1 2=3 then () else fail "m"
     val n = if cor2 2=3 then () else fail "n"
     val o' = if clshift1 1=2 then () else fail "o"
     val p = if clshift2 1=2 then () else fail "p"
     val q = if crshift1 4=2 then () else fail "q"
     val r = if crshift2 4=16 then () else fail "r"
     val s = if cxorb1 15=11 then () else fail "s"
     val t = if cxorb2 15=11 then () else fail "t"
     val _ = if !at<>"" then (print ("failed at "^ !at ^ "\n"); ()) else ()
   end
    

