(* Test integer arithmetic, input, output, and list operations *)

structure S =
struct
  val heap = let fun f (h::nil) = h
                    | f (h::t) = f t
                    | f nil = "bogus"
              in f(tl(System.argv()))
              end
 val _ = exportFn(heap,fn _ =>
 let
   val say = outputc std_out
   val prOp = fn (name,v:int) => say (name ^ " = "^ (makestring v) ^ "\n")
   val getInteger = fn () =>
	     (say "Please enter a number:";
	      flush_out std_out;
	      let val s = input_line std_in
	      in fold (fn (x,y) => (x-48)+10*y)
		      (map ord (tl (rev (explode s)))) 0
	      end)
   val n = getInteger()
   val m = getInteger()
   val _ = prOp("n" ,n)
   val _ = prOp("m", m)
   val _ = prOp ("n-1",n-1)
   val _ = prOp("1-n",1-n)
   val _ = prOp("1+n",1+n)
   val _ = prOp("9*n",9*n)
   val _ = prOp("10000/n",10000 div n)
   val _ = prOp ("n+1",n+1)
   val _ = prOp ("n*9",n*9)
   val _ = prOp ("n/2",n div 2)
   val _ = prOp ("n+m",n+m)
   val _ = prOp ("n-m",n-m)
   val _ = prOp ("n*m",n*m)
   val _ = prOp ("n/m",n div m)

   val dist = fn start => fn finish =>
     let fun loop i = if i <= finish then i :: loop (i+1) else nil
     in loop start
     end

   val sum = 
       let val longl = dist 0 10000
       in fold (op +) longl 0
       end handle Overflow => (print "sum\n"; 0)
			       

   val mult =
       let val longl = dist 50 51
       in fold (op * ) longl 1
       end handle Overflow => (print "mult\n"; 0)
			        

   val _ = prOp("sum 0 to 10000 = ",sum)
   val _ = prOp("mult 50 to 51 = ",mult)

   val sum2 = 
       let val longl = dist 100 10000
       in fold (op +) longl 1
       end
in ()
end)
end
