signature THREAD =
    sig
	val fork   : (unit -> unit) -> unit
	val exit   : unit -> 'a
	val yield  : unit -> unit

	type mutex
	val mutex       : unit -> mutex
	val try_acquire : mutex -> bool
	val acquire     : mutex -> unit
	val release     : mutex -> unit
	val with_mutex  : mutex -> (unit -> 'a) -> 'a

	type condition
	val condition   : unit -> condition
	val wait        : mutex -> condition -> unit
	val signal      : condition -> unit
	val broadcast   : condition -> unit
        val await       : mutex -> condition -> (unit -> bool) -> unit

	exception Undefined
	type 'a var
	val var : '1a -> '1a var
	val get : 'a var -> 'a
	val set : 'a var -> 'a -> unit
    end
