(* import "future"; *)

signature RADIX_ARG =
    sig
	val radix : int
	val maxDigits : int
	val concurrencyDepth : int
    end

signature SORT =
    sig
	val sort : int list -> int list
    end


functor RadixSort(structure Radix: RADIX_ARG
		  structure Future: FUTURE) : SORT =
    struct
        open Array List
        infix 9 sub

	fun fetchDigit d n =
	    let fun shift n 0 = n
		  | shift n x = shift (n div Radix.radix) (x - 1)
	    in
		(shift n d) mod Radix.radix
	    end

	val rad = Radix.radix - 1

	fun newBucket () = array (Radix.radix,nil)

	fun partition bit l =
	    let val bucket = newBucket ()
		val getDigit = fetchDigit bit
		fun part nil = bucket
		  | part (h::t) = 
		    let val b = getDigit h
			val blist = bucket sub b
		    in
			update(bucket,b,(h::blist));
			part t
		    end
	    in
		part l
	    end

	fun radixSort (digitNo, nil) = nil
	  | radixSort (digitNo, l as (_ :: nil)) = l
	  | radixSort (digitNo, l) =
	    if digitNo >= 0 then
		let val bucket = partition digitNo l
		    val nextDigit = digitNo - 1
		in
		    if ((digitNo - Radix.concurrencyDepth) >= 0) then
			let
			    fun subsort bucketPos =
				radixSort (nextDigit, (bucket sub bucketPos))
			    fun concat n =
				if (n = rad) then (subsort n)
				else (subsort n) @ (concat (n+1))
			in
			    concat 0
			end
		    else
			let
			    fun subsort bucketPos = 
				Future.future radixSort 
				(nextDigit, (bucket sub bucketPos))
			    fun futures n =
				if (n = rad) then [(subsort n)]
				else (subsort n) :: (futures (n+1))
			    fun concat nil = nil
			      | concat (h::t) = (Future.touch h) @ (concat t)
			in
			    concat (futures 0)
			end
		end
	    else
		l
    
	fun sort l = radixSort ((Radix.maxDigits-1), l)

    end
