(* import "thread.sig";
   import "future.sig";
*)

functor Future (Thread : THREAD) : FUTURE =
    struct
	local
	    open Thread

	    datatype 'a cell =
		BUSY
	      | DONE of 'a
	      | EXN of exn
	in
	    datatype 'a future =
		FUTURE of mutex * condition * 'a cell ref

	    fun future function arg =
		let val m = mutex ()
		    val c = condition ()
		    val f = ref BUSY
		    fun wrapper () =
			let val result = DONE (function arg)
			    handle exn => EXN exn
			in
			    with_mutex m (fn () =>
					  (f := result;
					   broadcast c))
			end
		in
		    fork wrapper;
		    FUTURE (m, c, f)
		end

	    fun touch (FUTURE (m, c, f)) =
		let fun touch' () =
		    case !f of
			BUSY => (wait m c; touch' ())
		      | DONE x => x
		      | EXN exn => raise exn
		in
		    with_mutex m touch'
		end
	end
    end
