(* Copyright (c) 1991 by Carnegie Mellon University *)

signature CPRINT =
  sig
    structure C : C
    val printProg : (string -> unit) * C.prog -> unit

    val startFile : (string -> unit) -> unit

    (* printDlist(name ,say,dlist): print an association list of string *
       entry point entries as a C integer arrays..  The data in the
       integer array is the machine representation of the ML datatype dlist,
       with the following types.

         type entryPoint = unit -> ?
         datatype dlist = DATALIST of string * entryPoint * dlist
	                | EMPTY

      We assume that EMPTY is represented as the integer 1 and DATALIST has 
      the tag 0.  The entry points actually point 8 bytes before the
      actual entry point.

      This list is used by the ML loader *)

    val printDlist : string * (string -> unit)  *
	                 {name : string,entry : string} list -> unit
end


